/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.ExprCompress;
import mosek.fusion.ExprPick;
import mosek.fusion.ExprReshape;
import mosek.fusion.ExprSlice;
import mosek.fusion.Expression;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.Set;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public abstract class BaseExpression
implements Expression {
    private WorkStack evaluated;
    private boolean has_evaluation;
    private Model owner;
    private int[] shape;

    public BaseExpression(Model model, int[] nArray) {
        this.shape = nArray;
        this.owner = model;
        this.has_evaluation = false;
        this.evaluated = null;
    }

    @Override
    public String toString() {
        return "Expression()";
    }

    protected void printStack(WorkStack workStack) {
        int[] nArray = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n = workStack.ptr_base;
        int n2 = workStack.nidxs_base;
        int n3 = workStack.cof_base;
        int n4 = workStack.shape_base;
        int n5 = workStack.codeptr_base;
        int n6 = workStack.code_base;
        int n7 = workStack.cconst_base;
        int n8 = workStack.sp_base;
        int n9 = workStack.nelem;
        int n10 = workStack.nnz;
        int n11 = workStack.ncodeatom;
        int n12 = workStack.nd;
        boolean bl = workStack.hassp;
    }

    @Override
    public void recursive_eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        if (bl) {
            if (this.has_evaluation) {
                this.evaluated.copy_expr(workStack);
            } else {
                this.eval(workStack, workStack2, workStack3, bl);
                this.evaluated = new WorkStack();
                if (this.compress_when_caching()) {
                    new ExprCompress(this).eval_continue(this.evaluated, workStack, workStack3);
                    this.evaluated.copy_expr(workStack);
                } else {
                    workStack.copy_expr(this.evaluated);
                }
                this.has_evaluation = true;
            }
        } else {
            this.eval(workStack, workStack2, workStack3, bl);
        }
    }

    @Override
    public boolean compress_when_caching() {
        return false;
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        this.recursive_eval(workStack, workStack2, workStack3, false);
    }

    @Override
    public abstract void eval(WorkStack var1, WorkStack var2, WorkStack var3, boolean var4);

    @Override
    public Expression pick(int[][] nArray) {
        return new ExprPick((Expression)this, nArray);
    }

    @Override
    public Expression pick(int[] nArray) {
        int[][] nArray2 = new int[nArray.length][1];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            nArray2[i][0] = nArray[i];
        }
        return new ExprPick((Expression)this, nArray2);
    }

    @Override
    public Expression index(int[] nArray) {
        int[][] nArray2 = new int[1][nArray.length];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            nArray2[0][i] = nArray[i];
        }
        return new ExprReshape(new int[0], new ExprPick((Expression)this, nArray2));
    }

    @Override
    public Expression index(int n) {
        int[][] nArray = new int[1][1];
        nArray[0][0] = n;
        return new ExprReshape(new int[0], new ExprPick((Expression)this, nArray));
    }

    @Override
    public Expression slice(int[] nArray, int[] nArray2) {
        return new ExprSlice(this, nArray, nArray2);
    }

    @Override
    public Expression slice(int n, int n2) {
        return new ExprSlice(this, new int[]{n}, new int[]{n2});
    }

    @Override
    public long getSize() {
        return Set.size(this.shape);
    }

    @Override
    public int getND() {
        return this.shape.length;
    }

    @Override
    public int getDim(int n) {
        return this.shape[n];
    }

    @Override
    public int[] getShape() {
        return Tools.arraycopy(this.shape);
    }

    @Override
    public Model getModel() {
        return this.owner;
    }

    protected static Model modelFrom(Expression[] expressionArray) {
        if (expressionArray.length == 0) {
            return null;
        }
        Model model = expressionArray[0].getModel();
        int n = 1;
        int n2 = expressionArray.length;
        for (int i = n; i < n2; ++i) {
            model = BaseExpression.modelFrom(model, expressionArray[i]);
        }
        return model;
    }

    protected static Model modelFrom(Model model, Expression expression) {
        return BaseExpression.modelFrom(model, expression.getModel());
    }

    protected static Model modelFrom(Expression expression, Expression expression2) {
        return BaseExpression.modelFrom(expression.getModel(), expression2.getModel());
    }

    protected static Model modelFrom(Model model, Model model2) {
        if (model == null) {
            return model2;
        }
        if (model2 != null && model != model2) {
            throw new ModelError("Mixing different models");
        }
        return model;
    }
}

