/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.LinkedInts;
import mosek.fusion.Utils.Tools;

public class LinkedBlocks {
    private int[] bfirst;
    private int[] bsize;
    private LinkedInts blocks;
    private LinkedInts ints;

    public LinkedBlocks() {
        this(0);
    }

    public LinkedBlocks(int n) {
        int n2 = 128;
        this.ints = new LinkedInts(n);
        this.blocks = new LinkedInts(n2);
        this.bsize = new int[n2];
        this.bfirst = new int[n2];
    }

    public LinkedBlocks(LinkedBlocks linkedBlocks) {
        this.ints = new LinkedInts(linkedBlocks.ints);
        this.blocks = new LinkedInts(linkedBlocks.blocks);
        this.bsize = Tools.arraycopy(linkedBlocks.bsize);
        this.bfirst = Tools.arraycopy(linkedBlocks.bfirst);
    }

    public void free(int n) {
        int n2 = this.bfirst[n];
        this.ints.free(n2, this.bsize[n]);
        this.bsize[n] = -1;
        this.bfirst[n] = -1;
        this.blocks.free(n, 1);
    }

    public int alloc(int n) {
        int n2 = n > 0 ? this.ints.alloc(n) : -1;
        int n3 = this.blocks.alloc();
        if (this.blocks.capacity() > this.bsize.length) {
            int[] nArray = new int[this.blocks.capacity()];
            int[] nArray2 = new int[this.blocks.capacity()];
            Tools.arraycopy(this.bsize, 0, nArray, 0, this.bsize.length);
            Tools.arraycopy(this.bfirst, 0, nArray2, 0, this.bfirst.length);
            this.bsize = nArray;
            this.bfirst = nArray2;
        }
        this.bfirst[n3] = n2;
        this.bsize[n3] = n;
        return n3;
    }

    public int maxidx(int n) {
        return this.ints.maxidx(this.bfirst[n], this.bsize[n]);
    }

    public int numallocated() {
        return this.ints.numallocated();
    }

    public void get(int n, int[] nArray, int n2) {
        this.ints.get(this.bfirst[n], this.bsize[n], nArray, n2);
    }

    public int numblocks() {
        return this.bsize.length;
    }

    public int blocksize(int n) {
        return this.bsize[n];
    }

    public int block_capacity() {
        return this.blocks.capacity();
    }

    public int capacity() {
        return this.ints.capacity();
    }

    public boolean validate() {
        return this.ints.validate() && this.blocks.validate();
    }
}

