/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.DeletionError;
import mosek.fusion.DimensionError;
import mosek.fusion.ExprFromVar;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.NilVariable;
import mosek.fusion.SliceError;
import mosek.fusion.SliceVariable;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;
import mosek.fusion.WorkStack;

public abstract class BaseVariable
implements Variable {
    private long[] sparsity;
    private long[] basevar_nativeidxs;
    private Model model;
    private int[] shape;

    protected BaseVariable(BaseVariable baseVariable, Model model) {
        this.model = model;
        this.shape = baseVariable.shape;
        this.sparsity = baseVariable.sparsity;
        this.basevar_nativeidxs = baseVariable.basevar_nativeidxs;
    }

    public BaseVariable(Model model, int[] nArray, long[] lArray, long[] lArray2) {
        this.model = model;
        this.shape = nArray;
        this.sparsity = lArray;
        this.basevar_nativeidxs = lArray2;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.a("Variable((");
        if (this.shape.length > 0) {
            stringBuffer.a(this.shape[0]);
            int n = 1;
            int n2 = this.shape.length;
            for (int i = n; i < n2; ++i) {
                stringBuffer.a(",").a(this.shape[i]);
            }
        }
        stringBuffer.a("))");
        return stringBuffer.toString();
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3 = n2 = this.basevar_nativeidxs.length;
        int n4 = this.shape.length;
        boolean bl2 = this.sparsity != null;
        workStack.alloc_expr(n4, n3, n2, bl2);
        int n5 = workStack.ptr_base;
        int n6 = workStack.nidxs_base;
        int n7 = workStack.sp_base;
        int n8 = workStack.cof_base;
        int n9 = workStack.shape_base;
        int[] nArray = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n10 = 0;
        int n11 = n4;
        for (n = n10; n < n11; ++n) {
            nArray[n9 + n] = this.shape[n];
        }
        n10 = 0;
        n11 = n2 + 1;
        for (n = n10; n < n11; ++n) {
            nArray[n5 + n] = n;
        }
        n10 = 0;
        n11 = n2;
        for (n = n10; n < n11; ++n) {
            lArray[n6 + n] = this.basevar_nativeidxs[n];
        }
        if (bl2) {
            n10 = 0;
            n11 = n2;
            for (n = n10; n < n11; ++n) {
                lArray[n7 + n] = this.sparsity[n];
            }
        }
        n10 = 0;
        n11 = n2;
        for (n = n10; n < n11; ++n) {
            dArray[n8 + n] = 1.0;
        }
    }

    @Override
    public boolean compress_when_caching() {
        return false;
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        this.recursive_eval(workStack, workStack2, workStack3, false);
    }

    @Override
    public void recursive_eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        this.eval(workStack, workStack2, workStack3, bl);
    }

    @Override
    public void remove() {
        throw new DeletionError("Only original variables can be removed");
    }

    public Variable fromTril(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (n < 0 || n >= this.shape.length) {
            throw new DimensionError("Invalid dimension");
        }
        if (this.shape[n] != n2 * (n2 + 1) / 2) {
            throw new DimensionError("Invalid shape for operation");
        }
        int n9 = 1;
        int n10 = 0;
        int n11 = n;
        for (n8 = n10; n8 < n11; ++n8) {
            n9 *= this.shape[n8];
        }
        n10 = this.shape[n];
        n11 = 1;
        n8 = n + 1;
        int n12 = this.shape.length;
        for (n7 = n8; n7 < n12; ++n7) {
            n11 *= this.shape[n7];
        }
        int[] nArray = new int[this.shape.length + 1];
        n12 = 0;
        n7 = n;
        for (n6 = n12; n6 < n7; ++n6) {
            nArray[n6] = this.shape[n6];
        }
        nArray[n] = n2;
        nArray[n + 1] = n2;
        n12 = n + 1;
        n7 = this.shape.length;
        for (n6 = n12; n6 < n7; ++n6) {
            nArray[n6 + 1] = this.shape[n6];
        }
        if (this.sparsity == null) {
            long[] lArray = new long[n9 * n2 * n2 * n11];
            n7 = 0;
            n6 = 0;
            int n13 = n9;
            for (int i = n6; i < n13; ++i) {
                int n14 = 0;
                int n15 = n2;
                for (int j = n14; j < n15; ++j) {
                    int n16 = 0;
                    int n17 = n2;
                    for (int k = n16; k < n17; ++k) {
                        int n18 = 0;
                        int n19 = n11;
                        for (int i2 = n18; i2 < n19; ++i2) {
                            lArray[n7] = j >= k ? this.basevar_nativeidxs[i * n10 * n11 + (j * (j + 1) / 2 + k) * n11 + i2] : this.basevar_nativeidxs[i * n10 * n11 + (k * (k + 1) / 2 + j) * n11 + i2];
                            ++n7;
                        }
                    }
                }
            }
            return new SliceVariable(this.getModel(), nArray, null, lArray);
        }
        n12 = 0;
        n7 = 0;
        n6 = this.sparsity.length;
        for (int i = n7; i < n6; ++i) {
            long l;
            long l2 = this.sparsity[i] / (long)n11 % (long)n10;
            n5 = (int)((-1.0 + Tools.sqrt((1L + 2L * l2) * (1L + 2L * l2))) / 4.0);
            if ((long)n5 == (l = this.sparsity[i] - (long)(n5 * (n5 + 1) / 2))) {
                ++n12;
                continue;
            }
            n12 += 2;
        }
        long[] lArray = new long[n12];
        long[] lArray2 = new long[n12];
        long[] lArray3 = new long[n12];
        int n20 = 0;
        int n21 = n12;
        for (n5 = n20; n5 < n21; ++n5) {
            lArray3[n5] = n5;
        }
        n20 = 0;
        n21 = 0;
        n5 = this.sparsity.length;
        for (n4 = n21; n4 < n5; ++n4) {
            long l;
            long l3 = this.sparsity[n4] / (long)(n10 * n11);
            long l4 = this.sparsity[n4] / (long)n11 % (long)n10;
            long l5 = this.sparsity[n4] % (long)n11;
            n3 = (int)((-1.0 + Tools.sqrt((1L + 2L * l4) * (1L + 2L * l4))) / 4.0);
            if ((long)n3 == (l = this.sparsity[n4] - (long)(n3 * (n3 + 1) / 2))) {
                lArray[n20] = this.basevar_nativeidxs[n4];
                lArray2[n20] = l3 * (long)n2 * (long)n2 * (long)n11 + ((long)(n3 * n2) + l) * (long)n11 + l5;
                ++n20;
                continue;
            }
            lArray[n20] = this.basevar_nativeidxs[n4];
            lArray[n20 + 1] = this.basevar_nativeidxs[n4];
            lArray2[n20] = l3 * (long)n2 * (long)n2 * (long)n11 + ((long)(n3 * n2) + l) * (long)n11 + l5;
            lArray2[n20 + 1] = l3 * (long)n2 * (long)n2 * (long)n11 + (l * (long)n2 + (long)n3) * (long)n11 + l5;
            n20 += 2;
        }
        CommonTools.argQsort(lArray3, lArray, null, 0L, (long)n12);
        n21 = 0;
        n5 = 0;
        n4 = n12;
        int n22 = n5 < n4 ? n4 - n5 : 0;
        long[] lArray4 = new long[n22];
        int n23 = n5;
        int n24 = 0;
        while (n24 < n22) {
            lArray4[n21] = lArray2[(int)lArray3[n23]];
            ++n21;
            ++n24;
            ++n23;
        }
        n24 = 0;
        int n25 = 0;
        int n26 = n12;
        n3 = n25 < n26 ? n26 - n25 : 0;
        long[] lArray5 = new long[n3];
        int n27 = n25;
        int n28 = 0;
        while (n28 < n3) {
            lArray5[n24] = lArray[(int)lArray3[n27]];
            ++n24;
            ++n28;
            ++n27;
        }
        return new SliceVariable(this.getModel(), nArray, lArray4, lArray5);
    }

    @Override
    public Variable fromTril(int n) {
        return this.fromTril(0, n);
    }

    public Variable tril(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n < 0 || n >= n2 || n2 >= this.shape.length) {
            throw new DimensionError("Invalid dimension specification");
        }
        if (this.shape[n] != this.shape[n2]) {
            throw new DimensionError("Operation only valid for square variables");
        }
        int[] nArray = new int[this.shape.length - 1];
        int n10 = 0;
        int n11 = n;
        for (n9 = n10; n9 < n11; ++n9) {
            nArray[n9] = this.shape[n9];
        }
        nArray[n] = this.shape[n] * (this.shape[n] + 1) / 2;
        n10 = n + 1;
        n11 = n2;
        for (n9 = n10; n9 < n11; ++n9) {
            nArray[n9] = this.shape[n9];
        }
        n10 = n2 + 1;
        n11 = this.shape.length;
        for (n9 = n10; n9 < n11; ++n9) {
            nArray[n9 - 1] = this.shape[n9];
        }
        if (this.sparsity == null) {
            int n12;
            int n13;
            int n14;
            n10 = 1;
            n11 = 0;
            n9 = n;
            for (n14 = n11; n14 < n9; ++n14) {
                n10 *= this.shape[n14];
            }
            n11 = this.shape[n];
            n9 = 1;
            n14 = n + 1;
            int n15 = n2;
            for (n13 = n14; n13 < n15; ++n13) {
                n9 *= this.shape[n13];
            }
            n14 = this.shape[n2];
            n15 = 1;
            n13 = n2 + 1;
            int n16 = this.shape.length;
            for (n12 = n13; n12 < n16; ++n12) {
                n15 *= this.shape[n12];
            }
            long[] lArray = new long[n10 * n9 * n15 * n11 * (n11 + 1) / 2];
            n16 = 0;
            n12 = 0;
            int n17 = n10;
            for (int i = n12; i < n17; ++i) {
                int n18 = 0;
                int n19 = n11;
                for (int j = n18; j < n19; ++j) {
                    int n20 = 0;
                    int n21 = j + 1;
                    for (int k = n20; k < n21; ++k) {
                        int n22 = 0;
                        int n23 = n9;
                        for (int i2 = n22; i2 < n23; ++i2) {
                            int n24 = 0;
                            int n25 = n15;
                            for (int i3 = n24; i3 < n25; ++i3) {
                                lArray[n16] = this.basevar_nativeidxs[i3 + n15 * (k + n14 * (i2 + n9 * (j + n11 * i)))];
                                ++n16;
                            }
                        }
                    }
                }
            }
            return new SliceVariable(this.getModel(), nArray, null, lArray);
        }
        n10 = 1;
        n11 = 0;
        n9 = n;
        for (n8 = n11; n8 < n9; ++n8) {
            n10 *= this.shape[n8];
        }
        n11 = this.shape[n];
        n9 = 1;
        n8 = n + 1;
        int n26 = n2;
        for (n7 = n8; n7 < n26; ++n7) {
            n9 *= this.shape[n7];
        }
        n8 = this.shape[n2];
        n26 = 1;
        n7 = n2 + 1;
        int n27 = this.shape.length;
        for (n6 = n7; n6 < n27; ++n6) {
            n26 *= this.shape[n6];
        }
        n7 = 1;
        n27 = n26;
        n6 = n27 * n8;
        int n28 = n6 * n9;
        int n29 = n28 * n11;
        int n30 = 0;
        int n31 = 0;
        int n32 = this.sparsity.length;
        for (n5 = n31; n5 < n32; ++n5) {
            if (this.sparsity[n5] / (long)n28 % (long)n11 < this.sparsity[n5] / (long)n27 % (long)n8) continue;
            ++n30;
        }
        n31 = 1;
        n32 = n26;
        n5 = n32 * n9;
        int n33 = n5 * n11 * (n11 + 1) / 2;
        long[] lArray = new long[n30];
        long[] lArray2 = new long[n30];
        long[] lArray3 = new long[n30];
        int n34 = 0;
        int n35 = 0;
        int n36 = this.sparsity.length;
        for (n4 = n35; n4 < n36; ++n4) {
            if (this.sparsity[n4] / (long)n28 % (long)n11 < this.sparsity[n4] / (long)n27 % (long)n8) continue;
            long l = this.sparsity[n4] / (long)n29;
            long l2 = this.sparsity[n4] / (long)n28 % (long)n11;
            long l3 = this.sparsity[n4] / (long)n6 % (long)n9;
            long l4 = this.sparsity[n4] / (long)n27 % (long)n8;
            long l5 = this.sparsity[n4] / (long)n7 % (long)n26;
            lArray2[n34] = this.basevar_nativeidxs[n4];
            lArray3[n34] = (long)n33 * l + (long)n5 * (l2 * (l2 + 1L) / 2L + l4) + (long)n32 * l3 + (long)n31 * l5;
            ++n34;
        }
        n35 = 0;
        n36 = n30;
        for (n4 = n35; n4 < n36; ++n4) {
            lArray[n4] = n4;
        }
        CommonTools.argQsort(lArray, lArray2, null, 0L, (long)n30);
        long[] lArray4 = new long[n30];
        long[] lArray5 = new long[n30];
        n4 = 0;
        int n37 = n30;
        for (n3 = n4; n3 < n37; ++n3) {
            lArray4[n3] = lArray2[(int)lArray[n3]];
        }
        n4 = 0;
        n37 = n30;
        for (n3 = n4; n3 < n37; ++n3) {
            lArray5[n3] = lArray3[(int)lArray[n3]];
        }
        return new SliceVariable(this.getModel(), nArray, lArray5, lArray4);
    }

    @Override
    public Variable tril() {
        return this.tril(0, 1);
    }

    @Override
    public Variable reshape(int n, int n2, int n3) {
        return this.reshape(new int[]{n, n2, n3});
    }

    @Override
    public Variable reshape(int n, int n2) {
        return this.reshape(new int[]{n, n2});
    }

    @Override
    public Variable reshape(int n) {
        return this.reshape(new int[]{n});
    }

    @Override
    public Variable reshape(int[] nArray) {
        int n;
        long l = 1L;
        int n2 = 0;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] < 0) {
                throw new DimensionError("Invalid shape");
            }
            l *= (long)nArray[n];
        }
        if (l != this.getSize()) {
            throw new LengthError("Shape size does not match variable size");
        }
        n2 = 0;
        n3 = 0;
        n = nArray.length;
        int n4 = n3 < n ? n - n3 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n3;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n2] = nArray[n5];
            ++n2;
            ++n6;
            ++n5;
        }
        return new SliceVariable(this.getModel(), nArray2, this.sparsity, this.basevar_nativeidxs);
    }

    @Override
    public void setLevel(double[] dArray) {
        if (this.sparsity == null) {
            if (dArray.length != this.basevar_nativeidxs.length) {
                throw new LengthError("Invalid length of solution values vector");
            }
            this.model.setVariableValues(true, this.basevar_nativeidxs, dArray);
        } else {
            if ((long)dArray.length != this.getSize()) {
                throw new LengthError("Invalid length of solution values vector");
            }
            int n = 0;
            int n2 = 0;
            int n3 = this.basevar_nativeidxs.length;
            int n4 = n2 < n3 ? n3 - n2 : 0;
            double[] dArray2 = new double[n4];
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                dArray2[n] = dArray[(int)this.sparsity[n5]];
                ++n;
                ++n6;
                ++n5;
            }
            double[] dArray3 = dArray2;
            this.model.setVariableValues(true, this.basevar_nativeidxs, dArray3);
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public int getND() {
        return this.shape.length;
    }

    @Override
    public int getDim(int n) {
        return this.shape[n];
    }

    @Override
    public int[] getShape() {
        return Tools.arraycopy(this.shape);
    }

    @Override
    public long getSize() {
        long l = 1L;
        int n = 0;
        int n2 = this.shape.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)this.shape[i];
        }
        return l;
    }

    @Override
    public double[] dual() throws SolutionError {
        double[] dArray = new double[this.basevar_nativeidxs.length];
        this.model.getVariableValues(false, this.basevar_nativeidxs, dArray, 0);
        if (this.sparsity != null) {
            double[] dArray2 = new double[(int)this.getSize()];
            int n = 0;
            int n2 = this.basevar_nativeidxs.length;
            for (int i = n; i < n2; ++i) {
                dArray2[(int)this.sparsity[i]] = dArray[i];
            }
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public double[] level() throws SolutionError {
        double[] dArray = new double[this.basevar_nativeidxs.length];
        this.model.getVariableValues(true, this.basevar_nativeidxs, dArray, 0);
        if (this.sparsity != null) {
            double[] dArray2 = new double[(int)this.getSize()];
            int n = 0;
            int n2 = this.basevar_nativeidxs.length;
            for (int i = n; i < n2; ++i) {
                dArray2[(int)this.sparsity[i]] = dArray[i];
            }
            dArray = dArray2;
        }
        return dArray;
    }

    @Override
    public void makeContinuous() {
        this.make_continuous();
    }

    @Override
    public void makeInteger() {
        this.make_integer();
    }

    @Override
    public Variable transpose() {
        long[] lArray;
        if (this.shape.length == 1) {
            return new SliceVariable(this.getModel(), new int[]{1, this.shape[0]}, this.sparsity, this.basevar_nativeidxs);
        }
        if (this.shape.length > 2) {
            throw new DimensionError("Invalid shape for operation");
        }
        long[] lArray2 = new long[this.basevar_nativeidxs.length];
        long[] lArray3 = lArray = this.sparsity == null ? null : new long[this.basevar_nativeidxs.length];
        if (this.sparsity == null) {
            int n = 0;
            int n2 = 0;
            int n3 = this.shape[1];
            for (int i = n2; i < n3; ++i) {
                int n4 = 0;
                int n5 = this.shape[0];
                for (int j = n4; j < n5; ++j) {
                    lArray2[n] = this.basevar_nativeidxs[j * this.shape[1] + i];
                    ++n;
                }
            }
        } else {
            int n;
            int[] nArray = new int[this.shape[1] + 1];
            int n6 = this.shape[0];
            int n7 = this.shape[1];
            int n8 = 0;
            int n9 = this.sparsity.length;
            for (n = n8; n < n9; ++n) {
                int n10 = (int)(this.sparsity[n] % (long)n7 + 1L);
                nArray[n10] = nArray[n10] + 1;
            }
            n8 = 0;
            n9 = n7;
            for (n = n8; n < n9; ++n) {
                int n11 = n + 1;
                nArray[n11] = nArray[n11] + nArray[n];
            }
            n8 = 0;
            n9 = this.sparsity.length;
            for (n = n8; n < n9; ++n) {
                long l = this.sparsity[n] % (long)n7;
                lArray2[nArray[(int)l]] = this.basevar_nativeidxs[n];
                lArray[nArray[(int)l]] = this.sparsity[n] / (long)n7 + this.sparsity[n] % (long)n7 * (long)n6;
                int n12 = (int)l;
                nArray[n12] = nArray[n12] + 1;
            }
        }
        return new SliceVariable(this.getModel(), new int[]{this.shape[1], this.shape[0]}, lArray, lArray2);
    }

    @Override
    public Variable index(int n, int n2, int n3) {
        return this.index(new int[]{n, n2, n3});
    }

    @Override
    public Variable index(int n, int n2) {
        return this.index(new int[]{n, n2});
    }

    @Override
    public Variable index(int[] nArray) {
        int[][] nArray2 = new int[1][nArray.length];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            nArray2[0][i] = nArray[i];
        }
        return this.pick(nArray2).reshape(new int[0]);
    }

    @Override
    public Variable index(int n) {
        return this.pick(new int[]{n}).reshape(new int[0]);
    }

    @Override
    public Variable pick(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.shape.length != 3) {
            throw new IndexError("Invalid index");
        }
        if (nArray.length != nArray2.length || nArray.length != nArray3.length) {
            throw new LengthError("Mismatching argument lengths");
        }
        int[][] nArray4 = new int[nArray.length][3];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            nArray4[i][0] = nArray[i];
            nArray4[i][1] = nArray2[i];
            nArray4[i][2] = nArray3[i];
        }
        return this.pick(nArray4);
    }

    @Override
    public Variable pick(int[] nArray, int[] nArray2) {
        if (this.shape.length != 2 || nArray.length != nArray2.length) {
            throw new IndexError("Invalid index");
        }
        int[][] nArray3 = new int[nArray.length][2];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            nArray3[i][0] = nArray[i];
            nArray3[i][1] = nArray2[i];
        }
        return this.pick(nArray3);
    }

    @Override
    public Variable pick(int[][] nArray) {
        long[] lArray;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.shape.length != nArray[0].length) {
            throw new IndexError("Invalid index");
        }
        boolean bl = false;
        int n5 = 0;
        int n6 = nArray.length;
        for (n4 = n5; n4 < n6; ++n4) {
            n3 = 0;
            n2 = nArray[0].length;
            for (n = n3; n < n2; ++n) {
                if (nArray[n4][n] >= 0 && nArray[n4][n] < this.shape[n]) continue;
                bl = true;
            }
        }
        if (bl) {
            throw new IndexError("Invalid index");
        }
        n5 = this.shape.length;
        long[] lArray2 = new long[n5];
        lArray2[n5 - 1] = 1L;
        n4 = 1;
        n3 = n5;
        for (n2 = n4; n2 < n3; ++n2) {
            lArray2[n5 - n2 - 1] = lArray2[n5 - n2] * (long)this.shape[n5 - n2];
        }
        int[] nArray2 = new int[]{nArray.length};
        long[] lArray3 = null;
        if (this.sparsity == null) {
            lArray = new long[nArray.length];
            n = 0;
            int n7 = nArray.length;
            for (int i = n; i < n7; ++i) {
                long l = 0L;
                int n8 = 0;
                int n9 = n5;
                for (int j = n8; j < n9; ++j) {
                    l += lArray2[j] * (long)nArray[i][j];
                }
                lArray[i] = this.basevar_nativeidxs[(int)l];
            }
        } else {
            int n10;
            int n11;
            int n12;
            n = 0;
            int n13 = 0;
            int n14 = nArray.length;
            for (n12 = n13; n12 < n14; ++n12) {
                long l = 0L;
                int n15 = 0;
                n11 = n5;
                for (n10 = n15; n10 < n11; ++n10) {
                    l += lArray2[n10] * (long)nArray[n12][n10];
                }
                if (CommonTools.binarySearch(this.sparsity, l) < 0) continue;
                ++n;
            }
            lArray = new long[n];
            lArray3 = new long[n];
            n13 = 0;
            n14 = 0;
            n12 = nArray.length;
            for (int i = n14; i < n12; ++i) {
                long l = 0L;
                n11 = 0;
                n10 = n5;
                for (int j = n11; j < n10; ++j) {
                    l += lArray2[j] * (long)nArray[i][j];
                }
                n11 = CommonTools.binarySearch(this.sparsity, l);
                if (n11 < 0) continue;
                lArray[n13] = this.basevar_nativeidxs[n11];
                lArray3[n13] = i;
                ++n13;
            }
            if (n == nArray.length) {
                lArray3 = null;
            }
        }
        return new SliceVariable(this.getModel(), nArray2, lArray3, lArray);
    }

    @Override
    public Variable pick(int[] nArray) {
        long[] lArray;
        int n;
        if (this.shape.length != 1) {
            throw new IndexError("Invalid index");
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.shape[0]) continue;
            bl = true;
        }
        if (bl) {
            throw new IndexError("Invalid index");
        }
        long[] lArray2 = null;
        if (this.sparsity == null) {
            n = 0;
            int n4 = 0;
            int n5 = nArray.length;
            int n6 = n4 < n5 ? n5 - n4 : 0;
            long[] lArray3 = new long[n6];
            int n7 = n4;
            int n8 = 0;
            while (n8 < n6) {
                lArray3[n] = this.basevar_nativeidxs[nArray[n7]];
                ++n;
                ++n8;
                ++n7;
            }
            lArray = lArray3;
        } else {
            int n9;
            n = 0;
            int n10 = 0;
            int n11 = nArray.length;
            for (n9 = n10; n9 < n11; ++n9) {
                if (CommonTools.binarySearch(this.sparsity, (long)nArray[n9]) < 0) continue;
                ++n;
            }
            lArray = new long[n];
            lArray2 = new long[n];
            n10 = 0;
            n11 = 0;
            n9 = nArray.length;
            for (int i = n11; i < n9; ++i) {
                int n12 = CommonTools.binarySearch(this.sparsity, (long)nArray[i]);
                if (n12 < 0) continue;
                lArray2[n10] = i;
                lArray[n10] = this.basevar_nativeidxs[n12];
                ++n10;
            }
            if (n == nArray.length) {
                lArray2 = null;
            }
        }
        return new SliceVariable(this.getModel(), new int[]{nArray.length}, lArray2, lArray);
    }

    @Override
    public Variable antidiag(int n) {
        if (this.shape.length != 2) {
            throw new DimensionError("antidiag() only works on two-dimensional objects");
        }
        if (n >= this.shape[1] || -n >= this.shape[2]) {
            throw new IndexError("Diagonal index out of bounds");
        }
        if (n >= 0) {
            return this.general_diag(new int[]{0, this.shape[1] - 1 - n}, new int[]{1, -1}, this.shape[0] < this.shape[1] - n ? this.shape[0] : this.shape[1] - n);
        }
        return this.general_diag(new int[]{-n, this.shape[1] - 1}, new int[]{1, -1}, this.shape[1] < this.shape[0] + n ? this.shape[1] : this.shape[0] + n);
    }

    @Override
    public Variable antidiag() {
        if (this.shape.length != 2) {
            throw new DimensionError("antidiag() only works on two-dimensional objects");
        }
        return this.general_diag(new int[]{0, this.shape[1] - 1}, new int[]{1, -1}, this.shape[0] < this.shape[1] ? this.shape[0] : this.shape[1]);
    }

    @Override
    public Variable diag(int n) {
        if (this.shape.length != 2) {
            throw new DimensionError("diag() only works on two-dimensional objects");
        }
        if (n >= this.shape[1] || -n >= this.shape[2]) {
            throw new IndexError("Diagonal index out of bounds");
        }
        if (n >= 0) {
            return this.general_diag(new int[]{0, n}, new int[]{1, 1}, this.shape[0] < this.shape[1] - n ? this.shape[0] : this.shape[1] - n);
        }
        return this.general_diag(new int[]{-n, 0}, new int[]{1, 1}, this.shape[1] < this.shape[0] + n ? this.shape[1] : this.shape[0] + n);
    }

    @Override
    public Variable diag() {
        if (this.shape.length != 2) {
            throw new DimensionError("diag() only works on two-dimensional objects");
        }
        return this.general_diag(new int[]{0, 0}, new int[]{1, 1}, this.shape[0] < this.shape[1] ? this.shape[0] : this.shape[1]);
    }

    private Variable general_diag(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.shape.length;
        if (n8 != nArray.length || n8 != nArray2.length) {
            throw new DimensionError("Invalid start or step definition");
        }
        int n9 = 0;
        int n10 = n8;
        for (n7 = n9; n7 < n10; ++n7) {
            if (nArray[n7] >= 0 && nArray[n7] < this.shape[n7]) continue;
            throw new LengthError("Start element is out of bounds");
        }
        long[] lArray = new long[n8];
        lArray[n8 - 1] = 1L;
        n10 = 1;
        n7 = n8;
        for (n6 = n10; n6 < n7; ++n6) {
            lArray[n8 - n6 - 1] = lArray[n8 - n6] * (long)this.shape[n8 - n6];
        }
        long l = 0L;
        n6 = 0;
        int n11 = nArray2.length;
        for (n5 = n6; n5 < n11; ++n5) {
            l += (long)nArray[n5] * lArray[n5];
        }
        long l2 = 0L;
        n5 = 0;
        int n12 = nArray2.length;
        for (n4 = n5; n4 < n12; ++n4) {
            l2 += (long)nArray2[n4] * lArray[n4];
        }
        if (this.sparsity == null) {
            long[] lArray2 = new long[n];
            n12 = 0;
            n4 = n;
            for (int i = n12; i < n4; ++i) {
                lArray2[i] = this.basevar_nativeidxs[(int)(l + l2 * (long)i)];
            }
            return new SliceVariable(this.getModel(), new int[]{n}, null, lArray2);
        }
        n5 = 0;
        n12 = 0;
        n4 = n;
        for (n3 = n12; n3 < n4; ++n3) {
            long l3 = l + l2 * (long)n3;
            n2 = CommonTools.binarySearch(this.sparsity, l3);
            if (n2 < 0) continue;
            ++n5;
        }
        long[] lArray3 = new long[n5];
        long[] lArray4 = new long[n5];
        n3 = 0;
        int n13 = 0;
        int n14 = n;
        for (n2 = n13; n2 < n14; ++n2) {
            lArray3[n2] = this.basevar_nativeidxs[(int)(l + l2 * (long)n2)];
            long l4 = l + l2 * (long)n2;
            int n15 = CommonTools.binarySearch(this.sparsity, l4);
            if (n15 < 0) continue;
            lArray4[n3] = n2;
            lArray3[n3] = this.basevar_nativeidxs[n15];
            ++n3;
        }
        return new SliceVariable(this.getModel(), new int[]{n}, lArray4, lArray3);
    }

    @Override
    public Variable slice(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (nArray.length != nArray2.length) {
            throw new SliceError("Invalid slice");
        }
        if (nArray.length != this.shape.length) {
            throw new DimensionError("Variable shape and slice do not match");
        }
        int n5 = 0;
        int n6 = this.shape.length;
        for (n4 = n5; n4 < n6; ++n4) {
            if (nArray[n4] < 0 || nArray2[n4] > this.shape[n4]) {
                throw new IndexError("Slice is out of bounds");
            }
            if (nArray[n4] <= nArray2[n4]) continue;
            throw new SliceError("Invalid slice");
        }
        n5 = this.shape.length;
        n6 = 0;
        n4 = 0;
        int n7 = n5;
        int n8 = n4 < n7 ? n7 - n4 : 0;
        int[] nArray3 = new int[n8];
        int n9 = n4;
        int n10 = 0;
        while (n10 < n8) {
            nArray3[n6] = nArray2[n9] - nArray[n9];
            ++n6;
            ++n10;
            ++n9;
        }
        int[] nArray4 = nArray3;
        int n11 = 1;
        int n12 = 0;
        int n13 = n5;
        for (n3 = n12; n3 < n13; ++n3) {
            n11 *= nArray2[n3] - nArray[n3];
        }
        if (n11 == 0) {
            return new NilVariable();
        }
        if (this.sparsity != null) {
            int n14;
            n12 = 0;
            int[] nArray5 = new int[n5];
            n3 = 0;
            int n15 = this.sparsity.length;
            for (int i = n3; i < n15; ++i) {
                long l = this.sparsity[i];
                n14 = 1;
                int n16 = n5;
                for (int j = n14; j < n16; ++j) {
                    nArray5[n5 - j] = (int)(l % (long)this.shape[n5 - j]);
                    l /= (long)this.shape[n5 - j];
                }
                nArray5[0] = (int)l;
                n14 = 0;
                while (nArray5[n14] >= nArray[n14] && nArray5[n14] < nArray2[n14]) {
                    ++n14;
                }
                if (n14 != n5) continue;
                ++n12;
            }
            n3 = 0;
            long[] lArray = new long[n12];
            long[] lArray2 = new long[n12];
            int n17 = 0;
            int n18 = this.sparsity.length;
            for (n14 = n17; n14 < n18; ++n14) {
                int n19;
                long l = this.sparsity[n14];
                int n20 = 1;
                int n21 = n5;
                for (n19 = n20; n19 < n21; ++n19) {
                    nArray5[n5 - n19] = (int)(l % (long)this.shape[n5 - n19]);
                    l /= (long)this.shape[n5 - n19];
                }
                nArray5[0] = (int)l;
                n20 = 0;
                while (nArray5[n20] >= nArray[n20] && nArray5[n20] < nArray2[n20]) {
                    ++n20;
                }
                if (n20 != n5) continue;
                lArray[n3] = this.basevar_nativeidxs[n14];
                n21 = 0;
                n19 = 0;
                int n22 = n5;
                for (int i = n19; i < n22; ++i) {
                    n21 = n21 * nArray4[i] + (nArray5[i] - nArray[i]);
                }
                lArray2[n3] = n21;
                ++n3;
            }
            return new SliceVariable(this.getModel(), nArray4, lArray2, lArray);
        }
        long[] lArray = new long[n11];
        int[] nArray6 = new int[n5];
        nArray6[n5 - 1] = 1;
        n3 = 1;
        int n23 = n5;
        for (n2 = n3; n2 < n23; ++n2) {
            nArray6[n5 - n2 - 1] = nArray6[n5 - n2] * this.shape[n5 - n2];
        }
        n3 = 0;
        n23 = 0;
        n2 = n5;
        for (n = n23; n < n2; ++n) {
            n3 += nArray[n] * nArray6[n];
        }
        n23 = 0;
        n2 = 0;
        n = n5;
        int n24 = n2 < n ? n - n2 : 0;
        int[] nArray7 = new int[n24];
        int n25 = n2;
        int n26 = 0;
        while (n26 < n24) {
            nArray7[n23] = n3;
            ++n23;
            ++n26;
            ++n25;
        }
        int[] nArray8 = nArray7;
        int n27 = 0;
        int n28 = 0;
        int n29 = n5;
        int n30 = n28 < n29 ? n29 - n28 : 0;
        int[] nArray9 = new int[n30];
        int n31 = n28;
        int n32 = 0;
        while (n32 < n30) {
            nArray9[n27] = nArray[n31];
            ++n27;
            ++n32;
            ++n31;
        }
        int[] nArray10 = nArray9;
        int n33 = 0;
        int n34 = n11;
        for (int i = n33; i < n34; ++i) {
            int n35;
            lArray[i] = this.basevar_nativeidxs[nArray8[n5 - 1]];
            int n36 = n5 - 1;
            nArray10[n36] = nArray10[n36] + 1;
            int n37 = n5 - 1;
            nArray8[n37] = nArray8[n37] + nArray6[n5 - 1];
            if (nArray10[n5 - 1] < nArray2[n5 - 1]) continue;
            for (n35 = n5 - 1; n35 > 0 && nArray10[n35] >= nArray2[n35]; --n35) {
                nArray10[n35] = nArray[n35];
                int n38 = n35 - 1;
                nArray10[n38] = nArray10[n38] + 1;
                int n39 = n35 - 1;
                nArray8[n39] = nArray8[n39] + nArray6[n35 - 1];
            }
            int n40 = n35 + 1;
            int n41 = n5;
            for (int j = n40; j < n41; ++j) {
                nArray8[j] = nArray8[n35];
            }
        }
        return new SliceVariable(this.getModel(), nArray4, null, lArray);
    }

    @Override
    public Variable slice(int n, int n2) {
        if (this.shape.length != 1) {
            throw new DimensionError("Variable shape and slice do not match");
        }
        if (n == 0 && n2 == this.shape[0]) {
            return this;
        }
        if (n < 0 || n2 > this.shape[0]) {
            throw new IndexError("Slice is out of bounds");
        }
        if (n > n2) {
            throw new SliceError("Invalid slice");
        }
        if (n == n2) {
            return new NilVariable();
        }
        if (this.sparsity != null) {
            int n3 = n2 - n;
            boolean bl = false;
            int n4 = CommonTools.binarySearchL(this.sparsity, n);
            int n5 = CommonTools.binarySearchL(this.sparsity, n2);
            int n6 = 0;
            int n7 = n4;
            int n8 = n5;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            long[] lArray = new long[n9];
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                lArray[n6] = this.sparsity[n10] - (long)n;
                ++n6;
                ++n11;
                ++n10;
            }
            n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n12 < n13 ? n13 - n12 : 0;
            long[] lArray2 = new long[n14];
            int n15 = n12;
            int n16 = 0;
            while (n16 < n14) {
                lArray2[n11] = this.basevar_nativeidxs[n15];
                ++n11;
                ++n16;
                ++n15;
            }
            return new SliceVariable(this.getModel(), new int[]{n3}, lArray, lArray2);
        }
        int n17 = n2 - n;
        long[] lArray = new long[n17];
        Tools.arraycopy(this.basevar_nativeidxs, n, lArray, 0, n17);
        return new SliceVariable(this.getModel(), new int[]{n17}, null, lArray);
    }

    @Override
    public Expression asExpr() {
        return new ExprFromVar(this);
    }

    @Override
    public int inst(int n, long[] lArray, int n2, long[] lArray2) {
        long[] lArray3 = this.basevar_nativeidxs;
        long[] lArray4 = this.sparsity;
        if (lArray4 == null) {
            int n3 = 0;
            int n4 = lArray3.length;
            for (int i = n3; i < n4; ++i) {
                lArray[i + n] = i;
                lArray2[i + n2] = lArray3[i];
            }
        } else {
            int n5 = 0;
            int n6 = this.sparsity.length;
            for (int i = n5; i < n6; ++i) {
                lArray[n + i] = lArray4[i];
                lArray2[i + n2] = lArray3[i];
            }
        }
        return this.basevar_nativeidxs.length;
    }

    @Override
    public int numInst() {
        return this.basevar_nativeidxs.length;
    }

    @Override
    public void inst(int n, long[] lArray) {
        if (this.sparsity == null) {
            int n2 = 0;
            int n3 = this.basevar_nativeidxs.length;
            for (int i = n2; i < n3; ++i) {
                lArray[n + i] = this.basevar_nativeidxs[i];
            }
        } else {
            int n4;
            int[] nArray = this.getShape();
            int n5 = 1;
            int n6 = 0;
            int n7 = nArray.length;
            for (n4 = n6; n4 < n7; ++n4) {
                n5 *= nArray[n4];
            }
            n6 = 0;
            n7 = n5;
            for (n4 = n6; n4 < n7; ++n4) {
                lArray[n + n4] = 0L;
            }
            n6 = 0;
            n7 = this.sparsity.length;
            for (n4 = n6; n4 < n7; ++n4) {
                lArray[(int)((long)n + this.sparsity[n4])] = this.basevar_nativeidxs[n4];
            }
        }
    }

    @Override
    public void set_values(double[] dArray, boolean bl) {
        if (this.sparsity == null) {
            this.getModel().setVariableValues(bl, this.basevar_nativeidxs, dArray);
        } else {
            int n;
            int n2 = 1;
            int n3 = 0;
            int n4 = this.shape.length;
            for (n = n3; n < n4; ++n) {
                n2 *= this.shape[n];
            }
            long[] lArray = new long[n2];
            n4 = 0;
            n = this.basevar_nativeidxs.length;
            for (int i = n4; i < n; ++i) {
                lArray[(int)this.sparsity[i]] = this.basevar_nativeidxs[i];
            }
            this.getModel().setVariableValues(bl, lArray, dArray);
        }
    }

    protected void dual_lu(int n, double[] dArray, boolean bl) throws SolutionError {
        if (this.sparsity == null) {
            this.model.getVariableDuals(bl, this.basevar_nativeidxs, dArray, n);
        } else {
            long[] lArray = new long[(int)this.getSize()];
            int n2 = 0;
            int n3 = this.sparsity.length;
            for (int i = n2; i < n3; ++i) {
                lArray[(int)this.sparsity[i]] = this.basevar_nativeidxs[i];
            }
            this.model.getVariableDuals(bl, lArray, dArray, n);
        }
    }

    @Override
    public void values(int n, double[] dArray, boolean bl) throws SolutionError {
        if (this.sparsity == null) {
            this.model.getVariableValues(bl, this.basevar_nativeidxs, dArray, n);
        } else {
            long[] lArray = new long[(int)this.getSize()];
            int n2 = 0;
            int n3 = this.sparsity.length;
            for (int i = n2; i < n3; ++i) {
                lArray[(int)this.sparsity[i]] = this.basevar_nativeidxs[i];
            }
            this.model.getVariableValues(bl, lArray, dArray, n);
        }
    }

    @Override
    public void make_continuous() {
        this.getModel().make_continuous(this.basevar_nativeidxs);
    }

    @Override
    public void make_integer() {
        this.getModel().make_integer(this.basevar_nativeidxs);
    }
}

