/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.Tools;

public class LinkedInts {
    private int nfree;
    private int last_free;
    private int first_free;
    private int first_used;
    private int[] prev;
    private int[] next;

    public LinkedInts(int n) {
        int n2 = n > 0 ? n : 128;
        this.next = new int[n2];
        this.prev = new int[n2];
        this.first_used = -1;
        this.first_free = 0;
        this.last_free = n2 - 1;
        int n3 = 1;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            this.prev[i] = i - 1;
            this.next[i - 1] = i;
        }
        this.prev[0] = -1;
        this.next[n2 - 1] = -1;
        this.nfree = n2;
    }

    public LinkedInts() {
        this(128);
    }

    public LinkedInts(LinkedInts linkedInts) {
        this.next = Tools.arraycopy(linkedInts.next);
        this.prev = Tools.arraycopy(linkedInts.prev);
        this.first_used = linkedInts.first_used;
        this.first_free = linkedInts.first_free;
        this.last_free = linkedInts.last_free;
        this.nfree = linkedInts.nfree;
    }

    public void free(int n, int n2) {
        int n3;
        int n4 = n3 = n;
        int n5 = 0;
        int n6 = n2 - 1;
        for (int i = n5; i < n6; ++i) {
            n4 = this.next[n4];
        }
        n5 = this.prev[n3];
        n6 = this.next[n4];
        if (n5 >= 0) {
            this.next[n5] = n6;
        } else {
            this.first_used = n6;
        }
        if (n6 >= 0) {
            this.prev[n6] = n5;
        }
        this.prev[n3] = -1;
        this.next[n4] = this.first_free;
        if (this.first_free >= 0) {
            this.prev[this.first_free] = n4;
        }
        this.first_free = n3;
        if (this.last_free < 0) {
            this.last_free = n4;
        }
        this.nfree += n2;
    }

    public int alloc() {
        return this.allocblock(1);
    }

    public int alloc(int n) {
        return this.allocblock(n);
    }

    public void alloc(int n, int[] nArray, int n2) {
        int n3 = this.allocblock(n);
        int n4 = 0;
        int n5 = n;
        for (int i = n4; i < n5; ++i) {
            nArray[i + n2] = n3;
            n3 = this.next[n3];
        }
    }

    public void get(int n, int n2, int[] nArray, int n3) {
        int n4 = n;
        int n5 = 0;
        int n6 = n2;
        for (int i = n5; i < n6; ++i) {
            nArray[i + n3] = n4;
            n4 = this.next[n4];
        }
    }

    public int numallocated() {
        return this.next.length - this.nfree;
    }

    public int maxidx(int n, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = 1;
        int n6 = n2;
        for (int i = n5; i < n6; ++i) {
            if (n3 >= (n4 = this.next[n4])) continue;
            n3 = n4;
        }
        return n3;
    }

    private int allocblock(int n) {
        int n2;
        int n3 = this.next.length;
        if (this.nfree < n) {
            n2 = n - this.nfree;
            if (n2 < n3) {
                n2 = n3;
            }
            this.recap(n2 + n3);
        }
        int n4 = n2 = this.first_free;
        int n5 = 0;
        int n6 = n - 1;
        for (int i = n5; i < n6; ++i) {
            n4 = this.next[n4];
        }
        this.first_free = this.next[n4];
        if (this.first_free < 0) {
            this.last_free = -1;
        } else {
            this.prev[this.first_free] = -1;
        }
        this.next[n4] = this.first_used;
        if (this.first_used >= 0) {
            this.prev[this.first_used] = n4;
        }
        this.first_used = n2;
        this.nfree -= n;
        return n2;
    }

    private void recap(int n) {
        int n2 = this.next.length;
        if (n > n2) {
            this.next = CommonTools.resize(this.next, n);
            this.prev = CommonTools.resize(this.prev, n);
            int n3 = n2;
            int n4 = n - 1;
            for (int i = n3; i < n4; ++i) {
                this.next[i] = i + 1;
                this.prev[i + 1] = i;
            }
            this.next[n - 1] = -1;
            this.prev[n2] = this.last_free;
            if (this.last_free < 0) {
                this.first_free = n2;
            } else {
                this.next[this.last_free] = n2;
            }
            this.last_free = n - 1;
            this.nfree += n - n2;
        }
    }

    public int capacity() {
        return this.next.length;
    }

    public boolean validate() {
        int n;
        boolean[] blArray = new boolean[this.next.length];
        int n2 = this.first_used;
        while (n2 >= 0) {
            blArray[n2] = true;
            if ((n2 = this.next[n2]) < 0 || !blArray[n2]) continue;
            throw new UnexpectedError("used list/next is inconsistent");
        }
        n2 = this.first_free;
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            blArray[n2] = true;
            if ((n2 = this.next[n2]) < 0 || !blArray[n2]) continue;
            throw new UnexpectedError("free list/next is inconsistent");
        }
        if (n3 != this.nfree) {
            throw new UnexpectedError("free next list did not contain nfree elements");
        }
        int n4 = 0;
        int n5 = blArray.length;
        for (n = n4; n < n5; ++n) {
            if (blArray[n2]) continue;
            throw new UnexpectedError("elements missing from used+free list");
        }
        n4 = 0;
        n5 = blArray.length;
        for (n = n4; n < n5; ++n) {
            blArray[n] = false;
        }
        n2 = this.last_free;
        n4 = 0;
        while (n2 >= 0) {
            ++n4;
            blArray[n2] = true;
            if ((n2 = this.prev[n2]) < 0 || !blArray[n2]) continue;
            throw new UnexpectedError("prev list is inconsistent");
        }
        if (n4 != this.nfree) {
            throw new UnexpectedError("free prev list did not contain nfree elements");
        }
        return true;
    }
}

