/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.ExprAdd;
import mosek.fusion.ExprCondense;
import mosek.fusion.ExprConst;
import mosek.fusion.ExprCrossDot;
import mosek.fusion.ExprDotParam;
import mosek.fusion.ExprInner;
import mosek.fusion.ExprMulDiagLeft;
import mosek.fusion.ExprMulDiagRight;
import mosek.fusion.ExprMulElement;
import mosek.fusion.ExprMulParamDiagLeft;
import mosek.fusion.ExprMulParamDiagRight;
import mosek.fusion.ExprMulParamElem;
import mosek.fusion.ExprMulParamLeft;
import mosek.fusion.ExprMulParamRight;
import mosek.fusion.ExprMulParamScalar;
import mosek.fusion.ExprMulParamScalarExpr;
import mosek.fusion.ExprMulScalarConst;
import mosek.fusion.ExprMulScalarVar;
import mosek.fusion.ExprMulVar;
import mosek.fusion.ExprPermuteDims;
import mosek.fusion.ExprRepeat;
import mosek.fusion.ExprReshape;
import mosek.fusion.ExprScalarMul;
import mosek.fusion.ExprStack;
import mosek.fusion.ExprSumReduce;
import mosek.fusion.ExprSumReduceEnd;
import mosek.fusion.ExprTranspose;
import mosek.fusion.ExprWSum;
import mosek.fusion.Expression;
import mosek.fusion.ExpressionError;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.Model;
import mosek.fusion.NDSparseArray;
import mosek.fusion.Parameter;
import mosek.fusion.Set;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Var;
import mosek.fusion.Variable;
import mosek.fusion.WorkStack;

public final class Expr
extends BaseExpression {
    private long[] inst;
    private double[] cof_v;
    private long[] subj;
    private long[] ptrb;
    private double[] bfix;
    private int[] shape;

    public Expr(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, int[] nArray, long[] lArray3) {
        int n;
        int[] nArray2;
        long[] lArray4 = Tools.arraycopy(lArray);
        long[] lArray5 = Tools.arraycopy(lArray2);
        double[] dArray3 = Tools.arraycopy(dArray);
        double[] dArray4 = Tools.arraycopy(dArray2);
        if (nArray != null) {
            nArray2 = Tools.arraycopy(nArray);
        } else {
            int[] nArray3 = new int[1];
            nArray2 = nArray3;
            nArray3[0] = lArray.length - 1;
        }
        this(lArray4, lArray5, dArray3, dArray4, nArray2, lArray3 != null ? Tools.arraycopy(lArray3) : null, 1);
        int n2 = lArray.length - 1;
        if (n2 < 0) {
            throw new ExpressionError("Invalid ptrb");
        }
        long l = lArray[n2];
        if (l < 0L || l != (long)dArray.length || l != (long)lArray2.length) {
            throw new ExpressionError("Invalid ptrb construction");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int[] nArray4 = this.shape;
        long l2 = Set.size(nArray4);
        int n3 = 0;
        int n4 = nArray4.length;
        for (n = n3; n < n4; ++n) {
            bl2 = bl2 && nArray4[n] >= 0;
        }
        n3 = 0;
        n4 = n2;
        for (n = n3; n < n4; ++n) {
            bl = bl && lArray[n] <= lArray[n + 1];
        }
        if (lArray3 != null && lArray3.length > 0) {
            bl3 = lArray3[0] >= 0L && lArray3[n2 - 1] < l2;
            n3 = 0;
            n4 = n2 - 1;
            for (n = n3; n < n4; ++n) {
                bl3 = bl3 && lArray3[n] < lArray3[n + 1];
            }
        }
        if (!bl2) {
            throw new ExpressionError("Invalid shape");
        }
        if (!bl) {
            throw new ExpressionError("Invalid ptrb");
        }
        if (!bl3) {
            throw new ExpressionError("Invalid sparsity pattern");
        }
    }

    protected Expr(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, int[] nArray, long[] lArray3, int n) {
        super(null, nArray);
        this.shape = nArray;
        this.ptrb = lArray;
        this.subj = lArray2;
        this.cof_v = dArray;
        this.bfix = dArray2;
        this.inst = lArray3;
        if (this.shape == null) {
            throw new UnexpectedError("Internal: NULL shape");
        }
    }

    private long prod(int[] nArray) {
        int n = 1;
        int n2 = 0;
        int n3 = nArray.length;
        for (int i = n2; i < n3; ++i) {
            n *= nArray[i];
        }
        return n;
    }

    private static Variable[] varstack(Variable[][] variableArray) {
        int n = 0;
        Variable[] variableArray2 = new Variable[1024];
        int n2 = 0;
        int n3 = variableArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            int n8 = variableArray[n5].length;
            int n9 = n7 < n8 ? n8 - n7 : 0;
            int n10 = n7;
            int n11 = 0;
            while (n11 < n9) {
                if (variableArray2.length == n) {
                    Variable[] variableArray3 = new Variable[2 * variableArray2.length];
                    System.arraycopy(variableArray2, 0, variableArray3, 0, variableArray2.length);
                    variableArray2 = variableArray3;
                }
                variableArray2[n] = variableArray[n5][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n6;
            ++n5;
        }
        if (variableArray2.length > n) {
            Variable[] variableArray4 = new Variable[n];
            System.arraycopy(variableArray2, 0, variableArray4, 0, n);
            variableArray2 = variableArray4;
        }
        return variableArray2;
    }

    private static Variable[] varstack(Variable[] variableArray, Variable[] variableArray2) {
        int n;
        if (variableArray == null) {
            return variableArray2;
        }
        if (variableArray2 == null) {
            return variableArray;
        }
        Variable[] variableArray3 = new Variable[variableArray.length + variableArray2.length];
        int n2 = 0;
        int n3 = variableArray.length;
        for (n = n2; n < n3; ++n) {
            variableArray3[n] = variableArray[n];
        }
        n2 = 0;
        n3 = variableArray2.length;
        for (n = n2; n < n3; ++n) {
            variableArray3[n + variableArray.length] = variableArray2[n];
        }
        return variableArray3;
    }

    public static Expression condense(Expression expression) {
        return new ExprCondense(expression);
    }

    public static Expression flatten(Expression expression) {
        if (expression == null) {
            throw new NullPointerException("Arguments for flatten may not be null");
        }
        long l = expression.getSize();
        if (l > Integer.MAX_VALUE) {
            throw new LengthError("Maximum dimension size exceeded");
        }
        return Expr.reshape(expression, (int)l);
    }

    public static Expression reshape(Expression expression, int n, int n2) {
        if (expression == null) {
            throw new NullPointerException("Arguments for reshape may not be null");
        }
        return Expr.reshape(expression, Set.make(n, n2));
    }

    public static Expression reshape(Expression expression, int n) {
        if (expression == null) {
            throw new NullPointerException("Arguments for reshape may not be null");
        }
        return Expr.reshape(expression, Set.make(n));
    }

    public static Expression reshape(Expression expression, int[] nArray) {
        return new ExprReshape(nArray, expression);
    }

    public static Expression zeros(int[] nArray) {
        return Expr.constTerm(nArray, 0.0);
    }

    public static Expression zeros(int n) {
        return Expr.constTerm(n, 0.0);
    }

    public static Expression ones() {
        return Expr.constTerm(1.0);
    }

    public static Expression ones(int[] nArray, int[][] nArray2) {
        return Expr.constTerm(nArray, nArray2, 1.0);
    }

    public static Expression ones(int[] nArray) {
        return Expr.constTerm(nArray, 1.0);
    }

    public static Expression ones(int n) {
        return Expr.constTerm(n, 1.0);
    }

    public static Expression constTerm(NDSparseArray nDSparseArray) {
        return new ExprConst(nDSparseArray.dims, nDSparseArray.inst, nDSparseArray.cof);
    }

    public static Expression constTerm(Matrix matrix) {
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        int[] nArray = Set.make(n, n2);
        if (matrix.isSparse()) {
            double[] dArray = new double[(int)matrix.numNonzeros()];
            int[] nArray2 = new int[(int)matrix.numNonzeros()];
            int[] nArray3 = new int[(int)matrix.numNonzeros()];
            matrix.getDataAsTriplets(nArray3, nArray2, dArray);
            int n3 = 0;
            int n4 = 0;
            int n5 = nArray2.length;
            int n6 = n4 < n5 ? n5 - n4 : 0;
            long[] lArray = new long[n6];
            int n7 = n4;
            int n8 = 0;
            while (n8 < n6) {
                lArray[n3] = nArray3[n7] * n2 + nArray2[n7];
                ++n3;
                ++n8;
                ++n7;
            }
            long[] lArray2 = lArray;
            return new ExprConst(nArray, lArray2, dArray);
        }
        return new ExprConst(nArray, null, matrix.getDataAsArray());
    }

    public static Expression constTerm(double d) {
        return new ExprConst(new int[0], null, d);
    }

    public static Expression constTerm(int[] nArray, int[][] nArray2, double d) {
        int n;
        int n2 = nArray2.length;
        int n3 = nArray.length;
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n3];
        lArray2[n3 - 1] = 1L;
        int n4 = 1;
        int n5 = n3;
        for (n = n4; n < n5; ++n) {
            lArray2[n3 - n - 1] = lArray2[n3 - n] * (long)nArray[n3 - n];
        }
        n4 = 0;
        n5 = n2;
        for (n = n4; n < n5; ++n) {
            int n6 = 0;
            int n7 = n3;
            for (int i = n6; i < n7; ++i) {
                int n8 = n;
                lArray[n8] = lArray[n8] + lArray2[i] * (long)nArray2[n][i];
            }
        }
        return new ExprConst(nArray, lArray, d);
    }

    public static Expression constTerm(int[] nArray, int[][] nArray2, double[] dArray) {
        int n;
        int n2 = nArray2.length;
        int n3 = nArray.length;
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n3];
        lArray2[n3 - 1] = 1L;
        int n4 = 1;
        int n5 = n3;
        for (n = n4; n < n5; ++n) {
            lArray2[n3 - n - 1] = lArray2[n3 - n] * (long)nArray[n3 - n];
        }
        n4 = 0;
        n5 = n2;
        for (n = n4; n < n5; ++n) {
            int n6 = 0;
            int n7 = n3;
            for (int i = n6; i < n7; ++i) {
                int n8 = n;
                lArray[n8] = lArray[n8] + lArray2[i] * (long)nArray2[n][i];
            }
        }
        return new ExprConst(nArray, lArray, dArray);
    }

    public static Expression constTerm(int[] nArray, double d) {
        return new ExprConst(nArray, null, d);
    }

    public static Expression constTerm(int n, double d) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        double[] dArray = new double[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n2] = d;
            ++n2;
            ++n7;
            ++n6;
        }
        return new ExprConst(new int[]{n}, null, dArray);
    }

    public static Expression constTerm(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        return new ExprConst(new int[]{dArray.length, dArray[0].length}, null, dArray2);
    }

    public static Expression constTerm(double[] dArray) {
        return new ExprConst(new int[]{dArray.length}, null, dArray);
    }

    public static Expression sum(Expression expression, int[] nArray) {
        int n;
        int n2;
        int[] nArray2 = expression.getShape();
        if (nArray.length == 0 || nArray[0] < 0) {
            throw new DimensionError("Invalid index dimension");
        }
        int n3 = 1;
        int n4 = nArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (nArray[n2 - 1] < nArray[n2]) continue;
            throw new DimensionError("Unordered dimension indexes");
        }
        if (nArray[nArray.length - 1] >= nArray2.length) {
            throw new DimensionError("Unordered dimension indexes");
        }
        n3 = nArray2.length;
        int[] nArray3 = new int[n3];
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = nArray.length;
        for (n = n6; n < n7; ++n) {
            while (n2 < nArray[n] && n2 < nArray[n]) {
                nArray3[n5] = n2++;
                ++n5;
            }
            ++n2;
        }
        while (n2 < n3 && n2 < n3) {
            nArray3[n5] = n2++;
            ++n5;
        }
        n6 = 0;
        n7 = nArray.length;
        for (n = n6; n < n7; ++n) {
            nArray3[n5] = nArray[n];
            ++n5;
        }
        return new ExprSumReduceEnd(nArray.length, new ExprPermuteDims(nArray3, expression));
    }

    public static Expression sum(Expression expression, int n) {
        return new ExprSumReduce(n, expression);
    }

    public static Expression sum(Expression expression) {
        return new ExprSumReduce(0, Expr.flatten(expression));
    }

    public static Expression neg(Expression expression) {
        return new ExprMulScalarConst(-1.0, expression);
    }

    private static Expression mulDiag(boolean bl, Matrix matrix, Expression expression) {
        long l = matrix.numNonzeros();
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        double[] dArray = new double[(int)l];
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        matrix.getDataAsTriplets(nArray2, nArray, dArray);
        if (bl) {
            return new ExprMulDiagLeft(n, n2, nArray2, nArray, dArray, expression);
        }
        return new ExprMulDiagRight(n, n2, nArray2, nArray, dArray, expression);
    }

    public static Expression mulDiag(Variable variable, Parameter parameter) {
        return new ExprMulParamDiagRight(variable.asExpr(), parameter);
    }

    public static Expression mulDiag(Parameter parameter, Variable variable) {
        return new ExprMulParamDiagLeft(parameter, variable.asExpr());
    }

    public static Expression mulDiag(Expression expression, Parameter parameter) {
        return new ExprMulParamDiagRight(expression, parameter);
    }

    public static Expression mulDiag(Parameter parameter, Expression expression) {
        return new ExprMulParamDiagLeft(parameter, expression);
    }

    public static Expression mulDiag(Variable variable, Matrix matrix) {
        return Expr.mulDiag(false, matrix, variable.asExpr());
    }

    public static Expression mulDiag(Matrix matrix, Variable variable) {
        return Expr.mulDiag(true, matrix, variable.asExpr());
    }

    public static Expression mulDiag(Expression expression, Matrix matrix) {
        return Expr.mulDiag(false, matrix, expression);
    }

    public static Expression mulDiag(Matrix matrix, Expression expression) {
        return Expr.mulDiag(true, matrix, expression);
    }

    public static Expression mulDiag(Variable variable, double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = dArray.length;
        int n8 = n6 < n7 ? n7 - n6 : 0;
        int n9 = 0;
        int n10 = dArray[0].length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray = new int[n8 * n11];
        int n12 = n6;
        int n13 = 0;
        while (n13 < n8) {
            n4 = n9;
            n3 = 0;
            while (n3 < n11) {
                nArray[n5] = n12;
                ++n5;
                ++n3;
                ++n4;
            }
            ++n13;
            ++n12;
        }
        n13 = 0;
        n4 = 0;
        n3 = dArray.length;
        int n14 = n4 < n3 ? n3 - n4 : 0;
        int n15 = 0;
        int n16 = dArray[0].length;
        int n17 = n15 < n16 ? n16 - n15 : 0;
        int[] nArray2 = new int[n14 * n17];
        int n18 = n4;
        int n19 = 0;
        while (n19 < n14) {
            n2 = n15;
            for (n = 0; n < n17; ++n) {
                nArray2[n13] = n2++;
                ++n13;
            }
            ++n19;
            ++n18;
        }
        n19 = 0;
        n2 = 0;
        n = dArray.length;
        int n20 = n2 < n ? n - n2 : 0;
        int n21 = 0;
        int n22 = dArray[0].length;
        int n23 = n21 < n22 ? n22 - n21 : 0;
        double[] dArray2 = new double[n20 * n23];
        int n24 = n2;
        int n25 = 0;
        while (n25 < n20) {
            int n26 = n21;
            int n27 = 0;
            while (n27 < n23) {
                dArray2[n19] = dArray[n24][n26];
                ++n19;
                ++n27;
                ++n26;
            }
            ++n25;
            ++n24;
        }
        return new ExprMulDiagRight(dArray.length, dArray[0].length, nArray, nArray2, dArray2, variable.asExpr());
    }

    public static Expression mulDiag(Expression expression, double[][] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = dArray.length;
        int n8 = n6 < n7 ? n7 - n6 : 0;
        int n9 = 0;
        int n10 = dArray[0].length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray = new int[n8 * n11];
        int n12 = n6;
        int n13 = 0;
        while (n13 < n8) {
            n4 = n9;
            n3 = 0;
            while (n3 < n11) {
                nArray[n5] = n12;
                ++n5;
                ++n3;
                ++n4;
            }
            ++n13;
            ++n12;
        }
        n13 = 0;
        n4 = 0;
        n3 = dArray.length;
        int n14 = n4 < n3 ? n3 - n4 : 0;
        int n15 = 0;
        int n16 = dArray[0].length;
        int n17 = n15 < n16 ? n16 - n15 : 0;
        int[] nArray2 = new int[n14 * n17];
        int n18 = n4;
        int n19 = 0;
        while (n19 < n14) {
            n2 = n15;
            for (n = 0; n < n17; ++n) {
                nArray2[n13] = n2++;
                ++n13;
            }
            ++n19;
            ++n18;
        }
        n19 = 0;
        n2 = 0;
        n = dArray.length;
        int n20 = n2 < n ? n - n2 : 0;
        int n21 = 0;
        int n22 = dArray[0].length;
        int n23 = n21 < n22 ? n22 - n21 : 0;
        double[] dArray2 = new double[n20 * n23];
        int n24 = n2;
        int n25 = 0;
        while (n25 < n20) {
            int n26 = n21;
            int n27 = 0;
            while (n27 < n23) {
                dArray2[n19] = dArray[n24][n26];
                ++n19;
                ++n27;
                ++n26;
            }
            ++n25;
            ++n24;
        }
        return new ExprMulDiagRight(dArray.length, dArray[0].length, nArray, nArray2, dArray2, expression);
    }

    public static Expression mulDiag(double[][] dArray, Variable variable) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = dArray.length;
        int n8 = n6 < n7 ? n7 - n6 : 0;
        int n9 = 0;
        int n10 = dArray[0].length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray = new int[n8 * n11];
        int n12 = n6;
        int n13 = 0;
        while (n13 < n8) {
            n4 = n9;
            n3 = 0;
            while (n3 < n11) {
                nArray[n5] = n12;
                ++n5;
                ++n3;
                ++n4;
            }
            ++n13;
            ++n12;
        }
        n13 = 0;
        n4 = 0;
        n3 = dArray.length;
        int n14 = n4 < n3 ? n3 - n4 : 0;
        int n15 = 0;
        int n16 = dArray[0].length;
        int n17 = n15 < n16 ? n16 - n15 : 0;
        int[] nArray2 = new int[n14 * n17];
        int n18 = n4;
        int n19 = 0;
        while (n19 < n14) {
            n2 = n15;
            for (n = 0; n < n17; ++n) {
                nArray2[n13] = n2++;
                ++n13;
            }
            ++n19;
            ++n18;
        }
        n19 = 0;
        n2 = 0;
        n = dArray.length;
        int n20 = n2 < n ? n - n2 : 0;
        int n21 = 0;
        int n22 = dArray[0].length;
        int n23 = n21 < n22 ? n22 - n21 : 0;
        double[] dArray2 = new double[n20 * n23];
        int n24 = n2;
        int n25 = 0;
        while (n25 < n20) {
            int n26 = n21;
            int n27 = 0;
            while (n27 < n23) {
                dArray2[n19] = dArray[n24][n26];
                ++n19;
                ++n27;
                ++n26;
            }
            ++n25;
            ++n24;
        }
        return new ExprMulDiagLeft(dArray.length, dArray[0].length, nArray, nArray2, dArray2, variable.asExpr());
    }

    public static Expression mulDiag(double[][] dArray, Expression expression) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = dArray.length;
        int n8 = n6 < n7 ? n7 - n6 : 0;
        int n9 = 0;
        int n10 = dArray[0].length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray = new int[n8 * n11];
        int n12 = n6;
        int n13 = 0;
        while (n13 < n8) {
            n4 = n9;
            n3 = 0;
            while (n3 < n11) {
                nArray[n5] = n12;
                ++n5;
                ++n3;
                ++n4;
            }
            ++n13;
            ++n12;
        }
        n13 = 0;
        n4 = 0;
        n3 = dArray.length;
        int n14 = n4 < n3 ? n3 - n4 : 0;
        int n15 = 0;
        int n16 = dArray[0].length;
        int n17 = n15 < n16 ? n16 - n15 : 0;
        int[] nArray2 = new int[n14 * n17];
        int n18 = n4;
        int n19 = 0;
        while (n19 < n14) {
            n2 = n15;
            for (n = 0; n < n17; ++n) {
                nArray2[n13] = n2++;
                ++n13;
            }
            ++n19;
            ++n18;
        }
        n19 = 0;
        n2 = 0;
        n = dArray.length;
        int n20 = n2 < n ? n - n2 : 0;
        int n21 = 0;
        int n22 = dArray[0].length;
        int n23 = n21 < n22 ? n22 - n21 : 0;
        double[] dArray2 = new double[n20 * n23];
        int n24 = n2;
        int n25 = 0;
        while (n25 < n20) {
            int n26 = n21;
            int n27 = 0;
            while (n27 < n23) {
                dArray2[n19] = dArray[n24][n26];
                ++n19;
                ++n27;
                ++n26;
            }
            ++n25;
            ++n24;
        }
        return new ExprMulDiagLeft(dArray.length, dArray[0].length, nArray, nArray2, dArray2, expression);
    }

    private static Expression mulElm_(Matrix matrix, Expression expression) {
        int[] nArray = expression.getShape();
        Expression expression2 = expression;
        if (nArray.length == 1) {
            nArray = new int[]{nArray[0], 1};
            expression2 = new ExprReshape(nArray, expression);
        }
        if (nArray.length != 2 || matrix.numRows() != nArray[0] || matrix.numColumns() != nArray[1]) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        int n = matrix.numColumns();
        long l = matrix.numNonzeros();
        int[] nArray2 = new int[(int)l];
        int[] nArray3 = new int[(int)l];
        double[] dArray = new double[(int)l];
        matrix.getDataAsTriplets(nArray2, nArray3, dArray);
        int n2 = 0;
        int n3 = 0;
        long l2 = l;
        long l3 = (long)n3 < l2 ? l2 - (long)n3 : 0L;
        long[] lArray = new long[(int)l3];
        long l4 = n3;
        int n4 = 0;
        while ((long)n4 < l3) {
            lArray[n2] = nArray2[(int)l4] * n + nArray3[(int)l4];
            ++n2;
            ++n4;
            ++l4;
        }
        return new ExprMulElement(dArray, lArray, expression2, 1);
    }

    private static Expression mulElm_(double[] dArray, Expression expression) {
        if (dArray == null || expression == null) {
            throw new NullPointerException("Arguments for mulElm may not be null");
        }
        if (expression.getND() == 0 && dArray.length == 1) {
            return new ExprMulScalarConst(dArray[0], expression);
        }
        if (expression.getND() != 1 || expression.getDim(0) != dArray.length) {
            throw new DimensionError("Dimensions of operands do not match");
        }
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = n5;
            ++n;
            ++n6;
            ++n5;
        }
        return new ExprMulElement(dArray, lArray, expression);
    }

    private static Expression mulElm_(NDSparseArray nDSparseArray, Expression expression) {
        if (nDSparseArray == null || expression == null) {
            throw new NullPointerException("Arguments for mulElm may not be null");
        }
        int[] nArray = expression.getShape();
        if (nArray.length != nDSparseArray.dims.length) {
            throw new LengthError("Dimension mismatch");
        }
        int n = 0;
        int n2 = nDSparseArray.dims.length;
        for (int i = n; i < n2; ++i) {
            if (nDSparseArray.dims[i] == nArray[i]) continue;
            throw new DimensionError("Dimensions of operands do not match");
        }
        return new ExprMulElement(nDSparseArray.cof, nDSparseArray.inst, expression);
    }

    public static Expression mul(Expression expression, double d) {
        return new ExprMulScalarConst(d, expression);
    }

    public static Expression mul(double d, Expression expression) {
        return new ExprMulScalarConst(d, expression);
    }

    public static Expression mul(Expression expression, double[] dArray) {
        return Expr.mul(false, dArray, expression);
    }

    public static Expression mul(double[] dArray, Expression expression) {
        return Expr.mul(true, dArray, expression);
    }

    public static Expression mul(Expression expression, double[][] dArray) {
        return Expr.mul(false, dArray, expression);
    }

    public static Expression mul(double[][] dArray, Expression expression) {
        return Expr.mul(true, dArray, expression);
    }

    public static Expression mul(Expression expression, Matrix matrix) {
        return Expr.mul(false, matrix, expression);
    }

    public static Expression mul(Matrix matrix, Expression expression) {
        return Expr.mul(true, matrix, expression);
    }

    private static Expression mul(boolean bl, double[] dArray, Expression expression) {
        int n;
        int n2 = n = dArray.length;
        double[] dArray2 = Tools.arraycopy(dArray);
        int n3 = expression.getND();
        if (n3 == 0) {
            int n4;
            int n5 = 0;
            int n6 = 0;
            int n7 = n;
            int n8 = n6 < n7 ? n7 - n6 : 0;
            int[] nArray = new int[n8];
            int n9 = n6;
            for (n4 = 0; n4 < n8; ++n4) {
                nArray[n5] = n9++;
                ++n5;
            }
            n4 = 0;
            int n10 = 0;
            int n11 = n;
            int n12 = n10 < n11 ? n11 - n10 : 0;
            int[] nArray2 = new int[n12];
            int n13 = n10;
            int n14 = 0;
            while (n14 < n12) {
                nArray2[n4] = 0;
                ++n4;
                ++n14;
                ++n13;
            }
            return new ExprReshape(new int[]{n}, new ExprScalarMul(n, 1, nArray, nArray2, dArray2, expression, 1));
        }
        if (n3 != 2) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (bl && expression.getDim(0) == dArray.length) {
            return new ExprReshape(new int[]{expression.getDim(1)}, new ExprCrossDot(n, 1, dArray2, expression));
        }
        if (bl && expression.getDim(0) == 1) {
            return new ExprCrossDot(n, 1, dArray2, expression);
        }
        if (!bl && expression.getDim(1) == n) {
            return new ExprReshape(new int[]{expression.getDim(0)}, new ExprCrossDot(1, n, dArray2, expression));
        }
        if (!bl && expression.getDim(1) == 1) {
            return new ExprCrossDot(n, 1, dArray2, new ExprTranspose(expression));
        }
        throw new DimensionError("Mismatching operand shapes");
    }

    private static Expression mul(boolean bl, double[][] dArray, Expression expression) {
        int n;
        int n2;
        int n3;
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        int n6 = n4 * n5;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        double[] dArray2 = new double[n6];
        int n7 = 0;
        int n8 = 0;
        int n9 = n4;
        for (int i = n8; i < n9; ++i) {
            n3 = 0;
            n2 = n5;
            for (n = n3; n < n2; ++n) {
                nArray[n7] = i;
                nArray2[n7] = n;
                dArray2[n7] = dArray[i][n];
                ++n7;
            }
        }
        long l = expression.getSize();
        int[] nArray3 = expression.getShape();
        if (nArray3.length == 0) {
            return new ExprScalarMul(n4, n5, nArray, nArray2, dArray2, expression, 1);
        }
        if (bl) {
            if (nArray3.length == 1) {
                return new ExprReshape(new int[]{n4}, new ExprCrossDot(n4, n5, dArray2, new ExprReshape(new int[]{1, nArray3[0]}, expression)));
            }
            if (nArray3.length == 2) {
                return new ExprCrossDot(n4, n5, dArray2, new ExprTranspose(expression));
            }
            throw new DimensionError("Mismatching operand shapes");
        }
        double[] dArray3 = new double[n6];
        n3 = 0;
        n2 = 0;
        n = n5;
        for (int i = n2; i < n; ++i) {
            int n10 = 0;
            int n11 = n4;
            for (int j = n10; j < n11; ++j) {
                dArray3[n3] = dArray[j][i];
                ++n3;
            }
        }
        if (nArray3.length == 1) {
            return new ExprReshape(new int[]{n5}, new ExprCrossDot(n5, n4, dArray3, new ExprReshape(new int[]{1, nArray3[0]}, expression)));
        }
        if (nArray3.length == 2) {
            return new ExprTranspose(new ExprCrossDot(n5, n4, dArray3, expression));
        }
        throw new DimensionError("Mismatching operand shapes");
    }

    private static Expression mul(boolean bl, Matrix matrix, Expression expression) {
        long l = matrix.numNonzeros();
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        int n3 = expression.getND();
        if (n3 == 0) {
            int[] nArray = new int[(int)l];
            int[] nArray2 = new int[(int)l];
            double[] dArray = new double[(int)l];
            matrix.getDataAsTriplets(nArray, nArray2, dArray);
            return new ExprScalarMul(n, n2, nArray, nArray2, dArray, expression);
        }
        if (matrix.isSparse()) {
            if (n3 == 1) {
                int[] nArray = expression.getShape();
                if (bl) {
                    int[] nArray3 = new int[(int)l];
                    int[] nArray4 = new int[(int)l];
                    double[] dArray = new double[(int)l];
                    matrix.getDataAsTriplets(nArray3, nArray4, dArray);
                    return new ExprReshape(new int[]{n}, new ExprCrossDot(n, n2, nArray3, nArray4, dArray, Expr.transpose(expression)));
                }
                int[] nArray5 = new int[(int)l];
                int[] nArray6 = new int[(int)l];
                double[] dArray = new double[(int)l];
                matrix.transpose().getDataAsTriplets(nArray5, nArray6, dArray);
                return new ExprReshape(new int[]{n2}, new ExprCrossDot(n2, n, nArray5, nArray6, dArray, expression));
            }
            if (n3 == 2) {
                if (bl) {
                    int[] nArray = new int[(int)l];
                    int[] nArray7 = new int[(int)l];
                    double[] dArray = new double[(int)l];
                    matrix.getDataAsTriplets(nArray, nArray7, dArray);
                    return new ExprCrossDot(n, n2, nArray, nArray7, dArray, Expr.transpose(expression));
                }
                int[] nArray = new int[(int)l];
                int[] nArray8 = new int[(int)l];
                double[] dArray = new double[(int)l];
                matrix.transpose().getDataAsTriplets(nArray, nArray8, dArray);
                return Expr.transpose(new ExprCrossDot(n2, n, nArray, nArray8, dArray, expression));
            }
            throw new DimensionError("Mismatching dimensions for multiplication");
        }
        if (n3 == 1) {
            int[] nArray = expression.getShape();
            if (bl) {
                return new ExprReshape(new int[]{n}, new ExprCrossDot(n, n2, matrix.getDataAsArray(), new ExprReshape(new int[]{1, nArray[0]}, expression)));
            }
            return new ExprReshape(new int[]{n2}, new ExprCrossDot(n2, n, matrix.transpose().getDataAsArray(), new ExprReshape(new int[]{nArray[0], 1}, expression)));
        }
        if (n3 == 2) {
            if (bl) {
                return new ExprCrossDot(n, n2, matrix.getDataAsArray(), Expr.transpose(expression));
            }
            return Expr.transpose(new ExprCrossDot(n2, n, matrix.transpose().getDataAsArray(), expression));
        }
        throw new DimensionError("Mismatching dimensions for multiplication");
    }

    public static Expression mul(Variable variable, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n5; i < n6; ++i) {
            int n7 = 0;
            int n8 = n2;
            for (int j = n7; j < n8; ++j) {
                nArray[n4] = i;
                nArray2[n4] = j;
                dArray2[n4] = dArray[i][j];
                ++n4;
            }
        }
        return Expr.mul(false, n, n2, nArray, nArray2, dArray2, variable);
    }

    public static Expression mul(double[][] dArray, Variable variable) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = n * n2;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n5; i < n6; ++i) {
            int n7 = 0;
            int n8 = n2;
            for (int j = n7; j < n8; ++j) {
                nArray[n4] = i;
                nArray2[n4] = j;
                dArray2[n4] = dArray[i][j];
                ++n4;
            }
        }
        return Expr.mul(true, n, n2, nArray, nArray2, dArray2, variable);
    }

    public static Expression mul(Variable variable, Matrix matrix) {
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        double[] dArray = new double[(int)matrix.numNonzeros()];
        int[] nArray = new int[(int)matrix.numNonzeros()];
        int[] nArray2 = new int[(int)matrix.numNonzeros()];
        matrix.getDataAsTriplets(nArray2, nArray, dArray);
        return Expr.mul(false, n, n2, nArray2, nArray, dArray, variable);
    }

    public static Expression mul(Matrix matrix, Variable variable) {
        int n = matrix.numRows();
        int n2 = matrix.numColumns();
        double[] dArray = new double[(int)matrix.numNonzeros()];
        int[] nArray = new int[(int)matrix.numNonzeros()];
        int[] nArray2 = new int[(int)matrix.numNonzeros()];
        matrix.getDataAsTriplets(nArray2, nArray, dArray);
        return Expr.mul(true, n, n2, nArray2, nArray, dArray, variable);
    }

    private static Expression mul(boolean bl, int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Variable variable) {
        if (variable.getND() == 0) {
            return new ExprMulScalarVar(n, n2, nArray, nArray2, dArray, variable);
        }
        if (variable.getND() == 1) {
            int[] nArray3;
            int[] nArray4 = variable.getShape();
            int[] nArray5 = new int[1];
            int n3 = nArray5[0] = bl ? n : n2;
            if (bl) {
                int[] nArray6 = new int[2];
                nArray6[0] = nArray4[0];
                nArray3 = nArray6;
                nArray6[1] = 1;
            } else {
                int[] nArray7 = new int[2];
                nArray7[0] = 1;
                nArray3 = nArray7;
                nArray7[1] = nArray4[0];
            }
            return new ExprReshape(nArray5, new ExprMulVar(bl, n, n2, nArray, nArray2, dArray, Var.reshape(variable, nArray3)));
        }
        return new ExprMulVar(bl, n, n2, nArray, nArray2, dArray, variable);
    }

    public static Expression mul(Expression expression, Parameter parameter) {
        if (parameter.getND() == 2 && expression.getND() == 2) {
            return new ExprMulParamRight(expression, parameter);
        }
        if (parameter.getND() == 1 && expression.getND() == 2) {
            return new ExprReshape(new int[]{expression.getDim(0)}, new ExprMulParamRight(expression, parameter.reshape(new int[]{parameter.getDim(0), 1})));
        }
        if (parameter.getND() == 2 && expression.getND() == 1) {
            return new ExprReshape(new int[]{parameter.getDim(1)}, new ExprMulParamRight(new ExprReshape(new int[]{1, expression.getDim(0)}, expression), parameter));
        }
        if (parameter.getND() == 0) {
            return new ExprMulParamScalar(parameter, expression);
        }
        if (expression.getND() == 0) {
            return new ExprMulParamScalarExpr(parameter, expression);
        }
        throw new DimensionError("Invalid operand dimensions for multiplication");
    }

    public static Expression mul(Parameter parameter, Expression expression) {
        if (parameter.getND() == 2 && expression.getND() == 2) {
            return new ExprMulParamLeft(parameter, expression);
        }
        if (parameter.getND() == 1 && expression.getND() == 2) {
            return new ExprReshape(new int[]{expression.getDim(1)}, new ExprMulParamLeft(parameter.reshape(new int[]{1, parameter.getDim(0)}), expression));
        }
        if (parameter.getND() == 2 && expression.getND() == 1) {
            return new ExprReshape(new int[]{parameter.getDim(0)}, new ExprMulParamLeft(parameter, new ExprReshape(new int[]{expression.getDim(0), 1}, expression)));
        }
        if (parameter.getND() == 0) {
            return new ExprMulParamScalar(parameter, expression);
        }
        if (expression.getND() == 0) {
            return new ExprMulParamScalarExpr(parameter, expression);
        }
        throw new DimensionError("Invalid operand dimensions for multiplication");
    }

    public static Expression dot(Expression expression, Matrix matrix) {
        int[] nArray = expression.getShape();
        if (nArray.length != 2 || matrix.dimi != nArray[0] || matrix.dimj != nArray[1]) {
            throw new DimensionError("Mismatching operand shapes");
        }
        long l = matrix.numNonzeros();
        if (!matrix.isSparse()) {
            int n = 0;
            int n2 = 0;
            long l2 = l;
            long l3 = (long)n2 < l2 ? l2 - (long)n2 : 0L;
            long[] lArray = new long[(int)l3];
            long l4 = n2;
            int n3 = 0;
            while ((long)n3 < l3) {
                lArray[n] = l4++;
                ++n;
                ++n3;
            }
            return new ExprInner(expression, lArray, matrix.getDataAsArray());
        }
        int[] nArray2 = new int[(int)l];
        int[] nArray3 = new int[(int)l];
        double[] dArray = new double[(int)l];
        int n = matrix.numColumns();
        matrix.getDataAsTriplets(nArray2, nArray3, dArray);
        int n4 = 0;
        int n5 = 0;
        int n6 = nArray2.length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        long[] lArray = new long[n7];
        int n8 = n5;
        int n9 = 0;
        while (n9 < n7) {
            lArray[n4] = nArray2[n8] * n + nArray3[n8];
            ++n4;
            ++n9;
            ++n8;
        }
        return new ExprInner(expression, lArray, dArray);
    }

    public static Expression dot(Expression expression, double[][] dArray) {
        int[] nArray = expression.getShape();
        if (2 != nArray.length) {
            throw new DimensionError("Mismatching operand shapes");
        }
        if (nArray[0] != dArray.length || nArray[1] != dArray[0].length) {
            throw new DimensionError("Mismatching operand shapes");
        }
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length * dArray[0].length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = n5;
            ++n;
            ++n6;
            ++n5;
        }
        n6 = 0;
        int n7 = 0;
        int n8 = dArray.length;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        int n10 = 0;
        int n11 = dArray[0].length;
        int n12 = n10 < n11 ? n11 - n10 : 0;
        double[] dArray2 = new double[n9 * n12];
        int n13 = n7;
        int n14 = 0;
        while (n14 < n9) {
            int n15 = n10;
            int n16 = 0;
            while (n16 < n12) {
                dArray2[n6] = dArray[n13][n15];
                ++n6;
                ++n16;
                ++n15;
            }
            ++n14;
            ++n13;
        }
        return new ExprInner(expression, lArray, dArray2);
    }

    public static Expression dot(Expression expression, NDSparseArray nDSparseArray) {
        int[] nArray = expression.getShape();
        if (nDSparseArray.dims.length != nArray.length) {
            throw new DimensionError("Mismatching operand shapes");
        }
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            if (nDSparseArray.dims[i] == nArray[i]) continue;
            throw new DimensionError("Mismatching operand shapes");
        }
        return new ExprInner(expression, nDSparseArray.inst, nDSparseArray.cof);
    }

    public static Expression dot(Expression expression, double[] dArray) {
        int[] nArray = expression.getShape();
        if (expression.getSize() == (long)dArray.length && nArray.length > 1) {
            int n = 0;
            int n2 = 0;
            int n3 = nArray.length;
            for (int i = n2; i < n3; ++i) {
                if (nArray[i] <= 1) continue;
                ++n;
            }
            if (n > 1) {
                throw new DimensionError("Mismatching operand shapes");
            }
            int[] nArray2 = new int[]{(int)expression.getSize()};
            return new ExprInner(new ExprReshape(nArray2, expression), dArray);
        }
        return new ExprInner(expression, dArray);
    }

    public static Expression dot(Matrix matrix, Expression expression) {
        return Expr.dot(expression, matrix);
    }

    public static Expression dot(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.dot(expression, nDSparseArray);
    }

    public static Expression dot(double[][] dArray, Expression expression) {
        return Expr.dot(expression, dArray);
    }

    public static Expression dot(double[] dArray, Expression expression) {
        return Expr.dot(expression, dArray);
    }

    public static Expression dot(Expression expression, Parameter parameter) {
        return new ExprDotParam(parameter, expression);
    }

    public static Expression dot(Parameter parameter, Expression expression) {
        return new ExprDotParam(parameter, expression);
    }

    public static Expression outer(Parameter parameter, Expression expression) {
        int[] nArray = expression.getShape();
        if (nArray.length != 1 && (nArray.length != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        int[] nArray2 = parameter.getShape();
        if (parameter.getND() != 1 && (parameter.getND() != 2 || nArray2[1] != 1)) {
            throw new DimensionError("Parameter argument must be one-dimensional");
        }
        return Expr.mul(parameter.reshape(new int[]{nArray2[0], 1}), Expr.reshape(expression, 1, nArray[0]));
    }

    public static Expression outer(Expression expression, Parameter parameter) {
        int[] nArray = expression.getShape();
        if (expression.getND() != 1 && (expression.getND() != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        int[] nArray2 = parameter.getShape();
        if (parameter.getND() != 1 && (parameter.getND() != 2 || nArray2[1] != 1)) {
            throw new DimensionError("Parameter argument must be one-dimensional");
        }
        return Expr.mul(Expr.reshape(expression, nArray[0], 1), parameter.reshape(new int[]{1, nArray2[0]}));
    }

    public static Expression outer(Matrix matrix, Expression expression) {
        int[] nArray = expression.getShape();
        if (nArray.length != 1 && (nArray.length != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        if (matrix.dimj != 1) {
            throw new DimensionError("Constant matrix must be a column-vector");
        }
        return Expr.mul(matrix, Expr.reshape(expression, 1, nArray[0]));
    }

    public static Expression outer(Expression expression, Matrix matrix) {
        int[] nArray = expression.getShape();
        if (expression.getND() != 1 && (expression.getND() != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        if (matrix.dimj != 1) {
            throw new DimensionError("Constant matrix must be a column-vector");
        }
        return Expr.mul(Expr.reshape(expression, nArray[0], 1), matrix.transpose());
    }

    public static Expression outer(double[] dArray, Expression expression) {
        int[] nArray = expression.getShape();
        if (expression.getND() != 1 && (expression.getND() != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        return Expr.mul(Matrix.dense(dArray.length, 1, dArray), Expr.reshape(expression, 1, nArray[0]));
    }

    public static Expression outer(Expression expression, double[] dArray) {
        int[] nArray = expression.getShape();
        if (expression.getND() != 1 && (expression.getND() != 2 || nArray[1] != 1)) {
            throw new DimensionError("Expression argument must be one-dimensional");
        }
        return Expr.mul(Expr.reshape(expression, nArray[0], 1), Matrix.dense(1, dArray.length, dArray));
    }

    private static Expression outer_(int n, long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, long[] lArray3, double[] dArray3, int[] nArray, int n2, boolean bl) {
        long[] lArray4;
        long[] lArray5;
        double[] dArray4;
        double[] dArray5;
        long[] lArray6;
        int[] nArray2;
        block12: {
            int n3;
            int n4;
            int n5;
            int n6;
            block11: {
                int n7;
                int n8;
                int n9;
                nArray2 = !bl ? Set.make(n, n2) : Set.make(n2, n);
                int n10 = dArray3.length * lArray3.length;
                int n11 = dArray3.length * lArray2.length;
                lArray6 = new long[n10];
                dArray5 = dArray2 != null ? new double[n10] : null;
                dArray4 = new double[n11];
                lArray5 = new long[n11];
                lArray4 = new long[n10 + 1];
                n6 = (int)lArray4[lArray4.length - 1];
                if (bl) break block11;
                long l = 0L;
                long l2 = 0L;
                int n12 = 0;
                int n13 = lArray3.length;
                for (n9 = n12; n9 < n13; ++n9) {
                    long l3 = lArray[n9 + 1] - lArray[n9];
                    n8 = 0;
                    n7 = dArray3.length;
                    for (int i = n8; i < n7; ++i) {
                        lArray3[(int)l] = lArray3[n9] * (long)n2 + (long)nArray[i];
                        lArray4[(int)(l + 1L)] = lArray4[(int)l] + l3;
                        ++l;
                        long l4 = lArray[n9];
                        long l5 = lArray[n9 + 1];
                        for (long j = l4; j < l5; ++j) {
                            lArray5[(int)l2] = lArray2[(int)j];
                            dArray4[(int)l2] = dArray[(int)j] * dArray3[i];
                            ++l2;
                        }
                    }
                }
                if (dArray5 == null) break block12;
                n12 = 0;
                n13 = 0;
                n9 = lArray3.length;
                for (int i = n13; i < n9; ++i) {
                    int n14 = 0;
                    n8 = dArray3.length;
                    for (n7 = n14; n7 < n8; ++n7) {
                        dArray5[n12] = dArray3[n7] * dArray2[i];
                        ++n12;
                    }
                }
                break block12;
            }
            long l = 0L;
            long l6 = 0L;
            int n15 = 0;
            int n16 = dArray3.length;
            for (n5 = n15; n5 < n16; ++n5) {
                double d = dArray3[n5];
                Tools.arraycopy(lArray2, 0L, lArray5, l6, (long)n6);
                int n17 = 0;
                n4 = n6;
                for (n3 = n17; n3 < n4; ++n3) {
                    dArray4[(int)(l6 + (long)n3)] = dArray[n3] * dArray3[n5];
                }
                n17 = 0;
                n4 = lArray3.length;
                for (n3 = n17; n3 < n4; ++n3) {
                    long l7 = lArray[n3 + 1] - lArray[n3];
                    lArray3[(int)l] = lArray3[n3] * (long)n2 + (long)nArray[n5];
                    lArray4[(int)(l + 1L)] = lArray4[(int)l] + l7;
                    ++l;
                }
                l6 += (long)n6;
            }
            if (dArray5 != null) {
                n15 = 0;
                n16 = 0;
                n5 = dArray3.length;
                for (int i = n16; i < n5; ++i) {
                    double d = dArray3[i];
                    n4 = 0;
                    n3 = lArray3.length;
                    for (int j = n4; j < n3; ++j) {
                        dArray5[n15] = dArray2[j] * d;
                        ++n15;
                    }
                }
            }
        }
        return new Expr(lArray4, lArray5, dArray4, dArray5, nArray2, lArray6);
    }

    private static Expression outer_(Variable variable, int n, double[] dArray, int[] nArray, int n2, boolean bl) {
        int[] nArray2 = !bl ? Set.make(n, n2) : Set.make(n2, n);
        long[] lArray = n2 == dArray.length ? null : new long[dArray.length * n];
        double[] dArray2 = new double[dArray.length * n];
        double[] dArray3 = new double[dArray.length * n];
        long[] lArray2 = new long[dArray.length * n];
        long[] lArray3 = new long[dArray.length * n + 1];
        if (n2 == dArray.length) {
            long l = 0L;
            if (!bl) {
                int n3 = 0;
                int n4 = n;
                for (int i = n3; i < n4; ++i) {
                    int n5 = 0;
                    int n6 = n2;
                    for (int j = n5; j < n6; ++j) {
                        lArray3[(int)(l + 1L)] = l + 1L;
                        lArray2[(int)l] = i;
                        dArray3[(int)l] = dArray[j];
                        ++l;
                    }
                }
            } else {
                int n7 = 0;
                int n8 = n2;
                for (int i = n7; i < n8; ++i) {
                    int n9 = 0;
                    int n10 = n;
                    for (int j = n9; j < n10; ++j) {
                        lArray3[(int)(l + 1L)] = l + 1L;
                        lArray2[(int)l] = j;
                        dArray3[(int)l] = dArray[i];
                        ++l;
                    }
                }
            }
        } else {
            long l = 0L;
            if (!bl) {
                int n11 = 0;
                int n12 = n;
                for (int i = n11; i < n12; ++i) {
                    int n13 = 0;
                    int n14 = dArray.length;
                    for (int j = n13; j < n14; ++j) {
                        lArray3[(int)(l + 1L)] = l + 1L;
                        lArray2[(int)l] = i;
                        dArray3[(int)l] = dArray[j];
                        lArray[(int)l] = i * n2 + nArray[j];
                        ++l;
                    }
                }
            } else {
                int n15 = 0;
                int n16 = dArray.length;
                for (int i = n15; i < n16; ++i) {
                    int n17 = 0;
                    int n18 = n;
                    for (int j = n17; j < n18; ++j) {
                        lArray3[(int)(l + 1L)] = l + 1L;
                        lArray2[(int)l] = j;
                        dArray3[(int)l] = dArray[i];
                        lArray[(int)l] = nArray[i] * n + j;
                        ++l;
                    }
                }
            }
        }
        return new Expr(lArray3, lArray2, dArray3, dArray2, nArray2, lArray);
    }

    public static Expression stack(Expression[][] expressionArray) {
        int n;
        int n2;
        int n3;
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n4 = 0;
        int n5 = expressionArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            Expression[] expressionArray2 = expressionArray[n3];
            if (expressionArray2 == null) {
                throw new NullPointerException("Arguments for stack may not be null");
            }
            int n6 = 0;
            n2 = expressionArray2.length;
            for (n = n6; n < n2; ++n) {
                if (expressionArray2[n] != null) continue;
                throw new NullPointerException("Arguments for stack may not be null");
            }
        }
        n4 = 0;
        n5 = 0;
        n3 = expressionArray.length;
        int n7 = n5 < n3 ? n3 - n5 : 0;
        Expression[] expressionArray3 = new Expression[n7];
        n2 = n5;
        n = 0;
        while (n < n7) {
            expressionArray3[n4] = Expr.stack_(expressionArray[n2], 1);
            ++n4;
            ++n;
            ++n2;
        }
        Expression[] expressionArray4 = expressionArray3;
        return Expr.stack_(expressionArray4, 0);
    }

    public static Expression vstack(double d, double d2, double d3) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), Expr.constTerm(d3)}, 0);
    }

    public static Expression vstack(double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, 0);
    }

    public static Expression vstack(double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, 0);
    }

    public static Expression vstack(Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, 0);
    }

    public static Expression vstack(Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2, Expression expression3) {
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, 0);
    }

    public static Expression vstack(double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, 0);
    }

    public static Expression vstack(Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, 0);
    }

    public static Expression vstack(Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, 0);
    }

    public static Expression vstack(Expression[] expressionArray) {
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n = 0;
        int n2 = expressionArray.length;
        for (int i = n; i < n2; ++i) {
            if (expressionArray[i] != null) continue;
            throw new NullPointerException("Arguments for vstack may not be null");
        }
        return Expr.stack_(expressionArray, 0);
    }

    public static Expression hstack(Expression expression, Expression expression2, Expression expression3) {
        if (expression == null || expression2 == null || expression3 == null) {
            throw new NullPointerException("Arguments e1, e2 and e3 may not be null");
        }
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, 1);
    }

    public static Expression hstack(Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, 1);
    }

    public static Expression hstack(Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, 1);
    }

    public static Expression hstack(double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, 1);
    }

    public static Expression hstack(double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, 1);
    }

    public static Expression hstack(double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, 1);
    }

    public static Expression hstack(Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, 1);
    }

    public static Expression hstack(Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, 1);
    }

    public static Expression hstack(Expression[] expressionArray) {
        if (expressionArray == null) {
            throw new NullPointerException("Argument exprs may not be null");
        }
        int n = 0;
        int n2 = expressionArray.length;
        for (int i = n; i < n2; ++i) {
            if (expressionArray[i] != null) continue;
            throw new NullPointerException("Arguments for hstack may not be null");
        }
        return Expr.stack_(expressionArray, 1);
    }

    public static Expression stack(int n, Expression expression, Expression expression2, Expression expression3) {
        return Expr.stack_(new Expression[]{expression, expression2, expression3}, n);
    }

    public static Expression stack(int n, Expression expression, Expression expression2, double d) {
        return Expr.stack_(new Expression[]{expression, expression2, Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Expression expression, double d, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), expression2}, n);
    }

    public static Expression stack(int n, Expression expression, double d, double d2) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d), Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, double d, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, expression2}, n);
    }

    public static Expression stack(int n, double d, Expression expression, double d2) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression, Expr.constTerm(d2)}, n);
    }

    public static Expression stack(int n, double d, double d2, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), Expr.constTerm(d2), expression}, n);
    }

    public static Expression stack(int n, double d, Expression expression) {
        return Expr.stack_(new Expression[]{Expr.constTerm(d), expression}, n);
    }

    public static Expression stack(int n, Expression expression, double d) {
        return Expr.stack_(new Expression[]{expression, Expr.constTerm(d)}, n);
    }

    public static Expression stack(int n, Expression expression, Expression expression2) {
        return Expr.stack_(new Expression[]{expression, expression2}, n);
    }

    public static Expression stack(int n, Expression[] expressionArray) {
        return Expr.stack_(expressionArray, n);
    }

    private static Expression stack_(Expression[] expressionArray, int n) {
        if (expressionArray.length == 1) {
            return expressionArray[0];
        }
        return new ExprStack(Expr.promote(expressionArray, n), n);
    }

    private static Expression[] promote(Expression[] expressionArray, int n) {
        int n2;
        int n3 = expressionArray.length;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        int[] nArray = new int[n7];
        int n8 = n5;
        int n9 = 0;
        while (n9 < n7) {
            nArray[n4] = expressionArray[n8].getND();
            ++n4;
            ++n9;
            ++n8;
        }
        int[] nArray2 = nArray;
        int n10 = nArray2[0];
        int n11 = nArray2[0];
        int n12 = 1;
        int n13 = n3;
        for (n2 = n12; n2 < n13; ++n2) {
            if (nArray2[n2] < n11) {
                n11 = nArray2[n2];
            }
            if (nArray2[n2] <= n10) continue;
            n10 = nArray2[n2];
        }
        if (n10 < n) {
            n10 = n;
        }
        if (n11 < n10) {
            Expression[] expressionArray2 = new Expression[n3];
            int[] nArray3 = new int[n10];
            n2 = 0;
            int n14 = n3;
            for (int i = n2; i < n14; ++i) {
                int n15;
                if (expressionArray[i].getND() == n10) {
                    expressionArray2[i] = expressionArray[i];
                    continue;
                }
                int[] nArray4 = expressionArray[i].getShape();
                int n16 = 0;
                int n17 = nArray4.length;
                for (n15 = n16; n15 < n17; ++n15) {
                    nArray3[n15] = nArray4[n15];
                }
                n16 = nArray4.length;
                n17 = n10;
                for (n15 = n16; n15 < n17; ++n15) {
                    nArray3[n15] = 1;
                }
                expressionArray2[i] = new ExprReshape(nArray3, expressionArray[i]);
            }
            return expressionArray2;
        }
        return expressionArray;
    }

    public static Expression repeat(Variable variable, int n, int n2) {
        return Expr.repeat(variable.asExpr(), n, n2);
    }

    public static Expression repeat(Expression expression, int n, int n2) {
        if (n <= 0) {
            throw new DimensionError("Cannot repeat Expression 0 or less times");
        }
        if (n2 < 0 || n2 > expression.getND()) {
            throw new DimensionError("Invalid stacking dimension");
        }
        if (n2 == expression.getND()) {
            int[] nArray = new int[n2 + 1];
            int n3 = 0;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                nArray[i] = expression.getDim(i);
            }
            nArray[n2] = 1;
            return new ExprRepeat(Expr.reshape(expression, nArray), n2, n);
        }
        return new ExprRepeat(expression, n2, n);
    }

    public static Expression add(Expression[] expressionArray) {
        int n = 0;
        int n2 = 0;
        int n3 = expressionArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray[n] = 1.0;
            ++n;
            ++n6;
            ++n5;
        }
        return new ExprWSum(expressionArray, dArray);
    }

    public static Expression add(Variable[] variableArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (variableArray == null) {
            throw new NullPointerException("Argument vs may not be null");
        }
        if (variableArray.length == 0) {
            return new Expr(new long[]{0L}, new long[0], new double[0], null, Set.make(0), new long[0], 1);
        }
        if (variableArray.length > 0 && variableArray[0] == null) {
            throw new NullPointerException("Argument vs may contain null");
        }
        int n14 = variableArray[0].getND();
        int n15 = 1;
        int n16 = variableArray.length;
        for (n13 = n15; n13 < n16; ++n13) {
            if (n14 >= variableArray[n13].getND()) continue;
            n14 = variableArray[n13].getND();
        }
        int[][] nArray = new int[variableArray.length][n14];
        n16 = 0;
        n13 = variableArray.length;
        for (n12 = n16; n12 < n13; ++n12) {
            int[] nArray2 = variableArray[n12].getShape();
            n11 = 0;
            n10 = nArray2.length;
            for (n9 = n11; n9 < n10; ++n9) {
                nArray[n12][n9] = nArray2[n9];
            }
            n11 = nArray2.length;
            n10 = n14;
            for (n9 = n11; n9 < n10; ++n9) {
                nArray[n12][n9] = 1;
            }
        }
        n16 = 1;
        n13 = variableArray.length;
        for (n12 = n16; n12 < n13; ++n12) {
            int n17 = 0;
            n11 = n14;
            for (n10 = n17; n10 < n11; ++n10) {
                if (nArray[0][n10] == nArray[n12][n10]) continue;
                throw new DimensionError("Mismatching operand dimensions");
            }
        }
        n16 = 0;
        n13 = 0;
        n12 = n14;
        int n18 = n13 < n12 ? n12 - n13 : 0;
        int[] nArray3 = new int[n18];
        n10 = n13;
        n9 = 0;
        while (n9 < n18) {
            nArray3[n16] = nArray[0][n10];
            ++n16;
            ++n9;
            ++n10;
        }
        int[] nArray4 = nArray3;
        int n19 = 1;
        int n20 = 0;
        int n21 = n14;
        for (n8 = n20; n8 < n21; ++n8) {
            n19 *= nArray4[n8];
        }
        n20 = 0;
        n21 = 0;
        n8 = 0;
        int n22 = variableArray.length;
        for (n7 = n8; n7 < n22; ++n7) {
            n6 = variableArray[n7].numInst();
            n20 += n6;
            n21 = n21 > n6 ? n21 : n6;
        }
        long[] lArray = new long[n19 + 1];
        long[] lArray2 = new long[n20];
        n7 = 0;
        n6 = 0;
        int n23 = n20;
        int n24 = n6 < n23 ? n23 - n6 : 0;
        double[] dArray = new double[n24];
        int n25 = n6;
        int n26 = 0;
        while (n26 < n24) {
            dArray[n7] = 1.0;
            ++n7;
            ++n26;
            ++n25;
        }
        double[] dArray2 = dArray;
        long[] lArray3 = new long[n21];
        long[] lArray4 = new long[n21];
        int n27 = 0;
        int n28 = variableArray.length;
        for (n5 = n27; n5 < n28; ++n5) {
            n4 = variableArray[n5].inst(0, lArray3, 0, lArray4);
            n3 = 0;
            n2 = n4;
            for (n = n3; n < n2; ++n) {
                int n29 = (int)(lArray3[n] + 1L);
                lArray[n29] = lArray[n29] + 1L;
            }
        }
        n27 = 0;
        n28 = n19;
        for (n5 = n27; n5 < n28; ++n5) {
            int n30 = n5 + 1;
            lArray[n30] = lArray[n30] + lArray[n5];
        }
        n27 = 0;
        n28 = variableArray.length;
        for (n5 = n27; n5 < n28; ++n5) {
            n4 = variableArray[n5].inst(0, lArray3, 0, lArray4);
            n3 = 0;
            n2 = n4;
            for (n = n3; n < n2; ++n) {
                lArray2[(int)lArray[(int)lArray3[n]]] = lArray4[n];
                int n31 = (int)lArray3[n];
                lArray[n31] = lArray[n31] + 1L;
            }
        }
        n27 = 0;
        n28 = n19;
        for (n5 = n27; n5 < n28; ++n5) {
            lArray[n19 - n5] = lArray[n19 - n5 - 1];
        }
        lArray[0] = 0L;
        int n32 = 0;
        int n33 = 0;
        n27 = n19;
        n28 = n33 < n27 ? n27 - n33 : 0;
        double[] dArray3 = new double[n28];
        n4 = n33;
        n3 = 0;
        while (n3 < n28) {
            dArray3[n32] = 0.0;
            ++n32;
            ++n3;
            ++n4;
        }
        return new Expr(lArray, lArray2, dArray2, dArray3, nArray4, null, 1);
    }

    private static Expression add_(Expression expression, double d, Expression expression2, double d2) {
        int n;
        int n2;
        int n3 = expression.getND();
        if (n3 == (n2 = expression2.getND())) {
            return new ExprAdd(expression, expression2, d, d2);
        }
        int n4 = n3 > n2 ? n3 : n2;
        int[] nArray = new int[n4];
        if (n3 < n2) {
            int n5;
            int[] nArray2 = expression.getShape();
            int n6 = 0;
            int n7 = n3;
            for (n5 = n6; n5 < n7; ++n5) {
                nArray[n5] = nArray2[n5];
            }
            n6 = n3;
            n7 = n4;
            for (n5 = n6; n5 < n7; ++n5) {
                nArray[n5] = 1;
            }
            return new ExprAdd(new ExprReshape(nArray, expression), expression2, d, d2);
        }
        int[] nArray3 = expression2.getShape();
        int n8 = 0;
        int n9 = n2;
        for (n = n8; n < n9; ++n) {
            nArray[n] = nArray3[n];
        }
        n8 = n2;
        n9 = n4;
        for (n = n8; n < n9; ++n) {
            nArray[n] = 1;
        }
        return new ExprAdd(expression, new ExprReshape(nArray, expression2), d, d2);
    }

    public static Expression transpose(Expression expression) {
        if (expression.getND() == 0) {
            return expression;
        }
        if (expression.getND() == 1) {
            return new ExprReshape(new int[]{1, expression.getDim(0)}, expression);
        }
        if (expression.getND() == 2) {
            return new ExprTranspose(expression);
        }
        throw new DimensionError("Incorrect number of dimensions for transpose");
    }

    public static Expression mulElm(Matrix matrix, Expression expression) {
        return Expr.mulElm_(matrix, expression);
    }

    public static Expression mulElm(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.mulElm_(nDSparseArray, expression);
    }

    public static Expression mulElm(double[][] dArray, Expression expression) {
        return Expr.mulElm_(Matrix.dense(dArray), expression);
    }

    public static Expression mulElm(double[] dArray, Expression expression) {
        return Expr.mulElm_(dArray, expression);
    }

    public static Expression mulElm(Expression expression, Matrix matrix) {
        return Expr.mulElm_(matrix, expression);
    }

    public static Expression mulElm(Expression expression, double[][] dArray) {
        return Expr.mulElm_(Matrix.dense(dArray), expression);
    }

    public static Expression mulElm(Expression expression, double[] dArray) {
        return Expr.mulElm_(dArray, expression);
    }

    public static Expression mulElm(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.mulElm_(nDSparseArray, expression);
    }

    public static Expression mulElm(Parameter parameter, Expression expression) {
        return new ExprMulParamElem(parameter, expression);
    }

    public static Expression mulElm(Expression expression, Parameter parameter) {
        return new ExprMulParamElem(parameter, expression);
    }

    public static Expression sub(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.add_(Expr.constTerm(nDSparseArray), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), -1.0);
    }

    public static Expression sub(Matrix matrix, Expression expression) {
        return Expr.add_(Expr.constTerm(matrix), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, Matrix matrix) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), -1.0);
    }

    public static Expression sub(double d, Expression expression) {
        return Expr.add_(Expr.constTerm(expression.getShape(), d), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, double d) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.getShape(), d), -1.0);
    }

    public static Expression sub(double[][] dArray, Expression expression) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, expression, -1.0);
    }

    public static Expression sub(double[] dArray, Expression expression) {
        return Expr.add_(Expr.constTerm(dArray), 1.0, expression, -1.0);
    }

    public static Expression sub(Expression expression, double[][] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Expression expression, double[] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), -1.0);
    }

    public static Expression sub(Expression expression, Expression expression2) {
        return Expr.add_(expression, 1.0, expression2, -1.0);
    }

    public static Expression add(NDSparseArray nDSparseArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), 1.0);
    }

    public static Expression add(Expression expression, NDSparseArray nDSparseArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(nDSparseArray), 1.0);
    }

    public static Expression add(Matrix matrix, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), 1.0);
    }

    public static Expression add(Expression expression, Matrix matrix) {
        return Expr.add_(expression, 1.0, Expr.constTerm(matrix), 1.0);
    }

    public static Expression add(double d, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.getShape(), d), 1.0);
    }

    public static Expression add(Expression expression, double d) {
        return Expr.add_(expression, 1.0, Expr.constTerm(expression.getShape(), d), 1.0);
    }

    public static Expression add(double[][] dArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(double[] dArray, Expression expression) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Expression expression, double[][] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Expression expression, double[] dArray) {
        return Expr.add_(expression, 1.0, Expr.constTerm(dArray), 1.0);
    }

    public static Expression add(Expression expression, Expression expression2) {
        return Expr.add_(expression, 1.0, expression2, 1.0);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3 = this.ptrb.length - 1;
        int n4 = (int)this.ptrb[n3];
        boolean bl2 = true;
        int n5 = 0;
        int n6 = n3;
        for (n2 = n5; n2 < n6; ++n2) {
            bl2 = bl2 && this.bfix[n2] <= 0.0 && this.bfix[n2] >= 0.0;
        }
        if (!bl2) {
            n4 += n3;
        }
        n5 = this.shape.length;
        workStack.alloc_expr(n5, n3, n4, this.inst != null);
        n6 = workStack.ptr_base;
        n2 = workStack.nidxs_base;
        int n7 = workStack.sp_base;
        int n8 = workStack.cof_base;
        int n9 = workStack.shape_base;
        int[] nArray = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n10 = 0;
        int n11 = n5;
        for (n = n10; n < n11; ++n) {
            nArray[n9 + n] = this.shape[n];
        }
        nArray[n6] = 0;
        n10 = 0;
        n11 = 0;
        n = n3;
        for (int i = n11; i < n; ++i) {
            long l = this.ptrb[i];
            long l2 = this.ptrb[i + 1];
            for (long j = l; j < l2; ++j) {
                lArray[n2 + n10] = this.subj[(int)j];
                dArray[n8 + n10] = this.cof_v[(int)j];
                ++n10;
            }
            if (!bl2) {
                lArray[n2 + n10] = 0L;
                dArray[n8 + n10] = this.bfix[i];
            }
            nArray[n6 + i + 1] = ++n10;
        }
    }

    private static void validateData(long[] lArray, long[] lArray2, double[] dArray, double[] dArray2, int[] nArray, long[] lArray3) {
        int n;
        int n2;
        int n3;
        int n4;
        if (nArray == null) {
            throw new ExpressionError("Array 'shape' in expression is null");
        }
        int n5 = lArray.length - 1;
        long l = lArray[lArray.length - 1];
        int n6 = nArray.length;
        long l2 = 1L;
        int n7 = 0;
        int n8 = n6;
        for (n4 = n7; n4 < n8; ++n4) {
            l2 *= (long)nArray[n4];
        }
        if (lArray.length < 1) {
            throw new ExpressionError("Array 'ptrb' in expression has wrong size");
        }
        if (l != (long)lArray2.length) {
            throw new ExpressionError("Array 'subj' in expression has wrong size");
        }
        if (l != (long)dArray.length) {
            throw new ExpressionError("Array 'cof' in expression has wrong size");
        }
        if (dArray2 == null || n5 != dArray2.length) {
            throw new ExpressionError("Array 'bfix' in expression has wrong length");
        }
        if (lArray3 != null && (long)lArray3.length < l2) {
            if (lArray3.length != lArray.length - 1) {
                throw new ExpressionError("Array 'inst' in expression has wrong length");
            }
            if (lArray3.length > 0) {
                if (lArray3[0] < 0L || lArray3[0] >= l2) {
                    throw new ExpressionError("Array 'inst' contains an invalid index");
                }
                n7 = 1;
                long l3 = l2;
                n3 = 1;
                n2 = lArray3.length;
                for (n = n3; n < n2; ++n) {
                    n7 = n7 != 0 && lArray3[n] >= 0L && lArray3[n] < l3 && lArray3[n] > lArray3[n - 1] ? 1 : 0;
                }
                if (n7 == 0) {
                    throw new ExpressionError("Invalid array 'inst'");
                }
            }
        } else if (l2 != (long)lArray.length - 1L) {
            throw new ExpressionError("Array 'ptrb' in expression has wrong length");
        }
        n7 = 0;
        n8 = 0;
        if (lArray[0] != 0L) {
            throw new ExpressionError("Invalid 'ptrb' argument in expression");
        }
        n4 = 1;
        n3 = 0;
        n2 = n5;
        for (n = n3; n < n2; ++n) {
            n4 = n4 != 0 && lArray[n] <= lArray[n + 1] ? 1 : 0;
        }
        if (n4 == 0) {
            throw new ExpressionError("Invalid 'ptrb' argument in expression");
        }
    }

    private static Model extractModel(Variable[] variableArray) {
        return variableArray == null || variableArray.length == 0 ? null : variableArray[0].getModel();
    }
}

