/*
 * Decompiled with CFR 0.152.
 */
package mosek;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import mosek.ArrayLengthException;
import mosek.DataCallback;
import mosek.Env;
import mosek.Error;
import mosek.Exception;
import mosek.ItgSolutionCallback;
import mosek.Progress;
import mosek.Stream;
import mosek.boundkey;
import mosek.compresstype;
import mosek.conetype;
import mosek.dataformat;
import mosek.dinfitem;
import mosek.domaintype;
import mosek.dparam;
import mosek.iinfitem;
import mosek.inftype;
import mosek.iparam;
import mosek.liinfitem;
import mosek.mark;
import mosek.nametype;
import mosek.objsense;
import mosek.parametertype;
import mosek.problemtype;
import mosek.prosta;
import mosek.rescode;
import mosek.solitem;
import mosek.solsta;
import mosek.soltype;
import mosek.sparam;
import mosek.stakey;
import mosek.streamtype;
import mosek.symmattype;
import mosek.variabletype;

public final class Task
implements Closeable {
    long native_task;
    private int cbsattached;
    private Progress progress;
    private DataCallback datacallback;
    private ItgSolutionCallback itgsolcallback;
    private Stream[] stream;

    private native void attachStream(long var1, int var3);

    private native void detachStream(long var1, int var3);

    private native void attachProgress(long var1);

    private native void detachProgress(long var1);

    private native void p_writedatastream(long var1, int var3, int var4, OutputStream var5);

    private void stream_func(int n, String string) {
        if (n < this.stream.length && this.stream[n] != null) {
            this.stream[n].print(string);
        }
    }

    public synchronized void set_Progress(Progress progress) {
        if (this.progress != null) {
            this.progress = progress;
            if (this.progress == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.progress = progress;
            if (this.progress != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    @Deprecated
    public synchronized void set_Progress(DataCallback dataCallback) {
        this.set_InfoCallback(dataCallback);
    }

    public synchronized void set_InfoCallback(DataCallback dataCallback) {
        if (this.datacallback != null) {
            this.datacallback = dataCallback;
            if (this.datacallback == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.datacallback = dataCallback;
            if (this.datacallback != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    public synchronized void set_ItgSolutionCallback(ItgSolutionCallback itgSolutionCallback) {
        if (this.itgsolcallback != null) {
            this.itgsolcallback = itgSolutionCallback;
            if (this.itgsolcallback == null) {
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        } else {
            this.itgsolcallback = itgSolutionCallback;
            if (this.itgsolcallback != null) {
                ++this.cbsattached;
            }
            if (this.cbsattached == 1) {
                this.attachProgress(this.native_task);
            }
        }
    }

    public synchronized void unset_Progress() {
        if (this.progress != null || this.datacallback != null) {
            if (this.progress != null) {
                this.progress = null;
                --this.cbsattached;
            }
            if (this.datacallback != null) {
                this.datacallback = null;
                --this.cbsattached;
            }
            if (this.cbsattached == 0) {
                this.detachProgress(this.native_task);
            }
        }
    }

    public synchronized void set_Stream(streamtype streamtype2, Stream stream) {
        int n = streamtype2.getValue();
        this.detachStream(this.native_task, n);
        if (this.stream[n] != null) {
            this.stream[n] = null;
        }
        if (stream != null) {
            this.stream[n] = stream;
            this.attachStream(this.native_task, n);
        }
    }

    public synchronized void writedatastream(dataformat dataformat2, compresstype compresstype2, OutputStream outputStream) {
        this.p_writedatastream(this.native_task, dataformat2.value, compresstype2.value, outputStream);
    }

    private native long p_createTask(Env var1, int var2, int var3);

    private native void p_deleteTask(long var1);

    private native long p_cloneTask(long var1);

    public Task(Env env, int n, int n2) {
        this.native_task = this.p_createTask(env, n, n2);
        this.stream = new Stream[4];
        this.progress = null;
    }

    public Task(int n, int n2) {
        this(null, n, n2);
    }

    public Task(Env env) {
        this(env, 0, 0);
    }

    public Task() {
        this(null, 0, 0);
    }

    private Task(long l) {
        this.native_task = l;
        this.stream = new Stream[4];
        this.progress = null;
    }

    public Task(Task task) {
        this.native_task = this.p_cloneTask(task.native_task);
        this.stream = new Stream[4];
        this.progress = null;
    }

    protected synchronized void finalize() {
        if (this.native_task != 0L) {
            this.cleanup();
            this.p_deleteTask(this.native_task);
            this.native_task = 0L;
        }
    }

    public synchronized void cleanup() {
        try {
            this.unset_Progress();
            for (streamtype streamtype2 : streamtype.values()) {
                this.set_Stream(streamtype2, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.finalize();
    }

    private native void p_putvarnamelist(long var1, int var3, IntBuffer var4, LongBuffer var5, ByteBuffer var6);

    public synchronized void putvarnamelist(int[] nArray, String[] stringArray) {
        int n = nArray.length < stringArray.length ? nArray.length : stringArray.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(nArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((n + 1) * 8);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        LongBuffer longBuffer = byteBuffer2.asLongBuffer();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            try {
                byArrayArray[i] = stringArray[i].getBytes("UTF-8");
                n2 += byArrayArray[i].length;
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        longBuffer.put(0, 0L);
        ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(n2 += n);
        for (int i = 0; i < n; ++i) {
            if (byArrayArray[i] != null) {
                byteBuffer3.put(byArrayArray[i]);
            }
            byteBuffer3.put((byte)0);
            longBuffer.put(i + 1, byteBuffer3.position());
        }
        this.p_putvarnamelist(this.native_task, n, intBuffer, longBuffer, byteBuffer3);
    }

    private native void p_analyzenames(long var1, int var3, int var4);

    private native void p_analyzeproblem(long var1, int var3);

    private native void p_analyzesolution(long var1, int var3, int var4);

    private native void p_appendacc(long var1, long var3, long var5, long[] var7, double[] var8);

    private native void p_appendaccs(long var1, long var3, long[] var5, long var6, long[] var8, double[] var9);

    private native void p_appendaccseq(long var1, long var3, long var5, long var7, double[] var9);

    private native void p_appendaccsseq(long var1, long var3, long[] var5, long var6, long var8, double[] var10);

    private native void p_appendafes(long var1, long var3);

    private native void p_appendbarvars(long var1, int var3, int[] var4);

    private native void p_appendcone(long var1, int var3, double var4, int var6, int[] var7);

    private native void p_appendconeseq(long var1, int var3, double var4, int var6, int var7);

    private native void p_appendconesseq(long var1, int var3, int[] var4, double[] var5, int[] var6, int var7);

    private native void p_appendcons(long var1, int var3);

    private native void p_appenddjcs(long var1, long var3);

    private native void p_appenddualexpconedomain(long var1, long[] var3);

    private native void p_appenddualgeomeanconedomain(long var1, long var3, long[] var5);

    private native void p_appenddualpowerconedomain(long var1, long var3, long var5, double[] var7, long[] var8);

    private native void p_appenddualpowerconedomainseq(long var1, long var3, long[] var5, long[] var6, double[] var7, long[] var8);

    private native void p_appendprimalexpconedomain(long var1, long[] var3);

    private native void p_appendprimalgeomeanconedomain(long var1, long var3, long[] var5);

    private native void p_appendprimalpowerconedomain(long var1, long var3, long var5, double[] var7, long[] var8);

    private native void p_appendprimalpowerconedomainseq(long var1, long var3, long[] var5, long[] var6, double[] var7, long[] var8);

    private native void p_appendquadraticconedomain(long var1, long var3, long[] var5);

    private native void p_appendrdomain(long var1, long var3, long[] var5);

    private native void p_appendrminusdomain(long var1, long var3, long[] var5);

    private native void p_appendrplusdomain(long var1, long var3, long[] var5);

    private native void p_appendrquadraticconedomain(long var1, long var3, long[] var5);

    private native void p_appendrzerodomain(long var1, long var3, long[] var5);

    private native void p_appendsparsesymmat(long var1, int var3, long var4, int[] var6, int[] var7, double[] var8, long[] var9);

    private native void p_appendsparsesymmatlist(long var1, int var3, int[] var4, long[] var5, int[] var6, int[] var7, double[] var8, long[] var9);

    private native void p_appendsvecpsdconedomain(long var1, long var3, long[] var5);

    private native void p_appendvars(long var1, int var3);

    private native void p_asyncgetresult(long var1, String var3, String var4, String var5, boolean[] var6, int[] var7, int[] var8);

    private native void p_asyncoptimize(long var1, String var3, String var4, byte[] var5);

    private native void p_asyncpoll(long var1, String var3, String var4, String var5, boolean[] var6, int[] var7, int[] var8);

    private native void p_asyncstop(long var1, String var3, String var4, String var5);

    private native void p_basiscond(long var1, double[] var3, double[] var4);

    private native void p_checkmemtask(long var1, String var3, int var4);

    private native void p_chgconbound(long var1, int var3, int var4, int var5, double var6);

    private native void p_chgvarbound(long var1, int var3, int var4, int var5, double var6);

    private native void p_commitchanges(long var1);

    private native void p_deletesolution(long var1, int var3);

    private native void p_dualsensitivity(long var1, int var3, int[] var4, double[] var5, double[] var6, double[] var7, double[] var8);

    private native void p_emptyafebarfrow(long var1, long var3);

    private native void p_emptyafebarfrowlist(long var1, long var3, long[] var5);

    private native void p_emptyafefcol(long var1, int var3);

    private native void p_emptyafefcollist(long var1, long var3, int[] var5);

    private native void p_emptyafefrow(long var1, long var3);

    private native void p_emptyafefrowlist(long var1, long var3, long[] var5);

    private native void p_evaluateacc(long var1, int var3, long var4, double[] var6);

    private native void p_evaluateaccs(long var1, int var3, double[] var4);

    private native void p_generateaccnames(long var1, long var3, long[] var5, String var6, int var7, int[] var8, long[] var9, int var10, int[] var11, long var12, String[] var14);

    private native void p_generatebarvarnames(long var1, int var3, int[] var4, String var5, int var6, int[] var7, long[] var8, int var9, int[] var10, long var11, String[] var13);

    private native void p_generateconenames(long var1, int var3, int[] var4, String var5, int var6, int[] var7, long[] var8, int var9, int[] var10, long var11, String[] var13);

    private native void p_generateconnames(long var1, int var3, int[] var4, String var5, int var6, int[] var7, long[] var8, int var9, int[] var10, long var11, String[] var13);

    private native void p_generatedjcnames(long var1, long var3, long[] var5, String var6, int var7, int[] var8, long[] var9, int var10, int[] var11, long var12, String[] var14);

    private native void p_generatevarnames(long var1, int var3, int[] var4, String var5, int var6, int[] var7, long[] var8, int var9, int[] var10, long var11, String[] var13);

    private native void p_getaccafeidxlist(long var1, long var3, long[] var5);

    private native void p_getaccb(long var1, long var3, double[] var5);

    private native void p_getaccbarfblocktriplet(long var1, long var3, long[] var5, long[] var6, int[] var7, int[] var8, int[] var9, double[] var10);

    private native void p_getaccbarfnumblocktriplets(long var1, long[] var3);

    private native void p_getaccdomain(long var1, long var3, long[] var5);

    private native void p_getaccdoty(long var1, int var3, long var4, double[] var6);

    private native void p_getaccdotys(long var1, int var3, double[] var4);

    private native void p_getaccfnumnz(long var1, long[] var3);

    private native void p_getaccftrip(long var1, long[] var3, int[] var4, double[] var5);

    private native void p_getaccgvector(long var1, double[] var3);

    private native void p_getaccn(long var1, long var3, long[] var5);

    private native void p_getaccname(long var1, long var3, int var5, byte[] var6);

    private native void p_getaccnamelen(long var1, long var3, int[] var5);

    private native void p_getaccntot(long var1, long[] var3);

    private native void p_getaccs(long var1, long[] var3, long[] var4, double[] var5);

    private native void p_getacol(long var1, int var3, int[] var4, int[] var5, double[] var6);

    private native void p_getacolnumnz(long var1, int var3, int[] var4);

    private native void p_getacolslice64(long var1, int var3, int var4, long var5, long[] var7, long[] var8, int[] var9, double[] var10);

    private native void p_getacolslicenumnz64(long var1, int var3, int var4, long[] var5);

    private native void p_getacolslicetrip(long var1, int var3, int var4, long var5, int[] var7, int[] var8, double[] var9);

    private native void p_getafebarfblocktriplet(long var1, long var3, long[] var5, long[] var6, int[] var7, int[] var8, int[] var9, double[] var10);

    private native void p_getafebarfnumblocktriplets(long var1, long[] var3);

    private native void p_getafebarfnumrowentries(long var1, long var3, int[] var5);

    private native void p_getafebarfrow(long var1, long var3, int[] var5, long[] var6, long[] var7, long[] var8, double[] var9);

    private native void p_getafebarfrowinfo(long var1, long var3, int[] var5, long[] var6);

    private native void p_getafefnumnz(long var1, long[] var3);

    private native void p_getafefrow(long var1, long var3, int[] var5, int[] var6, double[] var7);

    private native void p_getafefrownumnz(long var1, long var3, int[] var5);

    private native void p_getafeftrip(long var1, long[] var3, int[] var4, double[] var5);

    private native void p_getafeg(long var1, long var3, double[] var5);

    private native void p_getafegslice(long var1, long var3, long var5, double[] var7);

    private native void p_getaij(long var1, int var3, int var4, double[] var5);

    private native void p_getapiecenumnz(long var1, int var3, int var4, int var5, int var6, int[] var7);

    private native void p_getarow(long var1, int var3, int[] var4, int[] var5, double[] var6);

    private native void p_getarownumnz(long var1, int var3, int[] var4);

    private native void p_getarowslice64(long var1, int var3, int var4, long var5, long[] var7, long[] var8, int[] var9, double[] var10);

    private native void p_getarowslicenumnz64(long var1, int var3, int var4, long[] var5);

    private native void p_getarowslicetrip(long var1, int var3, int var4, long var5, int[] var7, int[] var8, double[] var9);

    private native void p_getatrip(long var1, long var3, int[] var5, int[] var6, double[] var7);

    private native void p_getatruncatetol(long var1, double[] var3);

    private native void p_getbarablocktriplet(long var1, long var3, long[] var5, int[] var6, int[] var7, int[] var8, int[] var9, double[] var10);

    private native void p_getbaraidx(long var1, long var3, long var5, int[] var7, int[] var8, long[] var9, long[] var10, double[] var11);

    private native void p_getbaraidxij(long var1, long var3, int[] var5, int[] var6);

    private native void p_getbaraidxinfo(long var1, long var3, long[] var5);

    private native void p_getbarasparsity(long var1, long var3, long[] var5, long[] var6);

    private native void p_getbarcblocktriplet(long var1, long var3, long[] var5, int[] var6, int[] var7, int[] var8, double[] var9);

    private native void p_getbarcidx(long var1, long var3, long var5, int[] var7, long[] var8, long[] var9, double[] var10);

    private native void p_getbarcidxinfo(long var1, long var3, long[] var5);

    private native void p_getbarcidxj(long var1, long var3, int[] var5);

    private native void p_getbarcsparsity(long var1, long var3, long[] var5, long[] var6);

    private native void p_getbarsj(long var1, int var3, int var4, double[] var5);

    private native void p_getbarsslice(long var1, int var3, int var4, int var5, long var6, double[] var8);

    private native void p_getbarvarname(long var1, int var3, int var4, byte[] var5);

    private native void p_getbarvarnameindex(long var1, String var3, int[] var4, int[] var5);

    private native void p_getbarvarnamelen(long var1, int var3, int[] var4);

    private native void p_getbarxj(long var1, int var3, int var4, double[] var5);

    private native void p_getbarxslice(long var1, int var3, int var4, int var5, long var6, double[] var8);

    private native void p_getc(long var1, double[] var3);

    private native void p_getcfix(long var1, double[] var3);

    private native void p_getcj(long var1, int var3, double[] var4);

    private native void p_getclist(long var1, int var3, int[] var4, double[] var5);

    private native void p_getconbound(long var1, int var3, int[] var4, double[] var5, double[] var6);

    private native void p_getconboundslice(long var1, int var3, int var4, int[] var5, double[] var6, double[] var7);

    private native void p_getcone(long var1, int var3, int[] var4, double[] var5, int[] var6, int[] var7);

    private native void p_getconeinfo(long var1, int var3, int[] var4, double[] var5, int[] var6);

    private native void p_getconename(long var1, int var3, int var4, byte[] var5);

    private native void p_getconenameindex(long var1, String var3, int[] var4, int[] var5);

    private native void p_getconenamelen(long var1, int var3, int[] var4);

    private native void p_getconname(long var1, int var3, int var4, byte[] var5);

    private native void p_getconnameindex(long var1, String var3, int[] var4, int[] var5);

    private native void p_getconnamelen(long var1, int var3, int[] var4);

    private native void p_getcslice(long var1, int var3, int var4, double[] var5);

    private native void p_getdimbarvarj(long var1, int var3, int[] var4);

    private native void p_getdjcafeidxlist(long var1, long var3, long[] var5);

    private native void p_getdjcb(long var1, long var3, double[] var5);

    private native void p_getdjcdomainidxlist(long var1, long var3, long[] var5);

    private native void p_getdjcname(long var1, long var3, int var5, byte[] var6);

    private native void p_getdjcnamelen(long var1, long var3, int[] var5);

    private native void p_getdjcnumafe(long var1, long var3, long[] var5);

    private native void p_getdjcnumafetot(long var1, long[] var3);

    private native void p_getdjcnumdomain(long var1, long var3, long[] var5);

    private native void p_getdjcnumdomaintot(long var1, long[] var3);

    private native void p_getdjcnumterm(long var1, long var3, long[] var5);

    private native void p_getdjcnumtermtot(long var1, long[] var3);

    private native void p_getdjcs(long var1, long[] var3, long[] var4, double[] var5, long[] var6, long[] var7);

    private native void p_getdjctermsizelist(long var1, long var3, long[] var5);

    private native void p_getdomainn(long var1, long var3, long[] var5);

    private native void p_getdomainname(long var1, long var3, int var5, byte[] var6);

    private native void p_getdomainnamelen(long var1, long var3, int[] var5);

    private native void p_getdomaintype(long var1, long var3, int[] var5);

    private native void p_getdouinf(long var1, int var3, double[] var4);

    private native void p_getdouparam(long var1, int var3, double[] var4);

    private native void p_getdualobj(long var1, int var3, double[] var4);

    private native void p_getdualproblem(long var1, long[] var3);

    private native void p_getdualsolutionnorms(long var1, int var3, double[] var4, double[] var5, double[] var6, double[] var7, double[] var8, double[] var9, double[] var10);

    private native void p_getdviolacc(long var1, int var3, long var4, long[] var6, double[] var7);

    private native void p_getdviolbarvar(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getdviolcon(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getdviolcones(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getdviolvar(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getinfeasiblesubproblem(long var1, int var3, long[] var4);

    private native void p_getinfindex(long var1, int var3, String var4, int[] var5);

    private native void p_getinfmax(long var1, int var3, int[] var4);

    private native void p_getinfname(long var1, int var3, int var4, byte[] var5);

    private native void p_getintinf(long var1, int var3, int[] var4);

    private native void p_getintparam(long var1, int var3, int[] var4);

    private native void p_getlenbarvarj(long var1, int var3, long[] var4);

    private native void p_getlintinf(long var1, int var3, long[] var4);

    private native void p_getlintparam(long var1, int var3, long[] var4);

    private native void p_getmaxnumanz64(long var1, long[] var3);

    private native void p_getmaxnumbarvar(long var1, int[] var3);

    private native void p_getmaxnumcon(long var1, int[] var3);

    private native void p_getmaxnumcone(long var1, int[] var3);

    private native void p_getmaxnumqnz64(long var1, long[] var3);

    private native void p_getmaxnumvar(long var1, int[] var3);

    private native void p_getmemusagetask(long var1, long[] var3, long[] var4);

    private native void p_getmionumthreads(long var1, int[] var3);

    private native void p_getnumacc(long var1, long[] var3);

    private native void p_getnumafe(long var1, long[] var3);

    private native void p_getnumanz64(long var1, long[] var3);

    private native void p_getnumbarablocktriplets(long var1, long[] var3);

    private native void p_getnumbaranz(long var1, long[] var3);

    private native void p_getnumbarcblocktriplets(long var1, long[] var3);

    private native void p_getnumbarcnz(long var1, long[] var3);

    private native void p_getnumbarvar(long var1, int[] var3);

    private native void p_getnumcon(long var1, int[] var3);

    private native void p_getnumcone(long var1, int[] var3);

    private native void p_getnumconemem(long var1, int var3, int[] var4);

    private native void p_getnumdjc(long var1, long[] var3);

    private native void p_getnumdomain(long var1, long[] var3);

    private native void p_getnumintvar(long var1, int[] var3);

    private native void p_getnumparam(long var1, int var3, int[] var4);

    private native void p_getnumqconknz64(long var1, int var3, long[] var4);

    private native void p_getnumqobjnz64(long var1, long[] var3);

    private native void p_getnumsymmat(long var1, long[] var3);

    private native void p_getnumvar(long var1, int[] var3);

    private native void p_getobjname(long var1, int var3, byte[] var4);

    private native void p_getobjnamelen(long var1, int[] var3);

    private native void p_getobjsense(long var1, int[] var3);

    private native void p_getparammax(long var1, int var3, int[] var4);

    private native void p_getparamname(long var1, int var3, int var4, byte[] var5);

    private native void p_getpowerdomainalpha(long var1, long var3, double[] var5);

    private native void p_getpowerdomaininfo(long var1, long var3, long[] var5, long[] var6);

    private native void p_getprimalobj(long var1, int var3, double[] var4);

    private native void p_getprimalsolutionnorms(long var1, int var3, double[] var4, double[] var5, double[] var6);

    private native void p_getprobtype(long var1, int[] var3);

    private native void p_getprosta(long var1, int var3, int[] var4);

    private native void p_getpviolacc(long var1, int var3, long var4, long[] var6, double[] var7);

    private native void p_getpviolbarvar(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getpviolcon(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getpviolcones(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getpvioldjc(long var1, int var3, long var4, long[] var6, double[] var7);

    private native void p_getpviolvar(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_getqconk64(long var1, int var3, long var4, long[] var6, int[] var7, int[] var8, double[] var9);

    private native void p_getqobj64(long var1, long var3, long[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_getqobjij(long var1, int var3, int var4, double[] var5);

    private native void p_getreducedcosts(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getskc(long var1, int var3, int[] var4);

    private native void p_getskcslice(long var1, int var3, int var4, int var5, int[] var6);

    private native void p_getskn(long var1, int var3, int[] var4);

    private native void p_getskx(long var1, int var3, int[] var4);

    private native void p_getskxslice(long var1, int var3, int var4, int var5, int[] var6);

    private native void p_getslc(long var1, int var3, double[] var4);

    private native void p_getslcslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getslx(long var1, int var3, double[] var4);

    private native void p_getslxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getsnx(long var1, int var3, double[] var4);

    private native void p_getsnxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getsolsta(long var1, int var3, int[] var4);

    private native void p_getsolution(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, double[] var15, double[] var16);

    private native void p_getsolutioninfo(long var1, int var3, double[] var4, double[] var5, double[] var6, double[] var7, double[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14);

    private native void p_getsolutioninfonew(long var1, int var3, double[] var4, double[] var5, double[] var6, double[] var7, double[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, double[] var15, double[] var16, double[] var17);

    private native void p_getsolutionnew(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, double[] var15, double[] var16, double[] var17);

    private native void p_getsolutionslice(long var1, int var3, int var4, int var5, int var6, double[] var7);

    private native void p_getsparsesymmat(long var1, long var3, long var5, int[] var7, int[] var8, double[] var9);

    private native void p_getstrparam(long var1, int var3, int var4, int[] var5, byte[] var6);

    private native void p_getstrparamlen(long var1, int var3, int[] var4);

    private native void p_getsuc(long var1, int var3, double[] var4);

    private native void p_getsucslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getsux(long var1, int var3, double[] var4);

    private native void p_getsuxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getsymmatinfo(long var1, long var3, int[] var5, long[] var6, int[] var7);

    private native void p_gettaskname(long var1, int var3, byte[] var4);

    private native void p_gettasknamelen(long var1, int[] var3);

    private native void p_getvarbound(long var1, int var3, int[] var4, double[] var5, double[] var6);

    private native void p_getvarboundslice(long var1, int var3, int var4, int[] var5, double[] var6, double[] var7);

    private native void p_getvarname(long var1, int var3, int var4, byte[] var5);

    private native void p_getvarnameindex(long var1, String var3, int[] var4, int[] var5);

    private native void p_getvarnamelen(long var1, int var3, int[] var4);

    private native void p_getvartype(long var1, int var3, int[] var4);

    private native void p_getvartypelist(long var1, int var3, int[] var4, int[] var5);

    private native void p_getxc(long var1, int var3, double[] var4);

    private native void p_getxcslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_getxx(long var1, int var3, double[] var4);

    private native void p_getxxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_gety(long var1, int var3, double[] var4);

    private native void p_getyslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_infeasibilityreport(long var1, int var3, int var4);

    private native void p_initbasissolve(long var1, int[] var3);

    private native void p_inputdata(long var1, int var3, int var4, int var5, int var6, double[] var7, double var8, int[] var10, int[] var11, int[] var12, double[] var13, int[] var14, double[] var15, double[] var16, int[] var17, double[] var18, double[] var19);

    private native void p_inputdata64(long var1, int var3, int var4, int var5, int var6, double[] var7, double var8, long[] var10, long[] var11, int[] var12, double[] var13, int[] var14, double[] var15, double[] var16, int[] var17, double[] var18, double[] var19);

    private native void p_isdouparname(long var1, String var3, int[] var4);

    private native void p_isintparname(long var1, String var3, int[] var4);

    private native void p_isstrparname(long var1, String var3, int[] var4);

    private native void p_linkfiletotaskstream(long var1, int var3, String var4, int var5);

    private native void p_onesolutionsummary(long var1, int var3, int var4);

    private native void p_optimizermt(long var1, String var3, String var4, int[] var5);

    private native void p_optimizersummary(long var1, int var3);

    private native void p_optimizetrm(long var1, int[] var3);

    private native void p_primalrepair(long var1, double[] var3, double[] var4, double[] var5, double[] var6);

    private native void p_primalsensitivity(long var1, int var3, int[] var4, int[] var5, int var6, int[] var7, int[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, double[] var15, double[] var16);

    private native void p_putacc(long var1, long var3, long var5, long var7, long[] var9, double[] var10);

    private native void p_putaccb(long var1, long var3, long var5, double[] var7);

    private native void p_putaccbj(long var1, long var3, long var5, double var7);

    private native void p_putaccdoty(long var1, int var3, long var4, double[] var6);

    private native void p_putacclist(long var1, long var3, long[] var5, long[] var6, long var7, long[] var9, double[] var10);

    private native void p_putaccname(long var1, long var3, String var5);

    private native void p_putacol(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_putacollist(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_putacolslice(long var1, int var3, int var4, int[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_putacolslice64(long var1, int var3, int var4, long[] var5, long[] var6, int[] var7, double[] var8);

    private native void p_putafebarfblocktriplet(long var1, long var3, long[] var5, int[] var6, int[] var7, int[] var8, double[] var9);

    private native void p_putafebarfentry(long var1, long var3, int var5, long var6, long[] var8, double[] var9);

    private native void p_putafebarfentrylist(long var1, long var3, long[] var5, int[] var6, long[] var7, long[] var8, long var9, long[] var11, double[] var12);

    private native void p_putafebarfrow(long var1, long var3, int var5, int[] var6, long[] var7, long[] var8, long var9, long[] var11, double[] var12);

    private native void p_putafefcol(long var1, int var3, long var4, long[] var6, double[] var7);

    private native void p_putafefentry(long var1, long var3, int var5, double var6);

    private native void p_putafefentrylist(long var1, long var3, long[] var5, int[] var6, double[] var7);

    private native void p_putafefrow(long var1, long var3, int var5, int[] var6, double[] var7);

    private native void p_putafefrowlist(long var1, long var3, long[] var5, int[] var6, long[] var7, long var8, int[] var10, double[] var11);

    private native void p_putafeg(long var1, long var3, double var5);

    private native void p_putafeglist(long var1, long var3, long[] var5, double[] var6);

    private native void p_putafegslice(long var1, long var3, long var5, double[] var7);

    private native void p_putaij(long var1, int var3, int var4, double var5);

    private native void p_putaijlist64(long var1, long var3, int[] var5, int[] var6, double[] var7);

    private native void p_putarow(long var1, int var3, int var4, int[] var5, double[] var6);

    private native void p_putarowlist(long var1, int var3, int[] var4, int[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_putarowlist64(long var1, int var3, int[] var4, long[] var5, long[] var6, int[] var7, double[] var8);

    private native void p_putarowslice(long var1, int var3, int var4, int[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_putarowslice64(long var1, int var3, int var4, long[] var5, long[] var6, int[] var7, double[] var8);

    private native void p_putatruncatetol(long var1, double var3);

    private native void p_putbarablocktriplet(long var1, long var3, int[] var5, int[] var6, int[] var7, int[] var8, double[] var9);

    private native void p_putbaraij(long var1, int var3, int var4, long var5, long[] var7, double[] var8);

    private native void p_putbaraijlist(long var1, int var3, int[] var4, int[] var5, long[] var6, long[] var7, long[] var8, double[] var9);

    private native void p_putbararowlist(long var1, int var3, int[] var4, long[] var5, long[] var6, int[] var7, long[] var8, long[] var9, double[] var10);

    private native void p_putbarcblocktriplet(long var1, long var3, int[] var5, int[] var6, int[] var7, double[] var8);

    private native void p_putbarcj(long var1, int var3, long var4, long[] var6, double[] var7);

    private native void p_putbarsj(long var1, int var3, int var4, double[] var5);

    private native void p_putbarvarname(long var1, int var3, String var4);

    private native void p_putbarxj(long var1, int var3, int var4, double[] var5);

    private native void p_putcfix(long var1, double var3);

    private native void p_putcj(long var1, int var3, double var4);

    private native void p_putclist(long var1, int var3, int[] var4, double[] var5);

    private native void p_putconbound(long var1, int var3, int var4, double var5, double var7);

    private native void p_putconboundlist(long var1, int var3, int[] var4, int[] var5, double[] var6, double[] var7);

    private native void p_putconboundlistconst(long var1, int var3, int[] var4, int var5, double var6, double var8);

    private native void p_putconboundslice(long var1, int var3, int var4, int[] var5, double[] var6, double[] var7);

    private native void p_putconboundsliceconst(long var1, int var3, int var4, int var5, double var6, double var8);

    private native void p_putcone(long var1, int var3, int var4, double var5, int var7, int[] var8);

    private native void p_putconename(long var1, int var3, String var4);

    private native void p_putconname(long var1, int var3, String var4);

    private native void p_putconsolutioni(long var1, int var3, int var4, int var5, double var6, double var8, double var10);

    private native void p_putcslice(long var1, int var3, int var4, double[] var5);

    private native void p_putdjc(long var1, long var3, long var5, long[] var7, long var8, long[] var10, double[] var11, long var12, long[] var14);

    private native void p_putdjcname(long var1, long var3, String var5);

    private native void p_putdjcslice(long var1, long var3, long var5, long var7, long[] var9, long var10, long[] var12, double[] var13, long var14, long[] var16, long[] var17);

    private native void p_putdomainname(long var1, long var3, String var5);

    private native void p_putdouparam(long var1, int var3, double var4);

    private native void p_putintparam(long var1, int var3, int var4);

    private native void p_putlintparam(long var1, int var3, long var4);

    private native void p_putmaxnumacc(long var1, long var3);

    private native void p_putmaxnumafe(long var1, long var3);

    private native void p_putmaxnumanz(long var1, long var3);

    private native void p_putmaxnumbarvar(long var1, int var3);

    private native void p_putmaxnumcon(long var1, int var3);

    private native void p_putmaxnumcone(long var1, int var3);

    private native void p_putmaxnumdjc(long var1, long var3);

    private native void p_putmaxnumdomain(long var1, long var3);

    private native void p_putmaxnumqnz(long var1, long var3);

    private native void p_putmaxnumvar(long var1, int var3);

    private native void p_putnadouparam(long var1, String var3, double var4);

    private native void p_putnaintparam(long var1, String var3, int var4);

    private native void p_putnastrparam(long var1, String var3, String var4);

    private native void p_putobjname(long var1, String var3);

    private native void p_putobjsense(long var1, int var3);

    private native void p_putoptserverhost(long var1, String var3);

    private native void p_putparam(long var1, String var3, String var4);

    private native void p_putqcon(long var1, int var3, int[] var4, int[] var5, int[] var6, double[] var7);

    private native void p_putqconk(long var1, int var3, int var4, int[] var5, int[] var6, double[] var7);

    private native void p_putqobj(long var1, int var3, int[] var4, int[] var5, double[] var6);

    private native void p_putqobjij(long var1, int var3, int var4, double var5);

    private native void p_putskc(long var1, int var3, int[] var4);

    private native void p_putskcslice(long var1, int var3, int var4, int var5, int[] var6);

    private native void p_putskx(long var1, int var3, int[] var4);

    private native void p_putskxslice(long var1, int var3, int var4, int var5, int[] var6);

    private native void p_putslc(long var1, int var3, double[] var4);

    private native void p_putslcslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_putslx(long var1, int var3, double[] var4);

    private native void p_putslxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_putsnx(long var1, int var3, double[] var4);

    private native void p_putsnxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_putsolution(long var1, int var3, int[] var4, int[] var5, int[] var6, double[] var7, double[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14);

    private native void p_putsolutionnew(long var1, int var3, int[] var4, int[] var5, int[] var6, double[] var7, double[] var8, double[] var9, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14, double[] var15);

    private native void p_putsolutionyi(long var1, int var3, int var4, double var5);

    private native void p_putstrparam(long var1, int var3, String var4);

    private native void p_putsuc(long var1, int var3, double[] var4);

    private native void p_putsucslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_putsux(long var1, int var3, double[] var4);

    private native void p_putsuxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_puttaskname(long var1, String var3);

    private native void p_putvarbound(long var1, int var3, int var4, double var5, double var7);

    private native void p_putvarboundlist(long var1, int var3, int[] var4, int[] var5, double[] var6, double[] var7);

    private native void p_putvarboundlistconst(long var1, int var3, int[] var4, int var5, double var6, double var8);

    private native void p_putvarboundslice(long var1, int var3, int var4, int[] var5, double[] var6, double[] var7);

    private native void p_putvarboundsliceconst(long var1, int var3, int var4, int var5, double var6, double var8);

    private native void p_putvarname(long var1, int var3, String var4);

    private native void p_putvarsolutionj(long var1, int var3, int var4, int var5, double var6, double var8, double var10, double var12);

    private native void p_putvartype(long var1, int var3, int var4);

    private native void p_putvartypelist(long var1, int var3, int[] var4, int[] var5);

    private native void p_putxc(long var1, int var3, double[] var4);

    private native void p_putxcslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_putxx(long var1, int var3, double[] var4);

    private native void p_putxxslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_puty(long var1, int var3, double[] var4);

    private native void p_putyslice(long var1, int var3, int var4, int var5, double[] var6);

    private native void p_readbsolution(long var1, String var3, int var4);

    private native void p_readdataautoformat(long var1, String var3);

    private native void p_readdataformat(long var1, String var3, int var4, int var5);

    private native void p_readjsonsol(long var1, String var3);

    private native void p_readjsonstring(long var1, String var3);

    private native void p_readlpstring(long var1, String var3);

    private native void p_readopfstring(long var1, String var3);

    private native void p_readparamfile(long var1, String var3);

    private native void p_readptfstring(long var1, String var3);

    private native void p_readsolution(long var1, int var3, String var4);

    private native void p_readsolutionfile(long var1, String var3);

    private native void p_readsummary(long var1, int var3);

    private native void p_readtask(long var1, String var3);

    private native void p_removebarvars(long var1, int var3, int[] var4);

    private native void p_removecones(long var1, int var3, int[] var4);

    private native void p_removecons(long var1, int var3, int[] var4);

    private native void p_removevars(long var1, int var3, int[] var4);

    private native void p_resetdouparam(long var1, int var3);

    private native void p_resetintparam(long var1, int var3);

    private native void p_resetparameters(long var1);

    private native void p_resetstrparam(long var1, int var3);

    private native void p_resizetask(long var1, int var3, int var4, int var5, long var6, long var8);

    private native void p_sensitivityreport(long var1, int var3);

    private native void p_solutiondef(long var1, int var3, boolean[] var4);

    private native void p_solutionsummary(long var1, int var3);

    private native void p_solvewithbasis(long var1, boolean var3, int var4, int[] var5, double[] var6, int[] var7);

    private native void p_strtoconetype(long var1, String var3, int[] var4);

    private native void p_strtosk(long var1, String var3, int[] var4);

    private native void p_toconic(long var1);

    private native void p_updatesolutioninfo(long var1, int var3);

    private native void p_writebsolution(long var1, String var3, int var4);

    private native void p_writedata(long var1, String var3);

    private native void p_writejsonsol(long var1, String var3);

    private native void p_writeparamfile(long var1, String var3);

    private native void p_writesolution(long var1, int var3, String var4);

    private native void p_writesolutionfile(long var1, String var3);

    private native void p_writestat(long var1, String var3);

    private native void p_writetask(long var1, String var3);

    public synchronized void analyzenames(streamtype streamtype2, nametype nametype2) throws Error {
        this.p_analyzenames(this.native_task, streamtype2.getValue(), nametype2.getValue());
    }

    public synchronized void analyzeproblem(streamtype streamtype2) throws Error {
        this.p_analyzeproblem(this.native_task, streamtype2.getValue());
    }

    public synchronized void analyzesolution(streamtype streamtype2, soltype soltype2) throws Error {
        this.p_analyzesolution(this.native_task, streamtype2.getValue(), soltype2.getValue());
    }

    public synchronized void appendacc(long l, long[] lArray, double[] dArray) throws Error {
        long l2 = -1L;
        if (lArray != null) {
            if (l2 < 0L) {
                l2 = lArray.length;
            } else if (l2 != (long)lArray.length) {
                throw new ArrayLengthException("appendacc", "afeidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidxlist in appendacc is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appendacc", "b");
        }
        this.p_appendacc(this.native_task, l, l2, lArray, dArray);
    }

    public synchronized void appendaccs(long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("appendaccs", "domidxs");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument domidxs in appendaccs is null");
        }
        long l2 = -1L;
        if (lArray2 != null) {
            if (l2 < 0L) {
                l2 = lArray2.length;
            } else if (l2 != (long)lArray2.length) {
                throw new ArrayLengthException("appendaccs", "afeidxlist");
            }
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidxlist in appendaccs is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appendaccs", "b");
        }
        this.p_appendaccs(this.native_task, l, lArray, l2, lArray2, dArray);
    }

    public synchronized void appendaccseq(long l, long l2, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getdomainn(this.native_task, l, lArray);
        long l3 = lArray[0];
        if (dArray != null && (long)dArray.length < l3) {
            throw new ArrayLengthException("appendaccseq", "b");
        }
        this.p_appendaccseq(this.native_task, l, l3, l2, dArray);
    }

    public synchronized void appendaccsseq(long[] lArray, long l, long l2, double[] dArray) throws Error {
        long l3 = -1L;
        if (lArray != null) {
            if (l3 < 0L) {
                l3 = lArray.length;
            } else if (l3 != (long)lArray.length) {
                throw new ArrayLengthException("appendaccsseq", "domidxs");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument domidxs in appendaccsseq is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("appendaccsseq", "b");
        }
        this.p_appendaccsseq(this.native_task, l3, lArray, l, l2, dArray);
    }

    public synchronized void appendafes(long l) throws Error {
        this.p_appendafes(this.native_task, l);
    }

    public synchronized void appendbarvars(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("appendbarvars", "dim");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument dim in appendbarvars is null");
        }
        this.p_appendbarvars(this.native_task, n, nArray);
    }

    public synchronized void appendcone(conetype conetype2, double d, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("appendcone", "submem");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument submem in appendcone is null");
        }
        this.p_appendcone(this.native_task, conetype2.getValue(), d, n, nArray);
    }

    public synchronized void appendconeseq(conetype conetype2, double d, int n, int n2) throws Error {
        this.p_appendconeseq(this.native_task, conetype2.getValue(), d, n, n2);
    }

    public synchronized void appendconesseq(conetype[] conetypeArray, double[] dArray, int[] nArray, int n) throws Error {
        int n2 = -1;
        if (conetypeArray != null) {
            if (n2 < 0) {
                n2 = conetypeArray.length;
            } else if (n2 != conetypeArray.length) {
                throw new ArrayLengthException("appendconesseq", "ct");
            }
        }
        if (dArray != null) {
            if (n2 < 0) {
                n2 = dArray.length;
            } else if (n2 != dArray.length) {
                throw new ArrayLengthException("appendconesseq", "conepar");
            }
        }
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("appendconesseq", "nummem");
            }
        }
        if (conetypeArray == null) {
            throw new NullPointerException("Argument ct in appendconesseq is null");
        }
        int[] nArray2 = null;
        if (conetypeArray != null) {
            nArray2 = new int[conetypeArray.length];
            for (int i = 0; i < conetypeArray.length; ++i) {
                nArray2[i] = conetypeArray[i].getValue();
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument conepar in appendconesseq is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument nummem in appendconesseq is null");
        }
        this.p_appendconesseq(this.native_task, n2, nArray2, dArray, nArray, n);
    }

    public synchronized void appendcons(int n) throws Error {
        this.p_appendcons(this.native_task, n);
    }

    public synchronized void appenddjcs(long l) throws Error {
        this.p_appenddjcs(this.native_task, l);
    }

    public synchronized void appenddualexpconedomain(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appenddualexpconedomain", "domidx");
        }
        this.p_appenddualexpconedomain(this.native_task, lArray2);
    }

    public synchronized long appenddualexpconedomain() throws Error {
        long[] lArray = new long[1];
        this.p_appenddualexpconedomain(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void appenddualgeomeanconedomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appenddualgeomeanconedomain", "domidx");
        }
        this.p_appenddualgeomeanconedomain(this.native_task, l, lArray2);
    }

    public synchronized long appenddualgeomeanconedomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appenddualgeomeanconedomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appenddualpowerconedomain(long l, double[] dArray, long[] lArray) throws Error {
        long l2 = -1L;
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("appenddualpowerconedomain", "alpha");
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appenddualpowerconedomain is null");
        }
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appenddualpowerconedomain", "domidx");
        }
        this.p_appenddualpowerconedomain(this.native_task, l, l2, dArray, lArray2);
    }

    public synchronized long appenddualpowerconedomain(long l, double[] dArray) throws Error {
        long l2 = -1L;
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("appenddualpowerconedomain", "alpha");
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appenddualpowerconedomain is null");
        }
        long[] lArray = new long[1];
        this.p_appenddualpowerconedomain(this.native_task, l, l2, dArray, lArray);
        return lArray[0];
    }

    public synchronized void appenddualpowerconedomainseq(long[] lArray, long[] lArray2, double[] dArray, long[] lArray3) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("appenddualpowerconedomainseq", "n");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("appenddualpowerconedomainseq", "nleft");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument n in appenddualpowerconedomainseq is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument nleft in appenddualpowerconedomainseq is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appenddualpowerconedomainseq is null");
        }
        long l2 = 0L;
        for (long l3 : lArray2) {
            l2 += l3;
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appenddualpowerconedomainseq", "alpha");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument domidxlist in appenddualpowerconedomainseq is null");
        }
        if (lArray3 != null && (long)lArray3.length < l) {
            throw new ArrayLengthException("appenddualpowerconedomainseq", "domidxlist");
        }
        this.p_appenddualpowerconedomainseq(this.native_task, l, lArray, lArray2, dArray, lArray3);
    }

    public synchronized long[] appenddualpowerconedomainseq(long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("appenddualpowerconedomainseq", "n");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("appenddualpowerconedomainseq", "nleft");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument n in appenddualpowerconedomainseq is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument nleft in appenddualpowerconedomainseq is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appenddualpowerconedomainseq is null");
        }
        long l2 = 0L;
        for (long l3 : lArray2) {
            l2 += l3;
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appenddualpowerconedomainseq", "alpha");
        }
        long[] lArray3 = new long[(int)l];
        this.p_appenddualpowerconedomainseq(this.native_task, l, lArray, lArray2, dArray, lArray3);
        return lArray3;
    }

    public synchronized void appendprimalexpconedomain(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendprimalexpconedomain", "domidx");
        }
        this.p_appendprimalexpconedomain(this.native_task, lArray2);
    }

    public synchronized long appendprimalexpconedomain() throws Error {
        long[] lArray = new long[1];
        this.p_appendprimalexpconedomain(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void appendprimalgeomeanconedomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendprimalgeomeanconedomain", "domidx");
        }
        this.p_appendprimalgeomeanconedomain(this.native_task, l, lArray2);
    }

    public synchronized long appendprimalgeomeanconedomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendprimalgeomeanconedomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendprimalpowerconedomain(long l, double[] dArray, long[] lArray) throws Error {
        long l2 = -1L;
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("appendprimalpowerconedomain", "alpha");
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appendprimalpowerconedomain is null");
        }
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendprimalpowerconedomain", "domidx");
        }
        this.p_appendprimalpowerconedomain(this.native_task, l, l2, dArray, lArray2);
    }

    public synchronized long appendprimalpowerconedomain(long l, double[] dArray) throws Error {
        long l2 = -1L;
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("appendprimalpowerconedomain", "alpha");
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appendprimalpowerconedomain is null");
        }
        long[] lArray = new long[1];
        this.p_appendprimalpowerconedomain(this.native_task, l, l2, dArray, lArray);
        return lArray[0];
    }

    public synchronized void appendprimalpowerconedomainseq(long[] lArray, long[] lArray2, double[] dArray, long[] lArray3) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("appendprimalpowerconedomainseq", "n");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("appendprimalpowerconedomainseq", "nleft");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument n in appendprimalpowerconedomainseq is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument nleft in appendprimalpowerconedomainseq is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appendprimalpowerconedomainseq is null");
        }
        long l2 = 0L;
        for (long l3 : lArray2) {
            l2 += l3;
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appendprimalpowerconedomainseq", "alpha");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument domidxlist in appendprimalpowerconedomainseq is null");
        }
        if (lArray3 != null && (long)lArray3.length < l) {
            throw new ArrayLengthException("appendprimalpowerconedomainseq", "domidxlist");
        }
        this.p_appendprimalpowerconedomainseq(this.native_task, l, lArray, lArray2, dArray, lArray3);
    }

    public synchronized long[] appendprimalpowerconedomainseq(long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("appendprimalpowerconedomainseq", "n");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("appendprimalpowerconedomainseq", "nleft");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument n in appendprimalpowerconedomainseq is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument nleft in appendprimalpowerconedomainseq is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in appendprimalpowerconedomainseq is null");
        }
        long l2 = 0L;
        for (long l3 : lArray2) {
            l2 += l3;
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("appendprimalpowerconedomainseq", "alpha");
        }
        long[] lArray3 = new long[(int)l];
        this.p_appendprimalpowerconedomainseq(this.native_task, l, lArray, lArray2, dArray, lArray3);
        return lArray3;
    }

    public synchronized void appendquadraticconedomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendquadraticconedomain", "domidx");
        }
        this.p_appendquadraticconedomain(this.native_task, l, lArray2);
    }

    public synchronized long appendquadraticconedomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendquadraticconedomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendrdomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendrdomain", "domidx");
        }
        this.p_appendrdomain(this.native_task, l, lArray2);
    }

    public synchronized long appendrdomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendrdomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendrminusdomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendrminusdomain", "domidx");
        }
        this.p_appendrminusdomain(this.native_task, l, lArray2);
    }

    public synchronized long appendrminusdomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendrminusdomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendrplusdomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendrplusdomain", "domidx");
        }
        this.p_appendrplusdomain(this.native_task, l, lArray2);
    }

    public synchronized long appendrplusdomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendrplusdomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendrquadraticconedomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendrquadraticconedomain", "domidx");
        }
        this.p_appendrquadraticconedomain(this.native_task, l, lArray2);
    }

    public synchronized long appendrquadraticconedomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendrquadraticconedomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendrzerodomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendrzerodomain", "domidx");
        }
        this.p_appendrzerodomain(this.native_task, l, lArray2);
    }

    public synchronized long appendrzerodomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendrzerodomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendsparsesymmat(int n, int[] nArray, int[] nArray2, double[] dArray, long[] lArray) throws Error {
        long l = -1L;
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("appendsparsesymmat", "subi");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("appendsparsesymmat", "subj");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("appendsparsesymmat", "valij");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in appendsparsesymmat is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in appendsparsesymmat is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij in appendsparsesymmat is null");
        }
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendsparsesymmat", "idx");
        }
        this.p_appendsparsesymmat(this.native_task, n, l, nArray, nArray2, dArray, lArray2);
    }

    public synchronized long appendsparsesymmat(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long l = -1L;
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("appendsparsesymmat", "subi");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("appendsparsesymmat", "subj");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("appendsparsesymmat", "valij");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in appendsparsesymmat is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in appendsparsesymmat is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij in appendsparsesymmat is null");
        }
        long[] lArray = new long[1];
        this.p_appendsparsesymmat(this.native_task, n, l, nArray, nArray2, dArray, lArray);
        return lArray[0];
    }

    public synchronized void appendsparsesymmatlist(int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, double[] dArray, long[] lArray2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("appendsparsesymmatlist", "dims");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("appendsparsesymmatlist", "nz");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument dims in appendsparsesymmatlist is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument nz in appendsparsesymmatlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subi in appendsparsesymmatlist is null");
        }
        long l = 0L;
        for (long l2 : lArray) {
            l += l2;
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("appendsparsesymmatlist", "subi");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subj in appendsparsesymmatlist is null");
        }
        long l3 = 0L;
        for (long l4 : lArray) {
            l3 += l4;
        }
        if (nArray3 != null && (long)nArray3.length < l3) {
            throw new ArrayLengthException("appendsparsesymmatlist", "subj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij in appendsparsesymmatlist is null");
        }
        long l5 = 0L;
        for (long l6 : lArray) {
            l5 += l6;
        }
        if (dArray != null && (long)dArray.length < l5) {
            throw new ArrayLengthException("appendsparsesymmatlist", "valij");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument idx in appendsparsesymmatlist is null");
        }
        if (lArray2 != null && lArray2.length < n) {
            throw new ArrayLengthException("appendsparsesymmatlist", "idx");
        }
        this.p_appendsparsesymmatlist(this.native_task, n, nArray, lArray, nArray2, nArray3, dArray, lArray2);
    }

    public synchronized long[] appendsparsesymmatlist(int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("appendsparsesymmatlist", "dims");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("appendsparsesymmatlist", "nz");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument dims in appendsparsesymmatlist is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument nz in appendsparsesymmatlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subi in appendsparsesymmatlist is null");
        }
        long l = 0L;
        for (long l2 : lArray) {
            l += l2;
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("appendsparsesymmatlist", "subi");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subj in appendsparsesymmatlist is null");
        }
        long l3 = 0L;
        for (long l4 : lArray) {
            l3 += l4;
        }
        if (nArray3 != null && (long)nArray3.length < l3) {
            throw new ArrayLengthException("appendsparsesymmatlist", "subj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij in appendsparsesymmatlist is null");
        }
        long l5 = 0L;
        for (long l6 : lArray) {
            l5 += l6;
        }
        if (dArray != null && (long)dArray.length < l5) {
            throw new ArrayLengthException("appendsparsesymmatlist", "valij");
        }
        long[] lArray2 = new long[n];
        this.p_appendsparsesymmatlist(this.native_task, n, nArray, lArray, nArray2, nArray3, dArray, lArray2);
        return lArray2;
    }

    public synchronized void appendsvecpsdconedomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("appendsvecpsdconedomain", "domidx");
        }
        this.p_appendsvecpsdconedomain(this.native_task, l, lArray2);
    }

    public synchronized long appendsvecpsdconedomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_appendsvecpsdconedomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void appendvars(int n) throws Error {
        this.p_appendvars(this.native_task, n);
    }

    public synchronized void asyncgetresult(String string, String string2, String string3, boolean[] blArray, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        boolean[] blArray2 = blArray;
        if (blArray.length != 1) {
            throw new ArrayLengthException("asyncgetresult", "respavailable");
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.p_asyncgetresult(this.native_task, string, string2, string3, blArray2, nArray, nArray2);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
        rescodeArray2[0] = rescode.fromValue(nArray2[0]);
    }

    public synchronized boolean asyncgetresult(String string, String string2, String string3, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.p_asyncgetresult(this.native_task, string, string2, string3, blArray, nArray, nArray2);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
        rescodeArray2[0] = rescode.fromValue(nArray2[0]);
        return blArray[0];
    }

    public synchronized String asyncoptimize(String string, String string2) throws Error {
        int n;
        byte[] byArray = new byte[65];
        this.p_asyncoptimize(this.native_task, string, string2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string3 = null;
        try {
            string3 = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string3;
    }

    public synchronized void asyncpoll(String string, String string2, String string3, boolean[] blArray, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        boolean[] blArray2 = blArray;
        if (blArray.length != 1) {
            throw new ArrayLengthException("asyncpoll", "respavailable");
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.p_asyncpoll(this.native_task, string, string2, string3, blArray2, nArray, nArray2);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
        rescodeArray2[0] = rescode.fromValue(nArray2[0]);
    }

    public synchronized boolean asyncpoll(String string, String string2, String string3, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.p_asyncpoll(this.native_task, string, string2, string3, blArray, nArray, nArray2);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
        rescodeArray2[0] = rescode.fromValue(nArray2[0]);
        return blArray[0];
    }

    public synchronized void asyncstop(String string, String string2, String string3) throws Error {
        this.p_asyncstop(this.native_task, string, string2, string3);
    }

    public synchronized void basiscond(double[] dArray, double[] dArray2) throws Error {
        double[] dArray3 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("basiscond", "nrmbasis");
        }
        double[] dArray4 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("basiscond", "nrminvbasis");
        }
        this.p_basiscond(this.native_task, dArray3, dArray4);
    }

    public synchronized void checkmem(String string, int n) throws Error {
        this.p_checkmemtask(this.native_task, string, n);
    }

    public synchronized void chgconbound(int n, int n2, int n3, double d) throws Error {
        this.p_chgconbound(this.native_task, n, n2, n3, d);
    }

    public synchronized void chgvarbound(int n, int n2, int n3, double d) throws Error {
        this.p_chgvarbound(this.native_task, n, n2, n3, d);
    }

    public synchronized void commitchanges() throws Error {
        this.p_commitchanges(this.native_task);
    }

    public synchronized void deletesolution(soltype soltype2) throws Error {
        this.p_deletesolution(this.native_task, soltype2.getValue());
    }

    public synchronized void dualsensitivity(int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("dualsensitivity", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in dualsensitivity is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("dualsensitivity", "leftpricej");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("dualsensitivity", "rightpricej");
        }
        if (dArray3 != null && dArray3.length < n) {
            throw new ArrayLengthException("dualsensitivity", "leftrangej");
        }
        if (dArray4 != null && dArray4.length < n) {
            throw new ArrayLengthException("dualsensitivity", "rightrangej");
        }
        this.p_dualsensitivity(this.native_task, n, nArray, dArray, dArray2, dArray3, dArray4);
    }

    public synchronized void emptyafebarfrow(long l) throws Error {
        this.p_emptyafebarfrow(this.native_task, l);
    }

    public synchronized void emptyafebarfrowlist(long[] lArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("emptyafebarfrowlist", "afeidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidxlist in emptyafebarfrowlist is null");
        }
        this.p_emptyafebarfrowlist(this.native_task, l, lArray);
    }

    public synchronized void emptyafefcol(int n) throws Error {
        this.p_emptyafefcol(this.native_task, n);
    }

    public synchronized void emptyafefcollist(int[] nArray) throws Error {
        long l = -1L;
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("emptyafefcollist", "varidx");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument varidx in emptyafefcollist is null");
        }
        this.p_emptyafefcollist(this.native_task, l, nArray);
    }

    public synchronized void emptyafefrow(long l) throws Error {
        this.p_emptyafefrow(this.native_task, l);
    }

    public synchronized void emptyafefrowlist(long[] lArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("emptyafefrowlist", "afeidx");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in emptyafefrowlist is null");
        }
        this.p_emptyafefrowlist(this.native_task, l, lArray);
    }

    public synchronized void evaluateacc(soltype soltype2, long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument activity in evaluateacc is null");
        }
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("evaluateacc", "activity");
        }
        this.p_evaluateacc(this.native_task, soltype2.getValue(), l, dArray);
    }

    public synchronized double[] evaluateacc(soltype soltype2, long l) throws Error {
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_evaluateacc(this.native_task, soltype2.getValue(), l, dArray);
        return dArray;
    }

    public synchronized void evaluateaccs(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument activity in evaluateaccs is null");
        }
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("evaluateaccs", "activity");
        }
        this.p_evaluateaccs(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] evaluateaccs(soltype soltype2) throws Error {
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_evaluateaccs(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void generateaccnames(long[] lArray, String string, int[] nArray, long[] lArray2, int[] nArray2, String[] stringArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("generateaccnames", "sub");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub in generateaccnames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generateaccnames is null");
        }
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generateaccnames", "dims");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument dims in generateaccnames is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("generateaccnames", "sp");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generateaccnames", "namedaxisidxs");
            }
        }
        long l2 = -1L;
        if (stringArray != null) {
            if (l2 < 0L) {
                l2 = stringArray.length;
            } else if (l2 != (long)stringArray.length) {
                throw new ArrayLengthException("generateaccnames", "names");
            }
        }
        this.p_generateaccnames(this.native_task, l, lArray, string, n, nArray, lArray2, n2, nArray2, l2, stringArray);
    }

    public synchronized void generatebarvarnames(int[] nArray, String string, int[] nArray2, long[] lArray, int[] nArray3, String[] stringArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generatebarvarnames", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in generatebarvarnames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generatebarvarnames is null");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generatebarvarnames", "dims");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument dims in generatebarvarnames is null");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("generatebarvarnames", "sp");
        }
        int n3 = -1;
        if (nArray3 != null) {
            if (n3 < 0) {
                n3 = nArray3.length;
            } else if (n3 != nArray3.length) {
                throw new ArrayLengthException("generatebarvarnames", "namedaxisidxs");
            }
        }
        long l = -1L;
        if (stringArray != null) {
            if (l < 0L) {
                l = stringArray.length;
            } else if (l != (long)stringArray.length) {
                throw new ArrayLengthException("generatebarvarnames", "names");
            }
        }
        this.p_generatebarvarnames(this.native_task, n, nArray, string, n2, nArray2, lArray, n3, nArray3, l, stringArray);
    }

    public synchronized void generateconenames(int[] nArray, String string, int[] nArray2, long[] lArray, int[] nArray3, String[] stringArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generateconenames", "subk");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subk in generateconenames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generateconenames is null");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generateconenames", "dims");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument dims in generateconenames is null");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("generateconenames", "sp");
        }
        int n3 = -1;
        if (nArray3 != null) {
            if (n3 < 0) {
                n3 = nArray3.length;
            } else if (n3 != nArray3.length) {
                throw new ArrayLengthException("generateconenames", "namedaxisidxs");
            }
        }
        long l = -1L;
        if (stringArray != null) {
            if (l < 0L) {
                l = stringArray.length;
            } else if (l != (long)stringArray.length) {
                throw new ArrayLengthException("generateconenames", "names");
            }
        }
        this.p_generateconenames(this.native_task, n, nArray, string, n2, nArray2, lArray, n3, nArray3, l, stringArray);
    }

    public synchronized void generateconnames(int[] nArray, String string, int[] nArray2, long[] lArray, int[] nArray3, String[] stringArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generateconnames", "subi");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in generateconnames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generateconnames is null");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generateconnames", "dims");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument dims in generateconnames is null");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("generateconnames", "sp");
        }
        int n3 = -1;
        if (nArray3 != null) {
            if (n3 < 0) {
                n3 = nArray3.length;
            } else if (n3 != nArray3.length) {
                throw new ArrayLengthException("generateconnames", "namedaxisidxs");
            }
        }
        long l = -1L;
        if (stringArray != null) {
            if (l < 0L) {
                l = stringArray.length;
            } else if (l != (long)stringArray.length) {
                throw new ArrayLengthException("generateconnames", "names");
            }
        }
        this.p_generateconnames(this.native_task, n, nArray, string, n2, nArray2, lArray, n3, nArray3, l, stringArray);
    }

    public synchronized void generatedjcnames(long[] lArray, String string, int[] nArray, long[] lArray2, int[] nArray2, String[] stringArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("generatedjcnames", "sub");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub in generatedjcnames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generatedjcnames is null");
        }
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generatedjcnames", "dims");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument dims in generatedjcnames is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("generatedjcnames", "sp");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generatedjcnames", "namedaxisidxs");
            }
        }
        long l2 = -1L;
        if (stringArray != null) {
            if (l2 < 0L) {
                l2 = stringArray.length;
            } else if (l2 != (long)stringArray.length) {
                throw new ArrayLengthException("generatedjcnames", "names");
            }
        }
        this.p_generatedjcnames(this.native_task, l, lArray, string, n, nArray, lArray2, n2, nArray2, l2, stringArray);
    }

    public synchronized void generatevarnames(int[] nArray, String string, int[] nArray2, long[] lArray, int[] nArray3, String[] stringArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("generatevarnames", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in generatevarnames is null");
        }
        if (string == null) {
            throw new NullPointerException("Argument fmt in generatevarnames is null");
        }
        int n2 = -1;
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("generatevarnames", "dims");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument dims in generatevarnames is null");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("generatevarnames", "sp");
        }
        int n3 = -1;
        if (nArray3 != null) {
            if (n3 < 0) {
                n3 = nArray3.length;
            } else if (n3 != nArray3.length) {
                throw new ArrayLengthException("generatevarnames", "namedaxisidxs");
            }
        }
        long l = -1L;
        if (stringArray != null) {
            if (l < 0L) {
                l = stringArray.length;
            } else if (l != (long)stringArray.length) {
                throw new ArrayLengthException("generatevarnames", "names");
            }
        }
        this.p_generatevarnames(this.native_task, n, nArray, string, n2, nArray2, lArray, n3, nArray3, l, stringArray);
    }

    public synchronized void getaccafeidxlist(long l, long[] lArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument afeidxlist in getaccafeidxlist is null");
        }
        long[] lArray2 = new long[1];
        this.p_getaccn(this.native_task, l, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getaccafeidxlist", "afeidxlist");
        }
        this.p_getaccafeidxlist(this.native_task, l, lArray);
    }

    public synchronized void getaccb(long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument b in getaccb is null");
        }
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getaccb", "b");
        }
        this.p_getaccb(this.native_task, l, dArray);
    }

    public synchronized double[] getaccb(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getaccb(this.native_task, l, dArray);
        return dArray;
    }

    public synchronized void getaccbarfblocktriplet(long[] lArray, long[] lArray2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getaccbarfnumblocktriplets(this.native_task, lArray3);
        long l = lArray3[0];
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "numtrip");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument acc_afe in getaccbarfblocktriplet is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "acc_afe");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument bar_var in getaccbarfblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "bar_var");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument blk_row in getaccbarfblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_row");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument blk_col in getaccbarfblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_col");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blk_val in getaccbarfblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_val");
        }
        this.p_getaccbarfblocktriplet(this.native_task, l, lArray4, lArray2, nArray, nArray2, nArray3, dArray);
    }

    public synchronized long getaccbarfblocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getaccbarfnumblocktriplets(this.native_task, lArray2);
        long l = lArray2[0];
        long[] lArray3 = new long[1];
        if (lArray == null) {
            throw new NullPointerException("Argument acc_afe in getaccbarfblocktriplet is null");
        }
        if (lArray != null && (long)lArray.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "acc_afe");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument bar_var in getaccbarfblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "bar_var");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument blk_row in getaccbarfblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_row");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument blk_col in getaccbarfblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_col");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blk_val in getaccbarfblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getaccbarfblocktriplet", "blk_val");
        }
        this.p_getaccbarfblocktriplet(this.native_task, l, lArray3, lArray, nArray, nArray2, nArray3, dArray);
        return lArray3[0];
    }

    public synchronized void getaccbarfnumblocktriplets(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccbarfnumblocktriplets", "numtrip");
        }
        this.p_getaccbarfnumblocktriplets(this.native_task, lArray2);
    }

    public synchronized long getaccbarfnumblocktriplets() throws Error {
        long[] lArray = new long[1];
        this.p_getaccbarfnumblocktriplets(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getaccdomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccdomain", "domidx");
        }
        this.p_getaccdomain(this.native_task, l, lArray2);
    }

    public synchronized long getaccdomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getaccdomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getaccdoty(soltype soltype2, long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument doty in getaccdoty is null");
        }
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getaccdoty", "doty");
        }
        this.p_getaccdoty(this.native_task, soltype2.getValue(), l, dArray);
    }

    public synchronized double[] getaccdoty(soltype soltype2, long l) throws Error {
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getaccdoty(this.native_task, soltype2.getValue(), l, dArray);
        return dArray;
    }

    public synchronized void getaccdotys(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument doty in getaccdotys is null");
        }
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getaccdotys", "doty");
        }
        this.p_getaccdotys(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getaccdotys(soltype soltype2) throws Error {
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getaccdotys(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getaccfnumnz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccfnumnz", "accfnnz");
        }
        this.p_getaccfnumnz(this.native_task, lArray2);
    }

    public synchronized long getaccfnumnz() throws Error {
        long[] lArray = new long[1];
        this.p_getaccfnumnz(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getaccftrip(long[] lArray, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument frow in getaccftrip is null");
        }
        long[] lArray2 = new long[1];
        this.p_getaccfnumnz(this.native_task, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getaccftrip", "frow");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument fcol in getaccftrip is null");
        }
        long[] lArray3 = new long[1];
        this.p_getaccfnumnz(this.native_task, lArray3);
        if (nArray != null && (long)nArray.length < lArray3[0]) {
            throw new ArrayLengthException("getaccftrip", "fcol");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument fval in getaccftrip is null");
        }
        long[] lArray4 = new long[1];
        this.p_getaccfnumnz(this.native_task, lArray4);
        if (dArray != null && (long)dArray.length < lArray4[0]) {
            throw new ArrayLengthException("getaccftrip", "fval");
        }
        this.p_getaccftrip(this.native_task, lArray, nArray, dArray);
    }

    public synchronized void getaccgvector(double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getaccgvector", "g");
        }
        this.p_getaccgvector(this.native_task, dArray);
    }

    public synchronized double[] getaccgvector() throws Error {
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getaccgvector(this.native_task, dArray);
        return dArray;
    }

    public synchronized void getaccn(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccn", "n");
        }
        this.p_getaccn(this.native_task, l, lArray2);
    }

    public synchronized long getaccn(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized String getaccname(long l) throws Error {
        int n;
        int[] nArray = new int[1];
        this.p_getaccnamelen(this.native_task, l, nArray);
        int n2 = 1 + nArray[0];
        byte[] byArray = new byte[n2];
        this.p_getaccname(this.native_task, l, n2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getaccnamelen(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getaccnamelen", "len");
        }
        this.p_getaccnamelen(this.native_task, l, nArray2);
    }

    public synchronized int getaccnamelen(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getaccnamelen(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getaccntot(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getaccntot", "n");
        }
        this.p_getaccntot(this.native_task, lArray2);
    }

    public synchronized long getaccntot() throws Error {
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getaccs(long[] lArray, long[] lArray2, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument domidxlist in getaccs is null");
        }
        long[] lArray3 = new long[1];
        this.p_getnumacc(this.native_task, lArray3);
        if (lArray != null && (long)lArray.length < lArray3[0]) {
            throw new ArrayLengthException("getaccs", "domidxlist");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidxlist in getaccs is null");
        }
        long[] lArray4 = new long[1];
        this.p_getaccntot(this.native_task, lArray4);
        if (lArray2 != null && (long)lArray2.length < lArray4[0]) {
            throw new ArrayLengthException("getaccs", "afeidxlist");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument b in getaccs is null");
        }
        long[] lArray5 = new long[1];
        this.p_getaccntot(this.native_task, lArray5);
        if (dArray != null && (long)dArray.length < lArray5[0]) {
            throw new ArrayLengthException("getaccs", "b");
        }
        this.p_getaccs(this.native_task, lArray, lArray2, dArray);
    }

    public synchronized void getacol(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getacol", "nzj");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in getacol is null");
        }
        int[] nArray4 = new int[1];
        this.p_getacolnumnz(this.native_task, n, nArray4);
        if (nArray2 != null && nArray2.length < nArray4[0]) {
            throw new ArrayLengthException("getacol", "subj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valj in getacol is null");
        }
        int[] nArray5 = new int[1];
        this.p_getacolnumnz(this.native_task, n, nArray5);
        if (dArray != null && dArray.length < nArray5[0]) {
            throw new ArrayLengthException("getacol", "valj");
        }
        this.p_getacol(this.native_task, n, nArray3, nArray2, dArray);
    }

    public synchronized void getacolnumnz(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getacolnumnz", "nzj");
        }
        this.p_getacolnumnz(this.native_task, n, nArray2);
    }

    public synchronized int getacolnumnz(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getacolnumnz(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getacolslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getacolslicenumnz64(this.native_task, n, n2, lArray3);
        long l = lArray3[0];
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in getacolslice is null");
        }
        if (lArray != null && lArray.length < n2 - n) {
            throw new ArrayLengthException("getacolslice", "ptrb");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in getacolslice is null");
        }
        if (lArray2 != null && lArray2.length < n2 - n) {
            throw new ArrayLengthException("getacolslice", "ptre");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getacolslice is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getacolslice", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in getacolslice is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getacolslice", "val");
        }
        this.p_getacolslice64(this.native_task, n, n2, l, lArray, lArray2, nArray, dArray);
    }

    public synchronized void getacolslicenumnz(int n, int n2, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getacolslicenumnz", "numnz");
        }
        this.p_getacolslicenumnz64(this.native_task, n, n2, lArray2);
    }

    public synchronized long getacolslicenumnz(int n, int n2) throws Error {
        long[] lArray = new long[1];
        this.p_getacolslicenumnz64(this.native_task, n, n2, lArray);
        return lArray[0];
    }

    public synchronized void getacolslicetrip(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getacolslicenumnz64(this.native_task, n, n2, lArray);
        long l = lArray[0];
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "subj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getacolslicetrip", "val");
        }
        this.p_getacolslicetrip(this.native_task, n, n2, l, nArray, nArray2, dArray);
    }

    public synchronized void getafebarfblocktriplet(long[] lArray, long[] lArray2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getafebarfnumblocktriplets(this.native_task, lArray3);
        long l = lArray3[0];
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getafebarfblocktriplet", "numtrip");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidx in getafebarfblocktriplet is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "afeidx");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in getafebarfblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "barvaridx");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in getafebarfblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in getafebarfblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valkl in getafebarfblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "valkl");
        }
        this.p_getafebarfblocktriplet(this.native_task, l, lArray4, lArray2, nArray, nArray2, nArray3, dArray);
    }

    public synchronized long getafebarfblocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getafebarfnumblocktriplets(this.native_task, lArray2);
        long l = lArray2[0];
        long[] lArray3 = new long[1];
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in getafebarfblocktriplet is null");
        }
        if (lArray != null && (long)lArray.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "afeidx");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in getafebarfblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "barvaridx");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in getafebarfblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in getafebarfblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valkl in getafebarfblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getafebarfblocktriplet", "valkl");
        }
        this.p_getafebarfblocktriplet(this.native_task, l, lArray3, lArray, nArray, nArray2, nArray3, dArray);
        return lArray3[0];
    }

    public synchronized void getafebarfnumblocktriplets(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getafebarfnumblocktriplets", "numtrip");
        }
        this.p_getafebarfnumblocktriplets(this.native_task, lArray2);
    }

    public synchronized long getafebarfnumblocktriplets() throws Error {
        long[] lArray = new long[1];
        this.p_getafebarfnumblocktriplets(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getafebarfnumrowentries(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getafebarfnumrowentries", "numentr");
        }
        this.p_getafebarfnumrowentries(this.native_task, l, nArray2);
    }

    public synchronized int getafebarfnumrowentries(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getafebarfnumrowentries(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getafebarfrow(long l, int[] nArray, long[] lArray, long[] lArray2, long[] lArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in getafebarfrow is null");
        }
        int[] nArray2 = new int[1];
        long[] lArray4 = new long[1];
        this.p_getafebarfrowinfo(this.native_task, l, nArray2, lArray4);
        if (nArray != null && nArray.length < nArray2[0]) {
            throw new ArrayLengthException("getafebarfrow", "barvaridx");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument ptrterm in getafebarfrow is null");
        }
        int[] nArray3 = new int[1];
        long[] lArray5 = new long[1];
        this.p_getafebarfrowinfo(this.native_task, l, nArray3, lArray5);
        if (lArray != null && lArray.length < nArray3[0]) {
            throw new ArrayLengthException("getafebarfrow", "ptrterm");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument numterm in getafebarfrow is null");
        }
        int[] nArray4 = new int[1];
        long[] lArray6 = new long[1];
        this.p_getafebarfrowinfo(this.native_task, l, nArray4, lArray6);
        if (lArray2 != null && lArray2.length < nArray4[0]) {
            throw new ArrayLengthException("getafebarfrow", "numterm");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument termidx in getafebarfrow is null");
        }
        int[] nArray5 = new int[1];
        long[] lArray7 = new long[1];
        this.p_getafebarfrowinfo(this.native_task, l, nArray5, lArray7);
        if (lArray3 != null && (long)lArray3.length < lArray7[0]) {
            throw new ArrayLengthException("getafebarfrow", "termidx");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument termweight in getafebarfrow is null");
        }
        int[] nArray6 = new int[1];
        long[] lArray8 = new long[1];
        this.p_getafebarfrowinfo(this.native_task, l, nArray6, lArray8);
        if (dArray != null && (long)dArray.length < lArray8[0]) {
            throw new ArrayLengthException("getafebarfrow", "termweight");
        }
        this.p_getafebarfrow(this.native_task, l, nArray, lArray, lArray2, lArray3, dArray);
    }

    public synchronized void getafebarfrowinfo(long l, int[] nArray, long[] lArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getafebarfrowinfo", "numentr");
        }
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getafebarfrowinfo", "numterm");
        }
        this.p_getafebarfrowinfo(this.native_task, l, nArray2, lArray2);
    }

    public synchronized void getafefnumnz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getafefnumnz", "numnz");
        }
        this.p_getafefnumnz(this.native_task, lArray2);
    }

    public synchronized long getafefnumnz() throws Error {
        long[] lArray = new long[1];
        this.p_getafefnumnz(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getafefrow(long l, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getafefrow", "numnz");
        }
        int[] nArray4 = new int[1];
        this.p_getafefrownumnz(this.native_task, l, nArray4);
        if (nArray2 != null && nArray2.length < nArray4[0]) {
            throw new ArrayLengthException("getafefrow", "varidx");
        }
        int[] nArray5 = new int[1];
        this.p_getafefrownumnz(this.native_task, l, nArray5);
        if (dArray != null && dArray.length < nArray5[0]) {
            throw new ArrayLengthException("getafefrow", "val");
        }
        this.p_getafefrow(this.native_task, l, nArray3, nArray2, dArray);
    }

    public synchronized void getafefrownumnz(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getafefrownumnz", "numnz");
        }
        this.p_getafefrownumnz(this.native_task, l, nArray2);
    }

    public synchronized int getafefrownumnz(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getafefrownumnz(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getafeftrip(long[] lArray, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in getafeftrip is null");
        }
        long[] lArray2 = new long[1];
        this.p_getafefnumnz(this.native_task, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getafeftrip", "afeidx");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument varidx in getafeftrip is null");
        }
        long[] lArray3 = new long[1];
        this.p_getafefnumnz(this.native_task, lArray3);
        if (nArray != null && (long)nArray.length < lArray3[0]) {
            throw new ArrayLengthException("getafeftrip", "varidx");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in getafeftrip is null");
        }
        long[] lArray4 = new long[1];
        this.p_getafefnumnz(this.native_task, lArray4);
        if (dArray != null && (long)dArray.length < lArray4[0]) {
            throw new ArrayLengthException("getafeftrip", "val");
        }
        this.p_getafeftrip(this.native_task, lArray, nArray, dArray);
    }

    public synchronized void getafeg(long l, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getafeg", "g");
        }
        this.p_getafeg(this.native_task, l, dArray2);
    }

    public synchronized double getafeg(long l) throws Error {
        double[] dArray = new double[1];
        this.p_getafeg(this.native_task, l, dArray);
        return dArray[0];
    }

    public synchronized void getafegslice(long l, long l2, double[] dArray) throws Error {
        if (dArray != null && (long)dArray.length < l2 - l) {
            throw new ArrayLengthException("getafegslice", "g");
        }
        this.p_getafegslice(this.native_task, l, l2, dArray);
    }

    public synchronized double[] getafegslice(long l, long l2) throws Error {
        double[] dArray = new double[(int)(l2 - l)];
        this.p_getafegslice(this.native_task, l, l2, dArray);
        return dArray;
    }

    public synchronized void getaij(int n, int n2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getaij", "aij");
        }
        this.p_getaij(this.native_task, n, n2, dArray2);
    }

    public synchronized double getaij(int n, int n2) throws Error {
        double[] dArray = new double[1];
        this.p_getaij(this.native_task, n, n2, dArray);
        return dArray[0];
    }

    public synchronized void getapiecenumnz(int n, int n2, int n3, int n4, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getapiecenumnz", "numnz");
        }
        this.p_getapiecenumnz(this.native_task, n, n2, n3, n4, nArray2);
    }

    public synchronized int getapiecenumnz(int n, int n2, int n3, int n4) throws Error {
        int[] nArray = new int[1];
        this.p_getapiecenumnz(this.native_task, n, n2, n3, n4, nArray);
        return nArray[0];
    }

    public synchronized void getarow(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getarow", "nzi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subi in getarow is null");
        }
        int[] nArray4 = new int[1];
        this.p_getarownumnz(this.native_task, n, nArray4);
        if (nArray2 != null && nArray2.length < nArray4[0]) {
            throw new ArrayLengthException("getarow", "subi");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument vali in getarow is null");
        }
        int[] nArray5 = new int[1];
        this.p_getarownumnz(this.native_task, n, nArray5);
        if (dArray != null && dArray.length < nArray5[0]) {
            throw new ArrayLengthException("getarow", "vali");
        }
        this.p_getarow(this.native_task, n, nArray3, nArray2, dArray);
    }

    public synchronized void getarownumnz(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getarownumnz", "nzi");
        }
        this.p_getarownumnz(this.native_task, n, nArray2);
    }

    public synchronized int getarownumnz(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getarownumnz(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getarowslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getarowslicenumnz64(this.native_task, n, n2, lArray3);
        long l = lArray3[0];
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in getarowslice is null");
        }
        if (lArray != null && lArray.length < n2 - n) {
            throw new ArrayLengthException("getarowslice", "ptrb");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in getarowslice is null");
        }
        if (lArray2 != null && lArray2.length < n2 - n) {
            throw new ArrayLengthException("getarowslice", "ptre");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getarowslice is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getarowslice", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in getarowslice is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getarowslice", "val");
        }
        this.p_getarowslice64(this.native_task, n, n2, l, lArray, lArray2, nArray, dArray);
    }

    public synchronized void getarowslicenumnz(int n, int n2, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getarowslicenumnz", "numnz");
        }
        this.p_getarowslicenumnz64(this.native_task, n, n2, lArray2);
    }

    public synchronized long getarowslicenumnz(int n, int n2) throws Error {
        long[] lArray = new long[1];
        this.p_getarowslicenumnz64(this.native_task, n, n2, lArray);
        return lArray[0];
    }

    public synchronized void getarowslicetrip(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getarowslicenumnz64(this.native_task, n, n2, lArray);
        long l = lArray[0];
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "subj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getarowslicetrip", "val");
        }
        this.p_getarowslicetrip(this.native_task, n, n2, l, nArray, nArray2, dArray);
    }

    public synchronized void getatrip(int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getnumanz64(this.native_task, lArray);
        long l = lArray[0];
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getatrip", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getatrip", "subj");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getatrip", "val");
        }
        this.p_getatrip(this.native_task, l, nArray, nArray2, dArray);
    }

    public synchronized void getatruncatetol(double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument tolzero in getatruncatetol is null");
        }
        if (dArray != null && dArray.length < 1) {
            throw new ArrayLengthException("getatruncatetol", "tolzero");
        }
        this.p_getatruncatetol(this.native_task, dArray);
    }

    public synchronized double[] getatruncatetol() throws Error {
        double[] dArray = new double[1];
        this.p_getatruncatetol(this.native_task, dArray);
        return dArray;
    }

    public synchronized void getbarablocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getnumbarablocktriplets(this.native_task, lArray2);
        long l = lArray2[0];
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarablocktriplet", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in getbarablocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in getbarablocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subj");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk in getbarablocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subk");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl in getbarablocktriplet is null");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl in getbarablocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "valijkl");
        }
        this.p_getbarablocktriplet(this.native_task, l, lArray3, nArray, nArray2, nArray3, nArray4, dArray);
    }

    public synchronized long getbarablocktriplet(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getnumbarablocktriplets(this.native_task, lArray);
        long l = lArray[0];
        long[] lArray2 = new long[1];
        if (nArray == null) {
            throw new NullPointerException("Argument subi in getbarablocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in getbarablocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subj");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk in getbarablocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subk");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl in getbarablocktriplet is null");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl in getbarablocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarablocktriplet", "valijkl");
        }
        this.p_getbarablocktriplet(this.native_task, l, lArray2, nArray, nArray2, nArray3, nArray4, dArray);
        return lArray2[0];
    }

    public synchronized void getbaraidx(long l, int[] nArray, int[] nArray2, long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getbaraidxinfo(this.native_task, l, lArray3);
        long l2 = lArray3[0];
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbaraidx", "i");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getbaraidx", "j");
        }
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbaraidx", "num");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument sub in getbaraidx is null");
        }
        if (lArray2 != null && (long)lArray2.length < l2) {
            throw new ArrayLengthException("getbaraidx", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in getbaraidx is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "weights");
        }
        this.p_getbaraidx(this.native_task, l, l2, nArray3, nArray4, lArray4, lArray2, dArray);
    }

    public synchronized long getbaraidx(long l, int[] nArray, int[] nArray2, long[] lArray, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getbaraidxinfo(this.native_task, l, lArray2);
        long l2 = lArray2[0];
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbaraidx", "i");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getbaraidx", "j");
        }
        long[] lArray3 = new long[1];
        if (lArray == null) {
            throw new NullPointerException("Argument sub in getbaraidx is null");
        }
        if (lArray != null && (long)lArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in getbaraidx is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbaraidx", "weights");
        }
        this.p_getbaraidx(this.native_task, l, l2, nArray3, nArray4, lArray3, lArray, dArray);
        return lArray3[0];
    }

    public synchronized void getbaraidxij(long l, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbaraidxij", "i");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getbaraidxij", "j");
        }
        this.p_getbaraidxij(this.native_task, l, nArray3, nArray4);
    }

    public synchronized void getbaraidxinfo(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbaraidxinfo", "num");
        }
        this.p_getbaraidxinfo(this.native_task, l, lArray2);
    }

    public synchronized long getbaraidxinfo(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getbaraidxinfo(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getbarasparsity(long[] lArray, long[] lArray2) throws Error {
        long[] lArray3 = new long[1];
        this.p_getnumbaranz(this.native_task, lArray3);
        long l = lArray3[0];
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarasparsity", "numnz");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument idxij in getbarasparsity is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getbarasparsity", "idxij");
        }
        this.p_getbarasparsity(this.native_task, l, lArray4, lArray2);
    }

    public synchronized void getbarcblocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getnumbarcblocktriplets(this.native_task, lArray2);
        long l = lArray2[0];
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarcblocktriplet", "num");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getbarcblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subj");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in getbarcblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in getbarcblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl in getbarcblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "valjkl");
        }
        this.p_getbarcblocktriplet(this.native_task, l, lArray3, nArray, nArray2, nArray3, dArray);
    }

    public synchronized long getbarcblocktriplet(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getnumbarcblocktriplets(this.native_task, lArray);
        long l = lArray[0];
        long[] lArray2 = new long[1];
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getbarcblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subj");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in getbarcblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in getbarcblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl in getbarcblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarcblocktriplet", "valjkl");
        }
        this.p_getbarcblocktriplet(this.native_task, l, lArray2, nArray, nArray2, nArray3, dArray);
        return lArray2[0];
    }

    public synchronized void getbarcidx(long l, int[] nArray, long[] lArray, long[] lArray2, double[] dArray) throws Error {
        long[] lArray3 = new long[1];
        this.p_getbarcidxinfo(this.native_task, l, lArray3);
        long l2 = lArray3[0];
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbarcidx", "j");
        }
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarcidx", "num");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument sub in getbarcidx is null");
        }
        if (lArray2 != null && (long)lArray2.length < l2) {
            throw new ArrayLengthException("getbarcidx", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in getbarcidx is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getbarcidx", "weights");
        }
        this.p_getbarcidx(this.native_task, l, l2, nArray2, lArray4, lArray2, dArray);
    }

    public synchronized void getbarcidxinfo(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarcidxinfo", "num");
        }
        this.p_getbarcidxinfo(this.native_task, l, lArray2);
    }

    public synchronized long getbarcidxinfo(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getbarcidxinfo(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getbarcidxj(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbarcidxj", "j");
        }
        this.p_getbarcidxj(this.native_task, l, nArray2);
    }

    public synchronized int getbarcidxj(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getbarcidxj(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getbarcsparsity(long[] lArray, long[] lArray2) throws Error {
        long[] lArray3 = new long[1];
        this.p_getnumbarcnz(this.native_task, lArray3);
        long l = lArray3[0];
        long[] lArray4 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getbarcsparsity", "numnz");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument idxj in getbarcsparsity is null");
        }
        if (lArray2 != null && (long)lArray2.length < l) {
            throw new ArrayLengthException("getbarcsparsity", "idxj");
        }
        this.p_getbarcsparsity(this.native_task, l, lArray4, lArray2);
    }

    public synchronized void getbarsj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barsj in getbarsj is null");
        }
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getbarsj", "barsj");
        }
        this.p_getbarsj(this.native_task, soltype2.getValue(), n, dArray);
    }

    public synchronized double[] getbarsj(soltype soltype2, int n) throws Error {
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getbarsj(this.native_task, soltype2.getValue(), n, dArray);
        return dArray;
    }

    public synchronized void getbarsslice(soltype soltype2, int n, int n2, long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barsslice in getbarsslice is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarsslice", "barsslice");
        }
        this.p_getbarsslice(this.native_task, soltype2.getValue(), n, n2, l, dArray);
    }

    public synchronized double[] getbarsslice(soltype soltype2, int n, int n2, long l) throws Error {
        double[] dArray = new double[(int)l];
        this.p_getbarsslice(this.native_task, soltype2.getValue(), n, n2, l, dArray);
        return dArray;
    }

    public synchronized String getbarvarname(int n) throws Error {
        int n2;
        int[] nArray = new int[1];
        this.p_getbarvarnamelen(this.native_task, n, nArray);
        int n3 = 1 + nArray[0];
        byte[] byArray = new byte[n3];
        this.p_getbarvarname(this.native_task, n, n3, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getbarvarnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbarvarnameindex", "asgn");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getbarvarnameindex", "index");
        }
        this.p_getbarvarnameindex(this.native_task, string, nArray3, nArray4);
    }

    public synchronized int getbarvarnameindex(String string, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbarvarnameindex", "asgn");
        }
        int[] nArray3 = new int[1];
        this.p_getbarvarnameindex(this.native_task, string, nArray2, nArray3);
        return nArray3[0];
    }

    public synchronized void getbarvarnamelen(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getbarvarnamelen", "len");
        }
        this.p_getbarvarnamelen(this.native_task, n, nArray2);
    }

    public synchronized int getbarvarnamelen(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getbarvarnamelen(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getbarxj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barxj in getbarxj is null");
        }
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getbarxj", "barxj");
        }
        this.p_getbarxj(this.native_task, soltype2.getValue(), n, dArray);
    }

    public synchronized double[] getbarxj(soltype soltype2, int n) throws Error {
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getbarxj(this.native_task, soltype2.getValue(), n, dArray);
        return dArray;
    }

    public synchronized void getbarxslice(soltype soltype2, int n, int n2, long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barxslice in getbarxslice is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getbarxslice", "barxslice");
        }
        this.p_getbarxslice(this.native_task, soltype2.getValue(), n, n2, l, dArray);
    }

    public synchronized double[] getbarxslice(soltype soltype2, int n, int n2, long l) throws Error {
        double[] dArray = new double[(int)l];
        this.p_getbarxslice(this.native_task, soltype2.getValue(), n, n2, l, dArray);
        return dArray;
    }

    public synchronized void getc(double[] dArray) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getc", "c");
        }
        this.p_getc(this.native_task, dArray);
    }

    public synchronized double[] getc() throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getc(this.native_task, dArray);
        return dArray;
    }

    public synchronized void getcfix(double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getcfix", "cfix");
        }
        this.p_getcfix(this.native_task, dArray2);
    }

    public synchronized double getcfix() throws Error {
        double[] dArray = new double[1];
        this.p_getcfix(this.native_task, dArray);
        return dArray[0];
    }

    public synchronized void getcj(int n, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getcj", "cj");
        }
        this.p_getcj(this.native_task, n, dArray2);
    }

    public synchronized double getcj(int n) throws Error {
        double[] dArray = new double[1];
        this.p_getcj(this.native_task, n, dArray);
        return dArray[0];
    }

    public synchronized void getclist(int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getclist", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getclist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument c in getclist is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getclist", "c");
        }
        this.p_getclist(this.native_task, n, nArray, dArray);
    }

    public synchronized double[] getclist(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getclist", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getclist is null");
        }
        double[] dArray = new double[n];
        this.p_getclist(this.native_task, n, nArray, dArray);
        return dArray;
    }

    public synchronized void getconbound(int n, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int[] nArray = new int[1];
        double[] dArray3 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getconbound", "bl");
        }
        double[] dArray4 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getconbound", "bu");
        }
        this.p_getconbound(this.native_task, n, nArray, dArray3, dArray4);
        boundkeyArray[0] = boundkey.fromValue(nArray[0]);
    }

    public synchronized void getconboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bk");
        }
        int[] nArray = null;
        if (boundkeyArray != null) {
            nArray = new int[boundkeyArray.length];
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("getconboundslice", "bu");
        }
        this.p_getconboundslice(this.native_task, n, n2, nArray, dArray, dArray2);
        if (boundkeyArray != null) {
            for (int i = 0; i < boundkeyArray.length; ++i) {
                boundkeyArray[i] = boundkey.fromValue(nArray[i]);
            }
        }
    }

    public synchronized void getcone(int n, conetype[] conetypeArray, double[] dArray, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = new int[1];
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getcone", "conepar");
        }
        int[] nArray4 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getcone", "nummem");
        }
        int[] nArray5 = new int[1];
        double[] dArray3 = new double[1];
        int[] nArray6 = new int[1];
        this.p_getconeinfo(this.native_task, n, nArray5, dArray3, nArray6);
        if (nArray2 != null && nArray2.length < nArray6[0]) {
            throw new ArrayLengthException("getcone", "submem");
        }
        this.p_getcone(this.native_task, n, nArray3, dArray2, nArray4, nArray2);
        conetypeArray[0] = conetype.fromValue(nArray3[0]);
    }

    public synchronized void getconeinfo(int n, conetype[] conetypeArray, double[] dArray, int[] nArray) throws Error {
        int[] nArray2 = new int[1];
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getconeinfo", "conepar");
        }
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconeinfo", "nummem");
        }
        this.p_getconeinfo(this.native_task, n, nArray2, dArray2, nArray3);
        conetypeArray[0] = conetype.fromValue(nArray2[0]);
    }

    public synchronized String getconename(int n) throws Error {
        int n2;
        int[] nArray = new int[1];
        this.p_getconenamelen(this.native_task, n, nArray);
        int n3 = 1 + nArray[0];
        byte[] byArray = new byte[n3];
        this.p_getconename(this.native_task, n, n3, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getconenameindex(String string, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconenameindex", "asgn");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getconenameindex", "index");
        }
        this.p_getconenameindex(this.native_task, string, nArray3, nArray4);
    }

    public synchronized int getconenameindex(String string, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconenameindex", "asgn");
        }
        int[] nArray3 = new int[1];
        this.p_getconenameindex(this.native_task, string, nArray2, nArray3);
        return nArray3[0];
    }

    public synchronized void getconenamelen(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconenamelen", "len");
        }
        this.p_getconenamelen(this.native_task, n, nArray2);
    }

    public synchronized int getconenamelen(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getconenamelen(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized String getconname(int n) throws Error {
        int n2;
        int[] nArray = new int[1];
        this.p_getconnamelen(this.native_task, n, nArray);
        int n3 = 1 + nArray[0];
        byte[] byArray = new byte[n3];
        this.p_getconname(this.native_task, n, n3, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getconnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconnameindex", "asgn");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getconnameindex", "index");
        }
        this.p_getconnameindex(this.native_task, string, nArray3, nArray4);
    }

    public synchronized int getconnameindex(String string, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconnameindex", "asgn");
        }
        int[] nArray3 = new int[1];
        this.p_getconnameindex(this.native_task, string, nArray2, nArray3);
        return nArray3[0];
    }

    public synchronized void getconnamelen(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getconnamelen", "len");
        }
        this.p_getconnamelen(this.native_task, n, nArray2);
    }

    public synchronized int getconnamelen(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getconnamelen(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getcslice(int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getcslice", "c");
        }
        this.p_getcslice(this.native_task, n, n2, dArray);
    }

    public synchronized double[] getcslice(int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getcslice(this.native_task, n, n2, dArray);
        return dArray;
    }

    public synchronized void getdimbarvarj(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getdimbarvarj", "dimbarvarj");
        }
        this.p_getdimbarvarj(this.native_task, n, nArray2);
    }

    public synchronized int getdimbarvarj(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getdimbarvarj(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getdjcafeidxlist(long l, long[] lArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument afeidxlist in getdjcafeidxlist is null");
        }
        long[] lArray2 = new long[1];
        this.p_getdjcnumafe(this.native_task, l, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getdjcafeidxlist", "afeidxlist");
        }
        this.p_getdjcafeidxlist(this.native_task, l, lArray);
    }

    public synchronized long[] getdjcafeidxlist(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumafe(this.native_task, l, lArray);
        long[] lArray2 = new long[(int)lArray[0]];
        this.p_getdjcafeidxlist(this.native_task, l, lArray2);
        return lArray2;
    }

    public synchronized void getdjcb(long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument b in getdjcb is null");
        }
        long[] lArray = new long[1];
        this.p_getdjcnumafe(this.native_task, l, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("getdjcb", "b");
        }
        this.p_getdjcb(this.native_task, l, dArray);
    }

    public synchronized double[] getdjcb(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumafe(this.native_task, l, lArray);
        double[] dArray = new double[(int)lArray[0]];
        this.p_getdjcb(this.native_task, l, dArray);
        return dArray;
    }

    public synchronized void getdjcdomainidxlist(long l, long[] lArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument domidxlist in getdjcdomainidxlist is null");
        }
        long[] lArray2 = new long[1];
        this.p_getdjcnumdomain(this.native_task, l, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getdjcdomainidxlist", "domidxlist");
        }
        this.p_getdjcdomainidxlist(this.native_task, l, lArray);
    }

    public synchronized long[] getdjcdomainidxlist(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumdomain(this.native_task, l, lArray);
        long[] lArray2 = new long[(int)lArray[0]];
        this.p_getdjcdomainidxlist(this.native_task, l, lArray2);
        return lArray2;
    }

    public synchronized String getdjcname(long l) throws Error {
        int n;
        int[] nArray = new int[1];
        this.p_getdjcnamelen(this.native_task, l, nArray);
        int n2 = 1 + nArray[0];
        byte[] byArray = new byte[n2];
        this.p_getdjcname(this.native_task, l, n2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getdjcnamelen(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getdjcnamelen", "len");
        }
        this.p_getdjcnamelen(this.native_task, l, nArray2);
    }

    public synchronized int getdjcnamelen(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getdjcnamelen(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getdjcnumafe(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumafe", "numafe");
        }
        this.p_getdjcnumafe(this.native_task, l, lArray2);
    }

    public synchronized long getdjcnumafe(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumafe(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getdjcnumafetot(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumafetot", "numafetot");
        }
        this.p_getdjcnumafetot(this.native_task, lArray2);
    }

    public synchronized long getdjcnumafetot() throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumafetot(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getdjcnumdomain(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumdomain", "numdomain");
        }
        this.p_getdjcnumdomain(this.native_task, l, lArray2);
    }

    public synchronized long getdjcnumdomain(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumdomain(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getdjcnumdomaintot(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumdomaintot", "numdomaintot");
        }
        this.p_getdjcnumdomaintot(this.native_task, lArray2);
    }

    public synchronized long getdjcnumdomaintot() throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumdomaintot(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getdjcnumterm(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumterm", "numterm");
        }
        this.p_getdjcnumterm(this.native_task, l, lArray2);
    }

    public synchronized long getdjcnumterm(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumterm(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized void getdjcnumtermtot(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdjcnumtermtot", "numtermtot");
        }
        this.p_getdjcnumtermtot(this.native_task, lArray2);
    }

    public synchronized long getdjcnumtermtot() throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumtermtot(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getdjcs(long[] lArray, long[] lArray2, double[] dArray, long[] lArray3, long[] lArray4) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument domidxlist in getdjcs is null");
        }
        long[] lArray5 = new long[1];
        this.p_getdjcnumdomaintot(this.native_task, lArray5);
        if (lArray != null && (long)lArray.length < lArray5[0]) {
            throw new ArrayLengthException("getdjcs", "domidxlist");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidxlist in getdjcs is null");
        }
        long[] lArray6 = new long[1];
        this.p_getdjcnumafetot(this.native_task, lArray6);
        if (lArray2 != null && (long)lArray2.length < lArray6[0]) {
            throw new ArrayLengthException("getdjcs", "afeidxlist");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument b in getdjcs is null");
        }
        long[] lArray7 = new long[1];
        this.p_getdjcnumafetot(this.native_task, lArray7);
        if (dArray != null && (long)dArray.length < lArray7[0]) {
            throw new ArrayLengthException("getdjcs", "b");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument termsizelist in getdjcs is null");
        }
        long[] lArray8 = new long[1];
        this.p_getdjcnumtermtot(this.native_task, lArray8);
        if (lArray3 != null && (long)lArray3.length < lArray8[0]) {
            throw new ArrayLengthException("getdjcs", "termsizelist");
        }
        if (lArray4 == null) {
            throw new NullPointerException("Argument numterms in getdjcs is null");
        }
        long[] lArray9 = new long[1];
        this.p_getnumdjc(this.native_task, lArray9);
        if (lArray4 != null && (long)lArray4.length < lArray9[0]) {
            throw new ArrayLengthException("getdjcs", "numterms");
        }
        this.p_getdjcs(this.native_task, lArray, lArray2, dArray, lArray3, lArray4);
    }

    public synchronized void getdjctermsizelist(long l, long[] lArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument termsizelist in getdjctermsizelist is null");
        }
        long[] lArray2 = new long[1];
        this.p_getdjcnumterm(this.native_task, l, lArray2);
        if (lArray != null && (long)lArray.length < lArray2[0]) {
            throw new ArrayLengthException("getdjctermsizelist", "termsizelist");
        }
        this.p_getdjctermsizelist(this.native_task, l, lArray);
    }

    public synchronized long[] getdjctermsizelist(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdjcnumterm(this.native_task, l, lArray);
        long[] lArray2 = new long[(int)lArray[0]];
        this.p_getdjctermsizelist(this.native_task, l, lArray2);
        return lArray2;
    }

    public synchronized void getdomainn(long l, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getdomainn", "n");
        }
        this.p_getdomainn(this.native_task, l, lArray2);
    }

    public synchronized long getdomainn(long l) throws Error {
        long[] lArray = new long[1];
        this.p_getdomainn(this.native_task, l, lArray);
        return lArray[0];
    }

    public synchronized String getdomainname(long l) throws Error {
        int n;
        int[] nArray = new int[1];
        this.p_getdomainnamelen(this.native_task, l, nArray);
        int n2 = 1 + nArray[0];
        byte[] byArray = new byte[n2];
        this.p_getdomainname(this.native_task, l, n2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getdomainnamelen(long l, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getdomainnamelen", "len");
        }
        this.p_getdomainnamelen(this.native_task, l, nArray2);
    }

    public synchronized int getdomainnamelen(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getdomainnamelen(this.native_task, l, nArray);
        return nArray[0];
    }

    public synchronized void getdomaintype(long l, domaintype[] domaintypeArray) throws Error {
        int[] nArray = new int[1];
        this.p_getdomaintype(this.native_task, l, nArray);
        domaintypeArray[0] = domaintype.fromValue(nArray[0]);
    }

    public synchronized domaintype getdomaintype(long l) throws Error {
        int[] nArray = new int[1];
        this.p_getdomaintype(this.native_task, l, nArray);
        return domaintype.fromValue(nArray[0]);
    }

    public synchronized void getdouinf(dinfitem dinfitem2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getdouinf", "dvalue");
        }
        this.p_getdouinf(this.native_task, dinfitem2.getValue(), dArray2);
    }

    public synchronized double getdouinf(dinfitem dinfitem2) throws Error {
        double[] dArray = new double[1];
        this.p_getdouinf(this.native_task, dinfitem2.getValue(), dArray);
        return dArray[0];
    }

    public synchronized void getdouparam(dparam dparam2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getdouparam", "parvalue");
        }
        this.p_getdouparam(this.native_task, dparam2.getValue(), dArray2);
    }

    public synchronized double getdouparam(dparam dparam2) throws Error {
        double[] dArray = new double[1];
        this.p_getdouparam(this.native_task, dparam2.getValue(), dArray);
        return dArray[0];
    }

    public synchronized void getdualobj(soltype soltype2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getdualobj", "dualobj");
        }
        this.p_getdualobj(this.native_task, soltype2.getValue(), dArray2);
    }

    public synchronized double getdualobj(soltype soltype2) throws Error {
        double[] dArray = new double[1];
        this.p_getdualobj(this.native_task, soltype2.getValue(), dArray);
        return dArray[0];
    }

    public synchronized void getdualproblem(Task[] taskArray) throws Error {
        long[] lArray = new long[]{0L};
        this.p_getdualproblem(this.native_task, lArray);
        taskArray[0] = new Task(lArray[0]);
    }

    public synchronized Task getdualproblem() throws Error {
        long[] lArray = new long[]{0L};
        this.p_getdualproblem(this.native_task, lArray);
        return new Task(lArray[0]);
    }

    public synchronized void getdualsolutionnorms(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) throws Error {
        double[] dArray8 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmy");
        }
        double[] dArray9 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmslc");
        }
        double[] dArray10 = dArray3;
        if (dArray3.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmsuc");
        }
        double[] dArray11 = dArray4;
        if (dArray4.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmslx");
        }
        double[] dArray12 = dArray5;
        if (dArray5.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmsux");
        }
        double[] dArray13 = dArray6;
        if (dArray6.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmsnx");
        }
        double[] dArray14 = dArray7;
        if (dArray7.length != 1) {
            throw new ArrayLengthException("getdualsolutionnorms", "nrmbars");
        }
        this.p_getdualsolutionnorms(this.native_task, soltype2.getValue(), dArray8, dArray9, dArray10, dArray11, dArray12, dArray13, dArray14);
    }

    public synchronized void getdviolacc(soltype soltype2, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getdviolacc", "accidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument accidxlist in getdviolacc is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getdviolacc is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getdviolacc", "viol");
        }
        this.p_getdviolacc(this.native_task, soltype2.getValue(), l, lArray, dArray);
    }

    public synchronized double[] getdviolacc(soltype soltype2, long[] lArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getdviolacc", "accidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument accidxlist in getdviolacc is null");
        }
        double[] dArray = new double[(int)l];
        this.p_getdviolacc(this.native_task, soltype2.getValue(), l, lArray, dArray);
        return dArray;
    }

    public synchronized void getdviolbarvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolbarvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolbarvar is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getdviolbarvar is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolbarvar", "viol");
        }
        this.p_getdviolbarvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getdviolbarvar(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolbarvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolbarvar is null");
        }
        double[] dArray = new double[n];
        this.p_getdviolbarvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getdviolcon(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolcon", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolcon is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getdviolcon is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolcon", "viol");
        }
        this.p_getdviolcon(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getdviolcon(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolcon", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolcon is null");
        }
        double[] dArray = new double[n];
        this.p_getdviolcon(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getdviolcones(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolcones", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolcones is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getdviolcones is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolcones", "viol");
        }
        this.p_getdviolcones(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized void getdviolvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolvar is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getdviolvar is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getdviolvar", "viol");
        }
        this.p_getdviolvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getdviolvar(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getdviolvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getdviolvar is null");
        }
        double[] dArray = new double[n];
        this.p_getdviolvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getinfeasiblesubproblem(soltype soltype2, Task[] taskArray) throws Error {
        long[] lArray = new long[]{0L};
        this.p_getinfeasiblesubproblem(this.native_task, soltype2.getValue(), lArray);
        taskArray[0] = new Task(lArray[0]);
    }

    public synchronized Task getinfeasiblesubproblem(soltype soltype2) throws Error {
        long[] lArray = new long[]{0L};
        this.p_getinfeasiblesubproblem(this.native_task, soltype2.getValue(), lArray);
        return new Task(lArray[0]);
    }

    public synchronized void getinfindex(inftype inftype2, String string, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getinfindex", "infindex");
        }
        this.p_getinfindex(this.native_task, inftype2.getValue(), string, nArray2);
    }

    public synchronized int getinfindex(inftype inftype2, String string) throws Error {
        int[] nArray = new int[1];
        this.p_getinfindex(this.native_task, inftype2.getValue(), string, nArray);
        return nArray[0];
    }

    public synchronized void getinfmax(inftype inftype2, int[] nArray) throws Error {
        if (nArray != null && nArray.length < 1024) {
            throw new ArrayLengthException("getinfmax", "infmax");
        }
        this.p_getinfmax(this.native_task, inftype2.getValue(), nArray);
    }

    public synchronized int[] getinfmax(inftype inftype2) throws Error {
        int[] nArray = new int[1024];
        this.p_getinfmax(this.native_task, inftype2.getValue(), nArray);
        return nArray;
    }

    public synchronized String getinfname(inftype inftype2, int n) throws Error {
        int n2;
        byte[] byArray = new byte[1024];
        this.p_getinfname(this.native_task, inftype2.getValue(), n, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getintinf(iinfitem iinfitem2, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getintinf", "ivalue");
        }
        this.p_getintinf(this.native_task, iinfitem2.getValue(), nArray2);
    }

    public synchronized int getintinf(iinfitem iinfitem2) throws Error {
        int[] nArray = new int[1];
        this.p_getintinf(this.native_task, iinfitem2.getValue(), nArray);
        return nArray[0];
    }

    public synchronized void getintparam(iparam iparam2, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getintparam", "parvalue");
        }
        this.p_getintparam(this.native_task, iparam2.getValue(), nArray2);
    }

    public synchronized int getintparam(iparam iparam2) throws Error {
        int[] nArray = new int[1];
        this.p_getintparam(this.native_task, iparam2.getValue(), nArray);
        return nArray[0];
    }

    public synchronized void getlenbarvarj(int n, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getlenbarvarj", "lenbarvarj");
        }
        this.p_getlenbarvarj(this.native_task, n, lArray2);
    }

    public synchronized long getlenbarvarj(int n) throws Error {
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        return lArray[0];
    }

    public synchronized void getlintinf(liinfitem liinfitem2, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getlintinf", "ivalue");
        }
        this.p_getlintinf(this.native_task, liinfitem2.getValue(), lArray2);
    }

    public synchronized long getlintinf(liinfitem liinfitem2) throws Error {
        long[] lArray = new long[1];
        this.p_getlintinf(this.native_task, liinfitem2.getValue(), lArray);
        return lArray[0];
    }

    public synchronized void getlintparam(iparam iparam2, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getlintparam", "parvalue");
        }
        this.p_getlintparam(this.native_task, iparam2.getValue(), lArray2);
    }

    public synchronized long getlintparam(iparam iparam2) throws Error {
        long[] lArray = new long[1];
        this.p_getlintparam(this.native_task, iparam2.getValue(), lArray);
        return lArray[0];
    }

    public synchronized void getmaxnumanz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getmaxnumanz", "maxnumanz");
        }
        this.p_getmaxnumanz64(this.native_task, lArray2);
    }

    public synchronized long getmaxnumanz() throws Error {
        long[] lArray = new long[1];
        this.p_getmaxnumanz64(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getmaxnumbarvar(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getmaxnumbarvar", "maxnumbarvar");
        }
        this.p_getmaxnumbarvar(this.native_task, nArray2);
    }

    public synchronized int getmaxnumbarvar() throws Error {
        int[] nArray = new int[1];
        this.p_getmaxnumbarvar(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getmaxnumcon(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getmaxnumcon", "maxnumcon");
        }
        this.p_getmaxnumcon(this.native_task, nArray2);
    }

    public synchronized int getmaxnumcon() throws Error {
        int[] nArray = new int[1];
        this.p_getmaxnumcon(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getmaxnumcone(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getmaxnumcone", "maxnumcone");
        }
        this.p_getmaxnumcone(this.native_task, nArray2);
    }

    public synchronized void getmaxnumqnz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getmaxnumqnz", "maxnumqnz");
        }
        this.p_getmaxnumqnz64(this.native_task, lArray2);
    }

    public synchronized void getmaxnumvar(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getmaxnumvar", "maxnumvar");
        }
        this.p_getmaxnumvar(this.native_task, nArray2);
    }

    public synchronized int getmaxnumvar() throws Error {
        int[] nArray = new int[1];
        this.p_getmaxnumvar(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getmemusage(long[] lArray, long[] lArray2) throws Error {
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getmemusage", "meminuse");
        }
        long[] lArray4 = lArray2;
        if (lArray2.length != 1) {
            throw new ArrayLengthException("getmemusage", "maxmemuse");
        }
        this.p_getmemusagetask(this.native_task, lArray3, lArray4);
    }

    public synchronized void getmionumthreads(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getmionumthreads", "numthreads");
        }
        this.p_getmionumthreads(this.native_task, nArray2);
    }

    public synchronized int getmionumthreads() throws Error {
        int[] nArray = new int[1];
        this.p_getmionumthreads(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getnumacc(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumacc", "num");
        }
        this.p_getnumacc(this.native_task, lArray2);
    }

    public synchronized long getnumacc() throws Error {
        long[] lArray = new long[1];
        this.p_getnumacc(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumafe(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumafe", "numafe");
        }
        this.p_getnumafe(this.native_task, lArray2);
    }

    public synchronized long getnumafe() throws Error {
        long[] lArray = new long[1];
        this.p_getnumafe(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumanz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumanz", "numanz");
        }
        this.p_getnumanz64(this.native_task, lArray2);
    }

    public synchronized long getnumanz() throws Error {
        long[] lArray = new long[1];
        this.p_getnumanz64(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumbarablocktriplets(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumbarablocktriplets", "num");
        }
        this.p_getnumbarablocktriplets(this.native_task, lArray2);
    }

    public synchronized long getnumbarablocktriplets() throws Error {
        long[] lArray = new long[1];
        this.p_getnumbarablocktriplets(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumbaranz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumbaranz", "nz");
        }
        this.p_getnumbaranz(this.native_task, lArray2);
    }

    public synchronized long getnumbaranz() throws Error {
        long[] lArray = new long[1];
        this.p_getnumbaranz(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumbarcblocktriplets(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumbarcblocktriplets", "num");
        }
        this.p_getnumbarcblocktriplets(this.native_task, lArray2);
    }

    public synchronized long getnumbarcblocktriplets() throws Error {
        long[] lArray = new long[1];
        this.p_getnumbarcblocktriplets(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumbarcnz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumbarcnz", "nz");
        }
        this.p_getnumbarcnz(this.native_task, lArray2);
    }

    public synchronized long getnumbarcnz() throws Error {
        long[] lArray = new long[1];
        this.p_getnumbarcnz(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumbarvar(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumbarvar", "numbarvar");
        }
        this.p_getnumbarvar(this.native_task, nArray2);
    }

    public synchronized int getnumbarvar() throws Error {
        int[] nArray = new int[1];
        this.p_getnumbarvar(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getnumcon(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumcon", "numcon");
        }
        this.p_getnumcon(this.native_task, nArray2);
    }

    public synchronized int getnumcon() throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getnumcone(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumcone", "numcone");
        }
        this.p_getnumcone(this.native_task, nArray2);
    }

    public synchronized int getnumcone() throws Error {
        int[] nArray = new int[1];
        this.p_getnumcone(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getnumconemem(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumconemem", "nummem");
        }
        this.p_getnumconemem(this.native_task, n, nArray2);
    }

    public synchronized void getnumdjc(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumdjc", "num");
        }
        this.p_getnumdjc(this.native_task, lArray2);
    }

    public synchronized long getnumdjc() throws Error {
        long[] lArray = new long[1];
        this.p_getnumdjc(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumdomain(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumdomain", "numdomain");
        }
        this.p_getnumdomain(this.native_task, lArray2);
    }

    public synchronized long getnumdomain() throws Error {
        long[] lArray = new long[1];
        this.p_getnumdomain(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumintvar(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumintvar", "numintvar");
        }
        this.p_getnumintvar(this.native_task, nArray2);
    }

    public synchronized int getnumintvar() throws Error {
        int[] nArray = new int[1];
        this.p_getnumintvar(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getnumparam(parametertype parametertype2, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumparam", "numparam");
        }
        this.p_getnumparam(this.native_task, parametertype2.getValue(), nArray2);
    }

    public synchronized int getnumparam(parametertype parametertype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumparam(this.native_task, parametertype2.getValue(), nArray);
        return nArray[0];
    }

    public synchronized void getnumqconknz(int n, long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumqconknz", "numqcnz");
        }
        this.p_getnumqconknz64(this.native_task, n, lArray2);
    }

    public synchronized long getnumqconknz(int n) throws Error {
        long[] lArray = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray);
        return lArray[0];
    }

    public synchronized void getnumqobjnz(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumqobjnz", "numqonz");
        }
        this.p_getnumqobjnz64(this.native_task, lArray2);
    }

    public synchronized long getnumqobjnz() throws Error {
        long[] lArray = new long[1];
        this.p_getnumqobjnz64(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumsymmat(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getnumsymmat", "num");
        }
        this.p_getnumsymmat(this.native_task, lArray2);
    }

    public synchronized long getnumsymmat() throws Error {
        long[] lArray = new long[1];
        this.p_getnumsymmat(this.native_task, lArray);
        return lArray[0];
    }

    public synchronized void getnumvar(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getnumvar", "numvar");
        }
        this.p_getnumvar(this.native_task, nArray2);
    }

    public synchronized int getnumvar() throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized String getobjname() throws Error {
        int n;
        int[] nArray = new int[1];
        this.p_getobjnamelen(this.native_task, nArray);
        int n2 = 1 + nArray[0];
        byte[] byArray = new byte[n2];
        this.p_getobjname(this.native_task, n2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getobjnamelen(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getobjnamelen", "len");
        }
        this.p_getobjnamelen(this.native_task, nArray2);
    }

    public synchronized int getobjnamelen() throws Error {
        int[] nArray = new int[1];
        this.p_getobjnamelen(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getobjsense(objsense[] objsenseArray) throws Error {
        int[] nArray = new int[1];
        this.p_getobjsense(this.native_task, nArray);
        objsenseArray[0] = objsense.fromValue(nArray[0]);
    }

    public synchronized objsense getobjsense() throws Error {
        int[] nArray = new int[1];
        this.p_getobjsense(this.native_task, nArray);
        return objsense.fromValue(nArray[0]);
    }

    public synchronized void getparammax(parametertype parametertype2, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getparammax", "parammax");
        }
        this.p_getparammax(this.native_task, parametertype2.getValue(), nArray2);
    }

    public synchronized int getparammax(parametertype parametertype2) throws Error {
        int[] nArray = new int[1];
        this.p_getparammax(this.native_task, parametertype2.getValue(), nArray);
        return nArray[0];
    }

    public synchronized String getparamname(parametertype parametertype2, int n) throws Error {
        int n2;
        byte[] byArray = new byte[1024];
        this.p_getparamname(this.native_task, parametertype2.getValue(), n, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getpowerdomainalpha(long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument alpha in getpowerdomainalpha is null");
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.p_getpowerdomaininfo(this.native_task, l, lArray, lArray2);
        if (dArray != null && (long)dArray.length < lArray2[0]) {
            throw new ArrayLengthException("getpowerdomainalpha", "alpha");
        }
        this.p_getpowerdomainalpha(this.native_task, l, dArray);
    }

    public synchronized double[] getpowerdomainalpha(long l) throws Error {
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        this.p_getpowerdomaininfo(this.native_task, l, lArray, lArray2);
        double[] dArray = new double[(int)lArray2[0]];
        this.p_getpowerdomainalpha(this.native_task, l, dArray);
        return dArray;
    }

    public synchronized void getpowerdomaininfo(long l, long[] lArray, long[] lArray2) throws Error {
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getpowerdomaininfo", "n");
        }
        long[] lArray4 = lArray2;
        if (lArray2.length != 1) {
            throw new ArrayLengthException("getpowerdomaininfo", "nleft");
        }
        this.p_getpowerdomaininfo(this.native_task, l, lArray3, lArray4);
    }

    public synchronized void getprimalobj(soltype soltype2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getprimalobj", "primalobj");
        }
        this.p_getprimalobj(this.native_task, soltype2.getValue(), dArray2);
    }

    public synchronized double getprimalobj(soltype soltype2) throws Error {
        double[] dArray = new double[1];
        this.p_getprimalobj(this.native_task, soltype2.getValue(), dArray);
        return dArray[0];
    }

    public synchronized void getprimalsolutionnorms(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3) throws Error {
        double[] dArray4 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getprimalsolutionnorms", "nrmxc");
        }
        double[] dArray5 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getprimalsolutionnorms", "nrmxx");
        }
        double[] dArray6 = dArray3;
        if (dArray3.length != 1) {
            throw new ArrayLengthException("getprimalsolutionnorms", "nrmbarx");
        }
        this.p_getprimalsolutionnorms(this.native_task, soltype2.getValue(), dArray4, dArray5, dArray6);
    }

    public synchronized void getprobtype(problemtype[] problemtypeArray) throws Error {
        int[] nArray = new int[1];
        this.p_getprobtype(this.native_task, nArray);
        problemtypeArray[0] = problemtype.fromValue(nArray[0]);
    }

    public synchronized problemtype getprobtype() throws Error {
        int[] nArray = new int[1];
        this.p_getprobtype(this.native_task, nArray);
        return problemtype.fromValue(nArray[0]);
    }

    public synchronized void getprosta(soltype soltype2, prosta[] prostaArray) throws Error {
        int[] nArray = new int[1];
        this.p_getprosta(this.native_task, soltype2.getValue(), nArray);
        prostaArray[0] = prosta.fromValue(nArray[0]);
    }

    public synchronized prosta getprosta(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getprosta(this.native_task, soltype2.getValue(), nArray);
        return prosta.fromValue(nArray[0]);
    }

    public synchronized void getpviolacc(soltype soltype2, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getpviolacc", "accidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument accidxlist in getpviolacc is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpviolacc is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getpviolacc", "viol");
        }
        this.p_getpviolacc(this.native_task, soltype2.getValue(), l, lArray, dArray);
    }

    public synchronized double[] getpviolacc(soltype soltype2, long[] lArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getpviolacc", "accidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument accidxlist in getpviolacc is null");
        }
        double[] dArray = new double[(int)l];
        this.p_getpviolacc(this.native_task, soltype2.getValue(), l, lArray, dArray);
        return dArray;
    }

    public synchronized void getpviolbarvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolbarvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolbarvar is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpviolbarvar is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolbarvar", "viol");
        }
        this.p_getpviolbarvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getpviolbarvar(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolbarvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolbarvar is null");
        }
        double[] dArray = new double[n];
        this.p_getpviolbarvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getpviolcon(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolcon", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolcon is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpviolcon is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolcon", "viol");
        }
        this.p_getpviolcon(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getpviolcon(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolcon", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolcon is null");
        }
        double[] dArray = new double[n];
        this.p_getpviolcon(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getpviolcones(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolcones", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolcones is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpviolcones is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolcones", "viol");
        }
        this.p_getpviolcones(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized void getpvioldjc(soltype soltype2, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getpvioldjc", "djcidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument djcidxlist in getpvioldjc is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpvioldjc is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getpvioldjc", "viol");
        }
        this.p_getpvioldjc(this.native_task, soltype2.getValue(), l, lArray, dArray);
    }

    public synchronized double[] getpvioldjc(soltype soltype2, long[] lArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("getpvioldjc", "djcidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument djcidxlist in getpvioldjc is null");
        }
        double[] dArray = new double[(int)l];
        this.p_getpvioldjc(this.native_task, soltype2.getValue(), l, lArray, dArray);
        return dArray;
    }

    public synchronized void getpviolvar(soltype soltype2, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolvar is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument viol in getpviolvar is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("getpviolvar", "viol");
        }
        this.p_getpviolvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
    }

    public synchronized double[] getpviolvar(soltype soltype2, int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getpviolvar", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in getpviolvar is null");
        }
        double[] dArray = new double[n];
        this.p_getpviolvar(this.native_task, soltype2.getValue(), n, nArray, dArray);
        return dArray;
    }

    public synchronized void getqconk(int n, long[] lArray, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray2);
        long l = lArray2[0];
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getqconk", "numqcnz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi in getqconk is null");
        }
        long[] lArray4 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray4);
        if (nArray != null && (long)nArray.length < lArray4[0]) {
            throw new ArrayLengthException("getqconk", "qcsubi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj in getqconk is null");
        }
        long[] lArray5 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray5);
        if (nArray2 != null && (long)nArray2.length < lArray5[0]) {
            throw new ArrayLengthException("getqconk", "qcsubj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval in getqconk is null");
        }
        long[] lArray6 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray6);
        if (dArray != null && (long)dArray.length < lArray6[0]) {
            throw new ArrayLengthException("getqconk", "qcval");
        }
        this.p_getqconk64(this.native_task, n, l, lArray3, nArray, nArray2, dArray);
    }

    public synchronized long getqconk(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray);
        long l = lArray[0];
        long[] lArray2 = new long[1];
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi in getqconk is null");
        }
        long[] lArray3 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray3);
        if (nArray != null && (long)nArray.length < lArray3[0]) {
            throw new ArrayLengthException("getqconk", "qcsubi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj in getqconk is null");
        }
        long[] lArray4 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray4);
        if (nArray2 != null && (long)nArray2.length < lArray4[0]) {
            throw new ArrayLengthException("getqconk", "qcsubj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval in getqconk is null");
        }
        long[] lArray5 = new long[1];
        this.p_getnumqconknz64(this.native_task, n, lArray5);
        if (dArray != null && (long)dArray.length < lArray5[0]) {
            throw new ArrayLengthException("getqconk", "qcval");
        }
        this.p_getqconk64(this.native_task, n, l, lArray2, nArray, nArray2, dArray);
        return lArray2[0];
    }

    public synchronized void getqobj(long[] lArray, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long[] lArray2 = new long[1];
        this.p_getnumqobjnz64(this.native_task, lArray2);
        long l = lArray2[0];
        long[] lArray3 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getqobj", "numqonz");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qosubi in getqobj is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("getqobj", "qosubi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qosubj in getqobj is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("getqobj", "qosubj");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qoval in getqobj is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("getqobj", "qoval");
        }
        this.p_getqobj64(this.native_task, l, lArray3, nArray, nArray2, dArray);
    }

    public synchronized void getqobjij(int n, int n2, double[] dArray) throws Error {
        double[] dArray2 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getqobjij", "qoij");
        }
        this.p_getqobjij(this.native_task, n, n2, dArray2);
    }

    public synchronized double getqobjij(int n, int n2) throws Error {
        double[] dArray = new double[1];
        this.p_getqobjij(this.native_task, n, n2, dArray);
        return dArray[0];
    }

    public synchronized void getreducedcosts(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getreducedcosts", "redcosts");
        }
        this.p_getreducedcosts(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getreducedcosts(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getreducedcosts(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getskc(soltype soltype2, stakey[] stakeyArray) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (stakeyArray != null && stakeyArray.length < nArray[0]) {
            throw new ArrayLengthException("getskc", "skc");
        }
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskc(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
    }

    public synchronized stakey[] getskc(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        stakey[] stakeyArray = new stakey[nArray[0]];
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskc(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
        return stakeyArray;
    }

    public synchronized void getskcslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("getskcslice", "skc");
        }
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
        }
        this.p_getskcslice(this.native_task, soltype2.getValue(), n, n2, nArray);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray[i]);
            }
        }
    }

    public synchronized stakey[] getskcslice(soltype soltype2, int n, int n2) throws Error {
        stakey[] stakeyArray = new stakey[n2 - n];
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
        }
        this.p_getskcslice(this.native_task, soltype2.getValue(), n, n2, nArray);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray[i]);
            }
        }
        return stakeyArray;
    }

    public synchronized void getskn(soltype soltype2, stakey[] stakeyArray) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcone(this.native_task, nArray);
        if (stakeyArray != null && stakeyArray.length < nArray[0]) {
            throw new ArrayLengthException("getskn", "skn");
        }
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskn(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
    }

    public synchronized stakey[] getskn(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcone(this.native_task, nArray);
        stakey[] stakeyArray = new stakey[nArray[0]];
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskn(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
        return stakeyArray;
    }

    public synchronized void getskx(soltype soltype2, stakey[] stakeyArray) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (stakeyArray != null && stakeyArray.length < nArray[0]) {
            throw new ArrayLengthException("getskx", "skx");
        }
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskx(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
    }

    public synchronized stakey[] getskx(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        stakey[] stakeyArray = new stakey[nArray[0]];
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
        }
        this.p_getskx(this.native_task, soltype2.getValue(), nArray2);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray2[i]);
            }
        }
        return stakeyArray;
    }

    public synchronized void getskxslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("getskxslice", "skx");
        }
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
        }
        this.p_getskxslice(this.native_task, soltype2.getValue(), n, n2, nArray);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray[i]);
            }
        }
    }

    public synchronized stakey[] getskxslice(soltype soltype2, int n, int n2) throws Error {
        stakey[] stakeyArray = new stakey[n2 - n];
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
        }
        this.p_getskxslice(this.native_task, soltype2.getValue(), n, n2, nArray);
        if (stakeyArray != null) {
            for (int i = 0; i < stakeyArray.length; ++i) {
                stakeyArray[i] = stakey.fromValue(nArray[i]);
            }
        }
        return stakeyArray;
    }

    public synchronized void getslc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc in getslc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getslc", "slc");
        }
        this.p_getslc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getslc(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getslc(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getslcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getslcslice", "slc");
        }
        this.p_getslcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getslcslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getslcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getslx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx in getslx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getslx", "slx");
        }
        this.p_getslx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getslx(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getslx(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getslxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getslxslice", "slx");
        }
        this.p_getslxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getslxslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getslxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getsnx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument snx in getsnx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getsnx", "snx");
        }
        this.p_getsnx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getsnx(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getsnx(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getsnxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsnxslice", "snx");
        }
        this.p_getsnxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getsnxslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getsnxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getsolsta(soltype soltype2, solsta[] solstaArray) throws Error {
        int[] nArray = new int[1];
        this.p_getsolsta(this.native_task, soltype2.getValue(), nArray);
        solstaArray[0] = solsta.fromValue(nArray[0]);
    }

    public synchronized solsta getsolsta(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getsolsta(this.native_task, soltype2.getValue(), nArray);
        return solsta.fromValue(nArray[0]);
    }

    public synchronized void getsolution(soltype soltype2, prosta[] prostaArray, solsta[] solstaArray, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        int n;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.p_getnumcon(this.native_task, nArray3);
        if (stakeyArray != null && stakeyArray.length < nArray3[0]) {
            throw new ArrayLengthException("getsolution", "skc");
        }
        int[] nArray4 = null;
        if (stakeyArray != null) {
            nArray4 = new int[stakeyArray.length];
        }
        int[] nArray5 = new int[1];
        this.p_getnumvar(this.native_task, nArray5);
        if (stakeyArray2 != null && stakeyArray2.length < nArray5[0]) {
            throw new ArrayLengthException("getsolution", "skx");
        }
        int[] nArray6 = null;
        if (stakeyArray2 != null) {
            nArray6 = new int[stakeyArray2.length];
        }
        int[] nArray7 = new int[1];
        this.p_getnumcone(this.native_task, nArray7);
        if (stakeyArray3 != null && stakeyArray3.length < nArray7[0]) {
            throw new ArrayLengthException("getsolution", "skn");
        }
        int[] nArray8 = null;
        if (stakeyArray3 != null) {
            nArray8 = new int[stakeyArray3.length];
        }
        int[] nArray9 = new int[1];
        this.p_getnumcon(this.native_task, nArray9);
        if (dArray != null && dArray.length < nArray9[0]) {
            throw new ArrayLengthException("getsolution", "xc");
        }
        int[] nArray10 = new int[1];
        this.p_getnumvar(this.native_task, nArray10);
        if (dArray2 != null && dArray2.length < nArray10[0]) {
            throw new ArrayLengthException("getsolution", "xx");
        }
        int[] nArray11 = new int[1];
        this.p_getnumcon(this.native_task, nArray11);
        if (dArray3 != null && dArray3.length < nArray11[0]) {
            throw new ArrayLengthException("getsolution", "y");
        }
        int[] nArray12 = new int[1];
        this.p_getnumcon(this.native_task, nArray12);
        if (dArray4 != null && dArray4.length < nArray12[0]) {
            throw new ArrayLengthException("getsolution", "slc");
        }
        int[] nArray13 = new int[1];
        this.p_getnumcon(this.native_task, nArray13);
        if (dArray5 != null && dArray5.length < nArray13[0]) {
            throw new ArrayLengthException("getsolution", "suc");
        }
        int[] nArray14 = new int[1];
        this.p_getnumvar(this.native_task, nArray14);
        if (dArray6 != null && dArray6.length < nArray14[0]) {
            throw new ArrayLengthException("getsolution", "slx");
        }
        int[] nArray15 = new int[1];
        this.p_getnumvar(this.native_task, nArray15);
        if (dArray7 != null && dArray7.length < nArray15[0]) {
            throw new ArrayLengthException("getsolution", "sux");
        }
        int[] nArray16 = new int[1];
        this.p_getnumvar(this.native_task, nArray16);
        if (dArray8 != null && dArray8.length < nArray16[0]) {
            throw new ArrayLengthException("getsolution", "snx");
        }
        this.p_getsolution(this.native_task, soltype2.getValue(), nArray, nArray2, nArray4, nArray6, nArray8, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8);
        prostaArray[0] = prosta.fromValue(nArray[0]);
        solstaArray[0] = solsta.fromValue(nArray2[0]);
        if (stakeyArray != null) {
            for (n = 0; n < stakeyArray.length; ++n) {
                stakeyArray[n] = stakey.fromValue(nArray4[n]);
            }
        }
        if (stakeyArray2 != null) {
            for (n = 0; n < stakeyArray2.length; ++n) {
                stakeyArray2[n] = stakey.fromValue(nArray6[n]);
            }
        }
        if (stakeyArray3 != null) {
            for (n = 0; n < stakeyArray3.length; ++n) {
                stakeyArray3[n] = stakey.fromValue(nArray8[n]);
            }
        }
    }

    public synchronized void getsolutioninfo(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[] dArray11) throws Error {
        double[] dArray12 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pobj");
        }
        double[] dArray13 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pviolcon");
        }
        double[] dArray14 = dArray3;
        if (dArray3.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pviolvar");
        }
        double[] dArray15 = dArray4;
        if (dArray4.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pviolbarvar");
        }
        double[] dArray16 = dArray5;
        if (dArray5.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pviolcone");
        }
        double[] dArray17 = dArray6;
        if (dArray6.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "pviolitg");
        }
        double[] dArray18 = dArray7;
        if (dArray7.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "dobj");
        }
        double[] dArray19 = dArray8;
        if (dArray8.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "dviolcon");
        }
        double[] dArray20 = dArray9;
        if (dArray9.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "dviolvar");
        }
        double[] dArray21 = dArray10;
        if (dArray10.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "dviolbarvar");
        }
        double[] dArray22 = dArray11;
        if (dArray11.length != 1) {
            throw new ArrayLengthException("getsolutioninfo", "dviolcone");
        }
        this.p_getsolutioninfo(this.native_task, soltype2.getValue(), dArray12, dArray13, dArray14, dArray15, dArray16, dArray17, dArray18, dArray19, dArray20, dArray21, dArray22);
    }

    public synchronized void getsolutioninfonew(soltype soltype2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, double[] dArray10, double[] dArray11, double[] dArray12, double[] dArray13, double[] dArray14) throws Error {
        double[] dArray15 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pobj");
        }
        double[] dArray16 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolcon");
        }
        double[] dArray17 = dArray3;
        if (dArray3.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolvar");
        }
        double[] dArray18 = dArray4;
        if (dArray4.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolbarvar");
        }
        double[] dArray19 = dArray5;
        if (dArray5.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolcone");
        }
        double[] dArray20 = dArray6;
        if (dArray6.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolacc");
        }
        double[] dArray21 = dArray7;
        if (dArray7.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pvioldjc");
        }
        double[] dArray22 = dArray8;
        if (dArray8.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "pviolitg");
        }
        double[] dArray23 = dArray9;
        if (dArray9.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dobj");
        }
        double[] dArray24 = dArray10;
        if (dArray10.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dviolcon");
        }
        double[] dArray25 = dArray11;
        if (dArray11.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dviolvar");
        }
        double[] dArray26 = dArray12;
        if (dArray12.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dviolbarvar");
        }
        double[] dArray27 = dArray13;
        if (dArray13.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dviolcone");
        }
        double[] dArray28 = dArray14;
        if (dArray14.length != 1) {
            throw new ArrayLengthException("getsolutioninfonew", "dviolacc");
        }
        this.p_getsolutioninfonew(this.native_task, soltype2.getValue(), dArray15, dArray16, dArray17, dArray18, dArray19, dArray20, dArray21, dArray22, dArray23, dArray24, dArray25, dArray26, dArray27, dArray28);
    }

    public synchronized void getsolutionnew(soltype soltype2, prosta[] prostaArray, solsta[] solstaArray, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9) throws Error {
        int n;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.p_getnumcon(this.native_task, nArray3);
        if (stakeyArray != null && stakeyArray.length < nArray3[0]) {
            throw new ArrayLengthException("getsolutionnew", "skc");
        }
        int[] nArray4 = null;
        if (stakeyArray != null) {
            nArray4 = new int[stakeyArray.length];
        }
        int[] nArray5 = new int[1];
        this.p_getnumvar(this.native_task, nArray5);
        if (stakeyArray2 != null && stakeyArray2.length < nArray5[0]) {
            throw new ArrayLengthException("getsolutionnew", "skx");
        }
        int[] nArray6 = null;
        if (stakeyArray2 != null) {
            nArray6 = new int[stakeyArray2.length];
        }
        int[] nArray7 = new int[1];
        this.p_getnumcone(this.native_task, nArray7);
        if (stakeyArray3 != null && stakeyArray3.length < nArray7[0]) {
            throw new ArrayLengthException("getsolutionnew", "skn");
        }
        int[] nArray8 = null;
        if (stakeyArray3 != null) {
            nArray8 = new int[stakeyArray3.length];
        }
        int[] nArray9 = new int[1];
        this.p_getnumcon(this.native_task, nArray9);
        if (dArray != null && dArray.length < nArray9[0]) {
            throw new ArrayLengthException("getsolutionnew", "xc");
        }
        int[] nArray10 = new int[1];
        this.p_getnumvar(this.native_task, nArray10);
        if (dArray2 != null && dArray2.length < nArray10[0]) {
            throw new ArrayLengthException("getsolutionnew", "xx");
        }
        int[] nArray11 = new int[1];
        this.p_getnumcon(this.native_task, nArray11);
        if (dArray3 != null && dArray3.length < nArray11[0]) {
            throw new ArrayLengthException("getsolutionnew", "y");
        }
        int[] nArray12 = new int[1];
        this.p_getnumcon(this.native_task, nArray12);
        if (dArray4 != null && dArray4.length < nArray12[0]) {
            throw new ArrayLengthException("getsolutionnew", "slc");
        }
        int[] nArray13 = new int[1];
        this.p_getnumcon(this.native_task, nArray13);
        if (dArray5 != null && dArray5.length < nArray13[0]) {
            throw new ArrayLengthException("getsolutionnew", "suc");
        }
        int[] nArray14 = new int[1];
        this.p_getnumvar(this.native_task, nArray14);
        if (dArray6 != null && dArray6.length < nArray14[0]) {
            throw new ArrayLengthException("getsolutionnew", "slx");
        }
        int[] nArray15 = new int[1];
        this.p_getnumvar(this.native_task, nArray15);
        if (dArray7 != null && dArray7.length < nArray15[0]) {
            throw new ArrayLengthException("getsolutionnew", "sux");
        }
        int[] nArray16 = new int[1];
        this.p_getnumvar(this.native_task, nArray16);
        if (dArray8 != null && dArray8.length < nArray16[0]) {
            throw new ArrayLengthException("getsolutionnew", "snx");
        }
        long[] lArray = new long[1];
        this.p_getaccntot(this.native_task, lArray);
        if (dArray9 != null && (long)dArray9.length < lArray[0]) {
            throw new ArrayLengthException("getsolutionnew", "doty");
        }
        this.p_getsolutionnew(this.native_task, soltype2.getValue(), nArray, nArray2, nArray4, nArray6, nArray8, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9);
        prostaArray[0] = prosta.fromValue(nArray[0]);
        solstaArray[0] = solsta.fromValue(nArray2[0]);
        if (stakeyArray != null) {
            for (n = 0; n < stakeyArray.length; ++n) {
                stakeyArray[n] = stakey.fromValue(nArray4[n]);
            }
        }
        if (stakeyArray2 != null) {
            for (n = 0; n < stakeyArray2.length; ++n) {
                stakeyArray2[n] = stakey.fromValue(nArray6[n]);
            }
        }
        if (stakeyArray3 != null) {
            for (n = 0; n < stakeyArray3.length; ++n) {
                stakeyArray3[n] = stakey.fromValue(nArray8[n]);
            }
        }
    }

    public synchronized void getsolutionslice(soltype soltype2, solitem solitem2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsolutionslice", "values");
        }
        this.p_getsolutionslice(this.native_task, soltype2.getValue(), solitem2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getsolutionslice(soltype soltype2, solitem solitem2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getsolutionslice(this.native_task, soltype2.getValue(), solitem2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getsparsesymmat(long l, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int[] nArray3 = new int[1];
        long[] lArray = new long[1];
        int[] nArray4 = new int[1];
        this.p_getsymmatinfo(this.native_task, l, nArray3, lArray, nArray4);
        long l2 = lArray[0];
        if (nArray != null && (long)nArray.length < l2) {
            throw new ArrayLengthException("getsparsesymmat", "subi");
        }
        if (nArray2 != null && (long)nArray2.length < l2) {
            throw new ArrayLengthException("getsparsesymmat", "subj");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("getsparsesymmat", "valij");
        }
        this.p_getsparsesymmat(this.native_task, l, l2, nArray, nArray2, dArray);
    }

    public synchronized String getstrparam(sparam sparam2, int[] nArray) throws Error {
        int n;
        int[] nArray2 = new int[1];
        this.p_getstrparamlen(this.native_task, sparam2.getValue(), nArray2);
        int n2 = 1 + nArray2[0];
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getstrparam", "len");
        }
        byte[] byArray = new byte[n2];
        this.p_getstrparam(this.native_task, sparam2.getValue(), n2, nArray3, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getstrparamlen(sparam sparam2, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getstrparamlen", "len");
        }
        this.p_getstrparamlen(this.native_task, sparam2.getValue(), nArray2);
    }

    public synchronized int getstrparamlen(sparam sparam2) throws Error {
        int[] nArray = new int[1];
        this.p_getstrparamlen(this.native_task, sparam2.getValue(), nArray);
        return nArray[0];
    }

    public synchronized void getsuc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc in getsuc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getsuc", "suc");
        }
        this.p_getsuc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getsuc(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getsuc(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getsucslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsucslice", "suc");
        }
        this.p_getsucslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getsucslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getsucslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getsux(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux in getsux is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getsux", "sux");
        }
        this.p_getsux(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getsux(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getsux(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getsuxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getsuxslice", "sux");
        }
        this.p_getsuxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getsuxslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getsuxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getsymmatinfo(long l, int[] nArray, long[] lArray, symmattype[] symmattypeArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getsymmatinfo", "dim");
        }
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("getsymmatinfo", "nz");
        }
        int[] nArray3 = new int[1];
        this.p_getsymmatinfo(this.native_task, l, nArray2, lArray2, nArray3);
        symmattypeArray[0] = symmattype.fromValue(nArray3[0]);
    }

    public synchronized String gettaskname() throws Error {
        int n;
        int[] nArray = new int[1];
        this.p_gettasknamelen(this.native_task, nArray);
        int n2 = 1 + nArray[0];
        byte[] byArray = new byte[n2];
        this.p_gettaskname(this.native_task, n2, byArray);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void gettasknamelen(int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("gettasknamelen", "len");
        }
        this.p_gettasknamelen(this.native_task, nArray2);
    }

    public synchronized int gettasknamelen() throws Error {
        int[] nArray = new int[1];
        this.p_gettasknamelen(this.native_task, nArray);
        return nArray[0];
    }

    public synchronized void getvarbound(int n, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int[] nArray = new int[1];
        double[] dArray3 = dArray;
        if (dArray.length != 1) {
            throw new ArrayLengthException("getvarbound", "bl");
        }
        double[] dArray4 = dArray2;
        if (dArray2.length != 1) {
            throw new ArrayLengthException("getvarbound", "bu");
        }
        this.p_getvarbound(this.native_task, n, nArray, dArray3, dArray4);
        boundkeyArray[0] = boundkey.fromValue(nArray[0]);
    }

    public synchronized void getvarboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bk");
        }
        int[] nArray = null;
        if (boundkeyArray != null) {
            nArray = new int[boundkeyArray.length];
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bl");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("getvarboundslice", "bu");
        }
        this.p_getvarboundslice(this.native_task, n, n2, nArray, dArray, dArray2);
        if (boundkeyArray != null) {
            for (int i = 0; i < boundkeyArray.length; ++i) {
                boundkeyArray[i] = boundkey.fromValue(nArray[i]);
            }
        }
    }

    public synchronized String getvarname(int n) throws Error {
        int n2;
        int[] nArray = new int[1];
        this.p_getvarnamelen(this.native_task, n, nArray);
        int n3 = 1 + nArray[0];
        byte[] byArray = new byte[n3];
        this.p_getvarname(this.native_task, n, n3, byArray);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public synchronized void getvarnameindex(String string, int[] nArray, int[] nArray2) throws Error {
        int[] nArray3 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getvarnameindex", "asgn");
        }
        int[] nArray4 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getvarnameindex", "index");
        }
        this.p_getvarnameindex(this.native_task, string, nArray3, nArray4);
    }

    public synchronized int getvarnameindex(String string, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getvarnameindex", "asgn");
        }
        int[] nArray3 = new int[1];
        this.p_getvarnameindex(this.native_task, string, nArray2, nArray3);
        return nArray3[0];
    }

    public synchronized void getvarnamelen(int n, int[] nArray) throws Error {
        int[] nArray2 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getvarnamelen", "len");
        }
        this.p_getvarnamelen(this.native_task, n, nArray2);
    }

    public synchronized int getvarnamelen(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getvarnamelen(this.native_task, n, nArray);
        return nArray[0];
    }

    public synchronized void getvartype(int n, variabletype[] variabletypeArray) throws Error {
        int[] nArray = new int[1];
        this.p_getvartype(this.native_task, n, nArray);
        variabletypeArray[0] = variabletype.fromValue(nArray[0]);
    }

    public synchronized variabletype getvartype(int n) throws Error {
        int[] nArray = new int[1];
        this.p_getvartype(this.native_task, n, nArray);
        return variabletype.fromValue(nArray[0]);
    }

    public synchronized void getvartypelist(int[] nArray, variabletype[] variabletypeArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getvartypelist", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getvartypelist is null");
        }
        if (variabletypeArray != null && variabletypeArray.length < n) {
            throw new ArrayLengthException("getvartypelist", "vartype");
        }
        int[] nArray2 = null;
        if (variabletypeArray != null) {
            nArray2 = new int[variabletypeArray.length];
        }
        this.p_getvartypelist(this.native_task, n, nArray, nArray2);
        if (variabletypeArray != null) {
            for (int i = 0; i < variabletypeArray.length; ++i) {
                variabletypeArray[i] = variabletype.fromValue(nArray2[i]);
            }
        }
    }

    public synchronized variabletype[] getvartypelist(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("getvartypelist", "subj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in getvartypelist is null");
        }
        variabletype[] variabletypeArray = new variabletype[n];
        int[] nArray2 = null;
        if (variabletypeArray != null) {
            nArray2 = new int[variabletypeArray.length];
        }
        this.p_getvartypelist(this.native_task, n, nArray, nArray2);
        if (variabletypeArray != null) {
            for (int i = 0; i < variabletypeArray.length; ++i) {
                variabletypeArray[i] = variabletype.fromValue(nArray2[i]);
            }
        }
        return variabletypeArray;
    }

    public synchronized void getxc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc in getxc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getxc", "xc");
        }
        this.p_getxc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getxc(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getxc(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getxcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getxcslice", "xc");
        }
        this.p_getxcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getxcslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getxcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void getxx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx in getxx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("getxx", "xx");
        }
        this.p_getxx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] getxx(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_getxx(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getxxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getxxslice", "xx");
        }
        this.p_getxxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getxxslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getxxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void gety(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y in gety is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("gety", "y");
        }
        this.p_gety(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized double[] gety(soltype soltype2) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        double[] dArray = new double[nArray[0]];
        this.p_gety(this.native_task, soltype2.getValue(), dArray);
        return dArray;
    }

    public synchronized void getyslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("getyslice", "y");
        }
        this.p_getyslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized double[] getyslice(soltype soltype2, int n, int n2) throws Error {
        double[] dArray = new double[n2 - n];
        this.p_getyslice(this.native_task, soltype2.getValue(), n, n2, dArray);
        return dArray;
    }

    public synchronized void infeasibilityreport(streamtype streamtype2, soltype soltype2) throws Error {
        this.p_infeasibilityreport(this.native_task, streamtype2.getValue(), soltype2.getValue());
    }

    public synchronized void initbasissolve(int[] nArray) throws Error {
        int[] nArray2 = new int[1];
        this.p_getnumcon(this.native_task, nArray2);
        if (nArray != null && nArray.length < nArray2[0]) {
            throw new ArrayLengthException("initbasissolve", "basis");
        }
        this.p_initbasissolve(this.native_task, nArray);
    }

    public synchronized void inputdata(int n, int n2, double[] dArray, double d, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray2, boundkey[] boundkeyArray, double[] dArray3, double[] dArray4, boundkey[] boundkeyArray2, double[] dArray5, double[] dArray6) throws Error {
        int n3 = -1;
        if (dArray4 != null) {
            if (n3 < 0) {
                n3 = dArray4.length;
            } else if (n3 != dArray4.length) {
                throw new ArrayLengthException("inputdata", "buc");
            }
        }
        if (dArray3 != null) {
            if (n3 < 0) {
                n3 = dArray3.length;
            } else if (n3 != dArray3.length) {
                throw new ArrayLengthException("inputdata", "blc");
            }
        }
        if (boundkeyArray != null) {
            if (n3 < 0) {
                n3 = boundkeyArray.length;
            } else if (n3 != boundkeyArray.length) {
                throw new ArrayLengthException("inputdata", "bkc");
            }
        }
        int n4 = -1;
        if (dArray != null) {
            if (n4 < 0) {
                n4 = dArray.length;
            } else if (n4 != dArray.length) {
                throw new ArrayLengthException("inputdata", "c");
            }
        }
        if (dArray6 != null) {
            if (n4 < 0) {
                n4 = dArray6.length;
            } else if (n4 != dArray6.length) {
                throw new ArrayLengthException("inputdata", "bux");
            }
        }
        if (dArray5 != null) {
            if (n4 < 0) {
                n4 = dArray5.length;
            } else if (n4 != dArray5.length) {
                throw new ArrayLengthException("inputdata", "blx");
            }
        }
        if (boundkeyArray2 != null) {
            if (n4 < 0) {
                n4 = boundkeyArray2.length;
            } else if (n4 != boundkeyArray2.length) {
                throw new ArrayLengthException("inputdata", "bkx");
            }
        }
        if (nArray != null) {
            if (n4 < 0) {
                n4 = nArray.length;
            } else if (n4 != nArray.length) {
                throw new ArrayLengthException("inputdata", "aptrb");
            }
        }
        if (nArray2 != null) {
            if (n4 < 0) {
                n4 = nArray2.length;
            } else if (n4 != nArray2.length) {
                throw new ArrayLengthException("inputdata", "aptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument aptrb in inputdata is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument aptre in inputdata is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub in inputdata is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument aval in inputdata is null");
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc in inputdata is null");
        }
        int[] nArray4 = null;
        if (boundkeyArray != null) {
            nArray4 = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray4[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument blc in inputdata is null");
        }
        if (dArray4 == null) {
            throw new NullPointerException("Argument buc in inputdata is null");
        }
        if (boundkeyArray2 == null) {
            throw new NullPointerException("Argument bkx in inputdata is null");
        }
        int[] nArray5 = null;
        if (boundkeyArray2 != null) {
            nArray5 = new int[boundkeyArray2.length];
            for (int i = 0; i < boundkeyArray2.length; ++i) {
                nArray5[i] = boundkeyArray2[i].getValue();
            }
        }
        if (dArray5 == null) {
            throw new NullPointerException("Argument blx in inputdata is null");
        }
        if (dArray6 == null) {
            throw new NullPointerException("Argument bux in inputdata is null");
        }
        this.p_inputdata(this.native_task, n, n2, n3, n4, dArray, d, nArray, nArray2, nArray3, dArray2, nArray4, dArray3, dArray4, nArray5, dArray5, dArray6);
    }

    public synchronized void inputdata(int n, int n2, double[] dArray, double d, long[] lArray, long[] lArray2, int[] nArray, double[] dArray2, boundkey[] boundkeyArray, double[] dArray3, double[] dArray4, boundkey[] boundkeyArray2, double[] dArray5, double[] dArray6) throws Error {
        int n3 = -1;
        if (dArray4 != null) {
            if (n3 < 0) {
                n3 = dArray4.length;
            } else if (n3 != dArray4.length) {
                throw new ArrayLengthException("inputdata", "buc");
            }
        }
        if (dArray3 != null) {
            if (n3 < 0) {
                n3 = dArray3.length;
            } else if (n3 != dArray3.length) {
                throw new ArrayLengthException("inputdata", "blc");
            }
        }
        if (boundkeyArray != null) {
            if (n3 < 0) {
                n3 = boundkeyArray.length;
            } else if (n3 != boundkeyArray.length) {
                throw new ArrayLengthException("inputdata", "bkc");
            }
        }
        int n4 = -1;
        if (dArray != null) {
            if (n4 < 0) {
                n4 = dArray.length;
            } else if (n4 != dArray.length) {
                throw new ArrayLengthException("inputdata", "c");
            }
        }
        if (dArray6 != null) {
            if (n4 < 0) {
                n4 = dArray6.length;
            } else if (n4 != dArray6.length) {
                throw new ArrayLengthException("inputdata", "bux");
            }
        }
        if (dArray5 != null) {
            if (n4 < 0) {
                n4 = dArray5.length;
            } else if (n4 != dArray5.length) {
                throw new ArrayLengthException("inputdata", "blx");
            }
        }
        if (boundkeyArray2 != null) {
            if (n4 < 0) {
                n4 = boundkeyArray2.length;
            } else if (n4 != boundkeyArray2.length) {
                throw new ArrayLengthException("inputdata", "bkx");
            }
        }
        if (lArray != null) {
            if (n4 < 0) {
                n4 = lArray.length;
            } else if (n4 != lArray.length) {
                throw new ArrayLengthException("inputdata", "aptrb");
            }
        }
        if (lArray2 != null) {
            if (n4 < 0) {
                n4 = lArray2.length;
            } else if (n4 != lArray2.length) {
                throw new ArrayLengthException("inputdata", "aptre");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument aptrb in inputdata is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument aptre in inputdata is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub in inputdata is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument aval in inputdata is null");
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc in inputdata is null");
        }
        int[] nArray2 = null;
        if (boundkeyArray != null) {
            nArray2 = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray2[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument blc in inputdata is null");
        }
        if (dArray4 == null) {
            throw new NullPointerException("Argument buc in inputdata is null");
        }
        if (boundkeyArray2 == null) {
            throw new NullPointerException("Argument bkx in inputdata is null");
        }
        int[] nArray3 = null;
        if (boundkeyArray2 != null) {
            nArray3 = new int[boundkeyArray2.length];
            for (int i = 0; i < boundkeyArray2.length; ++i) {
                nArray3[i] = boundkeyArray2[i].getValue();
            }
        }
        if (dArray5 == null) {
            throw new NullPointerException("Argument blx in inputdata is null");
        }
        if (dArray6 == null) {
            throw new NullPointerException("Argument bux in inputdata is null");
        }
        this.p_inputdata64(this.native_task, n, n2, n3, n4, dArray, d, lArray, lArray2, nArray, dArray2, nArray2, dArray3, dArray4, nArray3, dArray5, dArray6);
    }

    public synchronized void isdouparname(String string, dparam[] dparamArray) throws Error {
        int[] nArray = new int[1];
        this.p_isdouparname(this.native_task, string, nArray);
        dparamArray[0] = dparam.fromValue(nArray[0]);
    }

    public synchronized void isintparname(String string, iparam[] iparamArray) throws Error {
        int[] nArray = new int[1];
        this.p_isintparname(this.native_task, string, nArray);
        iparamArray[0] = iparam.fromValue(nArray[0]);
    }

    public synchronized void isstrparname(String string, sparam[] sparamArray) throws Error {
        int[] nArray = new int[1];
        this.p_isstrparname(this.native_task, string, nArray);
        sparamArray[0] = sparam.fromValue(nArray[0]);
    }

    public synchronized void linkfiletostream(streamtype streamtype2, String string, int n) throws Error {
        this.p_linkfiletotaskstream(this.native_task, streamtype2.getValue(), string, n);
    }

    public synchronized void onesolutionsummary(streamtype streamtype2, soltype soltype2) throws Error {
        this.p_onesolutionsummary(this.native_task, streamtype2.getValue(), soltype2.getValue());
    }

    public synchronized void optimizermt(String string, String string2, rescode[] rescodeArray) throws Error {
        int[] nArray = new int[1];
        this.p_optimizermt(this.native_task, string, string2, nArray);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
    }

    public synchronized rescode optimizermt(String string, String string2) throws Error {
        int[] nArray = new int[1];
        this.p_optimizermt(this.native_task, string, string2, nArray);
        return rescode.fromValue(nArray[0]);
    }

    public synchronized void optimizersummary(streamtype streamtype2) throws Error {
        this.p_optimizersummary(this.native_task, streamtype2.getValue());
    }

    public synchronized void optimize(rescode[] rescodeArray) throws Error {
        int[] nArray = new int[1];
        this.p_optimizetrm(this.native_task, nArray);
        rescodeArray[0] = rescode.fromValue(nArray[0]);
    }

    public synchronized rescode optimize() throws Error {
        int[] nArray = new int[1];
        this.p_optimizetrm(this.native_task, nArray);
        return rescode.fromValue(nArray[0]);
    }

    public synchronized void primalrepair(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) throws Error {
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("primalrepair", "wlc");
        }
        int[] nArray2 = new int[1];
        this.p_getnumcon(this.native_task, nArray2);
        if (dArray2 != null && dArray2.length < nArray2[0]) {
            throw new ArrayLengthException("primalrepair", "wuc");
        }
        int[] nArray3 = new int[1];
        this.p_getnumvar(this.native_task, nArray3);
        if (dArray3 != null && dArray3.length < nArray3[0]) {
            throw new ArrayLengthException("primalrepair", "wlx");
        }
        int[] nArray4 = new int[1];
        this.p_getnumvar(this.native_task, nArray4);
        if (dArray4 != null && dArray4.length < nArray4[0]) {
            throw new ArrayLengthException("primalrepair", "wux");
        }
        this.p_primalrepair(this.native_task, dArray, dArray2, dArray3, dArray4);
    }

    public synchronized void primalsensitivity(int[] nArray, mark[] markArray, int[] nArray2, mark[] markArray2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        int n;
        int n2 = -1;
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("primalsensitivity", "subi");
            }
        }
        if (markArray != null) {
            if (n2 < 0) {
                n2 = markArray.length;
            } else if (n2 != markArray.length) {
                throw new ArrayLengthException("primalsensitivity", "marki");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in primalsensitivity is null");
        }
        if (markArray == null) {
            throw new NullPointerException("Argument marki in primalsensitivity is null");
        }
        int[] nArray3 = null;
        if (markArray != null) {
            nArray3 = new int[markArray.length];
            for (n = 0; n < markArray.length; ++n) {
                nArray3[n] = markArray[n].getValue();
            }
        }
        n = -1;
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("primalsensitivity", "subj");
            }
        }
        if (markArray2 != null) {
            if (n < 0) {
                n = markArray2.length;
            } else if (n != markArray2.length) {
                throw new ArrayLengthException("primalsensitivity", "markj");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in primalsensitivity is null");
        }
        if (markArray2 == null) {
            throw new NullPointerException("Argument markj in primalsensitivity is null");
        }
        int[] nArray4 = null;
        if (markArray2 != null) {
            nArray4 = new int[markArray2.length];
            for (int i = 0; i < markArray2.length; ++i) {
                nArray4[i] = markArray2[i].getValue();
            }
        }
        if (dArray != null && dArray.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "leftpricei");
        }
        if (dArray2 != null && dArray2.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "rightpricei");
        }
        if (dArray3 != null && dArray3.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "leftrangei");
        }
        if (dArray4 != null && dArray4.length < n2) {
            throw new ArrayLengthException("primalsensitivity", "rightrangei");
        }
        if (dArray5 != null && dArray5.length < n) {
            throw new ArrayLengthException("primalsensitivity", "leftpricej");
        }
        if (dArray6 != null && dArray6.length < n) {
            throw new ArrayLengthException("primalsensitivity", "rightpricej");
        }
        if (dArray7 != null && dArray7.length < n) {
            throw new ArrayLengthException("primalsensitivity", "leftrangej");
        }
        if (dArray8 != null && dArray8.length < n) {
            throw new ArrayLengthException("primalsensitivity", "rightrangej");
        }
        this.p_primalsensitivity(this.native_task, n2, nArray, nArray3, n, nArray2, nArray4, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8);
    }

    public synchronized void putacc(long l, long l2, long[] lArray, double[] dArray) throws Error {
        long l3 = -1L;
        if (lArray != null) {
            if (l3 < 0L) {
                l3 = lArray.length;
            } else if (l3 != (long)lArray.length) {
                throw new ArrayLengthException("putacc", "afeidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidxlist in putacc is null");
        }
        if (dArray != null && (long)dArray.length < l3) {
            throw new ArrayLengthException("putacc", "b");
        }
        this.p_putacc(this.native_task, l, l2, l3, lArray, dArray);
    }

    public synchronized void putaccb(long l, double[] dArray) throws Error {
        long l2 = -1L;
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("putaccb", "b");
            }
        }
        this.p_putaccb(this.native_task, l, l2, dArray);
    }

    public synchronized void putaccbj(long l, long l2, double d) throws Error {
        this.p_putaccbj(this.native_task, l, l2, d);
    }

    public synchronized void putaccdoty(soltype soltype2, long l, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument doty in putaccdoty is null");
        }
        long[] lArray = new long[1];
        this.p_getaccn(this.native_task, l, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("putaccdoty", "doty");
        }
        this.p_putaccdoty(this.native_task, soltype2.getValue(), l, dArray);
    }

    public synchronized void putacclist(long[] lArray, long[] lArray2, long[] lArray3, double[] dArray) throws Error {
        long l = -1L;
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("putacclist", "domidxs");
            }
        }
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putacclist", "accidxs");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument accidxs in putacclist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument domidxs in putacclist is null");
        }
        long l2 = -1L;
        if (lArray3 != null) {
            if (l2 < 0L) {
                l2 = lArray3.length;
            } else if (l2 != (long)lArray3.length) {
                throw new ArrayLengthException("putacclist", "afeidxlist");
            }
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument afeidxlist in putacclist is null");
        }
        if (dArray != null && (long)dArray.length < l2) {
            throw new ArrayLengthException("putacclist", "b");
        }
        this.p_putacclist(this.native_task, l, lArray, lArray2, l2, lArray3, dArray);
    }

    public synchronized void putaccname(long l, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putaccname is null");
        }
        this.p_putaccname(this.native_task, l, string);
    }

    public synchronized void putacol(int n, int[] nArray, double[] dArray) throws Error {
        int n2 = -1;
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("putacol", "subj");
            }
        }
        if (dArray != null) {
            if (n2 < 0) {
                n2 = dArray.length;
            } else if (n2 != dArray.length) {
                throw new ArrayLengthException("putacol", "valj");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in putacol is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valj in putacol is null");
        }
        this.p_putacol(this.native_task, n, n2, nArray, dArray);
    }

    public synchronized void putacollist(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putacollist", "sub");
            }
        }
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("putacollist", "ptrb");
            }
        }
        if (nArray3 != null) {
            if (n < 0) {
                n = nArray3.length;
            } else if (n != nArray3.length) {
                throw new ArrayLengthException("putacollist", "ptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putacollist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptrb in putacollist is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument ptre in putacollist is null");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument asub in putacollist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putacollist is null");
        }
        this.p_putacollist(this.native_task, n, nArray, nArray2, nArray3, nArray4, dArray);
    }

    public synchronized void putacolslice(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument ptrb in putacolslice is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptre in putacolslice is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub in putacolslice is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putacolslice is null");
        }
        this.p_putacolslice(this.native_task, n, n2, nArray, nArray2, nArray3, dArray);
    }

    public synchronized void putacolslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in putacolslice is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in putacolslice is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub in putacolslice is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putacolslice is null");
        }
        this.p_putacolslice64(this.native_task, n, n2, lArray, lArray2, nArray, dArray);
    }

    public synchronized void putafebarfblocktriplet(long[] lArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafebarfblocktriplet", "afeidx");
            }
        }
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putafebarfblocktriplet", "barvaridx");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("putafebarfblocktriplet", "subk");
            }
        }
        if (nArray3 != null) {
            if (l < 0L) {
                l = nArray3.length;
            } else if (l != (long)nArray3.length) {
                throw new ArrayLengthException("putafebarfblocktriplet", "subl");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putafebarfblocktriplet", "valkl");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafebarfblocktriplet is null");
        }
        if (lArray != null && (long)lArray.length < l) {
            throw new ArrayLengthException("putafebarfblocktriplet", "afeidx");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in putafebarfblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("putafebarfblocktriplet", "barvaridx");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in putafebarfblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("putafebarfblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in putafebarfblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("putafebarfblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valkl in putafebarfblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("putafebarfblocktriplet", "valkl");
        }
        this.p_putafebarfblocktriplet(this.native_task, l, lArray, nArray, nArray2, nArray3, dArray);
    }

    public synchronized void putafebarfentry(long l, int n, long[] lArray, double[] dArray) throws Error {
        long l2 = -1L;
        if (lArray != null) {
            if (l2 < 0L) {
                l2 = lArray.length;
            } else if (l2 != (long)lArray.length) {
                throw new ArrayLengthException("putafebarfentry", "termidx");
            }
        }
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("putafebarfentry", "termweight");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument termidx in putafebarfentry is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument termweight in putafebarfentry is null");
        }
        this.p_putafebarfentry(this.native_task, l, n, l2, lArray, dArray);
    }

    public synchronized void putafebarfentrylist(long[] lArray, int[] nArray, long[] lArray2, long[] lArray3, long[] lArray4, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafebarfentrylist", "afeidx");
            }
        }
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putafebarfentrylist", "barvaridx");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("putafebarfentrylist", "numterm");
            }
        }
        if (lArray3 != null) {
            if (l < 0L) {
                l = lArray3.length;
            } else if (l != (long)lArray3.length) {
                throw new ArrayLengthException("putafebarfentrylist", "ptrterm");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafebarfentrylist is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in putafebarfentrylist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument numterm in putafebarfentrylist is null");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument ptrterm in putafebarfentrylist is null");
        }
        long l2 = -1L;
        if (lArray4 != null) {
            if (l2 < 0L) {
                l2 = lArray4.length;
            } else if (l2 != (long)lArray4.length) {
                throw new ArrayLengthException("putafebarfentrylist", "termidx");
            }
        }
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("putafebarfentrylist", "termweight");
            }
        }
        if (lArray4 == null) {
            throw new NullPointerException("Argument termidx in putafebarfentrylist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument termweight in putafebarfentrylist is null");
        }
        this.p_putafebarfentrylist(this.native_task, l, lArray, nArray, lArray2, lArray3, l2, lArray4, dArray);
    }

    public synchronized void putafebarfrow(long l, int[] nArray, long[] lArray, long[] lArray2, long[] lArray3, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putafebarfrow", "barvaridx");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("putafebarfrow", "numterm");
            }
        }
        if (lArray2 != null) {
            if (n < 0) {
                n = lArray2.length;
            } else if (n != lArray2.length) {
                throw new ArrayLengthException("putafebarfrow", "ptrterm");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument barvaridx in putafebarfrow is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument numterm in putafebarfrow is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptrterm in putafebarfrow is null");
        }
        long l2 = -1L;
        if (lArray3 != null) {
            if (l2 < 0L) {
                l2 = lArray3.length;
            } else if (l2 != (long)lArray3.length) {
                throw new ArrayLengthException("putafebarfrow", "termidx");
            }
        }
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("putafebarfrow", "termweight");
            }
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument termidx in putafebarfrow is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument termweight in putafebarfrow is null");
        }
        this.p_putafebarfrow(this.native_task, l, n, nArray, lArray, lArray2, l2, lArray3, dArray);
    }

    public synchronized void putafefcol(int n, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafefcol", "afeidx");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putafefcol", "val");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafefcol is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in putafefcol is null");
        }
        this.p_putafefcol(this.native_task, n, l, lArray, dArray);
    }

    public synchronized void putafefentry(long l, int n, double d) throws Error {
        this.p_putafefentry(this.native_task, l, n, d);
    }

    public synchronized void putafefentrylist(long[] lArray, int[] nArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafefentrylist", "afeidx");
            }
        }
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putafefentrylist", "varidx");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putafefentrylist", "val");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafefentrylist is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument varidx in putafefentrylist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in putafefentrylist is null");
        }
        this.p_putafefentrylist(this.native_task, l, lArray, nArray, dArray);
    }

    public synchronized void putafefrow(long l, int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putafefrow", "varidx");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putafefrow", "val");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument varidx in putafefrow is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in putafefrow is null");
        }
        this.p_putafefrow(this.native_task, l, n, nArray, dArray);
    }

    public synchronized void putafefrowlist(long[] lArray, int[] nArray, long[] lArray2, int[] nArray2, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafefrowlist", "afeidx");
            }
        }
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putafefrowlist", "numnzrow");
            }
        }
        if (lArray2 != null) {
            if (l < 0L) {
                l = lArray2.length;
            } else if (l != (long)lArray2.length) {
                throw new ArrayLengthException("putafefrowlist", "ptrrow");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafefrowlist is null");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument numnzrow in putafefrowlist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptrrow in putafefrowlist is null");
        }
        long l2 = -1L;
        if (nArray2 != null) {
            if (l2 < 0L) {
                l2 = nArray2.length;
            } else if (l2 != (long)nArray2.length) {
                throw new ArrayLengthException("putafefrowlist", "varidx");
            }
        }
        if (dArray != null) {
            if (l2 < 0L) {
                l2 = dArray.length;
            } else if (l2 != (long)dArray.length) {
                throw new ArrayLengthException("putafefrowlist", "val");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument varidx in putafefrowlist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in putafefrowlist is null");
        }
        this.p_putafefrowlist(this.native_task, l, lArray, nArray, lArray2, l2, nArray2, dArray);
    }

    public synchronized void putafeg(long l, double d) throws Error {
        this.p_putafeg(this.native_task, l, d);
    }

    public synchronized void putafeglist(long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putafeglist", "afeidx");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putafeglist", "g");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument afeidx in putafeglist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument g in putafeglist is null");
        }
        this.p_putafeglist(this.native_task, l, lArray, dArray);
    }

    public synchronized void putafegslice(long l, long l2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slice in putafegslice is null");
        }
        if (dArray != null && (long)dArray.length < l2 - l) {
            throw new ArrayLengthException("putafegslice", "slice");
        }
        this.p_putafegslice(this.native_task, l, l2, dArray);
    }

    public synchronized void putaij(int n, int n2, double d) throws Error {
        this.p_putaij(this.native_task, n, n2, d);
    }

    public synchronized void putaijlist(int[] nArray, int[] nArray2, double[] dArray) throws Error {
        long l = -1L;
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putaijlist", "subi");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("putaijlist", "subj");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putaijlist", "valij");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in putaijlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in putaijlist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valij in putaijlist is null");
        }
        this.p_putaijlist64(this.native_task, l, nArray, nArray2, dArray);
    }

    public synchronized void putarow(int n, int[] nArray, double[] dArray) throws Error {
        int n2 = -1;
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("putarow", "subi");
            }
        }
        if (dArray != null) {
            if (n2 < 0) {
                n2 = dArray.length;
            } else if (n2 != dArray.length) {
                throw new ArrayLengthException("putarow", "vali");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in putarow is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument vali in putarow is null");
        }
        this.p_putarow(this.native_task, n, n2, nArray, dArray);
    }

    public synchronized void putarowlist(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putarowlist", "sub");
            }
        }
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("putarowlist", "ptrb");
            }
        }
        if (nArray3 != null) {
            if (n < 0) {
                n = nArray3.length;
            } else if (n != nArray3.length) {
                throw new ArrayLengthException("putarowlist", "ptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putarowlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptrb in putarowlist is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument ptre in putarowlist is null");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument asub in putarowlist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putarowlist is null");
        }
        this.p_putarowlist(this.native_task, n, nArray, nArray2, nArray3, nArray4, dArray);
    }

    public synchronized void putarowlist(int[] nArray, long[] lArray, long[] lArray2, int[] nArray2, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putarowlist", "sub");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("putarowlist", "ptrb");
            }
        }
        if (lArray2 != null) {
            if (n < 0) {
                n = lArray2.length;
            } else if (n != lArray2.length) {
                throw new ArrayLengthException("putarowlist", "ptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putarowlist is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in putarowlist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in putarowlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument asub in putarowlist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putarowlist is null");
        }
        this.p_putarowlist64(this.native_task, n, nArray, lArray, lArray2, nArray2, dArray);
    }

    public synchronized void putarowslice(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument ptrb in putarowslice is null");
        }
        if (nArray != null && nArray.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptrb");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument ptre in putarowslice is null");
        }
        if (nArray2 != null && nArray2.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptre");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument asub in putarowslice is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putarowslice is null");
        }
        this.p_putarowslice(this.native_task, n, n2, nArray, nArray2, nArray3, dArray);
    }

    public synchronized void putarowslice(int n, int n2, long[] lArray, long[] lArray2, int[] nArray, double[] dArray) throws Error {
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in putarowslice is null");
        }
        if (lArray != null && lArray.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptrb");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in putarowslice is null");
        }
        if (lArray2 != null && lArray2.length < n2 - n) {
            throw new ArrayLengthException("putarowslice", "ptre");
        }
        if (nArray == null) {
            throw new NullPointerException("Argument asub in putarowslice is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument aval in putarowslice is null");
        }
        this.p_putarowslice64(this.native_task, n, n2, lArray, lArray2, nArray, dArray);
    }

    public synchronized void putatruncatetol(double d) throws Error {
        this.p_putatruncatetol(this.native_task, d);
    }

    public synchronized void putbarablocktriplet(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double[] dArray) throws Error {
        long l = -1L;
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("putbarablocktriplet", "subj");
            }
        }
        if (nArray3 != null) {
            if (l < 0L) {
                l = nArray3.length;
            } else if (l != (long)nArray3.length) {
                throw new ArrayLengthException("putbarablocktriplet", "subk");
            }
        }
        if (nArray4 != null) {
            if (l < 0L) {
                l = nArray4.length;
            } else if (l != (long)nArray4.length) {
                throw new ArrayLengthException("putbarablocktriplet", "subl");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putbarablocktriplet", "valijkl");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in putbarablocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subi");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in putbarablocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subj");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subk in putbarablocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subk");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument subl in putbarablocktriplet is null");
        }
        if (nArray4 != null && (long)nArray4.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valijkl in putbarablocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("putbarablocktriplet", "valijkl");
        }
        this.p_putbarablocktriplet(this.native_task, l, nArray, nArray2, nArray3, nArray4, dArray);
    }

    public synchronized void putbaraij(int n, int n2, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putbaraij", "sub");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putbaraij", "weights");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub in putbaraij is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in putbaraij is null");
        }
        this.p_putbaraij(this.native_task, n, n2, l, lArray, dArray);
    }

    public synchronized void putbaraijlist(int[] nArray, int[] nArray2, long[] lArray, long[] lArray2, long[] lArray3, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putbaraijlist", "subi");
            }
        }
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("putbaraijlist", "subj");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("putbaraijlist", "alphaptrb");
            }
        }
        if (lArray2 != null) {
            if (n < 0) {
                n = lArray2.length;
            } else if (n != lArray2.length) {
                throw new ArrayLengthException("putbaraijlist", "alphaptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in putbaraijlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in putbaraijlist is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument alphaptrb in putbaraijlist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument alphaptre in putbaraijlist is null");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument matidx in putbaraijlist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in putbaraijlist is null");
        }
        this.p_putbaraijlist(this.native_task, n, nArray, nArray2, lArray, lArray2, lArray3, dArray);
    }

    public synchronized void putbararowlist(int[] nArray, long[] lArray, long[] lArray2, int[] nArray2, long[] lArray3, long[] lArray4, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putbararowlist", "subi");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("putbararowlist", "ptrb");
            }
        }
        if (lArray2 != null) {
            if (n < 0) {
                n = lArray2.length;
            } else if (n != lArray2.length) {
                throw new ArrayLengthException("putbararowlist", "ptre");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subi in putbararowlist is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument ptrb in putbararowlist is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument ptre in putbararowlist is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subj in putbararowlist is null");
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument nummat in putbararowlist is null");
        }
        if (lArray3 != null && lArray3.length < nArray2.length) {
            throw new ArrayLengthException("putbararowlist", "nummat");
        }
        if (lArray4 == null) {
            throw new NullPointerException("Argument matidx in putbararowlist is null");
        }
        long l = 0L;
        for (long l2 : lArray3) {
            l += l2;
        }
        if (lArray4 != null && (long)lArray4.length < l) {
            throw new ArrayLengthException("putbararowlist", "matidx");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in putbararowlist is null");
        }
        long l3 = 0L;
        for (long l4 : lArray3) {
            l3 += l4;
        }
        if (dArray != null && (long)dArray.length < l3) {
            throw new ArrayLengthException("putbararowlist", "weights");
        }
        this.p_putbararowlist(this.native_task, n, nArray, lArray, lArray2, nArray2, lArray3, lArray4, dArray);
    }

    public synchronized void putbarcblocktriplet(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        long l = -1L;
        if (nArray != null) {
            if (l < 0L) {
                l = nArray.length;
            } else if (l != (long)nArray.length) {
                throw new ArrayLengthException("putbarcblocktriplet", "subj");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("putbarcblocktriplet", "subk");
            }
        }
        if (nArray3 != null) {
            if (l < 0L) {
                l = nArray3.length;
            } else if (l != (long)nArray3.length) {
                throw new ArrayLengthException("putbarcblocktriplet", "subl");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putbarcblocktriplet", "valjkl");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in putbarcblocktriplet is null");
        }
        if (nArray != null && (long)nArray.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subj");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument subk in putbarcblocktriplet is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subk");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument subl in putbarcblocktriplet is null");
        }
        if (nArray3 != null && (long)nArray3.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "subl");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument valjkl in putbarcblocktriplet is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("putbarcblocktriplet", "valjkl");
        }
        this.p_putbarcblocktriplet(this.native_task, l, nArray, nArray2, nArray3, dArray);
    }

    public synchronized void putbarcj(int n, long[] lArray, double[] dArray) throws Error {
        long l = -1L;
        if (lArray != null) {
            if (l < 0L) {
                l = lArray.length;
            } else if (l != (long)lArray.length) {
                throw new ArrayLengthException("putbarcj", "sub");
            }
        }
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("putbarcj", "weights");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument sub in putbarcj is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument weights in putbarcj is null");
        }
        this.p_putbarcj(this.native_task, n, l, lArray, dArray);
    }

    public synchronized void putbarsj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barsj in putbarsj is null");
        }
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("putbarsj", "barsj");
        }
        this.p_putbarsj(this.native_task, soltype2.getValue(), n, dArray);
    }

    public synchronized void putbarvarname(int n, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putbarvarname is null");
        }
        this.p_putbarvarname(this.native_task, n, string);
    }

    public synchronized void putbarxj(soltype soltype2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument barxj in putbarxj is null");
        }
        long[] lArray = new long[1];
        this.p_getlenbarvarj(this.native_task, n, lArray);
        if (dArray != null && (long)dArray.length < lArray[0]) {
            throw new ArrayLengthException("putbarxj", "barxj");
        }
        this.p_putbarxj(this.native_task, soltype2.getValue(), n, dArray);
    }

    public synchronized void putcfix(double d) throws Error {
        this.p_putcfix(this.native_task, d);
    }

    public synchronized void putcj(int n, double d) throws Error {
        this.p_putcj(this.native_task, n, d);
    }

    public synchronized void putclist(int[] nArray, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putclist", "subj");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putclist", "val");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in putclist is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in putclist is null");
        }
        this.p_putclist(this.native_task, n, nArray, dArray);
    }

    public synchronized void putconbound(int n, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putconbound(this.native_task, n, boundkey2.getValue(), d, d2);
    }

    public synchronized void putconboundlist(int[] nArray, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putconboundlist", "sub");
            }
        }
        if (boundkeyArray != null) {
            if (n < 0) {
                n = boundkeyArray.length;
            } else if (n != boundkeyArray.length) {
                throw new ArrayLengthException("putconboundlist", "bkc");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putconboundlist", "blc");
            }
        }
        if (dArray2 != null) {
            if (n < 0) {
                n = dArray2.length;
            } else if (n != dArray2.length) {
                throw new ArrayLengthException("putconboundlist", "buc");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putconboundlist is null");
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc in putconboundlist is null");
        }
        int[] nArray2 = null;
        if (boundkeyArray != null) {
            nArray2 = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray2[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blc in putconboundlist is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument buc in putconboundlist is null");
        }
        this.p_putconboundlist(this.native_task, n, nArray, nArray2, dArray, dArray2);
    }

    public synchronized void putconboundlistconst(int[] nArray, boundkey boundkey2, double d, double d2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putconboundlistconst", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putconboundlistconst is null");
        }
        this.p_putconboundlistconst(this.native_task, n, nArray, boundkey2.getValue(), d, d2);
    }

    public synchronized void putconboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkc in putconboundslice is null");
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "bkc");
        }
        int[] nArray = null;
        if (boundkeyArray != null) {
            nArray = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blc in putconboundslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "blc");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument buc in putconboundslice is null");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("putconboundslice", "buc");
        }
        this.p_putconboundslice(this.native_task, n, n2, nArray, dArray, dArray2);
    }

    public synchronized void putconboundsliceconst(int n, int n2, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putconboundsliceconst(this.native_task, n, n2, boundkey2.getValue(), d, d2);
    }

    public synchronized void putcone(int n, conetype conetype2, double d, int[] nArray) throws Error {
        int n2 = -1;
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("putcone", "submem");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument submem in putcone is null");
        }
        this.p_putcone(this.native_task, n, conetype2.getValue(), d, n2, nArray);
    }

    public synchronized void putconename(int n, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putconename is null");
        }
        this.p_putconename(this.native_task, n, string);
    }

    public synchronized void putconname(int n, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putconname is null");
        }
        this.p_putconname(this.native_task, n, string);
    }

    public synchronized void putconsolutioni(int n, soltype soltype2, stakey stakey2, double d, double d2, double d3) throws Error {
        this.p_putconsolutioni(this.native_task, n, soltype2.getValue(), stakey2.getValue(), d, d2, d3);
    }

    public synchronized void putcslice(int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slice in putcslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putcslice", "slice");
        }
        this.p_putcslice(this.native_task, n, n2, dArray);
    }

    public synchronized void putdjc(long l, long[] lArray, long[] lArray2, double[] dArray, long[] lArray3) throws Error {
        long l2 = -1L;
        if (lArray != null) {
            if (l2 < 0L) {
                l2 = lArray.length;
            } else if (l2 != (long)lArray.length) {
                throw new ArrayLengthException("putdjc", "domidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument domidxlist in putdjc is null");
        }
        long l3 = -1L;
        if (lArray2 != null) {
            if (l3 < 0L) {
                l3 = lArray2.length;
            } else if (l3 != (long)lArray2.length) {
                throw new ArrayLengthException("putdjc", "afeidxlist");
            }
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidxlist in putdjc is null");
        }
        if (dArray != null && (long)dArray.length < l3) {
            throw new ArrayLengthException("putdjc", "b");
        }
        long l4 = -1L;
        if (lArray3 != null) {
            if (l4 < 0L) {
                l4 = lArray3.length;
            } else if (l4 != (long)lArray3.length) {
                throw new ArrayLengthException("putdjc", "termsizelist");
            }
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument termsizelist in putdjc is null");
        }
        this.p_putdjc(this.native_task, l, l2, lArray, l3, lArray2, dArray, l4, lArray3);
    }

    public synchronized void putdjcname(long l, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putdjcname is null");
        }
        this.p_putdjcname(this.native_task, l, string);
    }

    public synchronized void putdjcslice(long l, long l2, long[] lArray, long[] lArray2, double[] dArray, long[] lArray3, long[] lArray4) throws Error {
        long l3 = -1L;
        if (lArray != null) {
            if (l3 < 0L) {
                l3 = lArray.length;
            } else if (l3 != (long)lArray.length) {
                throw new ArrayLengthException("putdjcslice", "domidxlist");
            }
        }
        if (lArray == null) {
            throw new NullPointerException("Argument domidxlist in putdjcslice is null");
        }
        long l4 = -1L;
        if (lArray2 != null) {
            if (l4 < 0L) {
                l4 = lArray2.length;
            } else if (l4 != (long)lArray2.length) {
                throw new ArrayLengthException("putdjcslice", "afeidxlist");
            }
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument afeidxlist in putdjcslice is null");
        }
        if (dArray != null && (long)dArray.length < l4) {
            throw new ArrayLengthException("putdjcslice", "b");
        }
        long l5 = -1L;
        if (lArray3 != null) {
            if (l5 < 0L) {
                l5 = lArray3.length;
            } else if (l5 != (long)lArray3.length) {
                throw new ArrayLengthException("putdjcslice", "termsizelist");
            }
        }
        if (lArray3 == null) {
            throw new NullPointerException("Argument termsizelist in putdjcslice is null");
        }
        if (lArray4 == null) {
            throw new NullPointerException("Argument termsindjc in putdjcslice is null");
        }
        if (lArray4 != null && (long)lArray4.length < l2 - l) {
            throw new ArrayLengthException("putdjcslice", "termsindjc");
        }
        this.p_putdjcslice(this.native_task, l, l2, l3, lArray, l4, lArray2, dArray, l5, lArray3, lArray4);
    }

    public synchronized void putdomainname(long l, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putdomainname is null");
        }
        this.p_putdomainname(this.native_task, l, string);
    }

    public synchronized void putdouparam(dparam dparam2, double d) throws Error {
        this.p_putdouparam(this.native_task, dparam2.getValue(), d);
    }

    public synchronized void putintparam(iparam iparam2, int n) throws Error {
        this.p_putintparam(this.native_task, iparam2.getValue(), n);
    }

    public synchronized void putlintparam(iparam iparam2, long l) throws Error {
        this.p_putlintparam(this.native_task, iparam2.getValue(), l);
    }

    public synchronized void putmaxnumacc(long l) throws Error {
        this.p_putmaxnumacc(this.native_task, l);
    }

    public synchronized void putmaxnumafe(long l) throws Error {
        this.p_putmaxnumafe(this.native_task, l);
    }

    public synchronized void putmaxnumanz(long l) throws Error {
        this.p_putmaxnumanz(this.native_task, l);
    }

    public synchronized void putmaxnumbarvar(int n) throws Error {
        this.p_putmaxnumbarvar(this.native_task, n);
    }

    public synchronized void putmaxnumcon(int n) throws Error {
        this.p_putmaxnumcon(this.native_task, n);
    }

    public synchronized void putmaxnumcone(int n) throws Error {
        this.p_putmaxnumcone(this.native_task, n);
    }

    public synchronized void putmaxnumdjc(long l) throws Error {
        this.p_putmaxnumdjc(this.native_task, l);
    }

    public synchronized void putmaxnumdomain(long l) throws Error {
        this.p_putmaxnumdomain(this.native_task, l);
    }

    public synchronized void putmaxnumqnz(long l) throws Error {
        this.p_putmaxnumqnz(this.native_task, l);
    }

    public synchronized void putmaxnumvar(int n) throws Error {
        this.p_putmaxnumvar(this.native_task, n);
    }

    public synchronized void putnadouparam(String string, double d) throws Error {
        this.p_putnadouparam(this.native_task, string, d);
    }

    public synchronized void putnaintparam(String string, int n) throws Error {
        this.p_putnaintparam(this.native_task, string, n);
    }

    public synchronized void putnastrparam(String string, String string2) throws Error {
        this.p_putnastrparam(this.native_task, string, string2);
    }

    public synchronized void putobjname(String string) throws Error {
        this.p_putobjname(this.native_task, string);
    }

    public synchronized void putobjsense(objsense objsense2) throws Error {
        this.p_putobjsense(this.native_task, objsense2.getValue());
    }

    public synchronized void putoptserverhost(String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument host in putoptserverhost is null");
        }
        this.p_putoptserverhost(this.native_task, string);
    }

    public synchronized void putparam(String string, String string2) throws Error {
        this.p_putparam(this.native_task, string, string2);
    }

    public synchronized void putqcon(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) throws Error {
        int n = -1;
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("putqcon", "qcsubi");
            }
        }
        if (nArray3 != null) {
            if (n < 0) {
                n = nArray3.length;
            } else if (n != nArray3.length) {
                throw new ArrayLengthException("putqcon", "qcsubj");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putqcon", "qcval");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubk in putqcon is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubi in putqcon is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument qcsubj in putqcon is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval in putqcon is null");
        }
        this.p_putqcon(this.native_task, n, nArray, nArray2, nArray3, dArray);
    }

    public synchronized void putqconk(int n, int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n2 = -1;
        if (nArray != null) {
            if (n2 < 0) {
                n2 = nArray.length;
            } else if (n2 != nArray.length) {
                throw new ArrayLengthException("putqconk", "qcsubi");
            }
        }
        if (nArray2 != null) {
            if (n2 < 0) {
                n2 = nArray2.length;
            } else if (n2 != nArray2.length) {
                throw new ArrayLengthException("putqconk", "qcsubj");
            }
        }
        if (dArray != null) {
            if (n2 < 0) {
                n2 = dArray.length;
            } else if (n2 != dArray.length) {
                throw new ArrayLengthException("putqconk", "qcval");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qcsubi in putqconk is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qcsubj in putqconk is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qcval in putqconk is null");
        }
        this.p_putqconk(this.native_task, n, n2, nArray, nArray2, dArray);
    }

    public synchronized void putqobj(int[] nArray, int[] nArray2, double[] dArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putqobj", "qosubi");
            }
        }
        if (nArray2 != null) {
            if (n < 0) {
                n = nArray2.length;
            } else if (n != nArray2.length) {
                throw new ArrayLengthException("putqobj", "qosubj");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putqobj", "qoval");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument qosubi in putqobj is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument qosubj in putqobj is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument qoval in putqobj is null");
        }
        this.p_putqobj(this.native_task, n, nArray, nArray2, dArray);
    }

    public synchronized void putqobjij(int n, int n2, double d) throws Error {
        this.p_putqobjij(this.native_task, n, n2, d);
    }

    public synchronized void putskc(soltype soltype2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skc in putskc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (stakeyArray != null && stakeyArray.length < nArray[0]) {
            throw new ArrayLengthException("putskc", "skc");
        }
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray2[i] = stakeyArray[i].getValue();
            }
        }
        this.p_putskc(this.native_task, soltype2.getValue(), nArray2);
    }

    public synchronized void putskcslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("putskcslice", "skc");
        }
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray[i] = stakeyArray[i].getValue();
            }
        }
        this.p_putskcslice(this.native_task, soltype2.getValue(), n, n2, nArray);
    }

    public synchronized void putskx(soltype soltype2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skx in putskx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (stakeyArray != null && stakeyArray.length < nArray[0]) {
            throw new ArrayLengthException("putskx", "skx");
        }
        int[] nArray2 = null;
        if (stakeyArray != null) {
            nArray2 = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray2[i] = stakeyArray[i].getValue();
            }
        }
        this.p_putskx(this.native_task, soltype2.getValue(), nArray2);
    }

    public synchronized void putskxslice(soltype soltype2, int n, int n2, stakey[] stakeyArray) throws Error {
        if (stakeyArray == null) {
            throw new NullPointerException("Argument skx in putskxslice is null");
        }
        if (stakeyArray != null && stakeyArray.length < n2 - n) {
            throw new ArrayLengthException("putskxslice", "skx");
        }
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray[i] = stakeyArray[i].getValue();
            }
        }
        this.p_putskxslice(this.native_task, soltype2.getValue(), n, n2, nArray);
    }

    public synchronized void putslc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc in putslc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putslc", "slc");
        }
        this.p_putslc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putslcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slc in putslcslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putslcslice", "slc");
        }
        this.p_putslcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void putslx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx in putslx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putslx", "slx");
        }
        this.p_putslx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putslxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument slx in putslxslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putslxslice", "slx");
        }
        this.p_putslxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void putsnx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux in putsnx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putsnx", "sux");
        }
        this.p_putsnx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putsnxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument snx in putsnxslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsnxslice", "snx");
        }
        this.p_putsnxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void putsolution(soltype soltype2, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8) throws Error {
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray[i] = stakeyArray[i].getValue();
            }
        }
        int[] nArray2 = null;
        if (stakeyArray2 != null) {
            nArray2 = new int[stakeyArray2.length];
            for (int i = 0; i < stakeyArray2.length; ++i) {
                nArray2[i] = stakeyArray2[i].getValue();
            }
        }
        int[] nArray3 = null;
        if (stakeyArray3 != null) {
            nArray3 = new int[stakeyArray3.length];
            for (int i = 0; i < stakeyArray3.length; ++i) {
                nArray3[i] = stakeyArray3[i].getValue();
            }
        }
        this.p_putsolution(this.native_task, soltype2.getValue(), nArray, nArray2, nArray3, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8);
    }

    public synchronized void putsolutionnew(soltype soltype2, stakey[] stakeyArray, stakey[] stakeyArray2, stakey[] stakeyArray3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9) throws Error {
        int[] nArray = null;
        if (stakeyArray != null) {
            nArray = new int[stakeyArray.length];
            for (int i = 0; i < stakeyArray.length; ++i) {
                nArray[i] = stakeyArray[i].getValue();
            }
        }
        int[] nArray2 = null;
        if (stakeyArray2 != null) {
            nArray2 = new int[stakeyArray2.length];
            for (int i = 0; i < stakeyArray2.length; ++i) {
                nArray2[i] = stakeyArray2[i].getValue();
            }
        }
        int[] nArray3 = null;
        if (stakeyArray3 != null) {
            nArray3 = new int[stakeyArray3.length];
            for (int i = 0; i < stakeyArray3.length; ++i) {
                nArray3[i] = stakeyArray3[i].getValue();
            }
        }
        this.p_putsolutionnew(this.native_task, soltype2.getValue(), nArray, nArray2, nArray3, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9);
    }

    public synchronized void putsolutionyi(int n, soltype soltype2, double d) throws Error {
        this.p_putsolutionyi(this.native_task, n, soltype2.getValue(), d);
    }

    public synchronized void putstrparam(sparam sparam2, String string) throws Error {
        this.p_putstrparam(this.native_task, sparam2.getValue(), string);
    }

    public synchronized void putsuc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc in putsuc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putsuc", "suc");
        }
        this.p_putsuc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putsucslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument suc in putsucslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsucslice", "suc");
        }
        this.p_putsucslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void putsux(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux in putsux is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putsux", "sux");
        }
        this.p_putsux(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putsuxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument sux in putsuxslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putsuxslice", "sux");
        }
        this.p_putsuxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void puttaskname(String string) throws Error {
        this.p_puttaskname(this.native_task, string);
    }

    public synchronized void putvarbound(int n, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putvarbound(this.native_task, n, boundkey2.getValue(), d, d2);
    }

    public synchronized void putvarboundlist(int[] nArray, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putvarboundlist", "sub");
            }
        }
        if (boundkeyArray != null) {
            if (n < 0) {
                n = boundkeyArray.length;
            } else if (n != boundkeyArray.length) {
                throw new ArrayLengthException("putvarboundlist", "bkx");
            }
        }
        if (dArray != null) {
            if (n < 0) {
                n = dArray.length;
            } else if (n != dArray.length) {
                throw new ArrayLengthException("putvarboundlist", "blx");
            }
        }
        if (dArray2 != null) {
            if (n < 0) {
                n = dArray2.length;
            } else if (n != dArray2.length) {
                throw new ArrayLengthException("putvarboundlist", "bux");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putvarboundlist is null");
        }
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkx in putvarboundlist is null");
        }
        int[] nArray2 = null;
        if (boundkeyArray != null) {
            nArray2 = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray2[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blx in putvarboundlist is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bux in putvarboundlist is null");
        }
        this.p_putvarboundlist(this.native_task, n, nArray, nArray2, dArray, dArray2);
    }

    public synchronized void putvarboundlistconst(int[] nArray, boundkey boundkey2, double d, double d2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putvarboundlistconst", "sub");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument sub in putvarboundlistconst is null");
        }
        this.p_putvarboundlistconst(this.native_task, n, nArray, boundkey2.getValue(), d, d2);
    }

    public synchronized void putvarboundslice(int n, int n2, boundkey[] boundkeyArray, double[] dArray, double[] dArray2) throws Error {
        if (boundkeyArray == null) {
            throw new NullPointerException("Argument bkx in putvarboundslice is null");
        }
        if (boundkeyArray != null && boundkeyArray.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "bkx");
        }
        int[] nArray = null;
        if (boundkeyArray != null) {
            nArray = new int[boundkeyArray.length];
            for (int i = 0; i < boundkeyArray.length; ++i) {
                nArray[i] = boundkeyArray[i].getValue();
            }
        }
        if (dArray == null) {
            throw new NullPointerException("Argument blx in putvarboundslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "blx");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument bux in putvarboundslice is null");
        }
        if (dArray2 != null && dArray2.length < n2 - n) {
            throw new ArrayLengthException("putvarboundslice", "bux");
        }
        this.p_putvarboundslice(this.native_task, n, n2, nArray, dArray, dArray2);
    }

    public synchronized void putvarboundsliceconst(int n, int n2, boundkey boundkey2, double d, double d2) throws Error {
        this.p_putvarboundsliceconst(this.native_task, n, n2, boundkey2.getValue(), d, d2);
    }

    public synchronized void putvarname(int n, String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument name in putvarname is null");
        }
        this.p_putvarname(this.native_task, n, string);
    }

    public synchronized void putvarsolutionj(int n, soltype soltype2, stakey stakey2, double d, double d2, double d3, double d4) throws Error {
        this.p_putvarsolutionj(this.native_task, n, soltype2.getValue(), stakey2.getValue(), d, d2, d3, d4);
    }

    public synchronized void putvartype(int n, variabletype variabletype2) throws Error {
        this.p_putvartype(this.native_task, n, variabletype2.getValue());
    }

    public synchronized void putvartypelist(int[] nArray, variabletype[] variabletypeArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("putvartypelist", "subj");
            }
        }
        if (variabletypeArray != null) {
            if (n < 0) {
                n = variabletypeArray.length;
            } else if (n != variabletypeArray.length) {
                throw new ArrayLengthException("putvartypelist", "vartype");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subj in putvartypelist is null");
        }
        if (variabletypeArray == null) {
            throw new NullPointerException("Argument vartype in putvartypelist is null");
        }
        int[] nArray2 = null;
        if (variabletypeArray != null) {
            nArray2 = new int[variabletypeArray.length];
            for (int i = 0; i < variabletypeArray.length; ++i) {
                nArray2[i] = variabletypeArray[i].getValue();
            }
        }
        this.p_putvartypelist(this.native_task, n, nArray, nArray2);
    }

    public synchronized void putxc(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc in putxc is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putxc", "xc");
        }
        this.p_putxc(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putxcslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xc in putxcslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putxcslice", "xc");
        }
        this.p_putxcslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void putxx(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx in putxx is null");
        }
        int[] nArray = new int[1];
        this.p_getnumvar(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("putxx", "xx");
        }
        this.p_putxx(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putxxslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument xx in putxxslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putxxslice", "xx");
        }
        this.p_putxxslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void puty(soltype soltype2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y in puty is null");
        }
        int[] nArray = new int[1];
        this.p_getnumcon(this.native_task, nArray);
        if (dArray != null && dArray.length < nArray[0]) {
            throw new ArrayLengthException("puty", "y");
        }
        this.p_puty(this.native_task, soltype2.getValue(), dArray);
    }

    public synchronized void putyslice(soltype soltype2, int n, int n2, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument y in putyslice is null");
        }
        if (dArray != null && dArray.length < n2 - n) {
            throw new ArrayLengthException("putyslice", "y");
        }
        this.p_putyslice(this.native_task, soltype2.getValue(), n, n2, dArray);
    }

    public synchronized void readbsolution(String string, compresstype compresstype2) throws Error {
        this.p_readbsolution(this.native_task, string, compresstype2.getValue());
    }

    public synchronized void readdata(String string) throws Error {
        this.p_readdataautoformat(this.native_task, string);
    }

    public synchronized void readdataformat(String string, dataformat dataformat2, compresstype compresstype2) throws Error {
        this.p_readdataformat(this.native_task, string, dataformat2.getValue(), compresstype2.getValue());
    }

    public synchronized void readjsonsol(String string) throws Error {
        this.p_readjsonsol(this.native_task, string);
    }

    public synchronized void readjsonstring(String string) throws Error {
        this.p_readjsonstring(this.native_task, string);
    }

    public synchronized void readlpstring(String string) throws Error {
        this.p_readlpstring(this.native_task, string);
    }

    public synchronized void readopfstring(String string) throws Error {
        this.p_readopfstring(this.native_task, string);
    }

    public synchronized void readparamfile(String string) throws Error {
        this.p_readparamfile(this.native_task, string);
    }

    public synchronized void readptfstring(String string) throws Error {
        this.p_readptfstring(this.native_task, string);
    }

    public synchronized void readsolution(soltype soltype2, String string) throws Error {
        this.p_readsolution(this.native_task, soltype2.getValue(), string);
    }

    public synchronized void readsolutionfile(String string) throws Error {
        this.p_readsolutionfile(this.native_task, string);
    }

    public synchronized void readsummary(streamtype streamtype2) throws Error {
        this.p_readsummary(this.native_task, streamtype2.getValue());
    }

    public synchronized void readtask(String string) throws Error {
        this.p_readtask(this.native_task, string);
    }

    public synchronized void removebarvars(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("removebarvars", "subset");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subset in removebarvars is null");
        }
        this.p_removebarvars(this.native_task, n, nArray);
    }

    public synchronized void removecones(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("removecones", "subset");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subset in removecones is null");
        }
        this.p_removecones(this.native_task, n, nArray);
    }

    public synchronized void removecons(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("removecons", "subset");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subset in removecons is null");
        }
        this.p_removecons(this.native_task, n, nArray);
    }

    public synchronized void removevars(int[] nArray) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("removevars", "subset");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument subset in removevars is null");
        }
        this.p_removevars(this.native_task, n, nArray);
    }

    public synchronized void resetdouparam(dparam dparam2) throws Error {
        this.p_resetdouparam(this.native_task, dparam2.getValue());
    }

    public synchronized void resetintparam(iparam iparam2) throws Error {
        this.p_resetintparam(this.native_task, iparam2.getValue());
    }

    public synchronized void resetparameters() throws Error {
        this.p_resetparameters(this.native_task);
    }

    public synchronized void resetstrparam(sparam sparam2) throws Error {
        this.p_resetstrparam(this.native_task, sparam2.getValue());
    }

    public synchronized void resizetask(int n, int n2, int n3, long l, long l2) throws Error {
        this.p_resizetask(this.native_task, n, n2, n3, l, l2);
    }

    public synchronized void sensitivityreport(streamtype streamtype2) throws Error {
        this.p_sensitivityreport(this.native_task, streamtype2.getValue());
    }

    public synchronized void solutiondef(soltype soltype2, boolean[] blArray) throws Error {
        boolean[] blArray2 = blArray;
        if (blArray.length != 1) {
            throw new ArrayLengthException("solutiondef", "isdef");
        }
        this.p_solutiondef(this.native_task, soltype2.getValue(), blArray2);
    }

    public synchronized boolean solutiondef(soltype soltype2) throws Error {
        boolean[] blArray = new boolean[1];
        this.p_solutiondef(this.native_task, soltype2.getValue(), blArray);
        return blArray[0];
    }

    public synchronized void solutionsummary(streamtype streamtype2) throws Error {
        this.p_solutionsummary(this.native_task, streamtype2.getValue());
    }

    public synchronized void solvewithbasis(boolean bl, int n, int[] nArray, double[] dArray, int[] nArray2) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument sub in solvewithbasis is null");
        }
        int[] nArray3 = new int[1];
        this.p_getnumcon(this.native_task, nArray3);
        if (nArray != null && nArray.length < nArray3[0]) {
            throw new ArrayLengthException("solvewithbasis", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in solvewithbasis is null");
        }
        int[] nArray4 = new int[1];
        this.p_getnumcon(this.native_task, nArray4);
        if (dArray != null && dArray.length < nArray4[0]) {
            throw new ArrayLengthException("solvewithbasis", "val");
        }
        int[] nArray5 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("solvewithbasis", "numnzout");
        }
        this.p_solvewithbasis(this.native_task, bl, n, nArray, dArray, nArray5);
    }

    public synchronized int solvewithbasis(boolean bl, int n, int[] nArray, double[] dArray) throws Error {
        if (nArray == null) {
            throw new NullPointerException("Argument sub in solvewithbasis is null");
        }
        int[] nArray2 = new int[1];
        this.p_getnumcon(this.native_task, nArray2);
        if (nArray != null && nArray.length < nArray2[0]) {
            throw new ArrayLengthException("solvewithbasis", "sub");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument val in solvewithbasis is null");
        }
        int[] nArray3 = new int[1];
        this.p_getnumcon(this.native_task, nArray3);
        if (dArray != null && dArray.length < nArray3[0]) {
            throw new ArrayLengthException("solvewithbasis", "val");
        }
        int[] nArray4 = new int[1];
        this.p_solvewithbasis(this.native_task, bl, n, nArray, dArray, nArray4);
        return nArray4[0];
    }

    public synchronized void strtoconetype(String string, conetype[] conetypeArray) throws Error {
        int[] nArray = new int[1];
        this.p_strtoconetype(this.native_task, string, nArray);
        conetypeArray[0] = conetype.fromValue(nArray[0]);
    }

    public synchronized void strtosk(String string, stakey[] stakeyArray) throws Error {
        int[] nArray = new int[1];
        this.p_strtosk(this.native_task, string, nArray);
        stakeyArray[0] = stakey.fromValue(nArray[0]);
    }

    public synchronized void toconic() throws Error {
        this.p_toconic(this.native_task);
    }

    public synchronized void updatesolutioninfo(soltype soltype2) throws Error {
        this.p_updatesolutioninfo(this.native_task, soltype2.getValue());
    }

    public synchronized void writebsolution(String string, compresstype compresstype2) throws Error {
        this.p_writebsolution(this.native_task, string, compresstype2.getValue());
    }

    public synchronized void writedata(String string) throws Error {
        this.p_writedata(this.native_task, string);
    }

    public synchronized void writejsonsol(String string) throws Error {
        this.p_writejsonsol(this.native_task, string);
    }

    public synchronized void writeparamfile(String string) throws Error {
        this.p_writeparamfile(this.native_task, string);
    }

    public synchronized void writesolution(soltype soltype2, String string) throws Error {
        this.p_writesolution(this.native_task, soltype2.getValue(), string);
    }

    public synchronized void writesolutionfile(String string) throws Error {
        this.p_writesolutionfile(this.native_task, string);
    }

    public synchronized void writestat(String string) throws Error {
        this.p_writestat(this.native_task, string);
    }

    public synchronized void writetask(String string) throws Error {
        this.p_writetask(this.native_task, string);
    }

    @Override
    public synchronized void close() {
        this.dispose();
    }

    static {
        Env.checkversion();
    }
}

