/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.DeletionError;
import mosek.fusion.DimensionError;
import mosek.fusion.Expr;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.Model;
import mosek.fusion.ModelError;
import mosek.fusion.NilVariable;
import mosek.fusion.SliceConstraint;
import mosek.fusion.SliceError;
import mosek.fusion.SolutionError;
import mosek.fusion.UnimplementedError;
import mosek.fusion.UpdateError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;

public abstract class Constraint {
    private int[] con_nativeidxs;
    private int[] shape;
    private Model model;

    public Constraint(Constraint constraint, Model model) {
        this.model = model;
        this.shape = constraint.shape;
        this.con_nativeidxs = constraint.con_nativeidxs;
    }

    public Constraint(Model model, int[] nArray, int[] nArray2) {
        this.model = model;
        this.shape = nArray;
        this.con_nativeidxs = nArray2;
    }

    public String toString() {
        throw new UnimplementedError("Constraint.toString");
    }

    protected void toStringArray(long[] lArray, long l, String[] stringArray) {
    }

    protected void dual_lu(int n, double[] dArray, boolean bl) throws SolutionError {
        this.model.getConstraintDuals(bl, this.con_nativeidxs, dArray, n);
    }

    public double[] dual() throws SolutionError {
        double[] dArray = new double[this.con_nativeidxs.length];
        this.values(false, 0, dArray);
        return dArray;
    }

    public double[] level() throws SolutionError {
        double[] dArray = new double[this.con_nativeidxs.length];
        this.values(true, 0, dArray);
        return dArray;
    }

    private void values(boolean bl, int n, double[] dArray) throws SolutionError {
        this.model.getConstraintValues(bl, this.con_nativeidxs, dArray, n);
    }

    public void remove() {
        throw new DeletionError("Only original constraints can be removed");
    }

    public void update(double[] dArray) {
        this.update(Expr.reshape(Expr.constTerm(dArray), this.getShape()), new NilVariable(), true);
    }

    public void update(Expression expression) {
        int n;
        int[] nArray = expression.getShape();
        if (this.shape.length < nArray.length) {
            throw new DimensionError("Expression shape does not match constraint");
        }
        int n2 = 0;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] == this.shape[n]) continue;
            throw new DimensionError("Expression shape does not match constraint");
        }
        n2 = nArray.length;
        n3 = this.shape.length;
        for (n = n2; n < n3; ++n) {
            if (this.shape[n] == 1) continue;
            throw new DimensionError("Expression shape does not match constraint");
        }
        this.model.update(this.con_nativeidxs, expression);
    }

    public void update(Expression expression, Variable variable, boolean bl) {
        int[] nArray;
        int n;
        int n2;
        int n3;
        int[] nArray2;
        int n4 = this.getND();
        if (n4 < (nArray2 = expression.getShape()).length) {
            throw new DimensionError("Expression shape does not match constraint");
        }
        int n5 = 0;
        int n6 = nArray2.length;
        for (n3 = n5; n3 < n6; ++n3) {
            if (nArray2[n3] == this.shape[n3]) continue;
            throw new DimensionError("Expression shape does not match constraint");
        }
        n5 = nArray2.length;
        n6 = this.shape.length;
        for (n3 = n5; n3 < n6; ++n3) {
            if (this.shape[n3] == 1) continue;
            throw new DimensionError("Expression shape does not match constraint");
        }
        n5 = variable.numInst();
        long[] lArray = new long[n5];
        if ((long)n5 < variable.getSize()) {
            long[] lArray2 = new long[n5];
            variable.inst(0, lArray2, 0, lArray);
        } else {
            variable.inst(0, lArray);
        }
        int n7 = 0;
        int n8 = n5;
        for (n2 = n7; n2 < n8; ++n2) {
            if (lArray[n2] >= 0L) continue;
            throw new UpdateError("Semidefinite terms cannot be updated");
        }
        n8 = 1;
        n2 = 0;
        int n9 = n5 - 1;
        for (n = n2; n < n9; ++n) {
            n8 = n8 != 0 && lArray[n] < lArray[n + 1] ? 1 : 0;
        }
        if (n8 != 0) {
            if (!bl) {
                n2 = 0;
                n9 = 0;
                n = n5;
                int n10 = n9 < n ? n - n9 : 0;
                int[] nArray3 = new int[n10];
                int n11 = n9;
                int n12 = 0;
                while (n12 < n10) {
                    nArray3[n2] = (int)lArray[n11];
                    ++n2;
                    ++n12;
                    ++n11;
                }
                nArray = nArray3;
            } else {
                nArray = new int[n5 + 1];
                nArray[0] = 0;
                n2 = 0;
                n9 = n5;
                for (n = n2; n < n9; ++n) {
                    nArray[1 + n] = (int)lArray[n];
                }
            }
        } else {
            int n13;
            n2 = 0;
            n9 = 0;
            n = n5;
            int n14 = n9 < n ? n - n9 : 0;
            long[] lArray3 = new long[n14];
            int n15 = n9;
            int n16 = 0;
            while (n16 < n14) {
                lArray3[n2] = n15;
                ++n2;
                ++n16;
                ++n15;
            }
            long[] lArray4 = lArray3;
            CommonTools.argQsort(lArray4, lArray, null, 0L, (long)n5);
            int n17 = 1;
            int n18 = 1;
            int n19 = n5;
            for (n13 = n18; n13 < n19; ++n13) {
                if (lArray[(int)lArray4[n13 - 1]] >= lArray[(int)lArray4[n13]]) continue;
                ++n17;
            }
            if (bl) {
                ++n17;
            }
            nArray = new int[n17];
            n18 = 0;
            if (bl) {
                nArray[0] = 0;
                ++n18;
            }
            nArray[n18] = (int)lArray[(int)lArray4[0]];
            n19 = 1;
            n13 = n5;
            for (int i = n19; i < n13; ++i) {
                if (lArray[i - 1] >= lArray[i]) continue;
                nArray[n18] = (int)lArray[(int)lArray4[i]];
                ++n18;
            }
        }
        this.model.update(this.con_nativeidxs, expression, nArray);
    }

    public void update(Expression expression, Variable variable) {
        this.update(expression, variable, false);
    }

    public Model get_model() {
        return this.model;
    }

    public int get_nd() {
        return this.shape.length;
    }

    public long size() {
        long l = 1L;
        int n = 0;
        int n2 = this.shape.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)this.shape[i];
        }
        return l;
    }

    public static Constraint stack(Constraint[] constraintArray, int n) {
        return Constraint.dstack(constraintArray, n);
    }

    public static Constraint stack(Constraint constraint, Constraint constraint2, Constraint constraint3, int n) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2, constraint3}, n);
    }

    public static Constraint stack(Constraint constraint, Constraint constraint2, int n) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2}, n);
    }

    public static Constraint hstack(Constraint[] constraintArray) {
        return Constraint.dstack(constraintArray, 1);
    }

    public static Constraint vstack(Constraint[] constraintArray) {
        return Constraint.dstack(constraintArray, 0);
    }

    public static Constraint hstack(Constraint constraint, Constraint constraint2, Constraint constraint3) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2, constraint3}, 1);
    }

    public static Constraint vstack(Constraint constraint, Constraint constraint2, Constraint constraint3) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2, constraint3}, 0);
    }

    public static Constraint hstack(Constraint constraint, Constraint constraint2) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2}, 1);
    }

    public static Constraint vstack(Constraint constraint, Constraint constraint2) {
        return Constraint.dstack(new Constraint[]{constraint, constraint2}, 0);
    }

    protected static Constraint dstack(Constraint[] constraintArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Model model = null;
        int n13 = 0;
        int n14 = constraintArray.length;
        for (n12 = n13; n12 < n14; ++n12) {
            if (model == null) {
                model = constraintArray[n12].getModel();
                continue;
            }
            if (constraintArray[n12].model == null || constraintArray[n12].model == model) continue;
            StringBuffer stringBuffer = new StringBuffer();
            String string = model.getName().length() > 0 ? model.getName() : "?";
            String string2 = constraintArray[n12].getModel().getName().length() > 0 ? constraintArray[n12].getModel().getName() : "?";
            stringBuffer.a("Constraints belong to different models: '").a(string).a("' and '").a(string2).a("'");
            throw new ModelError(stringBuffer.toString());
        }
        if (constraintArray.length == 0) {
            return new SliceConstraint(null, new int[]{0}, new int[0]);
        }
        if (constraintArray.length == 1) {
            return constraintArray[1];
        }
        n13 = constraintArray.length;
        n14 = 1;
        n12 = 0;
        int n15 = n13;
        for (n11 = n12; n11 < n15; ++n11) {
            n14 = constraintArray[n11].getND() > n14 ? constraintArray[n11].getND() : n14;
        }
        if (n == n14) {
            ++n14;
        }
        int[][] nArray = new int[n13][n14];
        n15 = 0;
        n11 = n13;
        for (n10 = n15; n10 < n11; ++n10) {
            n9 = 0;
            int n16 = n14;
            for (n8 = n9; n8 < n16; ++n8) {
                nArray[n10][n8] = 1;
            }
        }
        n15 = 0;
        n11 = 0;
        n10 = n13;
        n9 = n11 < n10 ? n10 - n11 : 0;
        int[] nArray2 = new int[n9];
        n8 = n11;
        int n17 = 0;
        while (n17 < n9) {
            nArray2[n15] = constraintArray[n8].getSize();
            ++n15;
            ++n17;
            ++n8;
        }
        int[] nArray3 = nArray2;
        int n18 = 0;
        int n19 = 0;
        int n20 = n13;
        for (n7 = n19; n7 < n20; ++n7) {
            n18 += nArray3[n7];
        }
        n19 = 0;
        n20 = n13;
        for (n7 = n19; n7 < n20; ++n7) {
            int[] nArray4 = constraintArray[n7].getShape();
            n6 = 0;
            n5 = nArray4.length;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray[n7][n4] = nArray4[n4];
            }
        }
        if (n < 0 || n > n14) {
            throw new DimensionError("Invalid stacking dimension");
        }
        n19 = 0;
        n20 = n;
        for (n7 = n19; n7 < n20; ++n7) {
            int n21 = 1;
            n6 = n13;
            for (n5 = n21; n5 < n6; ++n5) {
                if (nArray[0][n7] == nArray[n5][n7]) continue;
                throw new DimensionError("Constraint dimensions do not match");
            }
        }
        n19 = n + 1;
        n20 = n14;
        for (n7 = n19; n7 < n20; ++n7) {
            int n22 = 1;
            n6 = n13;
            for (n5 = n22; n5 < n6; ++n5) {
                if (nArray[0][n7] == nArray[n5][n7]) continue;
                throw new DimensionError("Constraint dimensions do not match");
            }
        }
        int[] nArray5 = new int[n18];
        n20 = 0;
        n7 = 0;
        int n23 = n14;
        n6 = n7 < n23 ? n23 - n7 : 0;
        int[] nArray6 = new int[n6];
        n4 = n7;
        int n24 = 0;
        while (n24 < n6) {
            nArray6[n20] = nArray[0][n4];
            ++n20;
            ++n24;
            ++n4;
        }
        int[] nArray7 = nArray6;
        int n25 = 1;
        int n26 = n13;
        for (n3 = n25; n3 < n26; ++n3) {
            int n27 = n;
            nArray7[n27] = nArray7[n27] + nArray[n3][n];
        }
        n25 = nArray7.length;
        long[] lArray = new long[constraintArray.length + 1];
        n3 = 0;
        int n28 = constraintArray.length;
        for (n2 = n3; n2 < n28; ++n2) {
            lArray[n2 + 1] = lArray[n2] + (long)nArray[n2][n];
        }
        if (n == 0) {
            n3 = 0;
            n28 = 0;
            n2 = n13;
            for (int i = n28; i < n2; ++i) {
                int n29 = constraintArray[i].con_nativeidxs.length;
                Tools.arraycopy(constraintArray[i].con_nativeidxs, 0, nArray5, n3, n29);
                n3 += n29;
            }
        } else {
            n3 = 0;
            n28 = 0;
            n2 = n13;
            int n30 = n28 < n2 ? n2 - n28 : 0;
            int[][] nArrayArray = new int[n30][];
            int n31 = n28;
            int n32 = 0;
            while (n32 < n30) {
                nArrayArray[n3] = constraintArray[n31].con_nativeidxs;
                ++n3;
                ++n32;
                ++n31;
            }
            int[][] nArrayArray2 = nArrayArray;
            if (n < n14) {
                int n33;
                int n34;
                int n35 = 1;
                int n36 = 0;
                int n37 = n;
                for (n34 = n36; n34 < n37; ++n34) {
                    n35 *= nArray7[n34];
                }
                n36 = 1;
                n37 = n + 1;
                n34 = n14;
                for (n33 = n37; n33 < n34; ++n33) {
                    n36 *= nArray7[n33];
                }
                n37 = 0;
                n34 = 0;
                n33 = n35;
                for (int i = n34; i < n33; ++i) {
                    int n38 = 0;
                    int n39 = n13;
                    for (int j = n38; j < n39; ++j) {
                        int n40 = 0;
                        int n41 = nArray[j][n];
                        int n42 = 0;
                        int n43 = n41;
                        for (int k = n42; k < n43; ++k) {
                            int n44 = 0;
                            int n45 = n36;
                            for (int i2 = n44; i2 < n45; ++i2) {
                                nArray5[n37] = constraintArray[n13].con_nativeidxs[i * n36 * n41 + n40];
                                ++n37;
                                ++n40;
                            }
                        }
                    }
                }
            } else {
                int n46;
                int n47 = 1;
                int n48 = 0;
                int n49 = n14;
                for (n46 = n48; n46 < n49; ++n46) {
                    n47 *= nArray7[n46];
                }
                n48 = 0;
                n49 = 0;
                n46 = n47;
                for (int i = n49; i < n46; ++i) {
                    int n50 = 0;
                    int n51 = n13;
                    for (int j = n50; j < n51; ++j) {
                        nArray5[n48] = nArrayArray2[j][i];
                        ++n48;
                    }
                }
            }
        }
        return new SliceConstraint(model, nArray7, nArray5);
    }

    public Constraint index(int[] nArray) {
        int n;
        int n2;
        if (nArray.length != this.shape.length) {
            throw new DimensionError("variable shape and slice do not match");
        }
        int n3 = 0;
        int n4 = this.shape.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] <= this.shape[n2]) continue;
            throw new IndexError("index is out of bounds");
        }
        n3 = this.shape.length;
        long[] lArray = new long[n3];
        lArray[n3 - 1] = 1L;
        n2 = 1;
        int n5 = n3;
        for (n = n2; n < n5; ++n) {
            lArray[n3 - n - 1] = lArray[n3 - n] * (long)this.shape[n3 - n];
        }
        n2 = 0;
        n5 = 0;
        n = n3;
        for (int i = n5; i < n; ++i) {
            n2 += (int)(lArray[i] * (long)nArray[i]);
        }
        return new SliceConstraint(this.model, new int[0], new int[]{this.con_nativeidxs[n2]});
    }

    public Constraint index(int n) {
        if (this.shape.length == 0 && n == 0) {
            return this;
        }
        if (this.shape.length != 1) {
            throw new DimensionError("Variable shape and slice do not match");
        }
        if (n < 0 || n > this.shape[0]) {
            throw new IndexError("Index is out of bounds");
        }
        return new SliceConstraint(this.model, new int[0], new int[]{this.con_nativeidxs[n]});
    }

    public Constraint slice(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        if (nArray.length != nArray2.length) {
            throw new SliceError("invalid slice");
        }
        if (nArray.length != this.shape.length) {
            throw new DimensionError("variable shape and slice do not match");
        }
        int n5 = 0;
        int n6 = this.shape.length;
        for (n4 = n5; n4 < n6; ++n4) {
            if (nArray[n4] < 0 || nArray2[n4] > this.shape[n4]) {
                throw new IndexError("slice is out of bounds");
            }
            if (nArray[n4] <= nArray2[n4]) continue;
            throw new SliceError("invalid slice");
        }
        n5 = this.shape.length;
        n6 = 0;
        n4 = 0;
        int n7 = n5;
        int n8 = n4 < n7 ? n7 - n4 : 0;
        int[] nArray3 = new int[n8];
        int n9 = n4;
        int n10 = 0;
        while (n10 < n8) {
            nArray3[n6] = nArray2[n9] - nArray[n9];
            ++n6;
            ++n10;
            ++n9;
        }
        int[] nArray4 = nArray3;
        int n11 = 1;
        int n12 = 0;
        int n13 = n5;
        for (n3 = n12; n3 < n13; ++n3) {
            n11 *= nArray2[n3] - nArray[n3];
        }
        if (n11 == 0) {
            return new SliceConstraint(this.model, nArray4, new int[0]);
        }
        int[] nArray5 = new int[n11];
        int[] nArray6 = new int[n5];
        nArray6[n5 - 1] = 1;
        n3 = 1;
        int n14 = n5;
        for (n2 = n3; n2 < n14; ++n2) {
            nArray6[n5 - n2 - 1] = nArray6[n5 - n2] * this.shape[n5 - n2];
        }
        n3 = 0;
        n14 = 0;
        n2 = n5;
        for (n = n14; n < n2; ++n) {
            n3 += nArray[n] * nArray6[n];
        }
        n14 = 0;
        n2 = 0;
        n = n5;
        int n15 = n2 < n ? n - n2 : 0;
        int[] nArray7 = new int[n15];
        int n16 = n2;
        int n17 = 0;
        while (n17 < n15) {
            nArray7[n14] = n3;
            ++n14;
            ++n17;
            ++n16;
        }
        int[] nArray8 = nArray7;
        int n18 = 0;
        int n19 = 0;
        int n20 = n5;
        int n21 = n19 < n20 ? n20 - n19 : 0;
        int[] nArray9 = new int[n21];
        int n22 = n19;
        int n23 = 0;
        while (n23 < n21) {
            nArray9[n18] = nArray[n22];
            ++n18;
            ++n23;
            ++n22;
        }
        int[] nArray10 = nArray9;
        int n24 = 0;
        int n25 = n11;
        for (int i = n24; i < n25; ++i) {
            int n26;
            nArray5[i] = this.con_nativeidxs[nArray8[n5 - 1]];
            int n27 = n5 - 1;
            nArray10[n27] = nArray10[n27] + 1;
            int n28 = n5 - 1;
            nArray8[n28] = nArray8[n28] + nArray6[n5 - 1];
            if (nArray10[n5 - 1] < nArray2[n5 - 1]) continue;
            for (n26 = n5 - 1; n26 > 0 && nArray10[n26] >= nArray2[n26]; --n26) {
                nArray10[n26] = nArray[n26];
                int n29 = n26 - 1;
                nArray10[n29] = nArray10[n29] + 1;
                int n30 = n26 - 1;
                nArray8[n30] = nArray8[n30] + nArray6[n26 - 1];
            }
            int n31 = n26 + 1;
            int n32 = n5;
            for (int j = n31; j < n32; ++j) {
                nArray8[j] = nArray8[n26];
            }
        }
        return new SliceConstraint(this.getModel(), nArray4, nArray5);
    }

    public Constraint slice(int n, int n2) {
        if (this.shape.length != 1) {
            throw new DimensionError("Variable shape and slice do not match");
        }
        if (n == 0 && n2 == this.shape[0]) {
            return this;
        }
        if (n < 0 || n2 > this.shape[0]) {
            throw new IndexError("Slice is out of bounds");
        }
        if (n > n2) {
            throw new SliceError("Invalid slice");
        }
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        int[] nArray = new int[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            nArray[n3] = this.con_nativeidxs[n7];
            ++n3;
            ++n8;
            ++n7;
        }
        return new SliceConstraint(this.model, new int[]{n2 - n}, nArray);
    }

    public int getND() {
        return this.shape.length;
    }

    public int getSize() {
        int n = 1;
        int n2 = 0;
        int n3 = this.shape.length;
        for (int i = n2; i < n3; ++i) {
            n *= this.shape[i];
        }
        return n;
    }

    public Model getModel() {
        return this.model;
    }

    public int[] getShape() {
        int n = 0;
        int n2 = 0;
        int n3 = this.shape.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray[n] = this.shape[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return nArray;
    }

    protected int[] getNativeidxs() {
        return this.con_nativeidxs;
    }
}

