/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import mosek.DataCallback;
import mosek.Env;
import mosek.Error;
import mosek.MosekException;
import mosek.Progress;
import mosek.Stream;
import mosek.Task;
import mosek.Warning;
import mosek.boundkey;
import mosek.compresstype;
import mosek.dataformat;
import mosek.dinfitem;
import mosek.fusion.BreakCallback;
import mosek.fusion.Model;
import mosek.fusion.NameError;
import mosek.fusion.OptimizeError;
import mosek.fusion.ProblemStatus;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionType;
import mosek.fusion.SolverInfo;
import mosek.fusion.SolverStatus;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.Tools;
import mosek.iinfitem;
import mosek.iparam;
import mosek.liinfitem;
import mosek.objsense;
import mosek.prosta;
import mosek.rescode;
import mosek.solsta;
import mosek.soltype;
import mosek.streamtype;
import mosek.variabletype;

public abstract class BaseModel
implements Closeable {
    private static Env _global_env = null;
    private static int env_counter = 0;
    private Task task;
    private final String modelname;
    private DataCallback user_callback = null;
    private Progress user_progress = null;
    private BreakCallback breaksolve = new BreakCallback();
    private String[] namex;
    private Writer logwriter;
    protected boolean synched;
    private soltype cursol;
    private long cumtime = 0L;

    protected void task_setnumvar(int n) {
    }

    protected static Env globalEnv() {
        try {
            if (_global_env == null) {
                _global_env = new Env(null, true);
            }
            ++env_counter;
            return _global_env;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected static void env_putlicensecode(int[] nArray) {
        BaseModel.globalEnv().putlicensecode(nArray);
    }

    protected static void env_putlicensepath(String string) {
        BaseModel.globalEnv().putlicensepath(string);
    }

    protected static void env_putlicensewait(boolean bl) {
        BaseModel.globalEnv().putlicensewait(bl ? 1 : 0);
    }

    protected static String env_getversion() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        Env.getversion(nArray, nArray2, nArray3);
        return String.format("%d.%d.%d", nArray[0], nArray2[0], nArray3[0]);
    }

    protected BaseModel(BaseModel baseModel) {
        this.modelname = baseModel.modelname;
        this.task = new Task(baseModel.task);
        boolean bl = false;
        try {
            this.task.putintparam(iparam.log_expand, 0);
            this.task.putintparam(iparam.remove_unused_solutions, 1);
            this.namex = new String[128];
            this.cursol = baseModel.cursol;
            this.logwriter = null;
            this.task.set_Stream(streamtype.log, new Stream(){

                @Override
                public void stream(String string) {
                    if (BaseModel.this.logwriter != null) {
                        try {
                            BaseModel.this.logwriter.write(string);
                            BaseModel.this.logwriter.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.task.set_Progress(this.breaksolve);
            bl = true;
        }
        finally {
            if (!bl) {
                this.task.dispose();
                this.task = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseModel(String string, String string2) {
        this.modelname = string;
        this.task = new Task(BaseModel.globalEnv(), 0, 0);
        boolean bl = false;
        try {
            this.task.putintparam(iparam.log_expand, 0);
            this.task.putintparam(iparam.remove_unused_solutions, 1);
            if (string != null) {
                this.task.puttaskname(string);
            }
            this.namex = new String[128];
            this.logwriter = null;
            this.task.set_Stream(streamtype.log, new Stream(){

                @Override
                public void stream(String string) {
                    if (BaseModel.this.logwriter != null) {
                        try {
                            BaseModel.this.logwriter.write(string);
                            BaseModel.this.logwriter.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.task.set_Progress(this.breaksolve);
            bl = true;
        }
        finally {
            if (!bl) {
                this.task.dispose();
                this.task = null;
            }
        }
    }

    protected double task_get_dinf(String string) {
        dinfitem dinfitem2 = SolverInfo.getdouinf(string);
        if (dinfitem2 == null) {
            throw new NameError("Invalid double info name");
        }
        return this.task.getdouinf(dinfitem2);
    }

    protected int task_get_iinf(String string) {
        iinfitem iinfitem2 = SolverInfo.getintinf(string);
        if (iinfitem2 == null) {
            throw new NameError("Invalid integer info name");
        }
        return this.task.getintinf(iinfitem2);
    }

    protected long task_get_liinf(String string) {
        liinfitem liinfitem2 = SolverInfo.getlintinf(string);
        if (liinfitem2 == null) {
            throw new NameError("Invalid long integer info name");
        }
        return this.task.getlintinf(liinfitem2);
    }

    protected void task_put_param(String string, String string2) {
        this.task.putnastrparam(string, string2);
    }

    protected void task_put_param(String string, double d) {
        this.task.putnadouparam(string, d);
    }

    protected void task_put_param(String string, int n) {
        this.task.putnaintparam(string, n);
    }

    protected void task_setLogHandler(Writer writer) {
        this.logwriter = writer;
    }

    protected void task_setDataCallbackHandler(DataCallback dataCallback) {
        this.user_callback = dataCallback;
        this.task.set_InfoCallback(dataCallback);
    }

    protected void task_setCallbackHandler(Progress progress) {
        this.user_progress = progress;
        this.task.set_Progress(progress);
    }

    protected void task_putarowlist(int[] nArray, long[] lArray, int[] nArray2, double[] dArray) {
        this.synched = false;
        try {
            int n = nArray.length;
            long[] lArray2 = new long[n];
            long[] lArray3 = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray2[i] = lArray[i];
                lArray3[i] = lArray[i + 1];
            }
            this.task.putarowlist(nArray, lArray2, lArray3, nArray2, dArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_cleararowlist(int[] nArray) {
        this.synched = false;
        try {
            int n = nArray.length;
            int[] nArray2 = new int[n];
            int[] nArray3 = new int[]{};
            double[] dArray = new double[]{};
            for (int i = 0; i < n; ++i) {
                nArray2[i] = 0;
            }
            this.task.putarowlist(nArray, nArray2, nArray2, nArray3, dArray);
            long[] lArray = new long[1];
            this.task.getnumbaranz(lArray);
            int n2 = (int)lArray[0];
            if (n2 > 0) {
                HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
                for (int i = 0; i < n; ++i) {
                    hashMap.put(nArray[i], true);
                }
                long[] lArray2 = new long[n2];
                this.task.getbarasparsity(lArray, lArray2);
                int[] nArray4 = new int[1];
                int[] nArray5 = new int[1];
                long[] lArray3 = new long[]{};
                for (int i = 0; i < n2; ++i) {
                    long l = lArray2[i];
                    this.task.getbaraidxij(l, nArray4, nArray5);
                    if (!hashMap.containsKey(nArray4)) continue;
                    this.task.putbaraij(nArray4[0], nArray5[0], lArray3, dArray);
                }
            }
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_clearacollist(int[] nArray) {
        this.synched = false;
        try {
            int n = nArray.length;
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = 0;
            }
            int[] nArray3 = new int[]{};
            double[] dArray = new double[]{};
            this.task.putacollist(nArray, nArray2, nArray2, nArray3, dArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putaijlist(int[] nArray, int[] nArray2, double[] dArray, long l) {
        double[] dArray2;
        int[] nArray3;
        int[] nArray4;
        this.synched = false;
        if ((long)nArray.length != l) {
            nArray4 = new int[(int)l];
            System.arraycopy(nArray, 0, nArray4, 0, (int)l);
        } else {
            nArray4 = nArray;
        }
        if ((long)nArray2.length != l) {
            nArray3 = new int[(int)l];
            System.arraycopy(nArray2, 0, nArray3, 0, (int)l);
        } else {
            nArray3 = nArray2;
        }
        if ((long)dArray.length != l) {
            dArray2 = new double[(int)l];
            System.arraycopy(dArray, 0, dArray2, 0, (int)l);
        } else {
            dArray2 = dArray;
        }
        try {
            this.task.putaijlist(nArray4, nArray3, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected long[] task_appendsymmatlist(int[] nArray, long[] lArray, int[] nArray2, int[] nArray3, double[] dArray) {
        long[] lArray2 = new long[nArray.length];
        this.task.appendsparsesymmatlist(nArray, lArray, nArray2, nArray3, dArray, lArray2);
        return lArray2;
    }

    protected void task_putbaraijlist(int[] nArray, int[] nArray2, long[] lArray) {
        long[] lArray2 = new long[nArray.length];
        long[] lArray3 = new long[nArray.length];
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray2[i] = i;
            lArray3[i] = i + 1;
            dArray[i] = 1.0;
        }
        this.task.putbaraijlist(nArray, nArray2, lArray2, lArray3, lArray, dArray);
    }

    protected void task_putbararowlist(int[] nArray, long[] lArray, int[] nArray2, long[] lArray2) {
        long[] lArray3 = new long[nArray.length];
        long[] lArray4 = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray3[i] = lArray[i];
            lArray4[i] = lArray[i + 1];
        }
        long[] lArray5 = new long[nArray2.length];
        double[] dArray = new double[nArray2.length];
        for (int i = 0; i < nArray2.length; ++i) {
            lArray5[i] = 1L;
            dArray[i] = 1.0;
        }
        this.task.putbararowlist(nArray, lArray3, lArray4, nArray2, lArray5, lArray2, dArray);
    }

    protected void task_putbarc(int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        this.task.putbarcblocktriplet(nArray, nArray2, nArray3, dArray);
    }

    protected void task_putobjectivename(String string) {
        try {
            if (string != null) {
                this.task.putobjname(string);
            } else {
                this.task.putobjname("");
            }
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putobjective(boolean bl, int[] nArray, double[] dArray, double d) {
        this.synched = false;
        try {
            double[] dArray2 = new double[this.task.getnumvar()];
            int[] nArray2 = Tools.range(dArray2.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                dArray2[n] = dArray2[n] + dArray[i];
            }
            this.task.putclist(nArray2, dArray2);
            this.task.putcfix(d);
            this.task.putobjsense(bl ? objsense.maximize : objsense.minimize);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putclist(int[] nArray, double[] dArray) {
        this.synched = false;
        try {
            this.task.putclist(nArray, dArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_cleanup(int n, int n2, int n3, int n4) {
        try {
            Object[] objectArray;
            int n5 = this.task.getnumvar();
            int n6 = this.task.getnumcon();
            int n7 = this.task.getnumcone();
            int n8 = this.task.getnumbarvar();
            if (n3 < n7) {
                objectArray = Tools.range(n3, n7);
                this.task.removecones((int[])objectArray);
            }
            if (n < n5) {
                objectArray = new double[n5 - n];
                boundkey[] boundkeyArray = new boundkey[n5 - n];
                for (int i = 0; i < n5 - n; ++i) {
                    boundkeyArray[i] = boundkey.fx;
                }
                this.task.putvarboundslice(n, n5, boundkeyArray, (double[])objectArray, (double[])objectArray);
            }
            if (n2 < n6) {
                objectArray = Tools.range(n2, n6);
                this.task.removecons((int[])objectArray);
            }
            if (n4 < n8) {
                objectArray = Tools.range(n4, n8);
                this.task.removebarvars((int[])objectArray);
            }
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_write(String string) {
        try {
            this.task.putintparam(iparam.opf_write_solutions, 1);
            this.task.writedata(string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_analyze_problem(int n) {
        try {
            this.task.putintparam(iparam.log_ana_pro, n);
            this.task.analyzeproblem(streamtype.log);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_write_stream(String string, OutputStream outputStream) {
        try {
            int n = string.indexOf(46);
            dataformat dataformat2 = dataformat.mps;
            compresstype compresstype2 = compresstype.none;
            if (n < 0) {
                if (string.equals("cbf")) {
                    dataformat2 = dataformat.cb;
                } else if (string.equals("ptf")) {
                    dataformat2 = dataformat.ptf;
                } else if (string.equals("opf")) {
                    dataformat2 = dataformat.op;
                } else if (string.equals("lp")) {
                    dataformat2 = dataformat.lp;
                } else if (string.equals("jtask")) {
                    dataformat2 = dataformat.json_task;
                } else if (string.equals("task")) {
                    dataformat2 = dataformat.task;
                }
            } else {
                String string2 = string.substring(n + 1);
                if (string.startsWith("cbf.")) {
                    dataformat2 = dataformat.cb;
                } else if (string.startsWith("ptf.")) {
                    dataformat2 = dataformat.ptf;
                } else if (string.startsWith("opf.")) {
                    dataformat2 = dataformat.op;
                } else if (string.startsWith("lp.")) {
                    dataformat2 = dataformat.lp;
                } else if (string.startsWith("jtask.")) {
                    dataformat2 = dataformat.json_task;
                } else if (string.startsWith("task.")) {
                    dataformat2 = dataformat.task;
                }
                if (string2.equals("gz")) {
                    compresstype2 = compresstype.gzip;
                } else if (string2.equals("zst")) {
                    compresstype2 = compresstype.zstd;
                }
            }
            this.task.putintparam(iparam.opf_write_solutions, 1);
            this.task.writedatastream(dataformat2, compresstype2, outputStream);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected Task task_get() {
        return this.task;
    }

    public Task clonetask() {
        return new Task(this.task);
    }

    protected void task_break_solve() {
        this.breaksolve.setbreak(true);
    }

    protected void task_putoptserver_host(String string) {
        this.task.putoptserverhost(string);
    }

    protected abstract void clear_solutions();

    protected abstract void report_solution(SolutionType var1, ProblemStatus var2, SolutionStatus var3, SolutionStatus var4, double var5, double var7, int var9, int var10, int var11, int var12, int var13, boolean var14, boolean var15);

    protected void report_solution_get_xx(double[] dArray) {
        this.task.getxxslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_slx(double[] dArray) {
        this.task.getslxslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_sux(double[] dArray) {
        this.task.getsuxslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_xc(double[] dArray) {
        this.task.getxcslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_slc(double[] dArray) {
        this.task.getslcslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_suc(double[] dArray) {
        this.task.getsucslice(this.cursol, 0, dArray.length, dArray);
    }

    protected void report_solution_get_barx(double[] dArray) {
        this.task.getbarxslice(this.cursol, 0, this.task.getnumbarvar(), dArray.length, dArray);
    }

    protected void report_solution_get_bars(double[] dArray) {
        this.task.getbarsslice(this.cursol, 0, this.task.getnumbarvar(), dArray.length, dArray);
    }

    protected void report_solution_get_accx(double[] dArray) {
        this.task.evaluateaccs(this.cursol, dArray);
    }

    protected void report_solution_get_accy(double[] dArray) {
        long l = 0L;
        long l2 = this.task.getnumacc();
        int n = 0;
        while ((long)n < l2) {
            long l3 = this.task.getaccn(n);
            double[] dArray2 = new double[(int)l3];
            this.task.getaccdoty(this.cursol, n, dArray2);
            int n2 = 0;
            while ((long)n2 < l3) {
                dArray[(int)l + n2] = dArray2[n2];
                ++n2;
            }
            l += l3;
            ++n;
        }
    }

    protected void report_solution_get_accptr(int[] nArray) {
        long l = 0L;
        long l2 = this.task.getnumacc();
        int n = 0;
        while ((long)n < l2) {
            nArray[n] = (int)l;
            l += this.task.getaccn(n);
            ++n;
        }
    }

    private void report_task_solution(soltype soltype2, int n, int n2, int n3, long l, long l2) {
        ProblemStatus problemStatus;
        SolutionStatus solutionStatus;
        SolutionStatus solutionStatus2;
        solsta[] solstaArray = new solsta[1];
        this.task.getsolsta(soltype2, solstaArray);
        prosta[] prostaArray = new prosta[1];
        this.task.getprosta(soltype2, prostaArray);
        boolean bl = false;
        boolean bl2 = false;
        switch (solstaArray[0]) {
            case optimal: {
                solutionStatus2 = SolutionStatus.Optimal;
                solutionStatus = SolutionStatus.Optimal;
                bl = true;
                bl2 = true;
                break;
            }
            case integer_optimal: {
                solutionStatus2 = SolutionStatus.Optimal;
                solutionStatus = SolutionStatus.Undefined;
                bl = true;
                break;
            }
            case prim_and_dual_feas: {
                solutionStatus2 = SolutionStatus.Feasible;
                solutionStatus = SolutionStatus.Feasible;
                bl = true;
                bl2 = true;
                break;
            }
            case prim_feas: {
                solutionStatus2 = SolutionStatus.Feasible;
                solutionStatus = SolutionStatus.Undefined;
                bl = true;
                break;
            }
            case dual_feas: {
                solutionStatus2 = SolutionStatus.Undefined;
                solutionStatus = SolutionStatus.Feasible;
                bl2 = true;
                break;
            }
            case prim_infeas_cer: {
                solutionStatus2 = SolutionStatus.Undefined;
                solutionStatus = SolutionStatus.Certificate;
                bl2 = true;
                break;
            }
            case dual_infeas_cer: {
                solutionStatus2 = SolutionStatus.Certificate;
                solutionStatus = SolutionStatus.Undefined;
                bl = true;
                break;
            }
            case prim_illposed_cer: {
                solutionStatus2 = SolutionStatus.Undefined;
                solutionStatus = SolutionStatus.IllposedCert;
                bl2 = true;
                break;
            }
            case dual_illposed_cer: {
                solutionStatus2 = SolutionStatus.IllposedCert;
                solutionStatus = SolutionStatus.Undefined;
                bl = true;
                break;
            }
            default: {
                solutionStatus2 = SolutionStatus.Unknown;
                solutionStatus = SolutionStatus.Unknown;
                bl = true;
                bl2 = true;
            }
        }
        if (soltype2 == soltype.itg) {
            solutionStatus = SolutionStatus.Undefined;
            bl2 = false;
            if (prostaArray[0] == prosta.prim_infeas) {
                solutionStatus2 = SolutionStatus.Undefined;
                bl = false;
            }
        }
        double[] dArray = new double[]{0.0};
        if (bl) {
            this.task.getprimalobj(soltype2, dArray);
        }
        double[] dArray2 = new double[]{0.0};
        if (bl2) {
            this.task.getdualobj(soltype2, dArray2);
        }
        switch (prostaArray[0]) {
            case unknown: {
                problemStatus = ProblemStatus.Unknown;
                break;
            }
            case prim_and_dual_feas: {
                problemStatus = ProblemStatus.PrimalAndDualFeasible;
                break;
            }
            case prim_feas: {
                problemStatus = ProblemStatus.PrimalFeasible;
                break;
            }
            case dual_feas: {
                problemStatus = ProblemStatus.DualFeasible;
                break;
            }
            case prim_infeas: {
                problemStatus = ProblemStatus.PrimalInfeasible;
                break;
            }
            case dual_infeas: {
                problemStatus = ProblemStatus.DualInfeasible;
                break;
            }
            case prim_and_dual_infeas: {
                problemStatus = ProblemStatus.PrimalAndDualInfeasible;
                break;
            }
            case ill_posed: {
                problemStatus = ProblemStatus.IllPosed;
                break;
            }
            case prim_infeas_or_unbounded: {
                problemStatus = ProblemStatus.PrimalInfeasibleOrUnbounded;
                break;
            }
            default: {
                problemStatus = ProblemStatus.Unknown;
            }
        }
        SolutionType solutionType = null;
        switch (soltype2) {
            case bas: {
                solutionType = SolutionType.Basic;
                break;
            }
            case itr: {
                solutionType = SolutionType.Interior;
                break;
            }
            case itg: {
                solutionType = SolutionType.Integer;
            }
        }
        this.cursol = soltype2;
        this.report_solution(solutionType, problemStatus, solutionStatus2, solutionStatus, dArray[0], dArray2[0], n, n2, n3, (int)l, (int)l2, bl, bl2);
    }

    protected static SolverStatus[] env_solve_batch(boolean bl, double d, int n, Model[] modelArray) {
        int n2;
        int n3 = modelArray.length;
        Task[] taskArray = new Task[n3];
        rescode[] rescodeArray = new rescode[n3];
        rescode[] rescodeArray2 = new rescode[n3];
        SolverStatus[] solverStatusArray = new SolverStatus[n3];
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            taskArray[n2] = modelArray[n2].getTask();
            rescodeArray[n2] = rescode.err_unknown;
            rescodeArray2[n2] = rescode.err_unknown;
        }
        try {
            BaseModel.globalEnv().optimizebatch(bl, d, n, taskArray, rescodeArray2, rescodeArray);
            bl2 = true;
        }
        catch (Error error) {
            throw new OptimizeError(error.toString());
        }
        finally {
            if (!bl2) {
                for (int i = 0; i < n3; ++i) {
                    modelArray[i].clear_solutions();
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            solverStatusArray[n2] = rescodeArray[n2] != rescode.ok ? SolverStatus.Error : (rescodeArray2[n2] == rescode.trm_lost_race ? SolverStatus.LostRace : SolverStatus.OK);
        }
        return solverStatusArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void task_solve(boolean bl, String string, String string2) throws OptimizeError {
        boolean bl2 = false;
        this.synched = false;
        try {
            rescode rescode2 = rescode.ok;
            try {
                this.breaksolve.setbreak(false);
                if (bl) {
                    rescode[] rescodeArray = new rescode[1];
                    this.task.optimizermt(string, string2, rescodeArray);
                    rescode2 = rescodeArray[0];
                } else {
                    rescode2 = this.task.optimize();
                }
                if (this.logwriter != null) {
                    this.task.solutionsummary(streamtype.log);
                }
                bl2 = true;
            }
            catch (Error error) {
                throw new OptimizeError(error.toString());
            }
            catch (Warning warning) {
                // empty catch block
            }
        }
        finally {
            if (!bl2) {
                this.clear_solutions();
            }
        }
    }

    protected void task_post_solve() {
        try {
            int n = this.task.getnumcon();
            int n2 = this.task.getnumvar();
            int n3 = this.task.getnumbarvar();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                int n5 = this.task.getdimbarvarj(i);
                n4 += n5 * (1 + n5) / 2;
            }
            long l = this.task.getnumacc();
            long l2 = this.task.getaccntot();
            boolean bl = this.task.solutiondef(soltype.bas);
            boolean bl2 = this.task.solutiondef(soltype.itr);
            boolean bl3 = this.task.solutiondef(soltype.itg);
            this.clear_solutions();
            if (bl2) {
                this.report_task_solution(soltype.itr, n2, n, n4, l, l2);
            }
            if (bl) {
                this.report_task_solution(soltype.bas, n2, n, n4, l, l2);
            }
            if (bl3) {
                this.report_task_solution(soltype.itg, n2, n, n4, l, l2);
            }
            this.synched = true;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_barvardim(int n) {
        return this.task.getdimbarvarj(n);
    }

    protected int task_numbarvar() {
        try {
            return this.task.getnumbarvar();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numcon() {
        try {
            return this.task.getnumcon();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numvar() {
        try {
            return this.task.getnumvar();
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_numacc() {
        return (int)this.task.getnumacc();
    }

    protected int task_numdjc() {
        return (int)this.task.getnumdjc();
    }

    protected int task_numafe() {
        return (int)this.task.getnumafe();
    }

    protected void task_format_djc_names(long[] lArray, String string, int[] nArray, String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        int[] nArray2 = null;
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n3;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                n += stringArray[n3].length;
            }
            stringArray2 = new String[n];
            int n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                ++n2;
                int n5 = 0;
                while (n5 < stringArray[n3].length) {
                    stringArray2[n4] = stringArray[n3][n5];
                    ++n5;
                    ++n4;
                }
            }
            nArray2 = new int[n2];
            n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                nArray2[n4] = n3;
                ++n4;
            }
        }
        try {
            this.task.generatedjcnames(lArray, string, nArray, null, nArray2, stringArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_format_acc_names(long[] lArray, String string, int[] nArray, String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        int[] nArray2 = null;
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n3;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                n += stringArray[n3].length;
            }
            stringArray2 = new String[n];
            int n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                ++n2;
                int n5 = 0;
                while (n5 < stringArray[n3].length) {
                    stringArray2[n4] = stringArray[n3][n5];
                    ++n5;
                    ++n4;
                }
            }
            nArray2 = new int[n2];
            n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                nArray2[n4] = n3;
                ++n4;
            }
        }
        try {
            this.task.generateaccnames(lArray, string, nArray, null, nArray2, stringArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_format_var_names(int[] nArray, String string, int[] nArray2, long[] lArray, String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        int[] nArray3 = null;
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n3;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                n += stringArray[n3].length;
            }
            stringArray2 = new String[n];
            int n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                ++n2;
                int n5 = 0;
                while (n5 < stringArray[n3].length) {
                    stringArray2[n4] = stringArray[n3][n5];
                    ++n5;
                    ++n4;
                }
            }
            nArray3 = new int[n2];
            n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                nArray3[n4] = n3;
                ++n4;
            }
        }
        try {
            this.task.generatevarnames(nArray, string, nArray2, lArray, nArray3, stringArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_format_barvar_names(int[] nArray, String string, int[] nArray2, String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        int[] nArray3 = null;
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n3;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                n += stringArray[n3].length;
            }
            stringArray2 = new String[n];
            int n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                ++n2;
                int n5 = 0;
                while (n5 < stringArray[n3].length) {
                    stringArray2[n4] = stringArray[n3][n5];
                    ++n5;
                    ++n4;
                }
            }
            nArray3 = new int[n2];
            n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                nArray3[n4] = n3;
                ++n4;
            }
        }
        try {
            this.task.generatebarvarnames(nArray, string, nArray2, null, nArray3, stringArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_format_con_names(int[] nArray, String string, int[] nArray2, long[] lArray, String[][] stringArray) {
        int n = 0;
        int n2 = 0;
        int[] nArray3 = null;
        String[] stringArray2 = null;
        if (stringArray != null) {
            int n3;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                n += stringArray[n3].length;
            }
            stringArray2 = new String[n];
            int n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                ++n2;
                int n5 = 0;
                while (n5 < stringArray[n3].length) {
                    stringArray2[n4] = stringArray[n3][n5];
                    ++n5;
                    ++n4;
                }
            }
            nArray3 = new int[n2];
            n4 = 0;
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (stringArray[n3] == null) continue;
                nArray3[n4] = n3;
                ++n4;
            }
        }
        try {
            this.task.generateconnames(nArray, string, nArray2, lArray, nArray3, stringArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_con_name(int n, String string) {
        try {
            this.task.putconname(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_name(int n, String string) {
        try {
            this.task.putvarname(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_barvar_name(int n, String string) {
        try {
            this.task.putbarvarname(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_cone_name(int n, String string) {
        try {
            this.task.putconename(n, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_acc_name(long l, String string) {
        try {
            this.task.putaccname(l, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_djc_name(long l, String string) {
        try {
            this.task.putdjcname(l, string);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putc(int[] nArray, double[] dArray, double d) {
        this.synched = false;
        try {
            int n;
            int n2 = this.task.getnumvar();
            int[] nArray2 = new int[n2];
            double[] dArray2 = new double[n2];
            for (n = 0; n < n2; ++n) {
                nArray2[n] = n;
            }
            for (n = 0; n < nArray.length; ++n) {
                dArray2[nArray[n]] = dArray[n];
            }
            this.task.putclist(nArray2, dArray2);
            this.task.putcfix(d);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    private void task_putvarboundlist(int[] nArray, double[] dArray, double[] dArray2, boundkey boundkey2) {
        this.synched = false;
        int n = nArray.length;
        if (dArray == null) {
            dArray = new double[n];
        }
        if (dArray2 == null) {
            dArray2 = new double[n];
        }
        boundkey[] boundkeyArray = new boundkey[n];
        for (int i = 0; i < n; ++i) {
            boundkeyArray[i] = boundkey2;
        }
        try {
            this.task.putvarboundlist(nArray, boundkeyArray, dArray, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    private void task_putconboundlist(int[] nArray, double[] dArray, double[] dArray2, boundkey boundkey2) {
        this.synched = false;
        int n = nArray.length;
        if (dArray == null) {
            dArray = new double[n];
        }
        if (dArray2 == null) {
            dArray2 = new double[n];
        }
        boundkey[] boundkeyArray = new boundkey[n];
        for (int i = 0; i < n; ++i) {
            boundkeyArray[i] = boundkey2;
        }
        try {
            this.task.putconboundlist(nArray, boundkeyArray, dArray, dArray2);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_putboundlist_fr(int[] nArray) {
        this.task_putvarboundlist(nArray, null, null, boundkey.fr);
    }

    protected void task_var_putboundlist_fx(int[] nArray, double[] dArray) {
        this.task_putvarboundlist(nArray, dArray, dArray, boundkey.fx);
    }

    protected void task_var_putboundlist_lo(int[] nArray, double[] dArray) {
        this.task_putvarboundlist(nArray, dArray, dArray, boundkey.lo);
    }

    protected void task_var_putboundlist_up(int[] nArray, double[] dArray) {
        this.task_putvarboundlist(nArray, dArray, dArray, boundkey.up);
    }

    protected void task_var_putboundlist_ra(int[] nArray, double[] dArray, double[] dArray2) {
        this.task_putvarboundlist(nArray, dArray, dArray2, boundkey.ra);
    }

    protected void task_con_putboundlist_fr(int[] nArray) {
        this.task_putconboundlist(nArray, null, null, boundkey.fr);
    }

    protected void task_con_putboundlist_fx(int[] nArray, double[] dArray) {
        this.task_putconboundlist(nArray, dArray, dArray, boundkey.fx);
    }

    protected void task_con_putboundlist_lo(int[] nArray, double[] dArray) {
        this.task_putconboundlist(nArray, dArray, dArray, boundkey.lo);
    }

    protected void task_con_putboundlist_up(int[] nArray, double[] dArray) {
        this.task_putconboundlist(nArray, dArray, dArray, boundkey.up);
    }

    protected void task_con_putboundlist_ra(int[] nArray, double[] dArray, double[] dArray2) {
        this.task_putconboundlist(nArray, dArray, dArray2, boundkey.ra);
    }

    protected int task_append_var(int n) {
        int n2 = this.task.getnumvar();
        this.task.appendvars(n);
        return n2;
    }

    protected int task_append_barvar(int n, int n2) {
        try {
            int n3 = this.task.getnumbarvar();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = n;
            }
            this.task.appendbarvars(nArray);
            return n3;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected int task_append_con(int n) {
        try {
            int n2 = this.task.getnumcon();
            this.task.appendcons(n);
            return n2;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_putintlist(int[] nArray) {
        try {
            variabletype[] variabletypeArray = new variabletype[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                variabletypeArray[i] = variabletype.type_int;
            }
            this.task.putvartypelist(nArray, variabletypeArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_var_putcontlist(int[] nArray) {
        try {
            variabletype[] variabletypeArray = new variabletype[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                variabletypeArray[i] = variabletype.type_cont;
            }
            this.task.putvartypelist(nArray, variabletypeArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_putxx_slice(SolutionType solutionType, int n, int n2, double[] dArray) {
        switch (solutionType) {
            case Interior: {
                this.task.putxxslice(soltype.itr, n, n2, dArray);
                break;
            }
            case Integer: {
                this.task.putxxslice(soltype.itg, n, n2, dArray);
                break;
            }
            case Basic: {
                this.task.putxxslice(soltype.bas, n, n2, dArray);
            }
        }
    }

    protected long task_append_afes(long l) {
        try {
            long l2 = this.task.getnumafe();
            this.task.appendafes(l);
            return l2;
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    protected void task_clearafelist(long[] lArray) {
        this.task.emptyafefrowlist(lArray);
        this.task.emptyafebarfrowlist(lArray);
        this.task.putafeglist(lArray, new double[lArray.length]);
    }

    protected void task_putafeflist(long[] lArray, int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        long[] lArray2 = new long[nArray.length - 1];
        for (int i = 0; i < lArray2.length; ++i) {
            lArray2[i] = nArray[i];
        }
        int[] nArray3 = new int[nArray.length - 1];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = nArray[i + 1] - nArray[i];
        }
        this.task.putafefrowlist(lArray, nArray3, lArray2, nArray2, dArray);
        this.task.putafeglist(lArray, dArray2);
    }

    protected void task_putafebarfrowlist(int[] nArray, int[] nArray2, int[] nArray3, long[] lArray) {
        int n;
        int n2 = nArray3.length;
        long[] lArray2 = new long[n2];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n = nArray2[i];
            while (n < nArray2[i + 1]) {
                lArray2[n3] = nArray[i];
                ++n;
                ++n3;
            }
        }
        long[] lArray3 = new long[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            lArray3[n3] = 1L;
        }
        long[] lArray4 = new long[n2];
        for (n = 0; n < n2; ++n) {
            lArray4[n] = n;
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 1.0;
        }
        this.task.putafebarfentrylist(lArray2, nArray3, lArray3, lArray4, lArray, dArray);
    }

    protected void task_putafefijlist(int[] nArray, int[] nArray2, double[] dArray) {
        long[] lArray = new long[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            lArray[i] = nArray[i];
        }
        this.task.putafefentrylist(lArray, nArray2, dArray);
    }

    protected void task_putafefglist(long[] lArray, double[] dArray) {
        this.task.putafeglist(lArray, dArray);
    }

    protected void task_append_accs(long l, int n, long[] lArray, double[] dArray) {
        long[] lArray2 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray2[i] = l;
        }
        this.task.appendaccs(lArray2, lArray, dArray);
    }

    protected void task_putacclist(long[] lArray, long[] lArray2, long[] lArray3, double[] dArray) {
        this.task.putacclist(lArray, lArray2, lArray3, dArray);
    }

    protected long task_append_domain_quad(int n) {
        return this.task.appendquadraticconedomain(n);
    }

    protected long task_append_domain_rquad(int n) {
        return this.task.appendrquadraticconedomain(n);
    }

    protected long task_append_domain_pexp() {
        return this.task.appendprimalexpconedomain();
    }

    protected long task_append_domain_dexp() {
        return this.task.appenddualexpconedomain();
    }

    protected long task_append_domain_ppow(int n, double[] dArray) {
        return this.task.appendprimalpowerconedomain(n, dArray);
    }

    protected long[] task_append_domain_ppow_seq(int n, int n2, double[] dArray) {
        int n3 = dArray.length / n2;
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = n;
        }
        long[] lArray2 = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray2[i] = n2;
        }
        return this.task.appendprimalpowerconedomainseq(lArray, lArray2, dArray);
    }

    protected long task_append_domain_dpow(int n, double[] dArray) {
        return this.task.appenddualpowerconedomain(n, dArray);
    }

    protected long[] task_append_domain_dpow_seq(int n, int n2, double[] dArray) {
        int n3 = dArray.length / n2;
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = n;
        }
        long[] lArray2 = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray2[i] = n2;
        }
        return this.task.appenddualpowerconedomainseq(lArray, lArray2, dArray);
    }

    protected long task_append_domain_pgeomean(int n) {
        return this.task.appendprimalgeomeanconedomain(n);
    }

    protected long task_append_domain_dgeomean(int n) {
        return this.task.appenddualgeomeanconedomain(n);
    }

    protected long task_append_domain_rpos(int n) {
        return this.task.appendrplusdomain(n);
    }

    protected long task_append_domain_rneg(int n) {
        return this.task.appendrminusdomain(n);
    }

    protected long task_append_domain_r(int n) {
        return this.task.appendrdomain(n);
    }

    protected long task_append_domain_rzero(int n) {
        return this.task.appendrzerodomain(n);
    }

    protected long task_append_domain_svec_psd(int n) {
        return this.task.appendsvecpsdconedomain(n);
    }

    protected long task_append_domain_empty() {
        return this.task.appendrdomain(0L);
    }

    protected long task_append_djc(long l) {
        long l2 = this.task.getnumdjc();
        this.task.appenddjcs(l);
        return l2;
    }

    protected void task_putdjcslice(long l, long l2, long[] lArray, long[] lArray2, long[] lArray3, long[] lArray4, double[] dArray) {
        try {
            this.task.putdjcslice(l, l2, lArray3, lArray4, dArray, lArray2, lArray);
        }
        catch (MosekException mosekException) {
            throw new UnexpectedError(mosekException.toString());
        }
    }

    public void dispose() {
        if (this.task != null) {
            Task task = this.task;
            this.task = null;
            task.dispose();
            --env_counter;
            task.dispose();
        }
    }

    protected void finalize() {
        this.dispose();
    }

    @Override
    public void close() {
        this.dispose();
    }
}

