/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.Tools;

public class SymmetricMatrix {
    private int nnz;
    private double scale;
    private double[] vval;
    private int[] vsubj;
    private int[] vsubi;
    private double[] uval;
    private int[] usubj;
    private int[] usubi;
    private int d1;
    private int d0;

    protected SymmetricMatrix(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, int[] nArray3, int[] nArray4, double[] dArray2, double d) {
        this.d0 = n;
        this.d1 = n2;
        this.usubi = nArray;
        this.usubj = nArray2;
        this.uval = dArray;
        this.vsubi = nArray3;
        this.vsubj = nArray4;
        this.vval = dArray2;
        this.scale = d;
        this.nnz = -1;
    }

    public static SymmetricMatrix rankOne(int n, int[] nArray, double[] dArray) {
        int n2;
        if (nArray.length != dArray.length) {
            throw new LengthError("Mismatching array lengths");
        }
        int n3 = 0;
        int n4 = nArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (nArray[n2] >= 0 && nArray[n2] < n) continue;
            throw new LengthError("Invalid index in argument 'sub'");
        }
        n3 = 0;
        n4 = 0;
        n2 = nArray.length;
        int n5 = n4 < n2 ? n2 - n4 : 0;
        int[] nArray2 = new int[n5];
        int n6 = n4;
        int n7 = 0;
        while (n7 < n5) {
            nArray2[n3] = nArray[n6];
            ++n3;
            ++n7;
            ++n6;
        }
        int[] nArray3 = nArray2;
        int n8 = 0;
        int n9 = 0;
        int n10 = nArray.length;
        int n11 = n9 < n10 ? n10 - n9 : 0;
        int[] nArray4 = new int[n11];
        int n12 = n9;
        int n13 = 0;
        while (n13 < n11) {
            nArray4[n8] = 1;
            ++n8;
            ++n13;
            ++n12;
        }
        int[] nArray5 = nArray4;
        int n14 = 0;
        int n15 = 0;
        int n16 = dArray.length;
        int n17 = n15 < n16 ? n16 - n15 : 0;
        double[] dArray2 = new double[n17];
        int n18 = n15;
        int n19 = 0;
        while (n19 < n17) {
            dArray2[n14] = dArray[n18];
            ++n14;
            ++n19;
            ++n18;
        }
        double[] dArray3 = dArray2;
        return new SymmetricMatrix(n, 1, nArray3, nArray5, dArray3, nArray3, nArray5, dArray3, 1.0);
    }

    public static SymmetricMatrix rankOne(double[] dArray) {
        int n = dArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray = new int[n5];
        int n6 = n3;
        for (int i = 0; i < n5; ++i) {
            nArray[n2] = n6++;
            ++n2;
        }
        int[] nArray2 = nArray;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        int[] nArray3 = new int[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            nArray3[n7] = 1;
            ++n7;
            ++n12;
            ++n11;
        }
        int[] nArray4 = nArray3;
        int n13 = 0;
        int n14 = 0;
        int n15 = n;
        int n16 = n14 < n15 ? n15 - n14 : 0;
        double[] dArray2 = new double[n16];
        int n17 = n14;
        int n18 = 0;
        while (n18 < n16) {
            dArray2[n13] = dArray[n17];
            ++n13;
            ++n18;
            ++n17;
        }
        double[] dArray3 = dArray2;
        return new SymmetricMatrix(n, 1, nArray2, nArray4, dArray3, nArray2, nArray4, dArray3, 1.0);
    }

    public static SymmetricMatrix antiDiag(double[] dArray) {
        int n = dArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray = new int[n5];
        int n6 = n3;
        for (int i = 0; i < n5; ++i) {
            nArray[n2] = n6++;
            ++n2;
        }
        int[] nArray2 = nArray;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        int[] nArray3 = new int[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            nArray3[n7] = n - n11;
            ++n7;
            ++n12;
            ++n11;
        }
        n12 = 0;
        int n13 = 0;
        int n14 = n;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        double[] dArray2 = new double[n15];
        int n16 = n13;
        int n17 = 0;
        while (n17 < n15) {
            dArray2[n12] = dArray[n16];
            ++n12;
            ++n17;
            ++n16;
        }
        n17 = 0;
        int n18 = 0;
        int n19 = n;
        int n20 = n18 < n19 ? n19 - n18 : 0;
        double[] dArray3 = new double[n20];
        int n21 = n18;
        int n22 = 0;
        while (n22 < n20) {
            dArray3[n17] = 1.0;
            ++n17;
            ++n22;
            ++n21;
        }
        return new SymmetricMatrix(n, n, nArray2, nArray3, dArray2, nArray2, nArray2, dArray3, 1.0);
    }

    public static SymmetricMatrix diag(double[] dArray) {
        int n = dArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray = new int[n5];
        int n6 = n3;
        for (int i = 0; i < n5; ++i) {
            nArray[n2] = n6++;
            ++n2;
        }
        int[] nArray2 = nArray;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        double[] dArray2 = new double[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            dArray2[n7] = dArray[n11];
            ++n7;
            ++n12;
            ++n11;
        }
        n12 = 0;
        int n13 = 0;
        int n14 = n;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        double[] dArray3 = new double[n15];
        int n16 = n13;
        int n17 = 0;
        while (n17 < n15) {
            dArray3[n12] = 1.0;
            ++n12;
            ++n17;
            ++n16;
        }
        return new SymmetricMatrix(n, n, nArray2, nArray2, dArray2, nArray2, nArray2, dArray3, 1.0);
    }

    public SymmetricMatrix add(SymmetricMatrix symmetricMatrix) {
        int n;
        int n2 = this.getdim();
        if (symmetricMatrix.getdim() != n2) {
            throw new DimensionError("Mismatching dimensions");
        }
        int n3 = this.usubi.length;
        int n4 = symmetricMatrix.usubi.length;
        int n5 = n3 + n4;
        int n6 = this.vsubi.length;
        int n7 = symmetricMatrix.vsubi.length;
        int n8 = n6 + n7;
        double[] dArray = new double[n8];
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n8];
        double[] dArray2 = new double[n5];
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        Tools.arraycopy(this.usubi, 0, nArray4, 0, n3);
        Tools.arraycopy(symmetricMatrix.usubi, 0, nArray4, n3, n4);
        Tools.arraycopy(this.usubj, 0, nArray3, 0, n3);
        int n9 = 0;
        int n10 = n4;
        for (n = n9; n < n10; ++n) {
            nArray3[n + n3] = symmetricMatrix.usubj[n] + this.d1;
        }
        if (this.scale > 1.0 || this.scale < 1.0) {
            Tools.arraycopy(this.uval, 0, dArray2, 0, n3);
        } else {
            n9 = 0;
            n10 = n3;
            for (n = n9; n < n10; ++n) {
                dArray2[n] = this.scale * this.uval[n];
            }
        }
        if (symmetricMatrix.scale > 1.0 || symmetricMatrix.scale < 1.0) {
            Tools.arraycopy(symmetricMatrix.uval, 0, dArray2, n3, n4);
        } else {
            n9 = 0;
            n10 = n4;
            for (n = n9; n < n10; ++n) {
                dArray2[n + n3] = symmetricMatrix.scale * symmetricMatrix.uval[n];
            }
        }
        Tools.arraycopy(this.usubi, 0, nArray4, 0, n3);
        n9 = 0;
        n10 = n7;
        for (n = n9; n < n10; ++n) {
            nArray2[n + n6] = symmetricMatrix.vsubi[n] + symmetricMatrix.d1;
        }
        Tools.arraycopy(this.vsubj, 0, nArray, 0, n6);
        Tools.arraycopy(symmetricMatrix.vsubj, n6, nArray, n6, n7);
        if (this.scale > 1.0 || this.scale < 1.0) {
            Tools.arraycopy(this.vval, 0, dArray, 0, n6);
        } else {
            n9 = 0;
            n10 = n6;
            for (n = n9; n < n10; ++n) {
                dArray[n] = this.scale * this.vval[n];
            }
        }
        if (symmetricMatrix.scale > 1.0 || symmetricMatrix.scale < 1.0) {
            Tools.arraycopy(symmetricMatrix.vval, 0, dArray, n6, n7);
        } else {
            n9 = 0;
            n10 = n7;
            for (n = n9; n < n10; ++n) {
                dArray[n + n6] = symmetricMatrix.scale * symmetricMatrix.vval[n];
            }
        }
        return new SymmetricMatrix(this.d0, this.d1 + symmetricMatrix.d1, nArray4, nArray3, dArray2, nArray2, nArray, dArray, 1.0);
    }

    public SymmetricMatrix sub(SymmetricMatrix symmetricMatrix) {
        return this.add(symmetricMatrix.mul(-1.0));
    }

    public SymmetricMatrix mul(double d) {
        return new SymmetricMatrix(this.d0, this.d1, this.usubi, this.usubj, this.uval, this.vsubi, this.vsubj, this.vval, this.scale * d);
    }

    public int getdim() {
        return this.d0;
    }
}

