/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.Set;

public class IndexCounter {
    private long start;
    private int[] dims;
    private long[] strides;
    private long[] st;
    private int[] ii;
    private int n;

    public IndexCounter(int[] nArray) {
        this.n = nArray.length;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        this.start = 0L;
        this.strides = Set.strides(nArray);
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        this.dims = nArray2;
    }

    public IndexCounter(long l, int[] nArray, int[] nArray2) {
        int n = nArray2.length;
        this.n = nArray.length;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        int n2 = 0;
        int n3 = this.n;
        for (int i = n2; i < n3; ++i) {
            this.st[i] = l;
        }
        this.strides = Set.strides(nArray2);
        this.dims = nArray;
        this.start = l;
    }

    public IndexCounter(long l, int[] nArray, long[] lArray) {
        this.n = nArray.length;
        this.ii = new int[this.n];
        this.st = new long[this.n];
        int n = 0;
        int n2 = this.n;
        for (int i = n; i < n2; ++i) {
            this.st[i] = l;
        }
        this.strides = lArray;
        this.dims = nArray;
        this.start = l;
    }

    public boolean atEnd() {
        return this.ii[this.n - 1] >= this.dims[this.n - 1];
    }

    public int[] getIndex() {
        return this.ii;
    }

    public long next() {
        long l = this.get();
        this.inc();
        return l;
    }

    public long get() {
        return this.st[0];
    }

    public void inc() {
        int n;
        this.ii[0] = this.ii[0] + 1;
        this.st[0] = this.st[0] + this.strides[this.n - 1];
        for (n = 0; n < this.n - 1 && this.ii[n] == this.dims[this.n - n - 1] && n < this.n - 1 && this.ii[n] == this.dims[this.n - n - 1]; ++n) {
            this.ii[n] = 0;
            int n2 = n + 1;
            this.ii[n2] = this.ii[n2] + 1;
            this.st[n + 1] = this.st[n + 1] + this.strides[this.n - n - 2];
        }
        int n3 = 0;
        int n4 = n;
        for (int i = n3; i < n4; ++i) {
            this.st[i] = this.st[n];
        }
    }

    public void reset() {
        this.st = new long[this.n];
        int n = 0;
        int n2 = this.n;
        for (int i = n; i < n2; ++i) {
            this.st[i] = this.start;
        }
    }
}

