/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public final class ExprCrossDot
extends BaseExpression {
    private Expression expr;
    private double[] mval;
    private int[] msubj;
    private int[] msubi;
    private int mdim1;
    private int mdim0;

    public ExprCrossDot(Matrix matrix, Expression expression) {
        super(expression.getModel(), ExprCrossDot.computeshape(matrix.numRows(), matrix.numColumns(), expression.getShape()));
        long l = matrix.numNonzeros();
        this.mdim0 = matrix.numRows();
        this.mdim1 = matrix.numColumns();
        if (matrix.isSparse()) {
            this.msubi = new int[(int)l];
            this.msubj = new int[(int)l];
            this.mval = new double[(int)l];
            matrix.getDataAsTriplets(this.msubi, this.msubj, this.mval);
        } else {
            this.mval = matrix.getDataAsArray();
            this.msubi = null;
            this.msubj = null;
        }
        ExprCrossDot.validate(this.mdim0, this.mdim1, this.msubi, this.msubj, this.mval, expression);
        this.expr = expression;
    }

    protected ExprCrossDot(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression, int n3) {
        super(expression.getModel(), ExprCrossDot.computeshape(n, n2, expression.getShape()));
        this.mdim0 = n;
        this.mdim1 = n2;
        this.msubi = nArray;
        this.msubj = nArray2;
        this.mval = dArray;
        this.expr = expression;
    }

    public ExprCrossDot(int n, int n2, double[] dArray, Expression expression) {
        this(n, n2, null, null, dArray, expression, ExprCrossDot.validate(n, n2, null, null, dArray, expression));
    }

    public ExprCrossDot(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        this(n, n2, nArray, nArray2, dArray, expression, 1);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        this.expr.recursive_eval(workStack2, workStack, workStack3, bl);
        workStack2.pop_expr();
        int n14 = workStack2.nd;
        int n15 = workStack2.nnz;
        int n16 = workStack2.nelem;
        int n17 = workStack2.ncodeatom;
        boolean bl2 = workStack2.hassp;
        int n18 = workStack2.shape_base;
        int n19 = workStack2.ptr_base;
        int n20 = workStack2.sp_base;
        int n21 = workStack2.nidxs_base;
        int n22 = workStack2.cof_base;
        int n23 = workStack2.codeptr_base;
        int n24 = workStack2.code_base;
        int n25 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n26 = 0;
        int n27 = 0;
        boolean bl3 = false;
        int n28 = 0;
        int n29 = nArray[n18 + 0];
        int n30 = nArray[n18 + 1];
        int n31 = this.mval.length;
        if (this.msubi == null || this.msubj == null) {
            if (!bl2) {
                n26 = n15 * this.mdim0;
                n27 = this.mdim0 * n29;
                n28 = n17 > 0 ? (n17 + n15 * 2) * this.mdim0 : 0;
            } else {
                n26 = n15 * this.mdim0;
                n28 = n17 > 0 ? (n17 + n15 * 2) * this.mdim0 : 0;
                n13 = -1;
                n12 = 0;
                while (n12 < n16 && n12 < n16) {
                    long l = lArray[n20 + n12] / (long)n30;
                    ++n12;
                    while (n12 < n16 && lArray[n20 + n12] / (long)n30 == l) {
                        ++n12;
                    }
                    ++n27;
                }
                n27 *= this.mdim0;
            }
        } else if (!bl2) {
            n13 = 0;
            while (n13 < n31 && n13 < n31) {
                ++n27;
                n12 = n13;
                int n32 = this.msubi[n13];
                ++n13;
                while (n13 < n31 && this.msubi[n13] == n32) {
                    ++n13;
                }
                n11 = n13;
                n10 = 0;
                n9 = n29;
                for (int i = n10; i < n9; ++i) {
                    n8 = n12;
                    n7 = n11;
                    for (n6 = n8; n6 < n7; ++n6) {
                        n5 = this.msubj[n6];
                        n4 = nArray[n19 + i * n30 + n5 + 1];
                        n3 = nArray[n19 + i * n30 + n5];
                        n2 = n4 - n3;
                        n26 += n2;
                        n28 += n17 > 0 ? nArray[n23 + n4] - nArray[n23 + n3] + n2 * 2 : 0;
                    }
                }
            }
            n27 *= n29;
        } else {
            n13 = 0;
            while (n13 < n31 && n13 < n31) {
                n12 = n13;
                int n33 = this.msubi[n13];
                ++n13;
                while (n13 < n31 && this.msubi[n13] == n33) {
                    ++n13;
                }
                n11 = n13;
                n10 = 0;
                while (n10 < n16 && n10 < n16) {
                    n9 = n10;
                    long l = lArray[n20 + n10] / (long)n30;
                    ++n10;
                    while (n10 < n16 && lArray[n20 + n10] / (long)n30 == l) {
                        ++n10;
                    }
                    n7 = n10;
                    n6 = 0;
                    n5 = n9;
                    n4 = n12;
                    while (n4 < n11 && n5 < n7) {
                        if ((long)this.msubj[n4] < lArray[n20 + n5] % (long)n30) {
                            ++n4;
                            continue;
                        }
                        if ((long)this.msubj[n4] > lArray[n20 + n5] % (long)n30) {
                            ++n5;
                            continue;
                        }
                        ++n6;
                        n3 = nArray[n19 + n5];
                        n2 = nArray[n19 + n5 + 1];
                        n = n2 - n3;
                        n26 += n;
                        n28 += n17 > 0 ? nArray[n23 + n2] - nArray[n23 + n3] + n * 2 : 0;
                        ++n4;
                        ++n5;
                    }
                    if (n6 <= 0) continue;
                    ++n27;
                }
            }
        }
        n13 = n27 < n29 * this.mdim0 ? 1 : 0;
        workStack.alloc_expr(2, n27, n26, n13 != 0, n28);
        int[] nArray2 = workStack.i32;
        long[] lArray2 = workStack.i64;
        double[] dArray2 = workStack.f64;
        n10 = workStack.ncodeatom;
        n9 = workStack.shape_base;
        int n34 = workStack.ptr_base;
        n8 = n13 != 0 ? workStack.sp_base : -9999;
        n7 = workStack.nidxs_base;
        n6 = workStack.cof_base;
        n5 = workStack.codeptr_base;
        n4 = workStack.code_base;
        n3 = workStack.cconst_base;
        nArray2[n9] = this.mdim0;
        nArray2[n9 + 1] = n29;
        nArray2[n34] = 0;
        if (n10 > 0) {
            nArray2[n5] = 0;
        }
        if (this.msubi == null || this.msubj == null) {
            if (!bl2) {
                int n35;
                int n36;
                int n37;
                int n38;
                int n39;
                int n40;
                int n41;
                int n42;
                int n43;
                int n44;
                int n45;
                n2 = 0;
                n = 0;
                int n46 = 0;
                int n47 = this.mdim0;
                for (n45 = n46; n45 < n47; ++n45) {
                    Tools.arraycopy(lArray, n21, lArray2, n7 + n2, n15);
                    n44 = 0;
                    n43 = 0;
                    n42 = n29;
                    for (n41 = n43; n41 < n42; ++n41) {
                        n40 = 0;
                        n39 = this.mdim1;
                        for (n38 = n40; n38 < n39; ++n38) {
                            n37 = nArray[n19 + n44];
                            n36 = nArray[n19 + n44 + 1];
                            for (n35 = n37; n35 < n36; ++n35) {
                                dArray2[n6 + n2] = this.mval[n45 * this.mdim1 + n38] * dArray[n22 + n35];
                                ++n2;
                            }
                            ++n44;
                        }
                        nArray2[n34 + n + 1] = n2;
                        ++n;
                    }
                }
                if (n10 > 0) {
                    n2 = 0;
                    n = 0;
                    n46 = 0;
                    n47 = this.mdim0;
                    for (n45 = n46; n45 < n47; ++n45) {
                        n44 = 0;
                        n43 = 0;
                        n42 = n29;
                        for (n41 = n43; n41 < n42; ++n41) {
                            n40 = 0;
                            n39 = this.mdim1;
                            for (n38 = n40; n38 < n39; ++n38) {
                                n37 = nArray[n19 + n44];
                                n36 = nArray[n19 + n44 + 1];
                                for (n35 = n37; n35 < n36; ++n35) {
                                    int n48 = nArray[n23 + n35];
                                    int n49 = nArray[n23 + n35 + 1];
                                    for (int i = n48; i < n49; ++i) {
                                        nArray2[n4 + n] = nArray[n24 + i];
                                        dArray2[n3 + n] = dArray[n25 + i];
                                        ++n;
                                    }
                                    nArray2[n4 + n] = 2;
                                    dArray2[n3 + n] = this.mval[n45 * this.mdim1 + n38];
                                    nArray2[n4 + ++n] = 5;
                                    nArray2[n5 + n2 + 1] = ++n;
                                    ++n2;
                                }
                                ++n44;
                            }
                        }
                    }
                }
            } else {
                int n50;
                int n51;
                int n52;
                long l;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                long l2;
                int n58;
                boolean bl4;
                int n59;
                n2 = 0;
                n = 0;
                int n60 = 0;
                int n61 = this.mdim0;
                for (n59 = n60; n59 < n61; ++n59) {
                    Tools.arraycopy(lArray, n21, lArray2, n7 + n2, n15);
                    bl4 = false;
                    n58 = 0;
                    while (n58 < n16 && n58 < n16) {
                        l2 = lArray[n20 + n58] / (long)n30;
                        n57 = n58++;
                        while (n58 < n16 && lArray[n20 + n58] / (long)n30 == l2) {
                            ++n58;
                        }
                        n56 = n58;
                        n55 = n57;
                        n54 = n56;
                        for (n53 = n55; n53 < n54; ++n53) {
                            l = lArray[n20 + n53] % (long)n30;
                            n52 = nArray[n19 + n53];
                            n51 = nArray[n19 + n53 + 1];
                            for (n50 = n52; n50 < n51; ++n50) {
                                dArray2[n6 + n2] = this.mval[(int)((long)(n59 * this.mdim1) + l)] * dArray[n22 + n50];
                                ++n2;
                            }
                        }
                        if (n13 != 0) {
                            lArray2[n8 + n] = (long)(n59 * n29) + l2;
                        }
                        nArray2[n34 + ++n] = n2;
                    }
                }
                if (n10 > 0) {
                    n2 = 0;
                    n = 0;
                    n60 = 0;
                    n61 = this.mdim0;
                    for (n59 = n60; n59 < n61; ++n59) {
                        bl4 = false;
                        n58 = 0;
                        while (n58 < n16 && n58 < n16) {
                            l2 = lArray[n20 + n58] / (long)n30;
                            n57 = n58++;
                            while (n58 < n16 && lArray[n20 + n58] / (long)n30 == l2) {
                                ++n58;
                            }
                            n56 = n58;
                            n55 = n57;
                            n54 = n56;
                            for (n53 = n55; n53 < n54; ++n53) {
                                l = lArray[n20 + n53] % (long)n30;
                                n52 = nArray[n19 + n53];
                                n51 = nArray[n19 + n53 + 1];
                                for (n50 = n52; n50 < n51; ++n50) {
                                    int n62 = nArray[n23 + n50];
                                    int n63 = nArray[n23 + n50 + 1];
                                    for (int i = n62; i < n63; ++i) {
                                        nArray2[n4 + n] = nArray[n24 + i];
                                        dArray2[n3 + n] = dArray[n25 + i];
                                        ++n;
                                    }
                                    nArray2[n4 + n] = 2;
                                    dArray2[n3 + n] = this.mval[(int)((long)(n59 * n29) + l)];
                                    nArray2[n4 + ++n] = 5;
                                    nArray2[n5 + n2 + 1] = ++n;
                                    ++n2;
                                }
                            }
                        }
                    }
                }
            }
        } else if (!bl2) {
            n2 = 0;
            n = 0;
            int n64 = 0;
            int n65 = 0;
            while (n65 < n31 && n65 < n31) {
                int n66 = n65;
                int n67 = this.msubi[n65];
                ++n65;
                while (n65 < n31 && this.msubi[n65] == n67) {
                    ++n65;
                }
                int n68 = n65;
                int n69 = 0;
                int n70 = n29;
                for (int i = n69; i < n70; ++i) {
                    int n71 = n66;
                    int n72 = n68;
                    for (int j = n71; j < n72; ++j) {
                        int n73 = i * n30 + this.msubj[j];
                        int n74 = nArray[n19 + n73];
                        int n75 = nArray[n19 + n73 + 1];
                        for (int k = n74; k < n75; ++k) {
                            lArray2[n7 + n2] = lArray[n21 + k];
                            dArray2[n6 + n2] = dArray[n22 + k] * this.mval[j];
                            if (n10 > 0) {
                                int n76 = nArray[n23 + k];
                                int n77 = nArray[n23 + k + 1];
                                for (int i2 = n76; i2 < n77; ++i2) {
                                    nArray2[n4 + n64] = nArray[n24 + i2];
                                    dArray2[n3 + n64] = dArray[n25 + i2];
                                    ++n64;
                                }
                                nArray2[n4 + n64] = 2;
                                dArray2[n3 + n64] = this.mval[j];
                                nArray2[n4 + ++n64] = 5;
                                nArray2[n5 + n2 + 1] = ++n64;
                            }
                            ++n2;
                        }
                    }
                    nArray2[n34 + n + 1] = n2;
                    if (n13 != 0) {
                        lArray2[n8 + n] = n67 * n29 + i;
                    }
                    ++n;
                }
            }
            if (n2 != n26) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of nonzeros");
            }
            if (n != n27) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of elements");
            }
            if (n64 != n10) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of code elements");
            }
        } else {
            int n78;
            int n79;
            int n80;
            int n81;
            int n82;
            int n83;
            int n84;
            long l;
            int n85;
            int n86;
            int n87;
            int n88;
            int n89;
            n2 = 0;
            n = 0;
            int n90 = 0;
            while (n90 < n31 && n90 < n31) {
                n89 = n90;
                n88 = this.msubi[n90];
                ++n90;
                while (n90 < n31 && this.msubi[n90] == n88) {
                    ++n90;
                }
                n87 = n90;
                n86 = 0;
                while (n86 < n16 && n86 < n16) {
                    n85 = n86;
                    l = lArray[n20 + n86] / (long)n30;
                    ++n86;
                    while (n86 < n16 && lArray[n20 + n86] / (long)n30 == l) {
                        ++n86;
                    }
                    n84 = n86;
                    n83 = 0;
                    n82 = n85;
                    n81 = n89;
                    while (n81 < n87 && n82 < n84) {
                        if ((long)this.msubj[n81] < lArray[n20 + n82] % (long)n30) {
                            ++n81;
                            continue;
                        }
                        if ((long)this.msubj[n81] > lArray[n20 + n82] % (long)n30) {
                            ++n82;
                            continue;
                        }
                        ++n83;
                        n80 = nArray[n19 + n82];
                        n79 = nArray[n19 + n82 + 1];
                        for (n78 = n80; n78 < n79; ++n78) {
                            lArray2[n7 + n2] = lArray[n21 + n78];
                            dArray2[n6 + n2] = dArray[n22 + n78] * this.mval[n81];
                            ++n2;
                        }
                        ++n81;
                        ++n82;
                    }
                    if (n83 <= 0) continue;
                    nArray2[n34 + n + 1] = n2;
                    if (n13 != 0) {
                        lArray2[n8 + n] = (long)(n88 * n29) + l;
                    }
                    ++n;
                }
            }
            if (n2 != n26) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of nonzeros");
            }
            if (n != n27) {
                throw new UnexpectedError("Error in evaluation: Incorrect number of elements");
            }
            if (n10 > 0) {
                n2 = 0;
                n = 0;
                n90 = 0;
                while (n90 < n31 && n90 < n31) {
                    n89 = n90;
                    n88 = this.msubi[n90];
                    ++n90;
                    while (n90 < n31 && this.msubi[n90] == n88) {
                        ++n90;
                    }
                    n87 = n90;
                    n86 = 0;
                    while (n86 < n16 && n86 < n16) {
                        n85 = n86;
                        l = lArray[n20 + n86] / (long)n30;
                        ++n86;
                        while (n86 < n16 && lArray[n20 + n86] / (long)n30 == l) {
                            ++n86;
                        }
                        n84 = n86;
                        n83 = 0;
                        n82 = n85;
                        n81 = n89;
                        while (n81 < n87 && n82 < n84) {
                            if ((long)this.msubj[n81] < lArray[n20 + n82] % (long)n30) {
                                ++n81;
                                continue;
                            }
                            if ((long)this.msubj[n81] > lArray[n20 + n82] % (long)n30) {
                                ++n82;
                                continue;
                            }
                            ++n83;
                            n80 = nArray[n19 + n82];
                            n79 = nArray[n19 + n82 + 1];
                            for (n78 = n80; n78 < n79; ++n78) {
                                int n91 = nArray[n23 + n78];
                                int n92 = nArray[n23 + n78 + 1];
                                for (int i = n91; i < n92; ++i) {
                                    nArray2[n4 + n] = nArray[n24 + i];
                                    dArray2[n3 + n] = dArray[n25 + i];
                                    ++n;
                                }
                                nArray2[n4 + n] = 2;
                                dArray2[n3 + n] = this.mval[n81];
                                nArray2[n4 + ++n] = 5;
                                nArray2[n5 + n2 + 1] = ++n;
                                ++n2;
                            }
                            ++n81;
                            ++n82;
                        }
                    }
                }
                if (n != n10) {
                    throw new UnexpectedError("Error in evaluation: Incorrect number of code elements");
                }
            }
        }
    }

    private static int[] computeshape(int n, int n2, int[] nArray) {
        if (nArray.length != 2) {
            throw new DimensionError("Mismatching dimensions");
        }
        if (n2 != nArray[1]) {
            throw new DimensionError("Mismatching dimensions");
        }
        return new int[]{n, nArray[0]};
    }

    private static int validate(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        if (expression.getND() != 2) {
            throw new DimensionError("Invalid operand dimensions");
        }
        int n3 = expression.getDim(0);
        int n4 = expression.getDim(1);
        if (n < 0 || n2 < 0) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (n2 != n4) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (nArray != null && nArray2 != null ? nArray.length != nArray2.length || nArray.length != dArray.length : dArray.length != n * n2) {
            throw new LengthError("Invalid matrix data");
        }
        int n5 = dArray.length;
        boolean bl = false;
        boolean bl2 = false;
        if (nArray != null && nArray2 != null) {
            int n6;
            int n7 = 0;
            int n8 = n5;
            for (n6 = n7; n6 < n8; ++n6) {
                bl = bl || nArray[n6] < 0 || nArray[n6] >= n || nArray2[n6] < 0 || nArray2[n6] >= n2;
            }
            if (!bl) {
                n7 = 0;
                n8 = n5 - 1;
                for (n6 = n7; n6 < n8; ++n6) {
                    bl2 = bl2 || nArray[n6] > nArray[n6 + 1] || nArray[n6] == nArray[n6 + 1] && nArray2[n6] >= nArray2[n6 + 1];
                }
            }
        }
        if (bl) {
            throw new LengthError("Invalid matrix data");
        }
        if (bl2) {
            throw new LengthError("Unsorted matrix data");
        }
        return 1;
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprCrossDot(M(").a(this.mdim0).a(",").a(this.mdim1).a("),").a(this.expr.toString()).a(")").toString();
    }
}

