/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.RelationKey;

public class LinearDomain {
    protected long nelements;
    protected long domsize;
    protected String[][] indexnames;
    protected boolean empty;
    protected boolean scalable;
    protected int[][] sparsity;
    protected boolean cardinal_flag;
    protected RelationKey key;
    protected double[] bnd;
    protected int[] shape;

    protected LinearDomain(RelationKey relationKey, boolean bl, double[] dArray, int[] nArray) {
        this(relationKey, bl, dArray, nArray, null, 1);
    }

    protected LinearDomain(RelationKey relationKey, boolean bl, double[] dArray, int[] nArray, int[][] nArray2, int n) {
        this.scalable = bl;
        this.shape = nArray;
        this.key = relationKey;
        this.bnd = dArray;
        this.sparsity = nArray2;
        this.cardinal_flag = false;
        this.empty = false;
        this.indexnames = null;
        this.domsize = 0L;
        this.nelements = 0L;
    }

    protected LinearDomain(LinearDomain linearDomain) {
        this.scalable = linearDomain.scalable;
        this.nelements = linearDomain.nelements;
        this.domsize = linearDomain.domsize;
        this.shape = linearDomain.shape;
        this.key = linearDomain.key;
        this.bnd = linearDomain.bnd;
        this.sparsity = linearDomain.sparsity;
        this.cardinal_flag = linearDomain.cardinal_flag;
        this.empty = linearDomain.empty;
        this.indexnames = linearDomain.indexnames;
    }

    public LinearDomain sparse(int[][] nArray) {
        this.sparsity = new int[nArray.length][nArray[0].length];
        this.empty = false;
        for (int i = 0; i < nArray.length && i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length && j < nArray[0].length; ++j) {
                this.sparsity[i][j] = nArray[i][j];
            }
        }
        return this;
    }

    public LinearDomain sparse(int[] nArray) {
        this.sparsity = new int[nArray.length][1];
        this.empty = false;
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.sparsity[i][0] = nArray[i];
        }
        return this;
    }

    public LinearDomain sparse() {
        this.empty = true;
        this.sparsity = null;
        return this;
    }

    public LinearDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    public LinearDomain withShape(int n, int n2, int n3) {
        this.shape = new int[]{n, n2, n3};
        return this;
    }

    public LinearDomain withShape(int n, int n2) {
        this.shape = new int[]{n, n2};
        return this;
    }

    public LinearDomain withShape(int n) {
        this.shape = new int[]{n};
        return this;
    }

    public LinearDomain withShape(int[] nArray) {
        this.shape = nArray;
        return this;
    }

    public LinearDomain withNamesOnAxis(String[] stringArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[][] stringArrayArray;
        int n7;
        int n8;
        int n9;
        int n10;
        if (this.indexnames == null) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            this.indexnames = stringArrayArray;
            n5 = 0;
            n4 = 0;
            n3 = stringArray.length;
            n2 = n4 < n3 ? n3 - n4 : 0;
            String[] stringArray2 = new String[n2];
            int n11 = n4;
            int n12 = 0;
            while (n12 < n2) {
                stringArray2[n5] = stringArray[n11];
                ++n5;
                ++n12;
                ++n11;
            }
            this.indexnames[n] = stringArray2;
        }
        if (this.indexnames.length < n + 1) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            String[][] stringArrayArray2 = stringArrayArray;
            n4 = 0;
            n3 = this.indexnames.length;
            for (n2 = n4; n2 < n3; ++n2) {
                stringArrayArray2[n2] = this.indexnames[n2];
            }
            this.indexnames = stringArrayArray2;
        }
        n10 = 0;
        n9 = 0;
        n8 = stringArray.length;
        n7 = n9 < n8 ? n8 - n9 : 0;
        stringArrayArray = new String[n7];
        n6 = n9;
        int n13 = 0;
        while (n13 < n7) {
            stringArrayArray[n10] = stringArray[n6];
            ++n10;
            ++n13;
            ++n6;
        }
        this.indexnames[n] = stringArrayArray;
        return this;
    }

    protected boolean match_shape(int[] nArray) {
        if (!this.scalable) {
            int n = 0;
            int n2 = nArray.length;
            for (int i = n; i < n2; ++i) {
                if (nArray[i] != this.shape[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void finalize_and_validate_inplace(int[] nArray) {
        int n;
        int n2;
        int n3;
        if (this.scalable) {
            if (this.shape == null) {
                if (this.sparsity != null && nArray == null) {
                    throw new DimensionError("Sparse domain requires a fixed shape");
                }
                this.shape = nArray != null ? nArray : new int[0];
            }
        } else if (nArray != null) {
            if (nArray.length != this.shape.length) {
                throw new DimensionError("Conflicting shape definitions");
            }
            n3 = 0;
            n2 = nArray.length;
            for (n = n3; n < n2; ++n) {
                if (nArray[n] == this.shape[n]) continue;
                throw new DimensionError("Conflicting shape definitions");
            }
        }
        if (this.indexnames != null) {
            if (this.indexnames.length > this.shape.length) {
                throw new DimensionError("Index names do not match shape");
            }
            n3 = 0;
            n2 = this.indexnames.length;
            for (n = n3; n < n2; ++n) {
                if (this.indexnames[n] == null || this.indexnames[n].length == this.shape[n]) continue;
                throw new DimensionError("Index names do not match shape");
            }
            if (this.indexnames.length < this.shape.length) {
                String[][] stringArrayArray = new String[this.shape.length][];
                n2 = 0;
                n = this.indexnames.length;
                for (int i = n2; i < n; ++i) {
                    stringArrayArray[i] = this.indexnames[i];
                }
                this.indexnames = stringArrayArray;
            }
        }
        this.domsize = 1L;
        int n4 = 0;
        n2 = this.shape.length;
        for (n = n4; n < n2; ++n) {
            this.domsize *= (long)this.shape[n];
        }
        if (this.sparsity != null) {
            this.nelements = this.sparsity.length;
            if (this.shape.length != this.sparsity[0].length) {
                throw new DimensionError("Mismatching shape and sparsity pattern");
            }
            n4 = 0;
            long l = this.nelements;
            for (long i = (long)n4; i < l; ++i) {
                int n5 = 0;
                int n6 = this.sparsity[0].length;
                for (int j = n5; j < n6; ++j) {
                    if (this.sparsity[(int)i][j] >= 0 && this.sparsity[(int)i][j] < this.shape[j]) continue;
                    throw new DimensionError("Sparsity pattern entry is out of bounds");
                }
            }
            if (!this.scalable && this.bnd != null && (long)this.bnd.length != this.nelements) {
                throw new DimensionError("Sparsity pattern does not match bound");
            }
        } else {
            this.nelements = this.domsize;
            if (this.bnd != null && !this.scalable && (long)this.bnd.length != this.nelements) {
                throw new DimensionError("Domain bound does not match shape");
            }
        }
    }

    protected LinearDomain finalize_and_validate(int[] nArray) {
        LinearDomain linearDomain = new LinearDomain(this);
        linearDomain.finalize_and_validate_inplace(nArray);
        return linearDomain;
    }
}

