/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;
import mosek.fusion.WorkStack;

public class ExprMulScalarVar
extends BaseExpression {
    private Variable x;
    private double[] mcof;
    private int[] msubj;
    private int[] msubi;
    private int mdimj;
    private int mdimi;

    public ExprMulScalarVar(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Variable variable) {
        this(n, n2, Tools.arraycopy(nArray), Tools.arraycopy(nArray2), Tools.arraycopy(dArray), variable, 1);
        int n3;
        if (variable.getND() != 0) {
            throw new DimensionError("Invalid Variable size");
        }
        if (n < 0 || n2 < 0 || nArray.length != nArray2.length || nArray.length != dArray.length) {
            throw new LengthError("Invalid Matrix data");
        }
        boolean bl = false;
        int n4 = 0;
        int n5 = nArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            if (nArray[n3] >= 0 && nArray[n3] < n && nArray2[n3] >= 0 && nArray2[n3] < n2) continue;
            bl = true;
        }
        if (bl) {
            throw new IndexError("Invalid Matrix data");
        }
        n4 = 0;
        n5 = 1;
        n3 = nArray.length;
        for (int i = n5; i < n3; ++i) {
            if (nArray[i] >= nArray[i - 1] && (nArray[i] != nArray[i - 1] || nArray2[i] > nArray2[i - 1])) continue;
            n4 = 1;
        }
        if (n4 != 0) {
            throw new IndexError("Matrix data not correctly sorted");
        }
    }

    protected ExprMulScalarVar(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Variable variable, int n3) {
        super(variable.getModel(), new int[]{n, n2});
        this.mdimi = n;
        this.mdimj = n2;
        this.msubi = nArray;
        this.msubj = nArray2;
        this.mcof = dArray;
        this.x = variable;
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        if (this.x.numInst() == 0) {
            workStack.alloc_expr(2, 0, 0, false);
            workStack.i32[workStack.shape_base] = this.mdimi;
            workStack.i32[workStack.shape_base + 1] = this.mdimj;
        } else {
            int n;
            int n2;
            long[] lArray = new long[1];
            this.x.inst(0, lArray);
            long l = lArray[0];
            int n3 = n2 = this.msubi.length;
            boolean bl2 = n2 < this.mdimi * this.mdimj;
            workStack.alloc_expr(2, n2, n3, bl2);
            int n4 = workStack.ptr_base;
            workStack.i32[workStack.shape_base] = this.mdimi;
            workStack.i32[workStack.shape_base + 1] = this.mdimj;
            int n5 = workStack.nidxs_base;
            int n6 = workStack.sp_base;
            int n7 = workStack.cof_base;
            int[] nArray = workStack.i32;
            long[] lArray2 = workStack.i64;
            double[] dArray = workStack.f64;
            int n8 = 0;
            int n9 = n3;
            for (n = n8; n < n9; ++n) {
                dArray[n7 + n] = this.mcof[n];
            }
            n8 = 0;
            n9 = n3;
            for (n = n8; n < n9; ++n) {
                lArray2[n5 + n] = l;
            }
            if (bl2) {
                n8 = 0;
                n9 = n2;
                for (n = n8; n < n9; ++n) {
                    lArray2[n6 + n] = this.msubi[n] * this.mdimj + this.msubj[n];
                }
            }
            n8 = 0;
            n9 = n2 + 1;
            for (n = n8; n < n9; ++n) {
                nArray[n4 + n] = n;
            }
        }
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprMulScalarVar(M(").a(this.mdimi).a(",").a(this.mdimj).a("), ").a(this.x.toString()).a(")").toString();
    }
}

