/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BoundInterfaceVariable;
import mosek.fusion.Model;
import mosek.fusion.ModelVariable;
import mosek.fusion.SolutionError;
import mosek.fusion.Utils.StringBuffer;

public class RangedVariable
extends ModelVariable {
    private int[] shape;
    private String name;
    private int[] nativeidxs;
    private long[] sparsity;

    private RangedVariable(RangedVariable rangedVariable, Model model) {
        super(rangedVariable, model);
        this.name = rangedVariable.name;
        this.nativeidxs = rangedVariable.nativeidxs;
        this.sparsity = rangedVariable.sparsity;
        this.shape = rangedVariable.shape;
    }

    protected RangedVariable(Model model, String string, long l, int[] nArray, long[] lArray, int[] nArray2) {
        super(model, string, nArray, l, lArray, RangedVariable.globalNativeIndexes(nArray2));
        this.nativeidxs = nArray2;
        this.sparsity = lArray;
        this.name = string;
        this.shape = nArray;
    }

    public StringBuffer elementDesc(long l, StringBuffer stringBuffer) {
        this.elementName(l, stringBuffer);
        stringBuffer.a(" : in range");
        return stringBuffer;
    }

    protected void dual_u(int n, double[] dArray) throws SolutionError {
        this.dual_lu(n, dArray, false);
    }

    protected void dual_l(int n, double[] dArray) throws SolutionError {
        this.dual_lu(n, dArray, true);
    }

    public BoundInterfaceVariable upperBoundVar() {
        int n = 0;
        int n2 = 0;
        int n3 = this.nativeidxs.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = this.nativeidxs[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new BoundInterfaceVariable(this.getModel(), this.shape, this.sparsity, lArray, false);
    }

    public BoundInterfaceVariable lowerBoundVar() {
        int n = 0;
        int n2 = 0;
        int n3 = this.nativeidxs.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        long[] lArray = new long[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            lArray[n] = this.nativeidxs[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new BoundInterfaceVariable(this.getModel(), this.shape, this.sparsity, lArray, true);
    }

    @Override
    protected ModelVariable clone(Model model) {
        return new RangedVariable(this, model);
    }

    private static long[] globalNativeIndexes(int[] nArray) {
        long[] lArray = new long[nArray.length];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }
}

