/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.DimensionError;
import mosek.fusion.ExprParameter;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Model;
import mosek.fusion.Parameter;
import mosek.fusion.Set;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public class ParameterImpl
implements Parameter {
    private long size;
    private int[] nidxs;
    private long[] sp;
    private int[] shape;
    private Model model;

    protected ParameterImpl(ParameterImpl parameterImpl, Model model) {
        this.model = model;
        this.shape = parameterImpl.shape;
        this.sp = parameterImpl.sp;
        this.size = parameterImpl.size;
        this.nidxs = parameterImpl.nidxs;
    }

    protected ParameterImpl(Model model, int[] nArray, long[] lArray, int[] nArray2) {
        this.model = model;
        this.shape = Tools.arraycopy(nArray);
        this.sp = lArray;
        this.size = Set.size(nArray);
        this.nidxs = Tools.arraycopy(nArray2);
    }

    @Override
    public Parameter clone(Model model) {
        return new ParameterImpl(this, model);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().a("Parameter((");
        if (this.shape.length > 0) {
            stringBuffer.a(this.shape[0]);
            int n = 1;
            int n2 = this.shape.length;
            for (int i = n; i < n2; ++i) {
                stringBuffer.a(",").a(this.shape[i]);
            }
        }
        stringBuffer.a(")");
        if (this.sp != null) {
            stringBuffer.a(",sparse");
        }
        stringBuffer.a(")");
        return stringBuffer.toString();
    }

    @Override
    public Parameter pick(int[][] nArray) {
        int[] nArray2;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.shape.length != nArray[0].length) {
            throw new IndexError("Invalid index");
        }
        boolean bl = false;
        int n5 = 0;
        int n6 = nArray.length;
        for (n4 = n5; n4 < n6; ++n4) {
            n3 = 0;
            n2 = nArray[0].length;
            for (n = n3; n < n2; ++n) {
                if (nArray[n4][n] >= 0 && nArray[n4][n] < this.shape[n]) continue;
                bl = true;
            }
        }
        if (bl) {
            throw new IndexError("Invalid index");
        }
        n5 = this.shape.length;
        long[] lArray = new long[n5];
        lArray[n5 - 1] = 1L;
        n4 = 1;
        n3 = n5;
        for (n2 = n4; n2 < n3; ++n2) {
            lArray[n5 - n2 - 1] = lArray[n5 - n2] * (long)this.shape[n5 - n2];
        }
        int[] nArray3 = new int[]{nArray.length};
        long[] lArray2 = null;
        if (this.sp == null) {
            nArray2 = new int[nArray.length];
            n = 0;
            int n7 = nArray.length;
            for (int i = n; i < n7; ++i) {
                long l = 0L;
                int n8 = 0;
                int n9 = n5;
                for (int j = n8; j < n9; ++j) {
                    l += lArray[j] * (long)nArray[i][j];
                }
                nArray2[i] = this.nidxs[(int)l];
            }
        } else {
            int n10;
            int n11;
            int n12;
            n = 0;
            int n13 = 0;
            int n14 = nArray.length;
            for (n12 = n13; n12 < n14; ++n12) {
                long l = 0L;
                int n15 = 0;
                n11 = n5;
                for (n10 = n15; n10 < n11; ++n10) {
                    l += lArray[n10] * (long)nArray[n12][n10];
                }
                if (CommonTools.binarySearch(this.sp, l) < 0) continue;
                ++n;
            }
            nArray2 = new int[n];
            lArray2 = new long[n];
            n13 = 0;
            n14 = 0;
            n12 = nArray.length;
            for (int i = n14; i < n12; ++i) {
                long l = 0L;
                n11 = 0;
                n10 = n5;
                for (int j = n11; j < n10; ++j) {
                    l += lArray[j] * (long)nArray[i][j];
                }
                n11 = CommonTools.binarySearch(this.sp, l);
                if (n11 < 0) continue;
                nArray2[n13] = this.nidxs[n11];
                lArray2[n13] = i;
                ++n13;
            }
            if (n == nArray.length) {
                lArray2 = null;
            }
        }
        return new ParameterImpl(this.model, nArray3, lArray2, nArray2);
    }

    @Override
    public Parameter pick(int[] nArray) {
        int[] nArray2;
        int n;
        if (this.shape.length != 1) {
            throw new IndexError("Invalid index");
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = nArray.length;
        for (n = n2; n < n3; ++n) {
            if (nArray[n] >= 0 && nArray[n] < this.shape[0]) continue;
            bl = true;
        }
        if (bl) {
            throw new IndexError("Invalid index");
        }
        long[] lArray = null;
        if (this.sp == null) {
            n = 0;
            int n4 = 0;
            int n5 = nArray.length;
            int n6 = n4 < n5 ? n5 - n4 : 0;
            int[] nArray3 = new int[n6];
            int n7 = n4;
            int n8 = 0;
            while (n8 < n6) {
                nArray3[n] = this.nidxs[nArray[n7]];
                ++n;
                ++n8;
                ++n7;
            }
            nArray2 = nArray3;
        } else {
            int n9;
            n = 0;
            int n10 = 0;
            int n11 = nArray.length;
            for (n9 = n10; n9 < n11; ++n9) {
                if (CommonTools.binarySearch(this.sp, (long)nArray[n9]) < 0) continue;
                ++n;
            }
            nArray2 = new int[n];
            lArray = new long[n];
            n10 = 0;
            n11 = 0;
            n9 = nArray.length;
            for (int i = n11; i < n9; ++i) {
                int n12 = CommonTools.binarySearch(this.sp, (long)nArray[i]);
                if (n12 < 0) continue;
                lArray[n10] = i;
                nArray2[n10] = this.nidxs[n12];
                ++n10;
            }
            if (n == nArray.length) {
                lArray = null;
            }
        }
        return new ParameterImpl(this.model, new int[]{nArray.length}, lArray, nArray2);
    }

    @Override
    public Expression index(int[] nArray) {
        if (this.shape.length != nArray.length) {
            throw new DimensionError("Index has incorrect dimension");
        }
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] >= 0 && nArray[i] < this.shape[i]) continue;
            throw new IndexError("Index out of bounds");
        }
        if (this.sp == null) {
            n = nArray.length;
            long l = nArray[n - 1];
            int n3 = 1;
            int n4 = n;
            for (int i = n3; i < n4; ++i) {
                l = l * (long)this.shape[n - i] + (long)nArray[n - i - 1];
            }
            return new ParameterImpl(this.model, new int[0], null, new int[]{this.nidxs[(int)l]});
        }
        n = nArray.length;
        long l = nArray[n - 1];
        int n5 = 1;
        int n6 = n;
        for (int i = n5; i < n6; ++i) {
            l = l * (long)this.shape[n - i] + (long)nArray[n - i - 1];
        }
        for (n5 = 0; n5 < this.sp.length && this.sp[n5] < l; ++n5) {
        }
        if (n5 < this.sp.length && this.sp[n5] == l) {
            return new ParameterImpl(this.model, new int[0], null, new int[]{this.nidxs[n5]});
        }
        return new ParameterImpl(this.model, new int[0], new long[0], new int[0]);
    }

    @Override
    public Expression index(int n) {
        int n2;
        if (this.shape.length != 1) {
            throw new DimensionError("Index has incorrect dimension");
        }
        if (n < 0 || n >= this.shape[0]) {
            throw new IndexError("Index out of bounds");
        }
        if (this.sp == null) {
            return new ParameterImpl(this.model, new int[0], null, new int[]{this.nidxs[n]});
        }
        for (n2 = 0; n2 < this.sp.length && this.sp[n2] < (long)n; ++n2) {
        }
        if (n2 < this.sp.length && this.sp[n2] == (long)n) {
            return new ParameterImpl(this.model, new int[0], null, new int[]{this.nidxs[n2]});
        }
        return new ParameterImpl(this.model, new int[0], new long[0], new int[0]);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2 = this.shape.length;
        int n3 = this.nidxs.length;
        boolean bl2 = this.sp != null;
        workStack.alloc_expr(n2, n3, this.nidxs.length, bl2, this.nidxs.length);
        int[] nArray = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n4 = workStack.ptr_base;
        int n5 = workStack.nidxs_base;
        int n6 = workStack.cof_base;
        int n7 = workStack.shape_base;
        int n8 = workStack.codeptr_base;
        int n9 = workStack.code_base;
        int n10 = workStack.cconst_base;
        int n11 = workStack.sp_base;
        nArray[n4] = 0;
        int n12 = 0;
        int n13 = n2;
        for (n = n12; n < n13; ++n) {
            nArray[n7 + n] = this.shape[n];
        }
        n12 = 0;
        n13 = n3;
        for (n = n12; n < n13; ++n) {
            lArray[n5 + n] = 0L;
        }
        n12 = 0;
        n13 = n3;
        for (n = n12; n < n13; ++n) {
            dArray[n6 + n] = 0.0;
        }
        n12 = 0;
        n13 = n3 + 1;
        for (n = n12; n < n13; ++n) {
            nArray[n4 + n] = n;
        }
        if (n3 > 0) {
            n12 = 0;
            n13 = n3 + 1;
            for (n = n12; n < n13; ++n) {
                nArray[n8 + n] = n;
            }
        }
        if (bl2) {
            n12 = 0;
            n13 = n3;
            for (n = n12; n < n13; ++n) {
                lArray[n11 + n] = this.sp[n];
            }
        }
        n12 = 0;
        n13 = n3;
        for (n = n12; n < n13; ++n) {
            nArray[n9 + n] = 1;
            dArray[n10 + n] = this.nidxs[n];
        }
    }

    @Override
    public boolean compress_when_caching() {
        return false;
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        this.recursive_eval(workStack, workStack2, workStack3, false);
    }

    @Override
    public void recursive_eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        this.eval(workStack, workStack2, workStack3, bl);
    }

    @Override
    public void getSp(long[] lArray, int n) {
        if (this.sp != null) {
            int n2 = 0;
            int n3 = this.sp.length;
            for (int i = n2; i < n3; ++i) {
                lArray[i + n] = this.sp[i];
            }
        } else {
            int n4 = 0;
            int n5 = this.nidxs.length;
            for (int i = n4; i < n5; ++i) {
                lArray[i + n] = i;
            }
        }
    }

    @Override
    public boolean isSparse() {
        return this.sp != null;
    }

    @Override
    public Parameter slice(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (nArray.length != nArray2.length || nArray.length != this.shape.length) {
            throw new DimensionError("Invalid index dimension");
        }
        int n7 = nArray.length;
        int n8 = 0;
        int n9 = n7;
        for (n6 = n8; n6 < n9; ++n6) {
            if (nArray[n6] >= 0 && nArray[n6] < nArray2[n6] && nArray2[n6] <= this.shape[n6]) continue;
            throw new IndexError("Invalid index");
        }
        long[] lArray = new long[n7];
        lArray[n7 - 1] = 1L;
        n9 = 1;
        n6 = n7;
        for (n5 = n9; n5 < n6; ++n5) {
            lArray[n7 - n5 - 1] = lArray[n7 - n5] * (long)this.shape[n5];
        }
        int[] nArray3 = new int[n7];
        n6 = 0;
        n5 = 0;
        int n10 = n7;
        int n11 = n5 < n10 ? n10 - n5 : 0;
        int[] nArray4 = new int[n11];
        int n12 = n5;
        int n13 = 0;
        while (n13 < n11) {
            nArray4[n6] = nArray2[n12] - nArray[n12];
            ++n6;
            ++n13;
            ++n12;
        }
        int[] nArray5 = nArray4;
        if (this.sp == null) {
            int n14;
            int n15 = 1;
            int n16 = 0;
            int n17 = n7;
            for (n14 = n16; n14 < n17; ++n14) {
                n15 *= nArray5[n14];
            }
            int[] nArray6 = new int[n15];
            n17 = 0;
            n14 = 0;
            int n18 = this.nidxs.length;
            for (int i = n14; i < n18; ++i) {
                int n19;
                int n20 = 0;
                int n21 = n7;
                for (n19 = n20; n19 < n21; ++n19) {
                    nArray3[n19] = (int)((long)i / lArray[n19] % (long)this.shape[n19]);
                }
                n20 = 1;
                n21 = 0;
                n19 = n7;
                for (int j = n21; j < n19; ++j) {
                    n20 = n20 != 0 && nArray[j] <= nArray3[j] && nArray3[j] < nArray2[j] ? 1 : 0;
                }
                if (n20 == 0) continue;
                nArray6[n17] = this.nidxs[i];
                ++n17;
            }
            return new ParameterImpl(this.model, nArray5, null, nArray6);
        }
        int n22 = 0;
        int n23 = 0;
        int n24 = this.nidxs.length;
        for (int i = n23; i < n24; ++i) {
            n4 = 0;
            n3 = n7;
            for (n2 = n4; n2 < n3; ++n2) {
                nArray3[n2] = (int)(this.sp[i] / lArray[n2] % (long)this.shape[n2]);
            }
            n4 = 1;
            n3 = 0;
            n2 = n7;
            for (n = n3; n < n2; ++n) {
                n4 = n4 != 0 && nArray[n] <= nArray3[n] && nArray3[n] < nArray2[n] ? 1 : 0;
            }
            if (n4 == 0) continue;
            ++n22;
        }
        int[] nArray7 = new int[n22];
        long[] lArray2 = new long[n22];
        long[] lArray3 = new long[n7];
        lArray3[n7 - 1] = 1L;
        n4 = 1;
        n3 = n7;
        for (n2 = n4; n2 < n3; ++n2) {
            lArray3[n7 - n2 - 1] = lArray3[n7 - n2] * (long)nArray5[n2];
        }
        n4 = 0;
        n3 = 0;
        n2 = this.nidxs.length;
        for (n = n3; n < n2; ++n) {
            int n25;
            int n26;
            int n27 = 0;
            int n28 = n7;
            for (n26 = n27; n26 < n28; ++n26) {
                nArray3[n] = (int)(this.sp[n] / lArray[n26] % (long)this.shape[n26]);
            }
            n27 = 1;
            n28 = 0;
            n26 = n7;
            for (n25 = n28; n25 < n26; ++n25) {
                n27 = n27 != 0 && nArray[n25] <= nArray3[n25] && nArray3[n25] < nArray2[n25] ? 1 : 0;
            }
            if (n27 == 0) continue;
            long l = 0L;
            n25 = 0;
            int n29 = n7;
            for (int i = n25; i < n29; ++i) {
                l += (long)(nArray3[i] - nArray[i]) * lArray3[i];
            }
            lArray2[n4] = l;
            nArray7[n4] = this.nidxs[n];
            ++n4;
        }
        return new ParameterImpl(this.model, nArray5, lArray2, nArray7);
    }

    @Override
    public Parameter transpose() {
        if (this.shape.length == 0) {
            return this;
        }
        if (this.shape.length == 1) {
            return new ParameterImpl(this.model, new int[]{1, this.shape[0]}, this.sp, this.nidxs);
        }
        if (this.shape.length == 2) {
            int n = this.shape[0];
            int n2 = this.shape[1];
            int[] nArray = new int[]{n2, n};
            if (this.sp != null) {
                int n3;
                int[] nArray2 = new int[this.nidxs.length];
                long[] lArray = new long[this.sp.length];
                int[] nArray3 = new int[n2 + 1];
                int n4 = 0;
                int n5 = this.sp.length;
                for (n3 = n4; n3 < n5; ++n3) {
                    int n6 = (int)(1L + this.sp[n3] % (long)n2);
                    nArray3[n6] = nArray3[n6] + 1;
                }
                n4 = 0;
                n5 = n2;
                for (n3 = n4; n3 < n5; ++n3) {
                    int n7 = n3 + 1;
                    nArray3[n7] = nArray3[n7] + nArray3[n3];
                }
                n4 = 0;
                n5 = this.sp.length;
                for (n3 = n4; n3 < n5; ++n3) {
                    long l = this.sp[n3] / (long)n2;
                    long l2 = this.sp[n3] % (long)n2;
                    nArray2[nArray3[(int)l2]] = this.nidxs[n3];
                    lArray[nArray3[(int)l2]] = l2 * (long)n + l;
                    int n8 = (int)l2;
                    nArray3[n8] = nArray3[n8] + 1;
                }
                return new ParameterImpl(this.model, nArray, lArray, nArray2);
            }
            int n9 = 0;
            int n10 = 0;
            int n11 = n2;
            int n12 = n10 < n11 ? n11 - n10 : 0;
            int n13 = 0;
            int n14 = n2;
            int n15 = n13 < n14 ? n14 - n13 : 0;
            int[] nArray4 = new int[n12 * n15];
            int n16 = n10;
            int n17 = 0;
            while (n17 < n12) {
                int n18 = n13;
                int n19 = 0;
                while (n19 < n15) {
                    nArray4[n9] = this.nidxs[n18 * n2 + n16];
                    ++n9;
                    ++n19;
                    ++n18;
                }
                ++n17;
                ++n16;
            }
            int[] nArray5 = nArray4;
            return new ParameterImpl(this.model, nArray, null, nArray5);
        }
        throw new DimensionError("Invalid shape for transpose");
    }

    @Override
    public Parameter slice(int n, int n2) {
        int n3;
        if (this.shape.length != 1) {
            throw new DimensionError("Invalid index dimension");
        }
        if (n < 0 || n >= n2 || (long)n2 > this.size) {
            throw new IndexError("Invalid index");
        }
        if (this.sp == null) {
            int n4 = 0;
            int n5 = n;
            int n6 = n2;
            int n7 = n5 < n6 ? n6 - n5 : 0;
            int[] nArray = new int[n7];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n7) {
                nArray[n4] = this.nidxs[n8];
                ++n4;
                ++n9;
                ++n8;
            }
            return new ParameterImpl(this.model, new int[]{n2 - n}, null, nArray);
        }
        int n10 = 0;
        int n11 = 0;
        int n12 = this.sp.length;
        for (n3 = n11; n3 < n12; ++n3) {
            if ((long)n > this.sp[n3] || this.sp[n3] >= (long)n2) continue;
            ++n10;
        }
        int[] nArray = new int[n10];
        long[] lArray = new long[n10];
        n3 = 0;
        int n13 = 0;
        int n14 = this.sp.length;
        for (int i = n13; i < n14; ++i) {
            if ((long)n > this.sp[i] || this.sp[i] >= (long)n2) continue;
            nArray[n3] = this.nidxs[i];
            lArray[n3] = this.sp[n3] - (long)n;
            ++n3;
        }
        return new ParameterImpl(this.model, new int[]{n2 - n}, lArray, nArray);
    }

    @Override
    public Parameter reshape(int[] nArray) {
        if (Set.size(nArray) != Set.size(this.shape)) {
            throw new DimensionError("Incompatible shape for resize");
        }
        return new ParameterImpl(this.model, nArray, this.sp, this.nidxs);
    }

    @Override
    public Expression asExpr() {
        return new ExprParameter(this);
    }

    @Override
    public long getSize() {
        return Set.size(this.shape);
    }

    @Override
    public int getNumNonzero() {
        return this.nidxs.length;
    }

    @Override
    public int getND() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return Tools.arraycopy(this.shape);
    }

    @Override
    public int getDim(int n) {
        return this.shape[n];
    }

    @Override
    public void getAllIndexes(int[] nArray, int n) {
        int n2 = 0;
        int n3 = this.nidxs.length;
        for (int i = n2; i < n3; ++i) {
            nArray[n + i] = this.nidxs[i];
        }
    }

    @Override
    public int getIndex(int n) {
        return this.nidxs[n];
    }

    @Override
    public double[] getValue() {
        return this.model.getParameterValue(this.nidxs);
    }

    @Override
    public void setValue(double[][] dArray) {
        if (this.getND() != 2 || dArray.length != this.shape[0] || dArray[0].length != this.shape[1]) {
            throw new LengthError("Mismatching value shape");
        }
        if (this.sp == null) {
            double[] dArray2 = new double[this.shape[0] * this.shape[1]];
            int n = 0;
            int n2 = this.shape[0];
            for (int i = n; i < n2; ++i) {
                int n3 = 0;
                int n4 = this.shape[1];
                for (int j = n3; j < n4; ++j) {
                    dArray2[i * this.shape[1] + j] = dArray[i][j];
                }
            }
            this.model.setParameterValue(this.nidxs, dArray2);
        } else {
            double[] dArray3 = new double[this.sp.length];
            int n = 0;
            int n5 = this.sp.length;
            for (int i = n; i < n5; ++i) {
                dArray3[i] = dArray[(int)(this.sp[i] / (long)this.shape[1])][(int)(this.sp[i] % (long)this.shape[1])];
            }
            this.model.setParameterValue(this.nidxs, dArray3);
        }
    }

    @Override
    public void setValue(double[] dArray) {
        if (this.sp != null) {
            if ((long)dArray.length != this.getSize()) {
                throw new LengthError("Length of value array is incorrect");
            }
            double[] dArray2 = new double[this.nidxs.length];
            int n = 0;
            int n2 = this.nidxs.length;
            for (int i = n; i < n2; ++i) {
                dArray2[i] = dArray[(int)this.sp[i]];
            }
            this.model.setParameterValue(this.nidxs, dArray2);
        } else {
            if (dArray.length != this.nidxs.length) {
                throw new LengthError("Length of value array is incorrect for sparse parameter");
            }
            this.model.setParameterValue(this.nidxs, dArray);
        }
    }

    @Override
    public void setValue(double d) {
        double[] dArray = new double[(int)this.size];
        int n = 0;
        long l = this.size;
        for (long i = (long)n; i < l; ++i) {
            dArray[(int)i] = d;
        }
        this.model.setParameterValue(this.nidxs, dArray);
    }

    @Override
    public Model getModel() {
        return this.model;
    }
}

