/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.CommonTools;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Matrix;
import mosek.fusion.Utils.Tools;

public class NDSparseArray {
    protected double[] cof;
    protected long[] inst;
    protected int[] dims;
    protected long size;

    private NDSparseArray(int[] nArray, int[][] nArray2, double[] dArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long[] lArray = new long[nArray2.length];
        this.size = 1L;
        int n7 = 0;
        int n8 = nArray.length;
        for (n6 = n7; n6 < n8; ++n6) {
            this.size *= (long)nArray[n6];
        }
        n7 = nArray.length;
        if (nArray2.length != dArray.length) {
            throw new LengthError("Mismatching data array length");
        }
        if (nArray2[0].length != n7) {
            throw new IndexError("An index key in sub has wrong length");
        }
        n8 = 0;
        n6 = 0;
        int n9 = nArray2.length;
        for (n5 = n6; n5 < n9; ++n5) {
            int n10 = 0;
            n4 = nArray2[0].length;
            for (n3 = n10; n3 < n4; ++n3) {
                if (nArray2[n5][n3] >= 0 && nArray2[n5][n3] < nArray[n3]) continue;
                n8 = 1;
            }
        }
        if (n8 != 0) {
            throw new IndexError("An index in sub is out of bounds");
        }
        n6 = 0;
        n9 = nArray2.length;
        for (n5 = n6; n5 < n9; ++n5) {
            long l = 0L;
            n3 = 0;
            n2 = nArray2[0].length;
            for (int i = n3; i < n2; ++i) {
                l = l * (long)nArray[i] + (long)nArray2[n5][i];
            }
            lArray[n5] = l;
        }
        this.dims = Tools.arraycopy(nArray);
        n6 = 1;
        n9 = 1;
        n5 = lArray.length;
        for (n = n9; n < n5; ++n) {
            n6 = n6 != 0 && lArray[n] >= lArray[n - 1] ? 1 : 0;
        }
        if (n6 != 0) {
            n9 = 1;
            n5 = 1;
            n = lArray.length;
            for (n4 = n5; n4 < n; ++n4) {
                if (lArray[n4 - 1] >= lArray[n4]) continue;
                ++n9;
            }
            if (n9 == lArray.length) {
                this.inst = Tools.arraycopy(lArray);
                this.cof = Tools.arraycopy(dArray);
            } else {
                this.inst = new long[n9];
                this.inst[0] = lArray[0];
                this.cof = new double[n9];
                this.cof[0] = dArray[0];
                n5 = 0;
                n = 1;
                n4 = lArray.length;
                for (n3 = n; n3 < n4; ++n3) {
                    if (lArray[n3] > lArray[n3 - 1]) {
                        this.inst[++n5] = lArray[n3];
                        this.cof[n5] = dArray[n3];
                        continue;
                    }
                    this.cof[n5] = this.cof[n5] + dArray[n3];
                }
            }
        } else {
            long[] lArray2 = Tools.range((long)lArray.length);
            CommonTools.argQsort(lArray2, lArray, null, 0L, (long)lArray.length);
            n5 = 1;
            n = 1;
            n4 = lArray.length;
            for (n3 = n; n3 < n4; ++n3) {
                if (lArray[(int)lArray2[n3 - 1]] >= lArray[(int)lArray2[n3]]) continue;
                ++n5;
            }
            this.inst = new long[n5];
            this.inst[0] = lArray[(int)lArray2[0]];
            this.cof = new double[n5];
            this.cof[0] = dArray[(int)lArray2[0]];
            n = 0;
            n4 = 1;
            n3 = lArray.length;
            for (n2 = n4; n2 < n3; ++n2) {
                if (lArray[(int)lArray2[n2]] > lArray[(int)lArray2[n2 - 1]]) {
                    this.inst[++n] = lArray[(int)lArray2[n2]];
                    this.cof[n] = dArray[(int)lArray2[n2]];
                    continue;
                }
                this.cof[n] = this.cof[n] + dArray[(int)lArray2[n2]];
            }
        }
    }

    private NDSparseArray(int[] nArray, long[] lArray, double[] dArray) {
        int n;
        int n2;
        this.size = 1L;
        int n3 = 0;
        int n4 = nArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            this.size *= (long)nArray[n2];
        }
        n3 = lArray.length;
        if (n3 != dArray.length) {
            throw new LengthError("Mismatching data array length");
        }
        n4 = 0;
        n2 = 0;
        int n5 = n3;
        for (n = n2; n < n5; ++n) {
            n4 = n4 != 0 || lArray[n] < 0L || lArray[n] >= this.size ? 1 : 0;
        }
        if (n4 != 0) {
            throw new IndexError("An index in inst is out of bounds");
        }
        this.dims = Tools.arraycopy(nArray);
        n4 = 1;
        n2 = 1;
        n5 = lArray.length;
        for (n = n2; n < n5; ++n) {
            n4 = n4 != 0 && lArray[n] >= lArray[n - 1] ? 1 : 0;
        }
        if (n4 != 0) {
            int n6;
            n2 = 1;
            n5 = 1;
            n = lArray.length;
            for (n6 = n5; n6 < n; ++n6) {
                if (lArray[n6 - 1] >= lArray[n6]) continue;
                ++n2;
            }
            if (n2 == lArray.length) {
                this.inst = Tools.arraycopy(lArray);
                this.cof = Tools.arraycopy(dArray);
            } else {
                this.inst = new long[n2];
                this.inst[0] = lArray[0];
                this.cof = new double[n2];
                this.cof[0] = dArray[0];
                n5 = 0;
                n = 1;
                n6 = lArray.length;
                for (int i = n; i < n6; ++i) {
                    if (lArray[i] > lArray[i - 1]) {
                        this.inst[++n5] = lArray[i];
                        this.cof[n5] = dArray[i];
                        continue;
                    }
                    this.cof[n5] = this.cof[n5] + dArray[i];
                }
            }
        } else {
            int n7;
            long[] lArray2 = Tools.range((long)lArray.length);
            CommonTools.argQsort(lArray2, lArray, null, 0L, (long)lArray.length);
            n5 = 1;
            n = 1;
            int n8 = lArray.length;
            for (n7 = n; n7 < n8; ++n7) {
                if (lArray[(int)lArray2[n7 - 1]] >= lArray[(int)lArray2[n7]]) continue;
                ++n5;
            }
            this.inst = new long[n5];
            this.inst[0] = lArray[(int)lArray2[0]];
            this.cof = new double[n5];
            this.cof[0] = dArray[(int)lArray2[0]];
            n = 0;
            n8 = 1;
            n7 = lArray.length;
            for (int i = n8; i < n7; ++i) {
                if (lArray[(int)lArray2[i]] > this.inst[(int)lArray2[i - 1]]) {
                    this.inst[++n] = lArray[(int)lArray2[i]];
                    this.cof[n] = dArray[(int)lArray2[i]];
                    continue;
                }
                this.cof[n] = this.cof[n] + dArray[(int)lArray2[i]];
            }
        }
    }

    private NDSparseArray(Matrix matrix) {
        long l = matrix.numNonzeros();
        int n = matrix.numColumns();
        int n2 = matrix.numRows();
        double[] dArray = new double[(int)l];
        int[] nArray = new int[(int)l];
        int[] nArray2 = new int[(int)l];
        matrix.getDataAsTriplets(nArray2, nArray, dArray);
        this.size = (long)matrix.numRows() * (long)matrix.numColumns();
        this.dims = new int[]{n2, n};
        int n3 = 0;
        long l2 = 0L;
        long l3 = l;
        long l4 = l2 < l3 ? l3 - l2 : 0L;
        long[] lArray = new long[(int)l4];
        long l5 = l2;
        int n4 = 0;
        while ((long)n4 < l4) {
            lArray[n3] = (long)nArray2[(int)l5] * (long)n + (long)nArray[(int)l5];
            ++n3;
            ++n4;
            ++l5;
        }
        this.inst = lArray;
        this.cof = dArray;
    }

    public static NDSparseArray make(Matrix matrix) {
        return new NDSparseArray(matrix);
    }

    public static NDSparseArray make(int[] nArray, long[] lArray, double[] dArray) {
        return new NDSparseArray(nArray, lArray, dArray);
    }

    public static NDSparseArray make(int[] nArray, int[][] nArray2, double[] dArray) {
        return new NDSparseArray(nArray, nArray2, dArray);
    }
}

