/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.AccSolutionStatus;
import mosek.fusion.CommonTools;
import mosek.fusion.ProblemStatus;
import mosek.fusion.SolutionStatus;
import mosek.fusion.Utils.Tools;

public class SolutionStruct {
    public double[] accy;
    public double[] accx;
    public int[] accptr;
    public double[] yx;
    public double[] sux;
    public double[] slx;
    public double[] bars;
    public double[] barx;
    public double[] y;
    public double[] suc;
    public double[] slc;
    public double[] xx;
    public double[] xc;
    public double dobj;
    public double pobj;
    public ProblemStatus probstatus;
    public SolutionStatus dstatus;
    public SolutionStatus pstatus;
    public int sol_numbarvar;
    public int sol_numaccelm;
    public int sol_numacc;
    public int sol_numvar;
    public int sol_numcon;

    public SolutionStruct(int n, int n2, int n3, int n4, int n5) {
        this.pobj = 0.0;
        this.dobj = 0.0;
        this.pstatus = SolutionStatus.Unknown;
        this.dstatus = SolutionStatus.Unknown;
        this.probstatus = ProblemStatus.Unknown;
        this.sol_numvar = n;
        this.sol_numcon = n2;
        this.sol_numbarvar = n3;
        this.sol_numacc = n4;
        this.sol_numaccelm = n5;
        this.slx = null;
        this.sux = null;
        this.xx = null;
        this.yx = null;
        this.slc = null;
        this.suc = null;
        this.y = null;
        this.xc = null;
        this.barx = null;
        this.bars = null;
        this.accx = null;
        this.accy = null;
        this.accptr = null;
        if (n > 0) {
            this.slx = new double[n];
            this.sux = new double[n];
            this.xx = new double[n];
            this.yx = new double[n];
        }
        if (n3 > 0) {
            this.barx = new double[n3];
            this.bars = new double[n3];
        }
        if (n2 > 0) {
            this.slc = new double[n2];
            this.suc = new double[n2];
            this.y = new double[n2];
            this.xc = new double[n2];
        }
        if (n4 > 0) {
            this.accx = new double[n5];
            this.accy = new double[n5];
            this.accptr = new int[n4 + 1];
        }
    }

    public SolutionStruct(SolutionStruct solutionStruct) {
        this.sol_numcon = solutionStruct.sol_numcon;
        this.sol_numvar = solutionStruct.sol_numvar;
        this.sol_numbarvar = solutionStruct.sol_numbarvar;
        this.sol_numacc = solutionStruct.sol_numacc;
        this.sol_numaccelm = solutionStruct.sol_numaccelm;
        this.pstatus = solutionStruct.pstatus;
        this.dstatus = solutionStruct.dstatus;
        this.probstatus = solutionStruct.probstatus;
        this.pobj = solutionStruct.pobj;
        this.dobj = solutionStruct.dobj;
        this.xc = solutionStruct.xc != null ? Tools.arraycopy(solutionStruct.xc) : null;
        this.xx = solutionStruct.xx != null ? Tools.arraycopy(solutionStruct.xx) : null;
        this.yx = solutionStruct.yx != null ? Tools.arraycopy(solutionStruct.yx) : null;
        this.slc = solutionStruct.slc != null ? Tools.arraycopy(solutionStruct.slc) : null;
        this.suc = solutionStruct.suc != null ? Tools.arraycopy(solutionStruct.suc) : null;
        this.y = solutionStruct.y != null ? Tools.arraycopy(solutionStruct.y) : null;
        this.barx = solutionStruct.barx != null ? Tools.arraycopy(solutionStruct.barx) : null;
        this.bars = solutionStruct.bars != null ? Tools.arraycopy(solutionStruct.bars) : null;
        this.slx = solutionStruct.slx != null ? Tools.arraycopy(solutionStruct.slx) : null;
        this.sux = solutionStruct.sux != null ? Tools.arraycopy(solutionStruct.sux) : null;
        this.accptr = solutionStruct.accptr != null ? Tools.arraycopy(solutionStruct.accptr) : null;
        this.accx = solutionStruct.accx != null ? Tools.arraycopy(solutionStruct.accx) : null;
        this.accy = solutionStruct.accy != null ? Tools.arraycopy(solutionStruct.accy) : null;
    }

    public SolutionStruct clone() {
        return new SolutionStruct(this);
    }

    public void resize(int n, int n2, int n3, int n4, int n5) {
        int n6;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        Object[] objectArray;
        int n7;
        if (n4 <= 0) {
            this.sol_numacc = 0;
        } else if (n4 <= this.accptr.length - 1) {
            this.sol_numacc = n4;
        } else {
            n7 = (this.accptr.length - 1) * 2;
            if (n7 < n4) {
                n7 = n4;
            }
            objectArray = new int[n7 + 1];
            Tools.arraycopy(this.accptr, 0, (int[])objectArray, 0, n4 + 1);
            this.accptr = (int[])objectArray;
            this.sol_numacc = n4;
        }
        if (n5 <= 0) {
            this.sol_numaccelm = 0;
        } else if (n5 > this.accx.length) {
            this.sol_numaccelm = n5;
        } else {
            n7 = this.accx.length * 2;
            if (n7 < n5) {
                n7 = n5;
            }
            objectArray = new double[n7];
            dArray3 = new double[n7];
            Tools.arraycopy(this.accx, 0, objectArray, 0, n5);
            Tools.arraycopy(this.accy, 0, dArray3, 0, n5);
            this.accx = objectArray;
            this.accy = dArray3;
            this.sol_numaccelm = n5;
        }
        if (n3 >= 0) {
            if (n3 <= this.sol_numbarvar) {
                this.sol_numbarvar = n3;
            } else if (n3 > this.barx.length) {
                n7 = this.sol_numbarvar * 2 > n3 + 100 ? this.sol_numbarvar * 2 : n3 + 100;
                this.barx = CommonTools.resize(this.barx, n7);
                this.bars = CommonTools.resize(this.bars, n7);
                this.sol_numbarvar = n7;
            }
        }
        if (n >= 0) {
            if (n <= this.sol_numvar) {
                this.sol_numvar = n;
            } else if (n <= this.xx.length) {
                n7 = this.sol_numvar;
                int n8 = n;
                for (int i = n7; i < n8; ++i) {
                    this.slx[i] = 0.0;
                    this.sux[i] = 0.0;
                    this.xx[i] = 0.0;
                    this.yx[i] = 0.0;
                }
                this.sol_numvar = n;
            } else {
                n7 = this.sol_numvar * 2 > n + 100 ? this.sol_numvar * 2 : n + 100;
                objectArray = new double[n7];
                Tools.arraycopy(this.slx, 0, objectArray, 0, this.slx.length);
                this.slx = objectArray;
                dArray3 = new double[n7];
                Tools.arraycopy(this.sux, 0, dArray3, 0, this.sux.length);
                this.sux = dArray3;
                dArray2 = new double[n7];
                Tools.arraycopy(this.xx, 0, dArray2, 0, this.xx.length);
                this.xx = dArray2;
                dArray = new double[n7];
                Tools.arraycopy(this.yx, 0, dArray, 0, this.yx.length);
                this.yx = dArray;
                for (n6 = this.sol_numvar; n6 < n && n6 < n; ++n6) {
                    this.slx[n6] = 0.0;
                    this.sux[n6] = 0.0;
                    this.xx[n6] = 0.0;
                }
                this.sol_numvar = n;
            }
        }
        if (n2 >= 0) {
            if (n2 <= this.sol_numcon) {
                this.sol_numcon = n2;
            } else if (n2 <= this.xx.length) {
                n7 = this.sol_numcon;
                int n9 = n2;
                for (int i = n7; i < n9; ++i) {
                    this.slc[i] = 0.0;
                    this.suc[i] = 0.0;
                    this.xc[i] = 0.0;
                    this.y[i] = 0.0;
                }
                this.sol_numcon = n2;
            } else {
                n7 = this.sol_numcon * 2 > n2 + 100 ? this.sol_numcon * 2 : n2 + 100;
                double[] dArray4 = new double[n7];
                Tools.arraycopy(this.slc, 0, dArray4, 0, this.slc.length);
                this.slc = dArray4;
                dArray3 = new double[n7];
                Tools.arraycopy(this.suc, 0, dArray3, 0, this.suc.length);
                this.suc = dArray3;
                dArray2 = new double[n7];
                Tools.arraycopy(this.xc, 0, dArray2, 0, this.xc.length);
                this.xc = dArray2;
                dArray = new double[n7];
                Tools.arraycopy(this.y, 0, dArray, 0, this.y.length);
                this.y = dArray;
                n6 = this.sol_numcon;
                int n10 = n2;
                for (int i = n6; i < n10; ++i) {
                    this.slc[i] = 0.0;
                    this.suc[i] = 0.0;
                    this.xc[i] = 0.0;
                    this.y[i] = 0.0;
                }
                this.sol_numcon = n2;
            }
        }
    }

    public boolean isDualAcceptable(AccSolutionStatus accSolutionStatus) {
        return this.isAcceptable(this.dstatus, accSolutionStatus);
    }

    public boolean isPrimalAcceptable(AccSolutionStatus accSolutionStatus) {
        return this.isAcceptable(this.pstatus, accSolutionStatus);
    }

    private boolean isAcceptable(SolutionStatus solutionStatus, AccSolutionStatus accSolutionStatus) {
        if (accSolutionStatus == AccSolutionStatus.Anything) {
            return true;
        }
        if (accSolutionStatus == AccSolutionStatus.Optimal) {
            return solutionStatus == SolutionStatus.Optimal;
        }
        if (accSolutionStatus == AccSolutionStatus.Feasible) {
            return solutionStatus == SolutionStatus.Optimal || solutionStatus == SolutionStatus.Feasible;
        }
        if (accSolutionStatus == AccSolutionStatus.Certificate) {
            return solutionStatus == SolutionStatus.Certificate;
        }
        return false;
    }
}

