/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.PSDKey;

public final class PSDDomain {
    protected String[][] indexnames;
    protected boolean axisIsSet;
    protected int conedim2;
    protected int conedim1;
    protected PSDKey key;
    protected int[] shape;

    protected PSDDomain(PSDKey pSDKey, int[] nArray, int n, int n2) {
        this.axisIsSet = true;
        this.shape = nArray;
        this.key = pSDKey;
        this.conedim1 = n;
        this.conedim2 = n2;
        this.indexnames = null;
        int n3 = this.shape.length;
        if ((this.shape.length <= n || this.shape.length <= n2 || n < 0 || n2 < 0 || n == n2) && this.shape[n] == this.shape[n2]) {
            throw new DimensionError("Mismatching shape or cone dimensions");
        }
    }

    protected PSDDomain(PSDKey pSDKey, int[] nArray) {
        this(pSDKey, nArray, nArray.length - 2, nArray.length - 1);
    }

    protected PSDDomain(PSDKey pSDKey) {
        this.shape = null;
        this.key = pSDKey;
        this.conedim1 = 0;
        this.conedim2 = 0;
        this.axisIsSet = false;
        this.indexnames = null;
    }

    private PSDDomain(PSDDomain pSDDomain) {
        this.shape = pSDDomain.shape;
        this.key = pSDDomain.key;
        this.conedim1 = pSDDomain.conedim1;
        this.conedim2 = pSDDomain.conedim2;
        this.axisIsSet = pSDDomain.axisIsSet;
        this.indexnames = pSDDomain.indexnames;
    }

    public PSDDomain axis(int n, int n2) {
        this.conedim1 = n;
        this.conedim2 = n2;
        this.axisIsSet = true;
        if (this.shape == null && (n < 0 || n2 < 0 || n == n2)) {
            throw new DimensionError("Mismatching shape or cone dimensions");
        }
        if (this.shape != null && (this.shape.length <= n || this.shape.length <= n2 || n < 0 || n2 < 0 || n == n2) && this.shape[n] == this.shape[n2]) {
            throw new DimensionError("Mismatching shape or cone dimensions");
        }
        return this;
    }

    public PSDDomain withNamesOnAxis(String[] stringArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String[][] stringArrayArray;
        int n7;
        int n8;
        int n9;
        int n10;
        if (this.indexnames == null) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            this.indexnames = stringArrayArray;
            n5 = 0;
            n4 = 0;
            n3 = stringArray.length;
            n2 = n4 < n3 ? n3 - n4 : 0;
            String[] stringArray2 = new String[n2];
            int n11 = n4;
            int n12 = 0;
            while (n12 < n2) {
                stringArray2[n5] = stringArray[n11];
                ++n5;
                ++n12;
                ++n11;
            }
            this.indexnames[n] = stringArray2;
        }
        if (this.indexnames.length < n + 1) {
            n10 = 0;
            n9 = 0;
            n8 = n + 1;
            n7 = n9 < n8 ? n8 - n9 : 0;
            stringArrayArray = new String[n7][];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                stringArrayArray[n10] = null;
                ++n10;
                ++n5;
                ++n6;
            }
            String[][] stringArrayArray2 = stringArrayArray;
            n4 = 0;
            n3 = this.indexnames.length;
            for (n2 = n4; n2 < n3; ++n2) {
                stringArrayArray2[n2] = this.indexnames[n2];
            }
            this.indexnames = stringArrayArray2;
        }
        n10 = 0;
        n9 = 0;
        n8 = stringArray.length;
        n7 = n9 < n8 ? n8 - n9 : 0;
        stringArrayArray = new String[n7];
        n6 = n9;
        int n13 = 0;
        while (n13 < n7) {
            stringArrayArray[n10] = stringArray[n6];
            ++n10;
            ++n13;
            ++n6;
        }
        this.indexnames[n] = stringArrayArray;
        return this;
    }

    private void finalize_and_validate_inplace(int[] nArray) {
        int n;
        int n2;
        int n3;
        if (nArray != null) {
            if (this.shape == null) {
                this.shape = nArray;
            } else {
                if (nArray.length != this.shape.length) {
                    throw new DimensionError("Conflicting shape definitions");
                }
                n3 = 0;
                n2 = nArray.length;
                for (n = n3; n < n2; ++n) {
                    if (nArray[n] == this.shape[n]) continue;
                    throw new DimensionError("Conflicting shape definitions");
                }
            }
        }
        if (this.shape.length < 2) {
            throw new DimensionError("Positive semidefinite domain must have at least two dimensions");
        }
        if (!this.axisIsSet) {
            this.conedim1 = this.shape.length - 2;
            this.conedim2 = this.shape.length - 1;
        }
        if (this.conedim1 < 0 || this.conedim1 >= this.shape.length || this.conedim2 < 0 || this.conedim2 >= this.shape.length || this.conedim1 == this.conedim2) {
            throw new DimensionError("Invalid cone dimension specification");
        }
        if (this.shape[this.conedim1] != this.shape[this.conedim2]) {
            throw new DimensionError("Cone dimensions must have same size");
        }
        if (this.indexnames != null) {
            if (this.indexnames.length != this.shape.length) {
                throw new DimensionError("Index names do not match the domain shape");
            }
            n3 = 0;
            n2 = this.shape.length;
            for (n = n3; n < n2; ++n) {
                if (this.indexnames[n] == null || this.indexnames[n].length == this.shape[n]) continue;
                throw new DimensionError("Index names do not match the domain shape");
            }
        }
    }

    protected PSDDomain finalize_and_validate(int[] nArray) {
        PSDDomain pSDDomain = new PSDDomain(this);
        pSDDomain.finalize_and_validate_inplace(nArray);
        return pSDDomain;
    }
}

