/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.CommonTools;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public final class ExprPermuteDims
extends BaseExpression {
    private int[] dperm;
    private Expression expr;

    public ExprPermuteDims(int[] nArray, Expression expression) {
        this(nArray, expression, 1);
        int n;
        int[] nArray2 = expression.getShape();
        if (nArray.length != nArray2.length) {
            throw new LengthError("Invalid dimension permutation length");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray3 = new int[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            nArray3[n2] = 0;
            ++n2;
            ++n7;
            ++n6;
        }
        int[] nArray4 = nArray3;
        int n8 = 0;
        int n9 = nArray4.length;
        for (n = n8; n < n9; ++n) {
            if (nArray[n] < 0 || nArray[n] > nArray2.length) {
                throw new LengthError("Invalid dimension permutation index");
            }
            int n10 = nArray[n];
            nArray4[n10] = nArray4[n10] + 1;
        }
        n8 = 0;
        n9 = nArray4.length;
        for (n = n8; n < n9; ++n) {
            if (nArray4[n] >= 1 && nArray4[n] <= 1) continue;
            throw new LengthError("Dimension permutation contains duplicates");
        }
    }

    protected ExprPermuteDims(int[] nArray, Expression expression, int n) {
        super(expression.getModel(), ExprPermuteDims.computeshape(nArray, expression.getShape()));
        this.expr = expression;
        this.dperm = Tools.arraycopy(nArray);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3;
        this.expr.recursive_eval(workStack2, workStack, workStack3, bl);
        workStack2.pop_expr();
        int n4 = workStack2.nd;
        int n5 = workStack2.nelem;
        int n6 = workStack2.nnz;
        int n7 = workStack2.ncodeatom;
        boolean bl2 = workStack2.hassp;
        int n8 = workStack2.shape_base;
        long[] lArray = new long[n4];
        lArray[n4 - 1] = 1L;
        int n9 = 1;
        int n10 = n4;
        for (n3 = n9; n3 < n10; ++n3) {
            lArray[n4 - n3 - 1] = lArray[n4 - n3] * (long)workStack2.i32[n8 + n4 - n3];
        }
        long[] lArray2 = new long[n4];
        lArray2[n4 - 1] = 1L;
        n10 = 1;
        n3 = n4;
        for (n2 = n10; n2 < n3; ++n2) {
            lArray2[n4 - n2 - 1] = lArray2[n4 - n2] * (long)workStack2.i32[n8 + this.dperm[n4 - n2]];
        }
        n10 = workStack2.ptr_base;
        n3 = workStack2.sp_base;
        n2 = workStack2.nidxs_base;
        int n11 = workStack2.cof_base;
        int n12 = workStack2.code_base;
        int n13 = workStack2.codeptr_base;
        int n14 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray3 = workStack2.i64;
        double[] dArray = workStack2.f64;
        workStack.alloc_expr(n4, n5, n6, bl2, n7);
        int n15 = workStack.ptr_base;
        int n16 = workStack.shape_base;
        int n17 = workStack.nidxs_base;
        int n18 = workStack.sp_base;
        int n19 = workStack.cof_base;
        int n20 = workStack.code_base;
        int n21 = workStack.codeptr_base;
        int n22 = workStack.cconst_base;
        int[] nArray2 = workStack.i32;
        long[] lArray4 = workStack.i64;
        double[] dArray2 = workStack.f64;
        int n23 = 0;
        int n24 = n4;
        for (n = n23; n < n24; ++n) {
            nArray2[n16 + n] = nArray[n8 + this.dperm[n]];
        }
        if (bl2) {
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            long[] lArray5 = new long[n5];
            long[] lArray6 = new long[n4];
            n = 0;
            int n30 = n5;
            for (n29 = n; n29 < n30; ++n29) {
                long l = lArray3[n3 + n29];
                int n31 = 0;
                n28 = n4;
                for (n27 = n31; n27 < n28; ++n27) {
                    lArray6[n27] = l / lArray[n27];
                    l %= lArray[n27];
                }
                long l2 = lArray6[this.dperm[0]];
                n27 = 1;
                n26 = n4;
                for (n25 = n27; n25 < n26; ++n25) {
                    l2 = l2 * (long)nArray2[n16 + n25] + lArray6[this.dperm[n25]];
                }
                lArray5[n29] = l2;
            }
            int n32 = 0;
            n = 0;
            n30 = n5;
            n29 = n < n30 ? n30 - n : 0;
            long[] lArray7 = new long[n29];
            int n33 = n;
            int n34 = 0;
            while (n34 < n29) {
                lArray7[n32] = n33;
                ++n32;
                ++n34;
                ++n33;
            }
            long[] lArray8 = lArray7;
            CommonTools.argQsort(lArray8, lArray5, null, 0L, (long)n5);
            nArray2[n15] = 0;
            if (n7 > 0) {
                nArray2[n21] = 0;
            }
            n28 = 0;
            n27 = 0;
            n26 = 0;
            n25 = 0;
            int n35 = n5;
            for (int i = n25; i < n35; ++i) {
                long l = lArray8[i];
                int n36 = nArray[(int)((long)n10 + l)];
                int n37 = nArray[(int)((long)n10 + l + 1L)];
                for (int j = n36; j < n37; ++j) {
                    lArray4[n17 + n26] = lArray3[n2 + j];
                    dArray2[n19 + n26] = dArray[n11 + j];
                    if (n7 > 0) {
                        int n38 = nArray[n13 + j];
                        int n39 = nArray[n13 + j + 1];
                        for (int k = n38; k < n39; ++k) {
                            nArray2[n20 + n28] = nArray[n12 + k];
                            dArray2[n22 + n28] = dArray[n14 + k];
                            ++n28;
                        }
                        nArray2[n21 + n26 + 1] = n28;
                    }
                    ++n26;
                }
                lArray4[n18 + i] = lArray5[(int)l];
                ++n27;
                nArray2[n15 + i + 1] = n26;
            }
        } else {
            nArray2[n15] = 0;
            if (n7 > 0) {
                nArray2[n21] = 0;
            }
            n23 = 0;
            n24 = 0;
            n = 0;
            int n40 = 0;
            int n41 = n5;
            for (int i = n40; i < n41; ++i) {
                int n42;
                long l = 0L;
                long l3 = i;
                int n43 = 0;
                int n44 = n4;
                for (n42 = n43; n42 < n44; ++n42) {
                    l += l3 / lArray2[n42] * lArray[this.dperm[n42]];
                    l3 %= lArray2[n42];
                }
                n43 = nArray[(int)((long)n10 + l)];
                n44 = nArray[(int)((long)n10 + l + 1L)];
                for (n42 = n43; n42 < n44; ++n42) {
                    lArray4[n17 + n] = lArray3[n2 + n42];
                    dArray2[n19 + n] = dArray[n11 + n42];
                    if (n7 > 0) {
                        int n45 = nArray[n13 + n42];
                        int n46 = nArray[n13 + n42 + 1];
                        for (int j = n45; j < n46; ++j) {
                            nArray2[n20 + n23] = nArray[n12 + j];
                            dArray2[n22 + n23] = dArray[n14 + j];
                            ++n23;
                        }
                        nArray2[n21 + n + 1] = n23;
                    }
                    ++n;
                }
                nArray2[n15 + ++n24] = n;
            }
        }
    }

    private static int[] computeshape(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray3 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray3[n] = nArray2[nArray[n5]];
            ++n;
            ++n6;
            ++n5;
        }
        return nArray3;
    }
}

