/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;
import mosek.fusion.WorkStack;

public class ExprMulVar
extends BaseExpression {
    private boolean left;
    private Variable x;
    private double[] mcof;
    private int[] msubj;
    private int[] msubi;
    private int mdimj;
    private int mdimi;

    public ExprMulVar(boolean bl, int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Variable variable) {
        this(bl, n, n2, nArray, nArray2, dArray, variable, 1);
        int[] nArray3 = variable.getShape();
        int n3 = nArray3.length;
        if (n3 != 2) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (bl && nArray3[0] != n2) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (!bl && nArray3[1] != n) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (nArray.length != nArray2.length || nArray.length != dArray.length) {
            throw new LengthError("Mismatching matrix data lengths");
        }
        this.validate(n, n2, nArray, nArray2, dArray);
    }

    protected ExprMulVar(boolean bl, int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Variable variable, int n3) {
        super(variable.getModel(), ExprMulVar.resshape(n, n2, variable.getShape(), bl));
        this.left = bl;
        this.x = variable;
        this.mdimi = n;
        this.mdimj = n2;
        this.msubi = Tools.arraycopy(nArray);
        this.msubj = Tools.arraycopy(nArray2);
        this.mcof = Tools.arraycopy(dArray);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        if (this.left) {
            this.eval_left(workStack, workStack2, workStack3, bl);
        } else {
            this.eval_right(workStack, workStack2, workStack3, bl);
        }
    }

    public void eval_right(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n = workStack2.pi32;
        int n2 = workStack2.pi64;
        int n3 = this.x.numInst();
        int n4 = workStack2.alloci64(n3);
        int n5 = workStack2.alloci64(n3);
        int n6 = workStack2.alloci32(n3);
        int n7 = workStack2.alloci32(n3);
        int[] nArray = this.x.getShape();
        int n8 = nArray.length;
        long l = nArray[0] * nArray[1];
        int n9 = nArray[1];
        int n10 = nArray[0];
        int n11 = workStack2.alloci32(n10 + 1);
        int n12 = this.msubi.length;
        int[] nArray2 = this.msubi;
        int[] nArray3 = this.msubj;
        double[] dArray = this.mcof;
        int n13 = this.mdimi;
        int n14 = this.mdimj;
        boolean bl2 = n12 / n13 == n14;
        int n15 = workStack2.alloci32(n12);
        int n16 = workStack2.alloci32(this.mdimj + 1);
        int[] nArray4 = workStack2.i32;
        long[] lArray = workStack2.i64;
        int n17 = 0;
        int n18 = 0;
        this.x.inst(n5, lArray, n4, lArray);
        if (bl2) {
            int n19;
            int n20;
            int n21;
            int n22 = 0;
            if (n3 > 0) {
                n22 = 1;
                if (n10 > 1) {
                    if (n9 == 1) {
                        n21 = 1;
                        n20 = n3;
                        for (n19 = n21; n19 < n20; ++n19) {
                            if (lArray[n5 + n19] <= lArray[n5 + n19 - 1]) continue;
                            ++n22;
                        }
                    } else {
                        n21 = 1;
                        n20 = n3;
                        for (n19 = n21; n19 < n20; ++n19) {
                            if (lArray[n5 + n19] / (long)n9 <= lArray[n5 + n19 - 1] / (long)n9) continue;
                            ++n22;
                        }
                    }
                }
            }
            n18 = n22 * n14;
            n17 = n3 * n14;
            n21 = n22 < n10 ? 1 : 0;
            workStack.alloc_expr(2, n18, n17, n21 != 0);
            n20 = workStack.ptr_base;
            n19 = workStack.shape_base;
            int n23 = workStack.nidxs_base;
            int n24 = n21 != 0 ? workStack.sp_base : workStack.alloci64(n18);
            int n25 = workStack.cof_base;
            int[] nArray5 = workStack.i32;
            long[] lArray2 = workStack.i64;
            double[] dArray2 = workStack.f64;
            nArray5[n19] = n10;
            nArray5[n19 + 1] = n14;
            int n26 = 0;
            int n27 = 0;
            int n28 = 0;
            nArray5[n20] = 0;
            while (n26 < n3) {
                int n29 = n26++;
                while (n26 < n3 && lArray[n5 + n26] / (long)n9 == lArray[n5 + n29] / (long)n9) {
                    ++n26;
                }
                long l2 = lArray[n5 + n29] / (long)n9;
                int n30 = 0;
                int n31 = n14;
                for (int i = n30; i < n31; ++i) {
                    int n32 = n29;
                    int n33 = n26;
                    for (int j = n32; j < n33; ++j) {
                        long l3 = lArray[n5 + j] % (long)n9;
                        lArray2[n23 + n28] = lArray[n4 + j];
                        dArray2[n25 + n28] = dArray[(int)(l3 * (long)n14 + (long)i)];
                        ++n28;
                    }
                    nArray5[n20 + n27 + 1] = n28;
                    lArray2[n24 + n27] = l2 * (long)n14 + (long)i;
                    ++n27;
                }
            }
            if (n21 == 0) {
                workStack.popi64(n18);
            }
        } else {
            int n34;
            int n35;
            int n36;
            if (n14 == 1) {
                n36 = 0;
                n35 = n12;
                for (n34 = n36; n34 < n35; ++n34) {
                    nArray4[n15 + n34] = n34;
                }
                nArray4[n16] = 0;
                nArray4[n16 + 1] = n12;
            } else {
                nArray4[n16] = 0;
                n36 = 0;
                n35 = n14 + 1;
                for (n34 = n36; n34 < n35; ++n34) {
                    nArray4[n16 + n34] = 0;
                }
                n36 = 0;
                n35 = n12;
                for (n34 = n36; n34 < n35; ++n34) {
                    int n37 = n16 + nArray3[n34] + 1;
                    nArray4[n37] = nArray4[n37] + 1;
                }
                n36 = 0;
                n35 = this.mdimj;
                for (n34 = n36; n34 < n35; ++n34) {
                    int n38 = n16 + n34 + 1;
                    nArray4[n38] = nArray4[n38] + nArray4[n16 + n34];
                }
                n36 = 0;
                n35 = n12;
                for (n34 = n36; n34 < n35; ++n34) {
                    nArray4[n15 + nArray4[n16 + nArray3[n34]]] = n34;
                    int n39 = n16 + nArray3[n34];
                    nArray4[n39] = nArray4[n39] + 1;
                }
                n36 = 0;
                n35 = n14;
                for (n34 = n36; n34 < n35; ++n34) {
                    nArray4[n16 + n14 - n34] = nArray4[n16 + n14 - n34 - 1];
                }
                nArray4[n16] = 0;
            }
            if (n3 / n10 == n9) {
                n36 = 0;
                n35 = 0;
                while (n35 < n12) {
                    ++n35;
                    while (n35 < n12 && nArray3[nArray4[n15 + n35 - 1]] == nArray3[nArray4[n15 + n35]]) {
                        ++n35;
                    }
                    ++n36;
                }
                n18 = n36 * n10;
                n17 = n12 * n10;
                n35 = n36 < n14 ? 1 : 0;
                workStack.alloc_expr(2, n18, n17, n35 != 0);
                n34 = workStack.ptr_base;
                int n40 = workStack.shape_base;
                int n41 = workStack.nidxs_base;
                int n42 = n35 != 0 ? workStack.sp_base : workStack.alloci64(n18);
                int n43 = workStack.cof_base;
                workStack.i32[n40] = n10;
                workStack.i32[n40 + 1] = n14;
                int[] nArray6 = workStack.i32;
                long[] lArray3 = workStack.i64;
                double[] dArray3 = workStack.f64;
                nArray6[n34] = 0;
                int n44 = 0;
                int n45 = 0;
                int n46 = 0;
                int n47 = n10;
                for (int i = n46; i < n47; ++i) {
                    int n48 = 0;
                    while (n48 < n12) {
                        int n49 = n48++;
                        while (n48 < n12 && nArray3[nArray4[n15 + n49]] == nArray3[nArray4[n15 + n48]]) {
                            ++n48;
                        }
                        int n50 = nArray3[nArray4[n15 + n49]];
                        int n51 = n49;
                        int n52 = n48;
                        for (int j = n51; j < n52; ++j) {
                            int n53 = nArray2[nArray4[n15 + j]];
                            lArray3[n41 + n45] = lArray[n4 + i * n9 + n53];
                            dArray3[n43 + n45] = dArray[nArray4[n15 + j]];
                            ++n45;
                        }
                        lArray3[n42 + n44] = i * n14 + n50;
                        nArray6[n34 + n44 + 1] = n45;
                        ++n44;
                    }
                }
                if (n35 == 0) {
                    workStack.popi64(n18);
                }
            } else {
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                n36 = 0;
                n35 = n10 + 1;
                for (n34 = n36; n34 < n35; ++n34) {
                    nArray4[n11 + n34] = 0;
                }
                if (n8 == 1) {
                    n36 = 0;
                    n35 = n3;
                    for (n34 = n36; n34 < n35; ++n34) {
                        nArray4[n6 + n34] = 0;
                    }
                    n36 = 0;
                    n35 = n3;
                    for (n34 = n36; n34 < n35; ++n34) {
                        nArray4[n7 + n34] = (int)lArray[n5 + n34];
                    }
                    nArray4[n11] = 0;
                    nArray4[n11 + 1] = n3;
                } else {
                    n36 = 0;
                    n35 = n3;
                    for (n34 = n36; n34 < n35; ++n34) {
                        nArray4[n6 + n34] = (int)(lArray[n5 + n34] / (long)nArray[1]);
                    }
                    n36 = 0;
                    n35 = n3;
                    for (n34 = n36; n34 < n35; ++n34) {
                        nArray4[n7 + n34] = (int)(lArray[n5 + n34] % (long)nArray[1]);
                    }
                    nArray4[n11] = 0;
                    n36 = 0;
                    n35 = n3;
                    for (n34 = n36; n34 < n35; ++n34) {
                        int n59 = n11 + nArray4[n6 + n34] + 1;
                        nArray4[n59] = nArray4[n59] + 1;
                    }
                    n36 = 0;
                    n35 = n10;
                    for (n34 = n36; n34 < n35; ++n34) {
                        int n60 = n11 + n34 + 1;
                        nArray4[n60] = nArray4[n60] + nArray4[n11 + n34];
                    }
                }
                n36 = 0;
                n35 = n10;
                for (n34 = n36; n34 < n35; ++n34) {
                    n58 = 0;
                    n57 = this.mdimj;
                    for (n56 = n58; n56 < n57; ++n56) {
                        int n61 = 0;
                        int n62 = nArray4[n11 + n34 + 1];
                        int n63 = nArray4[n16 + n56 + 1];
                        n55 = nArray4[n11 + n34];
                        n54 = nArray4[n16 + n56];
                        while (n54 < n63 && n55 < n62) {
                            if (nArray2[nArray4[n15 + n54]] < nArray4[n7 + n55]) {
                                ++n54;
                                continue;
                            }
                            if (nArray2[nArray4[n15 + n54]] > nArray4[n7 + n55]) {
                                ++n55;
                                continue;
                            }
                            ++n61;
                            ++n54;
                            ++n55;
                        }
                        if (n61 <= 0) continue;
                        n17 += n61;
                        ++n18;
                    }
                }
                n36 = n18 < n9 * this.mdimi ? 1 : 0;
                workStack.alloc_expr(2, n18, n17, n36 != 0);
                n35 = workStack.ptr_base;
                n34 = workStack.shape_base;
                n58 = workStack.nidxs_base;
                n57 = workStack.sp_base;
                n56 = workStack.cof_base;
                workStack.i32[n34] = n10;
                workStack.i32[n34 + 1] = this.mdimj;
                int[] nArray7 = workStack.i32;
                long[] lArray4 = workStack.i64;
                double[] dArray4 = workStack.f64;
                n55 = 0;
                n54 = 0;
                int n64 = 0;
                nArray7[n35] = 0;
                int n65 = 0;
                int n66 = n10;
                for (int i = n65; i < n66; ++i) {
                    int n67 = 0;
                    int n68 = this.mdimj;
                    for (int j = n67; j < n68; ++j) {
                        int n69 = 0;
                        int n70 = nArray4[n11 + i + 1];
                        int n71 = nArray4[n16 + j + 1];
                        int n72 = nArray4[n11 + i];
                        int n73 = nArray4[n16 + j];
                        while (n73 < n71 && n72 < n70) {
                            if (nArray2[nArray4[n15 + n73]] < nArray4[n7 + n72]) {
                                ++n73;
                                continue;
                            }
                            if (nArray2[nArray4[n15 + n73]] > nArray4[n7 + n72]) {
                                ++n72;
                                continue;
                            }
                            lArray4[n58 + n64] = lArray[n4 + n72];
                            dArray4[n56 + n64] = dArray[nArray4[n15 + n73]];
                            ++n69;
                            ++n64;
                            ++n73;
                            ++n72;
                        }
                        if (n69 > 0) {
                            nArray7[n35 + n54 + 1] = n64;
                            if (n36 != 0) {
                                lArray4[n57 + n54] = n55;
                            }
                            ++n54;
                        }
                        ++n55;
                    }
                }
            }
        }
        workStack2.pi32 = n;
        workStack2.pi64 = n2;
    }

    public void eval_left(WorkStack workStack, WorkStack workStack2, WorkStack workStack3, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = this.x.numInst();
        int[] nArray = this.x.getShape();
        int n10 = nArray.length;
        int n11 = workStack3.alloci64(n9);
        int n12 = workStack3.alloci64(n9);
        int n13 = workStack3.alloci32(n9);
        int n14 = workStack3.alloci32(n9);
        int n15 = workStack3.alloci32(n9);
        int n16 = workStack3.alloci32(this.mdimi + 1);
        int[] nArray2 = this.x.getShape();
        int n17 = nArray2.length;
        int n18 = n17 == 1 ? 1 : nArray2[1];
        int n19 = nArray2[0];
        int n20 = workStack3.alloci32(n18 + 1);
        int[] nArray3 = this.msubi;
        int[] nArray4 = this.msubj;
        double[] dArray = this.mcof;
        int n21 = this.mdimi;
        int n22 = this.mdimj;
        int n23 = 0;
        int n24 = 0;
        int[] nArray5 = workStack3.i32;
        long[] lArray = workStack3.i64;
        int n25 = dArray.length;
        this.x.inst(n12, lArray, n11, lArray);
        if ((long)this.x.numInst() < this.x.getSize()) {
            n8 = 0;
            n7 = n21 + 1;
            for (n6 = n8; n6 < n7; ++n6) {
                nArray5[n16 + n6] = 0;
            }
            n8 = 0;
            n7 = nArray3.length;
            for (n6 = n8; n6 < n7; ++n6) {
                int n26 = n16 + nArray3[n6] + 1;
                nArray5[n26] = nArray5[n26] + 1;
            }
            n8 = 0;
            n7 = n21;
            for (n6 = n8; n6 < n7; ++n6) {
                int n27 = n16 + n6 + 1;
                nArray5[n27] = nArray5[n27] + nArray5[n16 + n6];
            }
            if (n17 == 1) {
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n13 + n6] = (int)lArray[n12 + n6];
                }
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n14 + n6] = 0;
                }
            } else {
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n13 + n6] = (int)(lArray[n12 + n6] / (long)n18);
                }
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n14 + n6] = (int)(lArray[n12 + n6] % (long)n18);
                }
            }
            if (n17 > 1) {
                n8 = 0;
                n7 = n18 + 1;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n20 + n6] = 0;
                }
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    int n28 = n20 + nArray5[n14 + n6] + 1;
                    nArray5[n28] = nArray5[n28] + 1;
                }
                n8 = 0;
                n7 = n18;
                for (n6 = n8; n6 < n7; ++n6) {
                    int n29 = n20 + n6 + 1;
                    nArray5[n29] = nArray5[n29] + nArray5[n20 + n6];
                }
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n15 + nArray5[n20 + nArray5[n14 + n6]]] = n6;
                    int n30 = n20 + nArray5[n14 + n6];
                    nArray5[n30] = nArray5[n30] + 1;
                }
                n8 = 0;
                n7 = n18;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n20 + n18 - n6] = nArray5[n20 + n18 - n6 - 1];
                }
                nArray5[n20] = 0;
            } else {
                nArray5[n20] = 0;
                nArray5[n20 + 1] = n9;
                n8 = 0;
                n7 = n9;
                for (n6 = n8; n6 < n7; ++n6) {
                    nArray5[n15 + n6] = n6;
                }
            }
            n8 = 0;
            n7 = n21;
            for (n6 = n8; n6 < n7; ++n6) {
                n5 = 0;
                n4 = n18;
                for (n3 = n5; n3 < n4; ++n3) {
                    n2 = 0;
                    int n31 = nArray5[n20 + n3 + 1];
                    int n32 = nArray5[n16 + n6 + 1];
                    int n33 = nArray5[n20 + n3];
                    n = nArray5[n16 + n6];
                    while (n < n32 && n33 < n31) {
                        if (nArray4[n] < nArray5[n13 + nArray5[n15 + n33]]) {
                            ++n;
                            continue;
                        }
                        if (nArray4[n] > nArray5[n13 + nArray5[n15 + n33]]) {
                            ++n33;
                            continue;
                        }
                        ++n2;
                        ++n;
                        ++n33;
                    }
                    if (n2 <= 0) continue;
                    n23 += n2;
                    ++n24;
                }
            }
        } else {
            n23 = n25 * n18;
            n8 = 0;
            while (n8 < n25) {
                for (n7 = n8 + 1; n7 < n25 && nArray3[n8] == nArray3[n7]; ++n7) {
                }
                ++n24;
                n8 = n7;
            }
            n24 *= n18;
        }
        n8 = n24 < n18 * n21 ? 1 : 0;
        n7 = n17;
        workStack.alloc_expr(n7, n24, n23, n8 != 0);
        n6 = workStack.ptr_base;
        n5 = workStack.shape_base;
        n4 = workStack.nidxs_base;
        n3 = n8 != 0 ? workStack.sp_base : workStack.alloci64(n24);
        n2 = workStack.cof_base;
        int[] nArray6 = workStack.i32;
        long[] lArray2 = workStack.i64;
        double[] dArray2 = workStack.f64;
        nArray6[n5] = n21;
        if (n17 > 1) {
            nArray6[n5 + 1] = n18;
        }
        if ((long)this.x.numInst() < this.x.getSize()) {
            n = 0;
            int n34 = 0;
            int n35 = 0;
            nArray6[n6] = 0;
            int n36 = 0;
            int n37 = n21;
            for (int i = n36; i < n37; ++i) {
                int n38 = 0;
                int n39 = n18;
                for (int j = n38; j < n39; ++j) {
                    int n40 = 0;
                    int n41 = nArray5[n20 + j + 1];
                    int n42 = nArray5[n16 + i + 1];
                    int n43 = nArray5[n20 + j];
                    int n44 = nArray5[n16 + i];
                    while (n44 < n42 && n43 < n41) {
                        if (nArray4[n44] < nArray5[n13 + nArray5[n15 + n43]]) {
                            ++n44;
                            continue;
                        }
                        if (nArray4[n44] > nArray5[n13 + nArray5[n15 + n43]]) {
                            ++n43;
                            continue;
                        }
                        lArray2[n4 + n35] = lArray[n11 + nArray5[n15 + n43]];
                        dArray2[n2 + n35] = dArray[n44];
                        ++n40;
                        ++n35;
                        ++n44;
                        ++n43;
                    }
                    if (n40 > 0) {
                        nArray6[n6 + n34 + 1] = n35;
                        lArray2[n3 + n34] = n;
                        ++n34;
                    }
                    ++n;
                }
            }
        } else {
            n = 0;
            int n45 = 0;
            nArray6[n6] = 0;
            int n46 = 0;
            while (n46 < n25) {
                int n47;
                for (n47 = n46 + 1; n47 < n25 && nArray3[n47] == nArray3[n46]; ++n47) {
                }
                int n48 = 0;
                int n49 = n18;
                for (int i = n48; i < n49; ++i) {
                    int n50 = n46;
                    int n51 = n47;
                    for (int j = n50; j < n51; ++j) {
                        lArray2[n4 + n] = lArray[n11 + nArray4[j] * n18 + i];
                        dArray2[n2 + n] = dArray[j];
                        ++n;
                    }
                    nArray6[n6 + n45 + 1] = n;
                    lArray2[n3 + n45] = nArray3[n46] * n18 + i;
                    ++n45;
                }
                n46 = n47;
            }
        }
        if (n8 == 0) {
            workStack.popi64(n24);
        }
        workStack3.clear();
    }

    private void validate(int n, int n2, int[] nArray, int[] nArray2, double[] dArray) {
        int n3;
        boolean bl = true;
        int n4 = 0;
        int n5 = nArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            if (nArray[n3] >= 0 && nArray[n3] < n && nArray2[n3] >= 0 && nArray2[n3] < n2) continue;
            bl = false;
        }
        n4 = 1;
        n5 = nArray.length;
        for (n3 = n4; n3 < n5; ++n3) {
            if (nArray[n3 - 1] <= nArray[n3] && (nArray[n3 - 1] != nArray[n3] || nArray2[n3 - 1] < nArray2[n3])) continue;
            bl = false;
        }
        if (!bl) {
            throw new IndexError("Invalid matrix data");
        }
    }

    private static int[] resshape(int n, int n2, int[] nArray, boolean bl) {
        if (bl) {
            return new int[]{n, nArray[1]};
        }
        return new int[]{nArray[0], n2};
    }

    @Override
    public String toString() {
        if (this.left) {
            return new StringBuffer().a("ExprMulVar(M,").a(this.x.toString()).a(")").toString();
        }
        return new StringBuffer().a("ExprMulVar(").a(this.x.toString()).a(",M)").toString();
    }
}

