/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DJCDomain;
import mosek.fusion.DJCDomainType;
import mosek.fusion.DomainError;
import mosek.fusion.ExprDomain;
import mosek.fusion.ExprLinearDomain;
import mosek.fusion.ExprRangeDomain;
import mosek.fusion.Expression;
import mosek.fusion.LinearDomain;
import mosek.fusion.RangeDomain;
import mosek.fusion.RelationKey;
import mosek.fusion.SimpleTerm;
import mosek.fusion.Term;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Variable;

public class DJC {
    public static Term ANDFromTerms(Term[] termArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = termArray.length;
        for (n = n3; n < n4; ++n) {
            n2 += termArray[n].num();
        }
        Expression[] expressionArray = new Expression[n2];
        DJCDomain[] dJCDomainArray = new DJCDomain[n2];
        n2 = 0;
        n = 0;
        int n5 = termArray.length;
        for (int i = n; i < n5; ++i) {
            int n6 = 0;
            int n7 = termArray[i].num();
            for (int j = n6; j < n7; ++j) {
                expressionArray[n2] = termArray[i].exprs[j];
                dJCDomainArray[n2] = termArray[i].domains[j];
                ++n2;
            }
        }
        return new Term(expressionArray, dJCDomainArray);
    }

    public static Term AND(ExprDomain[] exprDomainArray) {
        int n = 0;
        int n2 = 0;
        int n3 = exprDomainArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        Term[] termArray = new Term[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            termArray[n] = exprDomainArray[n5].toDJCTerm();
            ++n;
            ++n6;
            ++n5;
        }
        return DJC.ANDFromTerms(termArray);
    }

    public static Term AND(SimpleTerm simpleTerm, SimpleTerm simpleTerm2, SimpleTerm simpleTerm3) {
        return DJC.AND(new SimpleTerm[]{simpleTerm, simpleTerm2, simpleTerm3});
    }

    public static Term AND(SimpleTerm simpleTerm, SimpleTerm simpleTerm2) {
        return DJC.AND(new SimpleTerm[]{simpleTerm, simpleTerm2});
    }

    public static Term AND(SimpleTerm simpleTerm) {
        return DJC.AND(new SimpleTerm[]{simpleTerm});
    }

    public static Term AND(SimpleTerm[] simpleTermArray) {
        return new Term(simpleTermArray);
    }

    public static SimpleTerm term(Expression expression, RangeDomain rangeDomain) {
        double[] dArray;
        double[] dArray2;
        int n;
        int n2;
        if (rangeDomain.sparsity != null) {
            throw new DomainError("Sparse domain is not acceptable in disjunctive constraints");
        }
        if (rangeDomain.cardinal_flag) {
            throw new DomainError("Integer domain is not acceptable in disjunctive constraints");
        }
        double[] dArray3 = rangeDomain.lb;
        double[] dArray4 = rangeDomain.ub;
        int[] nArray = expression.getShape();
        long l = expression.getSize();
        int[] nArray2 = rangeDomain.shape;
        if (nArray2 == null) {
            nArray2 = nArray;
        } else {
            if (nArray2.length != nArray.length) {
                throw new DomainError("Mismatching shapes");
            }
            n2 = 0;
            n = nArray2.length;
            for (int i = n2; i < n; ++i) {
                if (nArray2[i] == nArray[i]) continue;
                throw new DomainError("Mismatching shapes");
            }
        }
        if (rangeDomain.scalable) {
            n2 = 0;
            n = 0;
            long l2 = l;
            long l3 = (long)n < l2 ? l2 - (long)n : 0L;
            double[] dArray5 = new double[(int)l3];
            long l4 = n;
            int n3 = 0;
            while ((long)n3 < l3) {
                dArray5[n2] = dArray3[0];
                ++n2;
                ++n3;
                ++l4;
            }
            dArray2 = dArray5;
            n3 = 0;
            int n4 = 0;
            long l5 = l;
            long l6 = (long)n4 < l5 ? l5 - (long)n4 : 0L;
            double[] dArray6 = new double[(int)l6];
            long l7 = n4;
            int n5 = 0;
            while ((long)n5 < l6) {
                dArray6[n3] = dArray4[0];
                ++n3;
                ++n5;
                ++l7;
            }
            dArray = dArray6;
        } else {
            dArray2 = dArray3;
            dArray = dArray4;
        }
        return new SimpleTerm(expression, new DJCDomain(dArray2, dArray, nArray2, DJCDomainType.InRange));
    }

    public static SimpleTerm term(Variable variable, RangeDomain rangeDomain) {
        return DJC.term(variable.asExpr(), rangeDomain);
    }

    public static SimpleTerm term(ExprRangeDomain exprRangeDomain) {
        return DJC.term(exprRangeDomain.expr, exprRangeDomain.dom);
    }

    public static SimpleTerm term(Expression expression, LinearDomain linearDomain) {
        double[] dArray;
        int n;
        int n2;
        if (linearDomain.sparsity != null) {
            throw new DomainError("Sparse domain is not acceptable in disjunctive constraints");
        }
        if (linearDomain.cardinal_flag) {
            throw new DomainError("Integer domain is not acceptable in disjunctive constraints");
        }
        double[] dArray2 = linearDomain.bnd;
        int[] nArray = expression.getShape();
        long l = expression.getSize();
        int[] nArray2 = linearDomain.shape;
        if (nArray2 == null) {
            nArray2 = nArray;
        } else {
            if (nArray2.length != nArray.length) {
                throw new DomainError("Mismatching shapes");
            }
            n2 = 0;
            n = nArray2.length;
            for (int i = n2; i < n; ++i) {
                if (nArray2[i] == nArray[i]) continue;
                throw new DomainError("Mismatching shapes");
            }
        }
        if (linearDomain.bnd == null) {
            dArray = new double[(int)l];
        } else if (linearDomain.scalable) {
            n2 = 0;
            n = 0;
            long l2 = l;
            long l3 = (long)n < l2 ? l2 - (long)n : 0L;
            double[] dArray3 = new double[(int)l3];
            long l4 = n;
            int n3 = 0;
            while ((long)n3 < l3) {
                dArray3[n2] = dArray2[0];
                ++n2;
                ++n3;
                ++l4;
            }
            dArray = dArray3;
        } else {
            dArray = linearDomain.empty ? new double[(int)l] : dArray2;
        }
        if (linearDomain.key == RelationKey.EqualsTo) {
            return new SimpleTerm(expression, new DJCDomain(dArray, null, nArray2, DJCDomainType.EqualTo));
        }
        if (linearDomain.key == RelationKey.LessThan) {
            return new SimpleTerm(expression, new DJCDomain(dArray, null, nArray2, DJCDomainType.LessThan));
        }
        if (linearDomain.key == RelationKey.GreaterThan) {
            return new SimpleTerm(expression, new DJCDomain(dArray, null, nArray2, DJCDomainType.GreaterThan));
        }
        if (linearDomain.key == RelationKey.IsFree) {
            return new SimpleTerm(expression, new DJCDomain(dArray, null, nArray2, DJCDomainType.IsFree));
        }
        throw new UnexpectedError("Invalid linear domain");
    }

    public static SimpleTerm term(ExprLinearDomain exprLinearDomain) {
        return DJC.term(exprLinearDomain.expr, exprLinearDomain.dom);
    }

    public static SimpleTerm term(Variable variable, LinearDomain linearDomain) {
        return DJC.term(variable.asExpr(), linearDomain);
    }
}

