import numpy
import types
import mosek

def _():
  import types

  class Enum:
    @staticmethod
    def __inst(c,name):
      o = c()
      o.name  = name
      o.value = len(c.__members__)
      c.__members__.append(o)
      setattr(c, name, o)

    @classmethod
    def fromInt(c,value):
      return c.members[value]

    @staticmethod
    def new(name,membernames):
      members = []
      c = type(name, (Enum,),{ '__members__' : members })
      for n in membernames:
        Enum.__inst(c,n)
      return c
    @classmethod
    def members(c):
      return iter(c.__members__)

    def __str__(self):
      return self.__class__.__name__ + "." + self.name
    def __repr__(self):
      return self.__class__.__name__ + "." + self.name
  return Enum

class _monty:
  Enum = _()
  @staticmethod
  def deduceShape(l,dim):
    def _deduceShape(l,dim):
      if dim > 1:
        shplst = [ _deduceShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          shplst[0].append(len(l))
          return shplst[0]
        else:
          raise TypeError("Irregular array shape")
      else:
        return [len(dim)]
    return tuple(reversed(_deduceShape(l,dim)))
  @staticmethod
  def checkShape(l,dim):
    def _checkShape(l,dim):
      if dim > 1:
        shplst = [ _checkShape(i,dim-1) for i in l ]
        if all([shplst[0] == i for i in shplst ]):
          pass
        else:
          raise TypeError("Irregular array shape")
        return len(l)
      else:
        try:
          return len(l)
        except TypeError:
          raise TypeError("Wrong or irregular array shape")
    _checkShape(l,dim)
    return dim

  @staticmethod
  def initJaggedArray(data, nd):
    dims = []
    d = data
    for i in range(nd):
      dims.append(len(d))
      d = d[0]

    res = numpy.zeros(dims,dtype=object)
    res.__setitem__(tuple([ slice(d) for d in dims ]), data)

    return res


  @staticmethod
  def makeJaggedArray(src,ndims,dtype):
    if src is None:
      return None
    elif len(ndims) == 1:
      if ndims[0] == 1:
        r = numpy.zeros((len(src),),dtype=dtype)
        r[:] = src
      else:
        d = _monty.deduceDims(src,ndims[0])
        r = numpy.zeros(d,dtype=dtype)
        r.__setitem__(tuple([slice(None)]*ndims[0]),src) # basically: r[:,...,:] = src
      return r
    elif ndims[0] == 1:
      r = numpy.zeros((len(src),),dtype=numpy.dtype(object))
      # Note: This is a bit tricky to do reliably with numpy as it
      # tends to think we are dealing with multidimensional arrays and
      # explode
      for i,s in enumerate(src):
        r[i] = _monty.makeJaggedArray(s,ndims[1:],dtype)

      #r[:] = [ _monty.makeJaggedArray(s,ndims[1:],dtype) for s in src ]
      return r
    else:
      d = _monty.deduceDims(src,ndims[0])
      def _(src,nd):
        if nd == 0:
          return _monty.makeJaggedArray(src)
        else:
          return [ _(s,nd-1) for s in src ]

      r = numpy.zeros(d,dtype=numpy.dtype(object))
      r.__setitem__(tuple([slice(None)]*ndims[0]),_(src,ndims[0])) # basically: r[:,...,:] = convert(src)
      return r

  @staticmethod
  def copyArray(src,dst,dim):
    if dim == 1:
      src[:] = dst[:]
    else:
      for i in range(len(src)):
        _monty.copyArray(src[i],dst[i],dim-1)
  @staticmethod
  def arg_match_sloppy_array(v,elmmatch,dim,l=None):
    if dim == 0:
      elmmatch(v)
    elif dim == 1:
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      for e in v:
        if not elmmatch(e): return False
      return True
    elif isinstance(v,list) or isinstance(v,numpy.ndarray):
      if l is not None:
        if l != len(v): return False
      elif len(v) == 0: return True
      elif not (isinstance(v[0],list) or isinstance(v[0],numpy.ndarray)): return False

      top_len = len(v[0])
      for e in v:
        if not _monty.arg_match_sloppy_array(e,elmmatch,dim-1,top_len): return False
      return True
    else:
      return False

del _

mosek_fusion_RelationKey=_monty.Enum.new('RelationKey',['EqualsTo','LessThan','GreaterThan','IsFree','InRange'])
mosek_fusion_PSDKey=_monty.Enum.new('PSDKey',['IsSymPSD','IsTrilPSD'])
mosek_fusion_QConeKey=_monty.Enum.new('QConeKey',['InQCone','InRotatedQCone','InPExpCone','InPPowCone','InDExpCone','InDPowCone','InPGeoMeanCone','InDGeoMeanCone','Positive','Negative','Unbounded','Zero','InPSDCone','InSVecPSDCone'])
mosek_fusion_ObjectiveSense=_monty.Enum.new('ObjectiveSense',['Undefined','Minimize','Maximize'])
mosek_fusion_SolutionStatus=_monty.Enum.new('SolutionStatus',['Undefined','Unknown','Optimal','Feasible','Certificate','IllposedCert'])
mosek_fusion_AccSolutionStatus=_monty.Enum.new('AccSolutionStatus',['Anything','Optimal','Feasible','Certificate'])
mosek_fusion_ProblemStatus=_monty.Enum.new('ProblemStatus',['Unknown','PrimalAndDualFeasible','PrimalFeasible','DualFeasible','PrimalInfeasible','DualInfeasible','PrimalAndDualInfeasible','IllPosed','PrimalInfeasibleOrUnbounded'])
mosek_fusion_SolverStatus=_monty.Enum.new('SolverStatus',['OK','Error','LostRace'])
mosek_fusion_SolutionType=_monty.Enum.new('SolutionType',['Default','Basic','Interior','Integer'])
mosek_fusion_StatusKey=_monty.Enum.new('StatusKey',['Unknown','Basic','SuperBasic','OnBound','Infinity'])
mosek_fusion_DJCDomainType=_monty.Enum.new('DJCDomainType',['EqualTo','LessThan','GreaterThan','IsFree','InRange','InQCone','InRotatedQCone','InPExpCone','InPPowCone','InDExpCone','InDPowCone','InOneNormCone','InInfNormCone','InPGeoMeanCone','InDGeoMeanCone','InPSDCone'])
#BEFORE CLASS
def __mk_mosek_fusion_ExprDomain():
 class ExprDomain:
  def toDJCTerm(self,*args):
    if False: pass
    elif mosek_fusion_ExprDomain._match_toDJCTerm_(*args):
      return self._toDJCTerm_(*args)
    elif mosek_fusion_ExprDomain._match_alt_toDJCTerm_(*args):
      return self._toDJCTerm_alt_(*args)
    else:
      raise ValueError('Invalid argument list toDJCTerm('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ExprDomain.toDJCTerm()')
  def __repr__(self): return 'mosek.fusion.ExprDomain'
  @staticmethod
  def _match_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  def _toDJCTerm_alt_(self,):
    return self._toDJCTerm_()
  def _toDJCTerm_(self,):
   pass
 return ExprDomain
mosek_fusion_ExprDomain=__mk_mosek_fusion_ExprDomain()
del __mk_mosek_fusion_ExprDomain
#BEFORE CLASS
def __mk_mosek_fusion_Expression():
 class Expression:
  def getSize(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Expression._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getSize()')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Expression._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Expression._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Expression._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.index(int32)\n\tmosek.fusion.Expression.index(array(int32,ndim=1))')
  def getDim(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_Expression._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getDim(int32)')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Expression._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Expression._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.pick(array(int32,ndim=1))\n\tmosek.fusion.Expression.pick(array(int32,ndim=2))')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Expression._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Expression._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Expression._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.slice(int32,int32)\n\tmosek.fusion.Expression.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Expression._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getShape()')
  def eval(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_Expression._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    else:
      raise ValueError('Invalid argument list eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)')
  def getND(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Expression._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.getND()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Expression._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Expression._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Expression.toString()')
  def __repr__(self): return 'mosek.fusion.Expression'
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_0)
   return _1_res
  def _pick__3_5I(self,_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_2))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_2))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_t__0,_t__1,_t__2):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(_0,_1,_2)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getDim_alt_I(self,_t__0):
    return self._getDim_I(numpy.int32(__0))
  def _getDim_I(self,_0):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
 return Expression
mosek_fusion_Expression=__mk_mosek_fusion_Expression()
del __mk_mosek_fusion_Expression
#BEFORE CLASS
def __mk_mosek_fusion_Variable():
 class Variable(mosek_fusion_Expression):
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Variable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Variable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Variable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_Variable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_Variable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_Variable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_Variable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.index(int32)\n\tmosek.fusion.Variable.index(array(int32,ndim=1))\n\tmosek.fusion.Variable.index(int32,int32)\n\tmosek.fusion.Variable.index(int32,int32,int32)')
  def setLevel(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_setLevel__3D(*args):
      return self._setLevel__3D(*args)
    elif mosek_fusion_Variable._match_alt_setLevel__3D(*args):
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.setLevel(array(double,ndim=1))')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_Variable._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getModel()')
  def makeInteger(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_makeInteger_(*args):
      return self._makeInteger_(*args)
    elif mosek_fusion_Variable._match_alt_makeInteger_(*args):
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeInteger()')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_Variable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.dual()')
  def antidiag(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_Variable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_Variable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.antidiag()\n\tmosek.fusion.Variable.antidiag(int32)')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Variable._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getShape()')
  def fromTril(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_fromTril_I(*args):
      return self._fromTril_I(*args)
    elif mosek_fusion_Variable._match_alt_fromTril_I(*args):
      return self._fromTril_alt_I(*args)
    else:
      raise ValueError('Invalid argument list fromTril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.fromTril(int32)')
  def tril(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_tril_(*args):
      return self._tril_(*args)
    elif mosek_fusion_Variable._match_alt_tril_(*args):
      return self._tril_alt_(*args)
    else:
      raise ValueError('Invalid argument list tril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.tril()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_Variable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_continuous()')
  def getND(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Variable._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getND()')
  def diag(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_Variable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_Variable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_Variable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.diag()\n\tmosek.fusion.Variable.diag(int32)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_Variable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.make_integer()')
  def makeContinuous(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_makeContinuous_(*args):
      return self._makeContinuous_(*args)
    elif mosek_fusion_Variable._match_alt_makeContinuous_(*args):
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.makeContinuous()')
  def getSize(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Variable._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.getSize()')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_Variable._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.level()')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_Variable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.set_values(array(double,ndim=1),bool)')
  def reshape(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_Variable._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    elif mosek_fusion_Variable._match_reshape_I(*args):
      return self._reshape_I(*args)
    elif mosek_fusion_Variable._match_alt_reshape_I(*args):
      return self._reshape_alt_I(*args)
    elif mosek_fusion_Variable._match_reshape_II(*args):
      return self._reshape_II(*args)
    elif mosek_fusion_Variable._match_alt_reshape_II(*args):
      return self._reshape_alt_II(*args)
    elif mosek_fusion_Variable._match_reshape_III(*args):
      return self._reshape_III(*args)
    elif mosek_fusion_Variable._match_alt_reshape_III(*args):
      return self._reshape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.reshape(array(int32,ndim=1))\n\tmosek.fusion.Variable.reshape(int32)\n\tmosek.fusion.Variable.reshape(int32,int32)\n\tmosek.fusion.Variable.reshape(int32,int32,int32)')
  def remove(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_Variable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.remove()')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Variable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_Variable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.pick(array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=2))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Variable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_Variable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_Variable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_Variable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.Variable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Variable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Variable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Variable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.slice(int32,int32)\n\tmosek.fusion.Variable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_Variable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.transpose()')
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_Variable._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.asExpr()')
  def numInst(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_Variable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.numInst()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Variable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.toString()')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_Variable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_Variable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Variable.values(int32,array(double,ndim=1),bool)')
  def __repr__(self): return 'mosek.fusion.Variable'
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   pass
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   pass
  @staticmethod
  def _match_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1) and __arg_match_I__(_2) and __arg_match__3J__(_3))
  @staticmethod
  def _match_alt_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match__3J__(_3))
  def _inst_alt_I_3JI_3J(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3JI_3J(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3JI_3J(self,_0,_1,_2,_3):
   pass
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1))
  def _inst_alt_I_3J(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_0,_1):
   pass
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _setLevel_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setLevel__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setLevel__3D(self,_0):
   pass
  @staticmethod
  def _match_fromTril_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_fromTril_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _fromTril_alt_I(self,_t__0):
    return self._fromTril_I(numpy.int32(__0))
  def _fromTril_I(self,_0):
   pass
  @staticmethod
  def _match_tril_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_tril_(*args):
    if len(args) != 0: return False
    return True
  def _tril_alt_(self,):
    return self._tril_()
  def _tril_(self,):
   pass
  @staticmethod
  def _match_reshape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_reshape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _reshape_alt_III(self,_t__0,_t__1,_t__2):
    return self._reshape_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _reshape_III(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_reshape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_reshape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _reshape_alt_II(self,_t__0,_t__1):
    return self._reshape_II(numpy.int32(__0),numpy.int32(__1))
  def _reshape_II(self,_0,_1):
   pass
  @staticmethod
  def _match_reshape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_reshape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _reshape_alt_I(self,_t__0):
    return self._reshape_I(numpy.int32(__0))
  def _reshape_I(self,_0):
   pass
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _reshape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_0):
   pass
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_Z__(_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_Z__(_1))
  def _set_1values_alt__3DZ(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=_t__1
   _1_res = self._set_1values__3DZ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_0,_1):
   pass
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   pass
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _values_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1_res = self._values_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   pass
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   pass
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   pass
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   pass
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   pass
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  def _pick_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _pick_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_0)
   return _1_res
  def _pick__3_5I(self,_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_0):
   pass
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   pass
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _antidiag_alt_I(self,_t__0):
    return self._antidiag_I(numpy.int32(__0))
  def _antidiag_I(self,_0):
   pass
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   pass
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _diag_alt_I(self,_t__0):
    return self._diag_I(numpy.int32(__0))
  def _diag_I(self,_0):
   pass
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   pass
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _index_alt_III(self,_t__0,_t__1,_t__2):
    return self._index_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _index_III(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _index_alt_II(self,_t__0,_t__1):
    return self._index_II(numpy.int32(__0),numpy.int32(__1))
  def _index_II(self,_0,_1):
   pass
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   pass
 return Variable
mosek_fusion_Variable=__mk_mosek_fusion_Variable()
del __mk_mosek_fusion_Variable
#BEFORE CLASS
def __mk_mosek_fusion_Parameter():
 class Parameter(mosek_fusion_Expression):
  def getSp(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getSp__3JI(*args):
      return self._getSp__3JI(*args)
    elif mosek_fusion_Parameter._match_alt_getSp__3JI(*args):
      return self._getSp_alt__3JI(*args)
    else:
      raise ValueError('Invalid argument list getSp('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getSp(array(int64,ndim=1),int32)')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Parameter._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getShape()')
  def isSparse(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_isSparse_(*args):
      return self._isSparse_(*args)
    elif mosek_fusion_Parameter._match_alt_isSparse_(*args):
      return self._isSparse_alt_(*args)
    else:
      raise ValueError('Invalid argument list isSparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.isSparse()')
  def getNumNonzero(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getNumNonzero_(*args):
      return self._getNumNonzero_(*args)
    elif mosek_fusion_Parameter._match_alt_getNumNonzero_(*args):
      return self._getNumNonzero_alt_(*args)
    else:
      raise ValueError('Invalid argument list getNumNonzero('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getNumNonzero()')
  def clone(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_clone_Lmosek_4fusion_4Model_2(*args):
      return self._clone_Lmosek_4fusion_4Model_2(*args)
    elif mosek_fusion_Parameter._match_alt_clone_Lmosek_4fusion_4Model_2(*args):
      return self._clone_alt_Lmosek_4fusion_4Model_2(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.clone(mosek.fusion.Model)')
  def getDim(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_Parameter._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getDim(int32)')
  def reshape(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_Parameter._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.reshape(array(int32,ndim=1))')
  def getSize(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Parameter._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getSize()')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_Parameter._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_Parameter._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_Parameter._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.pick(array(int32,ndim=1))\n\tmosek.fusion.Parameter.pick(array(int32,ndim=2))')
  def setValue(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_setValue_D(*args):
      return self._setValue_D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue_D(*args):
      return self._setValue_alt_D(*args)
    elif mosek_fusion_Parameter._match_setValue__3D(*args):
      return self._setValue__3D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue__3D(*args):
      return self._setValue_alt__3D(*args)
    elif mosek_fusion_Parameter._match_setValue__3_5D(*args):
      return self._setValue__3_5D(*args)
    elif mosek_fusion_Parameter._match_alt_setValue__3_5D(*args):
      return self._setValue_alt__3_5D(*args)
    else:
      raise ValueError('Invalid argument list setValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.setValue(double)\n\tmosek.fusion.Parameter.setValue(array(double,ndim=1))\n\tmosek.fusion.Parameter.setValue(array(double,ndim=2))')
  def getND(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Parameter._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getND()')
  def getAllIndexes(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getAllIndexes__3II(*args):
      return self._getAllIndexes__3II(*args)
    elif mosek_fusion_Parameter._match_alt_getAllIndexes__3II(*args):
      return self._getAllIndexes_alt__3II(*args)
    else:
      raise ValueError('Invalid argument list getAllIndexes('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getAllIndexes(array(int32,ndim=1),int32)')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_Parameter._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getModel()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Parameter._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Parameter._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Parameter._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.slice(int32,int32)\n\tmosek.fusion.Parameter.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def getValue(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getValue_(*args):
      return self._getValue_(*args)
    elif mosek_fusion_Parameter._match_alt_getValue_(*args):
      return self._getValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list getValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getValue()')
  def getIndex(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_getIndex_I(*args):
      return self._getIndex_I(*args)
    elif mosek_fusion_Parameter._match_alt_getIndex_I(*args):
      return self._getIndex_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getIndex('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.getIndex(int32)')
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_Parameter._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_Parameter._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Parameter.asExpr()')
  def __repr__(self): return 'mosek.fusion.Parameter'
  @staticmethod
  def _match_clone_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(_0))
  @staticmethod
  def _match_alt_clone_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(_0))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   pass
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   pass
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   pass
  @staticmethod
  def _match_getAllIndexes__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_getAllIndexes__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_I__(_1))
  def _getAllIndexes_alt__3II(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _1_res = self._getAllIndexes__3II(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getAllIndexes__3II(self,_0,_1):
   pass
  @staticmethod
  def _match_getIndex_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getIndex_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getIndex_alt_I(self,_t__0):
    return self._getIndex_I(numpy.int32(__0))
  def _getIndex_I(self,_0):
   pass
  @staticmethod
  def _match_getSp__3JI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_getSp__3JI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1))
  def _getSp_alt__3JI(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _1_res = self._getSp__3JI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getSp__3JI(self,_0,_1):
   pass
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   pass
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   pass
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getDim_alt_I(self,_t__0):
    return self._getDim_I(numpy.int32(__0))
  def _getDim_I(self,_0):
   pass
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_0)
   return _1_res
  def _pick__3_5I(self,_0):
   pass
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_0):
   pass
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   pass
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   pass
  @staticmethod
  def _match_isSparse_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_isSparse_(*args):
    if len(args) != 0: return False
    return True
  def _isSparse_alt_(self,):
    return self._isSparse_()
  def _isSparse_(self,):
   pass
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _reshape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_0):
   pass
  @staticmethod
  def _match_getNumNonzero_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getNumNonzero_(*args):
    if len(args) != 0: return False
    return True
  def _getNumNonzero_alt_(self,):
    return self._getNumNonzero_()
  def _getNumNonzero_(self,):
   pass
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   pass
  @staticmethod
  def _match_getValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getValue_(*args):
    if len(args) != 0: return False
    return True
  def _getValue_alt_(self,):
    return self._getValue_()
  def _getValue_(self,):
   pass
  @staticmethod
  def _match_setValue__3_5D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5D__(_0))
  @staticmethod
  def _match_alt_setValue__3_5D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5D__(_0))
  def _setValue_alt__3_5D(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.float64))
   _1_res = self._setValue__3_5D(_0)
   return _1_res
  def _setValue__3_5D(self,_0):
   pass
  @staticmethod
  def _match_setValue__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_setValue__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _setValue_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setValue__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setValue__3D(self,_0):
   pass
  @staticmethod
  def _match_setValue_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_setValue_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  def _setValue_alt_D(self,_t__0):
    return self._setValue_D(numpy.float64(__0))
  def _setValue_D(self,_0):
   pass
 return Parameter
mosek_fusion_Parameter=__mk_mosek_fusion_Parameter()
del __mk_mosek_fusion_Parameter
#BEFORE CLASS
def __mk_mosek_fusion_FusionException():
 class FusionException(Exception):
  __slots__ = ['_FusionException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionException.ctor(string)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_FusionException._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_FusionException._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionException.toString()')
  def __repr__(self): return 'mosek.fusion.FusionException'
  @staticmethod
  def _ctor_S(msg_):
    o = FusionException.__new__(FusionException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionException
mosek_fusion_FusionException=__mk_mosek_fusion_FusionException()
del __mk_mosek_fusion_FusionException
#BEFORE CLASS
def __mk_mosek_fusion_SolutionError():
 class SolutionError(mosek_fusion_FusionException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionError.ctor()\n\tmosek.fusion.SolutionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SolutionError'
  @staticmethod
  def _ctor_():
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionException._ctor_init_S(self,"Solution is invalid or undefined")
  @staticmethod
  def _ctor_S(msg):
    o = SolutionError.__new__(SolutionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionException._ctor_init_S(self,msg)
 return SolutionError
mosek_fusion_SolutionError=__mk_mosek_fusion_SolutionError()
del __mk_mosek_fusion_SolutionError
#BEFORE CLASS
def __mk_mosek_fusion_UnimplementedError():
 class UnimplementedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnimplementedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnimplementedError'
  @staticmethod
  def _ctor_S(msg):
    o = UnimplementedError.__new__(UnimplementedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnimplementedError
mosek_fusion_UnimplementedError=__mk_mosek_fusion_UnimplementedError()
del __mk_mosek_fusion_UnimplementedError
#BEFORE CLASS
def __mk_mosek_fusion_FatalError():
 class FatalError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FatalError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.FatalError'
  @staticmethod
  def _ctor_S(msg):
    o = FatalError.__new__(FatalError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return FatalError
mosek_fusion_FatalError=__mk_mosek_fusion_FatalError()
del __mk_mosek_fusion_FatalError
#BEFORE CLASS
def __mk_mosek_fusion_UnexpectedError():
 class UnexpectedError(Exception):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4FusionException_2(*args):
      self._ctor_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4FusionException_2(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UnexpectedError.ctor(mosek.fusion.FusionException)\n\tmosek.fusion.UnexpectedError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UnexpectedError'
  @staticmethod
  def _ctor_Lmosek_4fusion_4FusionException_2(e):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_Lmosek_4fusion_4FusionException_2(e)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_match_Lmosek_4fusion_4FusionException_2__(e))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4FusionException_2(*args):
    if len(args) != 1: return False
    e, = args
    return (__arg_alt_match_Lmosek_4fusion_4FusionException_2__(e))
  def _ctor_alt_init_Lmosek_4fusion_4FusionException_2(self,e):
    self._ctor_init_Lmosek_4fusion_4FusionException_2(e)
  def _ctor_init_Lmosek_4fusion_4FusionException_2(self,e):
   Exception.__init__(self,e._toString_())
  @staticmethod
  def _ctor_S(msg):
    o = UnexpectedError.__new__(UnexpectedError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   Exception.__init__(self,msg)
 return UnexpectedError
mosek_fusion_UnexpectedError=__mk_mosek_fusion_UnexpectedError()
del __mk_mosek_fusion_UnexpectedError
#BEFORE CLASS
def __mk_mosek_fusion_FusionRuntimeException():
 class FusionRuntimeException(Exception):
  __slots__ = ['_FusionRuntimeException__msg']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.FusionRuntimeException.ctor(string)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_FusionRuntimeException._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_FusionRuntimeException._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.FusionRuntimeException.toString()')
  def __repr__(self): return 'mosek.fusion.FusionRuntimeException'
  @staticmethod
  def _ctor_S(msg_):
    o = FusionRuntimeException.__new__(FusionRuntimeException)
    o._ctor_init_S(msg_)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_match_S__(msg_))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg_, = args
    return (__arg_alt_match_S__(msg_))
  def _ctor_alt_init_S(self,msg_):
    self._ctor_init_S(msg_)
  def _ctor_init_S(self,msg_):
   Exception.__init__(self,msg_)
   self.__msg = msg_
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return (self.__msg)
 return FusionRuntimeException
mosek_fusion_FusionRuntimeException=__mk_mosek_fusion_FusionRuntimeException()
del __mk_mosek_fusion_FusionRuntimeException
#BEFORE CLASS
def __mk_mosek_fusion_SparseFormatError():
 class SparseFormatError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SparseFormatError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SparseFormatError'
  @staticmethod
  def _ctor_S(msg):
    o = SparseFormatError.__new__(SparseFormatError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SparseFormatError
mosek_fusion_SparseFormatError=__mk_mosek_fusion_SparseFormatError()
del __mk_mosek_fusion_SparseFormatError
#BEFORE CLASS
def __mk_mosek_fusion_SliceError():
 class SliceError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SliceError.ctor()\n\tmosek.fusion.SliceError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SliceError'
  @staticmethod
  def _ctor_():
    o = SliceError.__new__(SliceError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,"Invalid slice range")
  @staticmethod
  def _ctor_S(msg):
    o = SliceError.__new__(SliceError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SliceError
mosek_fusion_SliceError=__mk_mosek_fusion_SliceError()
del __mk_mosek_fusion_SliceError
#BEFORE CLASS
def __mk_mosek_fusion_UpdateError():
 class UpdateError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.UpdateError.ctor()\n\tmosek.fusion.UpdateError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.UpdateError'
  @staticmethod
  def _ctor_():
    o = UpdateError.__new__(UpdateError)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,"Cannot update parameterized item")
  @staticmethod
  def _ctor_S(msg):
    o = UpdateError.__new__(UpdateError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return UpdateError
mosek_fusion_UpdateError=__mk_mosek_fusion_UpdateError()
del __mk_mosek_fusion_UpdateError
#BEFORE CLASS
def __mk_mosek_fusion_SetDefinitionError():
 class SetDefinitionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SetDefinitionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.SetDefinitionError'
  @staticmethod
  def _ctor_S(msg):
    o = SetDefinitionError.__new__(SetDefinitionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return SetDefinitionError
mosek_fusion_SetDefinitionError=__mk_mosek_fusion_SetDefinitionError()
del __mk_mosek_fusion_SetDefinitionError
#BEFORE CLASS
def __mk_mosek_fusion_OptimizeError():
 class OptimizeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.OptimizeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.OptimizeError'
  @staticmethod
  def _ctor_S(msg):
    o = OptimizeError.__new__(OptimizeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return OptimizeError
mosek_fusion_OptimizeError=__mk_mosek_fusion_OptimizeError()
del __mk_mosek_fusion_OptimizeError
#BEFORE CLASS
def __mk_mosek_fusion_NameError():
 class NameError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.NameError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.NameError'
  @staticmethod
  def _ctor_S(msg):
    o = NameError.__new__(NameError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return NameError
mosek_fusion_NameError=__mk_mosek_fusion_NameError()
del __mk_mosek_fusion_NameError
#BEFORE CLASS
def __mk_mosek_fusion_DeletionError():
 class DeletionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DeletionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DeletionError'
  @staticmethod
  def _ctor_S(msg):
    o = DeletionError.__new__(DeletionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DeletionError
mosek_fusion_DeletionError=__mk_mosek_fusion_DeletionError()
del __mk_mosek_fusion_DeletionError
#BEFORE CLASS
def __mk_mosek_fusion_ModelError():
 class ModelError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ModelError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ModelError'
  @staticmethod
  def _ctor_S(msg):
    o = ModelError.__new__(ModelError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ModelError
mosek_fusion_ModelError=__mk_mosek_fusion_ModelError()
del __mk_mosek_fusion_ModelError
#BEFORE CLASS
def __mk_mosek_fusion_MatrixError():
 class MatrixError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.MatrixError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.MatrixError'
  @staticmethod
  def _ctor_S(msg):
    o = MatrixError.__new__(MatrixError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return MatrixError
mosek_fusion_MatrixError=__mk_mosek_fusion_MatrixError()
del __mk_mosek_fusion_MatrixError
#BEFORE CLASS
def __mk_mosek_fusion_DimensionError():
 class DimensionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DimensionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DimensionError'
  @staticmethod
  def _ctor_S(msg):
    o = DimensionError.__new__(DimensionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DimensionError
mosek_fusion_DimensionError=__mk_mosek_fusion_DimensionError()
del __mk_mosek_fusion_DimensionError
#BEFORE CLASS
def __mk_mosek_fusion_LengthError():
 class LengthError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.LengthError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.LengthError'
  @staticmethod
  def _ctor_S(msg):
    o = LengthError.__new__(LengthError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return LengthError
mosek_fusion_LengthError=__mk_mosek_fusion_LengthError()
del __mk_mosek_fusion_LengthError
#BEFORE CLASS
def __mk_mosek_fusion_RangeError():
 class RangeError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RangeError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.RangeError'
  @staticmethod
  def _ctor_S(msg):
    o = RangeError.__new__(RangeError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return RangeError
mosek_fusion_RangeError=__mk_mosek_fusion_RangeError()
del __mk_mosek_fusion_RangeError
#BEFORE CLASS
def __mk_mosek_fusion_IndexError():
 class IndexError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IndexError'
  @staticmethod
  def _ctor_S(msg):
    o = IndexError.__new__(IndexError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IndexError
mosek_fusion_IndexError=__mk_mosek_fusion_IndexError()
del __mk_mosek_fusion_IndexError
#BEFORE CLASS
def __mk_mosek_fusion_DomainError():
 class DomainError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DomainError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.DomainError'
  @staticmethod
  def _ctor_S(msg):
    o = DomainError.__new__(DomainError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return DomainError
mosek_fusion_DomainError=__mk_mosek_fusion_DomainError()
del __mk_mosek_fusion_DomainError
#BEFORE CLASS
def __mk_mosek_fusion_ValueConversionError():
 class ValueConversionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ValueConversionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ValueConversionError'
  @staticmethod
  def _ctor_S(msg):
    o = ValueConversionError.__new__(ValueConversionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ValueConversionError
mosek_fusion_ValueConversionError=__mk_mosek_fusion_ValueConversionError()
del __mk_mosek_fusion_ValueConversionError
#BEFORE CLASS
def __mk_mosek_fusion_ParameterError():
 class ParameterError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ParameterError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ParameterError'
  @staticmethod
  def _ctor_S(msg):
    o = ParameterError.__new__(ParameterError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ParameterError
mosek_fusion_ParameterError=__mk_mosek_fusion_ParameterError()
del __mk_mosek_fusion_ParameterError
#BEFORE CLASS
def __mk_mosek_fusion_ExpressionError():
 class ExpressionError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.ExpressionError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.ExpressionError'
  @staticmethod
  def _ctor_S(msg):
    o = ExpressionError.__new__(ExpressionError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return ExpressionError
mosek_fusion_ExpressionError=__mk_mosek_fusion_ExpressionError()
del __mk_mosek_fusion_ExpressionError
#BEFORE CLASS
def __mk_mosek_fusion_IOError():
 class IOError(mosek_fusion_FusionRuntimeException):
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IOError.ctor(string)')
  def __repr__(self): return 'mosek.fusion.IOError'
  @staticmethod
  def _ctor_S(msg):
    o = IOError.__new__(IOError)
    o._ctor_init_S(msg)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_match_S__(msg))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    msg, = args
    return (__arg_alt_match_S__(msg))
  def _ctor_alt_init_S(self,msg):
    self._ctor_init_S(msg)
  def _ctor_init_S(self,msg):
   mosek_fusion_FusionRuntimeException._ctor_init_S(self,msg)
 return IOError
mosek_fusion_IOError=__mk_mosek_fusion_IOError()
del __mk_mosek_fusion_IOError
#BEFORE CLASS
def __mk_mosek_fusion_Disjunction():
 class Disjunction(object):
  __slots__ = ['_Disjunction__id']
  def __repr__(self): return 'mosek.fusion.Disjunction'
  @staticmethod
  def _ctor_J(id):
    o = Disjunction.__new__(Disjunction)
    o._ctor_init_J(id)
    return o
  @staticmethod
  def __match_ctor_J(*args):
    if len(args) != 1: return False
    id, = args
    return (__arg_match_J__(id))
  @staticmethod
  def __match_alt_ctor_J(*args):
    if len(args) != 1: return False
    id, = args
    return (__arg_alt_match_J__(id))
  def _ctor_alt_init_J(self,id):
    self._ctor_init_J(numpy.int64(id))
  def _ctor_init_J(self,id):
   (self.__id) = id
 return Disjunction
mosek_fusion_Disjunction=__mk_mosek_fusion_Disjunction()
del __mk_mosek_fusion_Disjunction
#BEFORE CLASS
def __mk_mosek_fusion_DisjunctionTerms():
 class DisjunctionTerms(object):
  __slots__ = ['_terms']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3Lmosek_4fusion_4Term_2(*args):
      self._ctor_init__3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor__3Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init__3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
      self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.DisjunctionTerms.ctor(array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.Term)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DisjunctionTerms.ctor(mosek.fusion.DisjunctionTerms,mosek.fusion.DisjunctionTerms)')
  def __repr__(self): return 'mosek.fusion.DisjunctionTerms'
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(self,terms1,term):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(terms1,term)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprRangeDomain_2(self,terms1,term):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,terms1,mosek.fusion.DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(term))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    terms1,term, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(self,terms1,term):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(terms1,term)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4ExprLinearDomain_2(self,terms1,term):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,terms1,mosek.fusion.DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(term))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    terms1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    terms1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(terms1) and __arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(self,terms1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(terms1,term2)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4DisjunctionTerms_2(self,terms1,term2):
   mosek_fusion_DisjunctionTerms._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,terms1,(term2._terms))
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_match__3Lmosek_4fusion_4Term_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_alt_match__3Lmosek_4fusion_4Term_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,term1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(term1,numpy.array(term2,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2_3Lmosek_4fusion_4Term_2(self,term1,term2):
   _0=int(((term1._terms)).shape[0])
   self._terms = numpy.zeros(((int(((term1._terms)).shape[0]) + int((term2).shape[0])),), dtype=numpy.dtype(object))
   _1=0
   while (_1 < int(((term1._terms)).shape[0])):
    self._terms[_1] = (term1._terms)[_1]
    _1 += 1
   _2=0
   while (_2 < int((term2).shape[0])):
    self._terms[(_2 + _0)] = term2[_2]
    _2 += 1
  @staticmethod
  def _ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_match_Lmosek_4fusion_4Term_2__(term2))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    term1,term2, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(term1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(term2))
  def _ctor_alt_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,term1,term2):
    self._ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(term1,term2)
  def _ctor_init_Lmosek_4fusion_4DisjunctionTerms_2Lmosek_4fusion_4Term_2(self,term1,term2):
   self._terms = numpy.zeros(((int(((term1._terms)).shape[0]) + 1),), dtype=numpy.dtype(object))
   _0=0
   while (_0 < int(((term1._terms)).shape[0])):
    self._terms[_0] = (term1._terms)[_0]
    _0 += 1
   self._terms[int(((term1._terms)).shape[0])] = term2
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Term_2(terms):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init__3Lmosek_4fusion_4Term_2(terms)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    terms, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(terms))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    terms, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(terms))
  def _ctor_alt_init__3Lmosek_4fusion_4Term_2(self,terms):
    self._ctor_init__3Lmosek_4fusion_4Term_2(numpy.array(terms,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4Term_2(self,terms):
   (self._terms) = numpy.array([terms[_0] for _0 in range(0,int((terms).shape[0]))], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor_Lmosek_4fusion_4ExprRangeDomain_2(term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4ExprRangeDomain_2(self,term):
    self._ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(term)
  def _ctor_init_Lmosek_4fusion_4ExprRangeDomain_2(self,term):
   self._terms = numpy.array([mosek.fusion.DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(term)], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor_Lmosek_4fusion_4ExprLinearDomain_2(term):
    o = DisjunctionTerms.__new__(DisjunctionTerms)
    o._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(term)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    term, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(term))
  def _ctor_alt_init_Lmosek_4fusion_4ExprLinearDomain_2(self,term):
    self._ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(term)
  def _ctor_init_Lmosek_4fusion_4ExprLinearDomain_2(self,term):
   self._terms = numpy.array([mosek.fusion.DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(term)], dtype=numpy.dtype(object))
 return DisjunctionTerms
mosek_fusion_DisjunctionTerms=__mk_mosek_fusion_DisjunctionTerms()
del __mk_mosek_fusion_DisjunctionTerms
#BEFORE CLASS
def __mk_mosek_fusion_Term():
 class Term(mosek_fusion_ExprDomain,object):
  __slots__ = ['_domains','_exprs']
  def toDJCTerm(self,*args):
    if False: pass
    elif mosek_fusion_Term._match_toDJCTerm_(*args):
      return self._toDJCTerm_(*args)
    elif mosek_fusion_Term._match_alt_toDJCTerm_(*args):
      return self._toDJCTerm_alt_(*args)
    else:
      raise ValueError('Invalid argument list toDJCTerm('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Term.toDJCTerm()')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_Term._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_Term._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Term.size()')
  def __repr__(self): return 'mosek.fusion.Term'
  @staticmethod
  def _ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(elist,dlist):
    o = Term.__new__(Term)
    o._ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(elist,dlist)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    elist,dlist, = args
    return (__arg_match__3Lmosek_4fusion_4Expression_2__(elist) and __arg_match__3Lmosek_4fusion_4DJCDomain_2__(dlist))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    elist,dlist, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Expression_2__(elist) and __arg_alt_match__3Lmosek_4fusion_4DJCDomain_2__(dlist))
  def _ctor_alt_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(self,elist,dlist):
    self._ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(numpy.array(elist,dtype=numpy.dtype(object)),numpy.array(dlist,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(self,elist,dlist):
   _0=int((elist).shape[0])
   self._exprs = numpy.ndarray((_0,), dtype=numpy.dtype(object))
   self._domains = numpy.ndarray((_0,), dtype=numpy.dtype(object))
   for _1 in range(0,_0):
    self._exprs[_1] = elist[_1]
    self._domains[_1] = dlist[_1]
  @staticmethod
  def _ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d):
    o = Term.__new__(Term)
    o._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(e) and __arg_match_Lmosek_4fusion_4DJCDomain_2__(d))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(e) and __arg_alt_match_Lmosek_4fusion_4DJCDomain_2__(d))
  def _ctor_alt_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
    self._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
  def _ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
   self._exprs = numpy.array([e], dtype=numpy.dtype(object))
   self._domains = numpy.array([d], dtype=numpy.dtype(object))
  @staticmethod
  def _ctor__3Lmosek_4fusion_4SimpleTerm_2(t):
    o = Term.__new__(Term)
    o._ctor_init__3Lmosek_4fusion_4SimpleTerm_2(t)
    return o
  @staticmethod
  def __match_ctor__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    t, = args
    return (__arg_match__3Lmosek_4fusion_4SimpleTerm_2__(t))
  @staticmethod
  def __match_alt_ctor__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    t, = args
    return (__arg_alt_match__3Lmosek_4fusion_4SimpleTerm_2__(t))
  def _ctor_alt_init__3Lmosek_4fusion_4SimpleTerm_2(self,t):
    self._ctor_init__3Lmosek_4fusion_4SimpleTerm_2(numpy.array(t,dtype=numpy.dtype(object)))
  def _ctor_init__3Lmosek_4fusion_4SimpleTerm_2(self,t):
   _0=int((t).shape[0])
   self._exprs = numpy.ndarray((_0,), dtype=numpy.dtype(object))
   self._domains = numpy.ndarray((_0,), dtype=numpy.dtype(object))
   for _1 in range(0,_0):
    self._exprs[_1] = (t[_1]._exprs)[0]
    self._domains[_1] = (t[_1]._domains)[0]
  def _numaccterms_alt_(self,):
    return self._numaccterms_()
  def _numaccterms_(self,):
   _0=0
   for _1 in range(0,int((self._domains).shape[0])):
    _0 += self._domains[_1]._numaccterms_()
   return numpy.int32(_0)
  def _numaccrows_alt_(self,):
    return self._numaccrows_()
  def _numaccrows_(self,):
   _0=0
   for _1 in range(0,int((self._domains).shape[0])):
    _0 += self._domains[_1]._numaccrows_()
   return numpy.int32(_0)
  def _num_alt_(self,):
    return self._num_()
  def _num_(self,):
   return numpy.int32(int((self._domains).shape[0]))
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _0=0
   for _1 in range(0,int((self._domains).shape[0])):
    _0 += self._domains[_1]._size_()
   return numpy.int32(_0)
  @staticmethod
  def _match_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toDJCTerm_(*args):
    if len(args) != 0: return False
    return True
  def _toDJCTerm_alt_(self,):
    return self._toDJCTerm_()
  def _toDJCTerm_(self,):
   return (self)
 return Term
mosek_fusion_Term=__mk_mosek_fusion_Term()
del __mk_mosek_fusion_Term
#BEFORE CLASS
def __mk_mosek_fusion_SimpleTerm():
 class SimpleTerm(mosek_fusion_Term):
  def __repr__(self): return 'mosek.fusion.SimpleTerm'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d):
    o = SimpleTerm.__new__(SimpleTerm)
    o._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(e) and __arg_match_Lmosek_4fusion_4DJCDomain_2__(d))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(*args):
    if len(args) != 2: return False
    e,d, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(e) and __arg_alt_match_Lmosek_4fusion_4DJCDomain_2__(d))
  def _ctor_alt_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
    self._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(e,d)
  def _ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d):
   mosek_fusion_Term._ctor_init_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(self,e,d)
 return SimpleTerm
mosek_fusion_SimpleTerm=__mk_mosek_fusion_SimpleTerm()
del __mk_mosek_fusion_SimpleTerm
#BEFORE CLASS
def __mk_mosek_fusion_DJCDomain():
 class DJCDomain(object):
  __slots__ = ['dom','conedim','shape','par','b']
  def size(self,*args):
    if False: pass
    elif mosek_fusion_DJCDomain._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_DJCDomain._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJCDomain.size()')
  def __repr__(self): return 'mosek.fusion.DJCDomain'
  @staticmethod
  def _ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,dom_):
    o = DJCDomain.__new__(DJCDomain)
    o._ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,dom_)
    return o
  @staticmethod
  def __match_ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 4: return False
    b_,par_,shape_,dom_, = args
    return (__arg_match__3D__(b_) and __arg_match__3D__(par_) and __arg_match__3I__(shape_) and __arg_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  @staticmethod
  def __match_alt_ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 4: return False
    b_,par_,shape_,dom_, = args
    return (__arg_alt_match__3D__(b_) and __arg_alt_match__3D__(par_) and __arg_alt_match__3I__(shape_) and __arg_alt_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  def _ctor_alt_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,dom_):
    self._ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(numpy.array(b_,dtype=numpy.dtype(numpy.float64)),numpy.array(par_,dtype=numpy.dtype(numpy.float64)),numpy.array(shape_,dtype=numpy.dtype(numpy.int32)),dom_)
  def _ctor_init__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,dom_):
   self.b = b_
   self.par = par_
   self.shape = shape_
   self.dom = dom_
   self.conedim = (int((shape_).shape[0]) - 1)
  @staticmethod
  def _ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,conedim_,dom_):
    o = DJCDomain.__new__(DJCDomain)
    o._ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(b_,par_,shape_,conedim_,dom_)
    return o
  @staticmethod
  def __match_ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 5: return False
    b_,par_,shape_,conedim_,dom_, = args
    return (__arg_match__3D__(b_) and __arg_match__3D__(par_) and __arg_match__3I__(shape_) and __arg_match_I__(conedim_) and __arg_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  @staticmethod
  def __match_alt_ctor__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(*args):
    if len(args) != 5: return False
    b_,par_,shape_,conedim_,dom_, = args
    return (__arg_alt_match__3D__(b_) and __arg_alt_match__3D__(par_) and __arg_alt_match__3I__(shape_) and __arg_alt_match_I__(conedim_) and __arg_alt_match_Emosek_4fusion_4DJCDomainType_2__(dom_))
  def _ctor_alt_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,conedim_,dom_):
    self._ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(numpy.array(b_,dtype=numpy.dtype(numpy.float64)),numpy.array(par_,dtype=numpy.dtype(numpy.float64)),numpy.array(shape_,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim_),dom_)
  def _ctor_init__3D_3D_3IIEmosek_4fusion_4DJCDomainType_2(self,b_,par_,shape_,conedim_,dom_):
   self.b = b_
   self.par = par_
   self.shape = shape_
   self.dom = dom_
   self.conedim = conedim_
  def _numaccterms_alt_(self,):
    return self._numaccterms_()
  def _numaccterms_(self,):
   if (self.dom==mosek.fusion.DJCDomainType.InRange):
    return numpy.int32(2)
   else:
    return numpy.int32(1)
  def _numaccrows_alt_(self,):
    return self._numaccrows_()
  def _numaccrows_(self,):
   if (self.dom==mosek.fusion.DJCDomainType.InRange):
    return numpy.int32((self._size_() * 2))
   else:
    return numpy.int32(self._size_())
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _0=1
   _0 = fragments._c_closure_0(_0,self.shape)
   _0 = numpy.int32(_0) # postprocess
   return numpy.int32(_0)
 return DJCDomain
mosek_fusion_DJCDomain=__mk_mosek_fusion_DJCDomain()
del __mk_mosek_fusion_DJCDomain
#BEFORE CLASS
def __mk_mosek_fusion_DJC():
 class DJC(object):
  @staticmethod
  def ANDFromTerms(*args):
    if False: pass
    elif mosek_fusion_DJC._match_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
      return mosek_fusion_DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_DJC._match_alt_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
      return mosek_fusion_DJC._ANDFromTerms_alt__3Lmosek_4fusion_4Term_2(*args)
    else:
      raise ValueError('Invalid argument list ANDFromTerms('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.ANDFromTerms(array(mosek.fusion.Term,ndim=1))')
  @staticmethod
  def AND(*args):
    if False: pass
    elif mosek_fusion_DJC._match_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt__3Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
      return mosek_fusion_DJC._AND__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
      return mosek_fusion_DJC._AND_alt__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    elif mosek_fusion_DJC._match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
      return mosek_fusion_DJC._AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args)
    else:
      raise ValueError('Invalid argument list AND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.AND(array(mosek.fusion.SimpleTerm,ndim=1))\n\tmosek.fusion.DJC.AND(array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm)\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)\n\tmosek.fusion.DJC.AND(mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm,mosek.fusion.SimpleTerm)')
  @staticmethod
  def term(*args):
    if False: pass
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_DJC._match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_DJC._term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    else:
      raise ValueError('Invalid argument list term('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.DJC.term(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.RangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Variable,mosek.fusion.LinearDomain)\n\tmosek.fusion.DJC.term(mosek.fusion.Expression,mosek.fusion.LinearDomain)')
  def __repr__(self): return 'mosek.fusion.DJC'
  @staticmethod
  def _match_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(_0))
  @staticmethod
  def _match_alt_ANDFromTerms__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(_0))
  @staticmethod
  def _ANDFromTerms_alt__3Lmosek_4fusion_4Term_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _ANDFromTerms__3Lmosek_4fusion_4Term_2(_0):
   _1=0
   for _2 in range(0,int((_0).shape[0])):
    _1 += _0[_2]._num_()
   _3=numpy.ndarray((_1,), dtype=numpy.dtype(object))
   _4=numpy.ndarray((_1,), dtype=numpy.dtype(object))
   _1 = 0
   for _5 in range(0,int((_0).shape[0])):
    for _6 in range(0,_0[_5]._num_()):
     _3[_1] = (_0[_5]._exprs)[_6]
     _4[_1] = (_0[_5]._domains)[_6]
     _1 += 1
   return (mosek_fusion_Term._ctor__3Lmosek_4fusion_4Expression_2_3Lmosek_4fusion_4DJCDomain_2(_3,_4))
  @staticmethod
  def _match_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4ExprDomain_2__(_0))
  @staticmethod
  def _match_alt_AND__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_0))
  @staticmethod
  def _AND_alt__3Lmosek_4fusion_4ExprDomain_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._AND__3Lmosek_4fusion_4ExprDomain_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _AND__3Lmosek_4fusion_4ExprDomain_2(_0):
   return (mosek.fusion.DJC._ANDFromTerms__3Lmosek_4fusion_4Term_2(numpy.array([_0[_1]._toDJCTerm_() for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_0) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_1) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_2))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_0) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_1) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_2))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_t__0,_t__1,_t__2):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_0,_1,_2)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_0,_1,_2):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_0,_1,_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_0) and __arg_match_Lmosek_4fusion_4SimpleTerm_2__(_1))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_0) and __arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_1))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_t__0,_t__1):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_0,_1)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2Lmosek_4fusion_4SimpleTerm_2(_0,_1):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_0,_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4SimpleTerm_2__(_0))
  @staticmethod
  def _match_alt_AND_Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4SimpleTerm_2__(_0))
  @staticmethod
  def _AND_alt_Lmosek_4fusion_4SimpleTerm_2(_t__0):
    return mosek_fusion_DJC._AND_Lmosek_4fusion_4SimpleTerm_2(_0)
  @staticmethod
  def _AND_Lmosek_4fusion_4SimpleTerm_2(_0):
   return (mosek.fusion.DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(numpy.array([_0], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4SimpleTerm_2__(_0))
  @staticmethod
  def _match_alt_AND__3Lmosek_4fusion_4SimpleTerm_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4SimpleTerm_2__(_0))
  @staticmethod
  def _AND_alt__3Lmosek_4fusion_4SimpleTerm_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_DJC._AND__3Lmosek_4fusion_4SimpleTerm_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _AND__3Lmosek_4fusion_4SimpleTerm_2(_0):
   return (mosek_fusion_Term._ctor__3Lmosek_4fusion_4SimpleTerm_2(_0))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_t__0,_t__1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1):
   if ((_1._sparsity) is not None):
    raise mosek_fusion_DomainError._ctor_S("Sparse domain is not acceptable in disjunctive constraints")
   if (_1._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain is not acceptable in disjunctive constraints")
   _2=(_1._lb)
   _3=(_1._ub)
   _4=_0._getShape_()
   _5=_0._getSize_()
   _6=(_1._shape)
   if (_6 is None):
    _6 = _4
   else:
    if (int((_6).shape[0])!=int((_4).shape[0])):
     raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
    else:
     for _9 in range(0,int((_6).shape[0])):
      if (_6[_9]!=_4[_9]):
       raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
   if (_1._scalable):
    _7 = numpy.array([_2[0] for _10 in range(0,_5)], dtype=numpy.dtype(numpy.float64))
    _8 = numpy.array([_3[0] for _11 in range(0,_5)], dtype=numpy.dtype(numpy.float64))
   else:
    _7 = _2
    _8 = _3
   return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_7,_8,_6,mosek.fusion.DJCDomainType.InRange)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_t__0,_t__1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4RangeDomain_2(_0,_1):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0._asExpr_(),_1))
  @staticmethod
  def _match_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_0))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_0))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4ExprRangeDomain_2(_t__0):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprRangeDomain_2(_0)
  @staticmethod
  def _term_Lmosek_4fusion_4ExprRangeDomain_2(_0):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2((_0.expr),(_0.dom)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_t__0,_t__1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1):
   if ((_1._sparsity) is not None):
    raise mosek_fusion_DomainError._ctor_S("Sparse domain is not acceptable in disjunctive constraints")
   if (_1._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain is not acceptable in disjunctive constraints")
   _2=(_1._bnd)
   _3=_0._getShape_()
   _4=_0._getSize_()
   _5=(_1._shape)
   if (_5 is None):
    _5 = _3
   else:
    if (int((_5).shape[0])!=int((_3).shape[0])):
     raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
    else:
     for _7 in range(0,int((_5).shape[0])):
      if (_5[_7]!=_3[_7]):
       raise mosek_fusion_DomainError._ctor_S("Mismatching shapes")
   if ((_1._bnd) is None):
    _6 = numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   elif (_1._scalable):
    _6 = numpy.array([_2[0] for _8 in range(0,_4)], dtype=numpy.dtype(numpy.float64))
   elif (_1._empty):
    _6 = numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   else:
    _6 = _2
   if ((_1._key)==mosek.fusion.RelationKey.EqualsTo):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_6,None,_5,mosek.fusion.DJCDomainType.EqualTo)))
   elif ((_1._key)==mosek.fusion.RelationKey.LessThan):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_6,None,_5,mosek.fusion.DJCDomainType.LessThan)))
   elif ((_1._key)==mosek.fusion.RelationKey.GreaterThan):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_6,None,_5,mosek.fusion.DJCDomainType.GreaterThan)))
   elif ((_1._key)==mosek.fusion.RelationKey.IsFree):
    return (mosek_fusion_SimpleTerm._ctor_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4DJCDomain_2(_0,mosek_fusion_DJCDomain._ctor__3D_3D_3IEmosek_4fusion_4DJCDomainType_2(_6,None,_5,mosek.fusion.DJCDomainType.IsFree)))
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Invalid linear domain")
  @staticmethod
  def _match_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_0))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_0))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4ExprLinearDomain_2(_t__0):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4ExprLinearDomain_2(_0)
  @staticmethod
  def _term_Lmosek_4fusion_4ExprLinearDomain_2(_0):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2((_0.expr),(_0.dom)))
  @staticmethod
  def _match_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _term_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_t__0,_t__1):
    return mosek_fusion_DJC._term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  @staticmethod
  def _term_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4LinearDomain_2(_0,_1):
   return (mosek.fusion.DJC._term_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0._asExpr_(),_1))
 return DJC
mosek_fusion_DJC=__mk_mosek_fusion_DJC()
del __mk_mosek_fusion_DJC
def __mk_mosek_fusion_BaseModel():
  import threading
  import mosek
  import mosek.fusion
  import numpy
  
  class BaseModel(object):
    _lock = threading.Lock()
    _global_env = None
    _global_env_counter = 0
  
    @classmethod
    def _globalEnv(self):
      self._lock.acquire()
      try:
        if BaseModel._global_env is None:
          try:
            env = mosek.Env(globalenv=True)
            BaseModel._global_env = env
            BaseModel._global_env_counter += 1
          except mosek.Exception as e:
            raise UnexpectedError(e)
        return BaseModel._global_env
      finally:
        self._lock.release()
  
    @classmethod
    def _env_1putlicensecode__3I(self,code):
      self._globalEnv().putlicensecode(code)
  
    @classmethod
    def _env_1putlicensepath_S(self,path):
      self._globalEnv().putlicensepath(path)
  
    @classmethod
    def _env_1putlicensewait_Z(self,yn):
      if yn:
        self._globalEnv().putlicensewait(1)
      else:
        self._globalEnv().putlicensewait(0)
  
    @classmethod
    def _env_1getversion_(self):
      return ".".join([str(_) for _ in mosek.Env.getversion()])
  
    def __callback(self,callbackkey,dinf,iinf,liinf):
      if self.__user_cb is not None:
        try:
          if self.__user_cb(callbackkey,dinf,iinf,liinf):
            self.__break = True
        except:
          self.__break = True
      if self.__user_pgs is not None:
        try:
          if self.__user_pgs(callbackkey):
            self.__break = True
        except:
          self.__break = True
      return 1 if self.__break else 0
  
    def _ctor_init_SS(self,name,licfile):
      env = self._globalEnv()
      self.__modelname = name
      self.__break = False
      task = mosek.Task(self._global_env, 0, 0);
      self.__user_cb = None
      self.__user_pgs = None
      finished = False
      try:
        task.putintparam(mosek.iparam.log_expand,0);
        task.putintparam(mosek.iparam.remove_unused_solutions,1);
        self.__task = task
        if name is not None:
          task.puttaskname(name)
  
        self._synched = mosek_fusion_SolutionStatus.Optimal;
  
        self._sol_itr = None
        self._sol_bas = None
        self._sol_itg = None
  
        self.__objname = None
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
  
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def _ctor_init_Lmosek_4fusion_4BaseModel_2(self,m):
      env = self._globalEnv()
      self.__modelname = m.__modelname
      self.__break = False
      self.__user_cb = None
      self.__user_pgs = None
      task = mosek.Task(m.__task)
      finished = False
      try:
        self.__task = task
        self._synched = m._synched
  
        self._sol_itr = m._sol_itr._clone_() if m._sol_itr is not None else None
        self._sol_bas = m._sol_bas._clone_() if m._sol_bas is not None else None
        self._sol_itg = m._sol_itg._clone_() if m._sol_itg is not None else None
  
        self.__objname = m.__objname
  
        # handler for log output.
        def loghandler(text):
          if self.__logwriter is not None:
            self.__logwriter.write(text)
            self.__logwriter.flush()
        self.__loghandler = loghandler
        self.__logwriter = None
  
        task.set_Stream(mosek.streamtype.log,loghandler)
        task.set_InfoCallback(self.__callback)
        finished = True
      finally:
        if not finished:
          self.__task.__del__()
          self.__task = None
          BaseModel._global_env_counter -= 1
  
    def __del__(self):
        lock = self._lock
        if hasattr(self,'_BaseModel__task'):
          lock.acquire()
          try:
            task = self.__task
            BaseModel._global_env_counter -= 1
            task.__del__()
  
            for a in self.__class__.__slots__ + ['_sol_itr','_sol_bas','_sol_itg',
                                                 '_BaseModel__user_cb','_BaseModel__user_pgs','_BaseModel__loghandler','_BaseModel__logwriter','_BaseModel__task']:
              try: delattr(self,a)
              except AttributeError: pass
          finally:
            lock.release()
  
    def __enter__(self):
      return self
    def __exit__(self,exc_type,exc_val,exc_tb):
      self.__del__()
    def _dispose_(self):
      self.__del__()
  
    def _task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,handler):
      self.__user_cb = handler
    def _task_1setCallbackHandler_LSystem_4CallbackHandler_2(self,handler):
      self.__user_pgs = handler
  
    def _task_1setLogHandler_LSystem_4StreamWriter_2(self,handler):
      """
      Set the object to handle log output from the solver.
  
      The handler object must have a write method accepting a string.
      """
      self.__logwriter = handler
  
    def _task_1put_1param_SS(self,name,value):
      self.__task.putnastrparam(name,value)
    def _task_1put_1param_SD(self,name,value):
      self.__task.putnadouparam(name,value)
    def _task_1put_1param_SI(self,name,value):
      self.__task.putnaintparam(name,value)
  
    def _task_1get_1dinf_S(self,name):
      key = mosek_fusion_SolverInfo._getdouinf(name)
      if key is None:
        raise NameError("Invalid double info name '%s'" % name)
      else:
        return self.__task.getdouinf(key)
  
    def _task_1get_1iinf_S(self,name):
      key = mosek_fusion_SolverInfo._getintinf(name)
      if key is None:
        raise NameError("Invalid integer info name '%s'" % name)
      else:
        return self.__task.getintinf(key)
  
    def _task_1get_1liinf_S(self,name):
      key = mosek_fusion_SolverInfo._getlintinf(name)
      if key is None:
        raise NameError("Invalid long integer info name '%s'" % name)
      else:
        return self.__task.getlintinf(key)
  
    def _numVariables_ (self):
      return len(self.__vars)
    def _numConstraints_ (self):
      return len(self.__cons)
  
    @staticmethod
    def __convert_names(names):
      namelist = None
      if names is not None:
        namelist = []
        namedaxisidxs = []
        for axisi,nl in enumerate(names):
          if nl is not None:
            namelist.extend(nl)
            namedaxisidxs.append(axisi)
      else:
        namelist = None
        namedaxisidxs = None
  
      return namedaxisidxs,namelist
    def _task_1format_1djc_1names__3JS_3I_3_3S(self,sub,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatedjcnames(sub,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1acc_1names__3JS_3I_3_3S(self,sub,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generateaccnames(sub,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1var_1names__3IS_3I_3J_3_3S(self,subj,fmt,dims,sp,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatevarnames(subj,fmt,dims,sp,namedaxisidxs,namelist)
    def _task_1format_1barvar_1names__3IS_3I_3_3S(self,subj,fmt,dims,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generatebarvarnames(subj,fmt,dims,None,namedaxisidxs,namelist)
    def _task_1format_1con_1names__3IS_3I_3J_3_3S(self,subj,fmt,dims,sp,names):
      namedaxisidxs,namelist = self.__convert_names(names)
      self.__task.generateconnames(subj,fmt,dims,sp,namedaxisidxs,namelist)
  
    def _task_1con_1name_IS(self,idx,name): self.__task.putconname(idx,name)
    def _task_1var_1name_IS(self,idx, name): self.__task.putvarname(idx,name)
    def _task_1acc_1name_JS(self,idx, name): self.__task.putaccname(idx,name)
    def _task_1djc_1name_JS(self,idx, name): self.__task.putdjcname(idx,name)
    def _task_1barvar_1name_IS(self,idx, name): self.__task.putbarvarname(idx,name)
  
    def _task_1numcon_(self):
      return self.__task.getnumcon()
    def _task_1numvar_(self):
      return self.__task.getnumvar()
    def _task_1numacc_(self):
      return self.__task.getnumacc()
    def _task_1numafe_(self):
      return self.__task.getnumafe()
    def _task_1numdjc_(self):
      return self.__task.getnumdjc()
  
    def __task_putvarboundlist(self,idxs,bl,bu,bk):
      num = len(idxs)
      if bl is None: bl = numpy.zeros(num,numpy.float64)
      if bu is None: bu = numpy.zeros(num,numpy.float64)
  
      bka = [bk] * num
      self.__task.putvarboundlist(idxs,bka,bl,bu)
  
    def __task_putconboundlist(self,idxs,bl,bu,bk):
      num = len(idxs)
      if bl is None: bl = numpy.zeros(num,numpy.float64)
      if bu is None: bu = numpy.zeros(num,numpy.float64)
  
      bka = [bk] * num
      self.__task.putconboundlist(idxs,bka,bl,bu)
  
    def _task_1con_1putboundlist_1fx__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.fx);
  
    def _task_1con_1putboundlist_1lo__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.lo);
  
    def _task_1con_1putboundlist_1up__3I_3D(self,idxs, rhs):
      self.__task_putconboundlist( idxs, rhs, rhs, mosek.boundkey.up);
  
    def _task_1con_1putboundlist_1ra__3I_3D_3D(self,idxs, lb, ub):
      self.__task_putconboundlist( idxs, lb, ub, mosek.boundkey.ra);
  
    def _task_1con_1putboundlist_1fr__3I(self,idxs):
      self.__task_putconboundlist( idxs, None, None, mosek.boundkey.fr);
  
  
    def _task_1var_1putboundlist_1fx__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.fx);
  
    def _task_1var_1putboundlist_1lo__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.lo);
  
    def _task_1var_1putboundlist_1up__3I_3D(self,idxs, rhs):
      self.__task_putvarboundlist( idxs, rhs, rhs, mosek.boundkey.up);
  
    def _task_1var_1putboundlist_1ra__3I_3D_3D(self,idxs, lb, ub):
      self.__task_putvarboundlist( idxs, lb, ub, mosek.boundkey.ra);
  
    def _task_1var_1putboundlist_1fr__3I(self,idxs):
      self.__task_putvarboundlist( idxs, None, None, mosek.boundkey.fr);
  
    def _task_1var_1putintlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_int] * len(idxs))
    def _task_1var_1putcontlist__3I(self,idxs):
      self.__task.putvartypelist(idxs,[mosek.variabletype.type_cont] * len(idxs))
  
  
    def _task_1task_1optimize_ (self):
      try:
        self.__task.optimize()
        if self.__logwriter is not None:
          self.__task.solutionsummary(streamtype.log)
      except mosek.Error as e:
        raise OptimizeError("Error occurred while optimizing")
  
    def __task_appendvars(self,num):
      idx = self.__task.getnumvar()
      self.__task.appendvars(num)
      return idx
  
    def __task_appendcons(self,num):
      idx = self.__task.getnumcon()
      self.__task.appendcons(num)
      return idx
  
    def _task_1append_1var_I(self,num):
      return self.__task_appendvars(num)
  
    def _task_1append_1con_I(self,num):
      return self.__task_appendcons(num)
  
    # def _task_1append_1zerocones_I(self, numcone):
    #   self.__task.appendconesseq([mosek.conetype.zero for i in range(numcone)], numpy.zeros(numcone),numpy.zeros(numcone,int), 0)
  
    # def _task_1clear_1cones__3I(self, idxs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.zero, 0.0, 0,[])
  
    # def _task_1put_1zerocones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.zero, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1quadcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.quad, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1rquadcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.rquad, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1pexpcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.pexp, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1ppowcones__3III_3I_3D(self, idxs, conesize, numcone, membs, alpha):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.ppow, alpha[i], membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dexpcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dexp, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dpowcones__3III_3I_3D(self, idxs, conesize, numcone, membs, alpha):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dpow, alpha[i], membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1onenormcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.onenrm, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1infnormcones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.infnrm, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1pgeomeancones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.pgeomean, 0.0, membs[i*conesize:(i+1)*conesize])
  
    # def _task_1put_1dgeomeancones__3III_3I(self, idxs, conesize, numcone, membs):
    #   for i,k in enumerate(idxs):
    #     self.__task.putcone(k,mosek.conetype.dgeomean, 0.0, membs[i*conesize:(i+1)*conesize])
  
    def _task_1putarowlist__3I_3J_3I_3D(self,sub, ptrb, subj, cof):
      num   = len(sub)
      self.__task.putarowlist(sub, ptrb[:-1], ptrb[1:], subj, cof);
  
    def _task_1cleararowlist__3I(self,sub):
      num  = len(sub)
      ptr = numpy.zeros(num,dtype=numpy.int64)
      self.__task.putarowlist(sub, ptr, ptr, numpy.zeros(0,dtype=numpy.int32), numpy.zeros(0,dtype=numpy.float64))
  
      # This is probably awfully slow
      nnz   = self.__task.getnumbaranz()
      if nnz > 0:
        idxij = numpy.zeros(nnz,dtype=numpy.int64)
        self.__task.getbarasparsity(idxij)
        sub = set(sub)
        for idx in idxij:
          i,j = self.__task.getbaraidxij(idx)
          if i in sub:
            self.__task.putbaraij(i,j,[],[])
  
    def _task_1clearacollist__3I(self,sub):
      num  = len(sub)
      ptr = numpy.zeros(num,dtype=numpy.int64)
      self.__task.putacollist(sub, ptr, ptr, numpy.zeros(0,dtype=numpy.int32), numpy.zeros(0,dtype=numpy.float64))
  
    def _task_1putaijlist__3I_3I_3DJ(self,subi,subj,cof,num):
      self.__task.putaijlist(subi[:num],subj[:num],cof[:num])
  
    def _task_1putobjectivename_S(self,name):
      self.__task.putobjname("" if name is None else name)
  
    def _task_1putobjective_Z_3I_3DD(self,maximize,subj,cof,cfix):
      c = numpy.zeros(self.__task.getnumvar(),numpy.float64)
      idxs = numpy.arange(0,len(c),dtype=numpy.int32)
      for i in range(len(subj)):
        c[subj[i]] += cof[i]
      self.__task.putclist(idxs,c)
      self.__task.putcfix(cfix)
      self.__task.putobjsense(mosek.objsense.maximize if maximize else mosek.objsense.minimize)
  
    def _task_1putclist__3I_3D(self,subj,cof):
      self.__task.putclist(subj,cof)
  
  
    def _task_1appendsymmatlist__3I_3J_3I_3I_3D(self,dim,nz,subi,subj,cof):
      r = numpy.zeros(len(dim),numpy.int64)
      #print(dim,nz,"totalnz = {}, len(subi) = {},len(subj) = {}, subi = {}".format(sum(nz),len(subi),len(subj),subi))
      self.__task.appendsparsesymmatlist(dim,nz,subi,subj,cof,r)
      return r
  
    def _task_1putbarc__3I_3I_3I_3D(self,subj,subk,subl,val):
      #rint("putbarc: ",subj,subk,subl,val)
      self.__task.putbarcblocktriplet(subj,subk,subl,val)
      #self.__task.writedata("intermediate1.ptf")
  
    def _task_1putbaraijlist__3I_3I_3J(self,subi,subj,matidx):
      alpha = numpy.ones(len(subi),numpy.float64)
      ptr = numpy.arange(0,len(subi)+1,dtype=numpy.int64)
      self.__task.putbaraijlist(subi,subj,ptr[:-1],ptr[1:],matidx,alpha)
  
    def _task_1putbararowlist__3I_3J_3I_3J(self,subi,ptr,subj,matidx):
      alpha = numpy.ones(len(subj),numpy.float64)
      nummat = numpy.ones(len(subj),numpy.int64)
      self.__task.putbararowlist(subi,ptr[:-1],ptr[1:],subj,nummat,matidx,alpha)
  
  
    def _task_1barvardim_I(self,index):
      return self.__task.getdimbarvarj(index)
  
    def _task_1numbarvar_(self):
      return self.__task.getnumbarvar()
  
  
    def _task_1append_1barvar_II(self,size, num):
      res = self.__task.getnumbarvar()
      self.__task.appendbarvars([size] * num)
      return res
  
    def _task_1setnumvar_I(self,num):
      numvar = self.__task.getnumvar()
      if numvar > num:
        self.__task.removevars(range(num,numvar))
  
  
    def _task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(self,whichsol,first,last,xx):
      if   whichsol == mosek_fusion_SolutionType.Interior:
        self.__task.putxxslice(mosek.soltype.itr, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Integer:
        self.__task.putxxslice(mosek.soltype.itg, first,last,xx)
      elif whichsol == mosek_fusion_SolutionType.Basic:
        self.__task.putxxslice(mosek.soltype.bas, first,last,xx)
  
    def _task_1cleanup_IIII(self,inumvar,inumcon,inumcone,inumbarvar):
      numvar  = self.__task.getnumvar()
      numcon  = self.__task.getnumcon()
      numcone = self.__task.getnumcone()
      numbarvar = self.__task.getnumbarvar()
  
      if inumcone < numcone:
        self.__task.removecones(range(inumcone,numcone))
  
      if inumvar < numvar:
        n = numvar-inumvar
        vals = numpy.zeros((n,), numpy.float64)
        bk   = [ mosek.boundkey.fx for i in range(n) ]
        self.__task.putvarboundslice(inumvar,numvar,bk, vals, vals)
  
      if (inumcon < numcon):
        idxs = range(inumcon,numcon)
        self.__task.removecons(idxs)
  
      if (inumbarvar < numbarvar):
        self.__task.removebarvars(range(inumbarvar,numbarvar))
  
    def _task_1append_1afes_J(self,num):
      first = self.__task.getnumafe()
      self.__task.appendafes(num)
      return first
  
  
    def _task_1clearafelist__3J(self,idxs):
      self.__task.emptyafefrowlist(idxs)
      self.__task.emptyafebarfrowlist(idxs)
      self.__task.putafeglist(idxs,numpy.zeros(len(idxs),dtype=numpy.float64))
  
    def _task_1putafeflist__3J_3I_3I_3D_3D(self,idxs,ptr,subj,cof,g):
      lptr = numpy.array(ptr[:-1],dtype=numpy.int64)
      rownz = numpy.array([ptr[i+1]-ptr[i] for i in range(len(ptr)-1)],dtype=numpy.int32)
      self.__task.putafefrowlist(idxs,rownz,lptr, subj,cof)
      self.__task.putafeglist(idxs,g)
  
    # def _task_1putafebarfrowlist__3I_3J_3I_3J (self,idxs,ptr,barsubj,symmatidx):
    #     num = len(barsubj)
    #     afeidxlist = numpy.array([ idxs[i] for i in range(len(idxs)) for j in range(ptr[i],ptr[i+1]) ],dtype=numpy.int64)
    #     numtermslist = numpy.ones(num,numpy.int64)
    #     ptrtermslist = numpy.arange(num,numpy.int64)
    #     termweights = numpy.ones(num,numpy.float64)
    #     self.__task.putafebarfentrylist(afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
  
    def _task_1putafefijlist__3I_3I_3D (self,idxs,subj,cof):
      self.__task.putafefentrylist(numpy.array(idxs,dtype=numpy.int64),subj,cof)
    def _task_putafefglist__3I_3D(self,idxs,g):
      self.__task.putafeglist(idxs,g)
  
    def _task_1append_1accs_JI_3J_3D(self,domidx,numcone,afeidxs,g):
      domidxs = numpy.array([domidx for i in range(numcone)],dtype=numpy.int64)
      self.__task.appendaccs(domidxs,afeidxs,g)
  
    def _task_1putacclist__3J_3J_3J_3D(self,accidxs,domidxs,afeidxs,g):
      self.__task.putacclist(accidxs,domidxs,afeidxs,g)
  
  
  
    @staticmethod
    def __convertSolutionStatus(soltype,sol,status,prosta):
      pd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
      }
  
      dd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Unknown,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.Unknown,
      }
  
      psd = {
          mosek.prosta.unknown  :                   mosek_fusion_ProblemStatus.Unknown,
          mosek.prosta.prim_and_dual_feas :         mosek_fusion_ProblemStatus.PrimalAndDualFeasible,
          mosek.prosta.prim_feas :                  mosek_fusion_ProblemStatus.PrimalFeasible,
          mosek.prosta.dual_feas :                  mosek_fusion_ProblemStatus.DualFeasible,
          mosek.prosta.prim_infeas :                mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.dual_infeas :                mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_and_dual_infeas :       mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.ill_posed :                  mosek_fusion_ProblemStatus.IllPosed,
          mosek.prosta.prim_infeas_or_unbounded :   mosek_fusion_ProblemStatus.PrimalInfeasibleOrUnbounded,
        }
  
      try: sol.pstatus = pd[status]
      except KeyError: sol.pstatus = mosek_fusion_SolutionStatus.Unknown
  
      try: sol.dstatus = dd[status]
      except KeyError: sol.dstatus = mosek_fusion_SolutionStatus.Unknown
  
      try: sol.probstatus = psd[prosta]
      except KeyError: sol.probstatus = mosek_fusion_SolutionStatus.Unknown
  
  
    @staticmethod
    def _matchargs_task_1write_S(self,*args):
        return True
    def _task_1write_S(self,filename):
        self.__task.putintparam(mosek.iparam.opf_write_solutions, 1)
        #self.__task.putintparam(mosek.iparam.write_ignore_incompatible_items, 1)
        self.__task.writedata(filename)
  
    def _task_1write_1stream_SLSystem_4DataStream_2(self,ext,stream):
        exts = {
          'mps' : mosek.dataformat.mps,
          'cbf' : mosek.dataformat.cb,
          'ptf' : mosek.dataformat.ptf,
          'opf' : mosek.dataformat.op,
          'lp'  : mosek.dataformat.lp,
          'jtask'  : mosek.dataformat.json_task,
          'task'  : mosek.dataformat.task,
        }
        ct = {
          'gz' : mosek.compresstype.gzip,
          'zst' : mosek.compresstype.zstd,
        }
  
        fmt = mosek.dataformat.mps
        comptype = mosek.compresstype.none
        parts = ext.split('.')
        if len(parts) > 0: fmt = parts[0]
        if len(parts) > 1: comptype = parts[1]
  
        try:
          self.__task.putintparam(mosek.iparam.opf_write_solutions, 1)
          self.__task.writedatastream(exts.get(fmt,mosek.dataformat.mps), ct.get(comptype,mosek.compresstype.none), stream)
        except mosek.Error as e:
          raise mosek.fusion.UnexpectedError(e.msg)
  
    def _task_1write(self,filename):
      return self._writeProblem_S(filename)
  
    def _task_1get_(self):
      return self.__task
  
    def _task_1break_1solve_(self):
      self.__break = True
  
    def _task_1putoptserver_1host_S(self, addr):
      self.__task.putoptserverhost(addr)
  
    def _task_1analyze_1problem_I(self, detail):
      try:
        self.__task.putintparam(mosek.iparam.log_ana_pro, detail)
        self.__task.analyzeproblem(mosek.streamtype.log)
      except mosek.Error as e:
        raise mosek.fusion.UnexpectedError(e.msg)
  
    def _report_1solution__Lmosek_4fusion_4SolutionType_Emosek_4fusion_4ProblemStatus_Emosek_4fusion_4SolutionStatus_Lmosek_4fusion_4SolutionStatus_DDIIIIIZZ(
        self,
        soltype,
        prosta,
        psolsta,
        dsolsta,
        pobj,
        dobj,
        numvar,
        numcon,
        numbarelm,
        numacc,
        numaccelm,
        hasprimal,
        hasdual):
      assert False
    def _report_1solution_1get_1xx__3D  (self,v): self.__task.getxxslice(  self.__cursol,0,len(v),v)
    def _report_1solution_1get_1slx__3D (self,v): self.__task.getslxslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1sux__3D (self,v): self.__task.getsuxslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1xc__3D  (self,v): self.__task.getxcslice(  self.__cursol,0,len(v),v)
    def _report_1solution_1get_1slc__3D (self,v): self.__task.getslcslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1suc__3D (self,v): self.__task.getsucslice( self.__cursol,0,len(v),v)
    def _report_1solution_1get_1barx__3D(self,v): self.__task.getbarxslice(self.__cursol,0,self.__task.getnumbarvar(),len(v),v)
    def _report_1solution_1get_1bars__3D(self,v): self.__task.getbarsslice(self.__cursol,0,self.__task.getnumbarvar(),len(v),v)
    def _report_1solution_1get_1accx__3D(self,v): self.__task.evaluateaccs(self.__cursol,v)
    def _report_1solution_1get_1accy__3D(self,v):
      ptr = 0
      numacc = self.__task.getnumacc()
      for i in range(numacc):
        accn   = self.__task.getaccn(i)
        data = numpy.zeros(accn,numpy.float64)
        self.__task.getaccdoty(self.__cursol,i,data);
        v[ptr:ptr+accn] = data
        ptr += accn
  
    def _report_1solution_1get_1accptr__3I(self,v):
      ptr = 0
      numacc = self.__task.getnumacc()
      for i in range(numacc):
        v[i] = ptr;
        ptr += self.__task.getaccn(i)
  
    #def __report_task_solution(self,mosek.soltype st, int numvar, int numcon, int numbarelm, long numacc, long numaccelm) {
    def __report_task_solution(self,st,numvar,numcon,numbarelm,numacc,numaccelm):
      pd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.unknown :                    mosek_fusion_SolutionStatus.Unknown,
      }
  
      dd = {
          mosek.solsta.optimal :                    mosek_fusion_SolutionStatus.Optimal,
          mosek.solsta.integer_optimal :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_and_dual_feas :         mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_feas :                  mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.dual_feas :                  mosek_fusion_SolutionStatus.Feasible,
          mosek.solsta.prim_infeas_cer :            mosek_fusion_SolutionStatus.Certificate,
          mosek.solsta.dual_infeas_cer :            mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.prim_illposed_cer :          mosek_fusion_SolutionStatus.IllposedCert,
          mosek.solsta.dual_illposed_cer :          mosek_fusion_SolutionStatus.Undefined,
          mosek.solsta.unknown :                    mosek_fusion_SolutionStatus.Unknown,
      }
  
      psd = {
          mosek.prosta.unknown  :                   mosek_fusion_ProblemStatus.Unknown,
          mosek.prosta.prim_and_dual_feas :         mosek_fusion_ProblemStatus.PrimalAndDualFeasible,
          mosek.prosta.prim_feas :                  mosek_fusion_ProblemStatus.PrimalFeasible,
          mosek.prosta.dual_feas :                  mosek_fusion_ProblemStatus.DualFeasible,
          mosek.prosta.prim_infeas :                mosek_fusion_ProblemStatus.PrimalInfeasible,
          mosek.prosta.dual_infeas :                mosek_fusion_ProblemStatus.DualInfeasible,
          mosek.prosta.prim_and_dual_infeas :       mosek_fusion_ProblemStatus.PrimalAndDualInfeasible,
          mosek.prosta.ill_posed :                  mosek_fusion_ProblemStatus.IllPosed,
          mosek.prosta.prim_infeas_or_unbounded :   mosek_fusion_ProblemStatus.PrimalInfeasibleOrUnbounded,
        }
  
  
      solsta = self.__task.getsolsta(st)
      prosta = self.__task.getprosta(st)
  
      psolsta = pd[solsta]
      dsolsta = dd[solsta]
  
      # Special unconditional cases for integer solution:
      if st == mosek.soltype.itg:
        dsolsta = mosek_fusion_SolutionStatus.Undefined
        if prosta == mosek.prosta.prim_infeas:
          psolsta = mosek_fusion_SolutionStatus.Undefined
  
      hasprimal = psolsta != mosek_fusion_SolutionStatus.Undefined
      hasdual   = dsolsta != mosek_fusion_SolutionStatus.Undefined
  
      pobj   = self.__task.getprimalobj(st) if hasprimal else 0.0
      dobj   = self.__task.getdualobj(st) if hasdual else 0.0
  
      ps = psd[prosta]
  
      if   st == mosek.soltype.bas: soltp = mosek_fusion_SolutionType.Basic
      elif st == mosek.soltype.itr: soltp = mosek_fusion_SolutionType.Interior
      elif st == mosek.soltype.itg: soltp = mosek_fusion_SolutionType.Integer
  
      self.__cursol = st
      self._report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(
        soltp,ps,psolsta,dsolsta,pobj,dobj,numvar,numcon,numbarelm,numacc,numaccelm,hasprimal,hasdual)
  
  
  
  
    @classmethod
    def _env_1solve_1batch_ZDI_3Lmosek_4fusion_4Model_2(self,israce,timelimit,numthreads,models):
      n = len(models)
      tasks = [_m.getTask() for _m in models]
      res = [mosek.rescode.err_unknown] * n
      trm = [mosek.rescode.err_unknown] * n
      ok = False
      try:
        BaseModel._globalEnv().optimizebatch(israce,          # israce
                                             timelimit,       # timelimit
                                             numthreads,      # numthread
                                             tasks,
                                             trm,
                                             res)
        ok = True
      except mosek.Error as e:
        raise mosek_fusion_OptimizeError(str(e))
      finally:
        if not ok: # means exception, post-solve won't be called
          for _m in models:
            _m._sol_itr = None
            _m._sol_bas = None
            _m._sol_itg = None
  
      return [mosek_fusion_SolverStatus.Error if res[i]!=mosek.rescode.ok else mosek_fusion_SolverStatus.LostRace if trm[i]==mosek.rescode.trm_lost_race else mosek_fusion_SolverStatus.OK for i in range(n)]
  
    @staticmethod
    def _matchargs_task_1solve_(self,*args):
      return True
    def _task_1solve_ZSS(self, remote, server, port):
      task = self.__task
      ok = False
      try:
        trmcode = mosek.rescode.ok
        try:
          self.__break = False
          if remote:
            trmcode = task.optimizermt(server, port)
          else:
            trmcode = task.optimize()
          task.solutionsummary(mosek.streamtype.log)
          ok = True
        except mosek.Error as e:
          raise mosek_fusion_OptimizeError(str(e))
      finally:
        if not ok: # means exception, post-solve won't be called
          self._sol_itr = None
          self._sol_bas = None
          self._sol_itg = None
  
    def _task_1post_1solve_(self):
      task = self.__task  
      numcon  = task.getnumcon()
      numvar  = task.getnumvar()
      numbarvar = task.getnumbarvar()
      barvarveclen = 0
      for j in range(numbarvar):
        barxjdim = task.getdimbarvarj(j)
        barvarveclen += barxjdim * (1+barxjdim)/2
      barvarveclen = numpy.int32(barvarveclen)
      numacc = task.getnumacc();
      numaccelm = task.getaccntot();
  
      sol_bas_def = 0 != task.solutiondef(mosek.soltype.bas)
      sol_itr_def = 0 != task.solutiondef(mosek.soltype.itr)
      sol_itg_def = 0 != task.solutiondef(mosek.soltype.itg)
  
      self._clear_1solutions_();
      if sol_itr_def:
        self.__report_task_solution(mosek.soltype.itr, numvar, numcon, barvarveclen,numacc,numaccelm)
      if sol_bas_def:
        self.__report_task_solution(mosek.soltype.bas, numvar, numcon, barvarveclen,numacc,numaccelm)
      if sol_itg_def:
        self.__report_task_solution(mosek.soltype.itg, numvar, numcon, barvarveclen,numacc,numaccelm)
  
  
    @staticmethod
    def _env_1syeig_I_3D_3D(n,a,w): BaseModel._globalEnv().syeig(n,a,w)
    @staticmethod
    def _env_1syevd_I_3D_3D(n,a,w): BaseModel._globalEnv().syevd(n,a,w)
    #@staticmethod
    #def _env_1potrf_I_3D(n,a):      BaseModel._globalEnv().potrf(n,a)
  
  
  
    def _task_1putafefrow_J_3I_3D(self,idx,subj,cof): self.__task.putafefrow(idx,subj,cof)
  
    def _task_1clearaferowlist__3I(self,idxs):
      subj = numpy.zeros(0,dtype=numpy.int32)
      val  = numpy.zeros(0,dtype=numpy.float64)
  
      for i in range(len(idxs)):
          self.__task.putafefrow(idxs[i],subj,val)
          self.__task.putafeg(idxs[i],0.0)
      raise  UnexpectedError("Not implemented: clearbarfrowlist");
  
    def _task_1putafefrowlist__3I_3I_3I_3D_3D(self,idxs,ptr,subj,cof,g):
      for i in range(len(idxs)):
          self.__task.putafefrow(idxs[i],subj[ptr[i]:ptr[i+1]],cof[ptr[i]:ptr[i+1]])
          self.__task.putafeg(idxs[i],g[i])
  
    def _task_1putafebarfrowlist__3I_3I_3I_3J (self,idxs,ptr,barsubj,symmatidx):
      num = len(barsubj);
      #print('ptr = ',ptr)
      #print('idxs = ',idxs)
      #print('barsubj = ',barsubj)
      afeidxlist   = numpy.array([idxs[i] for i in range(len(idxs)) for j in range(ptr[i],ptr[i+1])],dtype=numpy.int64)
      numtermslist = numpy.ones(num,dtype=numpy.int64)
      ptrtermslist = numpy.arange(num,dtype=numpy.int64)
      termweights  = numpy.ones(num,dtype=numpy.float64)
      #print('afeidxlist   = ',afeidxlist  )
      #print('numtermslist = ',numtermslist)
      #print('ptrtermslist = ',ptrtermslist)
      #print('termweights  = ',termweights )
  
      #print(idxs,afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
      #print(len(idxs),len(afeidxlist),len(barsubj),len(numtermslist),len(ptrtermslist),len(symmatidx),len(termweights))
      self.__task.putafebarfentrylist(afeidxlist,barsubj,numtermslist,ptrtermslist,symmatidx,termweights)
  
    #def _task_1putafefijlist__3I_3I_3D(self,idxs,subj,cof):
    #  raise UnexpectedError("Not implemented: putafefijlist")
  
    def _task_1putafefglist__3I_3D (self,idxs,g):
      for i,v in zip(idxs,g):
        self.__task.putafeg(i,v)
  
    def _task_1append_1accs_II_3I_3D_3I(self,domidx,numcone,afeidxs,g,accidxs):
      domidxs = numpy.array([domidx]*numcone,dtype=numpy.int32)
      lafeidxs = numpy.array(afeidxs,dtype=numpy.int64)
      firstacc = self.__task.getnumacc()
  
      for i in range(numcone):
        accidxs[i] = firstacc + i
      self.__task.appendaccs(domidxs,lafeidxs,g)
  
    def _task_1putafefrow_I_3I_3D (self,idx,subj,cof):
      self.__task.putafefrow(idx, subj, cof)
  
    def _task_1append_1domain_1quad_I     (self, conesize): return self.__task.appendquadraticconedomain(conesize)
    def _task_1append_1domain_1rquad_I    (self, conesize): return self.__task.appendrquadraticconedomain(conesize)
    def _task_1append_1domain_1pexp_      (self): return self.__task.appendprimalexpconedomain()
    def _task_1append_1domain_1dexp_      (self): return self.__task.appenddualexpconedomain()
    def _task_1append_1domain_1ppow_I_3D  (self, conesize, alpha): return self.__task.appendprimalpowerconedomain(conesize,alpha)
    def _task_1append_1domain_1dpow_I_3D  (self, conesize, alpha): return self.__task.appenddualpowerconedomain(conesize,alpha)
    #def _task_1append_1domain_1onenorm_I  (self, conesize): return self.__task.appendonenormconedomain(conesize)
    #def _task_1append_1domain_1infnorm_I  (self, conesize): return self.__task.appendinfnormconedomain(conesize)
    def _task_1append_1domain_1pgeomean_I (self, conesize): return self.__task.appendprimalgeomeanconedomain(conesize)
    def _task_1append_1domain_1dgeomean_I (self, conesize): return self.__task.appenddualgeomeanconedomain(conesize)
    def _task_1append_1domain_1rpos_I     (self, conesize): return self.__task.appendrplusdomain(conesize)
    def _task_1append_1domain_1rneg_I     (self, conesize): return self.__task.appendrminusdomain(conesize)
    def _task_1append_1domain_1r_I        (self, conesize): return self.__task.appendrdomain(conesize)
    def _task_1append_1domain_1rzero_I    (self, conesize): return self.__task.appendrzerodomain(conesize)
    def _task_1append_1domain_1svec_1psd_I(self, conesize): return self.__task.appendsvecpsdconedomain(conesize)
    def _task_1append_1domain_1empty_     (self): return self.__task.appendrdomain(0)
    def __task_append_1afes(self,num):
      idx = self.__task.getnumafe()
      self.__task.appendafes(num)
      return idx
  
    def __task_appenddjcs(self,num):
      idx = self.__task.getnumdjc()
      self.__task.appenddjcs(num)
      return idx
  
    def _task_1append_1djc_J(self,num):
      return self.__task_appenddjcs(num)
  
    def _task_1putdjcslice_JJ_3J_3J_3J_3J_3D(self,first,last,numterm,termsizes,domidxlist,afeidxlist,b):
      return self.__task.putdjcslice(first,last,domidxlist,afeidxlist,b,termsizes,numterm)
  return BaseModel
mosek_fusion_BaseModel=__mk_mosek_fusion_BaseModel()
#BEFORE CLASS
def __mk_mosek_fusion_Model():
 class Model(mosek_fusion_BaseModel):
  __slots__ = ['_Model__xs','_Model__ws','_Model__rs','_Model__sol_itg','_Model__sol_bas','_Model__sol_itr','_Model__con_map','_Model__acons','_Model__cons','_Model__task_numaferow','_Model__param_value','_Model__param_num','_Model__par_map','_Model__numparameter','_Model__parameters','_Model__initsol_xx_flag','_Model__initsol_xx','_Model__var_map','_Model__barvars','_Model__vars','_Model__bfixidx','_Model__barvar_block_elm_j','_Model__barvar_block_elm_i','_Model__barvar_block_elm_barj','_Model__barvar_block_elm_ptr','_Model__barvar_block_dim','_Model__barvar_block_ptr','_Model__barvar_dim','_Model__barvar_num','_Model__var_elm_acc_ofs','_Model__var_elm_acc_idx','_Model__var_block_acc_id','_Model__var_block_map','_Model__acon_elm_afe','_Model__acon_elm_ofs','_Model__acon_elm_scale','_Model__acon_elm_accid','_Model__acon_afe','_Model__acon_acc','_Model__acon_block_map','_Model__acc_block_map','_Model__obj_blocks','_Model__afe_blocks','_Model__con_blocks','_Model__num_task_acc','_Model__num_task_afe','_Model__num_task_con','_Model__solutionptr','_Model__acceptable_sol','_Model__model_name']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_S(*args):
      self._ctor_init_S(*args)
    elif self.__match_alt_ctor_S(*args):
      self._ctor_alt_init_S(*args)
    elif self.__match_ctor_I(*args):
      self._ctor_init_I(*args)
    elif self.__match_alt_ctor_I(*args):
      self._ctor_alt_init_I(*args)
    elif self.__match_ctor_SI(*args):
      self._ctor_init_SI(*args)
    elif self.__match_alt_ctor_SI(*args):
      self._ctor_alt_init_SI(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Model.ctor()\n\tmosek.fusion.Model.ctor(string)\n\tmosek.fusion.Model.ctor(int32)\n\tmosek.fusion.Model.ctor(string,int32)')
  def flushSolutions(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_flushSolutions_(*args):
      return self._flushSolutions_(*args)
    elif mosek_fusion_Model._match_alt_flushSolutions_(*args):
      return self._flushSolutions_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushSolutions('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushSolutions()')
  def selectedSolution(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
      return self._selectedSolution_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
      return self._selectedSolution_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list selectedSolution('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.selectedSolution(mosek.fusion.SolutionType)')
  @staticmethod
  def putlicensewait(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensewait_Z(*args):
      return mosek_fusion_Model._putlicensewait_Z(*args)
    elif mosek_fusion_Model._match_alt_putlicensewait_Z(*args):
      return mosek_fusion_Model._putlicensewait_alt_Z(*args)
    else:
      raise ValueError('Invalid argument list putlicensewait('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensewait(bool)')
  def getParameter(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getParameter_S(*args):
      return self._getParameter_S(*args)
    elif mosek_fusion_Model._match_alt_getParameter_S(*args):
      return self._getParameter_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getParameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getParameter(string)')
  @staticmethod
  def putlicensepath(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensepath_S(*args):
      return mosek_fusion_Model._putlicensepath_S(*args)
    elif mosek_fusion_Model._match_alt_putlicensepath_S(*args):
      return mosek_fusion_Model._putlicensepath_alt_S(*args)
    else:
      raise ValueError('Invalid argument list putlicensepath('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensepath(string)')
  def writeTaskStream(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_writeTaskStream_SLSystem_4DataStream_2(*args):
      return self._writeTaskStream_SLSystem_4DataStream_2(*args)
    elif mosek_fusion_Model._match_alt_writeTaskStream_SLSystem_4DataStream_2(*args):
      return self._writeTaskStream_alt_SLSystem_4DataStream_2(*args)
    else:
      raise ValueError('Invalid argument list writeTaskStream('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTaskStream(string,System.DataStream)')
  def setDataCallbackHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
      return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
      return self._setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setDataCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setDataCallbackHandler(System.DataCallbackHandler)')
  def optserverHost(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_optserverHost_S(*args):
      return self._optserverHost_S(*args)
    elif mosek_fusion_Model._match_alt_optserverHost_S(*args):
      return self._optserverHost_alt_S(*args)
    else:
      raise ValueError('Invalid argument list optserverHost('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.optserverHost(string)')
  @staticmethod
  def putlicensecode(*args):
    if False: pass
    elif mosek_fusion_Model._match_putlicensecode__3I(*args):
      return mosek_fusion_Model._putlicensecode__3I(*args)
    elif mosek_fusion_Model._match_alt_putlicensecode__3I(*args):
      return mosek_fusion_Model._putlicensecode_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list putlicensecode('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.putlicensecode(array(int32,ndim=1))')
  def getVariable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getVariable_S(*args):
      return self._getVariable_S(*args)
    elif mosek_fusion_Model._match_alt_getVariable_S(*args):
      return self._getVariable_alt_S(*args)
    elif mosek_fusion_Model._match_getVariable_I(*args):
      return self._getVariable_I(*args)
    elif mosek_fusion_Model._match_alt_getVariable_I(*args):
      return self._getVariable_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariable(string)\n\tmosek.fusion.Model.getVariable(int32)')
  def flushParameters(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_flushParameters_(*args):
      return self._flushParameters_(*args)
    elif mosek_fusion_Model._match_alt_flushParameters_(*args):
      return self._flushParameters_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushParameters('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushParameters()')
  def disjunction(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_disjunction__3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction__3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt__3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt__3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_SLmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_S_3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_S_3Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
      return self._disjunction_alt_S_3Lmosek_4fusion_4ExprDomain_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4DisjunctionTerms_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    elif mosek_fusion_Model._match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
      return self._disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args)
    else:
      raise ValueError('Invalid argument list disjunction('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.disjunction(mosek.fusion.DisjunctionTerms)\n\tmosek.fusion.Model.disjunction(array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(mosek.fusion.ExprDomain)\n\tmosek.fusion.Model.disjunction(array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.ExprDomain)\n\tmosek.fusion.Model.disjunction(string,array(mosek.fusion.Term,ndim=1))\n\tmosek.fusion.Model.disjunction(string,array(mosek.fusion.ExprDomain,ndim=1))\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.DisjunctionTerms)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)\n\tmosek.fusion.Model.disjunction(string,mosek.fusion.Term,mosek.fusion.Term,mosek.fusion.Term)')
  def parameter(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_parameter_(*args):
      return self._parameter_(*args)
    elif mosek_fusion_Model._match_alt_parameter_(*args):
      return self._parameter_alt_(*args)
    elif mosek_fusion_Model._match_parameter_S(*args):
      return self._parameter_S(*args)
    elif mosek_fusion_Model._match_alt_parameter_S(*args):
      return self._parameter_alt_S(*args)
    elif mosek_fusion_Model._match_parameter_I(*args):
      return self._parameter_I(*args)
    elif mosek_fusion_Model._match_alt_parameter_I(*args):
      return self._parameter_alt_I(*args)
    elif mosek_fusion_Model._match_parameter__3I(*args):
      return self._parameter__3I(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I(*args):
      return self._parameter_alt__3I(*args)
    elif mosek_fusion_Model._match_parameter_SI(*args):
      return self._parameter_SI(*args)
    elif mosek_fusion_Model._match_alt_parameter_SI(*args):
      return self._parameter_alt_SI(*args)
    elif mosek_fusion_Model._match_parameter__3I_3J(*args):
      return self._parameter__3I_3J(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I_3J(*args):
      return self._parameter_alt__3I_3J(*args)
    elif mosek_fusion_Model._match_parameter_II(*args):
      return self._parameter_II(*args)
    elif mosek_fusion_Model._match_alt_parameter_II(*args):
      return self._parameter_alt_II(*args)
    elif mosek_fusion_Model._match_parameter__3I_3_5I(*args):
      return self._parameter__3I_3_5I(*args)
    elif mosek_fusion_Model._match_alt_parameter__3I_3_5I(*args):
      return self._parameter_alt__3I_3_5I(*args)
    elif mosek_fusion_Model._match_parameter_S_3I(*args):
      return self._parameter_S_3I(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I(*args):
      return self._parameter_alt_S_3I(*args)
    elif mosek_fusion_Model._match_parameter_S_3I_3J(*args):
      return self._parameter_S_3I_3J(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I_3J(*args):
      return self._parameter_alt_S_3I_3J(*args)
    elif mosek_fusion_Model._match_parameter_III(*args):
      return self._parameter_III(*args)
    elif mosek_fusion_Model._match_alt_parameter_III(*args):
      return self._parameter_alt_III(*args)
    elif mosek_fusion_Model._match_parameter_S_3I_3_5I(*args):
      return self._parameter_S_3I_3_5I(*args)
    elif mosek_fusion_Model._match_alt_parameter_S_3I_3_5I(*args):
      return self._parameter_alt_S_3I_3_5I(*args)
    elif mosek_fusion_Model._match_parameter_SII(*args):
      return self._parameter_SII(*args)
    elif mosek_fusion_Model._match_alt_parameter_SII(*args):
      return self._parameter_alt_SII(*args)
    elif mosek_fusion_Model._match_parameter_SIII(*args):
      return self._parameter_SIII(*args)
    elif mosek_fusion_Model._match_alt_parameter_SIII(*args):
      return self._parameter_alt_SIII(*args)
    else:
      raise ValueError('Invalid argument list parameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.parameter()\n\tmosek.fusion.Model.parameter(string)\n\tmosek.fusion.Model.parameter(int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1))\n\tmosek.fusion.Model.parameter(string,int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Model.parameter(int32,int32)\n\tmosek.fusion.Model.parameter(array(int32,ndim=1),array(int32,ndim=2))\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1))\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Model.parameter(int32,int32,int32)\n\tmosek.fusion.Model.parameter(string,array(int32,ndim=1),array(int32,ndim=2))\n\tmosek.fusion.Model.parameter(string,int32,int32)\n\tmosek.fusion.Model.parameter(string,int32,int32,int32)')
  def dualObjValue(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_dualObjValue_(*args):
      return self._dualObjValue_(*args)
    elif mosek_fusion_Model._match_alt_dualObjValue_(*args):
      return self._dualObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list dualObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dualObjValue()')
  def flushNames(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_flushNames_(*args):
      return self._flushNames_(*args)
    elif mosek_fusion_Model._match_alt_flushNames_(*args):
      return self._flushNames_alt_(*args)
    else:
      raise ValueError('Invalid argument list flushNames('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.flushNames()')
  def primalObjValue(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_primalObjValue_(*args):
      return self._primalObjValue_(*args)
    elif mosek_fusion_Model._match_alt_primalObjValue_(*args):
      return self._primalObjValue_alt_(*args)
    else:
      raise ValueError('Invalid argument list primalObjValue('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.primalObjValue()')
  def setSolverParam(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setSolverParam_SS(*args):
      return self._setSolverParam_SS(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SS(*args):
      return self._setSolverParam_alt_SS(*args)
    elif mosek_fusion_Model._match_setSolverParam_SI(*args):
      return self._setSolverParam_SI(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SI(*args):
      return self._setSolverParam_alt_SI(*args)
    elif mosek_fusion_Model._match_setSolverParam_SD(*args):
      return self._setSolverParam_SD(*args)
    elif mosek_fusion_Model._match_alt_setSolverParam_SD(*args):
      return self._setSolverParam_alt_SD(*args)
    else:
      raise ValueError('Invalid argument list setSolverParam('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setSolverParam(string,string)\n\tmosek.fusion.Model.setSolverParam(string,int32)\n\tmosek.fusion.Model.setSolverParam(string,double)')
  def getName(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getName_(*args):
      return self._getName_(*args)
    elif mosek_fusion_Model._match_alt_getName_(*args):
      return self._getName_alt_(*args)
    else:
      raise ValueError('Invalid argument list getName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getName()')
  def setLogHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setLogHandler_LSystem_4StreamWriter_2(*args):
      return self._setLogHandler_LSystem_4StreamWriter_2(*args)
    elif mosek_fusion_Model._match_alt_setLogHandler_LSystem_4StreamWriter_2(*args):
      return self._setLogHandler_alt_LSystem_4StreamWriter_2(*args)
    else:
      raise ValueError('Invalid argument list setLogHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setLogHandler(System.StreamWriter)')
  @staticmethod
  def getVersion(*args):
    if False: pass
    elif mosek_fusion_Model._match_getVersion_(*args):
      return mosek_fusion_Model._getVersion_(*args)
    elif mosek_fusion_Model._match_alt_getVersion_(*args):
      return mosek_fusion_Model._getVersion_alt_(*args)
    else:
      raise ValueError('Invalid argument list getVersion('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVersion()')
  def variable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_variable_(*args):
      return self._variable_(*args)
    elif mosek_fusion_Model._match_alt_variable_(*args):
      return self._variable_alt_(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S(*args):
      return self._variable_S(*args)
    elif mosek_fusion_Model._match_alt_variable_S(*args):
      return self._variable_alt_S(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_I(*args):
      return self._variable_I(*args)
    elif mosek_fusion_Model._match_alt_variable_I(*args):
      return self._variable_alt_I(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3I(*args):
      return self._variable__3I(*args)
    elif mosek_fusion_Model._match_alt_variable__3I(*args):
      return self._variable_alt__3I(*args)
    elif mosek_fusion_Model._match_variable_Lmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SI(*args):
      return self._variable_SI(*args)
    elif mosek_fusion_Model._match_alt_variable_SI(*args):
      return self._variable_alt_SI(*args)
    elif mosek_fusion_Model._match_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt__3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3I(*args):
      return self._variable_S_3I(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3I(*args):
      return self._variable_alt_S_3I(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_SLmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SLmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_SLmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_SILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_IILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_IILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_S_3ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_S_3ILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args):
      return self._variable_alt_SILmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_SIILmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
      return self._variable_alt_SIILmosek_4fusion_4PSDDomain_2(*args)
    else:
      raise ValueError('Invalid argument list variable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.variable()\n\tmosek.fusion.Model.variable(mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string)\n\tmosek.fusion.Model.variable(mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32)\n\tmosek.fusion.Model.variable(mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1))\n\tmosek.fusion.Model.variable(mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32)\n\tmosek.fusion.Model.variable(array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1))\n\tmosek.fusion.Model.variable(int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(int32,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.variable(string,array(int32,ndim=1),mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.variable(string,int32,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.variable(string,int32,int32,mosek.fusion.PSDDomain)')
  def getDualSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getDualSolutionStatus_(*args):
      return self._getDualSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_(*args):
      return self._getDualSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getDualSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getDualSolutionStatus()\n\tmosek.fusion.Model.getDualSolutionStatus(mosek.fusion.SolutionType)')
  def objective(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_objective_D(*args):
      return self._objective_D(*args)
    elif mosek_fusion_Model._match_alt_objective_D(*args):
      return self._objective_alt_D(*args)
    elif mosek_fusion_Model._match_objective_SD(*args):
      return self._objective_SD(*args)
    elif mosek_fusion_Model._match_alt_objective_SD(*args):
      return self._objective_alt_SD(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(*args)
    elif mosek_fusion_Model._match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Model._match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
      return self._objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args)
    else:
      raise ValueError('Invalid argument list objective('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.objective(double)\n\tmosek.fusion.Model.objective(string,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,double)\n\tmosek.fusion.Model.objective(mosek.fusion.ObjectiveSense,mosek.fusion.Expression)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,double)\n\tmosek.fusion.Model.objective(string,mosek.fusion.ObjectiveSense,mosek.fusion.Expression)')
  def hasVariable(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_hasVariable_S(*args):
      return self._hasVariable_S(*args)
    elif mosek_fusion_Model._match_alt_hasVariable_S(*args):
      return self._hasVariable_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasVariable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasVariable(string)')
  def getConstraintDuals(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getConstraintDuals_Z_3I_3DI(*args):
      return self._getConstraintDuals_Z_3I_3DI(*args)
    elif mosek_fusion_Model._match_alt_getConstraintDuals_Z_3I_3DI(*args):
      return self._getConstraintDuals_alt_Z_3I_3DI(*args)
    else:
      raise ValueError('Invalid argument list getConstraintDuals('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraintDuals(bool,array(int32,ndim=1),array(double,ndim=1),int32)')
  def solve(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_solve_(*args):
      return self._solve_(*args)
    elif mosek_fusion_Model._match_alt_solve_(*args):
      return self._solve_alt_(*args)
    elif mosek_fusion_Model._match_solve_SS(*args):
      return self._solve_SS(*args)
    elif mosek_fusion_Model._match_alt_solve_SS(*args):
      return self._solve_alt_SS(*args)
    else:
      raise ValueError('Invalid argument list solve('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.solve()\n\tmosek.fusion.Model.solve(string,string)')
  def setCallbackHandler(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
      return self._setCallbackHandler_LSystem_4CallbackHandler_2(*args)
    elif mosek_fusion_Model._match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
      return self._setCallbackHandler_alt_LSystem_4CallbackHandler_2(*args)
    else:
      raise ValueError('Invalid argument list setCallbackHandler('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setCallbackHandler(System.CallbackHandler)')
  def writeTask(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_writeTask_S(*args):
      return self._writeTask_S(*args)
    elif mosek_fusion_Model._match_alt_writeTask_S(*args):
      return self._writeTask_alt_S(*args)
    else:
      raise ValueError('Invalid argument list writeTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTask(string)')
  def setVariableValues(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_setVariableValues_Z_3J_3D(*args):
      return self._setVariableValues_Z_3J_3D(*args)
    elif mosek_fusion_Model._match_alt_setVariableValues_Z_3J_3D(*args):
      return self._setVariableValues_alt_Z_3J_3D(*args)
    else:
      raise ValueError('Invalid argument list setVariableValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.setVariableValues(bool,array(int64,ndim=1),array(double,ndim=1))')
  def dispose(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_dispose_(*args):
      return self._dispose_(*args)
    elif mosek_fusion_Model._match_alt_dispose_(*args):
      return self._dispose_alt_(*args)
    else:
      raise ValueError('Invalid argument list dispose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dispose()')
  def getPrimalSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_(*args):
      return self._getPrimalSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_(*args):
      return self._getPrimalSolutionStatus_alt_(*args)
    elif mosek_fusion_Model._match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getPrimalSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getPrimalSolutionStatus()\n\tmosek.fusion.Model.getPrimalSolutionStatus(mosek.fusion.SolutionType)')
  def updateObjective(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Model._match_alt_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._updateObjective_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list updateObjective('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.updateObjective(mosek.fusion.Expression,mosek.fusion.Variable)')
  def constraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprLinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprPSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprRangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4ExprConicDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args)
    elif mosek_fusion_Model._match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Model._match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
      return self._constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args)
    else:
      raise ValueError('Invalid argument list constraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprConicDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.ConeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprLinearDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprPSDDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprRangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.ExprConicDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.RangeDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.LinearDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.PSDDomain)\n\tmosek.fusion.Model.constraint(string,mosek.fusion.Expression,mosek.fusion.ConeDomain)')
  def breakSolver(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_breakSolver_(*args):
      return self._breakSolver_(*args)
    elif mosek_fusion_Model._match_alt_breakSolver_(*args):
      return self._breakSolver_alt_(*args)
    else:
      raise ValueError('Invalid argument list breakSolver('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.breakSolver()')
  def acceptedSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_Model._match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list acceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.acceptedSolutionStatus(mosek.fusion.AccSolutionStatus)')
  def getConstraintValues(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getConstraintValues_Z_3I_3DI(*args):
      return self._getConstraintValues_Z_3I_3DI(*args)
    elif mosek_fusion_Model._match_alt_getConstraintValues_Z_3I_3DI(*args):
      return self._getConstraintValues_alt_Z_3I_3DI(*args)
    else:
      raise ValueError('Invalid argument list getConstraintValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraintValues(bool,array(int32,ndim=1),array(double,ndim=1),int32)')
  def getProblemStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getProblemStatus_(*args):
      return self._getProblemStatus_(*args)
    elif mosek_fusion_Model._match_alt_getProblemStatus_(*args):
      return self._getProblemStatus_alt_(*args)
    elif mosek_fusion_Model._match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(*args)
    elif mosek_fusion_Model._match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
      return self._getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(*args)
    else:
      raise ValueError('Invalid argument list getProblemStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getProblemStatus()\n\tmosek.fusion.Model.getProblemStatus(mosek.fusion.SolutionType)')
  def getAcceptedSolutionStatus(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getAcceptedSolutionStatus_(*args):
      return self._getAcceptedSolutionStatus_(*args)
    elif mosek_fusion_Model._match_alt_getAcceptedSolutionStatus_(*args):
      return self._getAcceptedSolutionStatus_alt_(*args)
    else:
      raise ValueError('Invalid argument list getAcceptedSolutionStatus('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getAcceptedSolutionStatus()')
  def getTask(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getTask_(*args):
      return self._getTask_(*args)
    elif mosek_fusion_Model._match_alt_getTask_(*args):
      return self._getTask_alt_(*args)
    else:
      raise ValueError('Invalid argument list getTask('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getTask()')
  def getVariableDuals(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getVariableDuals_Z_3J_3DI(*args):
      return self._getVariableDuals_Z_3J_3DI(*args)
    elif mosek_fusion_Model._match_alt_getVariableDuals_Z_3J_3DI(*args):
      return self._getVariableDuals_alt_Z_3J_3DI(*args)
    else:
      raise ValueError('Invalid argument list getVariableDuals('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariableDuals(bool,array(int64,ndim=1),array(double,ndim=1),int32)')
  def hasParameter(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_hasParameter_S(*args):
      return self._hasParameter_S(*args)
    elif mosek_fusion_Model._match_alt_hasParameter_S(*args):
      return self._hasParameter_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasParameter('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasParameter(string)')
  def getVariableValues(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getVariableValues_Z_3J_3DI(*args):
      return self._getVariableValues_Z_3J_3DI(*args)
    elif mosek_fusion_Model._match_alt_getVariableValues_Z_3J_3DI(*args):
      return self._getVariableValues_alt_Z_3J_3DI(*args)
    else:
      raise ValueError('Invalid argument list getVariableValues('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getVariableValues(bool,array(int64,ndim=1),array(double,ndim=1),int32)')
  def getConstraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getConstraint_S(*args):
      return self._getConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_S(*args):
      return self._getConstraint_alt_S(*args)
    elif mosek_fusion_Model._match_getConstraint_I(*args):
      return self._getConstraint_I(*args)
    elif mosek_fusion_Model._match_alt_getConstraint_I(*args):
      return self._getConstraint_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getConstraint(string)\n\tmosek.fusion.Model.getConstraint(int32)')
  def writeTaskNoFlush(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_writeTaskNoFlush_S(*args):
      return self._writeTaskNoFlush_S(*args)
    elif mosek_fusion_Model._match_alt_writeTaskNoFlush_S(*args):
      return self._writeTaskNoFlush_alt_S(*args)
    else:
      raise ValueError('Invalid argument list writeTaskNoFlush('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.writeTaskNoFlush(string)')
  def getSolverIntInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverIntInfo_S(*args):
      return self._getSolverIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverIntInfo_S(*args):
      return self._getSolverIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverIntInfo(string)')
  def getSolverLIntInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverLIntInfo_S(*args):
      return self._getSolverLIntInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverLIntInfo_S(*args):
      return self._getSolverLIntInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverLIntInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverLIntInfo(string)')
  def dataReport(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_dataReport_(*args):
      return self._dataReport_(*args)
    elif mosek_fusion_Model._match_alt_dataReport_(*args):
      return self._dataReport_alt_(*args)
    elif mosek_fusion_Model._match_dataReport_I(*args):
      return self._dataReport_I(*args)
    elif mosek_fusion_Model._match_alt_dataReport_I(*args):
      return self._dataReport_alt_I(*args)
    else:
      raise ValueError('Invalid argument list dataReport('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.dataReport()\n\tmosek.fusion.Model.dataReport(int32)')
  @staticmethod
  def solveBatch(*args):
    if False: pass
    elif mosek_fusion_Model._match_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
      return mosek_fusion_Model._solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args)
    elif mosek_fusion_Model._match_alt_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
      return mosek_fusion_Model._solveBatch_alt_ZDI_3Lmosek_4fusion_4Model_2(*args)
    else:
      raise ValueError('Invalid argument list solveBatch('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.solveBatch(bool,double,int32,array(mosek.fusion.Model,ndim=1))')
  def hasConstraint(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_hasConstraint_S(*args):
      return self._hasConstraint_S(*args)
    elif mosek_fusion_Model._match_alt_hasConstraint_S(*args):
      return self._hasConstraint_alt_S(*args)
    else:
      raise ValueError('Invalid argument list hasConstraint('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.hasConstraint(string)')
  def getSolverDoubleInfo(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_getSolverDoubleInfo_S(*args):
      return self._getSolverDoubleInfo_S(*args)
    elif mosek_fusion_Model._match_alt_getSolverDoubleInfo_S(*args):
      return self._getSolverDoubleInfo_alt_S(*args)
    else:
      raise ValueError('Invalid argument list getSolverDoubleInfo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.getSolverDoubleInfo(string)')
  def clone(self,*args):
    if False: pass
    elif mosek_fusion_Model._match_clone_(*args):
      return self._clone_(*args)
    elif mosek_fusion_Model._match_alt_clone_(*args):
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Model.clone()')
  def __repr__(self): return 'mosek.fusion.Model'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2(m):
    o = Model.__new__(Model)
    o._ctor_init_Lmosek_4fusion_4Model_2(m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2(*args):
    if len(args) != 1: return False
    m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2(self,m):
    self._ctor_init_Lmosek_4fusion_4Model_2(m)
  def _ctor_init_Lmosek_4fusion_4Model_2(self,m):
   mosek_fusion_BaseModel._ctor_init_Lmosek_4fusion_4BaseModel_2(self,m)
   _0=self
   self.__model_name = (m.__model_name)
   self.__acceptable_sol = (m.__acceptable_sol)
   self.__solutionptr = (m.__solutionptr)
   self.__sol_itr = ((m.__sol_itr)._clone_() if (((m.__sol_itr) is not None) ) else None)
   self.__sol_itg = ((m.__sol_itg)._clone_() if (((m.__sol_itg) is not None) ) else None)
   self.__sol_bas = ((m.__sol_bas)._clone_() if (((m.__sol_bas) is not None) ) else None)
   self.__num_task_afe = (m.__num_task_afe)
   self.__num_task_con = (m.__num_task_con)
   self.__num_task_acc = (m.__num_task_acc)
   self.__con_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__con_blocks))
   self.__afe_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__afe_blocks))
   self.__obj_blocks = mosek_fusion_RowBlockManager._ctor_Lmosek_4fusion_4RowBlockManager_2((m.__obj_blocks))
   self.__acc_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__acc_block_map))
   self.__acon_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__acon_block_map))
   self.__acon_acc = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_acc))
   self.__acon_afe = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_afe))
   self.__acon_elm_accid = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_accid))
   self.__acon_elm_scale = mosek.fusion.Utils.Tools._arraycopy__3D((m.__acon_elm_scale))
   self.__acon_elm_ofs = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_ofs))
   self.__acon_elm_afe = mosek.fusion.Utils.Tools._arraycopy__3I((m.__acon_elm_afe))
   self.__task_numaferow = (m.__task_numaferow)
   self.__var_block_map = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((m.__var_block_map))
   self.__var_block_acc_id = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_block_acc_id))
   self.__var_elm_acc_idx = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_elm_acc_idx))
   self.__var_elm_acc_ofs = mosek.fusion.Utils.Tools._arraycopy__3I((m.__var_elm_acc_ofs))
   self.__barvar_num = 0
   self.__barvar_dim = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_dim))
   self.__barvar_block_ptr = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_ptr))
   self.__barvar_block_dim = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_dim))
   self.__barvar_block_elm_ptr = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_ptr))
   self.__barvar_block_elm_barj = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_barj))
   self.__barvar_block_elm_i = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_i))
   self.__barvar_block_elm_j = mosek.fusion.Utils.Tools._arraycopy__3I((m.__barvar_block_elm_j))
   self.__vars = numpy.array([((m.__vars)[_1]._clone_Lmosek_4fusion_4Model_2(_0) if (((m.__vars)[_1] is not None) ) else None) for _1 in range(0,int(((m.__vars)).shape[0]))], dtype=numpy.dtype(object))
   self.__barvars = numpy.array([((m.__barvars)[_2]._clone_Lmosek_4fusion_4Model_2(_0) if (((m.__barvars)[_2] is not None) ) else None) for _2 in range(0,int(((m.__barvars)).shape[0]))], dtype=numpy.dtype(object))
   self.__var_map = (m.__var_map)._clone_()
   self.__cons = numpy.array([((m.__cons)[_3]._clone_Lmosek_4fusion_4Model_2(_0) if (((m.__cons)[_3] is not None) ) else None) for _3 in range(0,int(((m.__cons)).shape[0]))], dtype=numpy.dtype(object))
   self.__acons = numpy.array([((m.__acons)[_4]._clone_Lmosek_4fusion_4Model_2(_0) if (((m.__acons)[_4] is not None) ) else None) for _4 in range(0,int(((m.__acons)).shape[0]))], dtype=numpy.dtype(object))
   self.__con_map = (m.__con_map)._clone_()
   self.__numparameter = (m.__numparameter)
   self.__parameters = (None if (((m.__parameters) is None) ) else numpy.array([((m.__parameters)[_5]._clone_Lmosek_4fusion_4Model_2(_0) if (((m.__parameters)[_5] is not None) ) else None) for _5 in range(0,int(((m.__parameters)).shape[0]))], dtype=numpy.dtype(object)))
   self.__par_map = (m.__par_map)._clone_()
   self.__param_num = (m.__param_num)
   self.__param_value = (mosek.fusion.Utils.Tools._arraycopy__3D((m.__param_value)) if (((m.__param_value) is not None) ) else None)
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self.__bfixidx = (m.__bfixidx)
   self.__rs = mosek_fusion_WorkStack._ctor_()
   self.__ws = mosek_fusion_WorkStack._ctor_()
   self.__xs = mosek_fusion_WorkStack._ctor_()
  @staticmethod
  def _ctor_SI(name,basesize):
    o = Model.__new__(Model)
    o._ctor_init_SI(name,basesize)
    return o
  @staticmethod
  def __match_ctor_SI(*args):
    if len(args) != 2: return False
    name,basesize, = args
    return (__arg_match_S__(name) and __arg_match_I__(basesize))
  @staticmethod
  def __match_alt_ctor_SI(*args):
    if len(args) != 2: return False
    name,basesize, = args
    return (__arg_alt_match_S__(name) and __arg_alt_match_I__(basesize))
  def _ctor_alt_init_SI(self,name,basesize):
    self._ctor_init_SI(name,numpy.int32(basesize))
  def _ctor_init_SI(self,name,basesize):
   mosek_fusion_BaseModel._ctor_init_SS(self,name,"")
   self.__model_name = name
   self.__acceptable_sol = mosek.fusion.AccSolutionStatus.Optimal
   self.__solutionptr = mosek.fusion.SolutionType.Default
   self.__sol_itr = None
   self.__sol_itg = None
   self.__sol_bas = None
   self.__num_task_afe = 0
   self.__num_task_con = 0
   self.__num_task_acc = 0
   self.__con_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__afe_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__obj_blocks = mosek_fusion_RowBlockManager._ctor_()
   self.__acc_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__acon_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__task_numaferow = 0
   self.__acon_acc = numpy.zeros((self.__acon_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_afe = numpy.zeros((self.__acon_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_accid = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_scale = numpy.array([1.0 for _0 in range(0,self.__acon_block_map._capacity_())], dtype=numpy.dtype(numpy.float64))
   self.__acon_elm_ofs = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__acon_elm_afe = numpy.zeros((self.__acon_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_block_map = mosek_fusion_LinkedBlocks._ctor_()
   self.__var_block_acc_id = numpy.zeros((self.__var_block_map._block_1capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_elm_acc_idx = numpy.zeros((self.__var_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__var_elm_acc_ofs = numpy.zeros((self.__var_block_map._capacity_(),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_num = 0
   self.__barvar_dim = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_ptr = numpy.zeros(((basesize + 1),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_dim = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_ptr = numpy.zeros(((basesize + 1),), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_barj = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_i = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__barvar_block_elm_j = numpy.zeros((basesize,), dtype=numpy.dtype(numpy.int32))
   self.__vars = numpy.array([None for _1 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__barvars = numpy.array([None for _2 in range(0,basesize)], dtype=numpy.dtype(object))
   self.__var_map = mosek.fusion.Utils.StringIntMap()
   self.__initsol_xx = None
   self.__initsol_xx_flag = None
   self.__cons = numpy.array([None for _3 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__acons = numpy.array([None for _4 in range(0,(basesize * 8))], dtype=numpy.dtype(object))
   self.__con_map = mosek.fusion.Utils.StringIntMap()
   self.__numparameter = 0
   self.__parameters = None
   self.__par_map = mosek.fusion.Utils.StringIntMap()
   self.__param_num = 0
   self.__param_value = None
   _5=numpy.zeros((1,), dtype=numpy.dtype(numpy.int32))
   _6=self.__linearvar_1alloc_I_3I(1,_5)
   self.__bfixidx = _5[0]
   self._task_1var_1putboundlist_1fx__3I_3D(numpy.array([self.__bfixidx], dtype=numpy.dtype(numpy.int32)),numpy.array([1.0], dtype=numpy.dtype(numpy.float64)))
   self._task_1var_1name_IS(self.__bfixidx,"1.0")
   self._task_1append_1domain_1empty_()
   self.__rs = mosek_fusion_WorkStack._ctor_()
   self.__ws = mosek_fusion_WorkStack._ctor_()
   self.__xs = mosek_fusion_WorkStack._ctor_()
  @staticmethod
  def _ctor_I(basesize):
    o = Model.__new__(Model)
    o._ctor_init_I(basesize)
    return o
  @staticmethod
  def __match_ctor_I(*args):
    if len(args) != 1: return False
    basesize, = args
    return (__arg_match_I__(basesize))
  @staticmethod
  def __match_alt_ctor_I(*args):
    if len(args) != 1: return False
    basesize, = args
    return (__arg_alt_match_I__(basesize))
  def _ctor_alt_init_I(self,basesize):
    self._ctor_init_I(numpy.int32(basesize))
  def _ctor_init_I(self,basesize):
   mosek_fusion_Model._ctor_init_SI(self,"",basesize)
  @staticmethod
  def _ctor_S(name):
    o = Model.__new__(Model)
    o._ctor_init_S(name)
    return o
  @staticmethod
  def __match_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_match_S__(name))
  @staticmethod
  def __match_alt_ctor_S(*args):
    if len(args) != 1: return False
    name, = args
    return (__arg_alt_match_S__(name))
  def _ctor_alt_init_S(self,name):
    self._ctor_init_S(name)
  def _ctor_init_S(self,name):
   mosek_fusion_Model._ctor_init_SI(self,name,128)
  @staticmethod
  def _ctor_():
    o = Model.__new__(Model)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_Model._ctor_init_S(self,"")
  @staticmethod
  def _match_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match__3Lmosek_4fusion_4Term_2__(_1))
  @staticmethod
  def _match_alt_disjunction_S_3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3Lmosek_4fusion_4Term_2__(_1))
  def _disjunction_alt_S_3Lmosek_4fusion_4Term_2(self,_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(object))
   _1_res = self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction_S_3Lmosek_4fusion_4Term_2(self,_0,_1):
   _2=int((_1).shape[0])
   _3=0
   _4=0
   _5=0
   _6=0
   for _7 in range(0,_2):
    _3 += _1[_7]._size_()
    _4 += _1[_7]._num_()
    _6 += _1[_7]._numaccrows_()
    _5 += _1[_7]._numaccterms_()
   _8=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int32))
   _9=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _10=numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
   _11=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int64))
   _12=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
   _13=self.__afe_1allocate__3I(_8)
   _14=0
   _15=0
   _16=0
   _17=0
   for _18 in range(0,_2):
    for _19 in range(0,_1[_18]._num_()):
     _20=(_1[_18]._domains)[_19]
     _21=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2((_1[_18]._exprs)[_19])))
     _21._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__rs,self.__ws,self.__xs)
     self.__rs._pop_1expr_()
     _22=(self.__rs.i32)
     _23=(self.__rs.i64)
     _24=(self.__rs.f64)
     _25=(self.__rs.nd)
     _26=(self.__rs.shape_base)
     _27=(self.__rs.nelem)
     _28=(self.__rs.nnz)
     _29=(self.__rs.ncodeatom)
     _30=(self.__rs.hassp)
     _31=(self.__rs.ptr_base)
     _32=(self.__rs.nidxs_base)
     _33=(self.__rs.cof_base)
     _34=(self.__rs.code_base)
     _35=(self.__rs.codeptr_base)
     _36=(self.__rs.cconst_base)
     _37=numpy.array([_22[(_26 + _38)] for _38 in range(0,_25)], dtype=numpy.dtype(numpy.int32))
     self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_8,_17,self.__rs,_27,_28,_31,_32,_33)
     if ((_20.dom)==mosek.fusion.DJCDomainType.InRange):
      _39=(_20.b)
      _40=(_20.par)
      fragments._c_closure_1(_9,_10,_8,_17,_16,_39,_27,_40) 
      _11[_15] = self._task_1append_1domain_1rpos_I(_27)
      _11[(_15 + 1)] = self._task_1append_1domain_1rneg_I(_27)
      _12[_18] += 2
      _15 += 2
      _16 += (_27 * 2)
     elif (((_20.dom)==mosek.fusion.DJCDomainType.EqualTo) or (((_20.dom)==mosek.fusion.DJCDomainType.LessThan) or (((_20.dom)==mosek.fusion.DJCDomainType.GreaterThan) or ((_20.dom)==mosek.fusion.DJCDomainType.IsFree)))):
      _41=(_20.b)
      fragments._c_closure_2(_9,_10,_8,_17,_16,_41,_27) 
      if ((_20.dom)==mosek.fusion.DJCDomainType.EqualTo):
       _11[_15] = self._task_1append_1domain_1rzero_I(_27)
      elif ((_20.dom)==mosek.fusion.DJCDomainType.LessThan):
       _11[_15] = self._task_1append_1domain_1rneg_I(_27)
      elif ((_20.dom)==mosek.fusion.DJCDomainType.GreaterThan):
       _11[_15] = self._task_1append_1domain_1rpos_I(_27)
      else:
       _11[_15] = self._task_1append_1domain_1r_I(_27)
      _12[_18] += 1
      _15 += 1
      _16 += _27
     else:
      raise mosek_fusion_UnexpectedError._ctor_S("Not implemented: Non-linear conic DJC constraints")
     if (_29 > 0):
      self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([_8[(_17 + _42)] for _42 in range(0,_27)], dtype=numpy.dtype(numpy.int32)),_31,_32,_35,_34,_36)
     _17 += _27
     _14 += 1
   _43=self._task_1append_1djc_J(1)
   self._task_1putdjcslice_JJ_3J_3J_3J_3J_3D(_43,(_43 + 1),numpy.array([numpy.int64(_2)], dtype=numpy.dtype(numpy.int64)),_12,_11,numpy.array([_9[_44] for _44 in range(0,int((_9).shape[0]))], dtype=numpy.dtype(numpy.int64)),_10)
   if (int(len(_0)) > 0):
    self._task_1djc_1name_JS(_43,mosek.fusion.Utils.StringBuffer()._a_S(_0)._a_S("[")._a_S("]")._toString_())
   return (mosek_fusion_Disjunction._ctor_J(_43))
  @staticmethod
  def _match_disjunction__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Term_2__(_0))
  @staticmethod
  def _match_alt_disjunction__3Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Term_2__(_0))
  def _disjunction_alt__3Lmosek_4fusion_4Term_2(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = self._disjunction__3Lmosek_4fusion_4Term_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction__3Lmosek_4fusion_4Term_2(self,_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",_0))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(_0))
  def _disjunction_alt_Lmosek_4fusion_4DisjunctionTerms_2(self,_t__0):
    return self._disjunction_Lmosek_4fusion_4DisjunctionTerms_2(_0)
  def _disjunction_Lmosek_4fusion_4DisjunctionTerms_2(self,_0):
   return (self._disjunction__3Lmosek_4fusion_4Term_2((_0._terms)))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4DisjunctionTerms_2__(_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4DisjunctionTerms_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4DisjunctionTerms_2__(_1))
  def _disjunction_alt_SLmosek_4fusion_4DisjunctionTerms_2(self,_t__0,_t__1):
    return self._disjunction_SLmosek_4fusion_4DisjunctionTerms_2(_0,_1)
  def _disjunction_SLmosek_4fusion_4DisjunctionTerms_2(self,_0,_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,(_1._terms)))
  @staticmethod
  def _match_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match__3Lmosek_4fusion_4ExprDomain_2__(_1))
  @staticmethod
  def _match_alt_disjunction_S_3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_1))
  def _disjunction_alt_S_3Lmosek_4fusion_4ExprDomain_2(self,_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(object))
   _1_res = self._disjunction_S_3Lmosek_4fusion_4ExprDomain_2(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction_S_3Lmosek_4fusion_4ExprDomain_2(self,_0,_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,numpy.array([_1[_2]._toDJCTerm_() for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4ExprDomain_2__(_0))
  @staticmethod
  def _match_alt_disjunction__3Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4ExprDomain_2__(_0))
  def _disjunction_alt__3Lmosek_4fusion_4ExprDomain_2(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = self._disjunction__3Lmosek_4fusion_4ExprDomain_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _disjunction__3Lmosek_4fusion_4ExprDomain_2(self,_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_0[_1]._toDJCTerm_() for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ExprDomain_2__(_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ExprDomain_2__(_1))
  def _disjunction_alt_SLmosek_4fusion_4ExprDomain_2(self,_t__0,_t__1):
    return self._disjunction_SLmosek_4fusion_4ExprDomain_2(_0,_1)
  def _disjunction_SLmosek_4fusion_4ExprDomain_2(self,_0,_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,numpy.array([_1._toDJCTerm_()], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprDomain_2__(_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4ExprDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprDomain_2__(_0))
  def _disjunction_alt_Lmosek_4fusion_4ExprDomain_2(self,_t__0):
    return self._disjunction_Lmosek_4fusion_4ExprDomain_2(_0)
  def _disjunction_Lmosek_4fusion_4ExprDomain_2(self,_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_0._toDJCTerm_()], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_0) and __arg_match_Lmosek_4fusion_4Term_2__(_1) and __arg_match_Lmosek_4fusion_4Term_2__(_2))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_2))
  def _disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__0,_t__1,_t__2):
    return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_0,_1,_2)
  def _disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_0,_1,_2):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_0,_1,_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_0) and __arg_match_Lmosek_4fusion_4Term_2__(_1))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_1))
  def _disjunction_alt_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__0,_t__1):
    return self._disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_0,_1)
  def _disjunction_Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_0,_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_0,_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Term_2__(_0))
  @staticmethod
  def _match_alt_disjunction_Lmosek_4fusion_4Term_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Term_2__(_0))
  def _disjunction_alt_Lmosek_4fusion_4Term_2(self,_t__0):
    return self._disjunction_Lmosek_4fusion_4Term_2(_0)
  def _disjunction_Lmosek_4fusion_4Term_2(self,_0):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2("",numpy.array([_0], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Term_2__(_1) and __arg_match_Lmosek_4fusion_4Term_2__(_2) and __arg_match_Lmosek_4fusion_4Term_2__(_3))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_2) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_3))
  def _disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_0,_1,_2,_3)
  def _disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_0,_1,_2,_3):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,numpy.array([_1,_2,_3], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Term_2__(_1) and __arg_match_Lmosek_4fusion_4Term_2__(_2))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_2))
  def _disjunction_alt_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_t__0,_t__1,_t__2):
    return self._disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(_0,_1,_2)
  def _disjunction_SLmosek_4fusion_4Term_2Lmosek_4fusion_4Term_2(self,_0,_1,_2):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,numpy.array([_1,_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_disjunction_SLmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Term_2__(_1))
  @staticmethod
  def _match_alt_disjunction_SLmosek_4fusion_4Term_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Term_2__(_1))
  def _disjunction_alt_SLmosek_4fusion_4Term_2(self,_t__0,_t__1):
    return self._disjunction_SLmosek_4fusion_4Term_2(_0,_1)
  def _disjunction_SLmosek_4fusion_4Term_2(self,_0,_1):
   return (self._disjunction_S_3Lmosek_4fusion_4Term_2(_0,numpy.array([_1], dtype=numpy.dtype(object))))
  def _formstConstr_alt_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._formstConstr_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _formstConstr_Lmosek_4fusion_4Utils_4StringBuffer_2_3I_3I(self,_0,_1,_2):
   return (_0)
  def __acon_1release_alt_I(self,_t__0):
    return self.__acon_1release_I(numpy.int32(__0))
  def __acon_1release_I(self,_0):
   _1=self.__acon_block_map._blocksize_I(_0)
   if (_1 >= 0):
    _2=self.__acc_block_map._blocksize_I(self.__acon_acc[_0])
    _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    _4=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    self.__acc_block_map._get_I_3II(self.__acon_acc[_0],_3,0)
    self.__acc_block_map._free_I(self.__acon_acc[_0])
    self.__afe_blocks._get_I_3II(self.__acon_afe[_0],_4,0)
    self.__afe_1release_I(self.__acon_afe[_0])
    self.__acon_block_map._free_I(_0)
    self._task_1clearafelist__3J(numpy.array([_4[_5] for _5 in range(0,_1)], dtype=numpy.dtype(numpy.int64)))
    self._task_1putacclist__3J_3J_3J_3D(numpy.array([_3[_6] for _6 in range(0,_2)], dtype=numpy.dtype(numpy.int64)),numpy.array([0 for _7 in range(0,_2)], dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
  def __acon_1allocate_alt_JII_3D_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.int64(_t__0)
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.float64))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__acon_1allocate_JII_3D_3I_3I(_0,_1,_2,_3,_4,_5)
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __acon_1allocate_JII_3D_3I_3I(self,_0,_1,_2,_3,_4,_5):
   _6=(_2 * _1)
   _7=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _8=self.__acon_block_map._alloc_I(_6)
   _9=self.__acc_block_map._alloc_I(_2)
   _10=self.__afe_1allocate__3I(_4)
   self.__acon_block_map._get_I_3II(_8,_7,0)
   self.__acc_block_map._get_I_3II(_9,_5,0)
   _11=self.__acon_block_map._block_1capacity_()
   _12=self.__acon_block_map._capacity_()
   if (_11 > int((self.__acon_acc).shape[0])):
    _13=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
    _14=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_acc,0,_13,0,int((self.__acon_acc).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_afe,0,_14,0,int((self.__acon_afe).shape[0]))
    self.__acon_acc = _13
    self.__acon_afe = _14
   self.__acon_acc[_8] = _9
   self.__acon_afe[_8] = _10
   if (_8 >= int((self.__acons).shape[0])):
    _15=numpy.array([None for _16 in range(0,(int((self.__acons).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _17 in range(0,int((self.__acons).shape[0])):
     _15[_17] = self.__acons[_17]
    self.__acons = _15
   if (_12 > int((self.__acon_elm_accid).shape[0])):
    _18=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _19=numpy.zeros((_12,), dtype=numpy.dtype(numpy.float64))
    _20=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _21=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_accid,0,_18,0,int((self.__acon_elm_accid).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.__acon_elm_scale,0,_19,0,int((self.__acon_elm_scale).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_ofs,0,_20,0,int((self.__acon_elm_ofs).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__acon_elm_afe,0,_21,0,int((self.__acon_elm_afe).shape[0]))
    self.__acon_elm_accid = _18
    self.__acon_elm_ofs = _20
    self.__acon_elm_afe = _21
    self.__acon_elm_scale = _19
   _22=0
   _22 = fragments._c_closure_3(_5,_22)
   _22 = numpy.int32(_22) # postprocess
   _22 += 1
   _23=self._task_1numacc_()
   if (_23 < _22):
    self._task_1append_1accs_JI_3J_3D(0,(_22 - _23),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.float64)))
   self._task_1putacclist__3J_3J_3J_3D(numpy.array([_5[_24] for _24 in range(0,int((_5).shape[0]))], dtype=numpy.dtype(numpy.int64)),numpy.array([_0 for _25 in range(0,int((_5).shape[0]))], dtype=numpy.dtype(numpy.int64)),numpy.array([_4[_26] for _26 in range(0,int((_4).shape[0]))], dtype=numpy.dtype(numpy.int64)),_3)
   fragments._c_closure_4(_5,self.__acon_elm_accid,self.__acon_elm_afe,self.__acon_elm_ofs,self.__acon_elm_scale,_7,_4,_1,_2) 
   return numpy.int32(_8)
  def __afe_1release_alt_I(self,_t__0):
    return self.__afe_1release_I(numpy.int32(__0))
  def __afe_1release_I(self,_0):
   _1=numpy.zeros((self.__afe_blocks._blocksize_I(_0),), dtype=numpy.dtype(numpy.int32))
   self.__afe_blocks._release_I_3I(_0,_1)
   self._task_1clearafelist__3J(numpy.array([_1[_2] for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int64)))
  def __afe_1allocate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__afe_1allocate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __afe_1allocate__3I(self,_0):
   _1=self.__afe_blocks._allocate__3I(_0)
   if (int((_0).shape[0]) > 0):
    _2=self._task_1numafe_()
    _3=_0[0]
    _3 = fragments._c_closure_5(_3,_0)
    _3 = numpy.int32(_3) # postprocess
    if ((_3 + 1) > _2):
     _4=((_3 + 1) - _2)
     self._task_1append_1afes_J(_4)
     self.__task_numaferow += _4
   return numpy.int32(_1)
  def __con_1release_alt_I(self,_t__0):
    return self.__con_1release_I(numpy.int32(__0))
  def __con_1release_I(self,_0):
   _1=self.__con_blocks._blocksize_I(_0)
   if (_1 >= 0):
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    self.__con_blocks._release_I_3I(_0,_2)
    self.__cons[_0] = None
    self._task_1con_1putboundlist_1fr__3I(_2)
  def __con_1allocate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__con_1allocate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __con_1allocate__3I(self,_0):
   _1=self.__con_blocks._allocate__3I(_0)
   if (int((_0).shape[0]) > 0):
    _2=_0[0]
    _2 = fragments._c_closure_6(_2,_0)
    _2 = numpy.int32(_2) # postprocess
    if ((_2 + 1) > self.__num_task_con):
     _3=((_2 + 1) - self.__num_task_con)
     self._task_1append_1con_I(_3)
     self.__num_task_con += _3
   if (_1 >= int((self.__cons).shape[0])):
    _4=numpy.array([None for _5 in range(0,(int((self.__cons).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _6 in range(0,int((self.__cons).shape[0])):
     _4[_6] = self.__cons[_6]
    self.__cons = _4
   return numpy.int32(_1)
  def __barvar_1alloc_alt_II_3I_3J(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.int32(_t__0)
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__barvar_1alloc_II_3I_3J(_0,_1,_2,_3)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __barvar_1alloc_II_3I_3J(self,_0,_1,_2,_3):
   _4=self.__barvar_num
   self.__barvar_num += 1
   _5=((_0 * (_0 + 1)) // 2)
   _6=(_5 * _1)
   _7=self.__barvar_block_ptr[_4]
   _8=int((self.__barvar_block_dim).shape[0])
   _9=self.__barvar_block_elm_ptr[_4]
   _10=int((self.__barvar_block_elm_barj).shape[0])
   if (_8 < (_7 + 1)):
    _11=numpy.zeros(((int((self.__barvar_block_dim).shape[0]) * 2),), dtype=numpy.dtype(numpy.int32))
    _12=numpy.zeros((((int((self.__barvar_block_dim).shape[0]) * 2) + 1),), dtype=numpy.dtype(numpy.int32))
    _13=numpy.zeros((((int((self.__barvar_block_dim).shape[0]) * 2) + 1),), dtype=numpy.dtype(numpy.int32))
    _14=numpy.array([None for _15 in range(0,((int((self.__barvar_block_dim).shape[0]) * 2) + 1))], dtype=numpy.dtype(object))
    for _16 in range(0,int((self.__barvars).shape[0])):
     _14[_16] = self.__barvars[_16]
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_dim,0,_11,0,int((self.__barvar_block_dim).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_ptr,0,_12,0,int((self.__barvar_block_ptr).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_ptr,0,_13,0,int((self.__barvar_block_elm_ptr).shape[0]))
    self.__barvar_block_dim = _11
    self.__barvar_block_ptr = _12
    self.__barvar_block_elm_ptr = _13
    self.__barvars = _14
   if (_10 < (_9 + _6)):
    _17=((_10 + _6) - _9)
    if (_17 < _10):
     _17 = _10
    _18=(_10 + _17)
    _19=numpy.zeros((_18,), dtype=numpy.dtype(numpy.int32))
    _20=numpy.zeros((_18,), dtype=numpy.dtype(numpy.int32))
    _21=numpy.zeros((_18,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_barj,0,_19,0,int((self.__barvar_block_elm_barj).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_i,0,_20,0,int((self.__barvar_block_elm_i).shape[0]))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_block_elm_j,0,_21,0,int((self.__barvar_block_elm_j).shape[0]))
    self.__barvar_block_elm_barj = _19
    self.__barvar_block_elm_i = _20
    self.__barvar_block_elm_j = _21
   _22=self._task_1numbarvar_()
   fragments._c_closure_7(_2,_22,_1) 
   if ((_22 + _1) >= int((self.__barvar_dim).shape[0])):
    _23=((_22 + _1) - int((self.__barvar_dim).shape[0]))
    if (_23 < int((self.__barvar_dim).shape[0])):
     _23 = int((self.__barvar_dim).shape[0])
    _24=(_23 + int((self.__barvar_dim).shape[0]))
    _25=numpy.zeros((_24,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__barvar_dim,0,_25,0,int((self.__barvar_dim).shape[0]))
    self.__barvar_dim = _25
   self.__barvar_block_dim[_4] = _0
   self.__barvar_block_ptr[(_4 + 1)] = (self.__barvar_block_ptr[_4] + _1)
   self.__barvar_block_elm_ptr[(_4 + 1)] = (self.__barvar_block_elm_ptr[_4] + _6)
   fragments._c_closure_8(self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_block_elm_ptr,self.__barvar_dim,_4,_0,_22,_3,_1) 
   _26=self._task_1append_1barvar_II(_0,_1)
   return numpy.int32(_4)
  def __conicvar_1alloc_alt_JII_3I_3I(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.int64(_t__0)
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__conicvar_1alloc_JII_3I_3I(_0,_1,_2,_3,_4)
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __conicvar_1alloc_JII_3I_3I(self,_0,_1,_2,_3,_4):
   _5=(_1 * _2)
   _6=self.__linearvar_1alloc_I_3I(_5,_4)
   _7=numpy.zeros((_5,), dtype=numpy.dtype(numpy.float64))
   _8=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
   _9=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
   _10=self.__acon_1allocate_JII_3D_3I_3I(_0,_1,_2,_7,_9,_3)
   self.__var_block_acc_id[_6] = _10
   fragments._c_closure_9(_3,_1,_5,_4,self.__var_elm_acc_idx,self.__var_elm_acc_ofs) 
   self._task_1putafeflist__3J_3I_3I_3D_3D(numpy.array([_9[_11] for _11 in range(0,int((_9).shape[0]))], dtype=numpy.dtype(numpy.int64)),numpy.array([_12 for _12 in range(0,(_5 + 1))], dtype=numpy.dtype(numpy.int32)),_4,numpy.array([1.0 for _13 in range(0,_5)], dtype=numpy.dtype(numpy.float64)),numpy.array([0.0 for _14 in range(0,_5)], dtype=numpy.dtype(numpy.float64)))
   return numpy.int32(_6)
  def __linearvar_1alloc_alt_I_3I(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__linearvar_1alloc_I_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __linearvar_1alloc_I_3I(self,_0,_1):
   _2=self.__var_block_map._alloc_I(_0)
   _3=(self.__var_block_map._maxidx_I(_2) + 1)
   _4=self.__var_block_map._capacity_()
   _5=self.__var_block_map._block_1capacity_()
   self.__var_block_map._get_I_3II(_2,_1,0)
   if (self._task_1numvar_() < _3):
    self._task_1append_1var_I((_3 - self._task_1numvar_()))
   if (_2 >= int((self.__vars).shape[0])):
    _6=numpy.array([None for _7 in range(0,(int((self.__vars).shape[0]) * 2))], dtype=numpy.dtype(object))
    for _8 in range(0,int((self.__vars).shape[0])):
     _6[_8] = self.__vars[_8]
    self.__vars = _6
   if (_5 > int((self.__var_block_acc_id).shape[0])):
    _9=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_block_acc_id,0,_9,0,int((self.__var_block_acc_id).shape[0]))
    self.__var_block_acc_id = _9
   if (_4 > int((self.__var_elm_acc_idx).shape[0])):
    _10=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_elm_acc_idx,0,_10,0,int((self.__var_elm_acc_idx).shape[0]))
    self.__var_elm_acc_idx = _10
    _11=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.__var_elm_acc_ofs,0,_11,0,int((self.__var_elm_acc_ofs).shape[0]))
    self.__var_elm_acc_ofs = _11
   self.__var_block_acc_id[_2] = (- 1)
   fragments._c_closure_10(_0,_1,self.__var_elm_acc_idx) 
   return numpy.int32(_2)
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1continuous__3J(self,_0):
   _1=0
   _1 = fragments._c_closure_11(_1,_0)
   _1 = numpy.int32(_1) # postprocess
   _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
   _3=0
   _3 = fragments._c_closure_12(_0,_3,_2)
   _3 = numpy.int32(_3) # postprocess
   self._task_1var_1putcontlist__3I(_2)
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1integer__3J(self,_0):
   _1=0
   _1 = fragments._c_closure_13(_1,_0)
   _1 = numpy.int32(_1) # postprocess
   _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
   _3=0
   _3 = fragments._c_closure_14(_0,_3,_2)
   _3 = numpy.int32(_3) # postprocess
   self._task_1var_1putintlist__3I(_2)
  @staticmethod
  def _match_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Z__(_0))
  @staticmethod
  def _match_alt_putlicensewait_Z(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Z__(_0))
  @staticmethod
  def _putlicensewait_alt_Z(_t__0):
    return mosek_fusion_Model._putlicensewait_Z(_0)
  @staticmethod
  def _putlicensewait_Z(_0):
   mosek.fusion.BaseModel._env_1putlicensewait_Z(_0)
  @staticmethod
  def _match_putlicensepath_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_putlicensepath_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  @staticmethod
  def _putlicensepath_alt_S(_t__0):
    return mosek_fusion_Model._putlicensepath_S(_0)
  @staticmethod
  def _putlicensepath_S(_0):
   mosek.fusion.BaseModel._env_1putlicensepath_S(_0)
  @staticmethod
  def _match_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_putlicensecode__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _putlicensecode_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Model._putlicensecode__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _putlicensecode__3I(_0):
   mosek.fusion.BaseModel._env_1putlicensecode__3I(_0)
  @staticmethod
  def _match_dispose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dispose_(*args):
    if len(args) != 0: return False
    return True
  def _dispose_alt_(self,):
    return self._dispose_()
  def _dispose_(self,):
   for _0 in range(0,int((self.__vars).shape[0])):
    self.__vars[_0] = None
   for _1 in range(0,int((self.__cons).shape[0])):
    self.__cons[_1] = None
   for _2 in range(0,int((self.__acons).shape[0])):
    self.__acons[_2] = None
   for _3 in range(0,int((self.__barvars).shape[0])):
    self.__barvars[_3] = None
   if (self.__parameters is not None):
    for _4 in range(0,int((self.__parameters).shape[0])):
     self.__parameters[_4] = None
   mosek_fusion_BaseModel._dispose_(self)
  @staticmethod
  def _match_getTask_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getTask_(*args):
    if len(args) != 0: return False
    return True
  def _getTask_alt_(self,):
    return self._getTask_()
  def _getTask_(self,):
   return (self._task_1get_())
  @staticmethod
  def _match_getConstraintDuals_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Z__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_getConstraintDuals_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_I__(_3))
  def _getConstraintDuals_alt_Z_3I_3DI(self,_t__0,_t__1,_t__2,_t__3):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.int32(_t__3)
   _1_res = self._getConstraintDuals_Z_3I_3DI(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getConstraintDuals_Z_3I_3DI(self,_0,_1,_2,_3):
   _4=int((_1).shape[0])
   _5=self._getSolution_1slc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   _6=self._getSolution_1suc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
   for _7 in range(0,_4):
    if (_1[_7] >= 0):
     if _0:
      _2[(_3 + _7)] = _5[_1[_7]]
     else:
      _2[(_3 + _7)] = (- _6[_1[_7]])
    else:
     raise mosek_fusion_SolutionError._ctor_S("Requested invalid solution item")
  @staticmethod
  def _match_getConstraintValues_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Z__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_getConstraintValues_Z_3I_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_I__(_3))
  def _getConstraintValues_alt_Z_3I_3DI(self,_t__0,_t__1,_t__2,_t__3):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.int32(_t__3)
   _1_res = self._getConstraintValues_Z_3I_3DI(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getConstraintValues_Z_3I_3DI(self,_0,_1,_2,_3):
   _4=int((_1).shape[0])
   if _0:
    _5=self._getSolution_1xc_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _6=self._getSolution_1accx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _7=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_15(_7,_6,self.__acon_elm_accid,self.__acon_elm_ofs,self.__acon_elm_scale,_4,_1,_3,_2,_5) 
   else:
    _8=self._getSolution_1y_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _9=self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _10=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_16(_10,_9,self.__acon_elm_accid,self.__acon_elm_ofs,self.__acon_elm_scale,_4,_1,_3,_2,_8) 
  @staticmethod
  def _match_getVariableDuals_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Z__(_0) and __arg_match__3J__(_1) and __arg_match__3D__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_getVariableDuals_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_I__(_3))
  def _getVariableDuals_alt_Z_3J_3DI(self,_t__0,_t__1,_t__2,_t__3):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.int32(_t__3)
   _1_res = self._getVariableDuals_Z_3J_3DI(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getVariableDuals_Z_3J_3DI(self,_0,_1,_2,_3):
   _4=int((_1).shape[0])
   if _0:
    _5=self._getSolution_1slx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_17(_4,_1,_3,_2,_5) 
   else:
    _6=self._getSolution_1sux_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_18(_4,_1,_3,_2,_6) 
  @staticmethod
  def _match_getVariableValues_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Z__(_0) and __arg_match__3J__(_1) and __arg_match__3D__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_getVariableValues_Z_3J_3DI(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match_I__(_3))
  def _getVariableValues_alt_Z_3J_3DI(self,_t__0,_t__1,_t__2,_t__3):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.int32(_t__3)
   _1_res = self._getVariableValues_Z_3J_3DI(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getVariableValues_Z_3J_3DI(self,_0,_1,_2,_3):
   _4=int((_1).shape[0])
   self.__barvar_num = self._task_1numbarvar_()
   if _0:
    _5=self._getSolution_1xx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _6=(self._getSolution_1barx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if ((self.__barvar_num > 0) ) else None)
    fragments._c_closure_19(_6,_4,_1,_3,_2,_5) 
   else:
    _7=self._getSolution_1yx_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _8=(self._getSolution_1bars_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default) if ((self.__barvar_num > 0) ) else None)
    _9=self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    _10=self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Default)
    fragments._c_closure_20(_10,_9,_8,_4,_1,_3,_2,self.__var_elm_acc_idx,self.__var_elm_acc_ofs,_7) 
  @staticmethod
  def _match_setVariableValues_Z_3J_3D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Z__(_0) and __arg_match__3J__(_1) and __arg_match__3D__(_2))
  @staticmethod
  def _match_alt_setVariableValues_Z_3J_3D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3D__(_2))
  def _setVariableValues_alt_Z_3J_3D(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setVariableValues_Z_3J_3D(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setVariableValues_Z_3J_3D(self,_0,_1,_2):
   if _0:
    _3=0
    _3 = fragments._c_closure_21(_1,_3)
    _3 = numpy.int32(_3) # postprocess
    _4=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int32))
    _5=numpy.zeros((_3,), dtype=numpy.dtype(numpy.float64))
    _6=0
    _6 = fragments._c_closure_22(_6,_1,_4,_5,_2)
    _6 = numpy.int32(_6) # postprocess
    self._setSolution_1xx__3I_3D(_4,_5)
   else:
    pass
  @staticmethod
  def _match_flushNames_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushNames_(*args):
    if len(args) != 0: return False
    return True
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   for _0 in range(0,int((self.__vars).shape[0])):
    if (self.__vars[_0] is not None):
     self.__vars[_0]._flushNames_()
   for _1 in range(0,int((self.__barvars).shape[0])):
    if (self.__barvars[_1] is not None):
     self.__barvars[_1]._flushNames_()
   for _2 in range(0,int((self.__cons).shape[0])):
    if (self.__cons[_2] is not None):
     self.__cons[_2]._flushNames_()
   for _3 in range(0,int((self.__acons).shape[0])):
    if (self.__acons[_3] is not None):
     self.__acons[_3]._flushNames_()
  @staticmethod
  def _match_writeTaskNoFlush_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_writeTaskNoFlush_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _writeTaskNoFlush_alt_S(self,_t__0):
    return self._writeTaskNoFlush_S(_0)
  def _writeTaskNoFlush_S(self,_0):
   self._flushNames_()
   self._task_1write_S(_0)
  @staticmethod
  def _match_writeTaskStream_SLSystem_4DataStream_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_LSystem_4DataStream_2__(_1))
  @staticmethod
  def _match_alt_writeTaskStream_SLSystem_4DataStream_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_LSystem_4DataStream_2__(_1))
  def _writeTaskStream_alt_SLSystem_4DataStream_2(self,_t__0,_t__1):
    return self._writeTaskStream_SLSystem_4DataStream_2(_0,_1)
  def _writeTaskStream_SLSystem_4DataStream_2(self,_0,_1):
   self._flushNames_()
   self.__flush_1parameters_()
   self._task_1write_1stream_SLSystem_4DataStream_2(_0,_1)
  @staticmethod
  def _match_dataReport_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dataReport_(*args):
    if len(args) != 0: return False
    return True
  def _dataReport_alt_(self,):
    return self._dataReport_()
  def _dataReport_(self,):
   self._dataReport_I(10)
  @staticmethod
  def _match_dataReport_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_dataReport_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _dataReport_alt_I(self,_t__0):
    return self._dataReport_I(numpy.int32(__0))
  def _dataReport_I(self,_0):
   self.__flush_1parameters_()
   self._task_1analyze_1problem_I(_0)
  @staticmethod
  def _match_writeTask_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_writeTask_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _writeTask_alt_S(self,_t__0):
    return self._writeTask_S(_0)
  def _writeTask_S(self,_0):
   self._flushNames_()
   self.__flush_1parameters_()
   self._task_1write_S(_0)
  @staticmethod
  def _match_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverLIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverLIntInfo_alt_S(self,_t__0):
    return self._getSolverLIntInfo_S(_0)
  def _getSolverLIntInfo_S(self,_0):
   return numpy.int64(self._task_1get_1liinf_S(_0))
  @staticmethod
  def _match_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverIntInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverIntInfo_alt_S(self,_t__0):
    return self._getSolverIntInfo_S(_0)
  def _getSolverIntInfo_S(self,_0):
   return numpy.int32(self._task_1get_1iinf_S(_0))
  @staticmethod
  def _match_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getSolverDoubleInfo_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getSolverDoubleInfo_alt_S(self,_t__0):
    return self._getSolverDoubleInfo_S(_0)
  def _getSolverDoubleInfo_S(self,_0):
   return numpy.float64(self._task_1get_1dinf_S(_0))
  @staticmethod
  def _match_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4CallbackHandler_2__(_0))
  @staticmethod
  def _match_alt_setCallbackHandler_LSystem_4CallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4CallbackHandler_2__(_0))
  def _setCallbackHandler_alt_LSystem_4CallbackHandler_2(self,_t__0):
    return self._setCallbackHandler_LSystem_4CallbackHandler_2(_0)
  def _setCallbackHandler_LSystem_4CallbackHandler_2(self,_0):
   self._task_1setCallbackHandler_LSystem_4CallbackHandler_2(_0)
  @staticmethod
  def _match_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4DataCallbackHandler_2__(_0))
  @staticmethod
  def _match_alt_setDataCallbackHandler_LSystem_4DataCallbackHandler_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4DataCallbackHandler_2__(_0))
  def _setDataCallbackHandler_alt_LSystem_4DataCallbackHandler_2(self,_t__0):
    return self._setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_0)
  def _setDataCallbackHandler_LSystem_4DataCallbackHandler_2(self,_0):
   self._task_1setDataCallbackHandler_LSystem_4DataCallbackHandler_2(_0)
  @staticmethod
  def _match_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_LSystem_4StreamWriter_2__(_0))
  @staticmethod
  def _match_alt_setLogHandler_LSystem_4StreamWriter_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_LSystem_4StreamWriter_2__(_0))
  def _setLogHandler_alt_LSystem_4StreamWriter_2(self,_t__0):
    return self._setLogHandler_LSystem_4StreamWriter_2(_0)
  def _setLogHandler_LSystem_4StreamWriter_2(self,_0):
   self._task_1setLogHandler_LSystem_4StreamWriter_2(_0)
  @staticmethod
  def _match_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_D__(_1))
  def _setSolverParam_alt_SD(self,_t__0,_t__1):
    return self._setSolverParam_SD(_0,numpy.float64(__1))
  def _setSolverParam_SD(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SD(self,_0,_1)
  @staticmethod
  def _match_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1))
  def _setSolverParam_alt_SI(self,_t__0,_t__1):
    return self._setSolverParam_SI(_0,numpy.int32(__1))
  def _setSolverParam_SI(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SI(self,_0,_1)
  @staticmethod
  def _match_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_S__(_1))
  @staticmethod
  def _match_alt_setSolverParam_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_S__(_1))
  def _setSolverParam_alt_SS(self,_t__0,_t__1):
    return self._setSolverParam_SS(_0,_1)
  def _setSolverParam_SS(self,_0,_1):
   mosek.fusion.Parameters._setParameter_Lmosek_4fusion_4Model_2SS(self,_0,_1)
  @staticmethod
  def _match_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_breakSolver_(*args):
    if len(args) != 0: return False
    return True
  def _breakSolver_alt_(self,):
    return self._breakSolver_()
  def _breakSolver_(self,):
   self._task_1break_1solve_()
  @staticmethod
  def _match_optserverHost_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_optserverHost_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _optserverHost_alt_S(self,_t__0):
    return self._optserverHost_S(_0)
  def _optserverHost_S(self,_0):
   self._task_1putoptserver_1host_S(_0)
  def _report_1solution_alt_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9,_t__10,_t__11,_t__12):
    return self._report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(__0,__1,__2,__3,numpy.float64(__4),numpy.float64(__5),numpy.int32(__6),numpy.int32(__7),numpy.int32(__8),numpy.int32(__9),numpy.int32(__10),_11,_12)
  def _report_1solution_Emosek_4fusion_4SolutionType_2Emosek_4fusion_4ProblemStatus_2Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4SolutionStatus_2DDIIIIIZZ(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9,_10,_11,_12):
   if (_0==mosek.fusion.SolutionType.Interior):
    _13 = self.__sol_itr
   elif (_0==mosek.fusion.SolutionType.Basic):
    _13 = self.__sol_bas
   elif (_0==mosek.fusion.SolutionType.Integer):
    _13 = self.__sol_itg
   else:
    _13 = None
   if (_13 is None):
    _13 = mosek_fusion_SolutionStruct._ctor_IIIII(_6,_7,_8,_9,_10)
   else:
    _13._resize_IIIII(_6,_7,_8,_9,_10)
   (_13.pobj) = _4
   (_13.dobj) = _5
   (_13.pstatus) = _2
   (_13.dstatus) = _3
   (_13.probstatus) = _1
   if (_6 > 0):
    if _11:
     self._report_1solution_1get_1xx__3D((_13.xx))
    if _12:
     self._report_1solution_1get_1slx__3D((_13.slx))
     self._report_1solution_1get_1sux__3D((_13.sux))
     _14=(_13.yx)
     _15=(_13.slx)
     _16=(_13.sux)
     fragments._c_closure_23(_6,_15,_16,_14) 
   if (_7 > 0):
    if _11:
     self._report_1solution_1get_1xc__3D((_13.xc))
    if _12:
     self._report_1solution_1get_1slc__3D((_13.slc))
     self._report_1solution_1get_1suc__3D((_13.suc))
     _17=(_13.y)
     _18=(_13.slc)
     _19=(_13.suc)
     fragments._c_closure_24(_7,_18,_19,_17) 
   if (_8 > 0):
    if _11:
     self._report_1solution_1get_1barx__3D((_13.barx))
    if _12:
     self._report_1solution_1get_1bars__3D((_13.bars))
   if (self._task_1numacc_() > 0):
    self._report_1solution_1get_1accptr__3I((_13.accptr))
    if _11:
     self._report_1solution_1get_1accx__3D((_13.accx))
    if _12:
     self._report_1solution_1get_1accy__3D((_13.accy))
   if (_0==mosek.fusion.SolutionType.Interior):
    self.__sol_itr = _13
   elif (_0==mosek.fusion.SolutionType.Basic):
    self.__sol_bas = _13
   elif (_0==mosek.fusion.SolutionType.Integer):
    self.__sol_itg = _13
  def _clear_1solutions_alt_(self,):
    return self._clear_1solutions_()
  def _clear_1solutions_(self,):
   self.__sol_itr = None
   self.__sol_itg = None
   self.__sol_bas = None
  @staticmethod
  def _match_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Z__(_0) and __arg_match_D__(_1) and __arg_match_I__(_2) and __arg_match__3Lmosek_4fusion_4Model_2__(_3))
  @staticmethod
  def _match_alt_solveBatch_ZDI_3Lmosek_4fusion_4Model_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Z__(_0) and __arg_alt_match_D__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match__3Lmosek_4fusion_4Model_2__(_3))
  @staticmethod
  def _solveBatch_alt_ZDI_3Lmosek_4fusion_4Model_2(_t__0,_t__1,_t__2,_t__3):
   _0=_t__0
   _1=numpy.float64(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Model._solveBatch_ZDI_3Lmosek_4fusion_4Model_2(_0,_1,_2,_3)
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _solveBatch_ZDI_3Lmosek_4fusion_4Model_2(_0,_1,_2,_3):
   _4=int((_3).shape[0])
   for _5 in range(0,_4):
    if (_3[_5] is None):
     raise mosek_fusion_OptimizeError._ctor_S("One of the models is a null object")
   for _6 in range(0,_4):
    _3[_6]._flushSolutions_()
    _3[_6].__flush_1parameters_()
   _7=mosek.fusion.BaseModel._env_1solve_1batch_ZDI_3Lmosek_4fusion_4Model_2(_0,_1,_2,_3)
   for _8 in range(0,_4):
    _3[_8]._task_1post_1solve_()
   return (_7)
  @staticmethod
  def _match_solve_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_S__(_1))
  @staticmethod
  def _match_alt_solve_SS(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_S__(_1))
  def _solve_alt_SS(self,_t__0,_t__1):
    return self._solve_SS(_0,_1)
  def _solve_SS(self,_0,_1):
   self._flushSolutions_()
   self.__flush_1parameters_()
   self._task_1solve_ZSS(True,_0,_1)
   self._task_1post_1solve_()
  @staticmethod
  def _match_solve_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_solve_(*args):
    if len(args) != 0: return False
    return True
  def _solve_alt_(self,):
    return self._solve_()
  def _solve_(self,):
   self._flushSolutions_()
   self.__flush_1parameters_()
   self._task_1solve_ZSS(False,"","")
   self._task_1post_1solve_()
  def __flush_1parameters_alt_(self,):
    return self.__flush_1parameters_()
  def __flush_1parameters_(self,):
   _0=self.__con_blocks._num_1parameterized_()
   _1=self.__afe_blocks._num_1parameterized_()
   _2=self.__obj_blocks._num_1parameterized_()
   if (_0 > 0):
    _3=numpy.zeros((_0,), dtype=numpy.dtype(numpy.int32))
    _4=numpy.zeros((_0,), dtype=numpy.dtype(numpy.int32))
    _5=numpy.zeros((_0,), dtype=numpy.dtype(numpy.float64))
    self.__con_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_3,_4,_5)
    self._task_1putaijlist__3I_3I_3DJ(_3,_4,_5,_0)
   if (_1 > 0):
    _6=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    _7=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    _8=numpy.zeros((_1,), dtype=numpy.dtype(numpy.float64))
    self.__afe_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_6,_7,_8)
    self._task_1putafefijlist__3I_3I_3D(_6,_7,_8)
   if (_2 > 0):
    _9=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    _10=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    _11=numpy.zeros((_2,), dtype=numpy.dtype(numpy.float64))
    self.__obj_blocks._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self.__xs,self.__param_value,_9,_10,_11)
    self._task_1putclist__3I_3D(_10,_11)
  @staticmethod
  def _match_flushParameters_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushParameters_(*args):
    if len(args) != 0: return False
    return True
  def _flushParameters_alt_(self,):
    return self._flushParameters_()
  def _flushParameters_(self,):
   self.__flush_1parameters_()
  def __evaluate_1parameterized_alt_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8,_t__9,_t__10):
   _0=_t__0
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int64))
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _6=numpy.array(_t__6,dtype=numpy.dtype(numpy.int32))
   _7=numpy.array(_t__7,dtype=numpy.dtype(numpy.int32))
   _8=numpy.array(_t__8,dtype=numpy.dtype(numpy.float64))
   _9=numpy.array(_t__9,dtype=numpy.dtype(numpy.int32))
   _10=numpy.array(_t__10,dtype=numpy.dtype(numpy.float64))
   _1_res = self.__evaluate_1parameterized_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(_0,_1,_2,_3,_4,_5,_6,_7,_8,_9,_10)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__6[:] = _6
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__7[:] = _7
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__8[:] = _8
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__9[:] = _9
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__10[:] = _10
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __evaluate_1parameterized_Lmosek_4fusion_4WorkStack_2I_3I_3I_3J_3I_3I_3I_3D_3I_3D(self,_0,_1,_2,_3,_4,_5,_6,_7,_8,_9,_10):
   _11=_0._allocf64_I(int((_7).shape[0]))
   _12=0
   _13=(_0.f64)
   _14=0
   _14,_12 = fragments._c_closure_25(_8,_7,_4,_5,_6,_14,_1,self.__param_value,_2,_3,_11,_12,_9,_10,_13)
   _14 = numpy.int32(_14) # postprocess
   _12 = numpy.int32(_12) # postprocess
   _0._popf64_I(int((_7).shape[0]))
  @staticmethod
  def _match_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_flushSolutions_(*args):
    if len(args) != 0: return False
    return True
  def _flushSolutions_alt_(self,):
    return self._flushSolutions_()
  def _flushSolutions_(self,):
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Interior)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Integer)
   self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(mosek.fusion.SolutionType.Basic)
  def __flush_1initsol_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self.__flush_1initsol_Emosek_4fusion_4SolutionType_2(__0)
  def __flush_1initsol_Emosek_4fusion_4SolutionType_2(self,_0):
   if (self.__initsol_xx is not None):
    _1=self._task_1numvar_()
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.float64))
    try:
     _3=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True)
     if ((_3.xx) is not None):
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII((_3.xx),0,_2,0,(int(((_3.xx)).shape[0]) if ((int(((_3.xx)).shape[0]) <= _1) ) else _1))
    except mosek_fusion_SolutionError as _4:
     pass
    _5=(int((self.__initsol_xx).shape[0]) if ((int((self.__initsol_xx).shape[0]) <= _1) ) else _1)
    for _6 in range(0,_5):
     if self.__initsol_xx_flag[_6]:
      _2[_6] = self.__initsol_xx[_6]
    _2[self.__bfixidx] = 1.0
    self._task_1putxx_1slice_Emosek_4fusion_4SolutionType_2II_3D(_0,0,_1,_2)
  @staticmethod
  def _match_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getDualSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getDualSolutionStatus_alt_(self,):
    return self._getDualSolutionStatus_()
  def _getDualSolutionStatus_(self,):
   return (self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_getProblemStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getProblemStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getProblemStatus_alt_(self,):
    return self._getProblemStatus_()
  def _getProblemStatus_(self,):
   return (self._getProblemStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getPrimalSolutionStatus_alt_(self,):
    return self._getPrimalSolutionStatus_()
  def _getPrimalSolutionStatus_(self,):
   return (self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(self.__solutionptr))
  @staticmethod
  def _match_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dualObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _dualObjValue_alt_(self,):
    return self._dualObjValue_()
  def _dualObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,False).dobj))
  @staticmethod
  def _match_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_primalObjValue_(*args):
    if len(args) != 0: return False
    return True
  def _primalObjValue_alt_(self,):
    return self._primalObjValue_()
  def _primalObjValue_(self,):
   return numpy.float64((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(mosek.fusion.SolutionType.Default,True).pobj))
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2ZZ(self,_t__0,_t__1,_t__2):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(__0,_1,_2)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(self,_0,_1,_2):
   _3=None
   _4=_0
   if (_4==mosek.fusion.SolutionType.Default):
    _4 = self.__solutionptr
   if (_4==mosek.fusion.SolutionType.Default):
    if (self.__sol_itg is not None):
     _3 = self.__sol_itg
    elif (self.__sol_bas is not None):
     _3 = self.__sol_bas
    else:
     _3 = self.__sol_itr
   elif (_4==mosek.fusion.SolutionType.Interior):
    _3 = self.__sol_itr
   elif (_4==mosek.fusion.SolutionType.Basic):
    _3 = self.__sol_bas
   elif (_4==mosek.fusion.SolutionType.Integer):
    _3 = self.__sol_itg
   if (_3 is None):
    raise mosek_fusion_SolutionError._ctor_S("Solution not available")
   else:
    if (_2 or ((_1 and _3._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self.__acceptable_sol)) or ((not _1) and _3._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self.__acceptable_sol)))):
     return (_3)
    elif ((_3 is self.__sol_itg) and (not _1)):
     raise mosek_fusion_SolutionError._ctor_S("Dual solution does not exists for mixed-integer problems.")
    else:
     _5=mosek.fusion.Utils.StringBuffer()
     _6=(_3.pstatus)
     _7=(_3.probstatus)
     if (not _1):
      _6 = (_3.dstatus)
     _5._a_S("Solution status is ")
     if (_6==mosek.fusion.SolutionStatus.Undefined):
      _5._a_S("Undefined")
     elif (_6==mosek.fusion.SolutionStatus.Unknown):
      _5._a_S("Unknown")
     elif (_6==mosek.fusion.SolutionStatus.Optimal):
      _5._a_S("Optimal")
     elif (_6==mosek.fusion.SolutionStatus.Feasible):
      _5._a_S("Feasible")
     elif (_6==mosek.fusion.SolutionStatus.Certificate):
      _5._a_S("Certificate")
     elif (_6==mosek.fusion.SolutionStatus.IllposedCert):
      _5._a_S("IllposedCert")
     _5._a_S(" but ")
     if (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Anything):
      _5._a_S("Anything")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Optimal):
      _5._a_S("Optimal")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Feasible):
      _5._a_S("at least Feasible")
     elif (self.__acceptable_sol==mosek.fusion.AccSolutionStatus.Certificate):
      _5._a_S("Certificate")
     _5._a_S(" is expected. Reason: Accessing ")
     if (_3 is self.__sol_itr):
      _5._a_S("interior-point solution")
     elif (_3 is self.__sol_bas):
      _5._a_S("basic solution")
     elif (_3 is self.__sol_itg):
      _5._a_S("integer solution")
     _5._a_S(" whose problem status is ")
     if (_7==mosek.fusion.ProblemStatus.Unknown):
      _5._a_S("Unknown")
     elif (_7==mosek.fusion.ProblemStatus.PrimalAndDualFeasible):
      _5._a_S("PrimalAndDualFeasible")
     elif (_7==mosek.fusion.ProblemStatus.PrimalFeasible):
      _5._a_S("PrimalFeasible")
     elif (_7==mosek.fusion.ProblemStatus.DualFeasible):
      _5._a_S("DualFeasible")
     elif (_7==mosek.fusion.ProblemStatus.PrimalInfeasible):
      _5._a_S("PrimalInfeasible")
     elif (_7==mosek.fusion.ProblemStatus.DualInfeasible):
      _5._a_S("DualInfeasible")
     elif (_7==mosek.fusion.ProblemStatus.PrimalAndDualInfeasible):
      _5._a_S("PrimalAndDualInfeasible")
     elif (_7==mosek.fusion.ProblemStatus.IllPosed):
      _5._a_S("IllPosed")
     elif (_7==mosek.fusion.ProblemStatus.PrimalInfeasibleOrUnbounded):
      _5._a_S("PrimalInfeasibleOrUnbounded")
     _5._a_S(".")
     raise mosek_fusion_SolutionError._ctor_S(_5._toString_())
  def _get_1sol_1cache_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__0,_t__1):
    return self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(__0,_1)
  def _get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(self,_0,_1):
   return (self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_0,_1,False))
  def _setSolution_1xx_alt__3I_3D(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setSolution_1xx__3I_3D(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setSolution_1xx__3I_3D(self,_0,_1):
   self._ensure_1initsol_1xx_()
   for _2 in range(0,int((_0).shape[0])):
    self.__initsol_xx[_0[_2]] = _1[_2]
    self.__initsol_xx_flag[_0[_2]] = True
  def _ensure_1initsol_1xx_alt_(self,):
    return self._ensure_1initsol_1xx_()
  def _ensure_1initsol_1xx_(self,):
   _0=self._task_1numvar_()
   if (self.__initsol_xx is None):
    self.__initsol_xx = numpy.zeros((_0,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.array([False for _1 in range(0,_0)], dtype=numpy.dtype(bool))
   elif (int((self.__initsol_xx).shape[0]) < _0):
    _2=self.__initsol_xx
    _3=self.__initsol_xx_flag
    self.__initsol_xx = numpy.zeros((_0,), dtype=numpy.dtype(numpy.float64))
    self.__initsol_xx_flag = numpy.zeros((_0,), dtype=numpy.dtype(bool))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_2,0,self.__initsol_xx,0,int((_2).shape[0]))
    for _4 in range(0,int((_2).shape[0])):
     self.__initsol_xx_flag[_4] = _3[_4]
  def _getSolution_1accptr_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1accptr_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1accptr_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_0,True,True).accptr))
  def _getSolution_1accy_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1accy_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1accy_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).accy))
  def _getSolution_1accx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1accx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1accx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).accx))
  def _getSolution_1bars_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1bars_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1bars_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).bars))
  def _getSolution_1barx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1barx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1barx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).barx))
  def _getSolution_1y_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1y_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1y_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).y))
  def _getSolution_1xc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1xc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1xc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).xc))
  def _getSolution_1suc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1suc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1suc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).suc))
  def _getSolution_1slc_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1slc_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1slc_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).slc))
  def _getSolution_1sux_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1sux_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1sux_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).sux))
  def _getSolution_1slx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1slx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1slx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).slx))
  def _getSolution_1yx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1yx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1yx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,False).yx))
  def _getSolution_1xx_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getSolution_1xx_Emosek_4fusion_4SolutionType_2(__0)
  def _getSolution_1xx_Emosek_4fusion_4SolutionType_2(self,_0):
   return ((self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2Z(_0,True).xx))
  @staticmethod
  def _match_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_selectedSolution_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _selectedSolution_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._selectedSolution_Emosek_4fusion_4SolutionType_2(__0)
  def _selectedSolution_Emosek_4fusion_4SolutionType_2(self,_0):
   self.__solutionptr = _0
  @staticmethod
  def _match_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getAcceptedSolutionStatus_(*args):
    if len(args) != 0: return False
    return True
  def _getAcceptedSolutionStatus_alt_(self,):
    return self._getAcceptedSolutionStatus_()
  def _getAcceptedSolutionStatus_(self,):
   return (self.__acceptable_sol)
  @staticmethod
  def _match_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _acceptedSolutionStatus_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _acceptedSolutionStatus_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   self.__acceptable_sol = _0
  @staticmethod
  def _match_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getProblemStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getProblemStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getProblemStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getProblemStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   _1=None
   if (_0==mosek.fusion.SolutionType.Default):
    if (self.__sol_itg is not None):
     _1 = self.__sol_itg
    elif (self.__sol_bas is not None):
     _1 = self.__sol_bas
    else:
     _1 = self.__sol_itr
   elif (_0==mosek.fusion.SolutionType.Interior):
    _1 = self.__sol_itr
   elif (_0==mosek.fusion.SolutionType.Basic):
    _1 = self.__sol_bas
   elif (_0==mosek.fusion.SolutionType.Integer):
    _1 = self.__sol_itg
   if (_1 is None):
    return (mosek.fusion.ProblemStatus.Unknown)
   else:
    return ((_1.probstatus))
  @staticmethod
  def _match_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getDualSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getDualSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_0,False))
  @staticmethod
  def _match_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4SolutionType_2__(_0))
  @staticmethod
  def _match_alt_getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4SolutionType_2__(_0))
  def _getPrimalSolutionStatus_alt_Emosek_4fusion_4SolutionType_2(self,_t__0):
    return self._getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(__0)
  def _getPrimalSolutionStatus_Emosek_4fusion_4SolutionType_2(self,_0):
   return (self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(_0,True))
  def _getSolutionStatus_alt_Emosek_4fusion_4SolutionType_2Z(self,_t__0,_t__1):
    return self._getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(__0,_1)
  def _getSolutionStatus_Emosek_4fusion_4SolutionType_2Z(self,_0,_1):
   try:
    _2=self._get_1sol_1cache_Emosek_4fusion_4SolutionType_2ZZ(_0,_1,True)
    if _1:
     return ((_2.pstatus))
    else:
     return ((_2.dstatus))
   except mosek_fusion_SolutionError as _3:
    return (mosek.fusion.SolutionStatus.Undefined)
  def _update_alt__3ILmosek_4fusion_4Expression_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1_res = self._update__3ILmosek_4fusion_4Expression_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3ILmosek_4fusion_4Expression_2(self,_0,_1):
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_1)))._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__ws,self.__rs,self.__xs)
   self.__ws._pop_1expr_()
   _2=(self.__ws.nd)
   _3=(self.__ws.shape_base)
   _4=(self.__ws.nelem)
   _5=(self.__ws.nnz)
   _6=(self.__ws.hassp)
   _7=(self.__ws.ncodeatom)
   _8=(self.__ws.ptr_base)
   _9=(self.__ws.sp_base)
   _10=(self.__ws.nidxs_base)
   _11=(self.__ws.cof_base)
   _12=(self.__ws.code_base)
   _13=(self.__ws.codeptr_base)
   _14=(self.__ws.cconst_base)
   _15=(self.__ws.i32)
   _16=(self.__ws.i64)
   _17=(self.__ws.f64)
   _18=0
   _18 = fragments._c_closure_26(_0,_4,_18)
   _18 = numpy.int32(_18) # postprocess
   _19=(_4 - _18)
   if (_18==_4):
    self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_0,self.__ws,_4,_5,_8,_10,_11)
    if (_7 > 0):
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_0,_8,_10,_13,_12,_14)
    else:
     self.__con_blocks._clear_1row_1code__3I(_0)
   elif (_19==_4):
    self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(numpy.array([(- (1 + _0[_20])) for _20 in range(0,_4)], dtype=numpy.dtype(numpy.int32)),0,self.__ws,_4,_5,_8,_10,_11)
    if (_7 > 0):
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([(- (1 + _0[_21])) for _21 in range(0,_4)], dtype=numpy.dtype(numpy.int32)),_8,_10,_13,_12,_14)
    else:
     self.__afe_blocks._clear_1row_1code__3I(numpy.array([(- (1 + _0[_22])) for _22 in range(0,_4)], dtype=numpy.dtype(numpy.int32)))
   else:
    _23=0
    _24=0
    _25=0
    _26=0
    _25,_26 = fragments._c_closure_27(_25,_0,_26,_4,_8,_15)
    _25 = numpy.int32(_25) # postprocess
    _26 = numpy.int32(_26) # postprocess
    _27=self.__xs._alloci32_I(_18)
    _28=self.__xs._alloci32_I(_19)
    _29=self.__xs._alloci32_I((_18 + 1))
    _30=self.__xs._alloci32_I((_19 + 1))
    _31=self.__xs._alloci64_I(_26)
    _32=self.__xs._alloci64_I(_25)
    _33=self.__xs._allocf64_I(_26)
    _34=self.__xs._allocf64_I(_25)
    _35=(self.__xs.f64)
    _36=(self.__xs.i64)
    _37=(self.__xs.i32)
    _37[_29] = 0
    _37[_30] = 0
    _38=0
    _39=0
    _40=0
    _41=0
    for _42 in range(0,_4):
     _43=_15[(_8 + _42)]
     _44=_15[((_8 + _42) + 1)]
     if (_0[_42] >= 0):
      mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_16,(_10 + _43),_36,(_31 + _41),(_44 - _43))
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_17,(_11 + _43),_35,(_33 + _41),(_44 - _43))
      _41 += (_44 - _43)
      _37[(_27 + _39)] = _0[_42]
      _37[((_29 + _39) + 1)] = _41
      _39 += 1
     else:
      mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_16,(_10 + _43),_36,(_32 + _40),(_44 - _43))
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_17,(_11 + _43),_35,(_34 + _40),(_44 - _43))
      _40 += (_44 - _43)
      _37[(_28 + _38)] = (- (1 + _0[_42]))
      _37[((_30 + _38) + 1)] = _40
      _38 += 1
    self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(numpy.array([_37[(_27 + _45)] for _45 in range(0,_18)], dtype=numpy.dtype(numpy.int32)),self.__xs,_18,_26,_29,_31,_33)
    self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_37,_28,self.__xs,_19,_25,_30,_32,_34)
    if (_7 > 0):
     _23,_24 = fragments._c_closure_28(_23,_13,_0,_24,_4,_8,_15)
     _23 = numpy.int32(_23) # postprocess
     _24 = numpy.int32(_24) # postprocess
     _46=self.__xs._alloci32_I((_26 + 1))
     _47=self.__xs._alloci32_I((_25 + 1))
     _48=self.__xs._alloci32_I(_24)
     _49=self.__xs._alloci32_I(_23)
     _50=self.__xs._allocf64_I(_24)
     _51=self.__xs._allocf64_I(_23)
     _37[_46] = 0
     _37[_47] = 0
     _52=0
     _53=0
     _54=0
     _55=0
     for _56 in range(0,_4):
      _57=_15[(_8 + _56)]
      _58=_15[((_8 + _56) + 1)]
      if (_0[_56] >= 0):
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_15,(_12 + _15[(_13 + _57)]),_37,(_48 + _53),(_15[(_13 + _58)] - _15[(_13 + _57)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_17,(_14 + _15[(_13 + _57)]),_35,(_50 + _53),(_15[(_13 + _58)] - _15[(_13 + _57)]))
       _53,_55 = fragments._c_closure_29(_13,_53,_46,_55,_57,_58,_15,_37)
       _53 = numpy.int32(_53) # postprocess
       _55 = numpy.int32(_55) # postprocess
      else:
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_15,(_12 + _15[(_13 + _57)]),_37,(_49 + _52),(_15[(_13 + _58)] - _15[(_13 + _57)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_17,(_14 + _15[(_13 + _57)]),_35,(_51 + _52),(_15[(_13 + _58)] - _15[(_13 + _57)]))
       _52,_40 = fragments._c_closure_30(_52,_47,_40,_13,_57,_58,_15,_37)
       _52 = numpy.int32(_52) # postprocess
       _40 = numpy.int32(_40) # postprocess
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,numpy.array([_37[(_27 + _59)] for _59 in range(0,_18)], dtype=numpy.dtype(numpy.int32)),_29,_31,_46,_48,_50)
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,numpy.array([numpy.int32(_36[(_28 + _60)]) for _60 in range(0,_19)], dtype=numpy.dtype(numpy.int32)),_30,_32,_47,_49,_51)
    else:
     self.__con_blocks._clear_1row_1code__3I(numpy.array([_37[(_27 + _61)] for _61 in range(0,_18)], dtype=numpy.dtype(numpy.int32)))
     self.__afe_blocks._clear_1row_1code__3I(numpy.array([numpy.int32(_36[(_28 + _62)]) for _62 in range(0,_19)], dtype=numpy.dtype(numpy.int32)))
   self.__xs._clear_()
  def _update_alt__3ILmosek_4fusion_4Expression_2_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._update__3ILmosek_4fusion_4Expression_2_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3ILmosek_4fusion_4Expression_2_3I(self,_0,_1,_2):
   for _3 in range(0,int((_0).shape[0])):
    if ((_0[_3] >= 0) and self.__con_blocks._row_1is_1parameterized_I(_3)):
     raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
    elif ((_0[_3] < 0) and self.__con_blocks._row_1is_1parameterized_I((- (_3 + 1)))):
     raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_1))._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__ws,self.__rs,self.__xs)
   self.__ws._pop_1expr_()
   _4=(self.__ws.nd)
   _5=(self.__ws.nelem)
   _6=(self.__ws.nnz)
   _7=(self.__ws.hassp)
   _8=(self.__ws.ncodeatom)
   _9=(self.__ws.shape_base)
   _10=(self.__ws.ptr_base)
   _11=(self.__ws.sp_base)
   _12=(self.__ws.nidxs_base)
   _13=(self.__ws.cof_base)
   _14=(self.__ws.code_base)
   _15=(self.__ws.codeptr_base)
   _16=(self.__ws.cconst_base)
   _17=(self.__ws.i32)
   _18=(self.__ws.i64)
   _19=(self.__ws.f64)
   _20=0
   _20 = fragments._c_closure_31(_0,_5,_20)
   _20 = numpy.int32(_20) # postprocess
   _21=(_5 - _20)
   if ((_20==_5) or (_21==_5)):
    _22=(int((_0).shape[0]) * int((_2).shape[0]))
    _23=numpy.zeros((_22,), dtype=numpy.dtype(numpy.float64))
    _24=0
    _24 = fragments._c_closure_32(_23,_13,_5,_12,_24,_10,_2,_19,_17,_18)
    _24 = numpy.int32(_24) # postprocess
    _25=numpy.array([_2[_27] for _26 in range(0,_5) for _27 in range(0,int((_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    if (_20==_5):
     _28=numpy.array([_0[_29] for _29 in range(0,_5) for _30 in range(0,int((_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
     self._task_1putaijlist__3I_3I_3DJ(_28,_25,_23,_24)
     if (_8 > 0):
      self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_0,_10,_12,_15,_14,_16)
    else:
     _31=numpy.array([(- (_0[_32] + 1)) for _32 in range(0,_5) for _33 in range(0,int((_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
     self._task_1putafefijlist__3I_3I_3D(_31,_25,_23)
     if (_8 > 0):
      self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([(- (1 + _0[_34])) for _34 in range(0,_5)], dtype=numpy.dtype(numpy.int32)),_10,_12,_15,_14,_16)
   else:
    _35=(_21 * int((_2).shape[0]))
    _36=(_20 * int((_2).shape[0]))
    _37=numpy.zeros((_36,), dtype=numpy.dtype(numpy.float64))
    _38=numpy.zeros((_35,), dtype=numpy.dtype(numpy.float64))
    _39=numpy.array([_2[_41] for _40 in range(0,_20) for _41 in range(0,int((_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _42=numpy.array([_2[_44] for _43 in range(0,_21) for _44 in range(0,int((_2).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _45=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int32))
    _46=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
    _47=0
    _48=0
    _49=0
    _50=0
    _51=0
    _52=0
    _51,_52 = fragments._c_closure_33(_38,_51,_13,_0,_46,_37,_52,_45,_5,_12,_10,_2,_19,_17,_18)
    _51 = numpy.int32(_51) # postprocess
    _52 = numpy.int32(_52) # postprocess
    self._task_1putaijlist__3I_3I_3DJ(_45,_39,_37,_52)
    self._task_1putafefijlist__3I_3I_3D(_46,_42,_38)
    if (_8 > 0):
     _51,_52 = fragments._c_closure_34(_51,_0,_52,_5,_10,_17)
     _51 = numpy.int32(_51) # postprocess
     _52 = numpy.int32(_52) # postprocess
     _53=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int32))
     _54=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
     _55=self.__xs._alloci32_I((_20 + 1))
     _56=self.__xs._alloci32_I((_21 + 1))
     _57=self.__xs._alloci64_I(_52)
     _58=self.__xs._alloci64_I(_51)
     _59=(self.__xs.f64)
     _60=(self.__xs.i64)
     _61=(self.__xs.i32)
     _61[_55] = 0
     _61[_56] = 0
     _62=0
     _63=0
     _64=0
     _65=0
     _62,_64,_63,_65 = fragments._c_closure_35(_62,_64,_0,_56,_54,_63,_65,_55,_53,_5,_10,_17,_61)
     _62 = numpy.int32(_62) # postprocess
     _64 = numpy.int32(_64) # postprocess
     _63 = numpy.int32(_63) # postprocess
     _65 = numpy.int32(_65) # postprocess
     _49,_50 = fragments._c_closure_36(_49,_15,_0,_50,_5,_10,_17)
     _49 = numpy.int32(_49) # postprocess
     _50 = numpy.int32(_50) # postprocess
     _66=self.__xs._alloci32_I((_52 + 1))
     _67=self.__xs._alloci32_I((_51 + 1))
     _68=self.__xs._alloci32_I(_50)
     _69=self.__xs._alloci32_I(_49)
     _70=self.__xs._allocf64_I(_50)
     _71=self.__xs._allocf64_I(_49)
     _61[_66] = 0
     _61[_67] = 0
     _72=0
     _73=0
     _74=0
     _75=0
     for _76 in range(0,_5):
      _77=_17[(_10 + _76)]
      _78=_17[((_10 + _76) + 1)]
      if (_0[_76] >= 0):
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_17,(_14 + _17[(_15 + _77)]),_61,(_68 + _73),(_17[(_15 + _78)] - _17[(_15 + _77)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_19,(_16 + _17[(_15 + _77)]),_59,(_70 + _73),(_17[(_15 + _78)] - _17[(_15 + _77)]))
       _73,_75 = fragments._c_closure_37(_15,_73,_66,_75,_77,_78,_17,_61)
       _73 = numpy.int32(_73) # postprocess
       _75 = numpy.int32(_75) # postprocess
      else:
       mosek.fusion.Utils.Tools._arraycopy__3II_3III(_17,(_14 + _17[(_15 + _77)]),_61,(_69 + _72),(_17[(_15 + _78)] - _17[(_15 + _77)]))
       mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_19,(_16 + _17[(_15 + _77)]),_59,(_71 + _72),(_17[(_15 + _78)] - _17[(_15 + _77)]))
       _72,_64 = fragments._c_closure_38(_72,_67,_64,_15,_77,_78,_17,_61)
       _72 = numpy.int32(_72) # postprocess
       _64 = numpy.int32(_64) # postprocess
     self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,_53,_55,_57,_66,_68,_70)
     self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__xs,_54,_56,_58,_67,_69,_71)
    else:
     _79=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int32))
     _80=numpy.zeros((_21,), dtype=numpy.dtype(numpy.int32))
     _81=0
     _82=0
     _81,_82 = fragments._c_closure_39(_81,_0,_80,_82,_79,_5)
     _81 = numpy.int32(_81) # postprocess
     _82 = numpy.int32(_82) # postprocess
     self.__con_blocks._clear_1row_1code__3I(_79)
     self.__afe_blocks._clear_1row_1code__3I(_80)
   self.__xs._clear_()
  @staticmethod
  def _match_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  def _updateObjective_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_t__0,_t__1):
    return self._updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(_0,_1)
  def _updateObjective_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_0,_1):
   if (_0._getSize_()!=1):
    raise mosek_fusion_DimensionError._ctor_S("Invalid expression size for objective")
   if ((self.__obj_blocks.code_used) > 0):
    raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized constraint")
   _2=_1._numInst_()
   _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
   if (_2 < _1._getSize_()):
    _4=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    _1._inst_I_3JI_3J(0,_4,0,_3)
   else:
    _1._inst_I_3J(0,_3)
   for _5 in range(0,_2):
    if (_3[_5] < 0):
     raise mosek_fusion_UpdateError._ctor_S("Updating semidefinite terms is currently not possible")
   _6=True
   _6 = fragments._c_closure_40(_2,_3,_6)
   _7=None
   if _6:
    _7 = numpy.array([numpy.int32(_3[_8]) for _8 in range(0,_2)], dtype=numpy.dtype(numpy.int32))
   else:
    _9=numpy.array([_10 for _10 in range((- 1),_2)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_9,_3,None,0,_2)
    _7 = numpy.array([numpy.int32(_3[_9[_11]]) for _11 in range(0,_2)], dtype=numpy.dtype(numpy.int32))
   _12=int((_7).shape[0])
   _13=numpy.zeros((_12,), dtype=numpy.dtype(numpy.float64))
   _14=_7
   mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_0))._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__ws,self.__rs,self.__xs)
   self.__ws._pop_1expr_()
   pass
   _15=(self.__ws.nd)
   _16=(self.__ws.nelem)
   _17=(self.__ws.nnz)
   _18=(self.__ws.hassp)
   _19=(self.__ws.ncodeatom)
   _20=(self.__ws.shape_base)
   _21=(self.__ws.ptr_base)
   _22=(self.__ws.sp_base)
   _23=(self.__ws.nidxs_base)
   _24=(self.__ws.cof_base)
   _25=(self.__ws.code_base)
   _26=(self.__ws.codeptr_base)
   _27=(self.__ws.cconst_base)
   pass
   if (_19 > 0):
    raise mosek_fusion_UpdateError._ctor_S("Cannot update parameterized objective")
   _28=(self.__ws.i32)
   _29=(self.__ws.i64)
   _30=(self.__ws.f64)
   _31=0
   _31 = fragments._c_closure_41(_13,_24,_31,_16,_23,_21,_7,_30,_28,_29)
   _31 = numpy.int32(_31) # postprocess
   self._task_1putclist__3I_3D(_14,_13)
   if (_19 > 0):
    self.__obj_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,numpy.array([0], dtype=numpy.dtype(numpy.int32)),_21,_23,_26,_25,_27)
  def __parameter_1unchecked_alt_S_3I_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__parameter_1unchecked_S_3I_3J(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1unchecked_S_3I_3J(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self.__par_map._hasItem_S(_0)):
    raise mosek_fusion_NameError._ctor_S("Duplicate parameter name")
   _3=mosek.fusion.Set._size__3I(_1)
   _4=(int((_2).shape[0]) if ((_2 is not None) ) else numpy.int32(_3))
   if (self.__param_value is None):
    self.__param_value = numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   else:
    if ((self.__param_num + _4) > int((self.__param_value).shape[0])):
     _5=self.__param_value
     _6=((2 * int((_5).shape[0])) if (((2 * int((_5).shape[0])) > (int((_5).shape[0]) + _4)) ) else (int((_5).shape[0]) + _4))
     self.__param_value = numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
     if (self.__param_num > 0):
      mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_5,0,self.__param_value,0,self.__param_num)
   _7=mosek_fusion_ParameterImpl._ctor_Lmosek_4fusion_4Model_2_3I_3J_3I(self,_1,_2,numpy.array([(self.__param_num + _8) for _8 in range(0,numpy.int32(_4))], dtype=numpy.dtype(numpy.int32)))
   self.__param_num += _4
   if (int(len(_0)) > 0):
    if ((self.__parameters is None) or (self.__numparameter==int((self.__parameters).shape[0]))):
     _9=self.__parameters
     self.__parameters = numpy.array([None for _10 in range(0,((self.__numparameter * 2) + 64))], dtype=numpy.dtype(object))
     for _11 in range(0,self.__numparameter):
      self.__parameters[_11] = _9[_11]
    self.__parameters[self.__numparameter] = _7
    self.__par_map._setItem_SI(_0,self.__numparameter)
    self.__numparameter += 1
   return (_7)
  def __parameter_1_alt_S_3I_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1_res = self.__parameter_1_S_3I_3J(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1_S_3I_3J(self,_0,_1,_2):
   _3=True
   _4=int((_1).shape[0])
   if ((_2 is not None) and (int((_2).shape[0]) > 0)):
    _5=(_2[(int((_2).shape[0]) - 1)] < mosek.fusion.Set._size__3I(_1))
    _5 = fragments._c_closure_42(_5,_2)
    if (not _5):
     raise mosek_fusion_IndexError._ctor_S("Unordered sparsity pattern")
   return (self.__parameter_1unchecked_S_3I_3J(_0,_1,_2))
  def __parameter_1_alt_S_3I_3_5I(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,ndmin=_monty.checkShape(_t__2,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self.__parameter_1_S_3I_3_5I(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __parameter_1_S_3I_3_5I(self,_0,_1,_2):
   _3=int((_2).shape[0])
   _4=int((_2).shape[1])
   if (int((_1).shape[0])!=_4):
    raise mosek_fusion_LengthError._ctor_S("Invalid sparsity")
   if (_2 is None):
    return (self.__parameter_1unchecked_S_3I_3J(_0,_1,None))
   else:
    _5=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int64))
    _6=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int64))
    _6[(_4 - 1)] = 1
    fragments._c_closure_43(_4,_1,_6) 
    fragments._c_closure_44(_4,_3,_5,_2,_6) 
    return (self.__parameter_1_S_3I_3J(_0,_1,_5))
  @staticmethod
  def _match_parameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_parameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _parameter_alt_S(self,_t__0):
    return self._parameter_S(_0)
  def _parameter_S(self,_0):
   _1=None
   return (self.__parameter_1_S_3I_3J(_0,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_parameter_SIII(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_parameter_SIII(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3))
  def _parameter_alt_SIII(self,_t__0,_t__1,_t__2,_t__3):
    return self._parameter_SIII(_0,numpy.int32(__1),numpy.int32(__2),numpy.int32(__3))
  def _parameter_SIII(self,_0,_1,_2,_3):
   _4=None
   return (self.__parameter_1_S_3I_3J(_0,numpy.array([_1,_2,_3], dtype=numpy.dtype(numpy.int32)),_4))
  @staticmethod
  def _match_parameter_SII(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_parameter_SII(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _parameter_alt_SII(self,_t__0,_t__1,_t__2):
    return self._parameter_SII(_0,numpy.int32(__1),numpy.int32(__2))
  def _parameter_SII(self,_0,_1,_2):
   _3=None
   return (self.__parameter_1_S_3I_3J(_0,numpy.array([_1,_2], dtype=numpy.dtype(numpy.int32)),_3))
  @staticmethod
  def _match_parameter_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_parameter_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1))
  def _parameter_alt_SI(self,_t__0,_t__1):
    return self._parameter_SI(_0,numpy.int32(__1))
  def _parameter_SI(self,_0,_1):
   _2=None
   return (self.__parameter_1_S_3I_3J(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_parameter_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_parameter_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1))
  def _parameter_alt_S_3I(self,_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter_S_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I(self,_0,_1):
   _2=None
   return (self.__parameter_1_S_3I_3J(_0,_1,_2))
  @staticmethod
  def _match_parameter_S_3I_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match__3J__(_2))
  @staticmethod
  def _match_alt_parameter_S_3I_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3J__(_2))
  def _parameter_alt_S_3I_3J(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1_res = self._parameter_S_3I_3J(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I_3J(self,_0,_1,_2):
   return (self.__parameter_1_S_3I_3J(_0,_1,_2))
  @staticmethod
  def _match_parameter_S_3I_3_5I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match__3_5I__(_2))
  @staticmethod
  def _match_alt_parameter_S_3I_3_5I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3_5I__(_2))
  def _parameter_alt_S_3I_3_5I(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,ndmin=_monty.checkShape(_t__2,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter_S_3I_3_5I(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter_S_3I_3_5I(self,_0,_1,_2):
   return (self.__parameter_1_S_3I_3_5I(_0,_1,_2))
  @staticmethod
  def _match_parameter_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_parameter_(*args):
    if len(args) != 0: return False
    return True
  def _parameter_alt_(self,):
    return self._parameter_()
  def _parameter_(self,):
   _0=None
   return (self.__parameter_1_S_3I_3J("",numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),_0))
  @staticmethod
  def _match_parameter_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_parameter_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _parameter_alt_III(self,_t__0,_t__1,_t__2):
    return self._parameter_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _parameter_III(self,_0,_1,_2):
   _3=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32)),_3))
  @staticmethod
  def _match_parameter_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_parameter_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _parameter_alt_II(self,_t__0,_t__1):
    return self._parameter_II(numpy.int32(__0),numpy.int32(__1))
  def _parameter_II(self,_0,_1):
   _2=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_parameter_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_parameter_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _parameter_alt_I(self,_t__0):
    return self._parameter_I(numpy.int32(__0))
  def _parameter_I(self,_0):
   _1=None
   return (self.__parameter_1_S_3I_3J("",numpy.array([_0], dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_parameter__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_parameter__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _parameter_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I(self,_0):
   _1=None
   return (self.__parameter_1_S_3I_3J("",_0,_1))
  @staticmethod
  def _match_parameter__3I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_parameter__3I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3J__(_1))
  def _parameter_alt__3I_3J(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._parameter__3I_3J(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I_3J(self,_0,_1):
   return (self.__parameter_1_S_3I_3J("",_0,_1))
  @staticmethod
  def _match_parameter__3I_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3_5I__(_1))
  @staticmethod
  def _match_alt_parameter__3I_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3_5I__(_1))
  def _parameter_alt__3I_3_5I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,ndmin=_monty.checkShape(_t__1,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._parameter__3I_3_5I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _parameter__3I_3_5I(self,_0,_1):
   return (self.__parameter_1_S_3I_3_5I("",_0,_1))
  def __objective_1_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1,_t__2):
    return self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,__1,_2)
  def __objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1,_2):
   self._task_1putobjectivename_S(_0)
   _3=mosek_fusion_WorkStack._ctor_()
   _4=mosek_fusion_WorkStack._ctor_()
   _5=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_2)))
   _5._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(_3,_4,self.__xs)
   _3._pop_1expr_()
   _6=(_3.i32)
   _7=(_3.i64)
   _8=(_3.f64)
   _9=(_3.nd)
   _10=(_3.nelem)
   _11=(_3.nnz)
   _12=(_3.hassp)
   _13=(_3.ncodeatom)
   _14=(_3.ptr_base)
   _15=(_3.shape_base)
   _16=(_3.nidxs_base)
   _17=(_3.cof_base)
   _18=(_3.code_base)
   _19=(_3.codeptr_base)
   _20=(_3.cconst_base)
   _21=1
   _9 = fragments._c_closure_45(_9,_6,_15)
   _9 = numpy.int32(_9) # postprocess
   if (_21!=1):
    raise mosek_fusion_LengthError._ctor_S("Invalid expression size for objective")
   if (_10!=1):
    raise mosek_fusion_LengthError._ctor_S("Invalid expression for objective")
   _22=0
   _23=0
   _22,_23 = fragments._c_closure_46(_22,_16,_11,_23,_7)
   _22 = numpy.int32(_22) # postprocess
   _23 = numpy.int32(_23) # postprocess
   _24=numpy.zeros((_22,), dtype=numpy.dtype(numpy.int32))
   _25=numpy.zeros((_22,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_47(_25,_17,_16,_11,_8,_7,_24) 
   self._task_1putobjective_Z_3I_3DD((_1==mosek.fusion.ObjectiveSense.Maximize),_24,_25,0.0)
   if (_23 > 0):
    _26=numpy.zeros((_23,), dtype=numpy.dtype(numpy.int32))
    _27=numpy.zeros((_23,), dtype=numpy.dtype(numpy.int32))
    _28=numpy.zeros((_23,), dtype=numpy.dtype(numpy.int32))
    _29=numpy.zeros((_23,), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_48(self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,_17,_16,_23,_8,_7,_26,_27,_28,_29) 
    self._task_1putbarc__3I_3I_3I_3D(_26,_27,_28,_29)
   if (_13 > 0):
    self.__obj_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(_3,numpy.array([0], dtype=numpy.dtype(numpy.int32)),_14,_16,_19,_18,_20)
  @staticmethod
  def _match_objective_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_objective_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  def _objective_alt_D(self,_t__0):
    return self._objective_D(numpy.float64(__0))
  def _objective_D(self,_0):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_0))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_alt_match_D__(_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2D(self,_t__0,_t__1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2D(__0,numpy.float64(__1))
  def _objective_Emosek_4fusion_4ObjectiveSense_2D(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_0,mosek.fusion.Expr._constTerm_D(_1))
  @staticmethod
  def _match_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1))
  @staticmethod
  def _match_alt_objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1))
  def _objective_alt_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1):
    return self._objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(__0,_1)
  def _objective_Emosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2("",_0,_1)
  @staticmethod
  def _match_objective_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_D__(_1))
  @staticmethod
  def _match_alt_objective_SD(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_D__(_1))
  def _objective_alt_SD(self,_t__0,_t__1):
    return self._objective_SD(_0,numpy.float64(__1))
  def _objective_SD(self,_0,_1):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,mosek.fusion.ObjectiveSense.Minimize,mosek.fusion.Expr._constTerm_D(_1))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_match_D__(_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2D(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_alt_match_D__(_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2D(self,_t__0,_t__1,_t__2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2D(_0,__1,numpy.float64(__2))
  def _objective_SEmosek_4fusion_4ObjectiveSense_2D(self,_0,_1,_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,_1,mosek.fusion.Expr._constTerm_D(_2))
  @staticmethod
  def _match_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_match_Lmosek_4fusion_4Expression_2__(_2))
  @staticmethod
  def _match_alt_objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Emosek_4fusion_4ObjectiveSense_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_2))
  def _objective_alt_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_t__0,_t__1,_t__2):
    return self._objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,__1,_2)
  def _objective_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(self,_0,_1,_2):
   self.__objective_1_SEmosek_4fusion_4ObjectiveSense_2Lmosek_4fusion_4Expression_2(_0,_1,_2)
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_0))
  def _constraint_alt_Lmosek_4fusion_4ExprRangeDomain_2(self,_t__0):
    return self._constraint_Lmosek_4fusion_4ExprRangeDomain_2(_0)
  def _constraint_Lmosek_4fusion_4ExprRangeDomain_2(self,_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",(_0.expr),(_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ExprRangeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprRangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ExprRangeDomain_2__(_1))
  def _constraint_alt_SLmosek_4fusion_4ExprRangeDomain_2(self,_t__0,_t__1):
    return self._constraint_SLmosek_4fusion_4ExprRangeDomain_2(_0,_1)
  def _constraint_SLmosek_4fusion_4ExprRangeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,(_1.expr),(_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprConicDomain_2__(_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprConicDomain_2__(_0))
  def _constraint_alt_Lmosek_4fusion_4ExprConicDomain_2(self,_t__0):
    return self._constraint_Lmosek_4fusion_4ExprConicDomain_2(_0)
  def _constraint_Lmosek_4fusion_4ExprConicDomain_2(self,_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2("",(_0.expr),(_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ExprConicDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprConicDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ExprConicDomain_2__(_1))
  def _constraint_alt_SLmosek_4fusion_4ExprConicDomain_2(self,_t__0,_t__1):
    return self._constraint_SLmosek_4fusion_4ExprConicDomain_2(_0,_1)
  def _constraint_SLmosek_4fusion_4ExprConicDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_0,(_1.expr),(_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_0))
  def _constraint_alt_Lmosek_4fusion_4ExprLinearDomain_2(self,_t__0):
    return self._constraint_Lmosek_4fusion_4ExprLinearDomain_2(_0)
  def _constraint_Lmosek_4fusion_4ExprLinearDomain_2(self,_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",(_0.expr),(_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ExprLinearDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprLinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ExprLinearDomain_2__(_1))
  def _constraint_alt_SLmosek_4fusion_4ExprLinearDomain_2(self,_t__0,_t__1):
    return self._constraint_SLmosek_4fusion_4ExprLinearDomain_2(_0,_1)
  def _constraint_SLmosek_4fusion_4ExprLinearDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,(_1.expr),(_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ExprPSDDomain_2__(_0))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ExprPSDDomain_2__(_0))
  def _constraint_alt_Lmosek_4fusion_4ExprPSDDomain_2(self,_t__0):
    return self._constraint_Lmosek_4fusion_4ExprPSDDomain_2(_0)
  def _constraint_Lmosek_4fusion_4ExprPSDDomain_2(self,_0):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",(_0.expr),(_0.dom)))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ExprPSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4ExprPSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ExprPSDDomain_2__(_1))
  def _constraint_alt_SLmosek_4fusion_4ExprPSDDomain_2(self,_t__0,_t__1):
    return self._constraint_SLmosek_4fusion_4ExprPSDDomain_2(_0,_1)
  def _constraint_SLmosek_4fusion_4ExprPSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,(_1.expr),(_1.dom)))
  @staticmethod
  def _match_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _constraint_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1)
  def _constraint_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2("",_0,_1))
  @staticmethod
  def _match_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4Expression_2__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _constraint_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def _constraint_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4PSDDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4PSDDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4PSDDomain_2(_0)
  def _variable_Lmosek_4fusion_4PSDDomain_2(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",(_0._shape),_0))
  @staticmethod
  def _match_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_IILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_IILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_IILmosek_4fusion_4PSDDomain_2(numpy.int32(__0),numpy.int32(__1),_2)
  def _variable_IILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",numpy.array([_1,_0,_0], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4PSDDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2("",numpy.array([_0,_0], dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4PSDDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4PSDDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_3))
  @staticmethod
  def _match_alt_variable_SIILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_3))
  def _variable_alt_SIILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2,_t__3):
    return self._variable_SIILmosek_4fusion_4PSDDomain_2(_0,numpy.int32(__1),numpy.int32(__2),_3)
  def _variable_SIILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2,_3):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_0,numpy.array([_2,_1,_1], dtype=numpy.dtype(numpy.int32)),_3))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4PSDDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_0,numpy.array([_1,_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self._variable_S_3ILmosek_4fusion_4PSDDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4ConeDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4ConeDomain_2(_0)
  def _variable_Lmosek_4fusion_4ConeDomain_2(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",None,_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4RangeDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4RangeDomain_2(_0)
  def _variable_Lmosek_4fusion_4RangeDomain_2(self,_0):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",None,_0))
  @staticmethod
  def _match_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _match_alt_variable_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  def _variable_alt_Lmosek_4fusion_4LinearDomain_2(self,_t__0):
    return self._variable_Lmosek_4fusion_4LinearDomain_2(_0)
  def _variable_Lmosek_4fusion_4LinearDomain_2(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",None,_0))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  def _variable_alt__3ILmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1_res = self._variable__3ILmosek_4fusion_4ConeDomain_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4ConeDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",_0,_1))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt__3ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1_res = self._variable__3ILmosek_4fusion_4RangeDomain_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",_0,_1))
  @staticmethod
  def _match_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable__3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt__3ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _1_res = self._variable__3ILmosek_4fusion_4LinearDomain_2(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3ILmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",_0,_1))
  @staticmethod
  def _match_variable__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_variable__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _variable_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._variable__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable__3I(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",_0,mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4ConeDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4ConeDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2("",numpy.array([_0], dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4RangeDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2("",numpy.array([_0], dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt_ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._variable_ILmosek_4fusion_4LinearDomain_2(numpy.int32(__0),_1)
  def _variable_ILmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.array([_0], dtype=numpy.dtype(numpy.int32)),_1))
  @staticmethod
  def _match_variable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_variable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _variable_alt_I(self,_t__0):
    return self._variable_I(numpy.int32(__0))
  def _variable_I(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.array([_0], dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_variable_(*args):
    if len(args) != 0: return False
    return True
  def _variable_alt_(self,):
    return self._variable_()
  def _variable_(self,):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2("",numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4ConeDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4ConeDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4RangeDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4RangeDomain_2(self,_0,_1):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  @staticmethod
  def _match_alt_variable_SLmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_1))
  def _variable_alt_SLmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1):
    return self._variable_SLmosek_4fusion_4LinearDomain_2(_0,_1)
  def _variable_SLmosek_4fusion_4LinearDomain_2(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,None,_1))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self._variable_S_3ILmosek_4fusion_4ConeDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4ConeDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self._variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_S_3ILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _variable_alt_S_3ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self._variable_S_3ILmosek_4fusion_4LinearDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3ILmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,_1,_2))
  @staticmethod
  def _match_variable_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_variable_S_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match__3I__(_1))
  def _variable_alt_S_3I(self,_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._variable_S_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _variable_S_3I(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,_1,mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4ConeDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4ConeDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4RangeDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   return (self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1) and __arg_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  @staticmethod
  def _match_alt_variable_SILmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_2))
  def _variable_alt_SILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self._variable_SILmosek_4fusion_4LinearDomain_2(_0,numpy.int32(__1),_2)
  def _variable_SILmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32)),_2))
  @staticmethod
  def _match_variable_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_variable_SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_S__(_0) and __arg_alt_match_I__(_1))
  def _variable_alt_SI(self,_t__0,_t__1):
    return self._variable_SI(_0,numpy.int32(__1))
  def _variable_SI(self,_0,_1):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  @staticmethod
  def _match_variable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_variable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _variable_alt_S(self,_t__0):
    return self._variable_S(_0)
  def _variable_S(self,_0):
   return (self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),mosek.fusion.Domain._unbounded_()))
  def _removeConstraintBlock_alt_I(self,_t__0):
    return self._removeConstraintBlock_I(numpy.int32(__0))
  def _removeConstraintBlock_I(self,_0):
   if (_0 >= 0):
    self.__con_1release_I(_0)
   else:
    self.__acon_1release_I((- (1 + _0)))
  def _removeVariableBlock_alt_J(self,_t__0):
    return self._removeVariableBlock_J(numpy.int64(__0))
  def _removeVariableBlock_J(self,_0):
   if (self.__con_blocks._is_1parameterized_() or self.__afe_blocks._is_1parameterized_()):
    raise mosek_fusion_DeletionError._ctor_S("Cannot remove variables in parameterized model")
   if (_0 < 0):
    raise mosek_fusion_DeletionError._ctor_S("PSD variables cannot be removed")
   else:
    _1=numpy.int32(_0)
    _2=self.__var_block_map._blocksize_I(_1)
    _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    self.__var_block_map._get_I_3II(_1,_3,0)
    self.__var_block_map._free_I(_1)
    _4=self.__var_block_acc_id[_1]
    if (_4 >= 0):
     self._removeConstraintBlock_I(_4)
    self._task_1var_1putboundlist_1fr__3I(_3)
    self._task_1clearacollist__3I(_3)
  def __ranged_1variable_alt_S_3ILmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self.__ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __ranged_1variable_S_3ILmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _3=_2._finalize_1and_1validate__3I(_1)
   _4=(_3._shape)
   _5=int((_4).shape[0])
   _6=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_49(_5,_4,_6) 
   _7=1
   _7 = fragments._c_closure_50(_7,_4)
   _7 = numpy.int32(_7) # postprocess
   _8=None
   _9=None
   _10=None
   _11=None
   _12=None
   _13=None
   if ((int(len(_0)) > 0) and ((_3._indexnames) is not None)):
    _14=mosek.fusion.Utils.StringBuffer()
    _15=mosek.fusion.Utils.StringBuffer()
    _16=0
    _17=0
    _18=0
    if (int(((_3._indexnames)).shape[0])!=_5):
     raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
    for _19 in range(0,int(((_3._indexnames)).shape[0])):
     if ((_3._indexnames)[_19] is not None):
      if (_4[_19]!=int(((_3._indexnames)[_19]).shape[0])):
       raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
      _18 += _4[_19]
    _9 = numpy.zeros(((_18 + 1),), dtype=numpy.dtype(numpy.int64))
    _8 = numpy.array([(- 1) for _20 in range(0,_5)], dtype=numpy.dtype(numpy.int32))
    for _21 in range(0,int(((_3._indexnames)).shape[0])):
     if ((_3._indexnames)[_21] is not None):
      _8[_21] = _16
      for _22 in range(0,_4[_21]):
       _14._a_S((_3._indexnames)[_21][_22])
       _16 += 1
       _17 += int(len((_3._indexnames)[_21][_22]))
       _9[_16] = _17
    _10 = _14
    _13 = _15
   _23=None
   _24=None
   if (_3._empty):
    _23 = numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   elif ((_3._sparsity) is not None):
    if (int(((_3._sparsity)).shape[1])!=_5):
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is not correct")
    _25=int(((_3._sparsity)).shape[0])
    _23 = numpy.zeros((_25,), dtype=numpy.dtype(numpy.int64))
    _26=False
    _27=(_3._sparsity)
    _26 = fragments._c_closure_51(_26,_25,_4,_27,_23,_6)
    if _26:
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is out of bounds")
    _28=(_3._sparsity)
    _29=0
    _29 = fragments._c_closure_52(_29,_5,_4)
    _29 = numpy.int32(_29) # postprocess
    _30=numpy.zeros((_25,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_53(_30,_25) 
    _31=numpy.zeros((_25,), dtype=numpy.dtype(numpy.int32))
    _32=numpy.zeros(((_29 + 1),), dtype=numpy.dtype(numpy.int32))
    for _33 in range(0,_5):
     fragments._c_closure_54(_30,_33,_28,_25,_5,_32,_4,_31) 
     _34=_30
     _30 = _31
     _31 = _34
    fragments._c_closure_55(_30,_28,_25,_5,_23,_6) 
   _35=(int((_23).shape[0]) if ((_23 is not None) ) else _7)
   _36=numpy.zeros((_35,), dtype=numpy.dtype(numpy.int32))
   _37=self.__linearvar_1alloc_I_3I(_35,_36)
   if (int(len(_0)) > 0):
    self.__var_map._setItem_SI(_0,_37)
    _38=mosek.fusion.Utils.StringBuffer()
    _38._a_S(_0)._a_S("[")
    if (_5 > 0):
     _38._a_S("%0")
     for _39 in range(1,_5):
      _38._a_S(",%")._a_I(_39)
    _38._a_S("]")
    if ((_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_36,_38._toString_(),_4,_23,(_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_36,_38._toString_(),_4,_23,None)
   if (_3._scalable):
    _40 = numpy.array([(_3._lb)[0] for _42 in range(0,_35)], dtype=numpy.dtype(numpy.float64))
    _41 = numpy.array([(_3._ub)[0] for _43 in range(0,_35)], dtype=numpy.dtype(numpy.float64))
   else:
    _40 = (_3._lb)
    _41 = (_3._ub)
   self._task_1var_1putboundlist_1ra__3I_3D_3D(_36,_40,_41)
   _44=mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,_0,_37,_4,_23,_36)
   if (_3._cardinal_flag):
    self._task_1var_1putintlist__3I(_36)
   self.__vars[_37] = _44
   return (_44)
  def __variable_1_alt_S_3ILmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4ConeDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4ConeDomain_2(self,_0,_1,_2):
   _3=_2._finalize_1and_1validate__3I(_1)
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _4=(_3._shape)
   _5=int((_4).shape[0])
   _6=_3._getAxis_()
   _7=_4[_6]
   _8=1
   _9=1
   _10=1
   _10 = fragments._c_closure_56(_10,_5,_4)
   _10 = numpy.int32(_10) # postprocess
   _9 = fragments._c_closure_57(_6,_9,_4)
   _9 = numpy.int32(_9) # postprocess
   _8 = fragments._c_closure_58(_6,_8,_5,_4)
   _8 = numpy.int32(_8) # postprocess
   _11=(_9 * _8)
   if ((_3._key)==mosek.fusion.QConeKey.InQCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for quadratic cone")._toString_())
    _12 = self._task_1append_1domain_1quad_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.InRotatedQCone):
    if (_7 < 3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for rotated quadratic cone")._toString_())
    _12 = self._task_1append_1domain_1rquad_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.InPExpCone):
    if (_7!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for exponential cone")._toString_())
    _12 = self._task_1append_1domain_1pexp_()
   elif ((_3._key)==mosek.fusion.QConeKey.InPPowCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for power cone")._toString_())
    _12 = self._task_1append_1domain_1ppow_I_3D(_7,(_3._alpha))
   elif ((_3._key)==mosek.fusion.QConeKey.InDExpCone):
    if (_7!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for dual exponential cone")._toString_())
    _12 = self._task_1append_1domain_1dexp_()
   elif ((_3._key)==mosek.fusion.QConeKey.InDPowCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for dual power cone")._toString_())
    _12 = self._task_1append_1domain_1dpow_I_3D(_7,(_3._alpha))
   elif ((_3._key)==mosek.fusion.QConeKey.InPGeoMeanCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for primal geometric mean cone")._toString_())
    _12 = self._task_1append_1domain_1pgeomean_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.InDGeoMeanCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for dual geometric mean cone")._toString_())
    _12 = self._task_1append_1domain_1dgeomean_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.Positive):
    _12 = self._task_1append_1domain_1rpos_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.InSVecPSDCone):
    _13=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _7))) - 1) / 2))
    if (((_13 * (_13 + 1)) // 2)!=_7):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for vector positive semidefinite cone")._toString_())
    _12 = self._task_1append_1domain_1svec_1psd_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.Negative):
    _12 = self._task_1append_1domain_1rneg_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.Unbounded):
    _12 = self._task_1append_1domain_1r_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.Zero):
    _12 = self._task_1append_1domain_1rzero_I(_7)
   elif ((_3._key)==mosek.fusion.QConeKey.InPSDCone):
    if (_7 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for positive semidefinite cone")._toString_())
    else:
     _14=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _7))) - 1) / 2))
     if (((_14 * (_14 + 1)) // 2)!=_7):
      raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_7)._a_S(") for positive semidefinite cone")._toString_())
    _12 = self._task_1append_1domain_1svec_1psd_I(_7)
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Internal error: Invalid cone type")
   _15=numpy.zeros(((_11 * _7),), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
   _17=self.__conicvar_1alloc_JII_3I_3I(_12,_7,_11,_16,_15)
   self._task_1var_1putboundlist_1fr__3I(_15)
   if (_3._int_flag):
    self._task_1var_1putintlist__3I(_15)
   _18=_15
   if (_6 < (int((_4).shape[0]) - 1)):
    _18 = numpy.zeros((int((_15).shape[0]),), dtype=numpy.dtype(numpy.int32))
    _19=0
    _19 = fragments._c_closure_59(_7,_9,_8,_15,_19,_18)
    _19 = numpy.int32(_19) # postprocess
   _20=mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4Model_2SI_3I_3I(self,_0,_17,_4,_15)
   self.__vars[_17] = _20
   if (int(len(_0)) > 0):
    _21=mosek.fusion.Utils.StringBuffer()
    _21._a_S(_0)._a_S("[")
    if (_5 > 0):
     _21._a_S("%0")
     for _22 in range(1,_5):
      _21._a_S(",%")._a_I(_22)
    _21._a_S("]")
    if ((_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_18,_21._toString_(),_4,None,(_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_18,_21._toString_(),_4,None,None)
    _23=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
    self.__acc_block_map._get_I_3II(self.__var_block_acc_id[_17],_23,0)
    _24=numpy.zeros(((int((_4).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_60(_24,_6,_4) 
    fragments._c_closure_61(_24,_6,_5,_4) 
    _25=mosek.fusion.Utils.StringBuffer()
    _25._a_S(_0)._a_S("[")
    if ((_5 - 1) > 0):
     _25._a_S("%0")
     for _26 in range(1,_5):
      _25._a_S(",%")._a_I(_26)
    _25._a_S("]")
    if ((_3._indexnames) is not None):
     _27=numpy.ndarray(((_5 - 1),), dtype=numpy.dtype(object))
     for _28 in range(0,_6):
      _27[_28] = (_3._indexnames)[_28]
     for _29 in range((_6 + 1),_5):
      _27[(_29 - 1)] = (_3._indexnames)[_29]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([numpy.int64(_23[_30]) for _30 in range(0,_11)], dtype=numpy.dtype(numpy.int64)),_25._toString_(),_24,_27)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([numpy.int64(_23[_31]) for _31 in range(0,_11)], dtype=numpy.dtype(numpy.int64)),_25._toString_(),_24,None)
    self.__var_map._setItem_SI(_0,_17)
   return (_20)
  def __variable_1_alt_S_3ILmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4LinearDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _3=_2._finalize_1and_1validate__3I(_1)
   _4=(_3._shape)
   _5=int((_4).shape[0])
   _6=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_62(_5,_4,_6) 
   _7=1
   _7 = fragments._c_closure_63(_7,_4)
   _7 = numpy.int32(_7) # postprocess
   _8=None
   _9=None
   _10=None
   _11=None
   _12=None
   _13=None
   if ((int(len(_0)) > 0) and ((_3._indexnames) is not None)):
    _14=mosek.fusion.Utils.StringBuffer()
    _15=mosek.fusion.Utils.StringBuffer()
    _16=0
    _17=0
    _18=0
    if (int(((_3._indexnames)).shape[0])!=_5):
     raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
    for _19 in range(0,int(((_3._indexnames)).shape[0])):
     if ((_3._indexnames)[_19] is not None):
      if (_4[_19]!=int(((_3._indexnames)[_19]).shape[0])):
       raise mosek_fusion_DomainError._ctor_S("Invalid index name definition")
      _18 += _4[_19]
    _9 = numpy.zeros(((_18 + 1),), dtype=numpy.dtype(numpy.int64))
    _8 = numpy.array([(- 1) for _20 in range(0,_5)], dtype=numpy.dtype(numpy.int32))
    for _21 in range(0,int(((_3._indexnames)).shape[0])):
     if ((_3._indexnames)[_21] is not None):
      _8[_21] = _16
      for _22 in range(0,_4[_21]):
       _14._a_S((_3._indexnames)[_21][_22])
       _16 += 1
       _17 += int(len((_3._indexnames)[_21][_22]))
       _9[_16] = _17
    _10 = _14
    _13 = _15
   _23=None
   _24=None
   if (_3._empty):
    _23 = numpy.zeros((0,), dtype=numpy.dtype(numpy.int64))
   elif ((_3._sparsity) is not None):
    if (int(((_3._sparsity)).shape[1])!=_5):
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is not correct")
    _25=int(((_3._sparsity)).shape[0])
    _23 = numpy.zeros((_25,), dtype=numpy.dtype(numpy.int64))
    _26=False
    _27=(_3._sparsity)
    _26 = fragments._c_closure_64(_26,_25,_4,_27,_23,_6)
    if _26:
     raise mosek_fusion_SparseFormatError._ctor_S("Sparsity pattern is out of bounds")
    _28=(_3._sparsity)
    _29=0
    _29 = fragments._c_closure_65(_29,_5,_4)
    _29 = numpy.int32(_29) # postprocess
    _30=numpy.zeros((_25,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_66(_30,_25) 
    _31=numpy.zeros((_25,), dtype=numpy.dtype(numpy.int32))
    _32=numpy.zeros(((_29 + 1),), dtype=numpy.dtype(numpy.int32))
    for _33 in range(0,_5):
     fragments._c_closure_67(_30,_33,_28,_25,_5,_32,_4,_31) 
     _34=_30
     _30 = _31
     _31 = _34
    fragments._c_closure_68(_30,_28,_25,_5,_23,_6) 
   _35=(int((_23).shape[0]) if ((_23 is not None) ) else _7)
   _36=numpy.zeros((_35,), dtype=numpy.dtype(numpy.float64))
   if ((_3._bnd) is not None):
    if (int(((_3._bnd)).shape[0])==1):
     for _37 in range(0,_35):
      _36[_37] = (_3._bnd)[0]
    elif (int(((_3._bnd)).shape[0])==_35):
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII((_3._bnd),0,_36,0,_35)
    else:
     raise mosek_fusion_DimensionError._ctor_S("Invalid right hand side shape in domain")
   _38=numpy.zeros((_35,), dtype=numpy.dtype(numpy.int32))
   _39=self.__linearvar_1alloc_I_3I(_35,_38)
   if ((_3._key)==mosek.fusion.RelationKey.IsFree):
    self._task_1var_1putboundlist_1fr__3I(_38)
   if ((_3._key)==mosek.fusion.RelationKey.LessThan):
    self._task_1var_1putboundlist_1up__3I_3D(_38,_36)
   elif ((_3._key)==mosek.fusion.RelationKey.GreaterThan):
    self._task_1var_1putboundlist_1lo__3I_3D(_38,_36)
   elif ((_3._key)==mosek.fusion.RelationKey.EqualsTo):
    self._task_1var_1putboundlist_1fx__3I_3D(_38,_36)
   _40=mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,_0,_39,_4,_23,_38)
   self.__vars[_39] = _40
   if (int(len(_0)) > 0):
    _41=mosek.fusion.Utils.StringBuffer()
    _41._a_S(_0)._a_S("[")
    if (_5 > 0):
     _41._a_S("%0")
     for _42 in range(1,_5):
      _41._a_S(",%")._a_I(_42)
    _41._a_S("]")
    if ((_3._indexnames) is not None):
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_38,_41._toString_(),_4,_23,(_3._indexnames))
    else:
     self._task_1format_1var_1names__3IS_3I_3J_3_3S(_38,_41._toString_(),_4,_23,None)
    self.__var_map._setItem_SI(_0,_39)
   if (_3._cardinal_flag):
    self._task_1var_1putintlist__3I(_38)
   return (_40)
  def __variable_1_alt_S_3ILmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=_t__2
   _1_res = self.__variable_1_S_3ILmosek_4fusion_4PSDDomain_2(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __variable_1_S_3ILmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasVariable_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate variable name '")._a_S(_0)._a_S("'")._toString_())
   _3=_2._finalize_1and_1validate__3I(_1)
   _4=(_3._shape)
   _5=(_3._conedim1)
   _6=(_3._conedim2)
   _7=int((_4).shape[0])
   _8=_4[_5]
   if (_5 > _6):
    _9=_5
    _5 = _6
    _6 = _9
   if ((_5==_6) or ((_5 < 0) or (_6 >= _7))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid cone order dimensions for semidefinite variables")
   if (_4[_5]!=_4[_6]):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape in cone order dimensions")
   _10=1
   _10 = fragments._c_closure_69(_5,_10,_4)
   _10 = numpy.int32(_10) # postprocess
   _10 = fragments._c_closure_70(_5,_6,_10,_4)
   _10 = numpy.int32(_10) # postprocess
   _10 = fragments._c_closure_71(_6,_7,_10,_4)
   _10 = numpy.int32(_10) # postprocess
   _11=(((_10 * _8) * (_8 + 1)) // 2)
   _12=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int64))
   _13=numpy.zeros((_10,), dtype=numpy.dtype(numpy.int32))
   _14=self.__barvar_1alloc_II_3I_3J(_8,_10,_13,_12)
   _15=mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,_0,_14,_4,(_3._conedim1),(_3._conedim2),_13,_12)
   if (int(len(_0)) > 0):
    _16=numpy.zeros(((_7 - 2),), dtype=numpy.dtype(numpy.int32))
    _17=(_5 if ((_5 < _6) ) else _6)
    _18=(_6 if ((_5 < _6) ) else _5)
    fragments._c_closure_72(_17,_16,_4) 
    fragments._c_closure_73(_17,_18,_16,_4) 
    fragments._c_closure_74(_18,_16,_7,_4) 
    _19=mosek.fusion.Utils.StringBuffer()
    _19._a_S(_0)._a_S("[")
    if ((_7 - 2) > 0):
     _19._a_S("%0")
     for _20 in range(1,(_7 - 2)):
      _19._a_S(",%")._a_I(_20)
    _19._a_S("]")
    if ((_3._indexnames) is not None):
     _21=numpy.ndarray(((_7 - 2),), dtype=numpy.dtype(object))
     for _22 in range(0,_17):
      _21[_22] = (_3._indexnames)[_22]
     for _23 in range((_17 + 1),_18):
      _21[(_23 - 1)] = (_3._indexnames)[_23]
     for _24 in range((_18 + 1),_7):
      _21[(_24 - 2)] = (_3._indexnames)[_24]
     self._task_1format_1barvar_1names__3IS_3I_3_3S(_13,_19._toString_(),_16,_21)
    else:
     self._task_1format_1barvar_1names__3IS_3I_3_3S(_13,_19._toString_(),_16,None)
   self.__barvars[_14] = _15
   if (int(len(_0)) > 0):
    self.__var_map._setItem_SI(_0,(- (_14 + 1)))
   return (_15)
  def __putfrows_alt__3IILmosek_4fusion_4WorkStack_2IIIII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _2=_t__2
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _6=numpy.int32(_t__6)
   _7=numpy.int32(_t__7)
   _1_res = self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_0,_1,_2,_3,_4,_5,_6,_7)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(self,_0,_1,_2,_3,_4,_5,_6,_7):
   _8=(_2.i32)
   _9=(_2.i64)
   _10=(_2.f64)
   _11=0
   _12=0
   _13=0
   _12,_11,_13 = fragments._c_closure_75(_12,self.__barvar_block_elm_barj,_11,_3,_6,_5,_8,_9,_13)
   _12 = numpy.int32(_12) # postprocess
   _11 = numpy.int32(_11) # postprocess
   _13 = numpy.int32(_13) # postprocess
   if (_3 > (int((_0).shape[0]) - _1)):
    raise mosek_fusion_UnexpectedError._ctor_S("Internal: Mismatching sizes")
   _14=_3
   _15=numpy.zeros(((_14 + 1),), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
   _17=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
   _18=numpy.zeros((_3,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_76(_18,_17,_7,_3,_6,_5,_15,_10,_8,_9,_16) 
   self._task_1putafeflist__3J_3I_3I_3D_3D(numpy.array([_0[(_19 + _1)] for _19 in range(0,_3)], dtype=numpy.dtype(numpy.int64)),_15,_16,_17,_18)
   if (_12 > 0):
    _20=_0
    _21=numpy.zeros(((_14 + 1),), dtype=numpy.dtype(numpy.int32))
    _22=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _23=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _24=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int64))
    _25=numpy.array([(- 1) for _26 in range(0,_13)], dtype=numpy.dtype(numpy.int32))
    _27=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
    _28=numpy.zeros((_13,), dtype=numpy.dtype(numpy.float64))
    _29=0
    _30=0
    _30,_29 = fragments._c_closure_77(_30,_29,_22,self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_dim,_7,_28,_23,_24,_25,_27,_6,_14,_21,_5,_10,_8,_9)
    _30 = numpy.int32(_30) # postprocess
    _29 = numpy.int32(_29) # postprocess
    _31=self._task_1appendsymmatlist__3I_3J_3I_3I_3D(_23,_24,_25,_27,_28)
    self._task_1putafebarfrowlist__3I_3I_3I_3J(_20,_21,_22,_31)
  def __putarows_alt__3ILmosek_4fusion_4WorkStack_2IIIII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=_t__1
   _2=numpy.int32(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _6=numpy.int32(_t__6)
   _1_res = self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_0,_1,_2,_3,_4,_5,_6)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __putarows__3ILmosek_4fusion_4WorkStack_2IIIII(self,_0,_1,_2,_3,_4,_5,_6):
   _7=(_1.i32)
   _8=(_1.i64)
   _9=(_1.f64)
   _10=0
   _11=0
   _12=0
   _11,_10,_12 = fragments._c_closure_78(_11,self.__barvar_block_elm_barj,_10,_2,_5,_4,_7,_8,_12)
   _11 = numpy.int32(_11) # postprocess
   _10 = numpy.int32(_10) # postprocess
   _12 = numpy.int32(_12) # postprocess
   _10 += _2
   _13=int((_0).shape[0])
   _14=numpy.zeros(((_13 + 1),), dtype=numpy.dtype(numpy.int64))
   _15=numpy.zeros((_10,), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros((_10,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_79(_16,_6,_2,_5,_4,_14,_9,_7,_8,_15) 
   self._task_1putarowlist__3I_3J_3I_3D(_0,_14,_15,_16)
   if (_11 > 0):
    _17=_0
    _18=numpy.zeros(((_13 + 1),), dtype=numpy.dtype(numpy.int64))
    _19=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
    _20=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int32))
    _21=numpy.zeros((_11,), dtype=numpy.dtype(numpy.int64))
    _22=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _23=numpy.zeros((_12,), dtype=numpy.dtype(numpy.int32))
    _24=numpy.zeros((_12,), dtype=numpy.dtype(numpy.float64))
    _25=0
    _26=0
    _26,_25 = fragments._c_closure_80(_26,_25,_19,self.__barvar_block_elm_barj,self.__barvar_block_elm_i,self.__barvar_block_elm_j,self.__barvar_dim,_6,_24,_20,_21,_22,_23,_5,_13,_18,_4,_9,_7,_8)
    _26 = numpy.int32(_26) # postprocess
    _25 = numpy.int32(_25) # postprocess
    _27=self._task_1appendsymmatlist__3I_3J_3I_3I_3D(_20,_21,_22,_23,_24)
    self._task_1putbararowlist__3I_3J_3I_3J(_17,_18,_19,_27)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4RangeDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   if (_2._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_1)))
   _3._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__rs,self.__ws,self.__xs)
   self.__rs._pop_1expr_()
   _4=(self.__rs.i32)
   _5=(self.__rs.i64)
   _6=(self.__rs.f64)
   _7=(self.__rs.nd)
   _8=(self.__rs.shape_base)
   _9=(self.__rs.nelem)
   _10=(self.__rs.nnz)
   _11=(self.__rs.ncodeatom)
   _12=(self.__rs.hassp)
   _13=(self.__rs.ptr_base)
   _14=(self.__rs.nidxs_base)
   _15=(self.__rs.cof_base)
   _16=(self.__rs.codeptr_base)
   _17=(self.__rs.code_base)
   _18=(self.__rs.cconst_base)
   _19=numpy.array([_4[(_8 + _20)] for _20 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
   _21=_2._finalize_1and_1validate__3I(_19)
   if ((_21._shape) is not None):
    if (int(((_21._shape)).shape[0])!=_7):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching expression and domain")
    else:
     for _22 in range(0,_7):
      if ((_21._shape)[_22]!=_4[(_8 + _22)]):
       raise mosek_fusion_DimensionError._ctor_S("Mismatching expression and domain")
   _23=1
   _23 = fragments._c_closure_81(_7,_23,_4,_8)
   _23 = numpy.int32(_23) # postprocess
   _24=numpy.zeros((_23,), dtype=numpy.dtype(numpy.int32))
   _25=self.__con_1allocate__3I(_24)
   self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_24,self.__rs,_9,_10,_13,_14,_15)
   self.__xs._clear_()
   _26=numpy.zeros((_23,), dtype=numpy.dtype(numpy.float64))
   _27=numpy.zeros((_23,), dtype=numpy.dtype(numpy.float64))
   _28=(_21._lb)
   _29=(_21._ub)
   _30=(_21._empty)
   _31=(_21._scalable)
   _32=(_21._sparsity)
   fragments._c_closure_82(_26,_27,_30,_28,_31,_32,_29,_7,_23,_4,_8) 
   self._task_1con_1putboundlist_1ra__3I_3D_3D(_24,_26,_27)
   if (_11 > 0):
    self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_24,_13,_14,_16,_17,_18)
   if (int(len(_0)) > 0):
    _33=mosek.fusion.Utils.StringBuffer()
    _33._a_S(_0)._a_S("[")
    if (int((_19).shape[0]) > 0):
     _33._a_S("%0")
    for _34 in range(1,int((_19).shape[0])):
     _33._a_S(",%")._a_I(_34)
    _33._a_S("]")
    if ((_21._indexnames) is not None):
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_24,_33._toString_(),_19,None,(_21._indexnames))
    else:
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_24,_33._toString_(),_19,None,None)
   _35=mosek_fusion_RangedConstraint._ctor_Lmosek_4fusion_4Model_2S_3I_3II(self,_0,numpy.array([_4[(_8 + _36)] for _36 in range(0,_7)], dtype=numpy.dtype(numpy.int32)),_24,_25)
   self.__cons[_25] = _35
   if (int(len(_0)) > 0):
    self.__con_map._setItem_SI(_0,_25)
   return (_35)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4PSDDomain_2(self,_0,_1,_2):
   _3=_1._getShape_()
   _4=_2._finalize_1and_1validate__3I(_3)
   _5=((_4._conedim1) < (_4._conedim2))
   _6=((_4._conedim2) if (((_4._conedim1) < (_4._conedim2)) ) else (_4._conedim1))
   _7=((_4._conedim1) if (((_4._conedim1) < (_4._conedim2)) ) else (_4._conedim2))
   _8=mosek_fusion_ExprDenseTril._ctor_IILmosek_4fusion_4Expression_2(_7,_6,mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprScaleVecPSD._ctor_IILmosek_4fusion_4BaseExpression_2(_7,_6,mosek_fusion_ExprDenseTril._ctor_IILmosek_4fusion_4Expression_2(_7,_6,(mosek_fusion_ExprSymmetrize._ctor_IILmosek_4fusion_4Expression_2(_7,_6,_1) if (((_4._key)==mosek.fusion.PSDKey.IsSymPSD) ) else _1))))))
   _8._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__rs,self.__ws,self.__xs)
   _9=(self.__rs.i32)
   _10=(self.__rs.i64)
   _11=(self.__rs.f64)
   _12=(self.__rs.nd)
   _13=(self.__rs.nelem)
   _14=(self.__rs.nnz)
   _15=(self.__rs.hassp)
   _16=(self.__rs.ncodeatom)
   _17=(self.__rs.shape_base)
   _18=(self.__rs.ptr_base)
   _19=(self.__rs.nidxs_base)
   _20=(self.__rs.sp_base)
   _21=(self.__rs.cof_base)
   _22=(self.__rs.codeptr_base)
   _23=(self.__rs.code_base)
   _24=(self.__rs.cconst_base)
   _25=_3[_6]
   _26=((_25 * (_25 + 1)) // 2)
   _27=1
   _27 = fragments._c_closure_83(_7,_6,_12,_27,_3)
   _27 = numpy.int32(_27) # postprocess
   _28=self._task_1append_1domain_1svec_1psd_I(_26)
   _29=(_26 * _27)
   _30=numpy.zeros((_29,), dtype=numpy.dtype(numpy.int32))
   _31=numpy.zeros((_27,), dtype=numpy.dtype(numpy.int32))
   _32=numpy.zeros((_29,), dtype=numpy.dtype(numpy.int32))
   _33=numpy.zeros((_29,), dtype=numpy.dtype(numpy.float64))
   _34=self.__acon_1allocate_JII_3D_3I_3I(_28,_26,_27,_33,_30,_31)
   _35=numpy.zeros((_29,), dtype=numpy.dtype(numpy.int32))
   self.__acon_block_map._get_I_3II(_34,_35,0)
   _36=1
   _37=_3[_6]
   _38=1
   _39=_3[_7]
   _40=1
   _40 = fragments._c_closure_84(_7,_40,_3)
   _40 = numpy.int64(_40) # postprocess
   _38 = fragments._c_closure_85(_7,_6,_38,_3)
   _38 = numpy.int64(_38) # postprocess
   _36 = fragments._c_closure_86(_6,_36,_12,_3)
   _36 = numpy.int64(_36) # postprocess
   _41=0
   _42=(1.0 / mosek.fusion.Utils.Tools._sqrt_D(2))
   _41 = fragments._c_closure_87(self.__acon_elm_scale,_35,_40,_39,_38,_37,_36,_41,_42)
   _41 = numpy.int32(_41) # postprocess
   _43=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
   _44=0
   _44 = fragments._c_closure_88(_30,_43,_26,_40,_39,_38,_37,_36,_44,_5)
   _44 = numpy.int32(_44) # postprocess
   self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_43,0,self.__rs,_13,_14,_18,_19,_21)
   if (_16 > 0):
    self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_43,_18,_19,_22,_23,_24)
   _45=numpy.zeros((((_27 * _39) * _39),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_89(_30,_26,_40,_39,_38,_37,_36,_45,_5) 
   if (int(len(_0)) > 0):
    _46=numpy.zeros(((int((_3).shape[0]) - 2),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_90(_7,_46,_3) 
    fragments._c_closure_91(_7,_6,_46,_3) 
    fragments._c_closure_92(_6,_46,_12,_3) 
    _47=mosek.fusion.Utils.StringBuffer()
    _47._a_S(_0)._a_S("[")
    if (_12 > 2):
     _47._a_S("%0")
     for _48 in range(1,(_12 - 2)):
      _47._a_S(",%")._a_I(_48)
    _47._a_S("]")
    if ((_4._indexnames) is not None):
     _49=(_4._indexnames)
     _50=numpy.ndarray(((_12 - 2),), dtype=numpy.dtype(object))
     for _51 in range(0,_7):
      _50[_51] = _49[_51]
     for _52 in range((_7 + 1),_6):
      _50[(_52 - 1)] = _49[_52]
     for _53 in range((_6 + 1),_12):
      _50[(_53 - 2)] = _49[_53]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_31[_54] for _54 in range(0,int((_31).shape[0]))], dtype=numpy.dtype(numpy.int64)),_47._toString_(),_46,_50)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_31[_55] for _55 in range(0,int((_31).shape[0]))], dtype=numpy.dtype(numpy.int64)),_47._toString_(),_46,None)
   _56=mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,_0,None,_3,_34,_45,None)
   self.__acons[_34] = _56
   if (int(len(_0)) > 0):
    self.__con_map._setItem_SI(_0,(- (1 + _34)))
   return (_56)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4ConeDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   if (_2._int_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_1)))
   _3._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__rs,self.__ws,self.__xs)
   self.__rs._pop_1expr_()
   _4=(self.__rs.i32)
   _5=(self.__rs.i64)
   _6=(self.__rs.f64)
   _7=(self.__rs.nd)
   _8=(self.__rs.shape_base)
   _9=(self.__rs.nelem)
   _10=(self.__rs.nnz)
   _11=(self.__rs.ncodeatom)
   _12=(self.__rs.hassp)
   _13=(self.__rs.ptr_base)
   _14=(self.__rs.nidxs_base)
   _15=(self.__rs.cof_base)
   _16=(self.__rs.code_base)
   _17=(self.__rs.codeptr_base)
   _18=(self.__rs.cconst_base)
   _19=numpy.array([_4[(_8 + _20)] for _20 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
   _21=_2._finalize_1and_1validate__3I(_19)
   _22=(_21._getAxis_() if (_21._axisIsSet_() ) else (_7 - 1))
   _23=_19[_22]
   _24=1
   _25=1
   _26=1
   _26 = fragments._c_closure_93(_26,_7,_19)
   _26 = numpy.int32(_26) # postprocess
   _25 = fragments._c_closure_94(_22,_25,_19)
   _25 = numpy.int32(_25) # postprocess
   _24 = fragments._c_closure_95(_22,_24,_7,_19)
   _24 = numpy.int32(_24) # postprocess
   _27=(_25 * _24)
   if ((_21._key)==mosek.fusion.QConeKey.InQCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for quadratic cone")._toString_())
    _28 = self._task_1append_1domain_1quad_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.InRotatedQCone):
    if (_23 < 3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for rotated quadratic cone")._toString_())
    _28 = self._task_1append_1domain_1rquad_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.InPExpCone):
    if (_23!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for exponential cone")._toString_())
    _28 = self._task_1append_1domain_1pexp_()
   elif ((_21._key)==mosek.fusion.QConeKey.InPPowCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for power cone")._toString_())
    if (int(((_21._alpha)).shape[0]) < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Power cone requires at least two parameters")._toString_())
    _28 = self._task_1append_1domain_1ppow_I_3D(_23,(_21._alpha))
   elif ((_21._key)==mosek.fusion.QConeKey.InDExpCone):
    if (_23!=3):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for dual exponential cone")._toString_())
    _28 = self._task_1append_1domain_1dexp_()
   elif ((_21._key)==mosek.fusion.QConeKey.InDPowCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for dual power cone")._toString_())
    if (int(((_21._alpha)).shape[0]) < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Power cone requires at least two parameters")._toString_())
    _28 = self._task_1append_1domain_1dpow_I_3D(_23,(_21._alpha))
   elif ((_21._key)==mosek.fusion.QConeKey.InPGeoMeanCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for primal geometric mean cone")._toString_())
    _28 = self._task_1append_1domain_1pgeomean_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.InDGeoMeanCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for dual geometric mean cone")._toString_())
    _28 = self._task_1append_1domain_1dgeomean_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.InSVecPSDCone):
    _29=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _23))) - 1) / 2))
    if (((_29 * (_29 + 1)) // 2)!=_23):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for vector positive semidefinite cone")._toString_())
    _28 = self._task_1append_1domain_1svec_1psd_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.Positive):
    _28 = self._task_1append_1domain_1rpos_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.Negative):
    _28 = self._task_1append_1domain_1rneg_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.Unbounded):
    _28 = self._task_1append_1domain_1r_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.Zero):
    _28 = self._task_1append_1domain_1rzero_I(_23)
   elif ((_21._key)==mosek.fusion.QConeKey.InPSDCone):
    if (_23 < 2):
     raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for positive semidefinite cone")._toString_())
    else:
     _30=numpy.int32(((mosek.fusion.Utils.Tools._sqrt_D((1 + (8 * _23))) - 1) / 2))
     if (((_30 * (_30 + 1)) // 2)!=_23):
      raise mosek_fusion_DimensionError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Invalid size (")._a_I(_23)._a_S(") for positive semidefinite cone")._toString_())
    _28 = self._task_1append_1domain_1svec_1psd_I(_23)
   else:
    raise mosek_fusion_UnexpectedError._ctor_S("Internal error: Invalid cone type")
   _31=numpy.zeros((_26,), dtype=numpy.dtype(numpy.float64))
   _32=numpy.zeros((_26,), dtype=numpy.dtype(numpy.int32))
   _33=numpy.zeros((_27,), dtype=numpy.dtype(numpy.int32))
   _34=self.__acon_1allocate_JII_3D_3I_3I(_28,_23,_27,_31,_32,_33)
   _35=numpy.zeros((_26,), dtype=numpy.dtype(numpy.int32))
   _36=0
   _37=(_21._domofs)
   _36 = fragments._c_closure_96(_23,_25,_24,_26,_31,_36,_37,_35)
   _36 = numpy.int32(_36) # postprocess
   _38=numpy.array([_32[_35[_39]] for _39 in range(0,_26)], dtype=numpy.dtype(numpy.int32))
   self.__putfrows__3IILmosek_4fusion_4WorkStack_2IIIII(_38,0,self.__rs,_9,_10,_13,_14,_15)
   if (_11 > 0):
    self.__afe_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_38,_13,_14,_17,_16,_18)
   if (int(len(_0)) > 0):
    _40=numpy.zeros(((int((_19).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_97(_40,_22,_19) 
    fragments._c_closure_98(_40,_22,_7,_19) 
    _41=mosek.fusion.Utils.StringBuffer()
    _41._a_S(_0)._a_S("[")
    if (_7 > 1):
     _41._a_S("%0")
     for _42 in range(1,(_7 - 1)):
      _41._a_S(",%")._a_I(_42)
    _41._a_S("]")
    if ((_21._indexnames) is not None):
     _43=(_21._indexnames)
     _44=numpy.ndarray(((_7 - 1),), dtype=numpy.dtype(object))
     for _45 in range(0,_22):
      _44[_45] = _43[_45]
     for _46 in range((_22 + 1),_7):
      _44[(_46 - 1)] = _43[_46]
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_33[_47] for _47 in range(0,int((_33).shape[0]))], dtype=numpy.dtype(numpy.int64)),_41._toString_(),_40,_44)
    else:
     self._task_1format_1acc_1names__3JS_3I_3_3S(numpy.array([_33[_48] for _48 in range(0,int((_33).shape[0]))], dtype=numpy.dtype(numpy.int64)),_41._toString_(),_40,None)
   _49=mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,_0,_21,_19,_34,_32,(_21._indexnames))
   self.__acons[_34] = _49
   if (int(len(_0)) > 0):
    self.__con_map._setItem_SI(_0,(- (_34 + 1)))
   return (_49)
  def __constraint_1_alt_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_t__0,_t__1,_t__2):
    return self.__constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(_0,_1,_2)
  def __constraint_1_SLmosek_4fusion_4Expression_2Lmosek_4fusion_4LinearDomain_2(self,_0,_1,_2):
   if ((int(len(_0)) > 0) and self._hasConstraint_S(_0)):
    raise mosek_fusion_NameError._ctor_S(mosek.fusion.Utils.StringBuffer()._a_S("Duplicate constraint name '")._a_S(_0)._a_S("'")._toString_())
   if (_2._cardinal_flag):
    raise mosek_fusion_DomainError._ctor_S("Integer domain not allowed in a constraint")
   _3=mosek_fusion_ExprDense._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprOptimizeCode._ctor_Lmosek_4fusion_4Expression_2(mosek_fusion_ExprCompress._ctor_Lmosek_4fusion_4Expression_2(_1)))
   _3._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self.__rs,self.__ws,self.__xs)
   self.__rs._pop_1expr_()
   _4=(self.__rs.i32)
   _5=(self.__rs.i64)
   _6=(self.__rs.f64)
   _7=(self.__rs.nd)
   _8=(self.__rs.nelem)
   _9=(self.__rs.nnz)
   _10=(self.__rs.hassp)
   _11=(self.__rs.ncodeatom)
   _12=(self.__rs.shape_base)
   _13=(self.__rs.ptr_base)
   _14=(self.__rs.nidxs_base)
   _15=(self.__rs.cof_base)
   _16=(self.__rs.codeptr_base)
   _17=(self.__rs.code_base)
   _18=(self.__rs.cconst_base)
   _19=numpy.array([_4[(_12 + _20)] for _20 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
   _21=_2._finalize_1and_1validate__3I(_19)
   _22=(_21._domsize)
   _23=(_21._indexnames)
   _25=numpy.zeros((_22,), dtype=numpy.dtype(numpy.int32))
   _26=self.__con_1allocate__3I(_25)
   self.__putarows__3ILmosek_4fusion_4WorkStack_2IIIII(_25,self.__rs,_8,_9,_13,_14,_15)
   _27=(_21._sparsity)
   _28=(_21._empty)
   _29=(_21._bnd)
   _30=(_21._scalable)
   if (_29 is None):
    _24 = numpy.zeros((int((_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
   elif _30:
    _24 = numpy.array([_29[0] for _31 in range(0,int((_25).shape[0]))], dtype=numpy.dtype(numpy.float64))
   elif (_27 is not None):
    _32=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int32))
    _32[(_7 - 1)] = 1
    fragments._c_closure_99(_7,_19,_32) 
    _24 = numpy.zeros((int((_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_100(_24,_29,_27,_7,_32) 
   elif _28:
    _24 = numpy.zeros((int((_25).shape[0]),), dtype=numpy.dtype(numpy.float64))
   else:
    _24 = numpy.array([_29[_33] for _33 in range(0,int((_25).shape[0]))], dtype=numpy.dtype(numpy.float64))
   if ((_21._key)==mosek.fusion.RelationKey.IsFree):
    self._task_1con_1putboundlist_1fr__3I(_25)
   if ((_21._key)==mosek.fusion.RelationKey.LessThan):
    self._task_1con_1putboundlist_1up__3I_3D(_25,_24)
   elif ((_21._key)==mosek.fusion.RelationKey.GreaterThan):
    self._task_1con_1putboundlist_1lo__3I_3D(_25,_24)
   elif ((_21._key)==mosek.fusion.RelationKey.EqualsTo):
    self._task_1con_1putboundlist_1fx__3I_3D(_25,_24)
   if (_11 > 0):
    self.__con_blocks._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self.__rs,_25,_13,_14,_16,_17,_18)
   if (int(len(_0)) > 0):
    _34=mosek.fusion.Utils.StringBuffer()
    _34._a_S(_0)._a_S("[")
    if (int((_19).shape[0]) > 0):
     _34._a_S("%0")
    for _35 in range(1,int((_19).shape[0])):
     _34._a_S(",%")._a_I(_35)
    _34._a_S("]")
    if ((_21._indexnames) is not None):
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_25,_34._toString_(),_19,None,(_21._indexnames))
    else:
     self._task_1format_1con_1names__3IS_3I_3J_3_3S(_25,_34._toString_(),_19,None,None)
   _36=mosek_fusion_LinearConstraint._ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,_0,_26,_19,_25,_23)
   self.__cons[_26] = _36
   if (int(len(_0)) > 0):
    self.__con_map._setItem_SI(_0,_26)
   return (_36)
  @staticmethod
  def _match_getVersion_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getVersion_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _getVersion_alt_():
    return mosek_fusion_Model._getVersion_()
  @staticmethod
  def _getVersion_():
   return (mosek.fusion.BaseModel._env_1getversion_())
  @staticmethod
  def _match_hasParameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_hasParameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _hasParameter_alt_S(self,_t__0):
    return self._hasParameter_S(_0)
  def _hasParameter_S(self,_0):
   return (self.__par_map._hasItem_S(_0))
  @staticmethod
  def _match_hasConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_hasConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _hasConstraint_alt_S(self,_t__0):
    return self._hasConstraint_S(_0)
  def _hasConstraint_S(self,_0):
   return (self.__con_map._hasItem_S(_0))
  @staticmethod
  def _match_hasVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_hasVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _hasVariable_alt_S(self,_t__0):
    return self._hasVariable_S(_0)
  def _hasVariable_S(self,_0):
   return (self.__var_map._hasItem_S(_0))
  @staticmethod
  def _match_getParameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getParameter_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getParameter_alt_S(self,_t__0):
    return self._getParameter_S(_0)
  def _getParameter_S(self,_0):
   return ((self.__parameters[self.__par_map._getItem_S(_0)] if (self.__par_map._hasItem_S(_0) ) else None))
  @staticmethod
  def _match_getConstraint_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getConstraint_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getConstraint_alt_I(self,_t__0):
    return self._getConstraint_I(numpy.int32(__0))
  def _getConstraint_I(self,_0):
   if (_0 >= 0):
    _1 = self.__cons[_0]
   else:
    _1 = self.__acons[(- (1 + _0))]
   return (_1)
  @staticmethod
  def _match_getConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getConstraint_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getConstraint_alt_S(self,_t__0):
    return self._getConstraint_S(_0)
  def _getConstraint_S(self,_0):
   _1=None
   if self.__con_map._hasItem_S(_0):
    _2=self.__con_map._getItem_S(_0)
    if (_2 >= 0):
     _1 = self.__cons[_2]
    else:
     _1 = self.__acons[(- (1 + _2))]
   return (_1)
  @staticmethod
  def _match_getVariable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getVariable_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getVariable_alt_I(self,_t__0):
    return self._getVariable_I(numpy.int32(__0))
  def _getVariable_I(self,_0):
   return (self.__vars[_0])
  @staticmethod
  def _match_getVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_S__(_0))
  @staticmethod
  def _match_alt_getVariable_S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_S__(_0))
  def _getVariable_alt_S(self,_t__0):
    return self._getVariable_S(_0)
  def _getVariable_S(self,_0):
   if self.__var_map._hasItem_S(_0):
    _1=self.__var_map._getItem_S(_0)
    if (_1 < 0):
     return (self.__barvars[(- (_1 + 1))])
    else:
     return (self.__vars[_1])
   else:
    return (None)
  @staticmethod
  def _match_getName_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getName_(*args):
    if len(args) != 0: return False
    return True
  def _getName_alt_(self,):
    return self._getName_()
  def _getName_(self,):
   return (self.__model_name)
  def _getParameterValue_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._getParameterValue__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _getParameterValue__3I(self,_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_101(_0,self.__param_value,_1) 
   return (_1)
  def _setParameterValue_alt__3I_3D(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setParameterValue__3I_3D(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setParameterValue__3I_3D(self,_0,_1):
   fragments._c_closure_102(_0,self.__param_value,_1) 
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_Model._ctor_Lmosek_4fusion_4Model_2(self))
 return Model
mosek_fusion_Model=__mk_mosek_fusion_Model()
del __mk_mosek_fusion_Model
def __mk_mosek_fusion_Debug():
  import sys
  class Debug:
    @staticmethod
    def _o_(): return Debug()
    def p(self,v):
      sys.stdout.write(str(v))
      return self
    _p_S = p
    _p_I = p
    _p_J = p
    _p_D = p
    _p_Z = p
  
    def p_array (self,v):
      if v is None:
          sys.stdout.write('None')
      else:
          sys.stdout.write('[ %s ]' % ','.join([str(i) for i in v]))
      return self
  
    _p__3I = p_array
    _p__3J = p_array
    _p__3D = p_array
  
    def _lf_(self):
      sys.stdout.write("\n")
      return self
  return Debug
mosek_fusion_Debug=__mk_mosek_fusion_Debug()
#BEFORE CLASS
def __mk_mosek_fusion_Sort():
 class Sort(object):
  @staticmethod
  def argbucketsort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argbucketsort__3J_3IJJII(*args):
      return mosek_fusion_Sort._argbucketsort__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3IJJII(*args):
      return mosek_fusion_Sort._argbucketsort_alt__3J_3IJJII(*args)
    elif mosek_fusion_Sort._match_argbucketsort__3J_3JJJJJ(*args):
      return mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(*args)
    elif mosek_fusion_Sort._match_alt_argbucketsort__3J_3JJJJJ(*args):
      return mosek_fusion_Sort._argbucketsort_alt__3J_3JJJJJ(*args)
    else:
      raise ValueError('Invalid argument list argbucketsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,int32,int32)\n\tmosek.fusion.Sort.argbucketsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,int64,int64)')
  @staticmethod
  def issorted(*args):
    if False: pass
    elif mosek_fusion_Sort._match_issorted__3J_3IJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3IJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_issorted__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_issorted__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._issorted_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list issorted('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.issorted(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  @staticmethod
  def getminmax(*args):
    if False: pass
    elif mosek_fusion_Sort._match_getminmax__3J_3I_3IJJ_3I(*args):
      return mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3I_3IJJ_3I(*args):
      return mosek_fusion_Sort._getminmax_alt__3J_3I_3IJJ_3I(*args)
    elif mosek_fusion_Sort._match_getminmax__3J_3J_3JJJ_3J(*args):
      return mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(*args)
    elif mosek_fusion_Sort._match_alt_getminmax__3J_3J_3JJJ_3J(*args):
      return mosek_fusion_Sort._getminmax_alt__3J_3J_3JJJ_3J(*args)
    else:
      raise ValueError('Invalid argument list getminmax('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,array(int32,ndim=1))\n\tmosek.fusion.Sort.getminmax(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,array(int64,ndim=1))')
  @staticmethod
  def argTransposeSort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argTransposeSort__3J_3JIII_3J(*args):
      return mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(*args)
    elif mosek_fusion_Sort._match_alt_argTransposeSort__3J_3JIII_3J(*args):
      return mosek_fusion_Sort._argTransposeSort_alt__3J_3JIII_3J(*args)
    else:
      raise ValueError('Invalid argument list argTransposeSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argTransposeSort(array(int64,ndim=1),array(int64,ndim=1),int32,int32,int32,array(int64,ndim=1))')
  @staticmethod
  def argsort(*args):
    if False: pass
    elif mosek_fusion_Sort._match_argsort__3J_3J(*args):
      return mosek_fusion_Sort._argsort__3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I(*args):
      return mosek_fusion_Sort._argsort__3J_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3I(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3I(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3I(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3J(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3J(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3J(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3IJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3IJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3I_3IJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3I_3IJJZ(*args)
    elif mosek_fusion_Sort._match_argsort__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort__3J_3J_3JJJZ(*args)
    elif mosek_fusion_Sort._match_alt_argsort__3J_3J_3JJJZ(*args):
      return mosek_fusion_Sort._argsort_alt__3J_3J_3JJJZ(*args)
    else:
      raise ValueError('Invalid argument list argsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64,bool)\n\tmosek.fusion.Sort.argsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64,bool)')
  def __repr__(self): return 'mosek.fusion.Sort'
  @staticmethod
  def _match_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3) and __arg_match_I__(_4) and __arg_match__3J__(_5))
  @staticmethod
  def _match_alt_argTransposeSort__3J_3JIII_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match_I__(_4) and __arg_alt_match__3J__(_5))
  @staticmethod
  def _argTransposeSort_alt__3J_3JIII_3J(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int32(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argTransposeSort__3J_3JIII_3J(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argTransposeSort__3J_3JIII_3J(_0,_1,_2,_3,_4,_5):
   fragments._c_closure_103(_2,_3,_4,_0,_1,_5) 
  @staticmethod
  def _match_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_argsort__3J_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1))
  @staticmethod
  def _argsort_alt__3J_3J(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argsort__3J_3J(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J(_0,_1):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_0,_1,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_argsort__3J_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _argsort_alt__3J_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._argsort__3J_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I(_0,_1):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_0,_1,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2))
  @staticmethod
  def _match_alt_argsort__3J_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2))
  @staticmethod
  def _argsort_alt__3J_3J_3J(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3J(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3J(_0,_1,_2):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_argsort__3J_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _argsort_alt__3J_3I_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3I(_0,_1,_2):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,0,int((_0).shape[0]),False)
  @staticmethod
  def _match_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3))
  @staticmethod
  def _match_alt_argsort__3J_3JJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3))
  @staticmethod
  def _argsort_alt__3J_3JJJ(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _1_res = mosek_fusion_Sort._argsort__3J_3JJJ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3JJJ(_0,_1,_2,_3):
   mosek.fusion.Sort._argsort__3J_3JJJZ(_0,_1,_2,_3,False)
  @staticmethod
  def _match_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3))
  @staticmethod
  def _match_alt_argsort__3J_3IJJ(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3))
  @staticmethod
  def _argsort_alt__3J_3IJJ(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _1_res = mosek_fusion_Sort._argsort__3J_3IJJ(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3IJJ(_0,_1,_2,_3):
   mosek.fusion.Sort._argsort__3J_3IJJZ(_0,_1,_2,_3,False)
  @staticmethod
  def _match_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4):
   mosek.fusion.Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,False)
  @staticmethod
  def _match_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4):
   mosek.fusion.Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,False)
  @staticmethod
  def _match_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _argsort_alt__3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1_res = mosek_fusion_Sort._argsort__3J_3JJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3JJJZ(_0,_1,_2,_3,_4):
   if ((not _4) or ((_3 - _2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_2,_3)
   elif (not mosek.fusion.Sort._issorted__3J_3JJJZ(_0,_1,_2,_3,_4)):
    _5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _6=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,None,_2,_3,_5)
    if ((_5[1] - _5[0]) < (_6 * (_3 - _2))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_5[0],_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_2,_3)
  @staticmethod
  def _match_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_argsort__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _argsort_alt__3J_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1_res = mosek_fusion_Sort._argsort__3J_3IJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3IJJZ(_0,_1,_2,_3,_4):
   if ((not _4) or ((_3 - _2) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_2,_3)
   elif (not mosek.fusion.Sort._issorted__3J_3IJJZ(_0,_1,_2,_3,_4)):
    _5=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _6=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,None,_2,_3,_5)
    if ((_5[1] - _5[0]) < (_6 * (_3 - _2))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_1,_2,_3,_5[0],_5[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_2,_3)
  @staticmethod
  def _match_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_argsort__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _argsort_alt__3J_3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1_res = mosek_fusion_Sort._argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5):
   if ((not _5) or ((_4 - _3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   elif (not mosek.fusion.Sort._issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)):
    _6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int64))
    _7=2
    mosek.fusion.Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_6)
    if (((_6[1] - _6[0]) < (_7 * (_4 - _3))) and ((_6[3] - _6[2]) < (_7 * (_4 - _3)))):
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_2,_3,_4,_6[2],_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3JJJJJ(_0,_1,_3,_4,_6[0],_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_argsort__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _argsort_alt__3J_3I_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1_res = mosek_fusion_Sort._argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argsort__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5):
   if ((not _5) or ((_4 - _3) < 16)):
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   elif (not mosek.fusion.Sort._issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)):
    _6=numpy.zeros((4,), dtype=numpy.dtype(numpy.int32))
    _7=2
    mosek.fusion.Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_6)
    if (((_6[1] - _6[0]) < (_7 * (_4 - _3))) and ((_6[3] - _6[2]) < (_7 * (_4 - _3)))):
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_2,_3,_4,_6[2],_6[3])
     mosek.fusion.Sort._argbucketsort__3J_3IJJII(_0,_1,_3,_4,_6[0],_6[1])
    else:
     mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_J__(_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3JJJJJ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_J__(_5))
  @staticmethod
  def _argbucketsort_alt__3J_3JJJJJ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.int64(_t__5)
   _1_res = mosek_fusion_Sort._argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argbucketsort__3J_3JJJJJ(_0,_1,_2,_3,_4,_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3JJJ(_0,_2,_3,_1,_4,_5)
  @staticmethod
  def _match_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_I__(_4) and __arg_match_I__(_5))
  @staticmethod
  def _match_alt_argbucketsort__3J_3IJJII(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_I__(_4) and __arg_alt_match_I__(_5))
  @staticmethod
  def _argbucketsort_alt__3J_3IJJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _1_res = mosek_fusion_Sort._argbucketsort__3J_3IJJII(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argbucketsort__3J_3IJJII(_0,_1,_2,_3,_4,_5):
   mosek.fusion.Utils.Tools._bucketsort__3JJJ_3III(_0,_2,_3,_1,_4,_5)
  @staticmethod
  def _match_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3J__(_5))
  @staticmethod
  def _match_alt_getminmax__3J_3J_3JJJ_3J(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3J__(_5))
  @staticmethod
  def _getminmax_alt__3J_3J_3JJJ_3J(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_Sort._getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _getminmax__3J_3J_3JJJ_3J(_0,_1,_2,_3,_4,_5):
   fragments._c_closure_104(_3,_0,_4,_5,_1,_2) 
  @staticmethod
  def _match_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match__3I__(_5))
  @staticmethod
  def _match_alt_getminmax__3J_3I_3IJJ_3I(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match__3I__(_5))
  @staticmethod
  def _getminmax_alt__3J_3I_3IJJ_3I(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=numpy.array(_t__5,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Sort._getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _getminmax__3J_3I_3IJJ_3I(_0,_1,_2,_3,_4,_5):
   fragments._c_closure_105(_3,_0,_4,_5,_1,_2) 
  @staticmethod
  def _match_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_issorted__3J_3JJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _issorted_alt__3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1_res = mosek_fusion_Sort._issorted__3J_3JJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3JJJZ(_0,_1,_2,_3,_4):
   for _5 in range(_2,(_3 - 1)):
    if (_1[_0[_5]] > _1[_0[(_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match_J__(_2) and __arg_match_J__(_3) and __arg_match_Z__(_4))
  @staticmethod
  def _match_alt_issorted__3J_3IJJZ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_Z__(_4))
  @staticmethod
  def _issorted_alt__3J_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int64(_t__2)
   _3=numpy.int64(_t__3)
   _4=_t__4
   _1_res = mosek_fusion_Sort._issorted__3J_3IJJZ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3IJJZ(_0,_1,_2,_3,_4):
   for _5 in range(_2,(_3 - 1)):
    if (_1[_0[_5]] > _1[_0[(_5 + 1)]]):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_issorted__3J_3J_3JJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _issorted_alt__3J_3J_3JJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1_res = mosek_fusion_Sort._issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3J_3JJJZ(_0,_1,_2,_3,_4,_5):
   for _6 in range(_3,(_4 - 1)):
    if ((_1[_0[_6]] > _1[_0[(_6 + 1)]]) or ((_1[_0[(_6 + 1)]]==_1[_0[_6]]) and (_2[_0[_6]] > _2[_0[(_6 + 1)]]))):
     return (False)
   return (True)
  @staticmethod
  def _match_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4) and __arg_match_Z__(_5))
  @staticmethod
  def _match_alt_issorted__3J_3I_3IJJZ(*args):
    if len(args) != 6: return False
    _0,_1,_2,_3,_4,_5, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4) and __arg_alt_match_Z__(_5))
  @staticmethod
  def _issorted_alt__3J_3I_3IJJZ(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _5=_t__5
   _1_res = mosek_fusion_Sort._issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _issorted__3J_3I_3IJJZ(_0,_1,_2,_3,_4,_5):
   for _6 in range(_3,(_4 - 1)):
    if ((_1[_0[_6]] > _1[_0[(_6 + 1)]]) or ((_1[_0[_6]]==_1[_0[(_6 + 1)]]) and (_2[_0[_6]] > _2[_0[(_6 + 1)]]))):
     return (False)
   return (True)
 return Sort
mosek_fusion_Sort=__mk_mosek_fusion_Sort()
del __mk_mosek_fusion_Sort
#BEFORE CLASS
def __mk_mosek_fusion_IndexCounter():
 class IndexCounter(object):
  __slots__ = ['_IndexCounter__start','_IndexCounter__dims','_IndexCounter__strides','_IndexCounter__st','_IndexCounter__ii','_IndexCounter__n']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor__3I(*args):
      self._ctor_init__3I(*args)
    elif self.__match_alt_ctor__3I(*args):
      self._ctor_alt_init__3I(*args)
    elif self.__match_ctor_J_3I_3I(*args):
      self._ctor_init_J_3I_3I(*args)
    elif self.__match_alt_ctor_J_3I_3I(*args):
      self._ctor_alt_init_J_3I_3I(*args)
    elif self.__match_ctor_J_3I_3J(*args):
      self._ctor_init_J_3I_3J(*args)
    elif self.__match_alt_ctor_J_3I_3J(*args):
      self._ctor_alt_init_J_3I_3J(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.IndexCounter.ctor(array(int32,ndim=1))\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.IndexCounter.ctor(int64,array(int32,ndim=1),array(int64,ndim=1))')
  def getIndex(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_getIndex_(*args):
      return self._getIndex_(*args)
    elif mosek_fusion_IndexCounter._match_alt_getIndex_(*args):
      return self._getIndex_alt_(*args)
    else:
      raise ValueError('Invalid argument list getIndex('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.getIndex()')
  def inc(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_inc_(*args):
      return self._inc_(*args)
    elif mosek_fusion_IndexCounter._match_alt_inc_(*args):
      return self._inc_alt_(*args)
    else:
      raise ValueError('Invalid argument list inc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.inc()')
  def next(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_next_(*args):
      return self._next_(*args)
    elif mosek_fusion_IndexCounter._match_alt_next_(*args):
      return self._next_alt_(*args)
    else:
      raise ValueError('Invalid argument list next('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.next()')
  def reset(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_reset_(*args):
      return self._reset_(*args)
    elif mosek_fusion_IndexCounter._match_alt_reset_(*args):
      return self._reset_alt_(*args)
    else:
      raise ValueError('Invalid argument list reset('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.reset()')
  def get(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_get_(*args):
      return self._get_(*args)
    elif mosek_fusion_IndexCounter._match_alt_get_(*args):
      return self._get_alt_(*args)
    else:
      raise ValueError('Invalid argument list get('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.get()')
  def atEnd(self,*args):
    if False: pass
    elif mosek_fusion_IndexCounter._match_atEnd_(*args):
      return self._atEnd_(*args)
    elif mosek_fusion_IndexCounter._match_alt_atEnd_(*args):
      return self._atEnd_alt_(*args)
    else:
      raise ValueError('Invalid argument list atEnd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.IndexCounter.atEnd()')
  def __repr__(self): return 'mosek.fusion.IndexCounter'
  @staticmethod
  def _ctor__3I(shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init__3I(shape)
    return o
  @staticmethod
  def __match_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_alt_match__3I__(shape))
  def _ctor_alt_init__3I(self,shape):
    self._ctor_init__3I(numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3I(self,shape):
   self.__n = int((shape).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   self.__start = 0
   self.__strides = mosek.fusion.Set._strides__3I(shape)
   self.__dims = numpy.array([shape[_0] for _0 in range(0,int((shape).shape[0]))], dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_J_3I_3I(start_,dims_,shape):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3I_3I(start_,dims_,shape)
    return o
  @staticmethod
  def __match_ctor_J_3I_3I(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor_J_3I_3I(*args):
    if len(args) != 3: return False
    start_,dims_,shape, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match__3I__(shape))
  def _ctor_alt_init_J_3I_3I(self,start_,dims_,shape):
    self._ctor_init_J_3I_3I(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_J_3I_3I(self,start_,dims_,shape):
   _0=int((shape).shape[0])
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_106(self.__n,self.__st,start_) 
   self.__strides = mosek.fusion.Set._strides__3I(shape)
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _ctor_J_3I_3J(start_,dims_,strides_):
    o = IndexCounter.__new__(IndexCounter)
    o._ctor_init_J_3I_3J(start_,dims_,strides_)
    return o
  @staticmethod
  def __match_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_match_J__(start_) and __arg_match__3I__(dims_) and __arg_match__3J__(strides_))
  @staticmethod
  def __match_alt_ctor_J_3I_3J(*args):
    if len(args) != 3: return False
    start_,dims_,strides_, = args
    return (__arg_alt_match_J__(start_) and __arg_alt_match__3I__(dims_) and __arg_alt_match__3J__(strides_))
  def _ctor_alt_init_J_3I_3J(self,start_,dims_,strides_):
    self._ctor_init_J_3I_3J(numpy.int64(start_),numpy.array(dims_,dtype=numpy.dtype(numpy.int32)),numpy.array(strides_,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_J_3I_3J(self,start_,dims_,strides_):
   self.__n = int((dims_).shape[0])
   self.__ii = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int32))
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_107(self.__n,self.__st,start_) 
   self.__strides = strides_
   self.__dims = dims_
   self.__start = start_
  @staticmethod
  def _match_atEnd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_atEnd_(*args):
    if len(args) != 0: return False
    return True
  def _atEnd_alt_(self,):
    return self._atEnd_()
  def _atEnd_(self,):
   return ((self.__ii[(self.__n - 1)] >= self.__dims[(self.__n - 1)]))
  @staticmethod
  def _match_getIndex_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getIndex_(*args):
    if len(args) != 0: return False
    return True
  def _getIndex_alt_(self,):
    return self._getIndex_()
  def _getIndex_(self,):
   return (self.__ii)
  @staticmethod
  def _match_next_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_next_(*args):
    if len(args) != 0: return False
    return True
  def _next_alt_(self,):
    return self._next_()
  def _next_(self,):
   _0=self._get_()
   self._inc_()
   return numpy.int64(_0)
  @staticmethod
  def _match_get_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_(*args):
    if len(args) != 0: return False
    return True
  def _get_alt_(self,):
    return self._get_()
  def _get_(self,):
   return numpy.int64(self.__st[0])
  @staticmethod
  def _match_inc_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inc_(*args):
    if len(args) != 0: return False
    return True
  def _inc_alt_(self,):
    return self._inc_()
  def _inc_(self,):
   fragments._c_closure_108(self.__dims,self.__ii,self.__n,self.__st,self.__strides) 
  @staticmethod
  def _match_reset_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_reset_(*args):
    if len(args) != 0: return False
    return True
  def _reset_alt_(self,):
    return self._reset_()
  def _reset_(self,):
   self.__st = numpy.zeros((self.__n,), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_109(self.__n,self.__st,self.__start) 
 return IndexCounter
mosek_fusion_IndexCounter=__mk_mosek_fusion_IndexCounter()
del __mk_mosek_fusion_IndexCounter
#BEFORE CLASS
def __mk_mosek_fusion_CommonTools():
 class CommonTools(object):
  @staticmethod
  def resize(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_resize__3DI(*args):
      return mosek_fusion_CommonTools._resize__3DI(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3DI(*args):
      return mosek_fusion_CommonTools._resize_alt__3DI(*args)
    elif mosek_fusion_CommonTools._match_resize__3II(*args):
      return mosek_fusion_CommonTools._resize__3II(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3II(*args):
      return mosek_fusion_CommonTools._resize_alt__3II(*args)
    elif mosek_fusion_CommonTools._match_resize__3JI(*args):
      return mosek_fusion_CommonTools._resize__3JI(*args)
    elif mosek_fusion_CommonTools._match_alt_resize__3JI(*args):
      return mosek_fusion_CommonTools._resize_alt__3JI(*args)
    else:
      raise ValueError('Invalid argument list resize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.resize(array(double,ndim=1),int32)\n\tmosek.fusion.CommonTools.resize(array(int32,ndim=1),int32)\n\tmosek.fusion.CommonTools.resize(array(int64,ndim=1),int32)')
  @staticmethod
  def transposeTriplets(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
      return mosek_fusion_CommonTools._transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list transposeTriplets('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)\n\tmosek.fusion.CommonTools.transposeTriplets(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int64,ndim=1),ndim=1),array(array(int64,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  @staticmethod
  def argQsort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_argQsort__3J_3I_3IJJ(*args):
      return mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3I_3IJJ(*args):
      return mosek_fusion_CommonTools._argQsort_alt__3J_3I_3IJJ(*args)
    elif mosek_fusion_CommonTools._match_argQsort__3J_3J_3JJJ(*args):
      return mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(*args)
    elif mosek_fusion_CommonTools._match_alt_argQsort__3J_3J_3JJJ(*args):
      return mosek_fusion_CommonTools._argQsort_alt__3J_3J_3JJJ(*args)
    else:
      raise ValueError('Invalid argument list argQsort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int32,ndim=1),array(int32,ndim=1),int64,int64)\n\tmosek.fusion.CommonTools.argQsort(array(int64,ndim=1),array(int64,ndim=1),array(int64,ndim=1),int64,int64)')
  @staticmethod
  def binarySearchR(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearchR__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchR__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearchR__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchR_alt__3JJ(*args)
    else:
      raise ValueError('Invalid argument list binarySearchR('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearchR(array(int64,ndim=1),int64)')
  @staticmethod
  def ndIncr(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_ndIncr__3I_3I_3I(*args):
      return mosek_fusion_CommonTools._ndIncr__3I_3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_ndIncr__3I_3I_3I(*args):
      return mosek_fusion_CommonTools._ndIncr_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list ndIncr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.ndIncr(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def binarySearchL(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearchL__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchL__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearchL__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearchL_alt__3JJ(*args)
    else:
      raise ValueError('Invalid argument list binarySearchL('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearchL(array(int64,ndim=1),int64)')
  @staticmethod
  def argMSort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_argMSort__3I_3I(*args):
      return mosek_fusion_CommonTools._argMSort__3I_3I(*args)
    elif mosek_fusion_CommonTools._match_alt_argMSort__3I_3I(*args):
      return mosek_fusion_CommonTools._argMSort_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list argMSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.argMSort(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def binarySearch(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_binarySearch__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearch__3JJ(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearch__3JJ(*args):
      return mosek_fusion_CommonTools._binarySearch_alt__3JJ(*args)
    elif mosek_fusion_CommonTools._match_binarySearch__3II(*args):
      return mosek_fusion_CommonTools._binarySearch__3II(*args)
    elif mosek_fusion_CommonTools._match_alt_binarySearch__3II(*args):
      return mosek_fusion_CommonTools._binarySearch_alt__3II(*args)
    else:
      raise ValueError('Invalid argument list binarySearch('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.binarySearch(array(int64,ndim=1),int64)\n\tmosek.fusion.CommonTools.binarySearch(array(int32,ndim=1),int32)')
  @staticmethod
  def tripletSort(*args):
    if False: pass
    elif mosek_fusion_CommonTools._match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    elif mosek_fusion_CommonTools._match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
      return mosek_fusion_CommonTools._tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(*args)
    else:
      raise ValueError('Invalid argument list tripletSort('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.CommonTools.tripletSort(array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1),array(array(int32,ndim=1),ndim=1),array(array(int32,ndim=1),ndim=1),array(array(double,ndim=1),ndim=1),int64,int32,int32)')
  def __repr__(self): return 'mosek.fusion.CommonTools'
  @staticmethod
  def _match_resize__3JI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_resize__3JI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _resize_alt__3JI(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_CommonTools._resize__3JI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3JI(_0,_1):
   if (_1==int((_0).shape[0])):
    return (_0)
   else:
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int64))
    if (_1 > int((_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_0,0,_2,0,int((_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_0,0,_2,0,_1)
    return (_2)
  @staticmethod
  def _match_resize__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_resize__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _resize_alt__3II(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_CommonTools._resize__3II(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3II(_0,_1):
   if (_1==int((_0).shape[0])):
    return (_0)
   else:
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    if (_1 > int((_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(_0,0,_2,0,int((_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(_0,0,_2,0,_1)
    return (_2)
  @staticmethod
  def _match_resize__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_resize__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _resize_alt__3DI(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_CommonTools._resize__3DI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _resize__3DI(_0,_1):
   if (_1==int((_0).shape[0])):
    return (_0)
   else:
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.float64))
    if (_1 > int((_0).shape[0])):
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_0,0,_2,0,int((_0).shape[0]))
    else:
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_0,0,_2,0,_1)
    return (_2)
  @staticmethod
  def _match_binarySearch__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_binarySearch__3II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _binarySearch_alt__3II(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_CommonTools._binarySearch__3II(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearch__3II(_0,_1):
   _2=0
   _3=int((_0).shape[0])
   if (_0[_2]==_1):
    return numpy.int32(_2)
   elif (_0[(_3 - 1)]==_1):
    return numpy.int32((_3 - 1))
   while (_2 < (_3 - 1)):
    _4=((_3 - _2) // 2)
    if (_1 < _0[_4]):
     _2 = (_4 + 1)
    elif (_1 > _0[_4]):
     _3 = _4
    else:
     return numpy.int32(_4)
   return numpy.int32((- 1))
  @staticmethod
  def _match_binarySearch__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match_J__(_1))
  @staticmethod
  def _match_alt_binarySearch__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_J__(_1))
  @staticmethod
  def _binarySearch_alt__3JJ(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _1_res = mosek_fusion_CommonTools._binarySearch__3JJ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearch__3JJ(_0,_1):
   _2=mosek.fusion.CommonTools._binarySearchL__3JJ(_0,_1)
   if ((_2 < int((_0).shape[0])) and (_0[_2]==_1)):
    return numpy.int32(_2)
   else:
    return numpy.int32((- 1))
  @staticmethod
  def _match_binarySearchR__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match_J__(_1))
  @staticmethod
  def _match_alt_binarySearchR__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_J__(_1))
  @staticmethod
  def _binarySearchR_alt__3JJ(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _1_res = mosek_fusion_CommonTools._binarySearchR__3JJ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearchR__3JJ(_0,_1):
   _2=0
   _3=int((_0).shape[0])
   if (_0[_2] > _1):
    return numpy.int32(_2)
   _2,_3 = fragments._c_closure_110(_2,_3,_1,_0)
   _2 = numpy.int32(_2) # postprocess
   _3 = numpy.int32(_3) # postprocess
   return numpy.int32(_3)
  @staticmethod
  def _match_binarySearchL__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3J__(_0) and __arg_match_J__(_1))
  @staticmethod
  def _match_alt_binarySearchL__3JJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match_J__(_1))
  @staticmethod
  def _binarySearchL_alt__3JJ(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _1_res = mosek_fusion_CommonTools._binarySearchL__3JJ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _binarySearchL__3JJ(_0,_1):
   _2=0
   _3=int((_0).shape[0])
   if (_1 <= _0[_2]):
    return numpy.int32(_2)
   _2,_3 = fragments._c_closure_111(_2,_3,_1,_0)
   _2 = numpy.int32(_2) # postprocess
   _3 = numpy.int32(_3) # postprocess
   return numpy.int32(_3)
  @staticmethod
  def _match_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_ndIncr__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _ndIncr_alt__3I_3I_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_CommonTools._ndIncr__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _ndIncr__3I_3I_3I(_0,_1,_2):
   fragments._c_closure_112(_1,_2,_0) 
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3J__(_3) and __arg_match__3_3J__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3J__(_3) and __arg_alt_match__3_3J__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3J_3_3J_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int64))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int64))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1_res = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3J_3_3J_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_113(_10,_6,_9,_0,_1) 
   fragments._c_closure_114(_7,_9) 
   fragments._c_closure_115(_10,_8) 
   _11=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int64))
   _12=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int64))
   _13=numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_116(_10,_7,_9,_1,_11,_12,_13,_2) 
   _3[0] = _12
   _4[0] = _11
   _5[0] = _13
  @staticmethod
  def _match_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3I__(_3) and __arg_match__3_3I__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3I__(_3) and __arg_alt_match__3_3I__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _transposeTriplets_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int32))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int32))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1_res = mosek_fusion_CommonTools._transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _transposeTriplets__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_117(_10,_6,_9,_0,_1) 
   fragments._c_closure_118(_7,_9) 
   fragments._c_closure_119(_10,_8) 
   _11=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _12=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _13=numpy.zeros((_6,), dtype=numpy.dtype(numpy.float64))
   fragments._c_closure_120(_10,_7,_9,_1,_11,_12,_13,_2) 
   _3[0] = _12
   _4[0] = _11
   _5[0] = _13
  @staticmethod
  def _match_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3D__(_2) and __arg_match__3_3I__(_3) and __arg_match__3_3I__(_4) and __arg_match__3_3D__(_5) and __arg_match_J__(_6) and __arg_match_I__(_7) and __arg_match_I__(_8))
  @staticmethod
  def _match_alt_tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(*args):
    if len(args) != 9: return False
    _0,_1,_2,_3,_4,_5,_6,_7,_8, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3D__(_2) and __arg_alt_match__3_3I__(_3) and __arg_alt_match__3_3I__(_4) and __arg_alt_match__3_3D__(_5) and __arg_alt_match_J__(_6) and __arg_alt_match_I__(_7) and __arg_alt_match_I__(_8))
  @staticmethod
  def _tripletSort_alt__3I_3I_3D_3_3I_3_3I_3_3DJII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6,_t__7,_t__8):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=_monty.makeJaggedArray(_t__3,(1,1),numpy.dtype(numpy.int32))
   _4=_monty.makeJaggedArray(_t__4,(1,1),numpy.dtype(numpy.int32))
   _5=_monty.makeJaggedArray(_t__5,(1,1),numpy.dtype(numpy.float64))
   _6=numpy.int64(_t__6)
   _7=numpy.int32(_t__7)
   _8=numpy.int32(_t__8)
   _1_res = mosek_fusion_CommonTools._tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__5[:] = _5
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _tripletSort__3I_3I_3D_3_3I_3_3I_3_3DJII(_0,_1,_2,_3,_4,_5,_6,_7,_8):
   _9=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   _10=numpy.zeros(((_8 + 2),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_121(_10,_6,_1) 
   fragments._c_closure_122(_10,_8) 
   fragments._c_closure_123(_9,_10,_6,_1) 
   _11=numpy.zeros(((_7 + 2),), dtype=numpy.dtype(numpy.int64))
   _12=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_124(_6,_11,_0) 
   fragments._c_closure_125(_7,_11) 
   fragments._c_closure_126(_9,_10,_8,_12,_11,_0) 
   _13=1
   _13 = fragments._c_closure_127(_6,_13,_12,_0,_1)
   _13 = numpy.int32(_13) # postprocess
   _14=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
   _15=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
   _16=numpy.zeros((_13,), dtype=numpy.dtype(numpy.float64))
   _17=_12[0]
   _14[0] = _0[_17]
   _15[0] = _1[_17]
   _16[0] = _2[_17]
   _18=1
   _18 = fragments._c_closure_128(_18,_6,_12,_0,_1,_14,_15,_16,_2)
   _18 = numpy.int32(_18) # postprocess
   _3[0] = _14
   _4[0] = _15
   _5[0] = _16
  @staticmethod
  def _match_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_argMSort__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _argMSort_alt__3I_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_CommonTools._argMSort__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argMSort__3I_3I(_0,_1):
   _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   _3=False
   _4=1
   while (_4 < int((_0).shape[0])):
    _3 = (not _3)
    for _5 in range(0,int((_0).shape[0]),(_4 * 2)):
     if _3:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_0,_2,_1,_5,(_5 + _4),(_5 + (2 * _4)))
     else:
      mosek.fusion.CommonTools.__mergeInto__3I_3I_3IIII(_2,_0,_1,_5,(_5 + _4),(_5 + (2 * _4)))
    _4 *= 2
   if _3:
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_2,0,_0,0,int((_0).shape[0]))
  @staticmethod
  def __mergeInto_alt__3I_3I_3IIII(_t__0,_t__1,_t__2,_t__3,_t__4,_t__5):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _1_res = mosek_fusion_CommonTools.__mergeInto__3I_3I_3IIII(_0,_1,_2,_3,_4,_5)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __mergeInto__3I_3I_3IIII(_0,_1,_2,_3,_4,_5):
   _6=(int((_0).shape[0]) if ((_5 > int((_0).shape[0])) ) else _5)
   _7=(_6 if ((_4 > _6) ) else _4)
   if (_7==_6):
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(_0,_3,_1,_3,(_7 - _3))
   else:
    fragments._c_closure_129(_3,_7,_6,_0,_1,_2) 
  @staticmethod
  def _match_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argQsort__3J_3J_3JJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argQsort_alt__3J_3J_3JJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1_res = mosek_fusion_CommonTools._argQsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argQsort__3J_3J_3JJJ(_0,_1,_2,_3,_4):
   if (_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3JJJ(_0,_1,_3,_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3J_3JJJ(_0,_1,_2,_3,_4)
  @staticmethod
  def _match_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match__3J__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2) and __arg_match_J__(_3) and __arg_match_J__(_4))
  @staticmethod
  def _match_alt_argQsort__3J_3I_3IJJ(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match__3J__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match_J__(_3) and __arg_alt_match_J__(_4))
  @staticmethod
  def _argQsort_alt__3J_3I_3IJJ(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.int64(_t__3)
   _4=numpy.int64(_t__4)
   _1_res = mosek_fusion_CommonTools._argQsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _argQsort__3J_3I_3IJJ(_0,_1,_2,_3,_4):
   if (_2 is None):
    mosek.fusion.Utils.Tools._argsort__3J_3IJJ(_0,_1,_3,_4)
   else:
    mosek.fusion.Utils.Tools._argsort__3J_3I_3IJJ(_0,_1,_2,_3,_4)
 return CommonTools
mosek_fusion_CommonTools=__mk_mosek_fusion_CommonTools()
del __mk_mosek_fusion_CommonTools
#BEFORE CLASS
def __mk_mosek_fusion_SolutionStruct():
 class SolutionStruct(object):
  __slots__ = ['accy','accx','accptr','yx','sux','slx','bars','barx','y','suc','slc','xx','xc','dobj','pobj','probstatus','dstatus','pstatus','sol_numbarvar','sol_numaccelm','sol_numacc','sol_numvar','sol_numcon']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
      self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(*args)
    elif self.__match_ctor_IIIII(*args):
      self._ctor_init_IIIII(*args)
    elif self.__match_alt_ctor_IIIII(*args):
      self._ctor_alt_init_IIIII(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.SolutionStruct.ctor(mosek.fusion.SolutionStruct)\n\tmosek.fusion.SolutionStruct.ctor(int32,int32,int32,int32,int32)')
  def resize(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_resize_IIIII(*args):
      return self._resize_IIIII(*args)
    elif mosek_fusion_SolutionStruct._match_alt_resize_IIIII(*args):
      return self._resize_alt_IIIII(*args)
    else:
      raise ValueError('Invalid argument list resize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.resize(int32,int32,int32,int32,int32)')
  def clone(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_clone_(*args):
      return self._clone_(*args)
    elif mosek_fusion_SolutionStruct._match_alt_clone_(*args):
      return self._clone_alt_(*args)
    else:
      raise ValueError('Invalid argument list clone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.clone()')
  def isPrimalAcceptable(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isPrimalAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isPrimalAcceptable(mosek.fusion.AccSolutionStatus)')
  def isDualAcceptable(self,*args):
    if False: pass
    elif mosek_fusion_SolutionStruct._match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args)
    elif mosek_fusion_SolutionStruct._match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
      return self._isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(*args)
    else:
      raise ValueError('Invalid argument list isDualAcceptable('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SolutionStruct.isDualAcceptable(mosek.fusion.AccSolutionStatus)')
  def __repr__(self): return 'mosek.fusion.SolutionStruct'
  @staticmethod
  def _ctor_IIIII(numvar,numcon,numbarvar,numacc,numaccelm):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_IIIII(numvar,numcon,numbarvar,numacc,numaccelm)
    return o
  @staticmethod
  def __match_ctor_IIIII(*args):
    if len(args) != 5: return False
    numvar,numcon,numbarvar,numacc,numaccelm, = args
    return (__arg_match_I__(numvar) and __arg_match_I__(numcon) and __arg_match_I__(numbarvar) and __arg_match_I__(numacc) and __arg_match_I__(numaccelm))
  @staticmethod
  def __match_alt_ctor_IIIII(*args):
    if len(args) != 5: return False
    numvar,numcon,numbarvar,numacc,numaccelm, = args
    return (__arg_alt_match_I__(numvar) and __arg_alt_match_I__(numcon) and __arg_alt_match_I__(numbarvar) and __arg_alt_match_I__(numacc) and __arg_alt_match_I__(numaccelm))
  def _ctor_alt_init_IIIII(self,numvar,numcon,numbarvar,numacc,numaccelm):
    self._ctor_init_IIIII(numpy.int32(numvar),numpy.int32(numcon),numpy.int32(numbarvar),numpy.int32(numacc),numpy.int32(numaccelm))
  def _ctor_init_IIIII(self,numvar,numcon,numbarvar,numacc,numaccelm):
   self.pobj = 0.0
   self.dobj = 0.0
   self.pstatus = mosek.fusion.SolutionStatus.Unknown
   self.dstatus = mosek.fusion.SolutionStatus.Unknown
   self.probstatus = mosek.fusion.ProblemStatus.Unknown
   self.sol_numvar = numvar
   self.sol_numcon = numcon
   self.sol_numbarvar = numbarvar
   self.sol_numacc = numacc
   self.sol_numaccelm = numaccelm
   self.slx = None
   self.sux = None
   self.xx = None
   self.yx = None
   self.slc = None
   self.suc = None
   self.y = None
   self.xc = None
   self.barx = None
   self.bars = None
   self.accx = None
   self.accy = None
   self.accptr = None
   if (numvar > 0):
    self.slx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.sux = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.xx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
    self.yx = numpy.zeros((numvar,), dtype=numpy.dtype(numpy.float64))
   if (numbarvar > 0):
    self.barx = numpy.zeros((numbarvar,), dtype=numpy.dtype(numpy.float64))
    self.bars = numpy.zeros((numbarvar,), dtype=numpy.dtype(numpy.float64))
   if (numcon > 0):
    self.slc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.suc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.y = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
    self.xc = numpy.zeros((numcon,), dtype=numpy.dtype(numpy.float64))
   if (numacc > 0):
    self.accx = numpy.zeros((numaccelm,), dtype=numpy.dtype(numpy.float64))
    self.accy = numpy.zeros((numaccelm,), dtype=numpy.dtype(numpy.float64))
    self.accptr = numpy.zeros(((numacc + 1),), dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_Lmosek_4fusion_4SolutionStruct_2(that):
    o = SolutionStruct.__new__(SolutionStruct)
    o._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SolutionStruct_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_alt_match_Lmosek_4fusion_4SolutionStruct_2__(that))
  def _ctor_alt_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
    self._ctor_init_Lmosek_4fusion_4SolutionStruct_2(that)
  def _ctor_init_Lmosek_4fusion_4SolutionStruct_2(self,that):
   self.sol_numcon = (that.sol_numcon)
   self.sol_numvar = (that.sol_numvar)
   self.sol_numbarvar = (that.sol_numbarvar)
   self.sol_numacc = (that.sol_numacc)
   self.sol_numaccelm = (that.sol_numaccelm)
   self.pstatus = (that.pstatus)
   self.dstatus = (that.dstatus)
   self.probstatus = (that.probstatus)
   self.pobj = (that.pobj)
   self.dobj = (that.dobj)
   self.xc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xc)) if (((that.xc) is not None) ) else None)
   self.xx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.xx)) if (((that.xx) is not None) ) else None)
   self.yx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.yx)) if (((that.yx) is not None) ) else None)
   self.slc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slc)) if (((that.slc) is not None) ) else None)
   self.suc = (mosek.fusion.Utils.Tools._arraycopy__3D((that.suc)) if (((that.suc) is not None) ) else None)
   self.y = (mosek.fusion.Utils.Tools._arraycopy__3D((that.y)) if (((that.y) is not None) ) else None)
   self.barx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.barx)) if (((that.barx) is not None) ) else None)
   self.bars = (mosek.fusion.Utils.Tools._arraycopy__3D((that.bars)) if (((that.bars) is not None) ) else None)
   self.slx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.slx)) if (((that.slx) is not None) ) else None)
   self.sux = (mosek.fusion.Utils.Tools._arraycopy__3D((that.sux)) if (((that.sux) is not None) ) else None)
   self.accptr = (mosek.fusion.Utils.Tools._arraycopy__3I((that.accptr)) if (((that.accptr) is not None) ) else None)
   self.accx = (mosek.fusion.Utils.Tools._arraycopy__3D((that.accx)) if (((that.accx) is not None) ) else None)
   self.accy = (mosek.fusion.Utils.Tools._arraycopy__3D((that.accy)) if (((that.accy) is not None) ) else None)
  @staticmethod
  def _match_clone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_clone_(*args):
    if len(args) != 0: return False
    return True
  def _clone_alt_(self,):
    return self._clone_()
  def _clone_(self,):
   return (mosek_fusion_SolutionStruct._ctor_Lmosek_4fusion_4SolutionStruct_2(self))
  @staticmethod
  def _match_resize_IIIII(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3) and __arg_match_I__(_4))
  @staticmethod
  def _match_alt_resize_IIIII(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match_I__(_4))
  def _resize_alt_IIIII(self,_t__0,_t__1,_t__2,_t__3,_t__4):
    return self._resize_IIIII(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2),numpy.int32(__3),numpy.int32(__4))
  def _resize_IIIII(self,_0,_1,_2,_3,_4):
   if (_3 <= 0):
    self.sol_numacc = 0
   elif (_3 <= (int((self.accptr).shape[0]) - 1)):
    self.sol_numacc = _3
   else:
    _5=((int((self.accptr).shape[0]) - 1) * 2)
    if (_5 < _3):
     _5 = _3
    _6=numpy.zeros(((_5 + 1),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.accptr,0,_6,0,(_3 + 1))
    self.accptr = _6
    self.sol_numacc = _3
   if (_4 <= 0):
    self.sol_numaccelm = 0
   elif (_4 > int((self.accx).shape[0])):
    self.sol_numaccelm = _4
   else:
    _7=(int((self.accx).shape[0]) * 2)
    if (_7 < _4):
     _7 = _4
    _8=numpy.zeros((_7,), dtype=numpy.dtype(numpy.float64))
    _9=numpy.zeros((_7,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.accx,0,_8,0,_4)
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.accy,0,_9,0,_4)
    self.accx = _8
    self.accy = _9
    self.sol_numaccelm = _4
   if (_2 < 0):
    pass
   elif (_2 <= self.sol_numbarvar):
    self.sol_numbarvar = _2
   elif (_2 <= int((self.barx).shape[0])):
    pass
   else:
    if ((self.sol_numbarvar * 2) > (_2 + 100)):
     _10 = (self.sol_numbarvar * 2)
    else:
     _10 = (_2 + 100)
    self.barx = mosek.fusion.CommonTools._resize__3DI(self.barx,_10)
    self.bars = mosek.fusion.CommonTools._resize__3DI(self.bars,_10)
    self.sol_numbarvar = _10
   if (_0 < 0):
    pass
   elif (_0 <= self.sol_numvar):
    self.sol_numvar = _0
   elif (_0 <= int((self.xx).shape[0])):
    self.sol_numvar = fragments._c_closure_130(_0,self.slx,self.sol_numvar,self.sux,self.xx,self.yx)
    self.sol_numvar = numpy.int32(self.sol_numvar) # postprocess
   else:
    if ((self.sol_numvar * 2) > (_0 + 100)):
     _11 = (self.sol_numvar * 2)
    else:
     _11 = (_0 + 100)
    _12=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slx,0,_12,0,int((self.slx).shape[0]))
    self.slx = _12
    _13=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.sux,0,_13,0,int((self.sux).shape[0]))
    self.sux = _13
    _14=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xx,0,_14,0,int((self.xx).shape[0]))
    self.xx = _14
    _15=numpy.zeros((_11,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.yx,0,_15,0,int((self.yx).shape[0]))
    self.yx = _15
    fragments._c_closure_131(_0,self.slx,self.sol_numvar,self.sux,self.xx) 
    self.sol_numvar = _0
   if (_1 < 0):
    pass
   elif (_1 <= self.sol_numcon):
    self.sol_numcon = _1
   elif (_1 <= int((self.xx).shape[0])):
    self.sol_numcon = fragments._c_closure_132(_1,self.slc,self.sol_numcon,self.suc,self.xc,self.y)
    self.sol_numcon = numpy.int32(self.sol_numcon) # postprocess
   else:
    if ((self.sol_numcon * 2) > (_1 + 100)):
     _16 = (self.sol_numcon * 2)
    else:
     _16 = (_1 + 100)
    _17=numpy.zeros((_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.slc,0,_17,0,int((self.slc).shape[0]))
    self.slc = _17
    _18=numpy.zeros((_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.suc,0,_18,0,int((self.suc).shape[0]))
    self.suc = _18
    _19=numpy.zeros((_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.xc,0,_19,0,int((self.xc).shape[0]))
    self.xc = _19
    _20=numpy.zeros((_16,), dtype=numpy.dtype(numpy.float64))
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.y,0,_20,0,int((self.y).shape[0]))
    self.y = _20
    fragments._c_closure_133(_1,self.slc,self.sol_numcon,self.suc,self.xc,self.y) 
    self.sol_numcon = _1
  @staticmethod
  def _match_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _isDualAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _isDualAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.dstatus,_0))
  @staticmethod
  def _match_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  @staticmethod
  def _match_alt_isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Emosek_4fusion_4AccSolutionStatus_2__(_0))
  def _isPrimalAcceptable_alt_Emosek_4fusion_4AccSolutionStatus_2(self,_t__0):
    return self._isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(__0)
  def _isPrimalAcceptable_Emosek_4fusion_4AccSolutionStatus_2(self,_0):
   return (self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self.pstatus,_0))
  def __isAcceptable_alt_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_t__0,_t__1):
    return self.__isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(__0,__1)
  def __isAcceptable_Emosek_4fusion_4SolutionStatus_2Emosek_4fusion_4AccSolutionStatus_2(self,_0,_1):
   if (_1==mosek.fusion.AccSolutionStatus.Anything):
    return (True)
   elif (_1==mosek.fusion.AccSolutionStatus.Optimal):
    return ((_0==mosek.fusion.SolutionStatus.Optimal))
   elif (_1==mosek.fusion.AccSolutionStatus.Feasible):
    return (((_0==mosek.fusion.SolutionStatus.Optimal) or (_0==mosek.fusion.SolutionStatus.Feasible)))
   elif (_1==mosek.fusion.AccSolutionStatus.Certificate):
    return ((_0==mosek.fusion.SolutionStatus.Certificate))
   return (False)
 return SolutionStruct
mosek_fusion_SolutionStruct=__mk_mosek_fusion_SolutionStruct()
del __mk_mosek_fusion_SolutionStruct
#BEFORE CLASS
def __mk_mosek_fusion_RowBlockManager():
 class RowBlockManager(object):
  __slots__ = ['varidx_used','code_used','cconst','code','first_free_codeitem','param_code_sizes','param_varidx','first_free_entry','row_code_ptr','row_param_ptre','row_param_ptrb','blocks']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_(*args):
      self._ctor_init_(*args)
    elif self.__match_alt_ctor_(*args):
      self._ctor_alt_init_(*args)
    elif self.__match_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
      self._ctor_init_Lmosek_4fusion_4RowBlockManager_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4RowBlockManager_2(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.RowBlockManager.ctor()\n\tmosek.fusion.RowBlockManager.ctor(mosek.fusion.RowBlockManager)')
  def blocksize(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_blocksize_I(*args):
      return self._blocksize_I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_blocksize_I(*args):
      return self._blocksize_alt_I(*args)
    else:
      raise ValueError('Invalid argument list blocksize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.blocksize(int32)')
  def num_parameterized(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_num_1parameterized_(*args):
      return self._num_1parameterized_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_num_1parameterized_(*args):
      return self._num_1parameterized_alt_(*args)
    else:
      raise ValueError('Invalid argument list num_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.num_parameterized()')
  def release(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_release_I_3I(*args):
      return self._release_I_3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_release_I_3I(*args):
      return self._release_alt_I_3I(*args)
    else:
      raise ValueError('Invalid argument list release('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.release(int32,array(int32,ndim=1))')
  def block_capacity(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_block_1capacity_(*args):
      return self._block_1capacity_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_block_1capacity_(*args):
      return self._block_1capacity_alt_(*args)
    else:
      raise ValueError('Invalid argument list block_capacity('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.block_capacity()')
  def is_parameterized(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_is_1parameterized_(*args):
      return self._is_1parameterized_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_is_1parameterized_(*args):
      return self._is_1parameterized_alt_(*args)
    else:
      raise ValueError('Invalid argument list is_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.is_parameterized()')
  def get(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_get_I_3II(*args):
      return self._get_I_3II(*args)
    elif mosek_fusion_RowBlockManager._match_alt_get_I_3II(*args):
      return self._get_alt_I_3II(*args)
    else:
      raise ValueError('Invalid argument list get('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.get(int32,array(int32,ndim=1),int32)')
  def row_is_parameterized(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_row_1is_1parameterized_I(*args):
      return self._row_1is_1parameterized_I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_row_1is_1parameterized_I(*args):
      return self._row_1is_1parameterized_alt_I(*args)
    else:
      raise ValueError('Invalid argument list row_is_parameterized('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.row_is_parameterized(int32)')
  def clear_row_code(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_clear_1row_1code__3I(*args):
      return self._clear_1row_1code__3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_clear_1row_1code__3I(*args):
      return self._clear_1row_1code_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list clear_row_code('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.clear_row_code(array(int32,ndim=1))')
  def capacity(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_capacity_(*args):
      return self._capacity_(*args)
    elif mosek_fusion_RowBlockManager._match_alt_capacity_(*args):
      return self._capacity_alt_(*args)
    else:
      raise ValueError('Invalid argument list capacity('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.capacity()')
  def evaluate(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
      return self._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args)
    elif mosek_fusion_RowBlockManager._match_alt_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
      return self._evaluate_alt_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args)
    else:
      raise ValueError('Invalid argument list evaluate('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.evaluate(mosek.fusion.WorkStack,array(double,ndim=1),array(int32,ndim=1),array(int32,ndim=1),array(double,ndim=1))')
  def replace_row_code(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
      return self._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args)
    elif mosek_fusion_RowBlockManager._match_alt_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
      return self._replace_1row_1code_alt_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args)
    else:
      raise ValueError('Invalid argument list replace_row_code('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.replace_row_code(mosek.fusion.WorkStack,array(int32,ndim=1),int32,int32,int32,int32,int32)')
  def allocate(self,*args):
    if False: pass
    elif mosek_fusion_RowBlockManager._match_allocate__3I(*args):
      return self._allocate__3I(*args)
    elif mosek_fusion_RowBlockManager._match_alt_allocate__3I(*args):
      return self._allocate_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list allocate('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RowBlockManager.allocate(array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.RowBlockManager'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RowBlockManager_2(that):
    o = RowBlockManager.__new__(RowBlockManager)
    o._ctor_init_Lmosek_4fusion_4RowBlockManager_2(that)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_match_Lmosek_4fusion_4RowBlockManager_2__(that))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RowBlockManager_2(*args):
    if len(args) != 1: return False
    that, = args
    return (__arg_alt_match_Lmosek_4fusion_4RowBlockManager_2__(that))
  def _ctor_alt_init_Lmosek_4fusion_4RowBlockManager_2(self,that):
    self._ctor_init_Lmosek_4fusion_4RowBlockManager_2(that)
  def _ctor_init_Lmosek_4fusion_4RowBlockManager_2(self,that):
   self.blocks = mosek_fusion_LinkedBlocks._ctor_Lmosek_4fusion_4LinkedBlocks_2((that.blocks))
   self.row_param_ptrb = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_param_ptrb)) if (((that.row_param_ptrb) is not None) ) else None)
   self.row_param_ptre = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_param_ptre)) if (((that.row_param_ptre) is not None) ) else None)
   self.row_code_ptr = (mosek.fusion.Utils.Tools._arraycopy__3I((that.row_code_ptr)) if (((that.row_code_ptr) is not None) ) else None)
   self.first_free_entry = (that.first_free_entry)
   self.param_varidx = (mosek.fusion.Utils.Tools._arraycopy__3J((that.param_varidx)) if (((that.param_varidx) is not None) ) else None)
   self.param_code_sizes = (mosek.fusion.Utils.Tools._arraycopy__3I((that.param_code_sizes)) if (((that.param_code_sizes) is not None) ) else None)
   self.first_free_codeitem = (that.first_free_codeitem)
   self.code = (mosek.fusion.Utils.Tools._arraycopy__3I((that.code)) if (((that.code) is not None) ) else None)
   self.cconst = (mosek.fusion.Utils.Tools._arraycopy__3D((that.cconst)) if (((that.cconst) is not None) ) else None)
   self.code_used = (that.code_used)
   self.varidx_used = (that.varidx_used)
  @staticmethod
  def _ctor_():
    o = RowBlockManager.__new__(RowBlockManager)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   self.blocks = mosek_fusion_LinkedBlocks._ctor_()
   self.row_param_ptrb = None
   self.row_param_ptre = None
   self.row_code_ptr = None
   self.first_free_entry = 0
   self.param_varidx = None
   self.param_code_sizes = None
   self.first_free_codeitem = 0
   self.code = None
   self.cconst = None
   self.code_used = 0
   self.varidx_used = 0
  @staticmethod
  def _match_num_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_num_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  def _num_1parameterized_alt_(self,):
    return self._num_1parameterized_()
  def _num_1parameterized_(self,):
   return numpy.int32(self.varidx_used)
  @staticmethod
  def _match_is_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_is_1parameterized_(*args):
    if len(args) != 0: return False
    return True
  def _is_1parameterized_alt_(self,):
    return self._is_1parameterized_()
  def _is_1parameterized_(self,):
   return ((self.code_used > 0))
  @staticmethod
  def _match_blocksize_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_blocksize_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _blocksize_alt_I(self,_t__0):
    return self._blocksize_I(numpy.int32(__0))
  def _blocksize_I(self,_0):
   return numpy.int32(self.blocks._blocksize_I(_0))
  @staticmethod
  def _match_block_1capacity_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_block_1capacity_(*args):
    if len(args) != 0: return False
    return True
  def _block_1capacity_alt_(self,):
    return self._block_1capacity_()
  def _block_1capacity_(self,):
   return numpy.int32(self.blocks._block_1capacity_())
  @staticmethod
  def _match_capacity_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_capacity_(*args):
    if len(args) != 0: return False
    return True
  def _capacity_alt_(self,):
    return self._capacity_()
  def _capacity_(self,):
   return numpy.int32(self.blocks._capacity_())
  @staticmethod
  def _match_get_I_3II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_get_I_3II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_I__(_2))
  def _get_alt_I_3II(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int32(_t__2)
   _1_res = self._get_I_3II(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _get_I_3II(self,_0,_1,_2):
   self.blocks._get_I_3II(_0,_1,_2)
  @staticmethod
  def _match_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_match__3D__(_1) and __arg_match__3I__(_2) and __arg_match__3I__(_3) and __arg_match__3D__(_4))
  @staticmethod
  def _match_alt_evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(*args):
    if len(args) != 5: return False
    _0,_1,_2,_3,_4, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match__3I__(_2) and __arg_alt_match__3I__(_3) and __arg_alt_match__3D__(_4))
  def _evaluate_alt_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self,_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.float64))
   _1_res = self._evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _evaluate_Lmosek_4fusion_4WorkStack_2_3D_3I_3I_3D(self,_0,_1,_2,_3,_4):
   _5=_0._allocf64_I(self.code_used)
   _6=0
   _7=(_0.f64)
   _8=0
   _8,_6 = fragments._c_closure_134(self.cconst,self.code,_8,self.param_code_sizes,_1,self.param_varidx,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre,_5,_6,_2,_3,_4,_7)
   _8 = numpy.int32(_8) # postprocess
   _6 = numpy.int32(_6) # postprocess
   _0._popf64_I(self.code_used)
  @staticmethod
  def _match_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
    if len(args) != 7: return False
    _0,_1,_2,_3,_4,_5,_6, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_match__3I__(_1) and __arg_match_I__(_2) and __arg_match_I__(_3) and __arg_match_I__(_4) and __arg_match_I__(_5) and __arg_match_I__(_6))
  @staticmethod
  def _match_alt_replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(*args):
    if len(args) != 7: return False
    _0,_1,_2,_3,_4,_5,_6, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match_I__(_3) and __arg_alt_match_I__(_4) and __arg_alt_match_I__(_5) and __arg_alt_match_I__(_6))
  def _replace_1row_1code_alt_Lmosek_4fusion_4WorkStack_2_3IIIIII(self,_t__0,_t__1,_t__2,_t__3,_t__4,_t__5,_t__6):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int32(_t__2)
   _3=numpy.int32(_t__3)
   _4=numpy.int32(_t__4)
   _5=numpy.int32(_t__5)
   _6=numpy.int32(_t__6)
   _1_res = self._replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(_0,_1,_2,_3,_4,_5,_6)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _replace_1row_1code_Lmosek_4fusion_4WorkStack_2_3IIIIII(self,_0,_1,_2,_3,_4,_5,_6):
   _7=int((_1).shape[0])
   _8=(_0.i32)
   _9=(_0.i64)
   _10=(_0.f64)
   _11=True
   _12=0
   _13=0
   _13,_12 = fragments._c_closure_135(_5,_4,_7,_13,_12,_2,_8)
   _13 = numpy.int32(_13) # postprocess
   _12 = numpy.int32(_12) # postprocess
   self._clear_1row_1code__3I(_1)
   self.__ensure_1code_1cap_II(_13,_12)
   self.code_used += _12
   self.varidx_used += _13
   if (self.first_free_codeitem > (self.code_used * 2)):
    self.__compress_()
   self.first_free_codeitem,self.first_free_entry = fragments._c_closure_136(_5,_4,self.first_free_codeitem,self.first_free_entry,_1,_7,_2,_8,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre)
   self.first_free_codeitem = numpy.int32(self.first_free_codeitem) # postprocess
   self.first_free_entry = numpy.int32(self.first_free_entry) # postprocess
   _11 = fragments._c_closure_137(self.cconst,_6,self.code,_5,_4,_1,_7,_3,_11,self.param_code_sizes,self.param_varidx,_2,_10,_8,_9,self.row_code_ptr,self.row_param_ptrb)
   if (not _11):
    raise mosek_fusion_ParameterError._ctor_S("Expression contains parameterized SDP non-zero")
  @staticmethod
  def _match_clear_1row_1code__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_clear_1row_1code__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _clear_1row_1code_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._clear_1row_1code__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _clear_1row_1code__3I(self,_0):
   self.code_used,self.varidx_used = fragments._c_closure_138(self.code_used,_0,self.param_code_sizes,self.row_param_ptrb,self.row_param_ptre,self.varidx_used)
   self.code_used = numpy.int32(self.code_used) # postprocess
   self.varidx_used = numpy.int32(self.varidx_used) # postprocess
  def __compress_alt_(self,):
    return self.__compress_()
  def __compress_(self,):
   _0=numpy.zeros((self.code_used,), dtype=numpy.dtype(numpy.int32))
   _1=numpy.zeros((self.code_used,), dtype=numpy.dtype(numpy.float64))
   _2=numpy.zeros((self.first_free_entry,), dtype=numpy.dtype(numpy.int64))
   _3=numpy.zeros((self.first_free_entry,), dtype=numpy.dtype(numpy.int32))
   _4=0
   _5=0
   for _6 in range(0,int((self.row_param_ptrb).shape[0])):
    _7=0
    _8=(self.row_param_ptre[_6] - self.row_param_ptrb[_6])
    mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.param_varidx,self.row_param_ptrb[_6],_2,_4,_8)
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.param_code_sizes,self.row_param_ptrb[_6],_3,_4,_8)
    _7 = fragments._c_closure_139(_7,_6,self.param_code_sizes,self.row_param_ptrb,self.row_param_ptre)
    _7 = numpy.int32(_7) # postprocess
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.code,self.row_code_ptr[_6],_0,_5,_7)
    mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.cconst,self.row_code_ptr[_6],_1,_5,_7)
    self.row_param_ptrb[_6] = _4
    self.row_param_ptre[_6] = (_4 + _8)
    self.row_code_ptr[_6] = _5
    _5 += _7
    _4 += _8
   mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(_2,0,self.param_varidx,0,_4)
   mosek.fusion.Utils.Tools._arraycopy__3II_3III(_3,0,self.param_code_sizes,0,_4)
   mosek.fusion.Utils.Tools._arraycopy__3II_3III(_0,0,self.code,0,_5)
   mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(_1,0,self.cconst,0,_5)
   self.first_free_codeitem = _5
   self.first_free_entry = _4
  def __ensure_1code_1cap_alt_II(self,_t__0,_t__1):
    return self.__ensure_1code_1cap_II(numpy.int32(__0),numpy.int32(__1))
  def __ensure_1code_1cap_II(self,_0,_1):
   if (self.row_code_ptr is None):
    _2=128
    _2 = fragments._c_closure_140(_2,_0)
    _2 = numpy.int32(_2) # postprocess
    _3=128
    _3 = fragments._c_closure_141(_1,_3)
    _3 = numpy.int32(_3) # postprocess
    self.row_param_ptrb = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.row_param_ptre = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.row_code_ptr = numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    self.param_varidx = numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    self.param_code_sizes = numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    self.code = numpy.zeros((_3,), dtype=numpy.dtype(numpy.int32))
    self.cconst = numpy.zeros((_3,), dtype=numpy.dtype(numpy.float64))
   else:
    if (_0 > (int((self.param_varidx).shape[0]) - self.first_free_entry)):
     _4=int((self.param_varidx).shape[0])
     _4 = fragments._c_closure_142(self.first_free_entry,_4,_0)
     _4 = numpy.int32(_4) # postprocess
     _5=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
     _6=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int64))
     _7=numpy.zeros((_4,), dtype=numpy.dtype(numpy.int32))
     mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.param_varidx,0,_6,0,self.first_free_entry)
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.param_code_sizes,0,_7,0,self.first_free_entry)
     self.param_varidx = _6
     self.param_code_sizes = _7
    if (_1 > (int((self.code).shape[0]) - self.first_free_codeitem)):
     _8=int((self.code).shape[0])
     _8 = fragments._c_closure_143(_1,self.first_free_codeitem,_8)
     _8 = numpy.int32(_8) # postprocess
     _9=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
     mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.code,0,_9,0,self.first_free_codeitem)
     _10=numpy.zeros((_8,), dtype=numpy.dtype(numpy.float64))
     mosek.fusion.Utils.Tools._arraycopy__3DI_3DII(self.cconst,0,_10,0,self.first_free_codeitem)
     self.code = _9
     self.cconst = _10
  @staticmethod
  def _match_release_I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_release_I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3I__(_1))
  def _release_alt_I_3I(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._release_I_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _release_I_3I(self,_0,_1):
   _2=self.blocks._blocksize_I(_0)
   self.blocks._get_I_3II(_0,_1,0)
   self.blocks._free_I(_0)
   self.code_used = fragments._c_closure_144(self.code_used,_1,_2,self.row_code_ptr,self.row_param_ptrb,self.row_param_ptre)
   self.code_used = numpy.int32(self.code_used) # postprocess
  @staticmethod
  def _match_allocate__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_allocate__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _allocate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._allocate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _allocate__3I(self,_0):
   _1=int((_0).shape[0])
   _2=self.blocks._alloc_I(_1)
   self.blocks._get_I_3II(_2,_0,0)
   if ((self.row_code_ptr is not None) and (self.blocks._capacity_() > int((self.row_param_ptrb).shape[0]))):
    _3=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_param_ptrb,0,_3,0,int((self.row_param_ptrb).shape[0]))
    _4=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_param_ptre,0,_4,0,int((self.row_param_ptre).shape[0]))
    _5=numpy.zeros((self.blocks._capacity_(),), dtype=numpy.dtype(numpy.int32))
    mosek.fusion.Utils.Tools._arraycopy__3II_3III(self.row_code_ptr,0,_5,0,int((self.row_code_ptr).shape[0]))
    self.row_param_ptrb = _3
    self.row_param_ptre = _4
    self.row_code_ptr = _5
   return numpy.int32(_2)
  @staticmethod
  def _match_row_1is_1parameterized_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_row_1is_1parameterized_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _row_1is_1parameterized_alt_I(self,_t__0):
    return self._row_1is_1parameterized_I(numpy.int32(__0))
  def _row_1is_1parameterized_I(self,_0):
   return (((self.row_param_ptrb is not None) and (self.row_param_ptrb[_0] < self.row_param_ptre[_0])))
 return RowBlockManager
mosek_fusion_RowBlockManager=__mk_mosek_fusion_RowBlockManager()
del __mk_mosek_fusion_RowBlockManager
#BEFORE CLASS
def __mk_mosek_fusion_BaseVariable():
 class BaseVariable(mosek_fusion_Variable,object):
  __slots__ = ['_BaseVariable__sparsity','_BaseVariable__basevar_nativeidxs','_BaseVariable__model','_BaseVariable__shape']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
      self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.BaseVariable.ctor(mosek.fusion.Model,array(int32,ndim=1),array(int64,ndim=1),array(int64,ndim=1))')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_BaseVariable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.transpose()')
  def diag(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.diag()\n\tmosek.fusion.BaseVariable.diag(int32)')
  def makeInteger(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeInteger_(*args):
      return self._makeInteger_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeInteger_(*args):
      return self._makeInteger_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeInteger('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeInteger()')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getModel()')
  def getSize(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getSize()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_continuous()')
  def makeContinuous(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_makeContinuous_(*args):
      return self._makeContinuous_(*args)
    elif mosek_fusion_BaseVariable._match_alt_makeContinuous_(*args):
      return self._makeContinuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list makeContinuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.makeContinuous()')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getShape()')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_BaseVariable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.index(int32)\n\tmosek.fusion.BaseVariable.index(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.index(int32,int32)\n\tmosek.fusion.BaseVariable.index(int32,int32,int32)')
  def reshape(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_reshape__3I(*args):
      return self._reshape__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape__3I(*args):
      return self._reshape_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_reshape_I(*args):
      return self._reshape_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_I(*args):
      return self._reshape_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_reshape_II(*args):
      return self._reshape_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_II(*args):
      return self._reshape_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_reshape_III(*args):
      return self._reshape_III(*args)
    elif mosek_fusion_BaseVariable._match_alt_reshape_III(*args):
      return self._reshape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.reshape(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.reshape(int32)\n\tmosek.fusion.BaseVariable.reshape(int32,int32)\n\tmosek.fusion.BaseVariable.reshape(int32,int32,int32)')
  def getDim(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getDim_I(*args):
      return self._getDim_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_getDim_I(*args):
      return self._getDim_alt_I(*args)
    else:
      raise ValueError('Invalid argument list getDim('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getDim(int32)')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_BaseVariable._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.level()')
  def remove(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_BaseVariable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.remove()')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_BaseVariable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_BaseVariable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.BaseVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.values(int32,array(double,ndim=1),bool)')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BaseVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.slice(int32,int32)\n\tmosek.fusion.BaseVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_BaseVariable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.set_values(array(double,ndim=1),bool)')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_BaseVariable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=2))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BaseVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def antidiag(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_BaseVariable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.antidiag()\n\tmosek.fusion.BaseVariable.antidiag(int32)')
  def setLevel(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_setLevel__3D(*args):
      return self._setLevel__3D(*args)
    elif mosek_fusion_BaseVariable._match_alt_setLevel__3D(*args):
      return self._setLevel_alt__3D(*args)
    else:
      raise ValueError('Invalid argument list setLevel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.setLevel(array(double,ndim=1))')
  def getND(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_BaseVariable._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.getND()')
  def tril(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_tril_(*args):
      return self._tril_(*args)
    elif mosek_fusion_BaseVariable._match_alt_tril_(*args):
      return self._tril_alt_(*args)
    elif mosek_fusion_BaseVariable._match_tril_II(*args):
      return self._tril_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_tril_II(*args):
      return self._tril_alt_II(*args)
    else:
      raise ValueError('Invalid argument list tril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.tril()\n\tmosek.fusion.BaseVariable.tril(int32,int32)')
  def fromTril(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_fromTril_I(*args):
      return self._fromTril_I(*args)
    elif mosek_fusion_BaseVariable._match_alt_fromTril_I(*args):
      return self._fromTril_alt_I(*args)
    elif mosek_fusion_BaseVariable._match_fromTril_II(*args):
      return self._fromTril_II(*args)
    elif mosek_fusion_BaseVariable._match_alt_fromTril_II(*args):
      return self._fromTril_alt_II(*args)
    else:
      raise ValueError('Invalid argument list fromTril('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.fromTril(int32)\n\tmosek.fusion.BaseVariable.fromTril(int32,int32)')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_BaseVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.toString()')
  def asExpr(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_asExpr_(*args):
      return self._asExpr_(*args)
    elif mosek_fusion_BaseVariable._match_alt_asExpr_(*args):
      return self._asExpr_alt_(*args)
    else:
      raise ValueError('Invalid argument list asExpr('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.asExpr()')
  def eval(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    elif mosek_fusion_BaseVariable._match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
      return self._eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args)
    else:
      raise ValueError('Invalid argument list eval('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.eval(mosek.fusion.WorkStack,mosek.fusion.WorkStack,mosek.fusion.WorkStack)')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_BaseVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.make_integer()')
  def numInst(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_BaseVariable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.numInst()')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_BaseVariable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BaseVariable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BaseVariable.dual()')
  def __repr__(self): return 'mosek.fusion.BaseVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4BaseVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   self.__model = m
   self.__shape = (v.__shape)
   self.__sparsity = (v.__sparsity)
   self.__basevar_nativeidxs = (v.__basevar_nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,basevar_nativeidxs):
    o = BaseVariable.__new__(BaseVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,basevar_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,basevar_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(basevar_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,basevar_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(basevar_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,basevar_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(basevar_nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,basevar_nativeidxs):
   self.__model = m
   (self.__shape) = shape
   (self.__sparsity) = sparsity
   (self.__basevar_nativeidxs) = basevar_nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("Variable((")
   if (int((self.__shape).shape[0]) > 0):
    _0._a_I(self.__shape[0])
    for _1 in range(1,int((self.__shape).shape[0])):
     _0._a_S(",")._a_I(self.__shape[_1])
   _0._a_S("))")
   return (_0._toString_())
  @staticmethod
  def _match_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_1) and __arg_match_Lmosek_4fusion_4WorkStack_2__(_2))
  @staticmethod
  def _match_alt_eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_0) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_1) and __arg_alt_match_Lmosek_4fusion_4WorkStack_2__(_2))
  def _eval_alt_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_t__0,_t__1,_t__2):
    return self._eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(_0,_1,_2)
  def _eval_Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2Lmosek_4fusion_4WorkStack_2(self,_0,_1,_2):
   _3=int((self.__basevar_nativeidxs).shape[0])
   _4=_3
   _5=int((self.__shape).shape[0])
   _6=(self.__sparsity is not None)
   _0._alloc_1expr_IIIZ(_5,_4,_3,_6)
   _7=(_0.ptr_base)
   _8=(_0.nidxs_base)
   _9=(_0.sp_base)
   _10=(_0.cof_base)
   _11=(_0.shape_base)
   _12=(_0.i32)
   _13=(_0.i64)
   _14=(_0.f64)
   fragments._c_closure_145(_5,_12,self.__shape,_11) 
   fragments._c_closure_146(self.__basevar_nativeidxs,_10,_6,_8,_3,_7,_14,_12,_13,_9,self.__sparsity) 
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   raise mosek_fusion_DeletionError._ctor_S("Only original variables can be removed")
  @staticmethod
  def _match_fromTril_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_fromTril_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _fromTril_alt_II(self,_t__0,_t__1):
    return self._fromTril_II(numpy.int32(__0),numpy.int32(__1))
  def _fromTril_II(self,_0,_1):
   if ((_0 < 0) or (_0 >= int((self.__shape).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid dimension")
   elif (self.__shape[_0]!=((_1 * (_1 + 1)) // 2)):
    raise mosek_fusion_DimensionError._ctor_S("Invalid shape for operation")
   _2=1
   _2 = fragments._c_closure_147(_2,_0,self.__shape)
   _2 = numpy.int32(_2) # postprocess
   _3=self.__shape[_0]
   _4=1
   _4 = fragments._c_closure_148(_4,_0,self.__shape)
   _4 = numpy.int32(_4) # postprocess
   _5=numpy.zeros(((int((self.__shape).shape[0]) + 1),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_149(_0,_5,self.__shape) 
   _5[_0] = _1
   _5[(_0 + 1)] = _1
   fragments._c_closure_150(_0,_5,self.__shape) 
   if (self.__sparsity is None):
    _6=numpy.zeros(((((_2 * _1) * _1) * _4),), dtype=numpy.dtype(numpy.int64))
    _7=0
    _7 = fragments._c_closure_151(self.__basevar_nativeidxs,_1,_2,_3,_4,_6,_7)
    _7 = numpy.int32(_7) # postprocess
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_5,None,_6))
   else:
    _8=0
    for _9 in range(0,int((self.__sparsity).shape[0])):
     _10=((self.__sparsity[_9] // _4) % _3)
     _11=numpy.int32((((- 1) + mosek.fusion.Utils.Tools._sqrt_D(((1 + (2 * _10)) * (1 + (2 * _10))))) / 4))
     _12=(self.__sparsity[_9] - ((_11 * (_11 + 1)) // 2))
     if (_11==_12):
      _8 += 1
     else:
      _8 += 2
    _13=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
    _14=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
    _15=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_152(_8,_15) 
    _16=0
    for _17 in range(0,int((self.__sparsity).shape[0])):
     _18=(self.__sparsity[_17] // (_3 * _4))
     _19=((self.__sparsity[_17] // _4) % _3)
     _20=(self.__sparsity[_17] % _4)
     _21=numpy.int32((((- 1) + mosek.fusion.Utils.Tools._sqrt_D(((1 + (2 * _19)) * (1 + (2 * _19))))) / 4))
     _22=(self.__sparsity[_17] - ((_21 * (_21 + 1)) // 2))
     if (_21==_22):
      _13[_16] = self.__basevar_nativeidxs[_17]
      _14[_16] = (((((_18 * _1) * _1) * _4) + (((_21 * _1) + _22) * _4)) + _20)
      _16 += 1
     else:
      _13[_16] = self.__basevar_nativeidxs[_17]
      _13[(_16 + 1)] = self.__basevar_nativeidxs[_17]
      _14[_16] = (((((_18 * _1) * _1) * _4) + (((_21 * _1) + _22) * _4)) + _20)
      _14[(_16 + 1)] = (((((_18 * _1) * _1) * _4) + (((_22 * _1) + _21) * _4)) + _20)
      _16 += 2
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_15,_13,None,0,_8)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_5,numpy.array([_14[_15[_23]] for _23 in range(0,_8)], dtype=numpy.dtype(numpy.int64)),numpy.array([_13[_15[_24]] for _24 in range(0,_8)], dtype=numpy.dtype(numpy.int64))))
  @staticmethod
  def _match_fromTril_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_fromTril_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _fromTril_alt_I(self,_t__0):
    return self._fromTril_I(numpy.int32(__0))
  def _fromTril_I(self,_0):
   return (self._fromTril_II(0,_0))
  @staticmethod
  def _match_tril_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_tril_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _tril_alt_II(self,_t__0,_t__1):
    return self._tril_II(numpy.int32(__0),numpy.int32(__1))
  def _tril_II(self,_0,_1):
   if ((_0 < 0) or ((_0 >= _1) or (_1 >= int((self.__shape).shape[0])))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid dimension specification")
   else:
    if (self.__shape[_0]!=self.__shape[_1]):
     raise mosek_fusion_DimensionError._ctor_S("Operation only valid for square variables")
   _2=numpy.zeros(((int((self.__shape).shape[0]) - 1),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_153(_0,_2,self.__shape) 
   _2[_0] = ((self.__shape[_0] * (self.__shape[_0] + 1)) // 2)
   fragments._c_closure_154(_0,_1,_2,self.__shape) 
   fragments._c_closure_155(_1,_2,self.__shape) 
   if (self.__sparsity is None):
    _3=1
    _3 = fragments._c_closure_156(_3,_0,self.__shape)
    _3 = numpy.int32(_3) # postprocess
    _4=self.__shape[_0]
    _5=1
    _5 = fragments._c_closure_157(_5,_0,_1,self.__shape)
    _5 = numpy.int32(_5) # postprocess
    _6=self.__shape[_1]
    _7=1
    _7 = fragments._c_closure_158(_7,_1,self.__shape)
    _7 = numpy.int32(_7) # postprocess
    _8=numpy.zeros(((((((_3 * _5) * _7) * _4) * (_4 + 1)) // 2),), dtype=numpy.dtype(numpy.int64))
    _9=0
    _9 = fragments._c_closure_159(self.__basevar_nativeidxs,_3,_4,_5,_6,_7,_9,_8)
    _9 = numpy.int32(_9) # postprocess
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_2,None,_8))
   else:
    _10=1
    _10 = fragments._c_closure_160(_10,_0,self.__shape)
    _10 = numpy.int32(_10) # postprocess
    _11=self.__shape[_0]
    _12=1
    _12 = fragments._c_closure_161(_12,_0,_1,self.__shape)
    _12 = numpy.int32(_12) # postprocess
    _13=self.__shape[_1]
    _14=1
    _14 = fragments._c_closure_162(_14,_1,self.__shape)
    _14 = numpy.int32(_14) # postprocess
    _15=1
    _16=_14
    _17=(_16 * _13)
    _18=(_17 * _12)
    _19=(_18 * _11)
    _20=0
    _20 = fragments._c_closure_163(_11,_13,_20,_18,_16,self.__sparsity)
    _20 = numpy.int32(_20) # postprocess
    _21=1
    _22=_14
    _23=(_22 * _12)
    _24=(((_23 * _11) * (_11 + 1)) // 2)
    _25=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int64))
    _26=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int64))
    _27=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int64))
    _28=0
    _28 = fragments._c_closure_164(self.__basevar_nativeidxs,_11,_12,_13,_14,_28,_20,_25,_26,_24,_23,_22,_21,_27,_19,_18,_17,_16,_15,self.__sparsity)
    _28 = numpy.int32(_28) # postprocess
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_25,_26,None,0,_20)
    _29=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int64))
    _30=numpy.zeros((_20,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_165(_20,_29,_25,_26) 
    fragments._c_closure_166(_20,_25,_27,_30) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_2,_30,_29))
  @staticmethod
  def _match_tril_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_tril_(*args):
    if len(args) != 0: return False
    return True
  def _tril_alt_(self,):
    return self._tril_()
  def _tril_(self,):
   return (self._tril_II(0,1))
  @staticmethod
  def _match_reshape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_reshape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _reshape_alt_III(self,_t__0,_t__1,_t__2):
    return self._reshape_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _reshape_III(self,_0,_1,_2):
   return (self._reshape__3I(numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_reshape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _reshape_alt_II(self,_t__0,_t__1):
    return self._reshape_II(numpy.int32(__0),numpy.int32(__1))
  def _reshape_II(self,_0,_1):
   return (self._reshape__3I(numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_reshape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _reshape_alt_I(self,_t__0):
    return self._reshape_I(numpy.int32(__0))
  def _reshape_I(self,_0):
   return (self._reshape__3I(numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_reshape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _reshape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._reshape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _reshape__3I(self,_0):
   _1=1
   for _2 in range(0,int((_0).shape[0])):
    if (_0[_2] < 0):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape")
    _1 *= _0[_2]
   if (_1!=self._getSize_()):
    raise mosek_fusion_LengthError._ctor_S("Shape size does not match variable size")
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_0[_3] for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)),self.__sparsity,self.__basevar_nativeidxs))
  @staticmethod
  def _match_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_setLevel__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _setLevel_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._setLevel__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _setLevel__3D(self,_0):
   if (self.__sparsity is None):
    if (int((_0).shape[0])!=int((self.__basevar_nativeidxs).shape[0])):
     raise mosek_fusion_LengthError._ctor_S("Invalid length of solution values vector")
    self.__model._setVariableValues_Z_3J_3D(True,self.__basevar_nativeidxs,_0)
   else:
    if (int((_0).shape[0])!=self._getSize_()):
     raise mosek_fusion_LengthError._ctor_S("Invalid length of solution values vector")
    _1=numpy.array([_0[self.__sparsity[_2]] for _2 in range(0,int((self.__basevar_nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.float64))
    self.__model._setVariableValues_Z_3J_3D(True,self.__basevar_nativeidxs,_1)
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   return (self.__model)
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_getDim_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _getDim_alt_I(self,_t__0):
    return self._getDim_I(numpy.int32(__0))
  def _getDim_I(self,_0):
   return numpy.int32(self.__shape[_0])
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   return (mosek.fusion.Utils.Tools._arraycopy__3I(self.__shape))
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   _0=1
   _0 = fragments._c_closure_167(self.__shape,_0)
   _0 = numpy.int64(_0) # postprocess
   return numpy.int64(_0)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__model._getVariableValues_Z_3J_3DI(False,self.__basevar_nativeidxs,_0,0)
   if (self.__sparsity is not None):
    _1=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_168(self.__basevar_nativeidxs,_0,self.__sparsity,_1) 
    _0 = _1
   return (_0)
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__model._getVariableValues_Z_3J_3DI(True,self.__basevar_nativeidxs,_0,0)
   if (self.__sparsity is not None):
    _1=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_169(self.__basevar_nativeidxs,_0,self.__sparsity,_1) 
    _0 = _1
   return (_0)
  @staticmethod
  def _match_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeContinuous_(*args):
    if len(args) != 0: return False
    return True
  def _makeContinuous_alt_(self,):
    return self._makeContinuous_()
  def _makeContinuous_(self,):
   self._make_1continuous_()
  @staticmethod
  def _match_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_makeInteger_(*args):
    if len(args) != 0: return False
    return True
  def _makeInteger_alt_(self,):
    return self._makeInteger_()
  def _makeInteger_(self,):
   self._make_1integer_()
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   if (int((self.__shape).shape[0])==1):
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([1,self.__shape[0]], dtype=numpy.dtype(numpy.int32)),self.__sparsity,self.__basevar_nativeidxs))
   elif (int((self.__shape).shape[0]) > 2):
    raise mosek_fusion_DimensionError._ctor_S("Invalid shape for operation")
   else:
    _0=numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.int64))
    _1=(None if ((self.__sparsity is None) ) else numpy.zeros((int((self.__basevar_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.int64)))
    fragments._c_closure_170(self.__basevar_nativeidxs,_0,self.__shape,_1,self.__sparsity) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([self.__shape[1],self.__shape[0]], dtype=numpy.dtype(numpy.int32)),_1,_0))
  @staticmethod
  def _match_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_index_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _index_alt_III(self,_t__0,_t__1,_t__2):
    return self._index_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _index_III(self,_0,_1,_2):
   return (self._index__3I(numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_index_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _index_alt_II(self,_t__0,_t__1):
    return self._index_II(numpy.int32(__0),numpy.int32(__1))
  def _index_II(self,_0,_1):
   return (self._index__3I(numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   _1=numpy.zeros((1,int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_171(_0,_1) 
   return (self._pick__3_5I(_1)._reshape__3I(numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   return (self._pick__3I(numpy.array([_0], dtype=numpy.dtype(numpy.int32)))._reshape__3I(numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  def _pick_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_0,_1,_2):
   if (int((self.__shape).shape[0])!=3):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   if ((int((_0).shape[0])!=int((_1).shape[0])) or (int((_0).shape[0])!=int((_2).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching argument lengths")
   _3=numpy.zeros((int((_0).shape[0]),3,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_172(_0,_1,_2,_3) 
   return (self._pick__3_5I(_3))
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _pick_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_0,_1):
   if ((int((self.__shape).shape[0])!=2) or (int((_0).shape[0])!=int((_1).shape[0]))):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _2=numpy.zeros((int((_0).shape[0]),2,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_173(_0,_1,_2) 
   return (self._pick__3_5I(_2))
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_0)
   return _1_res
  def _pick__3_5I(self,_0):
   if (int((self.__shape).shape[0])!=int((_0).shape[1])):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _1=False
   _1 = fragments._c_closure_174(_1,_0,self.__shape)
   if _1:
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _2=int((self.__shape).shape[0])
   _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
   _3[(_2 - 1)] = 1
   fragments._c_closure_175(_2,self.__shape,_3) 
   _4=numpy.array([int((_0).shape[0])], dtype=numpy.dtype(numpy.int32))
   _6=None
   if (self.__sparsity is None):
    _5 = numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_176(self.__basevar_nativeidxs,_5,_0,_2,_3) 
   else:
    _7=0
    for _8 in range(0,int((_0).shape[0])):
     _9=0
     _9 = fragments._c_closure_177(_8,_9,_0,_2,_3)
     _9 = numpy.int64(_9) # postprocess
     if (mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_9) >= 0):
      _7 += 1
    _5 = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _6 = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _10=0
    for _11 in range(0,int((_0).shape[0])):
     _12=0
     _12 = fragments._c_closure_178(_11,_12,_0,_2,_3)
     _12 = numpy.int64(_12) # postprocess
     _13=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_12)
     if (_13 >= 0):
      _5[_10] = self.__basevar_nativeidxs[_13]
      _6[_10] = _11
      _10 += 1
    if (_7==int((_0).shape[0])):
     _6 = None
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_4,_6,_5))
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_0):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _1=False
   _1 = fragments._c_closure_179(_0,_1,self.__shape)
   if _1:
    raise mosek_fusion_IndexError._ctor_S("Invalid index")
   _3=None
   if (self.__sparsity is None):
    _2 = numpy.array([self.__basevar_nativeidxs[_0[_4]] for _4 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64))
   else:
    _5=0
    for _6 in range(0,int((_0).shape[0])):
     if (mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_0[_6]) >= 0):
      _5 += 1
    _2 = numpy.zeros((_5,), dtype=numpy.dtype(numpy.int64))
    _3 = numpy.zeros((_5,), dtype=numpy.dtype(numpy.int64))
    _7=0
    for _8 in range(0,int((_0).shape[0])):
     _9=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_0[_8])
     if (_9 >= 0):
      _3[_7] = _8
      _2[_7] = self.__basevar_nativeidxs[_9]
      _7 += 1
    if (_5==int((_0).shape[0])):
     _3 = None
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([int((_0).shape[0])], dtype=numpy.dtype(numpy.int32)),_3,_2))
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _antidiag_alt_I(self,_t__0):
    return self._antidiag_I(numpy.int32(__0))
  def _antidiag_I(self,_0):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   elif ((_0 >= self.__shape[1]) or ((- _0) >= self.__shape[2])):
    raise mosek_fusion_IndexError._ctor_S("Diagonal index out of bounds")
   if (_0 >= 0):
    return (self.__general_1diag__3I_3II(numpy.array([0,((self.__shape[1] - 1) - _0)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < (self.__shape[1] - _0)) ) else (self.__shape[1] - _0))))
   else:
    return (self.__general_1diag__3I_3II(numpy.array([(- _0),(self.__shape[1] - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[1] if ((self.__shape[1] < (self.__shape[0] + _0)) ) else (self.__shape[0] + _0))))
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("antidiag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3II(numpy.array([0,(self.__shape[1] - 1)], dtype=numpy.dtype(numpy.int32)),numpy.array([1,(- 1)], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < self.__shape[1]) ) else self.__shape[1])))
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _diag_alt_I(self,_t__0):
    return self._diag_I(numpy.int32(__0))
  def _diag_I(self,_0):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   elif ((_0 >= self.__shape[1]) or ((- _0) >= self.__shape[2])):
    raise mosek_fusion_IndexError._ctor_S("Diagonal index out of bounds")
   if (_0 >= 0):
    return (self.__general_1diag__3I_3II(numpy.array([0,_0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < (self.__shape[1] - _0)) ) else (self.__shape[1] - _0))))
   else:
    return (self.__general_1diag__3I_3II(numpy.array([(- _0),0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[1] if ((self.__shape[1] < (self.__shape[0] + _0)) ) else (self.__shape[0] + _0))))
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   if (int((self.__shape).shape[0])!=2):
    raise mosek_fusion_DimensionError._ctor_S("diag() only works on two-dimensional objects")
   return (self.__general_1diag__3I_3II(numpy.array([0,0], dtype=numpy.dtype(numpy.int32)),numpy.array([1,1], dtype=numpy.dtype(numpy.int32)),(self.__shape[0] if ((self.__shape[0] < self.__shape[1]) ) else self.__shape[1])))
  def __general_1diag_alt__3I_3II(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.int32(_t__2)
   _1_res = self.__general_1diag__3I_3II(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __general_1diag__3I_3II(self,_0,_1,_2):
   _3=int((self.__shape).shape[0])
   if ((_3!=int((_0).shape[0])) or (_3!=int((_1).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid start or step definition")
   for _4 in range(0,_3):
    if ((_0[_4] < 0) or (_0[_4] >= self.__shape[_4])):
     raise mosek_fusion_LengthError._ctor_S("Start element is out of bounds")
   _5=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int64))
   _5[(_3 - 1)] = 1
   fragments._c_closure_180(_3,self.__shape,_5) 
   _6=0
   _6 = fragments._c_closure_181(_0,_6,_1,_5)
   _6 = numpy.int64(_6) # postprocess
   _7=0
   _7 = fragments._c_closure_182(_1,_7,_5)
   _7 = numpy.int64(_7) # postprocess
   if (self.__sparsity is None):
    _8=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_183(self.__basevar_nativeidxs,_2,_8,_6,_7) 
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_2], dtype=numpy.dtype(numpy.int32)),None,_8))
   else:
    _9=0
    for _10 in range(0,_2):
     _11=(_6 + (_7 * _10))
     _12=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_11)
     if (_12 >= 0):
      _9 += 1
    _13=numpy.zeros((_9,), dtype=numpy.dtype(numpy.int64))
    _14=numpy.zeros((_9,), dtype=numpy.dtype(numpy.int64))
    _15=0
    for _16 in range(0,_2):
     _13[_16] = self.__basevar_nativeidxs[(_6 + (_7 * _16))]
     _17=(_6 + (_7 * _16))
     _18=mosek.fusion.CommonTools._binarySearch__3JJ(self.__sparsity,_17)
     if (_18 >= 0):
      _14[_15] = _16
      _13[_15] = self.__basevar_nativeidxs[_18]
      _15 += 1
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_2], dtype=numpy.dtype(numpy.int32)),_14,_13))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   elif (int((_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   else:
    for _2 in range(0,int((self.__shape).shape[0])):
     if ((_0[_2] < 0) or (_1[_2] > self.__shape[_2])):
      raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
     elif (_0[_2] > _1[_2]):
      raise mosek_fusion_SliceError._ctor_S("Invalid slice")
    _3=int((self.__shape).shape[0])
    _4=numpy.array([(_1[_5] - _0[_5]) for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
    _6=1
    _6 = fragments._c_closure_184(_0,_1,_3,_6)
    _6 = numpy.int32(_6) # postprocess
    if (_6==0):
     return (mosek_fusion_NilVariable._ctor_())
    elif (self.__sparsity is not None):
     _7=0
     _8=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int32))
     _7 = fragments._c_closure_185(_0,_8,_1,_3,_7,self.__shape,self.__sparsity)
     _7 = numpy.int32(_7) # postprocess
     _9=0
     _10=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
     _11=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
     _9 = fragments._c_closure_186(self.__basevar_nativeidxs,_0,_9,_10,_8,_1,_3,self.__shape,_4,_11,self.__sparsity)
     _9 = numpy.int32(_9) # postprocess
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_4,_11,_10))
    else:
     _12=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int64))
     fragments._c_closure_187(self.__basevar_nativeidxs,_0,_1,_3,self.__shape,_12,_6) 
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),_4,None,_12))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   if ((_0==0) and (_1==self.__shape[0])):
    return (self)
   elif ((_0 < 0) or (_1 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
   elif (_0 > _1):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   elif (_0==_1):
    return (mosek_fusion_NilVariable._ctor_())
   elif (self.__sparsity is not None):
    _2=(_1 - _0)
    _3=0
    _4=mosek.fusion.CommonTools._binarySearchL__3JJ(self.__sparsity,_0)
    _5=mosek.fusion.CommonTools._binarySearchL__3JJ(self.__sparsity,_1)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_2], dtype=numpy.dtype(numpy.int32)),numpy.array([(self.__sparsity[_6] - _0) for _6 in range(_4,_5)], dtype=numpy.dtype(numpy.int64)),numpy.array([self.__basevar_nativeidxs[_7] for _7 in range(_4,_5)], dtype=numpy.dtype(numpy.int64))))
   else:
    _8=(_1 - _0)
    _9=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
    mosek.fusion.Utils.Tools._arraycopy__3JI_3JII(self.__basevar_nativeidxs,_0,_9,0,_8)
    return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(self._getModel_(),numpy.array([_8], dtype=numpy.dtype(numpy.int32)),None,_9))
  @staticmethod
  def _match_asExpr_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_asExpr_(*args):
    if len(args) != 0: return False
    return True
  def _asExpr_alt_(self,):
    return self._asExpr_()
  def _asExpr_(self,):
   return (mosek_fusion_ExprFromVar._ctor_Lmosek_4fusion_4Variable_2(self))
  @staticmethod
  def _match_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1) and __arg_match_I__(_2) and __arg_match__3J__(_3))
  @staticmethod
  def _match_alt_inst_I_3JI_3J(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match_I__(_2) and __arg_alt_match__3J__(_3))
  def _inst_alt_I_3JI_3J(self,_t__0,_t__1,_t__2,_t__3):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3JI_3J(_0,_1,_2,_3)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3JI_3J(self,_0,_1,_2,_3):
   _4=(self.__basevar_nativeidxs)
   _5=(self.__sparsity)
   if (_5 is None):
    fragments._c_closure_188(_3,_2,_1,_0,_4) 
   else:
    for _6 in range(0,int(((self.__sparsity)).shape[0])):
     _1[(_0 + _6)] = _5[_6]
     _3[(_6 + _2)] = _4[_6]
   return numpy.int32(int(((self.__basevar_nativeidxs)).shape[0]))
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   return numpy.int32(int((self.__basevar_nativeidxs).shape[0]))
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1))
  def _inst_alt_I_3J(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_0,_1):
   if (self.__sparsity is None):
    fragments._c_closure_189(self.__basevar_nativeidxs,_1,_0) 
   else:
    _2=self._getShape_()
    _3=1
    _3 = fragments._c_closure_190(_3,_2)
    _3 = numpy.int32(_3) # postprocess
    fragments._c_closure_191(_3,_1,_0) 
    fragments._c_closure_192(self.__basevar_nativeidxs,_1,_0,self.__sparsity) 
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_Z__(_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_Z__(_1))
  def _set_1values_alt__3DZ(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=_t__1
   _1_res = self._set_1values__3DZ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_0,_1):
   if (self.__sparsity is None):
    self._getModel_()._setVariableValues_Z_3J_3D(_1,self.__basevar_nativeidxs,_0)
   else:
    _2=1
    _2 = fragments._c_closure_193(self.__shape,_2)
    _2 = numpy.int32(_2) # postprocess
    _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_194(self.__basevar_nativeidxs,_3,self.__sparsity) 
    self._getModel_()._setVariableValues_Z_3J_3D(_1,_3,_0)
  def _dual_1lu_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1_res = self._dual_1lu_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1lu_I_3DZ(self,_0,_1,_2):
   if (self.__sparsity is None):
    self.__model._getVariableDuals_Z_3J_3DI(_2,self.__basevar_nativeidxs,_1,_0)
   else:
    _3=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_195(self.__basevar_nativeidxs,_3,self.__sparsity) 
    self.__model._getVariableDuals_Z_3J_3DI(_2,_3,_1,_0)
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _values_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1_res = self._values_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_0,_1,_2):
   if (self.__sparsity is None):
    self.__model._getVariableValues_Z_3J_3DI(_2,self.__basevar_nativeidxs,_1,_0)
   else:
    _3=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_196(self.__basevar_nativeidxs,_3,self.__sparsity) 
    self.__model._getVariableValues_Z_3J_3DI(_2,_3,_1,_0)
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   self._getModel_()._make_1continuous__3J(self.__basevar_nativeidxs)
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   self._getModel_()._make_1integer__3J(self.__basevar_nativeidxs)
 return BaseVariable
mosek_fusion_BaseVariable=__mk_mosek_fusion_BaseVariable()
del __mk_mosek_fusion_BaseVariable
#BEFORE CLASS
def __mk_mosek_fusion_SliceVariable():
 class SliceVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_SliceVariable__shape','_SliceVariable__sparsity','_SliceVariable__nativeidxs']
  def __repr__(self): return 'mosek.fusion.SliceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,nativeidxs):
    o = SliceVariable.__new__(SliceVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(*args):
    if len(args) != 4: return False
    m,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs)
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__shape) = shape
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceVariable_2(v):
    o = SliceVariable.__new__(SliceVariable)
    o._ctor_init_Lmosek_4fusion_4SliceVariable_2(v)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceVariable_2(*args):
    if len(args) != 1: return False
    v, = args
    return (__arg_match_Lmosek_4fusion_4SliceVariable_2__(v))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceVariable_2(*args):
    if len(args) != 1: return False
    v, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceVariable_2__(v))
  def _ctor_alt_init_Lmosek_4fusion_4SliceVariable_2(self,v):
    self._ctor_init_Lmosek_4fusion_4SliceVariable_2(v)
  def _ctor_init_Lmosek_4fusion_4SliceVariable_2(self,v):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,v._getModel_())
   (self.__nativeidxs) = (v.__nativeidxs)
   (self.__sparsity) = (v.__sparsity)
   (self.__shape) = (v.__shape)
 return SliceVariable
mosek_fusion_SliceVariable=__mk_mosek_fusion_SliceVariable()
del __mk_mosek_fusion_SliceVariable
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceVariable():
 class BoundInterfaceVariable(mosek_fusion_SliceVariable):
  __slots__ = ['_BoundInterfaceVariable__islower']
  def diag(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_diag_(*args):
      return self._diag_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_diag_(*args):
      return self._diag_alt_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_diag_I(*args):
      return self._diag_I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_diag_I(*args):
      return self._diag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list diag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.diag()\n\tmosek.fusion.BoundInterfaceVariable.diag(int32)')
  def transpose(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_transpose_(*args):
      return self._transpose_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_transpose_(*args):
      return self._transpose_alt_(*args)
    else:
      raise ValueError('Invalid argument list transpose('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.transpose()')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.dual()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.slice(int32,int32)\n\tmosek.fusion.BoundInterfaceVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def antidiag(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_antidiag_(*args):
      return self._antidiag_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_antidiag_(*args):
      return self._antidiag_alt_(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_antidiag_I(*args):
      return self._antidiag_I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_antidiag_I(*args):
      return self._antidiag_alt_I(*args)
    else:
      raise ValueError('Invalid argument list antidiag('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.antidiag()\n\tmosek.fusion.BoundInterfaceVariable.antidiag(int32)')
  def pick(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I(*args):
      return self._pick__3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I(*args):
      return self._pick_alt__3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3_5I(*args):
      return self._pick__3_5I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3_5I(*args):
      return self._pick_alt__3_5I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I_3I(*args):
      return self._pick__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I_3I(*args):
      return self._pick_alt__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_pick__3I_3I_3I(*args):
      return self._pick__3I_3I_3I(*args)
    elif mosek_fusion_BoundInterfaceVariable._match_alt_pick__3I_3I_3I(*args):
      return self._pick_alt__3I_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list pick('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=2))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.BoundInterfaceVariable.pick(array(int32,ndim=1),array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.BoundInterfaceVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,shape,sparsity,nativeidxs,islower):
    o = BoundInterfaceVariable.__new__(BoundInterfaceVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,shape,sparsity,nativeidxs,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(*args):
    if len(args) != 5: return False
    m,shape,sparsity,nativeidxs,islower, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3J__(nativeidxs) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(*args):
    if len(args) != 5: return False
    m,shape,sparsity,nativeidxs,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(nativeidxs) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self,m,shape,sparsity,nativeidxs,islower):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)),islower)
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self,m,shape,sparsity,nativeidxs,islower):
   mosek_fusion_SliceVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,m,shape,sparsity,nativeidxs)
   (self.__islower) = islower
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceVariable_2Z(v,islower):
    o = BoundInterfaceVariable.__new__(BoundInterfaceVariable)
    o._ctor_init_Lmosek_4fusion_4SliceVariable_2Z(v,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceVariable_2Z(*args):
    if len(args) != 2: return False
    v,islower, = args
    return (__arg_match_Lmosek_4fusion_4SliceVariable_2__(v) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceVariable_2Z(*args):
    if len(args) != 2: return False
    v,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceVariable_2__(v) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4SliceVariable_2Z(self,v,islower):
    self._ctor_init_Lmosek_4fusion_4SliceVariable_2Z(v,islower)
  def _ctor_init_Lmosek_4fusion_4SliceVariable_2Z(self,v,islower):
   mosek_fusion_SliceVariable._ctor_init_Lmosek_4fusion_4SliceVariable_2(self,v)
   (self.__islower) = islower
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
   self._dual_1lu_I_3DZ(0,_0,self.__islower)
   return (_0)
  @staticmethod
  def _match_transpose_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_transpose_(*args):
    if len(args) != 0: return False
    return True
  def _transpose_alt_(self,):
    return self._transpose_()
  def _transpose_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._transpose_(self)))
  @staticmethod
  def _match_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_pick__3I_3I_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1) and __arg_alt_match__3I__(_2))
  def _pick_alt__3I_3I_3I(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I_3I(self,_0,_1,_2):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I_3I_3I(self,_0,_1,_2)))
  @staticmethod
  def _match_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_pick__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _pick_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I_3I(self,_0,_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I_3I(self,_0,_1)))
  @staticmethod
  def _match_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_pick__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _pick_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3_5I(_0)
   return _1_res
  def _pick__3_5I(self,_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3_5I(self,_0)))
  @staticmethod
  def _match_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_pick__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _pick_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._pick__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _pick__3I(self,_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._pick__3I(self,_0)))
  @staticmethod
  def _match_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_antidiag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _antidiag_alt_I(self,_t__0):
    return self._antidiag_I(numpy.int32(__0))
  def _antidiag_I(self,_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._antidiag_I(self,_0)))
  @staticmethod
  def _match_antidiag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_antidiag_(*args):
    if len(args) != 0: return False
    return True
  def _antidiag_alt_(self,):
    return self._antidiag_()
  def _antidiag_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._antidiag_(self)))
  @staticmethod
  def _match_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_diag_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _diag_alt_I(self,_t__0):
    return self._diag_I(numpy.int32(__0))
  def _diag_I(self,_0):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._diag_I(self,_0)))
  @staticmethod
  def _match_diag_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_diag_(*args):
    if len(args) != 0: return False
    return True
  def _diag_alt_(self,):
    return self._diag_()
  def _diag_(self,):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._diag_(self)))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._slice__3I_3I(self,_0,_1)))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   return (self.__from_1_Lmosek_4fusion_4Variable_2(mosek_fusion_BaseVariable._slice_II(self,_0,_1)))
  def __from_1_alt_Lmosek_4fusion_4Variable_2(self,_t__0):
    return self.__from_1_Lmosek_4fusion_4Variable_2(_0)
  def __from_1_Lmosek_4fusion_4Variable_2(self,_0):
   _1=self._getShape_()
   _2=_0._numInst_()
   _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
   _4=None
   if (_0._getSize_()==_2):
    _0._inst_I_3J(0,_3)
   else:
    _4 = numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    _0._inst_I_3JI_3J(0,_4,0,_3)
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(_0._getModel_(),_1,_4,_3,self.__islower))
 return BoundInterfaceVariable
mosek_fusion_BoundInterfaceVariable=__mk_mosek_fusion_BoundInterfaceVariable()
del __mk_mosek_fusion_BoundInterfaceVariable
#BEFORE CLASS
def __mk_mosek_fusion_ModelVariable():
 class ModelVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_ModelVariable__sparsity','_ModelVariable__shape','_ModelVariable__modelvar_nativeidxs','_ModelVariable__varid','_ModelVariable__name']
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_ModelVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_ModelVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def remove(self,*args):
    if False: pass
    elif mosek_fusion_ModelVariable._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_ModelVariable._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelVariable.remove()')
  def __repr__(self): return 'mosek.fusion.ModelVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4BaseVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__name = (v.__name)
   self.__varid = (v.__varid)
   self.__modelvar_nativeidxs = (v.__modelvar_nativeidxs)
   self.__shape = (v.__shape)
   self.__sparsity = (v.__sparsity)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,shape,varid,sparsity,modelvar_nativeidxs):
    o = ModelVariable.__new__(ModelVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,shape,varid,sparsity,modelvar_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(*args):
    if len(args) != 6: return False
    model,name,shape,varid,sparsity,modelvar_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match_J__(varid) and __arg_match__3J__(sparsity) and __arg_match__3J__(modelvar_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(*args):
    if len(args) != 6: return False
    model,name,shape,varid,sparsity,modelvar_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match_J__(varid) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3J__(modelvar_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,modelvar_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int64(varid),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(modelvar_nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,modelvar_nativeidxs):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,model,shape,sparsity,modelvar_nativeidxs)
   (self.__name) = name
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__sparsity) = sparsity
   (self.__modelvar_nativeidxs) = modelvar_nativeidxs
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _1._a_S(("_" if ((int(len(self.__name))==0) ) else self.__name))._a_S("[")._a_S(mosek.fusion.Set._indexToString__3IJ(self.__shape,_0))._a_S("]")
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   self._getModel_()._removeVariableBlock_J(self.__varid)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   pass
 return ModelVariable
mosek_fusion_ModelVariable=__mk_mosek_fusion_ModelVariable()
del __mk_mosek_fusion_ModelVariable
#BEFORE CLASS
def __mk_mosek_fusion_RangedVariable():
 class RangedVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_RangedVariable__shape','_RangedVariable__name','_RangedVariable__names_flushed','_RangedVariable__nativeidxs','_RangedVariable__sparsity']
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_RangedVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def upperBoundVar(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_upperBoundVar_(*args):
      return self._upperBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_upperBoundVar_(*args):
      return self._upperBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list upperBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.upperBoundVar()')
  def lowerBoundVar(self,*args):
    if False: pass
    elif mosek_fusion_RangedVariable._match_lowerBoundVar_(*args):
      return self._lowerBoundVar_(*args)
    elif mosek_fusion_RangedVariable._match_alt_lowerBoundVar_(*args):
      return self._lowerBoundVar_alt_(*args)
    else:
      raise ValueError('Invalid argument list lowerBoundVar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedVariable.lowerBoundVar()')
  def __repr__(self): return 'mosek.fusion.RangedVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__name = (v.__name)
   self.__nativeidxs = (v.__nativeidxs)
   self.__sparsity = (v.__sparsity)
   self.__names_flushed = (v.__names_flushed)
   self.__shape = (v.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs):
    o = RangedVariable.__new__(RangedVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_J__(varid) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_J__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,numpy.int64(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,mosek.fusion.RangedVariable.__globalNativeIndexes__3I(nativeidxs))
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__name) = name
   (self.__shape) = shape
   self.__names_flushed = False
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(_0,_1)
   _1._a_S(" : in range")
   return (_1)
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  def _dual_1u_alt_I_3D(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._dual_1u_I_3D(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1u_I_3D(self,_0,_1):
   self._dual_1lu_I_3DZ(_0,_1,False)
  def _dual_1l_alt_I_3D(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _1_res = self._dual_1l_I_3D(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1l_I_3D(self,_0,_1):
   self._dual_1lu_I_3DZ(_0,_1,True)
  @staticmethod
  def _match_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_upperBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _upperBoundVar_alt_(self,):
    return self._upperBoundVar_()
  def _upperBoundVar_(self,):
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self._getModel_(),self.__shape,self.__sparsity,numpy.array([self.__nativeidxs[_0] for _0 in range(0,int((self.__nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int64)),False))
  @staticmethod
  def _match_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_lowerBoundVar_(*args):
    if len(args) != 0: return False
    return True
  def _lowerBoundVar_alt_(self,):
    return self._lowerBoundVar_()
  def _lowerBoundVar_(self,):
   return (mosek_fusion_BoundInterfaceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3JZ(self._getModel_(),self.__shape,self.__sparsity,numpy.array([self.__nativeidxs[_0] for _0 in range(0,int((self.__nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int64)),True))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_RangedVariable._ctor_Lmosek_4fusion_4RangedVariable_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_RangedVariable.__globalNativeIndexes__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_197(_0,_1) 
   return (_1)
 return RangedVariable
mosek_fusion_RangedVariable=__mk_mosek_fusion_RangedVariable()
del __mk_mosek_fusion_RangedVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDVariable():
 class LinearPSDVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearPSDVariable__shape','_LinearPSDVariable__name','_LinearPSDVariable__varid','_LinearPSDVariable__nativeidxs','_LinearPSDVariable__conedim']
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    elif mosek_fusion_LinearPSDVariable._match_make_1continuous__3J(*args):
      return self._make_1continuous__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1continuous__3J(*args):
      return self._make_1continuous_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_continuous()\n\tmosek.fusion.LinearPSDVariable.make_continuous(array(int64,ndim=1))')
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    elif mosek_fusion_LinearPSDVariable._match_make_1integer__3J(*args):
      return self._make_1integer__3J(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_make_1integer__3J(*args):
      return self._make_1integer_alt__3J(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.make_integer()\n\tmosek.fusion.LinearPSDVariable.make_integer(array(int64,ndim=1))')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_LinearPSDVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearPSDVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearPSDVariable.toString()')
  def __repr__(self): return 'mosek.fusion.LinearPSDVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   (self.__conedim) = (v.__conedim)
   (self.__varid) = (v.__varid)
   (self.__name) = (v.__name)
   (self.__shape) = (v.__shape)
   (self.__nativeidxs) = (v.__nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,varid,shape,conedim,nativeidxs):
    o = LinearPSDVariable.__new__(LinearPSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,varid,shape,conedim,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3II_3J(*args):
    if len(args) != 6: return False
    model,name,varid,shape,conedim,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match_I__(conedim) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3II_3J(*args):
    if len(args) != 6: return False
    model,name,varid,shape,conedim,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3II_3J(self,model,name,varid,shape,conedim,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3II_3J(self,model,name,varid,shape,conedim,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.LinearPSDVariable.__globalNativeIndexes__3J(nativeidxs))
   (self.__name) = name
   (self.__conedim) = conedim
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("PSDVariable(")
   if (int(len(self.__name)) > 0):
    _0._a_S("'")._a_S(self.__name)._a_S("',")
   _0._a_I(self.__shape[0])
   for _1 in range(1,int((self.__shape).shape[0])):
    _0._a_S(",")._a_I(self.__shape[_1])
   _0._a_S(")")
   return (_0._toString_())
  @staticmethod
  def _match_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1continuous__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1continuous_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1continuous__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1continuous__3J(self,_0):
   pass
  @staticmethod
  def _match_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3J__(_0))
  @staticmethod
  def _match_alt_make_1integer__3J(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3J__(_0))
  def _make_1integer_alt__3J(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1_res = self._make_1integer__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _make_1integer__3J(self,_0):
   raise mosek_fusion_UnimplementedError._ctor_S("Cannot make PSDVariable elements integer")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearPSDVariable._ctor_Lmosek_4fusion_4LinearPSDVariable_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __globalNativeIndexes_alt__3J(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_LinearPSDVariable.__globalNativeIndexes__3J(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3J(_0):
   return (numpy.array([(- (_0[_1] + 1)) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int64)))
 return LinearPSDVariable
mosek_fusion_LinearPSDVariable=__mk_mosek_fusion_LinearPSDVariable()
del __mk_mosek_fusion_LinearPSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_PSDVariable():
 class PSDVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_PSDVariable__model','_PSDVariable__names_flushed','_PSDVariable__barvaridxs','_PSDVariable__conedim2','_PSDVariable__conedim1','_PSDVariable__shape','_PSDVariable__name','_PSDVariable__nativeidxs','_PSDVariable__varid']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_PSDVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.toString()')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_PSDVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_PSDVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def __repr__(self): return 'mosek.fusion.PSDVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__varid = (v.__varid)
   self.__nativeidxs = (v.__nativeidxs)
   self.__name = (v.__name)
   self.__shape = (v.__shape)
   self.__conedim1 = (v.__conedim1)
   self.__conedim2 = (v.__conedim2)
   self.__names_flushed = False
   self.__model = m
   self.__barvaridxs = (v.__barvaridxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
    o = PSDVariable.__new__(PSDVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(*args):
    if len(args) != 8: return False
    model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match_I__(conedim1) and __arg_match_I__(conedim2) and __arg_match__3I__(barvaridxs) and __arg_match__3J__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3III_3I_3J(*args):
    if len(args) != 8: return False
    model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim1) and __arg_alt_match_I__(conedim2) and __arg_alt_match__3I__(barvaridxs) and __arg_alt_match__3J__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim1),numpy.int32(conedim2),numpy.array(barvaridxs,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3III_3I_3J(self,model,name,varid,shape,conedim1,conedim2,barvaridxs,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.PSDVariable.__fullnativeidxs__3III_3J(shape,conedim1,conedim2,nativeidxs))
   (self.__varid) = varid
   (self.__nativeidxs) = nativeidxs
   (self.__name) = name
   (self.__shape) = shape
   (self.__conedim1) = conedim1
   (self.__conedim2) = conedim2
   self.__names_flushed = False
   (self.__model) = model
   (self.__barvaridxs) = barvaridxs
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("PSDVariable(")
   if (int(len(self.__name)) > 0):
    _0._a_S("'")._a_S(self.__name)._a_S("',")
   _0._a_I(self.__shape[0])
   for _1 in range(1,int((self.__shape).shape[0])):
    _0._a_S(",")._a_I(self.__shape[_1])
   _0._a_S(")")
   return (_0._toString_())
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(_0,_1)
   _1._a_S(" : element in positive semidefinite cone")
   return (_1)
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_PSDVariable._ctor_Lmosek_4fusion_4PSDVariable_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __fullnativeidxs_alt__3III_3J(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int64))
   _1_res = mosek_fusion_PSDVariable.__fullnativeidxs__3III_3J(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __fullnativeidxs__3III_3J(_0,_1,_2,_3):
   _4=int((_0).shape[0])
   _5=(_1 < _2)
   _6=(_1 if (_5 ) else _2)
   _7=(_1 if ((not _5) ) else _2)
   _8=1
   _8 = fragments._c_closure_198(_6,_8,_0)
   _8 = numpy.int32(_8) # postprocess
   _9=_0[_6]
   _10=1
   _10 = fragments._c_closure_199(_6,_7,_10,_0)
   _10 = numpy.int32(_10) # postprocess
   _11=_0[_7]
   _12=1
   _12 = fragments._c_closure_200(_7,_12,_4,_0)
   _12 = numpy.int32(_12) # postprocess
   _13=((((_8 * _9) * _10) * _11) * _12)
   _14=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int64))
   _15=_12
   _16=(_15 * _11)
   _17=(_16 * _10)
   _18=(_17 * _17)
   fragments._c_closure_201(_8,_9,_10,_11,_12,_3,_14,_18,_17,_16,_15) 
   return (_14)
 return PSDVariable
mosek_fusion_PSDVariable=__mk_mosek_fusion_PSDVariable()
del __mk_mosek_fusion_PSDVariable
#BEFORE CLASS
def __mk_mosek_fusion_LinearVariable():
 class LinearVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_LinearVariable__shape','_LinearVariable__sparsity','_LinearVariable__nativeidxs','_LinearVariable__names_flushed','_LinearVariable__name']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_LinearVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearVariable.toString()')
  def __repr__(self): return 'mosek.fusion.LinearVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__names_flushed = (v.__names_flushed)
   self.__nativeidxs = (v.__nativeidxs)
   self.__sparsity = (v.__sparsity)
   self.__shape = (v.__shape)
   self.__name = (v.__name)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs):
    o = LinearVariable.__new__(LinearVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,varid,shape,sparsity,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_J__(varid) and __arg_match__3I__(shape) and __arg_match__3J__(sparsity) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(*args):
    if len(args) != 6: return False
    model,name,varid,shape,sparsity,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_J__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3J__(sparsity) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(model,name,numpy.int64(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(sparsity,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SJ_3I_3J_3I(self,model,name,varid,shape,sparsity,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,sparsity,mosek.fusion.LinearVariable.__globalNativeIndexes__3I(nativeidxs))
   self.__names_flushed = False
   (self.__name) = name
   (self.__nativeidxs) = nativeidxs
   (self.__sparsity) = sparsity
   (self.__shape) = shape
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("LinearVariable((")
   if (int((self.__shape).shape[0]) > 0):
    _0._a_I(self.__shape[0])
    for _1 in range(1,int((self.__shape).shape[0])):
     _0._a_S(",")._a_I(self.__shape[_1])
   _0._a_S(")")
   if (self.__sparsity is not None):
    _0._a_S(",sparse")
   _0._a_S(")")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearVariable._ctor_Lmosek_4fusion_4LinearVariable_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_LinearVariable.__globalNativeIndexes__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_202(_0,_1) 
   return (_1)
 return LinearVariable
mosek_fusion_LinearVariable=__mk_mosek_fusion_LinearVariable()
del __mk_mosek_fusion_LinearVariable
#BEFORE CLASS
def __mk_mosek_fusion_ConicVariable():
 class ConicVariable(mosek_fusion_ModelVariable):
  __slots__ = ['_ConicVariable__nativeidxs','_ConicVariable__shape','_ConicVariable__name','_ConicVariable__names_flushed','_ConicVariable__varid']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_ConicVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ConicVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicVariable.toString()')
  def __repr__(self): return 'mosek.fusion.ConicVariable'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    v,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConicVariable_2__(v) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
    self._ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(v,m)
  def _ctor_init_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,v,m):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4ModelVariable_2Lmosek_4fusion_4Model_2(self,v,m)
   self.__names_flushed = (v.__names_flushed)
   self.__shape = (v.__shape)
   self.__nativeidxs = (v.__nativeidxs)
   self.__shape = (v.__shape)
   self.__varid = (v.__varid)
   self.__name = (v.__name)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,varid,shape,nativeidxs):
    o = ConicVariable.__new__(ConicVariable)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,varid,shape,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3I_3I(*args):
    if len(args) != 5: return False
    model,name,varid,shape,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(varid) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3I_3I(*args):
    if len(args) != 5: return False
    model,name,varid,shape,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(varid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3I_3I(self,model,name,varid,shape,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(model,name,numpy.int32(varid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I(self,model,name,varid,shape,nativeidxs):
   mosek_fusion_ModelVariable._ctor_init_Lmosek_4fusion_4Model_2S_3IJ_3J_3J(self,model,name,shape,varid,None,mosek.fusion.ConicVariable.__globalNativeIndexes__3I(nativeidxs))
   (self.__name) = name
   (self.__names_flushed) = False
   (self.__varid) = varid
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("ConicVariable( ")
   if (int(len(self.__name)) > 0):
    _0._a_S("'")._a_S(self.__name)._a_S("',")
   _0._a_S("(")
   _0._a_I(self.__shape[0])
   for _1 in range(1,int((self.__shape).shape[0])):
    _0._a_S(",")._a_I(self.__shape[_1])
   _0._a_S(") )")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_ConicVariable._ctor_Lmosek_4fusion_4ConicVariable_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __globalNativeIndexes_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_ConicVariable.__globalNativeIndexes__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __globalNativeIndexes__3I(_0):
   _1=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int64))
   fragments._c_closure_203(_0,_1) 
   return (_1)
 return ConicVariable
mosek_fusion_ConicVariable=__mk_mosek_fusion_ConicVariable()
del __mk_mosek_fusion_ConicVariable
#BEFORE CLASS
def __mk_mosek_fusion_NilVariable():
 class NilVariable(mosek_fusion_BaseVariable):
  __slots__ = ['_NilVariable__shape']
  def make_integer(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1integer_(*args):
      return self._make_1integer_(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1integer_(*args):
      return self._make_1integer_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_integer('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_integer()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_NilVariable._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_NilVariable._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_NilVariable._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.slice(int32,int32)\n\tmosek.fusion.NilVariable.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_NilVariable._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.toString()')
  def inst(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_inst_I_3J(*args):
      return self._inst_I_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3J(*args):
      return self._inst_alt_I_3J(*args)
    elif mosek_fusion_NilVariable._match_inst_I_3J_3J(*args):
      return self._inst_I_3J_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3J_3J(*args):
      return self._inst_alt_I_3J_3J(*args)
    elif mosek_fusion_NilVariable._match_inst_I_3JI_3J(*args):
      return self._inst_I_3JI_3J(*args)
    elif mosek_fusion_NilVariable._match_alt_inst_I_3JI_3J(*args):
      return self._inst_alt_I_3JI_3J(*args)
    else:
      raise ValueError('Invalid argument list inst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1))\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),array(int64,ndim=1))\n\tmosek.fusion.NilVariable.inst(int32,array(int64,ndim=1),int32,array(int64,ndim=1))')
  def elementName(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementName('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementName(int64,mosek.fusion.Utils.StringBuffer)')
  def numInst(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_numInst_(*args):
      return self._numInst_(*args)
    elif mosek_fusion_NilVariable._match_alt_numInst_(*args):
      return self._numInst_alt_(*args)
    else:
      raise ValueError('Invalid argument list numInst('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.numInst()')
  def make_continuous(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_make_1continuous_(*args):
      return self._make_1continuous_(*args)
    elif mosek_fusion_NilVariable._match_alt_make_1continuous_(*args):
      return self._make_1continuous_alt_(*args)
    else:
      raise ValueError('Invalid argument list make_continuous('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.make_continuous()')
  def elementDesc(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    elif mosek_fusion_NilVariable._match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
      return self._elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(*args)
    else:
      raise ValueError('Invalid argument list elementDesc('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.elementDesc(int64,mosek.fusion.Utils.StringBuffer)')
  def values(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_values_I_3DZ(*args):
      return self._values_I_3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_values_I_3DZ(*args):
      return self._values_alt_I_3DZ(*args)
    else:
      raise ValueError('Invalid argument list values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.values(int32,array(double,ndim=1),bool)')
  def set_values(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_set_1values__3DZ(*args):
      return self._set_1values__3DZ(*args)
    elif mosek_fusion_NilVariable._match_alt_set_1values__3DZ(*args):
      return self._set_1values_alt__3DZ(*args)
    else:
      raise ValueError('Invalid argument list set_values('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.set_values(array(double,ndim=1),bool)')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_NilVariable._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_NilVariable._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_NilVariable._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_NilVariable._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    elif mosek_fusion_NilVariable._match_index_II(*args):
      return self._index_II(*args)
    elif mosek_fusion_NilVariable._match_alt_index_II(*args):
      return self._index_alt_II(*args)
    elif mosek_fusion_NilVariable._match_index_III(*args):
      return self._index_III(*args)
    elif mosek_fusion_NilVariable._match_alt_index_III(*args):
      return self._index_alt_III(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.NilVariable.index(int32)\n\tmosek.fusion.NilVariable.index(array(int32,ndim=1))\n\tmosek.fusion.NilVariable.index(int32,int32)\n\tmosek.fusion.NilVariable.index(int32,int32,int32)')
  def __repr__(self): return 'mosek.fusion.NilVariable'
  @staticmethod
  def _ctor__3I(shape):
    o = NilVariable.__new__(NilVariable)
    o._ctor_init__3I(shape)
    return o
  @staticmethod
  def __match_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_match__3I__(shape))
  @staticmethod
  def __match_alt_ctor__3I(*args):
    if len(args) != 1: return False
    shape, = args
    return (__arg_alt_match__3I__(shape))
  def _ctor_alt_init__3I(self,shape):
    self._ctor_init__3I(numpy.array(shape,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init__3I(self,shape):
   mosek_fusion_BaseVariable._ctor_init_Lmosek_4fusion_4Model_2_3I_3J_3J(self,None,mosek.fusion.Utils.Tools._arraycopy__3I(shape),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int64)))
   (self.__shape) = numpy.array([shape[_0] for _0 in range(0,int((shape).shape[0]))], dtype=numpy.dtype(numpy.int32))
  @staticmethod
  def _ctor_():
    o = NilVariable.__new__(NilVariable)
    o._ctor_init_()
    return o
  @staticmethod
  def __match_ctor_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def __match_alt_ctor_(*args):
    if len(args) != 0: return False
    return True
  def _ctor_alt_init_(self,):
    self._ctor_init_()
  def _ctor_init_(self,):
   mosek_fusion_NilVariable._ctor_init__3I(self,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)))
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  @staticmethod
  def _match_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementDesc_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementDesc_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   return (_1)
  @staticmethod
  def _match_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_J__(_0) and __arg_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  @staticmethod
  def _match_alt_elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_J__(_0) and __arg_alt_match_Lmosek_4fusion_4Utils_4StringBuffer_2__(_1))
  def _elementName_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _elementName_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  @staticmethod
  def _match_numInst_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_numInst_(*args):
    if len(args) != 0: return False
    return True
  def _numInst_alt_(self,):
    return self._numInst_()
  def _numInst_(self,):
   return numpy.int32(0)
  @staticmethod
  def _match_inst_I_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1) and __arg_match__3J__(_2))
  @staticmethod
  def _match_alt_inst_I_3J_3J(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1) and __arg_alt_match__3J__(_2))
  def _inst_alt_I_3J_3J(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J_3J(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J_3J(self,_0,_1,_2):
   return numpy.int32(0)
  @staticmethod
  def _match_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match__3J__(_1))
  @staticmethod
  def _match_alt_inst_I_3J(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3J__(_1))
  def _inst_alt_I_3J(self,_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int64))
   _1_res = self._inst_I_3J(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _inst_I_3J(self,_0,_1):
   pass
  @staticmethod
  def _match_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_Z__(_1))
  @staticmethod
  def _match_alt_set_1values__3DZ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_Z__(_1))
  def _set_1values_alt__3DZ(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=_t__1
   _1_res = self._set_1values__3DZ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _set_1values__3DZ(self,_0,_1):
   pass
  @staticmethod
  def _match_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match__3D__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_values_I_3DZ(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3D__(_1) and __arg_alt_match_Z__(_2))
  def _values_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1_res = self._values_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _values_I_3DZ(self,_0,_1,_2):
   pass
  @staticmethod
  def _match_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1continuous_(*args):
    if len(args) != 0: return False
    return True
  def _make_1continuous_alt_(self,):
    return self._make_1continuous_()
  def _make_1continuous_(self,):
   pass
  @staticmethod
  def _match_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_make_1integer_(*args):
    if len(args) != 0: return False
    return True
  def _make_1integer_alt_(self,):
    return self._make_1integer_()
  def _make_1integer_(self,):
   pass
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   return ("NilVariable")
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([1 for _1 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([1 for _1 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   if ((int((self.__shape).shape[0])!=int((_0).shape[0])) or (int((self.__shape).shape[0])!=int((_1).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching slice shape")
   for _2 in range(0,int((_0).shape[0])):
    if ((_1[_2] > _0[_2]) or ((_0[_2] < 0) or (_1[_2] >= self.__shape[_2]))):
     raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   return (mosek_fusion_NilVariable._ctor__3I(numpy.array([(_1[_3] - _0[_3]) for _3 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if ((_1 > _0) or ((_0 < 0) or (_1 > self.__shape[0]))):
    raise mosek_fusion_SliceError._ctor_S("Slice is out of bounds")
   elif (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching slice shape")
   else:
    return (mosek_fusion_NilVariable._ctor__3I(numpy.array([(_1 - _0)], dtype=numpy.dtype(numpy.int32))))
 return NilVariable
mosek_fusion_NilVariable=__mk_mosek_fusion_NilVariable()
del __mk_mosek_fusion_NilVariable
#BEFORE CLASS
def __mk_mosek_fusion_Var():
 class Var(object):
  @staticmethod
  def flatten(*args):
    if False: pass
    elif mosek_fusion_Var._match_flatten_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_flatten_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._flatten_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list flatten('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.flatten(mosek.fusion.Variable)')
  @staticmethod
  def vstack(*args):
    if False: pass
    elif mosek_fusion_Var._match_vstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list vstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.vstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def empty(*args):
    if False: pass
    elif mosek_fusion_Var._match_empty__3I(*args):
      return mosek_fusion_Var._empty__3I(*args)
    elif mosek_fusion_Var._match_alt_empty__3I(*args):
      return mosek_fusion_Var._empty_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list empty('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.empty(array(int32,ndim=1))')
  @staticmethod
  def promote(*args):
    if False: pass
    elif mosek_fusion_Var._match_promote_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._promote_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_promote_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._promote_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list promote('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.promote(mosek.fusion.Variable,int32)')
  @staticmethod
  def stack(*args):
    if False: pass
    elif mosek_fusion_Var._match_stack__3_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt__3_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack__3Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt__3Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_I_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_I_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_I_3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_I_3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.stack(array(array(mosek.fusion.Variable,ndim=1),ndim=1))\n\tmosek.fusion.Var.stack(array(mosek.fusion.Variable,ndim=1),int32)\n\tmosek.fusion.Var.stack(int32,array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.stack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.stack(int32,mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def reshape(*args):
    if False: pass
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2_3I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_reshape_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._reshape_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list reshape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,array(int32,ndim=1))\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.reshape(mosek.fusion.Variable,int32,int32)')
  @staticmethod
  def vrepeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._vrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list vrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.vrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def compress(*args):
    if False: pass
    elif mosek_fusion_Var._match_compress_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_compress_Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._compress_alt_Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list compress('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.compress(mosek.fusion.Variable)')
  @staticmethod
  def hstack(*args):
    if False: pass
    elif mosek_fusion_Var._match_hstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt__3Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Var._match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
      return mosek_fusion_Var._hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args)
    else:
      raise ValueError('Invalid argument list hstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hstack(array(mosek.fusion.Variable,ndim=1))\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable)\n\tmosek.fusion.Var.hstack(mosek.fusion.Variable,mosek.fusion.Variable,mosek.fusion.Variable)')
  @staticmethod
  def hrepeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._hrepeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    else:
      raise ValueError('Invalid argument list hrepeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.hrepeat(mosek.fusion.Variable,int32)')
  @staticmethod
  def repeat(*args):
    if False: pass
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args):
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2I(*args)
    elif mosek_fusion_Var._match_repeat_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(*args)
    elif mosek_fusion_Var._match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args):
      return mosek_fusion_Var._repeat_alt_Lmosek_4fusion_4Variable_2II(*args)
    else:
      raise ValueError('Invalid argument list repeat('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32)\n\tmosek.fusion.Var.repeat(mosek.fusion.Variable,int32,int32)')
  def __repr__(self): return 'mosek.fusion.Var'
  @staticmethod
  def _match_empty__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_empty__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _empty_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._empty__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _empty__3I(_0):
   for _1 in range(0,int((_0).shape[0])):
    if (_0[_1] < 0):
     raise mosek_fusion_DimensionError._ctor_S("Invalid shape")
   return (mosek_fusion_NilVariable._ctor__3I(_0))
  @staticmethod
  def _match_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_compress_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _compress_alt_Lmosek_4fusion_4Variable_2(_t__0):
    return mosek_fusion_Var._compress_Lmosek_4fusion_4Variable_2(_0)
  @staticmethod
  def _compress_Lmosek_4fusion_4Variable_2(_0):
   _1=_0._getShape_()
   _2=int((_1).shape[0])
   _3=0
   _3 = fragments._c_closure_204(_2,_3,_1)
   _3 = numpy.int32(_3) # postprocess
   _4=numpy.zeros((_3,), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_205(_2,_4,_1) 
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,_4))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,numpy.array([_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,numpy.array([_1,_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_flatten_Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _flatten_alt_Lmosek_4fusion_4Variable_2(_t__0):
    return mosek_fusion_Var._flatten_Lmosek_4fusion_4Variable_2(_0)
  @staticmethod
  def _flatten_Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,numpy.array([numpy.int32(mosek.fusion.Set._size__3I(_0._getShape_()))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_reshape_Lmosek_4fusion_4Variable_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _reshape_alt_Lmosek_4fusion_4Variable_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._reshape_Lmosek_4fusion_4Variable_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _reshape_Lmosek_4fusion_4Variable_2_3I(_0,_1):
   return (_0._reshape__3I(_1))
  @staticmethod
  def _index_1permute_1_alt_Lmosek_4fusion_4Variable_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Var._index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _index_1permute_1_Lmosek_4fusion_4Variable_2_3I(_0,_1):
   _4=_0._getShape_()
   _5=int((_4).shape[0])
   _6=1
   _6 = fragments._c_closure_206(_5,_4,_6)
   _6 = numpy.int32(_6) # postprocess
   _7=_0._numInst_()
   _8=numpy.zeros((_5,), dtype=numpy.dtype(numpy.int64))
   _8[(_5 - 1)] = 1
   fragments._c_closure_207(_5,_1,_8,_4) 
   if (_7 < _6):
    _2 = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _3 = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _0._inst_I_3JI_3J(0,_2,0,_3)
   else:
    _2 = None
    _3 = numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _0._inst_I_3J(0,_3)
   if (_2 is None):
    _9=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_208(_3,_5,_7,_1,_8,_9,_4) 
    _3 = _9
   else:
    _10=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    fragments._c_closure_209(_5,_7,_1,_8,_10,_4) 
    _11=numpy.array([_12 for _12 in range(0,_7)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_11,_10,None,0,_7)
    _2 = numpy.array([_2[_11[_13]] for _13 in range(0,_7)], dtype=numpy.dtype(numpy.int64))
    _3 = numpy.array([_3[_11[_14]] for _14 in range(0,_7)], dtype=numpy.dtype(numpy.int64))
   return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_0._getModel_(),numpy.array([_4[_1[_15]] for _15 in range(0,_5)], dtype=numpy.dtype(numpy.int32)),_2,_3))
  @staticmethod
  def _match_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_hrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _hrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._hrepeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _hrepeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,1,_1))
  @staticmethod
  def _match_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_vrepeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _vrepeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._vrepeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _vrepeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,0,_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,0,_1))
  @staticmethod
  def _match_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_repeat_Lmosek_4fusion_4Variable_2II(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _repeat_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._repeat_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def _repeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   return (mosek.fusion.Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2))
  @staticmethod
  def __drepeat_alt_Lmosek_4fusion_4Variable_2II(_t__0,_t__1,_t__2):
    return mosek_fusion_Var.__drepeat_Lmosek_4fusion_4Variable_2II(_0,numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def __drepeat_Lmosek_4fusion_4Variable_2II(_0,_1,_2):
   if (_2 < 0):
    raise mosek_fusion_LengthError._ctor_S("Cannot repeat less than 0 times")
   elif (_2==0):
    return (mosek_fusion_NilVariable._ctor_())
   elif (_2==1):
    return (_0)
   else:
    _3=_0._getModel_()
    _4=_0._getShape_()
    _5=int((_4).shape[0])
    if ((_1 < 0) or (_1 > _5)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
    _6=mosek.fusion.Set._size__3I(_4)
    _7=_0._numInst_()
    _8=(_7 * _2)
    _9=1
    _9 = fragments._c_closure_210(_9,_1,_4)
    _9 = numpy.int32(_9) # postprocess
    _10=(_4[_1] if ((_1 < _5) ) else 1)
    _11=(_10 * _2)
    _12=1
    _12 = fragments._c_closure_211(_12,_1,_5,_4)
    _12 = numpy.int32(_12) # postprocess
    _13=(_5 if ((_1 < _5) ) else (_1 + 1))
    _14=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_212(_5,_14,_4) 
    fragments._c_closure_213(_5,_13,_14) 
    _14[_1] = _11
    if (_7 < _6):
     _15=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
     _16=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
     _17=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
     _18=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int64))
     _0._inst_I_3JI_3J(0,_16,0,_15)
     _19=(_11 * _12)
     _20=(_10 * _12)
     _21=_12
     if (_1==0):
      _22=0
      _22 = fragments._c_closure_214(_6,_22,_2,_7,_17,_18,_15,_16)
      _22 = numpy.int32(_22) # postprocess
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_3,_14,_18,_17))
     elif (_1 >= _5):
      _23=0
      _23 = fragments._c_closure_215(_23,_2,_7,_17,_18,_15,_16)
      _23 = numpy.int32(_23) # postprocess
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_3,_14,_18,_17))
     else:
      _24=0
      _24 = fragments._c_closure_216(_10,_12,_24,_2,_7,_19,_17,_18,_20,_21,_15,_16)
      _24 = numpy.int32(_24) # postprocess
      _25=1
      _25 = fragments._c_closure_217(_25,_13,_14)
      _25 = numpy.int32(_25) # postprocess
      _26=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
      _27=numpy.zeros((_8,), dtype=numpy.dtype(numpy.int32))
      _28=numpy.zeros(((_25 + 1),), dtype=numpy.dtype(numpy.int32))
      _29=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int64))
      _29[(_13 - 1)] = 1
      fragments._c_closure_218(_13,_14,_29) 
      fragments._c_closure_219(_26,_8) 
      for _30 in range(0,_13):
       _31=((_13 - _30) - 1)
       fragments._c_closure_220(_31,_28,_14) 
       fragments._c_closure_221(_31,_28,_8,_14,_18,_29) 
       fragments._c_closure_222(_31,_28,_14) 
       fragments._c_closure_223(_26,_31,_28,_8,_14,_18,_29,_27) 
       _32=_26
       _26 = _27
       _27 = _32
      return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_3,_14,numpy.array([_18[_26[_33]] for _33 in range(0,_8)], dtype=numpy.dtype(numpy.int64)),numpy.array([_17[_26[_34]] for _34 in range(0,_8)], dtype=numpy.dtype(numpy.int64))))
    else:
     _35=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
     _36=numpy.zeros(((_7 * _2),), dtype=numpy.dtype(numpy.int64))
     _0._inst_I_3J(0,_35)
     _37=(_11 * _12)
     _38=_12
     _39=0
     _39 = fragments._c_closure_224(_9,_10,_12,_39,_2,_36,_37,_38,_35)
     _39 = numpy.int32(_39) # postprocess
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_3,_14,None,_36))
  @staticmethod
  def _match_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_stack__3_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _stack_alt__3_3Lmosek_4fusion_4Variable_2(_t__0):
   _0=_monty.makeJaggedArray(_t__0,(1,1),numpy.dtype(object))
   _1_res = mosek_fusion_Var._stack__3_3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3_3Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0[_1],1) for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1):
    return mosek_fusion_Var._vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_vstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _vstack_alt__3Lmosek_4fusion_4Variable_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._vstack__3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _vstack__3Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1):
    return mosek_fusion_Var._hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _match_alt_hstack__3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0))
  @staticmethod
  def _hstack_alt__3Lmosek_4fusion_4Variable_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._hstack__3Lmosek_4fusion_4Variable_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _hstack__3Lmosek_4fusion_4Variable_2(_0):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,1))
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Var._stack__3Lmosek_4fusion_4Variable_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3Lmosek_4fusion_4Variable_2I(_0,_1):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_1,_0))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_I__(_3))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__0,_t__1,_t__2,_t__3):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2,numpy.int32(__3))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2,_3):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_3,numpy.array([_0,_1,_2], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,numpy.int32(__2))
  @staticmethod
  def _stack_Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2I(_0,_1,_2):
   return (mosek.fusion.Var._stack_I_3Lmosek_4fusion_4Variable_2(_2,numpy.array([_0,_1], dtype=numpy.dtype(object))))
  @staticmethod
  def _match_stack_I_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match__3Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_stack_I_3Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match__3Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _stack_alt_I_3Lmosek_4fusion_4Variable_2(_t__0,_t__1):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Var._stack_I_3Lmosek_4fusion_4Variable_2(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack_I_3Lmosek_4fusion_4Variable_2(_0,_1):
   _2=_0
   for _3 in range(0,int((_1).shape[0])):
    if (_2 < _1[_3]._getND_()):
     _2 = _1[_3]._getND_()
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(_1,_0))
  @staticmethod
  def _match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_match_Lmosek_4fusion_4Variable_2__(_3))
  @staticmethod
  def _match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_3))
  @staticmethod
  def _stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2,_t__3):
    return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(numpy.int32(__0),_1,_2,_3)
  @staticmethod
  def _stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2,_3):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_1,_2,_3], dtype=numpy.dtype(object)),_0))
  @staticmethod
  def _match_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _match_alt_stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_2))
  @staticmethod
  def _stack_alt_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Var._stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(numpy.int32(__0),_1,_2)
  @staticmethod
  def _stack_ILmosek_4fusion_4Variable_2Lmosek_4fusion_4Variable_2(_0,_1,_2):
   return (mosek.fusion.Var._dstack__3Lmosek_4fusion_4Variable_2I(numpy.array([_1,_2], dtype=numpy.dtype(object)),_0))
  @staticmethod
  def _match_promote_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_promote_Lmosek_4fusion_4Variable_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Variable_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _promote_alt_Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
    return mosek_fusion_Var._promote_Lmosek_4fusion_4Variable_2I(_0,numpy.int32(__1))
  @staticmethod
  def _promote_Lmosek_4fusion_4Variable_2I(_0,_1):
   if (_1 > _0._getND_()):
    _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int32))
    _3=_0._getShape_()
    fragments._c_closure_225(_3,_2) 
    fragments._c_closure_226(_1,_3,_2) 
    return (_0._reshape__3I(_2))
   else:
    return (_0)
  @staticmethod
  def _dstack_alt__3Lmosek_4fusion_4Variable_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Var._dstack__3Lmosek_4fusion_4Variable_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _dstack__3Lmosek_4fusion_4Variable_2I(_0,_1):
   if (_1 < 0):
    raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
   _2=None
   for _3 in range(0,int((_0).shape[0])):
    if (_2 is None):
     _2 = _0[_3]._getModel_()
    elif ((_0[_3]._getModel_() is not None) and (_0[_3]._getModel_() is not _2)):
     _4=mosek.fusion.Utils.StringBuffer()
     _5=(_2._getName_() if ((int(len(_2._getName_())) > 0) ) else "?")
     _6=(_0[_3]._getModel_()._getName_() if ((int(len(_0[_3]._getModel_()._getName_())) > 0) ) else "?")
     _4._a_S("Variables belong to different models: '")._a_S(_5)._a_S("' and '")._a_S(_6)._a_S("'")
     raise mosek_fusion_ModelError._ctor_S(_4._toString_())
   if (int((_0).shape[0])==0):
    return (mosek_fusion_NilVariable._ctor_())
   elif (int((_0).shape[0])==1):
    return (_0[0])
   else:
    _7=int((_0).shape[0])
    _8=numpy.array([_0[_9]._numInst_() for _9 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
    _10=_monty.initJaggedArray([_0[_11]._getShape_() for _11 in range(0,_7)], 1)
    _12=numpy.array([int((_10[_13]).shape[0]) for _13 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
    _14=_10[0]
    _15=_12[0]
    _16=0
    _16 = fragments._c_closure_227(_7,_8,_16)
    _16 = numpy.int32(_16) # postprocess
    _17=(_1 + 1)
    _17 = fragments._c_closure_228(_7,_12,_17)
    _17 = numpy.int32(_17) # postprocess
    _18=numpy.zeros((_17,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_229(_15,_18,_14) 
    fragments._c_closure_230(_15,_17,_18) 
    _18[_1] = 0
    fragments._c_closure_231(_1,_7,_18,_10) 
    for _19 in range(0,_7):
     for _20 in range(0,int((_10[_19]).shape[0])):
      if ((_20!=_1) and (_10[_19][_20]!=_18[_20])):
       raise mosek_fusion_DimensionError._ctor_S("Variable dimensions do not match")
     for _21 in range(int((_10[_19]).shape[0]),_17):
      if ((_21!=_1) and (1!=_18[_21])):
       raise mosek_fusion_DimensionError._ctor_S("Variable dimensions do not match")
    _22=numpy.zeros((_16,), dtype=numpy.dtype(numpy.int64))
    _23=numpy.zeros((_16,), dtype=numpy.dtype(numpy.int64))
    _24=numpy.array([(_10[_25][_1] if ((_1 < int((_10[_25]).shape[0])) ) else 1) for _25 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))
    _26=1
    _26 = fragments._c_closure_232(_26,_1,_14)
    _26 = numpy.int32(_26) # postprocess
    _27=0
    _27 = fragments._c_closure_233(_27,_7,_24)
    _27 = numpy.int32(_27) # postprocess
    _28=1
    _28 = fragments._c_closure_234(_28,_1,_14)
    _28 = numpy.int32(_28) # postprocess
    if (_26==1):
     _29=0
     _30=0
     for _31 in range(0,_7):
      _0[_31]._inst_I_3JI_3J(_29,_23,_29,_22)
      _29 = fragments._c_closure_235(_31,_29,_30,_8,_23)
      _29 = numpy.int32(_29) # postprocess
      _30 += mosek.fusion.Set._size__3I(_10[_31])
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_2,_18,(_23 if ((_16 < ((_26 * _27) * _28)) ) else None),_22))
    else:
     _32=0
     for _33 in range(0,_7):
      _32 += _0[_33]._inst_I_3JI_3J(_32,_23,_32,_22)
     _34=numpy.zeros((_16,), dtype=numpy.dtype(numpy.int32))
     _35=numpy.zeros((_16,), dtype=numpy.dtype(numpy.int32))
     _36=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_236(_7,_36,_24) 
     fragments._c_closure_237(_34,_16) 
     _37=0
     _37 = fragments._c_closure_238(_27,_28,_37,_7,_8,_36,_23,_24)
     _37 = numpy.int32(_37) # postprocess
     _38=1
     _38 = fragments._c_closure_239(_38,_17,_18)
     _38 = numpy.int32(_38) # postprocess
     _39=numpy.zeros((_17,), dtype=numpy.dtype(numpy.int64))
     _39[(_17 - 1)] = 1
     fragments._c_closure_240(_17,_18,_39) 
     _40=numpy.zeros(((_38 + 1),), dtype=numpy.dtype(numpy.int32))
     for _41 in range(0,_17):
      _42=((_17 - _41) - 1)
      fragments._c_closure_241(_42,_40,_18) 
      fragments._c_closure_242(_42,_40,_16,_18,_23,_39) 
      fragments._c_closure_243(_42,_40,_18) 
      fragments._c_closure_244(_34,_42,_40,_16,_18,_23,_39,_35) 
      _43=_34
      _34 = _35
      _35 = _43
     return (mosek_fusion_SliceVariable._ctor_Lmosek_4fusion_4Model_2_3I_3J_3J(_2,_18,(numpy.array([_23[_34[_44]] for _44 in range(0,_16)], dtype=numpy.dtype(numpy.int64)) if ((_16 < ((_26 * _27) * _28)) ) else None),numpy.array([_22[_34[_45]] for _45 in range(0,_16)], dtype=numpy.dtype(numpy.int64))))
 return Var
mosek_fusion_Var=__mk_mosek_fusion_Var()
del __mk_mosek_fusion_Var
#BEFORE CLASS
def __mk_mosek_fusion_Constraint():
 class Constraint(object):
  __slots__ = ['_Constraint__con_nativeidxs','_Constraint__shape','_Constraint__model']
  def __init__(self,*args):
    if False: pass
    elif self.__match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
      self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args)
    elif self.__match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
      self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(*args)
    elif self.__match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
      self._ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(*args)
    else:
      raise ValueError('Invalid argument list for constructor. Candidates are:\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Constraint,mosek.fusion.Model)\n\tmosek.fusion.Constraint.ctor(mosek.fusion.Model,array(int32,ndim=1),array(int32,ndim=1))')
  def size(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_size_(*args):
      return self._size_(*args)
    elif mosek_fusion_Constraint._match_alt_size_(*args):
      return self._size_alt_(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.size()')
  def getModel(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_getModel_(*args):
      return self._getModel_(*args)
    elif mosek_fusion_Constraint._match_alt_getModel_(*args):
      return self._getModel_alt_(*args)
    else:
      raise ValueError('Invalid argument list getModel('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getModel()')
  def get_model(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_get_1model_(*args):
      return self._get_1model_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1model_(*args):
      return self._get_1model_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_model('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_model()')
  @staticmethod
  def vstack(*args):
    if False: pass
    elif mosek_fusion_Constraint._match_vstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list vstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.vstack(array(mosek.fusion.Constraint,ndim=1))\n\tmosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint)\n\tmosek.fusion.Constraint.vstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)')
  def update(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2(*args):
      return self._update_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2(*args)
    elif mosek_fusion_Constraint._match_update__3D(*args):
      return self._update__3D(*args)
    elif mosek_fusion_Constraint._match_alt_update__3D(*args):
      return self._update_alt__3D(*args)
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args)
    elif mosek_fusion_Constraint._match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
      return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args)
    elif mosek_fusion_Constraint._match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
      return self._update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args)
    else:
      raise ValueError('Invalid argument list update('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression)\n\tmosek.fusion.Constraint.update(array(double,ndim=1))\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable)\n\tmosek.fusion.Constraint.update(mosek.fusion.Expression,mosek.fusion.Variable,bool)')
  def getShape(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_getShape_(*args):
      return self._getShape_(*args)
    elif mosek_fusion_Constraint._match_alt_getShape_(*args):
      return self._getShape_alt_(*args)
    else:
      raise ValueError('Invalid argument list getShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getShape()')
  def level(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_level_(*args):
      return self._level_(*args)
    elif mosek_fusion_Constraint._match_alt_level_(*args):
      return self._level_alt_(*args)
    else:
      raise ValueError('Invalid argument list level('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.level()')
  def remove(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_Constraint._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.remove()')
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_Constraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.toString()')
  @staticmethod
  def hstack(*args):
    if False: pass
    elif mosek_fusion_Constraint._match_hstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack__3Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt__3Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    elif mosek_fusion_Constraint._match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
      return mosek_fusion_Constraint._hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args)
    else:
      raise ValueError('Invalid argument list hstack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.hstack(array(mosek.fusion.Constraint,ndim=1))\n\tmosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint)\n\tmosek.fusion.Constraint.hstack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint)')
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_Constraint._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.dual()')
  def get_nd(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_get_1nd_(*args):
      return self._get_1nd_(*args)
    elif mosek_fusion_Constraint._match_alt_get_1nd_(*args):
      return self._get_1nd_alt_(*args)
    else:
      raise ValueError('Invalid argument list get_nd('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.get_nd()')
  @staticmethod
  def stack(*args):
    if False: pass
    elif mosek_fusion_Constraint._match_stack__3Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack__3Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt__3Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    elif mosek_fusion_Constraint._match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
      return mosek_fusion_Constraint._stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args)
    else:
      raise ValueError('Invalid argument list stack('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.stack(array(mosek.fusion.Constraint,ndim=1),int32)\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,int32)\n\tmosek.fusion.Constraint.stack(mosek.fusion.Constraint,mosek.fusion.Constraint,mosek.fusion.Constraint,int32)')
  def getND(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_getND_(*args):
      return self._getND_(*args)
    elif mosek_fusion_Constraint._match_alt_getND_(*args):
      return self._getND_alt_(*args)
    else:
      raise ValueError('Invalid argument list getND('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getND()')
  def getSize(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_getSize_(*args):
      return self._getSize_(*args)
    elif mosek_fusion_Constraint._match_alt_getSize_(*args):
      return self._getSize_alt_(*args)
    else:
      raise ValueError('Invalid argument list getSize('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.getSize()')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_Constraint._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_Constraint._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_Constraint._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.index(int32)\n\tmosek.fusion.Constraint.index(array(int32,ndim=1))')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_Constraint._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_Constraint._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_Constraint._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_Constraint._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Constraint.slice(int32,int32)\n\tmosek.fusion.Constraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.Constraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m):
   self.__model = m
   self.__shape = (c.__shape)
   self.__con_nativeidxs = (c.__con_nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3I(model,shape,con_nativeidxs):
    o = Constraint.__new__(Constraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,shape,con_nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,con_nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match__3I__(shape) and __arg_match__3I__(con_nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,con_nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(con_nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,con_nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(con_nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,con_nativeidxs):
   (self.__model) = model
   (self.__shape) = shape
   (self.__con_nativeidxs) = con_nativeidxs
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   raise mosek_fusion_UnimplementedError._ctor_S("Constraint.toString")
  def _toStringArray_alt__3JJ_3S(self,_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int64))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(object))
   _1_res = self._toStringArray__3JJ_3S(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _toStringArray__3JJ_3S(self,_0,_1,_2):
   pass
  def _dual_1lu_alt_I_3DZ(self,_t__0,_t__1,_t__2):
   _0=numpy.int32(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=_t__2
   _1_res = self._dual_1lu_I_3DZ(_0,_1,_2)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _dual_1lu_I_3DZ(self,_0,_1,_2):
   self.__model._getConstraintDuals_Z_3I_3DI(_2,self.__con_nativeidxs,_1,_0)
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros((int((self.__con_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__values_ZI_3D(False,0,_0)
   return (_0)
  @staticmethod
  def _match_level_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_level_(*args):
    if len(args) != 0: return False
    return True
  def _level_alt_(self,):
    return self._level_()
  def _level_(self,):
   _0=numpy.zeros((int((self.__con_nativeidxs).shape[0]),), dtype=numpy.dtype(numpy.float64))
   self.__values_ZI_3D(True,0,_0)
   return (_0)
  def __values_alt_ZI_3D(self,_t__0,_t__1,_t__2):
   _0=_t__0
   _1=numpy.int32(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _1_res = self.__values_ZI_3D(_0,_1,_2)
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __values_ZI_3D(self,_0,_1,_2):
   self.__model._getConstraintValues_Z_3I_3DI(_0,self.__con_nativeidxs,_2,_1)
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   raise mosek_fusion_DeletionError._ctor_S("Only original constraints can be removed")
  @staticmethod
  def _match_update__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_update__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  def _update_alt__3D(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = self._update__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _update__3D(self,_0):
   self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(mosek.fusion.Expr._reshape_Lmosek_4fusion_4Expression_2_3I(mosek.fusion.Expr._constTerm__3D(_0),self._getShape_()),mosek_fusion_NilVariable._ctor_(),True)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0))
  def _update_alt_Lmosek_4fusion_4Expression_2(self,_t__0):
    return self._update_Lmosek_4fusion_4Expression_2(_0)
  def _update_Lmosek_4fusion_4Expression_2(self,_0):
   _1=_0._getShape_()
   if (int((self.__shape).shape[0]) < int((_1).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _2 in range(0,int((_1).shape[0])):
    if (_1[_2]!=self.__shape[_2]):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _3 in range(int((_1).shape[0]),int((self.__shape).shape[0])):
    if (self.__shape[_3]!=1):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   self.__model._update__3ILmosek_4fusion_4Expression_2(self.__con_nativeidxs,_0)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_match_Z__(_2))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1) and __arg_alt_match_Z__(_2))
  def _update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(self,_t__0,_t__1,_t__2):
    return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(_0,_1,_2)
  def _update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(self,_0,_1,_2):
   _3=self._getND_()
   _4=_0._getShape_()
   if (_3 < int((_4).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _5 in range(0,int((_4).shape[0])):
    if (_4[_5]!=self.__shape[_5]):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   for _6 in range(int((_4).shape[0]),int((self.__shape).shape[0])):
    if (self.__shape[_6]!=1):
     raise mosek_fusion_DimensionError._ctor_S("Expression shape does not match constraint")
   _7=_1._numInst_()
   _8=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
   if (_7 < _1._getSize_()):
    _9=numpy.zeros((_7,), dtype=numpy.dtype(numpy.int64))
    _1._inst_I_3JI_3J(0,_9,0,_8)
   else:
    _1._inst_I_3J(0,_8)
   for _10 in range(0,_7):
    if (_8[_10] < 0):
     raise mosek_fusion_UpdateError._ctor_S("Semidefinite terms cannot be updated")
   _12=True
   _12 = fragments._c_closure_245(_12,_7,_8)
   if _12:
    if (not _2):
     _11 = numpy.array([numpy.int32(_8[_13]) for _13 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
    else:
     _11 = numpy.zeros(((_7 + 1),), dtype=numpy.dtype(numpy.int32))
     _11[0] = 0
     fragments._c_closure_246(_7,_8,_11) 
   else:
    _14=numpy.array([_15 for _15 in range(0,_7)], dtype=numpy.dtype(numpy.int64))
    mosek.fusion.CommonTools._argQsort__3J_3J_3JJJ(_14,_8,None,0,_7)
    _16=1
    _16 = fragments._c_closure_247(_7,_16,_14,_8)
    _16 = numpy.int32(_16) # postprocess
    if _2:
     _16 += 1
    _11 = numpy.zeros((_16,), dtype=numpy.dtype(numpy.int32))
    _17=0
    if _2:
     _11[0] = 0
     _17 += 1
    _11[_17] = numpy.int32(_8[_14[0]])
    _17 = fragments._c_closure_248(_17,_7,_14,_8,_11)
    _17 = numpy.int32(_17) # postprocess
   self.__model._update__3ILmosek_4fusion_4Expression_2_3I(self.__con_nativeidxs,_0,_11)
  @staticmethod
  def _match_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_match_Lmosek_4fusion_4Variable_2__(_1))
  @staticmethod
  def _match_alt_update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Expression_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Variable_2__(_1))
  def _update_alt_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_t__0,_t__1):
    return self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(_0,_1)
  def _update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2(self,_0,_1):
   self._update_Lmosek_4fusion_4Expression_2Lmosek_4fusion_4Variable_2Z(_0,_1,False)
  @staticmethod
  def _match_get_1model_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1model_(*args):
    if len(args) != 0: return False
    return True
  def _get_1model_alt_(self,):
    return self._get_1model_()
  def _get_1model_(self,):
   return (self.__model)
  @staticmethod
  def _match_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_get_1nd_(*args):
    if len(args) != 0: return False
    return True
  def _get_1nd_alt_(self,):
    return self._get_1nd_()
  def _get_1nd_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_size_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_size_(*args):
    if len(args) != 0: return False
    return True
  def _size_alt_(self,):
    return self._size_()
  def _size_(self,):
   _0=1
   _0 = fragments._c_closure_249(self.__shape,_0)
   _0 = numpy.int64(_0) # postprocess
   return numpy.int64(_0)
  @staticmethod
  def _match_stack__3Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_stack__3Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _stack_alt__3Lmosek_4fusion_4Constraint_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Constraint._stack__3Lmosek_4fusion_4Constraint_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _stack__3Lmosek_4fusion_4Constraint_2I(_0,_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_0,_1))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_2) and __arg_match_I__(_3))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 4: return False
    _0,_1,_2,_3, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_2) and __arg_alt_match_I__(_3))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_t__0,_t__1,_t__2,_t__3):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_0,_1,_2,numpy.int32(__3))
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_0,_1,_2,_3):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),_3))
  @staticmethod
  def _match_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _stack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_t__0,_t__1,_t__2):
    return mosek_fusion_Constraint._stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_0,_1,numpy.int32(__2))
  @staticmethod
  def _stack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2I(_0,_1,_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),_2))
  @staticmethod
  def _match_hstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _match_alt_hstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _hstack_alt__3Lmosek_4fusion_4Constraint_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Constraint._hstack__3Lmosek_4fusion_4Constraint_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _hstack__3Lmosek_4fusion_4Constraint_2(_0):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_0,1))
  @staticmethod
  def _match_vstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _match_alt_vstack__3Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3Lmosek_4fusion_4Constraint_2__(_0))
  @staticmethod
  def _vstack_alt__3Lmosek_4fusion_4Constraint_2(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Constraint._vstack__3Lmosek_4fusion_4Constraint_2(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _vstack__3Lmosek_4fusion_4Constraint_2(_0):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_0,0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_2))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1,_t__2):
    return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1,_2):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1,_2], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _match_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _match_alt_hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _hstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1):
    return mosek_fusion_Constraint._hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1)
  @staticmethod
  def _hstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),1))
  @staticmethod
  def _match_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _match_alt_vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4Constraint_2__(_0) and __arg_alt_match_Lmosek_4fusion_4Constraint_2__(_1))
  @staticmethod
  def _vstack_alt_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_t__0,_t__1):
    return mosek_fusion_Constraint._vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1)
  @staticmethod
  def _vstack_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Constraint_2(_0,_1):
   return (mosek.fusion.Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(numpy.array([_0,_1], dtype=numpy.dtype(object)),0))
  @staticmethod
  def _dstack_alt__3Lmosek_4fusion_4Constraint_2I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Constraint._dstack__3Lmosek_4fusion_4Constraint_2I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _dstack__3Lmosek_4fusion_4Constraint_2I(_0,_1):
   _2=None
   for _3 in range(0,int((_0).shape[0])):
    if (_2 is None):
     _2 = _0[_3]._getModel_()
    elif (((_0[_3].__model) is not None) and ((_0[_3].__model) is not _2)):
     _4=mosek.fusion.Utils.StringBuffer()
     _5=(_2._getName_() if ((int(len(_2._getName_())) > 0) ) else "?")
     _6=(_0[_3]._getModel_()._getName_() if ((int(len(_0[_3]._getModel_()._getName_())) > 0) ) else "?")
     _4._a_S("Constraints belong to different models: '")._a_S(_5)._a_S("' and '")._a_S(_6)._a_S("'")
     raise mosek_fusion_ModelError._ctor_S(_4._toString_())
   if (int((_0).shape[0])==0):
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(None,numpy.array([0], dtype=numpy.dtype(numpy.int32)),numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
   elif (int((_0).shape[0])==1):
    return (_0[1])
   else:
    _7=int((_0).shape[0])
    _8=1
    for _9 in range(0,_7):
     _8 = (_0[_9]._getND_() if ((_0[_9]._getND_() > _8) ) else _8)
    if (_1==_8):
     _8 += 1
    _10=numpy.zeros((_7,_8,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_250(_7,_8,_10) 
    _11=numpy.array([_0[_12]._getSize_() for _12 in range(0,_7)], dtype=numpy.dtype(numpy.int32))
    _13=0
    _13 = fragments._c_closure_251(_7,_11,_13)
    _13 = numpy.int32(_13) # postprocess
    for _14 in range(0,_7):
     _15=_0[_14]._getShape_()
     fragments._c_closure_252(_14,_10,_15) 
    if ((_1 < 0) or (_1 > _8)):
     raise mosek_fusion_DimensionError._ctor_S("Invalid stacking dimension")
    for _16 in range(0,_1):
     for _17 in range(1,_7):
      if (_10[0,_16]!=_10[_17,_16]):
       raise mosek_fusion_DimensionError._ctor_S("Constraint dimensions do not match")
    for _18 in range((_1 + 1),_8):
     for _19 in range(1,_7):
      if (_10[0,_18]!=_10[_19,_18]):
       raise mosek_fusion_DimensionError._ctor_S("Constraint dimensions do not match")
    _20=numpy.zeros((_13,), dtype=numpy.dtype(numpy.int32))
    _21=numpy.array([_10[0,_22] for _22 in range(0,_8)], dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_253(_1,_7,_21,_10) 
    _23=int((_21).shape[0])
    _24=numpy.zeros(((int((_0).shape[0]) + 1),), dtype=numpy.dtype(numpy.int64))
    for _25 in range(0,int((_0).shape[0])):
     _24[(_25 + 1)] = (_24[_25] + _10[_25,_1])
    if (_1==0):
     _26=0
     for _27 in range(0,_7):
      _28=int(((_0[_27].__con_nativeidxs)).shape[0])
      mosek.fusion.Utils.Tools._arraycopy__3II_3III((_0[_27].__con_nativeidxs),0,_20,_26,_28)
      _26 += _28
    else:
     _29=_monty.initJaggedArray([(_0[_30].__con_nativeidxs) for _30 in range(0,_7)], 1)
     if (_1 < _8):
      _31=1
      _31 = fragments._c_closure_254(_31,_1,_21)
      _31 = numpy.int32(_31) # postprocess
      _32=1
      _32 = fragments._c_closure_255(_32,_1,_8,_21)
      _32 = numpy.int32(_32) # postprocess
      _33=0
      for _34 in range(0,_31):
       for _35 in range(0,_7):
        _36=0
        _37=_10[_35,_1]
        for _38 in range(0,_37):
         for _39 in range(0,_32):
          _20[_33] = (_0[_7].__con_nativeidxs)[(((_34 * _32) * _37) + _36)]
          _33 += 1
          _36 += 1
     else:
      fragments._c_closure_256(_20,_7,_8,_29,_21) 
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(_2,_21,_20))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   if (int((_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("variable shape and slice do not match")
   else:
    for _1 in range(0,int((self.__shape).shape[0])):
     if ((_0[_1] < 0) or (_0[_1] > self.__shape[_1])):
      raise mosek_fusion_IndexError._ctor_S("index is out of bounds")
    _2=int((self.__shape).shape[0])
    _3=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int64))
    _3[(_2 - 1)] = 1
    fragments._c_closure_257(_2,self.__shape,_3) 
    _4=0
    _4 = fragments._c_closure_258(_0,_4,_2,_3)
    _4 = numpy.int32(_4) # postprocess
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_4]], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   if ((int((self.__shape).shape[0])==0) and (_0==0)):
    return (self)
   elif (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   elif ((_0 < 0) or (_0 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Index is out of bounds")
   else:
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_0]], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    raise mosek_fusion_SliceError._ctor_S("invalid slice")
   elif (int((_0).shape[0])!=int((self.__shape).shape[0])):
    raise mosek_fusion_DimensionError._ctor_S("variable shape and slice do not match")
   else:
    for _2 in range(0,int((self.__shape).shape[0])):
     if ((_0[_2] < 0) or (_1[_2] > self.__shape[_2])):
      raise mosek_fusion_IndexError._ctor_S("slice is out of bounds")
     elif (_0[_2] > _1[_2]):
      raise mosek_fusion_SliceError._ctor_S("invalid slice")
    _3=int((self.__shape).shape[0])
    _4=numpy.array([(_1[_5] - _0[_5]) for _5 in range(0,_3)], dtype=numpy.dtype(numpy.int32))
    _6=1
    _6 = fragments._c_closure_259(_0,_1,_3,_6)
    _6 = numpy.int32(_6) # postprocess
    if (_6==0):
     return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,_4,numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))))
    else:
     _7=numpy.zeros((_6,), dtype=numpy.dtype(numpy.int32))
     fragments._c_closure_260(self.__con_nativeidxs,_0,_1,_3,self.__shape,_7,_6) 
     return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self._getModel_(),_4,_7))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   if (int((self.__shape).shape[0])!=1):
    raise mosek_fusion_DimensionError._ctor_S("Variable shape and slice do not match")
   if ((_0==0) and (_1==self.__shape[0])):
    return (self)
   elif ((_0 < 0) or (_1 > self.__shape[0])):
    raise mosek_fusion_IndexError._ctor_S("Slice is out of bounds")
   elif (_0 > _1):
    raise mosek_fusion_SliceError._ctor_S("Invalid slice")
   else:
    return (mosek_fusion_SliceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3I(self.__model,numpy.array([(_1 - _0)], dtype=numpy.dtype(numpy.int32)),numpy.array([self.__con_nativeidxs[_2] for _2 in range(_0,_1)], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_getND_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getND_(*args):
    if len(args) != 0: return False
    return True
  def _getND_alt_(self,):
    return self._getND_()
  def _getND_(self,):
   return numpy.int32(int((self.__shape).shape[0]))
  @staticmethod
  def _match_getSize_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getSize_(*args):
    if len(args) != 0: return False
    return True
  def _getSize_alt_(self,):
    return self._getSize_()
  def _getSize_(self,):
   _0=1
   _0 = fragments._c_closure_261(self.__shape,_0)
   _0 = numpy.int32(_0) # postprocess
   return numpy.int32(_0)
  @staticmethod
  def _match_getModel_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getModel_(*args):
    if len(args) != 0: return False
    return True
  def _getModel_alt_(self,):
    return self._getModel_()
  def _getModel_(self,):
   return (self.__model)
  @staticmethod
  def _match_getShape_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getShape_(*args):
    if len(args) != 0: return False
    return True
  def _getShape_alt_(self,):
    return self._getShape_()
  def _getShape_(self,):
   return (numpy.array([self.__shape[_0] for _0 in range(0,int((self.__shape).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  def _getNativeidxs_alt_(self,):
    return self._getNativeidxs_()
  def _getNativeidxs_(self,):
   return (self.__con_nativeidxs)
 return Constraint
mosek_fusion_Constraint=__mk_mosek_fusion_Constraint()
del __mk_mosek_fusion_Constraint
#BEFORE CLASS
def __mk_mosek_fusion_SliceConstraint():
 class SliceConstraint(mosek_fusion_Constraint):
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_SliceConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_SliceConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SliceConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.SliceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceConstraint_2(c):
    o = SliceConstraint.__new__(SliceConstraint)
    o._ctor_init_Lmosek_4fusion_4SliceConstraint_2(c)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceConstraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_match_Lmosek_4fusion_4SliceConstraint_2__(c))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceConstraint_2(*args):
    if len(args) != 1: return False
    c, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceConstraint_2__(c))
  def _ctor_alt_init_Lmosek_4fusion_4SliceConstraint_2(self,c):
    self._ctor_init_Lmosek_4fusion_4SliceConstraint_2(c)
  def _ctor_init_Lmosek_4fusion_4SliceConstraint_2(self,c):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,c._getModel_())
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3I(model,shape,nativeidxs):
    o = SliceConstraint.__new__(SliceConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,shape,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3I(*args):
    if len(args) != 3: return False
    model,shape,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(model,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nativeidxs)
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("SliceConstraint()")
   return (_0._toString_())
 return SliceConstraint
mosek_fusion_SliceConstraint=__mk_mosek_fusion_SliceConstraint()
del __mk_mosek_fusion_SliceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_BoundInterfaceConstraint():
 class BoundInterfaceConstraint(mosek_fusion_SliceConstraint):
  __slots__ = ['_BoundInterfaceConstraint__islower']
  def dual(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_dual_(*args):
      return self._dual_(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_dual_(*args):
      return self._dual_alt_(*args)
    else:
      raise ValueError('Invalid argument list dual('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.dual()')
  def slice(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_slice_II(*args):
      return self._slice_II(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_slice_II(*args):
      return self._slice_alt_II(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_slice__3I_3I(*args):
      return self._slice__3I_3I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_slice__3I_3I(*args):
      return self._slice_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list slice('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.slice(int32,int32)\n\tmosek.fusion.BoundInterfaceConstraint.slice(array(int32,ndim=1),array(int32,ndim=1))')
  def index(self,*args):
    if False: pass
    elif mosek_fusion_BoundInterfaceConstraint._match_index_I(*args):
      return self._index_I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_index_I(*args):
      return self._index_alt_I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_index__3I(*args):
      return self._index__3I(*args)
    elif mosek_fusion_BoundInterfaceConstraint._match_alt_index__3I(*args):
      return self._index_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list index('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.BoundInterfaceConstraint.index(int32)\n\tmosek.fusion.BoundInterfaceConstraint.index(array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.BoundInterfaceConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2_3I_3IZ(m,shape,nativeidxs,islower):
    o = BoundInterfaceConstraint.__new__(BoundInterfaceConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(m,shape,nativeidxs,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2_3I_3IZ(*args):
    if len(args) != 4: return False
    m,shape,nativeidxs,islower, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(m) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2_3I_3IZ(*args):
    if len(args) != 4: return False
    m,shape,nativeidxs,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(m) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2_3I_3IZ(self,m,shape,nativeidxs,islower):
    self._ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(m,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),islower)
  def _ctor_init_Lmosek_4fusion_4Model_2_3I_3IZ(self,m,shape,nativeidxs,islower):
   mosek_fusion_SliceConstraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,m,shape,nativeidxs)
   (self.__islower) = islower
  @staticmethod
  def _ctor_Lmosek_4fusion_4SliceConstraint_2Z(c,islower):
    o = BoundInterfaceConstraint.__new__(BoundInterfaceConstraint)
    o._ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(c,islower)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4SliceConstraint_2Z(*args):
    if len(args) != 2: return False
    c,islower, = args
    return (__arg_match_Lmosek_4fusion_4SliceConstraint_2__(c) and __arg_match_Z__(islower))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4SliceConstraint_2Z(*args):
    if len(args) != 2: return False
    c,islower, = args
    return (__arg_alt_match_Lmosek_4fusion_4SliceConstraint_2__(c) and __arg_alt_match_Z__(islower))
  def _ctor_alt_init_Lmosek_4fusion_4SliceConstraint_2Z(self,c,islower):
    self._ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(c,islower)
  def _ctor_init_Lmosek_4fusion_4SliceConstraint_2Z(self,c,islower):
   mosek_fusion_SliceConstraint._ctor_init_Lmosek_4fusion_4SliceConstraint_2(self,c)
   (self.__islower) = islower
  @staticmethod
  def _match_dual_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_dual_(*args):
    if len(args) != 0: return False
    return True
  def _dual_alt_(self,):
    return self._dual_()
  def _dual_(self,):
   _0=numpy.zeros((self._getSize_(),), dtype=numpy.dtype(numpy.float64))
   self._dual_1lu_I_3DZ(0,_0,self.__islower)
   return (_0)
  @staticmethod
  def _match_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_slice__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  def _slice_alt__3I_3I(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = self._slice__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _slice__3I_3I(self,_0,_1):
   _2=mosek_fusion_Constraint._slice__3I_3I(self,_0,_1)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_2))
  @staticmethod
  def _match_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_slice_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _slice_alt_II(self,_t__0,_t__1):
    return self._slice_II(numpy.int32(__0),numpy.int32(__1))
  def _slice_II(self,_0,_1):
   _2=mosek_fusion_Constraint._slice_II(self,_0,_1)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_2))
  @staticmethod
  def _match_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_index__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _index_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._index__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _index__3I(self,_0):
   _1=mosek_fusion_Constraint._index__3I(self,_0)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_1))
  @staticmethod
  def _match_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_index_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _index_alt_I(self,_t__0):
    return self._index_I(numpy.int32(__0))
  def _index_I(self,_0):
   _1=mosek_fusion_Constraint._index_I(self,_0)
   return (self.__from_1_Lmosek_4fusion_4Constraint_2(_1))
  def __from_1_alt_Lmosek_4fusion_4Constraint_2(self,_t__0):
    return self.__from_1_Lmosek_4fusion_4Constraint_2(_0)
  def __from_1_Lmosek_4fusion_4Constraint_2(self,_0):
   _2=_0
   if   isinstance(_2,mosek_fusion_SliceConstraint):
    cc=_2
    return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4SliceConstraint_2Z(cc,self.__islower))
   else:
    cc=_2
    return (None)
 return BoundInterfaceConstraint
mosek_fusion_BoundInterfaceConstraint=__mk_mosek_fusion_BoundInterfaceConstraint()
del __mk_mosek_fusion_BoundInterfaceConstraint
#BEFORE CLASS
def __mk_mosek_fusion_ModelConstraint():
 class ModelConstraint(mosek_fusion_Constraint):
  __slots__ = ['_ModelConstraint__conid','_ModelConstraint__shape','_ModelConstraint__modelcon_nativeidxs','_ModelConstraint__name']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_ModelConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ModelConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.toString()')
  def remove(self,*args):
    if False: pass
    elif mosek_fusion_ModelConstraint._match_remove_(*args):
      return self._remove_(*args)
    elif mosek_fusion_ModelConstraint._match_alt_remove_(*args):
      return self._remove_alt_(*args)
    else:
      raise ValueError('Invalid argument list remove('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ModelConstraint.remove()')
  def __repr__(self): return 'mosek.fusion.ModelConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ModelConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Constraint_2Lmosek_4fusion_4Model_2(self,c,m)
   (self.__conid) = (c.__conid)
   self.__name = (c.__name)
   self.__modelcon_nativeidxs = (c.__modelcon_nativeidxs)
   self.__shape = (c.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nidxs,conid):
    o = ModelConstraint.__new__(ModelConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nidxs,conid)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nidxs,conid, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match__3I__(nidxs) and __arg_match_I__(conid))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nidxs,conid, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nidxs) and __arg_alt_match_I__(conid))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nidxs,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid):
   mosek_fusion_Constraint._ctor_init_Lmosek_4fusion_4Model_2_3I_3I(self,model,shape,nidxs)
   (self.__name) = name
   (self.__modelcon_nativeidxs) = nidxs
   (self.__shape) = shape
   (self.__conid) = conid
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("Constraint('")._a_S(self.__name)._a_S("')")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   pass
  @staticmethod
  def _match_remove_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_remove_(*args):
    if len(args) != 0: return False
    return True
  def _remove_alt_(self,):
    return self._remove_()
  def _remove_(self,):
   self._getModel_()._removeConstraintBlock_I(self.__conid)
 return ModelConstraint
mosek_fusion_ModelConstraint=__mk_mosek_fusion_ModelConstraint()
del __mk_mosek_fusion_ModelConstraint
#BEFORE CLASS
def __mk_mosek_fusion_LinearPSDConstraint():
 class LinearPSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_LinearPSDConstraint__conedim','_LinearPSDConstraint__shape','_LinearPSDConstraint__conid','_LinearPSDConstraint__slackidxs','_LinearPSDConstraint__nativeidxs']
  def __repr__(self): return 'mosek.fusion.LinearPSDConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearPSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__slackidxs = (c.__slackidxs)
   self.__nativeidxs = (c.__nativeidxs)
   self.__conedim = (c.__conedim)
   self.__shape = (c.__shape)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,conid,shape,conedim,nativeidxs,slackidxs):
    o = LinearPSDConstraint.__new__(LinearPSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,conid,shape,conedim,nativeidxs,slackidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(*args):
    if len(args) != 7: return False
    model,name,conid,shape,conedim,nativeidxs,slackidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match_I__(conedim) and __arg_match__3I__(nativeidxs) and __arg_match__3J__(slackidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3II_3I_3J(*args):
    if len(args) != 7: return False
    model,name,conid,shape,conedim,nativeidxs,slackidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match__3J__(slackidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(self,model,name,conid,shape,conedim,nativeidxs,slackidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(slackidxs,dtype=numpy.dtype(numpy.int64)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3II_3I_3J(self,model,name,conid,shape,conedim,nativeidxs,slackidxs):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid)
   (self.__conid) = conid
   (self.__slackidxs) = slackidxs
   (self.__nativeidxs) = nativeidxs
   (self.__conedim) = conedim
   (self.__shape) = shape
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   _2=mosek.fusion.Set._idxtokey__3IJ(self.__shape,_0)
   _1._a_S(" : element (")._a_I(_2[0])
   for _3 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(_2[_3])
   _1._a_S(") in a positive semi-definite cone of size (")._a_I(self.__shape[0])
   for _4 in range(1,int((_2).shape[0])):
    _1._a_S(",")._a_I(self.__shape[_4])
   _1._a_S(")")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearPSDConstraint._ctor_Lmosek_4fusion_4LinearPSDConstraint_2Lmosek_4fusion_4Model_2(self,_0))
 return LinearPSDConstraint
mosek_fusion_LinearPSDConstraint=__mk_mosek_fusion_LinearPSDConstraint()
del __mk_mosek_fusion_LinearPSDConstraint
#BEFORE CLASS
def __mk_mosek_fusion_PSDConstraint():
 class PSDConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_PSDConstraint__names_flushed','_PSDConstraint__conedim1','_PSDConstraint__conedim0','_PSDConstraint__shape','_PSDConstraint__name','_PSDConstraint__slackidxs','_PSDConstraint__nativeidxs','_PSDConstraint__conid']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_PSDConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_PSDConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.PSDConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__name = (c.__name)
   self.__shape = (c.__shape)
   self.__slackidxs = (c.__slackidxs)
   self.__nativeidxs = (c.__nativeidxs)
   self.__names_flushed = (c.__names_flushed)
   self.__conedim0 = (c.__conedim0)
   self.__conedim1 = (c.__conedim1)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
    o = PSDConstraint.__new__(PSDConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(*args):
    if len(args) != 8: return False
    model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match_I__(conedim0) and __arg_match_I__(conedim1) and __arg_match__3J__(slackidxs) and __arg_match__3I__(nativeidxs))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3III_3J_3I(*args):
    if len(args) != 8: return False
    model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conedim0) and __arg_alt_match_I__(conedim1) and __arg_alt_match__3J__(slackidxs) and __arg_alt_match__3I__(nativeidxs))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(self,model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim0),numpy.int32(conedim1),numpy.array(slackidxs,dtype=numpy.dtype(numpy.int64)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3III_3J_3I(self,model,name,conid,shape,conedim0,conedim1,slackidxs,nativeidxs):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,mosek.fusion.PSDConstraint.__computenidxs__3III_3I(shape,conedim0,conedim1,nativeidxs),conid)
   (self.__conid) = conid
   (self.__nativeidxs) = nativeidxs
   (self.__slackidxs) = slackidxs
   (self.__name) = name
   (self.__shape) = shape
   (self.__conedim0) = conedim0
   (self.__conedim1) = conedim1
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   raise mosek_fusion_UnimplementedError._ctor_S("PSDConstraint.toString not implemented")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_PSDConstraint._ctor_Lmosek_4fusion_4PSDConstraint_2Lmosek_4fusion_4Model_2(self,_0))
  @staticmethod
  def __computenidxs_alt__3III_3I(_t__0,_t__1,_t__2,_t__3):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int32(_t__1)
   _2=numpy.int32(_t__2)
   _3=numpy.array(_t__3,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_PSDConstraint.__computenidxs__3III_3I(_0,_1,_2,_3)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__3[:] = _3
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __computenidxs__3III_3I(_0,_1,_2,_3):
   _4=int((_0).shape[0])
   _5=(_1 < _2)
   _6=(_1 if (_5 ) else _2)
   _7=(_2 if (_5 ) else _1)
   _8=numpy.array([1,1,1,1,1], dtype=numpy.dtype(numpy.int32))
   _9=numpy.zeros((5,), dtype=numpy.dtype(numpy.int32))
   _10=1
   _10 = fragments._c_closure_262(_0,_10)
   _10 = numpy.int32(_10) # postprocess
   fragments._c_closure_263(_6,_8,_0) 
   _8[1] = _0[_6]
   fragments._c_closure_264(_6,_7,_8,_0) 
   _8[3] = _0[_7]
   fragments._c_closure_265(_7,_8,_4,_0) 
   _9[4] = 1
   fragments._c_closure_266(_8,_9) 
   _11=numpy.zeros((_10,), dtype=numpy.dtype(numpy.int32))
   _12=0
   _12 = fragments._c_closure_267(_8,_12,_3,_11,_9,_5)
   _12 = numpy.int32(_12) # postprocess
   return (_11)
 return PSDConstraint
mosek_fusion_PSDConstraint=__mk_mosek_fusion_PSDConstraint()
del __mk_mosek_fusion_PSDConstraint
#BEFORE CLASS
def __mk_mosek_fusion_RangedConstraint():
 class RangedConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_RangedConstraint__nativeidxs','_RangedConstraint__shape']
  def upperBoundCon(self,*args):
    if False: pass
    elif mosek_fusion_RangedConstraint._match_upperBoundCon_(*args):
      return self._upperBoundCon_(*args)
    elif mosek_fusion_RangedConstraint._match_alt_upperBoundCon_(*args):
      return self._upperBoundCon_alt_(*args)
    else:
      raise ValueError('Invalid argument list upperBoundCon('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedConstraint.upperBoundCon()')
  def lowerBoundCon(self,*args):
    if False: pass
    elif mosek_fusion_RangedConstraint._match_lowerBoundCon_(*args):
      return self._lowerBoundCon_(*args)
    elif mosek_fusion_RangedConstraint._match_alt_lowerBoundCon_(*args):
      return self._lowerBoundCon_alt_(*args)
    else:
      raise ValueError('Invalid argument list lowerBoundCon('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangedConstraint.lowerBoundCon()')
  def __repr__(self): return 'mosek.fusion.RangedConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = RangedConstraint.__new__(RangedConstraint)
    o._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4RangedConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangedConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__shape = (c.__shape)
   self.__nativeidxs = (c.__nativeidxs)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nativeidxs,conid):
    o = RangedConstraint.__new__(RangedConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,shape,nativeidxs,conid)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nativeidxs,conid, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match__3I__(shape) and __arg_match__3I__(nativeidxs) and __arg_match_I__(conid))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2S_3I_3II(*args):
    if len(args) != 5: return False
    model,name,shape,nativeidxs,conid, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match_I__(conid))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid):
    self._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(model,name,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid))
  def _ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nativeidxs,conid)
   (self.__shape) = shape
   (self.__nativeidxs) = nativeidxs
  @staticmethod
  def _match_upperBoundCon_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_upperBoundCon_(*args):
    if len(args) != 0: return False
    return True
  def _upperBoundCon_alt_(self,):
    return self._upperBoundCon_()
  def _upperBoundCon_(self,):
   return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3IZ(self._getModel_(),self.__shape,self.__nativeidxs,False))
  @staticmethod
  def _match_lowerBoundCon_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_lowerBoundCon_(*args):
    if len(args) != 0: return False
    return True
  def _lowerBoundCon_alt_(self,):
    return self._lowerBoundCon_()
  def _lowerBoundCon_(self,):
   return (mosek_fusion_BoundInterfaceConstraint._ctor_Lmosek_4fusion_4Model_2_3I_3IZ(self._getModel_(),self.__shape,self.__nativeidxs,True))
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_RangedConstraint._ctor_Lmosek_4fusion_4RangedConstraint_2Lmosek_4fusion_4Model_2(self,_0))
 return RangedConstraint
mosek_fusion_RangedConstraint=__mk_mosek_fusion_RangedConstraint()
del __mk_mosek_fusion_RangedConstraint
#BEFORE CLASS
def __mk_mosek_fusion_ConicConstraint():
 class ConicConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_ConicConstraint__indexnames','_ConicConstraint__nativeidxs','_ConicConstraint__names_flushed','_ConicConstraint__name','_ConicConstraint__shape','_ConicConstraint__dom','_ConicConstraint__conid']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_ConicConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_ConicConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConicConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.ConicConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = ConicConstraint.__new__(ConicConstraint)
    o._ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4ConicConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConicConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__dom = (c.__dom)
   self.__conid = (c.__conid)
   self.__shape = (c.__shape)
   self.__name = (c.__name)
   self.__nativeidxs = (c.__nativeidxs)
   self.__names_flushed = (c.__names_flushed)
   self.__indexnames = (c.__indexnames)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,shape,conid,nativeidxs,indexnames):
    o = ConicConstraint.__new__(ConicConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,shape,conid,nativeidxs,indexnames)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(*args):
    if len(args) != 7: return False
    model,name,dom,shape,conid,nativeidxs,indexnames, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_Lmosek_4fusion_4ConeDomain_2__(dom) and __arg_match__3I__(shape) and __arg_match_I__(conid) and __arg_match__3I__(nativeidxs) and __arg_match__3_3S__(indexnames))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(*args):
    if len(args) != 7: return False
    model,name,dom,shape,conid,nativeidxs,indexnames, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(dom) and __arg_alt_match__3I__(shape) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(nativeidxs) and __arg_alt_match__3_3S__(indexnames))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,model,name,dom,shape,conid,nativeidxs,indexnames):
    self._ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(model,name,dom,numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.int32(conid),numpy.array(nativeidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(indexnames,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4Model_2SLmosek_4fusion_4ConeDomain_2_3II_3I_3_3S(self,model,name,dom,shape,conid,nativeidxs,indexnames):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,numpy.array([(- (1 + nativeidxs[_0])) for _0 in range(0,int((nativeidxs).shape[0]))], dtype=numpy.dtype(numpy.int32)),(- (1 + conid)))
   (self.__dom) = dom
   (self.__shape) = shape
   (self.__name) = name
   (self.__nativeidxs) = nativeidxs
   (self.__indexnames) = indexnames
   (self.__conid) = conid
   self.__names_flushed = False
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("ConicConstraint('")._a_S(self.__name)._a_S("')")
   return (_0._toString_())
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   raise mosek_fusion_UnimplementedError._ctor_S("ConicConstraint.domainToString")
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_ConicConstraint._ctor_Lmosek_4fusion_4ConicConstraint_2Lmosek_4fusion_4Model_2(self,_0))
 return ConicConstraint
mosek_fusion_ConicConstraint=__mk_mosek_fusion_ConicConstraint()
del __mk_mosek_fusion_ConicConstraint
#BEFORE CLASS
def __mk_mosek_fusion_LinearConstraint():
 class LinearConstraint(mosek_fusion_ModelConstraint):
  __slots__ = ['_LinearConstraint__indexnames','_LinearConstraint__names_flushed','_LinearConstraint__nidxs','_LinearConstraint__name','_LinearConstraint__conid']
  def toString(self,*args):
    if False: pass
    elif mosek_fusion_LinearConstraint._match_toString_(*args):
      return self._toString_(*args)
    elif mosek_fusion_LinearConstraint._match_alt_toString_(*args):
      return self._toString_alt_(*args)
    else:
      raise ValueError('Invalid argument list toString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearConstraint.toString()')
  def __repr__(self): return 'mosek.fusion.LinearConstraint'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m):
    o = LinearConstraint.__new__(LinearConstraint)
    o._ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_match_Lmosek_4fusion_4LinearConstraint_2__(c) and __arg_match_Lmosek_4fusion_4Model_2__(m))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(*args):
    if len(args) != 2: return False
    c,m, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearConstraint_2__(c) and __arg_alt_match_Lmosek_4fusion_4Model_2__(m))
  def _ctor_alt_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
    self._ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(c,m)
  def _ctor_init_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,c,m):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4ModelConstraint_2Lmosek_4fusion_4Model_2(self,c,m)
   self.__conid = (c.__conid)
   self.__name = (c.__name)
   self.__nidxs = mosek.fusion.Utils.Tools._arraycopy__3I((c.__nidxs))
   self.__names_flushed = (c.__names_flushed)
   self.__indexnames = (c.__indexnames)
  @staticmethod
  def _ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,conid,shape,nidxs,indexnames):
    o = LinearConstraint.__new__(LinearConstraint)
    o._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,conid,shape,nidxs,indexnames)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(*args):
    if len(args) != 6: return False
    model,name,conid,shape,nidxs,indexnames, = args
    return (__arg_match_Lmosek_4fusion_4Model_2__(model) and __arg_match_S__(name) and __arg_match_I__(conid) and __arg_match__3I__(shape) and __arg_match__3I__(nidxs) and __arg_match__3_3S__(indexnames))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(*args):
    if len(args) != 6: return False
    model,name,conid,shape,nidxs,indexnames, = args
    return (__arg_alt_match_Lmosek_4fusion_4Model_2__(model) and __arg_alt_match_S__(name) and __arg_alt_match_I__(conid) and __arg_alt_match__3I__(shape) and __arg_alt_match__3I__(nidxs) and __arg_alt_match__3_3S__(indexnames))
  def _ctor_alt_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,model,name,conid,shape,nidxs,indexnames):
    self._ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(model,name,numpy.int32(conid),numpy.array(shape,dtype=numpy.dtype(numpy.int32)),numpy.array(nidxs,dtype=numpy.dtype(numpy.int32)),numpy.array(indexnames,dtype=numpy.dtype(object)))
  def _ctor_init_Lmosek_4fusion_4Model_2SI_3I_3I_3_3S(self,model,name,conid,shape,nidxs,indexnames):
   mosek_fusion_ModelConstraint._ctor_init_Lmosek_4fusion_4Model_2S_3I_3II(self,model,name,shape,nidxs,conid)
   (self.__nidxs) = nidxs
   (self.__conid) = conid
   (self.__name) = name
   (self.__names_flushed) = False
   (self.__indexnames) = indexnames
  @staticmethod
  def _match_toString_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_toString_(*args):
    if len(args) != 0: return False
    return True
  def _toString_alt_(self,):
    return self._toString_()
  def _toString_(self,):
   _0=mosek.fusion.Utils.StringBuffer()
   _0._a_S("LinearConstraint('")._a_S(self.__name)._a_S("')")
   return (_0._toString_())
  def _flushNames_alt_(self,):
    return self._flushNames_()
  def _flushNames_(self,):
   pass
  def _domainToString_alt_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_t__0,_t__1):
    return self._domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(numpy.int64(__0),_1)
  def _domainToString_JLmosek_4fusion_4Utils_4StringBuffer_2(self,_0,_1):
   pass
  def _clone_alt_Lmosek_4fusion_4Model_2(self,_t__0):
    return self._clone_Lmosek_4fusion_4Model_2(_0)
  def _clone_Lmosek_4fusion_4Model_2(self,_0):
   return (mosek_fusion_LinearConstraint._ctor_Lmosek_4fusion_4LinearConstraint_2Lmosek_4fusion_4Model_2(self,_0))
 return LinearConstraint
mosek_fusion_LinearConstraint=__mk_mosek_fusion_LinearConstraint()
del __mk_mosek_fusion_LinearConstraint
#BEFORE CLASS
def __mk_mosek_fusion_Set():
 class Set(object):
  @staticmethod
  def scalar(*args):
    if False: pass
    elif mosek_fusion_Set._match_scalar_(*args):
      return mosek_fusion_Set._scalar_(*args)
    elif mosek_fusion_Set._match_alt_scalar_(*args):
      return mosek_fusion_Set._scalar_alt_(*args)
    else:
      raise ValueError('Invalid argument list scalar('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.scalar()')
  @staticmethod
  def indexToKey(*args):
    if False: pass
    elif mosek_fusion_Set._match_indexToKey__3IJ_3I(*args):
      return mosek_fusion_Set._indexToKey__3IJ_3I(*args)
    elif mosek_fusion_Set._match_alt_indexToKey__3IJ_3I(*args):
      return mosek_fusion_Set._indexToKey_alt__3IJ_3I(*args)
    else:
      raise ValueError('Invalid argument list indexToKey('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.indexToKey(array(int32,ndim=1),int64,array(int32,ndim=1))')
  @staticmethod
  def indexToString(*args):
    if False: pass
    elif mosek_fusion_Set._match_indexToString__3IJ(*args):
      return mosek_fusion_Set._indexToString__3IJ(*args)
    elif mosek_fusion_Set._match_alt_indexToString__3IJ(*args):
      return mosek_fusion_Set._indexToString_alt__3IJ(*args)
    else:
      raise ValueError('Invalid argument list indexToString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.indexToString(array(int32,ndim=1),int64)')
  @staticmethod
  def make(*args):
    if False: pass
    elif mosek_fusion_Set._match_make__3S(*args):
      return mosek_fusion_Set._make__3S(*args)
    elif mosek_fusion_Set._match_alt_make__3S(*args):
      return mosek_fusion_Set._make_alt__3S(*args)
    elif mosek_fusion_Set._match_make_I(*args):
      return mosek_fusion_Set._make_I(*args)
    elif mosek_fusion_Set._match_alt_make_I(*args):
      return mosek_fusion_Set._make_alt_I(*args)
    elif mosek_fusion_Set._match_make__3I(*args):
      return mosek_fusion_Set._make__3I(*args)
    elif mosek_fusion_Set._match_alt_make__3I(*args):
      return mosek_fusion_Set._make_alt__3I(*args)
    elif mosek_fusion_Set._match_make__3I_3I(*args):
      return mosek_fusion_Set._make__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_make__3I_3I(*args):
      return mosek_fusion_Set._make_alt__3I_3I(*args)
    elif mosek_fusion_Set._match_make_II(*args):
      return mosek_fusion_Set._make_II(*args)
    elif mosek_fusion_Set._match_alt_make_II(*args):
      return mosek_fusion_Set._make_alt_II(*args)
    elif mosek_fusion_Set._match_make_III(*args):
      return mosek_fusion_Set._make_III(*args)
    elif mosek_fusion_Set._match_alt_make_III(*args):
      return mosek_fusion_Set._make_alt_III(*args)
    else:
      raise ValueError('Invalid argument list make('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.make(array(string,ndim=1))\n\tmosek.fusion.Set.make(int32)\n\tmosek.fusion.Set.make(array(int32,ndim=1))\n\tmosek.fusion.Set.make(array(int32,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Set.make(int32,int32)\n\tmosek.fusion.Set.make(int32,int32,int32)')
  @staticmethod
  def linearidx(*args):
    if False: pass
    elif mosek_fusion_Set._match_linearidx__3I_3I(*args):
      return mosek_fusion_Set._linearidx__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_linearidx__3I_3I(*args):
      return mosek_fusion_Set._linearidx_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list linearidx('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.linearidx(array(int32,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def size(*args):
    if False: pass
    elif mosek_fusion_Set._match_size__3I(*args):
      return mosek_fusion_Set._size__3I(*args)
    elif mosek_fusion_Set._match_alt_size__3I(*args):
      return mosek_fusion_Set._size_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list size('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.size(array(int32,ndim=1))')
  @staticmethod
  def strides(*args):
    if False: pass
    elif mosek_fusion_Set._match_strides__3I(*args):
      return mosek_fusion_Set._strides__3I(*args)
    elif mosek_fusion_Set._match_alt_strides__3I(*args):
      return mosek_fusion_Set._strides_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list strides('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.strides(array(int32,ndim=1))')
  @staticmethod
  def keyToString(*args):
    if False: pass
    elif mosek_fusion_Set._match_keyToString__3I(*args):
      return mosek_fusion_Set._keyToString__3I(*args)
    elif mosek_fusion_Set._match_alt_keyToString__3I(*args):
      return mosek_fusion_Set._keyToString_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list keyToString('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.keyToString(array(int32,ndim=1))')
  @staticmethod
  def idxtokey(*args):
    if False: pass
    elif mosek_fusion_Set._match_idxtokey__3IJ(*args):
      return mosek_fusion_Set._idxtokey__3IJ(*args)
    elif mosek_fusion_Set._match_alt_idxtokey__3IJ(*args):
      return mosek_fusion_Set._idxtokey_alt__3IJ(*args)
    elif mosek_fusion_Set._match_idxtokey__3IJ_3I(*args):
      return mosek_fusion_Set._idxtokey__3IJ_3I(*args)
    elif mosek_fusion_Set._match_alt_idxtokey__3IJ_3I(*args):
      return mosek_fusion_Set._idxtokey_alt__3IJ_3I(*args)
    else:
      raise ValueError('Invalid argument list idxtokey('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.idxtokey(array(int32,ndim=1),int64)\n\tmosek.fusion.Set.idxtokey(array(int32,ndim=1),int64,array(int32,ndim=1))')
  @staticmethod
  def match(*args):
    if False: pass
    elif mosek_fusion_Set._match_match__3I_3I(*args):
      return mosek_fusion_Set._match__3I_3I(*args)
    elif mosek_fusion_Set._match_alt_match__3I_3I(*args):
      return mosek_fusion_Set._match_alt__3I_3I(*args)
    else:
      raise ValueError('Invalid argument list match('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Set.match(array(int32,ndim=1),array(int32,ndim=1))')
  def __repr__(self): return 'mosek.fusion.Set'
  @staticmethod
  def _match_size__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_size__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _size_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._size__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _size__3I(_0):
   _1=1
   _1 = fragments._c_closure_268(_0,_1)
   _1 = numpy.int64(_1) # postprocess
   return numpy.int64(_1)
  @staticmethod
  def _match_match__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_match__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _match_alt__3I_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._match__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _match__3I_3I(_0,_1):
   if (int((_0).shape[0])!=int((_1).shape[0])):
    return (False)
   for _2 in range(0,int((_0).shape[0])):
    if (_0[_2]!=_1[_2]):
     return (False)
   return (True)
  @staticmethod
  def _match_linearidx__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_linearidx__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _linearidx_alt__3I_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._linearidx__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _linearidx__3I_3I(_0,_1):
   _2=_1[0]
   _2 = fragments._c_closure_269(_1,_2,_0)
   _2 = numpy.int64(_2) # postprocess
   return numpy.int64(_2)
  @staticmethod
  def _match_idxtokey__3IJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_J__(_1))
  @staticmethod
  def _match_alt_idxtokey__3IJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_J__(_1))
  @staticmethod
  def _idxtokey_alt__3IJ(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int64(_t__1)
   _1_res = mosek_fusion_Set._idxtokey__3IJ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _idxtokey__3IJ(_0,_1):
   _2=numpy.zeros((int((_0).shape[0]),), dtype=numpy.dtype(numpy.int32))
   mosek.fusion.Set._idxtokey__3IJ_3I(_0,_1,_2)
   return (_2)
  @staticmethod
  def _match_idxtokey__3IJ_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_idxtokey__3IJ_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _idxtokey_alt__3IJ_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._idxtokey__3IJ_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _idxtokey__3IJ_3I(_0,_1,_2):
   fragments._c_closure_270(_2,_1,_0) 
  @staticmethod
  def _match_indexToString__3IJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match_J__(_1))
  @staticmethod
  def _match_alt_indexToString__3IJ(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_J__(_1))
  @staticmethod
  def _indexToString_alt__3IJ(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int64(_t__1)
   _1_res = mosek_fusion_Set._indexToString__3IJ(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _indexToString__3IJ(_0,_1):
   _2=int((_0).shape[0])
   _3=mosek.fusion.Utils.StringBuffer()
   if (_2==0):
    return ("0")
   elif (_2==1):
    return (_3._a_J(_1)._toString_())
   else:
    _4=_1
    _5=numpy.zeros((_2,), dtype=numpy.dtype(numpy.int32))
    _4 = fragments._c_closure_271(_5,_2,_4,_0)
    _4 = numpy.int64(_4) # postprocess
    _5[0] = numpy.int32(_4)
    _3._a_I(_5[0])
    for _6 in range(1,_2):
     _3._a_S(",")._a_I(_5[_6])
    return (_3._toString_())
  @staticmethod
  def _match_keyToString__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_keyToString__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _keyToString_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._keyToString__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _keyToString__3I(_0):
   _1=mosek.fusion.Utils.StringBuffer()
   _1._a_I(_0[0])
   for _2 in range(1,int((_0).shape[0])):
    _1._a_S(",")._a_I(_0[_2])
   return (_1._toString_())
  @staticmethod
  def _match_indexToKey__3IJ_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match__3I__(_0) and __arg_match_J__(_1) and __arg_match__3I__(_2))
  @staticmethod
  def _match_alt_indexToKey__3IJ_3I(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match_J__(_1) and __arg_alt_match__3I__(_2))
  @staticmethod
  def _indexToKey_alt__3IJ_3I(_t__0,_t__1,_t__2):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.int64(_t__1)
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._indexToKey__3IJ_3I(_0,_1,_2)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _indexToKey__3IJ_3I(_0,_1,_2):
   fragments._c_closure_272(_1,_2,_0) 
  @staticmethod
  def _match_strides__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_strides__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _strides_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._strides__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _strides__3I(_0):
   _1=int((_0).shape[0])
   _2=numpy.zeros((_1,), dtype=numpy.dtype(numpy.int64))
   _2[(_1 - 1)] = 1
   fragments._c_closure_273(_1,_0,_2) 
   return (_2)
  @staticmethod
  def _match_make__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3I__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_make__3I_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3I__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _make_alt__3I_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._make__3I_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3I_3I(_0,_1):
   _2=numpy.zeros(((int((_0).shape[0]) + int((_1).shape[0])),), dtype=numpy.dtype(numpy.int32))
   fragments._c_closure_274(_2,_0) 
   fragments._c_closure_275(_2,_0,_1) 
   return (_2)
  @staticmethod
  def _match_make__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_make__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _make_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Set._make__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3I(_0):
   return (numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_make_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  @staticmethod
  def _make_alt_III(_t__0,_t__1,_t__2):
    return mosek_fusion_Set._make_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  @staticmethod
  def _make_III(_0,_1,_2):
   return (numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_make_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _make_alt_II(_t__0,_t__1):
    return mosek_fusion_Set._make_II(numpy.int32(__0),numpy.int32(__1))
  @staticmethod
  def _make_II(_0,_1):
   return (numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_make_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _make_alt_I(_t__0):
    return mosek_fusion_Set._make_I(numpy.int32(__0))
  @staticmethod
  def _make_I(_0):
   return (numpy.array([_0], dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_scalar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_scalar_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _scalar_alt_():
    return mosek_fusion_Set._scalar_()
  @staticmethod
  def _scalar_():
   return (numpy.zeros((0,), dtype=numpy.dtype(numpy.int32)))
  @staticmethod
  def _match_make__3S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3S__(_0))
  @staticmethod
  def _match_alt_make__3S(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3S__(_0))
  @staticmethod
  def _make_alt__3S(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1_res = mosek_fusion_Set._make__3S(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _make__3S(_0):
   return (numpy.array([int((_0).shape[0])], dtype=numpy.dtype(numpy.int32)))
 return Set
mosek_fusion_Set=__mk_mosek_fusion_Set()
del __mk_mosek_fusion_Set
#BEFORE CLASS
def __mk_mosek_fusion_ConeDomain():
 class ConeDomain(object):
  __slots__ = ['_indexnames','_domsize','_domofs','_alpha','_shape','_int_flag','_axisset','_axisidx','_key']
  def axisIsSet(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_axisIsSet_(*args):
      return self._axisIsSet_(*args)
    elif mosek_fusion_ConeDomain._match_alt_axisIsSet_(*args):
      return self._axisIsSet_alt_(*args)
    else:
      raise ValueError('Invalid argument list axisIsSet('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.axisIsSet()')
  def withNamesOnAxis(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis__3SI(*args)
    elif mosek_fusion_ConeDomain._match_alt_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis_alt__3SI(*args)
    else:
      raise ValueError('Invalid argument list withNamesOnAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.withNamesOnAxis(array(string,ndim=1),int32)')
  def getAxis(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_getAxis_(*args):
      return self._getAxis_(*args)
    elif mosek_fusion_ConeDomain._match_alt_getAxis_(*args):
      return self._getAxis_alt_(*args)
    else:
      raise ValueError('Invalid argument list getAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.getAxis()')
  def integral(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_integral_(*args):
      return self._integral_(*args)
    elif mosek_fusion_ConeDomain._match_alt_integral_(*args):
      return self._integral_alt_(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.integral()')
  def axis(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_axis_I(*args):
      return self._axis_I(*args)
    elif mosek_fusion_ConeDomain._match_alt_axis_I(*args):
      return self._axis_alt_I(*args)
    else:
      raise ValueError('Invalid argument list axis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.axis(int32)')
  def withShape(self,*args):
    if False: pass
    elif mosek_fusion_ConeDomain._match_withShape__3I(*args):
      return self._withShape__3I(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape__3I(*args):
      return self._withShape_alt__3I(*args)
    elif mosek_fusion_ConeDomain._match_withShape_I(*args):
      return self._withShape_I(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_I(*args):
      return self._withShape_alt_I(*args)
    elif mosek_fusion_ConeDomain._match_withShape_II(*args):
      return self._withShape_II(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_II(*args):
      return self._withShape_alt_II(*args)
    elif mosek_fusion_ConeDomain._match_withShape_III(*args):
      return self._withShape_III(*args)
    elif mosek_fusion_ConeDomain._match_alt_withShape_III(*args):
      return self._withShape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list withShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.ConeDomain.withShape(array(int32,ndim=1))\n\tmosek.fusion.ConeDomain.withShape(int32)\n\tmosek.fusion.ConeDomain.withShape(int32,int32)\n\tmosek.fusion.ConeDomain.withShape(int32,int32,int32)')
  def __repr__(self): return 'mosek.fusion.ConeDomain'
  @staticmethod
  def _ctor_Emosek_4fusion_4QConeKey_2_3D_3I(k,alpha,d):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(k,alpha,d)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4QConeKey_2_3D_3I(*args):
    if len(args) != 3: return False
    k,alpha,d, = args
    return (__arg_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_match__3D__(alpha) and __arg_match__3I__(d))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4QConeKey_2_3D_3I(*args):
    if len(args) != 3: return False
    k,alpha,d, = args
    return (__arg_alt_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_alt_match__3D__(alpha) and __arg_alt_match__3I__(d))
  def _ctor_alt_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,alpha,d):
    self._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(k,numpy.array(alpha,dtype=numpy.dtype(numpy.float64)),numpy.array(d,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,alpha,d):
   self._shape = (mosek.fusion.Utils.Tools._arraycopy__3I(d) if ((d is not None) ) else None)
   self._domsize = 0
   (self._alpha) = alpha
   self._key = k
   self._axisidx = 0
   self._axisset = False
   self._int_flag = False
   self._domofs = None
   self._indexnames = None
  @staticmethod
  def _ctor_Emosek_4fusion_4QConeKey_2_3I(k,d):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Emosek_4fusion_4QConeKey_2_3I(k,d)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4QConeKey_2_3I(*args):
    if len(args) != 2: return False
    k,d, = args
    return (__arg_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_match__3I__(d))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4QConeKey_2_3I(*args):
    if len(args) != 2: return False
    k,d, = args
    return (__arg_alt_match_Emosek_4fusion_4QConeKey_2__(k) and __arg_alt_match__3I__(d))
  def _ctor_alt_init_Emosek_4fusion_4QConeKey_2_3I(self,k,d):
    self._ctor_init_Emosek_4fusion_4QConeKey_2_3I(k,numpy.array(d,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4QConeKey_2_3I(self,k,d):
   mosek_fusion_ConeDomain._ctor_init_Emosek_4fusion_4QConeKey_2_3D_3I(self,k,None,d)
  @staticmethod
  def _ctor_Lmosek_4fusion_4ConeDomain_2(other):
    o = ConeDomain.__new__(ConeDomain)
    o._ctor_init_Lmosek_4fusion_4ConeDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4ConeDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4ConeDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4ConeDomain_2(self,other):
   self._key = (other._key)
   self._axisidx = (other._axisidx)
   self._axisset = (other._axisset)
   self._int_flag = (other._int_flag)
   self._shape = (other._shape)
   self._alpha = (other._alpha)
   self._domofs = (other._domofs)
   self._domsize = (other._domsize)
   self._indexnames = (other._indexnames)
  def _match_1shape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._match_1shape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _match_1shape__3I(self,_0):
   return (((self._shape is None) or mosek.fusion.Set._match__3I_3I(_0,self._shape)))
  @staticmethod
  def _match_integral_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_integral_(*args):
    if len(args) != 0: return False
    return True
  def _integral_alt_(self,):
    return self._integral_()
  def _integral_(self,):
   self._int_flag = True
   return (self)
  @staticmethod
  def _match_axisIsSet_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_axisIsSet_(*args):
    if len(args) != 0: return False
    return True
  def _axisIsSet_alt_(self,):
    return self._axisIsSet_()
  def _axisIsSet_(self,):
   return (self._axisset)
  @staticmethod
  def _match_getAxis_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_getAxis_(*args):
    if len(args) != 0: return False
    return True
  def _getAxis_alt_(self,):
    return self._getAxis_()
  def _getAxis_(self,):
   return numpy.int32(self._axisidx)
  @staticmethod
  def _match_axis_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_axis_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _axis_alt_I(self,_t__0):
    return self._axis_I(numpy.int32(__0))
  def _axis_I(self,_0):
   self._axisidx = _0
   self._axisset = True
   return (self)
  @staticmethod
  def _match_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _withShape_alt_III(self,_t__0,_t__1,_t__2):
    return self._withShape_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _withShape_III(self,_0,_1,_2):
   return (self.__withShape_1__3I(numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _withShape_alt_II(self,_t__0,_t__1):
    return self._withShape_II(numpy.int32(__0),numpy.int32(__1))
  def _withShape_II(self,_0,_1):
   return (self.__withShape_1__3I(numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _withShape_alt_I(self,_t__0):
    return self._withShape_I(numpy.int32(__0))
  def _withShape_I(self,_0):
   return (self.__withShape_1__3I(numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _withShape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._withShape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withShape__3I(self,_0):
   return (self.__withShape_1__3I(mosek.fusion.Utils.Tools._arraycopy__3I(_0)))
  def __withShape_1_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__withShape_1__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __withShape_1__3I(self,_0):
   self._shape = _0
   return (self)
  @staticmethod
  def _match_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3S__(_0) and __arg_alt_match_I__(_1))
  def _withNamesOnAxis_alt__3SI(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = self._withNamesOnAxis__3SI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withNamesOnAxis__3SI(self,_0,_1):
   if (_0 is None):
    self._indexnames = numpy.zeros(((_1 + 1),), dtype=numpy.dtype(object))
    self._indexnames[_1] = numpy.array([_0[_2] for _2 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   if (int((self._indexnames).shape[0]) < (_1 + 1)):
    _3=numpy.ndarray((_1,), dtype=numpy.dtype(object))
    for _4 in range(0,int((self._indexnames).shape[0])):
     _3[_4] = self._indexnames[_4]
    self._indexnames = _3
   self._indexnames[_1] = numpy.array([_0[_5] for _5 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   return (self)
  def __finalize_1and_1validate_1inplace_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__finalize_1and_1validate_1inplace__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __finalize_1and_1validate_1inplace__3I(self,_0):
   self._domsize = 1
   if (self._shape is None):
    if (_0 is not None):
     self._shape = _0
    else:
     raise mosek_fusion_DimensionError._ctor_S("Missing domain shape")
   elif (_0 is not None):
    if (int((_0).shape[0])!=int((self._shape).shape[0])):
     raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
    for _1 in range(0,int((_0).shape[0])):
     if (_0[_1]!=self._shape[_1]):
      raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
   self._domsize = fragments._c_closure_276(self._domsize,self._shape)
   self._domsize = numpy.int64(self._domsize) # postprocess
   if (self._indexnames is not None):
    if (int((self._indexnames).shape[0])!=int((self._shape).shape[0])):
     raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
    for _2 in range(0,int((self._shape).shape[0])):
     if ((self._indexnames[_2] is not None) and (int((self._indexnames[_2]).shape[0])!=self._shape[_2])):
      raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
   if (not self._axisset):
    self._axisset = True
    self._axisidx = (int((self._shape).shape[0]) - 1)
   elif ((self._axisidx < 0) or (self._axisidx >= int((self._shape).shape[0]))):
    raise mosek_fusion_DimensionError._ctor_S("Cone axis is invalid")
   if ((self._domofs is not None) and (int((self._domofs).shape[0])!=self._domsize)):
    raise mosek_fusion_DimensionError._ctor_S("Domain offset does not match shape")
  def _finalize_1and_1validate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._finalize_1and_1validate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _finalize_1and_1validate__3I(self,_0):
   _1=mosek_fusion_ConeDomain._ctor_Lmosek_4fusion_4ConeDomain_2(self)
   _1.__finalize_1and_1validate_1inplace__3I(_0)
   return (_1)
 return ConeDomain
mosek_fusion_ConeDomain=__mk_mosek_fusion_ConeDomain()
del __mk_mosek_fusion_ConeDomain
#BEFORE CLASS
def __mk_mosek_fusion_PSDDomain():
 class PSDDomain(object):
  __slots__ = ['_indexnames','_axisIsSet','_conedim2','_conedim1','_key','_shape']
  def axis(self,*args):
    if False: pass
    elif mosek_fusion_PSDDomain._match_axis_II(*args):
      return self._axis_II(*args)
    elif mosek_fusion_PSDDomain._match_alt_axis_II(*args):
      return self._axis_alt_II(*args)
    else:
      raise ValueError('Invalid argument list axis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDDomain.axis(int32,int32)')
  def withNamesOnAxis(self,*args):
    if False: pass
    elif mosek_fusion_PSDDomain._match_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis__3SI(*args)
    elif mosek_fusion_PSDDomain._match_alt_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis_alt__3SI(*args)
    else:
      raise ValueError('Invalid argument list withNamesOnAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.PSDDomain.withNamesOnAxis(array(string,ndim=1),int32)')
  def __repr__(self): return 'mosek.fusion.PSDDomain'
  @staticmethod
  def _ctor_Emosek_4fusion_4PSDKey_2_3III(k,shp,conedim1,conedim2):
    o = PSDDomain.__new__(PSDDomain)
    o._ctor_init_Emosek_4fusion_4PSDKey_2_3III(k,shp,conedim1,conedim2)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4PSDKey_2_3III(*args):
    if len(args) != 4: return False
    k,shp,conedim1,conedim2, = args
    return (__arg_match_Emosek_4fusion_4PSDKey_2__(k) and __arg_match__3I__(shp) and __arg_match_I__(conedim1) and __arg_match_I__(conedim2))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4PSDKey_2_3III(*args):
    if len(args) != 4: return False
    k,shp,conedim1,conedim2, = args
    return (__arg_alt_match_Emosek_4fusion_4PSDKey_2__(k) and __arg_alt_match__3I__(shp) and __arg_alt_match_I__(conedim1) and __arg_alt_match_I__(conedim2))
  def _ctor_alt_init_Emosek_4fusion_4PSDKey_2_3III(self,k,shp,conedim1,conedim2):
    self._ctor_init_Emosek_4fusion_4PSDKey_2_3III(k,numpy.array(shp,dtype=numpy.dtype(numpy.int32)),numpy.int32(conedim1),numpy.int32(conedim2))
  def _ctor_init_Emosek_4fusion_4PSDKey_2_3III(self,k,shp,conedim1,conedim2):
   self._axisIsSet = True
   self._shape = shp
   self._key = k
   (self._conedim1) = conedim1
   (self._conedim2) = conedim2
   self._indexnames = None
   _0=int((self._shape).shape[0])
   if ((not ((int((self._shape).shape[0]) > conedim1) and ((int((self._shape).shape[0]) > conedim2) and ((conedim1 >= 0) and ((conedim2 >= 0) and (conedim1!=conedim2)))))) and (self._shape[conedim1]==self._shape[conedim2])):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape or cone dimensions")
  @staticmethod
  def _ctor_Emosek_4fusion_4PSDKey_2_3I(k,shp):
    o = PSDDomain.__new__(PSDDomain)
    o._ctor_init_Emosek_4fusion_4PSDKey_2_3I(k,shp)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4PSDKey_2_3I(*args):
    if len(args) != 2: return False
    k,shp, = args
    return (__arg_match_Emosek_4fusion_4PSDKey_2__(k) and __arg_match__3I__(shp))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4PSDKey_2_3I(*args):
    if len(args) != 2: return False
    k,shp, = args
    return (__arg_alt_match_Emosek_4fusion_4PSDKey_2__(k) and __arg_alt_match__3I__(shp))
  def _ctor_alt_init_Emosek_4fusion_4PSDKey_2_3I(self,k,shp):
    self._ctor_init_Emosek_4fusion_4PSDKey_2_3I(k,numpy.array(shp,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4PSDKey_2_3I(self,k,shp):
   mosek_fusion_PSDDomain._ctor_init_Emosek_4fusion_4PSDKey_2_3III(self,k,shp,(int((shp).shape[0]) - 2),(int((shp).shape[0]) - 1))
  @staticmethod
  def _ctor_Emosek_4fusion_4PSDKey_2(k):
    o = PSDDomain.__new__(PSDDomain)
    o._ctor_init_Emosek_4fusion_4PSDKey_2(k)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4PSDKey_2(*args):
    if len(args) != 1: return False
    k, = args
    return (__arg_match_Emosek_4fusion_4PSDKey_2__(k))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4PSDKey_2(*args):
    if len(args) != 1: return False
    k, = args
    return (__arg_alt_match_Emosek_4fusion_4PSDKey_2__(k))
  def _ctor_alt_init_Emosek_4fusion_4PSDKey_2(self,k):
    self._ctor_init_Emosek_4fusion_4PSDKey_2(k)
  def _ctor_init_Emosek_4fusion_4PSDKey_2(self,k):
   self._shape = None
   self._key = k
   self._conedim1 = 0
   self._conedim2 = 0
   self._axisIsSet = False
   self._indexnames = None
  @staticmethod
  def _ctor_Lmosek_4fusion_4PSDDomain_2(other):
    o = PSDDomain.__new__(PSDDomain)
    o._ctor_init_Lmosek_4fusion_4PSDDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4PSDDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4PSDDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4PSDDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4PSDDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4PSDDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4PSDDomain_2(self,other):
   self._shape = (other._shape)
   self._key = (other._key)
   self._conedim1 = (other._conedim1)
   self._conedim2 = (other._conedim2)
   self._axisIsSet = (other._axisIsSet)
   self._indexnames = (other._indexnames)
  @staticmethod
  def _match_axis_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_axis_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _axis_alt_II(self,_t__0,_t__1):
    return self._axis_II(numpy.int32(__0),numpy.int32(__1))
  def _axis_II(self,_0,_1):
   (self._conedim1) = _0
   (self._conedim2) = _1
   self._axisIsSet = True
   if ((self._shape is None) and (not ((_0 >= 0) and ((_1 >= 0) and (_0!=_1))))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape or cone dimensions")
   elif ((self._shape is not None) and ((not ((int((self._shape).shape[0]) > _0) and ((int((self._shape).shape[0]) > _1) and ((_0 >= 0) and ((_1 >= 0) and (_0!=_1)))))) and (self._shape[_0]==self._shape[_1]))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching shape or cone dimensions")
   return (self)
  @staticmethod
  def _match_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3S__(_0) and __arg_alt_match_I__(_1))
  def _withNamesOnAxis_alt__3SI(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = self._withNamesOnAxis__3SI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withNamesOnAxis__3SI(self,_0,_1):
   if (self._indexnames is None):
    self._indexnames = _monty.initJaggedArray([None for _2 in range(0,(_1 + 1))], 1)
    self._indexnames[_1] = numpy.array([_0[_3] for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   if (int((self._indexnames).shape[0]) < (_1 + 1)):
    _4=_monty.initJaggedArray([None for _5 in range(0,(_1 + 1))], 1)
    for _6 in range(0,int((self._indexnames).shape[0])):
     _4[_6] = self._indexnames[_6]
    self._indexnames = _4
   self._indexnames[_1] = numpy.array([_0[_7] for _7 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   return (self)
  def __finalize_1and_1validate_1inplace_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__finalize_1and_1validate_1inplace__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __finalize_1and_1validate_1inplace__3I(self,_0):
   if (_0 is not None):
    if (self._shape is None):
     self._shape = _0
    else:
     if (int((_0).shape[0])!=int((self._shape).shape[0])):
      raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
     for _1 in range(0,int((_0).shape[0])):
      if (_0[_1]!=self._shape[_1]):
       raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
   if (int((self._shape).shape[0]) < 2):
    raise mosek_fusion_DimensionError._ctor_S("Positive semidefinite domain must have at least two dimensions")
   if (not self._axisIsSet):
    self._conedim1 = (int((self._shape).shape[0]) - 2)
    self._conedim2 = (int((self._shape).shape[0]) - 1)
   if ((self._conedim1 < 0) or ((self._conedim1 >= int((self._shape).shape[0])) or ((self._conedim2 < 0) or ((self._conedim2 >= int((self._shape).shape[0])) or (self._conedim1==self._conedim2))))):
    raise mosek_fusion_DimensionError._ctor_S("Invalid cone dimension specification")
   if (self._shape[self._conedim1]!=self._shape[self._conedim2]):
    raise mosek_fusion_DimensionError._ctor_S("Cone dimensions must have same size")
   if (self._indexnames is not None):
    if (int((self._indexnames).shape[0])!=int((self._shape).shape[0])):
     raise mosek_fusion_DimensionError._ctor_S("Index names do not match the domain shape")
    else:
     for _2 in range(0,int((self._shape).shape[0])):
      if ((self._indexnames[_2] is not None) and (int((self._indexnames[_2]).shape[0])!=self._shape[_2])):
       raise mosek_fusion_DimensionError._ctor_S("Index names do not match the domain shape")
  def _finalize_1and_1validate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._finalize_1and_1validate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _finalize_1and_1validate__3I(self,_0):
   _1=mosek_fusion_PSDDomain._ctor_Lmosek_4fusion_4PSDDomain_2(self)
   _1.__finalize_1and_1validate_1inplace__3I(_0)
   return (_1)
 return PSDDomain
mosek_fusion_PSDDomain=__mk_mosek_fusion_PSDDomain()
del __mk_mosek_fusion_PSDDomain
#BEFORE CLASS
def __mk_mosek_fusion_RangeDomain():
 class RangeDomain(object):
  __slots__ = ['_domsize','_nelements','_indexnames','_cardinal_flag','_scalable','_ub','_lb','_sparsity','_empty','_shape']
  def symmetric(self,*args):
    if False: pass
    elif mosek_fusion_RangeDomain._match_symmetric_(*args):
      return self._symmetric_(*args)
    elif mosek_fusion_RangeDomain._match_alt_symmetric_(*args):
      return self._symmetric_alt_(*args)
    else:
      raise ValueError('Invalid argument list symmetric('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangeDomain.symmetric()')
  def withNamesOnAxis(self,*args):
    if False: pass
    elif mosek_fusion_RangeDomain._match_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis__3SI(*args)
    elif mosek_fusion_RangeDomain._match_alt_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis_alt__3SI(*args)
    else:
      raise ValueError('Invalid argument list withNamesOnAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangeDomain.withNamesOnAxis(array(string,ndim=1),int32)')
  def integral(self,*args):
    if False: pass
    elif mosek_fusion_RangeDomain._match_integral_(*args):
      return self._integral_(*args)
    elif mosek_fusion_RangeDomain._match_alt_integral_(*args):
      return self._integral_alt_(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangeDomain.integral()')
  def sparse(self,*args):
    if False: pass
    elif mosek_fusion_RangeDomain._match_sparse_(*args):
      return self._sparse_(*args)
    elif mosek_fusion_RangeDomain._match_alt_sparse_(*args):
      return self._sparse_alt_(*args)
    elif mosek_fusion_RangeDomain._match_sparse__3I(*args):
      return self._sparse__3I(*args)
    elif mosek_fusion_RangeDomain._match_alt_sparse__3I(*args):
      return self._sparse_alt__3I(*args)
    elif mosek_fusion_RangeDomain._match_sparse__3_5I(*args):
      return self._sparse__3_5I(*args)
    elif mosek_fusion_RangeDomain._match_alt_sparse__3_5I(*args):
      return self._sparse_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list sparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangeDomain.sparse()\n\tmosek.fusion.RangeDomain.sparse(array(int32,ndim=1))\n\tmosek.fusion.RangeDomain.sparse(array(int32,ndim=2))')
  def withShape(self,*args):
    if False: pass
    elif mosek_fusion_RangeDomain._match_withShape__3I(*args):
      return self._withShape__3I(*args)
    elif mosek_fusion_RangeDomain._match_alt_withShape__3I(*args):
      return self._withShape_alt__3I(*args)
    elif mosek_fusion_RangeDomain._match_withShape_I(*args):
      return self._withShape_I(*args)
    elif mosek_fusion_RangeDomain._match_alt_withShape_I(*args):
      return self._withShape_alt_I(*args)
    elif mosek_fusion_RangeDomain._match_withShape_II(*args):
      return self._withShape_II(*args)
    elif mosek_fusion_RangeDomain._match_alt_withShape_II(*args):
      return self._withShape_alt_II(*args)
    elif mosek_fusion_RangeDomain._match_withShape_III(*args):
      return self._withShape_III(*args)
    elif mosek_fusion_RangeDomain._match_alt_withShape_III(*args):
      return self._withShape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list withShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.RangeDomain.withShape(array(int32,ndim=1))\n\tmosek.fusion.RangeDomain.withShape(int32)\n\tmosek.fusion.RangeDomain.withShape(int32,int32)\n\tmosek.fusion.RangeDomain.withShape(int32,int32,int32)')
  def __repr__(self): return 'mosek.fusion.RangeDomain'
  @staticmethod
  def _ctor_Z_3D_3D_3I(scalable,lb,ub,dims):
    o = RangeDomain.__new__(RangeDomain)
    o._ctor_init_Z_3D_3D_3I(scalable,lb,ub,dims)
    return o
  @staticmethod
  def __match_ctor_Z_3D_3D_3I(*args):
    if len(args) != 4: return False
    scalable,lb,ub,dims, = args
    return (__arg_match_Z__(scalable) and __arg_match__3D__(lb) and __arg_match__3D__(ub) and __arg_match__3I__(dims))
  @staticmethod
  def __match_alt_ctor_Z_3D_3D_3I(*args):
    if len(args) != 4: return False
    scalable,lb,ub,dims, = args
    return (__arg_alt_match_Z__(scalable) and __arg_alt_match__3D__(lb) and __arg_alt_match__3D__(ub) and __arg_alt_match__3I__(dims))
  def _ctor_alt_init_Z_3D_3D_3I(self,scalable,lb,ub,dims):
    self._ctor_init_Z_3D_3D_3I(scalable,numpy.array(lb,dtype=numpy.dtype(numpy.float64)),numpy.array(ub,dtype=numpy.dtype(numpy.float64)),numpy.array(dims,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Z_3D_3D_3I(self,scalable,lb,ub,dims):
   mosek_fusion_RangeDomain._ctor_init_Z_3D_3D_3I_3_5II(self,scalable,lb,ub,dims,None,1)
  @staticmethod
  def _ctor_ZDD_3I(scalable,lb,ub,dims):
    o = RangeDomain.__new__(RangeDomain)
    o._ctor_init_ZDD_3I(scalable,lb,ub,dims)
    return o
  @staticmethod
  def __match_ctor_ZDD_3I(*args):
    if len(args) != 4: return False
    scalable,lb,ub,dims, = args
    return (__arg_match_Z__(scalable) and __arg_match_D__(lb) and __arg_match_D__(ub) and __arg_match__3I__(dims))
  @staticmethod
  def __match_alt_ctor_ZDD_3I(*args):
    if len(args) != 4: return False
    scalable,lb,ub,dims, = args
    return (__arg_alt_match_Z__(scalable) and __arg_alt_match_D__(lb) and __arg_alt_match_D__(ub) and __arg_alt_match__3I__(dims))
  def _ctor_alt_init_ZDD_3I(self,scalable,lb,ub,dims):
    self._ctor_init_ZDD_3I(scalable,numpy.float64(lb),numpy.float64(ub),numpy.array(dims,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_ZDD_3I(self,scalable,lb,ub,dims):
   self._cardinal_flag = False
   self._shape = dims
   self._sparsity = None
   (self._scalable) = scalable
   _0=1
   _0 = fragments._c_closure_277(dims,_0)
   _0 = numpy.int32(_0) # postprocess
   (self._ub) = numpy.array([ub for _1 in range(0,_0)], dtype=numpy.dtype(numpy.float64))
   (self._lb) = numpy.array([lb for _2 in range(0,_0)], dtype=numpy.dtype(numpy.float64))
   (self._empty) = False
   (self._indexnames) = None
   (self._domsize) = 0
   (self._nelements) = 0
  @staticmethod
  def _ctor_Z_3D_3D_3I_3_5I(scalable,lb,ub,dims,sp):
    o = RangeDomain.__new__(RangeDomain)
    o._ctor_init_Z_3D_3D_3I_3_5I(scalable,lb,ub,dims,sp)
    return o
  @staticmethod
  def __match_ctor_Z_3D_3D_3I_3_5I(*args):
    if len(args) != 5: return False
    scalable,lb,ub,dims,sp, = args
    return (__arg_match_Z__(scalable) and __arg_match__3D__(lb) and __arg_match__3D__(ub) and __arg_match__3I__(dims) and __arg_match__3_5I__(sp))
  @staticmethod
  def __match_alt_ctor_Z_3D_3D_3I_3_5I(*args):
    if len(args) != 5: return False
    scalable,lb,ub,dims,sp, = args
    return (__arg_alt_match_Z__(scalable) and __arg_alt_match__3D__(lb) and __arg_alt_match__3D__(ub) and __arg_alt_match__3I__(dims) and __arg_alt_match__3_5I__(sp))
  def _ctor_alt_init_Z_3D_3D_3I_3_5I(self,scalable,lb,ub,dims,sp):
    self._ctor_init_Z_3D_3D_3I_3_5I(scalable,numpy.array(lb,dtype=numpy.dtype(numpy.float64)),numpy.array(ub,dtype=numpy.dtype(numpy.float64)),numpy.array(dims,dtype=numpy.dtype(numpy.int32)),numpy.array(sp,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Z_3D_3D_3I_3_5I(self,scalable,lb,ub,dims,sp):
   mosek_fusion_RangeDomain._ctor_init_Z_3D_3D_3I_3_5II(self,scalable,lb,ub,dims,sp,1)
  @staticmethod
  def _ctor_Z_3D_3D_3I_3_5II(scalable,lb,ub,dims,sp,steal):
    o = RangeDomain.__new__(RangeDomain)
    o._ctor_init_Z_3D_3D_3I_3_5II(scalable,lb,ub,dims,sp,steal)
    return o
  @staticmethod
  def __match_ctor_Z_3D_3D_3I_3_5II(*args):
    if len(args) != 6: return False
    scalable,lb,ub,dims,sp,steal, = args
    return (__arg_match_Z__(scalable) and __arg_match__3D__(lb) and __arg_match__3D__(ub) and __arg_match__3I__(dims) and __arg_match__3_5I__(sp) and __arg_match_I__(steal))
  @staticmethod
  def __match_alt_ctor_Z_3D_3D_3I_3_5II(*args):
    if len(args) != 6: return False
    scalable,lb,ub,dims,sp,steal, = args
    return (__arg_alt_match_Z__(scalable) and __arg_alt_match__3D__(lb) and __arg_alt_match__3D__(ub) and __arg_alt_match__3I__(dims) and __arg_alt_match__3_5I__(sp) and __arg_alt_match_I__(steal))
  def _ctor_alt_init_Z_3D_3D_3I_3_5II(self,scalable,lb,ub,dims,sp,steal):
    self._ctor_init_Z_3D_3D_3I_3_5II(scalable,numpy.array(lb,dtype=numpy.dtype(numpy.float64)),numpy.array(ub,dtype=numpy.dtype(numpy.float64)),numpy.array(dims,dtype=numpy.dtype(numpy.int32)),numpy.array(sp,dtype=numpy.dtype(numpy.int32)),numpy.int32(steal))
  def _ctor_init_Z_3D_3D_3I_3_5II(self,scalable,lb,ub,dims,sp,steal):
   self._cardinal_flag = False
   self._shape = dims
   self._sparsity = None
   (self._scalable) = scalable
   (self._ub) = ub
   (self._lb) = lb
   (self._sparsity) = sp
   (self._empty) = False
   (self._indexnames) = None
   (self._domsize) = 0
   (self._nelements) = 0
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangeDomain_2(other):
    o = RangeDomain.__new__(RangeDomain)
    o._ctor_init_Lmosek_4fusion_4RangeDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4RangeDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4RangeDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4RangeDomain_2(self,other):
   self._cardinal_flag = (other._cardinal_flag)
   self._sparsity = (other._sparsity)
   self._scalable = (other._scalable)
   self._shape = (other._shape)
   self._ub = (other._ub)
   self._lb = (other._lb)
   self._domsize = (other._domsize)
   self._nelements = (other._nelements)
   self._empty = (other._empty)
   self._indexnames = (_monty.initJaggedArray([(other._indexnames)[_0] for _0 in range(0,int(((other._indexnames)).shape[0]))], 1) if (((other._indexnames) is not None) ) else None)
  @staticmethod
  def _match_symmetric_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_symmetric_(*args):
    if len(args) != 0: return False
    return True
  def _symmetric_alt_(self,):
    return self._symmetric_()
  def _symmetric_(self,):
   return (mosek_fusion_SymmetricRangeDomain._ctor_Lmosek_4fusion_4RangeDomain_2(self))
  @staticmethod
  def _match_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _sparse_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3_5I(_0)
   return _1_res
  def _sparse__3_5I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),int((_0).shape[1]),), dtype=numpy.dtype(numpy.int32))
   _1=0
   while (_1 < int((_0).shape[0])):
    _2=0
    while (_2 < int((_0).shape[1])):
     (self._sparsity)[_1,_2] = _0[_1,_2]
     _2 += 1
    _1 += 1
   return (self)
  @staticmethod
  def _match_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _sparse_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _sparse__3I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),1,), dtype=numpy.dtype(numpy.int32))
   for _1 in range(0,int((_0).shape[0])):
    (self._sparsity)[_1,0] = _0[_1]
   return (self)
  @staticmethod
  def _match_sparse_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_sparse_(*args):
    if len(args) != 0: return False
    return True
  def _sparse_alt_(self,):
    return self._sparse_()
  def _sparse_(self,):
   (self._empty) = True
   (self._sparsity) = None
   return (self)
  @staticmethod
  def _match_integral_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_integral_(*args):
    if len(args) != 0: return False
    return True
  def _integral_alt_(self,):
    return self._integral_()
  def _integral_(self,):
   self._cardinal_flag = True
   return (self)
  @staticmethod
  def _match_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _withShape_alt_III(self,_t__0,_t__1,_t__2):
    return self._withShape_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _withShape_III(self,_0,_1,_2):
   self._shape = numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _withShape_alt_II(self,_t__0,_t__1):
    return self._withShape_II(numpy.int32(__0),numpy.int32(__1))
  def _withShape_II(self,_0,_1):
   self._shape = numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _withShape_alt_I(self,_t__0):
    return self._withShape_I(numpy.int32(__0))
  def _withShape_I(self,_0):
   self._shape = numpy.array([_0], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _withShape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._withShape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withShape__3I(self,_0):
   self._shape = _0
   return (self)
  @staticmethod
  def _match_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3S__(_0) and __arg_alt_match_I__(_1))
  def _withNamesOnAxis_alt__3SI(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = self._withNamesOnAxis__3SI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withNamesOnAxis__3SI(self,_0,_1):
   if (self._indexnames is None):
    self._indexnames = _monty.initJaggedArray([None for _2 in range(0,(_1 + 1))], 1)
    self._indexnames[_1] = numpy.array([_0[_3] for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   if (int((self._indexnames).shape[0]) < (_1 + 1)):
    _4=_monty.initJaggedArray([None for _5 in range(0,(_1 + 1))], 1)
    for _6 in range(0,int((self._indexnames).shape[0])):
     _4[_6] = self._indexnames[_6]
    self._indexnames = _4
   self._indexnames[_1] = numpy.array([_0[_7] for _7 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   return (self)
  def _match_1shape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._match_1shape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _match_1shape__3I(self,_0):
   if self._scalable:
    return (True)
   elif (int((self._shape).shape[0])!=int((_0).shape[0])):
    return (False)
   else:
    for _1 in range(0,int((self._shape).shape[0])):
     if (self._shape[_1]!=_0[_1]):
      return (False)
   return (True)
  def __finalize_1and_1validate_1inplace_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__finalize_1and_1validate_1inplace__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __finalize_1and_1validate_1inplace__3I(self,_0):
   self._domsize = 1
   if self._scalable:
    if (_0 is not None):
     self._shape = _0
    else:
     self._shape = numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))
    self._domsize = fragments._c_closure_278(self._domsize,self._shape)
    self._domsize = numpy.int64(self._domsize) # postprocess
   else:
    if (_0 is not None):
     if (int((_0).shape[0])!=int((self._shape).shape[0])):
      raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
     for _1 in range(0,int((_0).shape[0])):
      if (_0[_1]!=self._shape[_1]):
       raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
    self._domsize = fragments._c_closure_279(self._domsize,self._shape)
    self._domsize = numpy.int64(self._domsize) # postprocess
   if (self._indexnames is not None):
    if (int((self._indexnames).shape[0])!=int((self._shape).shape[0])):
     raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
    for _2 in range(0,int((self._shape).shape[0])):
     if ((self._indexnames[_2] is not None) and (int((self._indexnames[_2]).shape[0])!=self._shape[_2])):
      raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
   if (self._sparsity is not None):
    self._nelements = int((self._sparsity).shape[0])
    if (int((self._shape).shape[0])!=int((self._sparsity).shape[1])):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and sparsity pattern")
    for _3 in range(0,self._nelements):
     for _4 in range(0,int((self._sparsity).shape[1])):
      if ((self._sparsity[_3,_4] < 0) or (self._sparsity[_3,_4] >= self._shape[_4])):
       raise mosek_fusion_DimensionError._ctor_S("Sparsity pattern entry is out of bounds")
    if ((not self._scalable) and ((self._lb is not None) and (int((self._lb).shape[0])!=self._nelements))):
     raise mosek_fusion_DimensionError._ctor_S("Sparsity pattern does not match bound")
    if ((not self._scalable) and ((self._ub is not None) and (int((self._ub).shape[0])!=self._nelements))):
     raise mosek_fusion_DimensionError._ctor_S("Sparsity pattern does not match bound")
   else:
    self._nelements = self._domsize
    if ((self._lb is not None) and (not self._scalable)):
     if (int((self._lb).shape[0])!=self._nelements):
      raise mosek_fusion_DimensionError._ctor_S("Domain bound does not match shape")
    if ((self._ub is not None) and (not self._scalable)):
     if (int((self._ub).shape[0])!=self._nelements):
      raise mosek_fusion_DimensionError._ctor_S("Domain bound does not match shape")
  def _finalize_1and_1validate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._finalize_1and_1validate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _finalize_1and_1validate__3I(self,_0):
   _1=mosek_fusion_RangeDomain._ctor_Lmosek_4fusion_4RangeDomain_2(self)
   _1.__finalize_1and_1validate_1inplace__3I(_0)
   return (_1)
 return RangeDomain
mosek_fusion_RangeDomain=__mk_mosek_fusion_RangeDomain()
del __mk_mosek_fusion_RangeDomain
#BEFORE CLASS
def __mk_mosek_fusion_SymmetricRangeDomain():
 class SymmetricRangeDomain(mosek_fusion_RangeDomain):
  __slots__ = ['_dim']
  def __repr__(self): return 'mosek.fusion.SymmetricRangeDomain'
  @staticmethod
  def _ctor_Lmosek_4fusion_4RangeDomain_2(other):
    o = SymmetricRangeDomain.__new__(SymmetricRangeDomain)
    o._ctor_init_Lmosek_4fusion_4RangeDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4RangeDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4RangeDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4RangeDomain_2(self,other):
   mosek_fusion_RangeDomain._ctor_init_Lmosek_4fusion_4RangeDomain_2(self,other)
   if ((self._shape is not None) and ((int((self._shape).shape[0])!=2) or (self._shape[0]!=self._shape[1]))):
    raise mosek_fusion_DimensionError._ctor_S("Only square domains can be symmetric")
   self._dim = (0 if ((self._shape is None) ) else self._shape[0])
 return SymmetricRangeDomain
mosek_fusion_SymmetricRangeDomain=__mk_mosek_fusion_SymmetricRangeDomain()
del __mk_mosek_fusion_SymmetricRangeDomain
#BEFORE CLASS
def __mk_mosek_fusion_SymmetricLinearDomain():
 class SymmetricLinearDomain(object):
  __slots__ = ['_sparsity','_cardinal_flag','_key','_shape','_dom','_dim']
  def sparse(self,*args):
    if False: pass
    elif mosek_fusion_SymmetricLinearDomain._match_sparse__3I(*args):
      return self._sparse__3I(*args)
    elif mosek_fusion_SymmetricLinearDomain._match_alt_sparse__3I(*args):
      return self._sparse_alt__3I(*args)
    elif mosek_fusion_SymmetricLinearDomain._match_sparse__3_5I(*args):
      return self._sparse__3_5I(*args)
    elif mosek_fusion_SymmetricLinearDomain._match_alt_sparse__3_5I(*args):
      return self._sparse_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list sparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymmetricLinearDomain.sparse(array(int32,ndim=1))\n\tmosek.fusion.SymmetricLinearDomain.sparse(array(int32,ndim=2))')
  def integral(self,*args):
    if False: pass
    elif mosek_fusion_SymmetricLinearDomain._match_integral_(*args):
      return self._integral_(*args)
    elif mosek_fusion_SymmetricLinearDomain._match_alt_integral_(*args):
      return self._integral_alt_(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.SymmetricLinearDomain.integral()')
  def __repr__(self): return 'mosek.fusion.SymmetricLinearDomain'
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearDomain_2(other):
    o = SymmetricLinearDomain.__new__(SymmetricLinearDomain)
    o._ctor_init_Lmosek_4fusion_4LinearDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4LinearDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4LinearDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4LinearDomain_2(self,other):
   self._dom = other
   self._shape = (other._shape)
   self._key = (other._key)
   self._cardinal_flag = (other._cardinal_flag)
   self._sparsity = (other._sparsity)
   if ((self._shape is not None) and ((int((self._shape).shape[0])!=2) or (self._shape[0]!=self._shape[1]))):
    raise mosek_fusion_DimensionError._ctor_S("Only square domains can be symmetric")
   self._dim = (0 if ((self._shape is None) ) else self._shape[0])
  @staticmethod
  def _match_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _sparse_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3_5I(_0)
   return _1_res
  def _sparse__3_5I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),int((_0).shape[1]),), dtype=numpy.dtype(numpy.int32))
   _1=0
   while (_1 < int((_0).shape[0])):
    _2=0
    while (_2 < int((_0).shape[1])):
     (self._sparsity)[_1,_2] = _0[_1,_2]
     _2 += 1
    _1 += 1
   return (self)
  @staticmethod
  def _match_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _sparse_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _sparse__3I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),1,), dtype=numpy.dtype(numpy.int32))
   for _1 in range(0,int((_0).shape[0])):
    (self._sparsity)[_1,0] = _0[_1]
   return (self)
  @staticmethod
  def _match_integral_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_integral_(*args):
    if len(args) != 0: return False
    return True
  def _integral_alt_(self,):
    return self._integral_()
  def _integral_(self,):
   self._cardinal_flag = True
   return (self)
  def _match_1shape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._match_1shape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _match_1shape__3I(self,_0):
   for _1 in range(0,int((_0).shape[0])):
    if (_0[_1]==self._shape[_1]):
     return (False)
   return (True)
 return SymmetricLinearDomain
mosek_fusion_SymmetricLinearDomain=__mk_mosek_fusion_SymmetricLinearDomain()
del __mk_mosek_fusion_SymmetricLinearDomain
#BEFORE CLASS
def __mk_mosek_fusion_LinearDomain():
 class LinearDomain(object):
  __slots__ = ['_nelements','_domsize','_indexnames','_empty','_scalable','_sparsity','_cardinal_flag','_key','_bnd','_shape']
  def integral(self,*args):
    if False: pass
    elif mosek_fusion_LinearDomain._match_integral_(*args):
      return self._integral_(*args)
    elif mosek_fusion_LinearDomain._match_alt_integral_(*args):
      return self._integral_alt_(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearDomain.integral()')
  def withNamesOnAxis(self,*args):
    if False: pass
    elif mosek_fusion_LinearDomain._match_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis__3SI(*args)
    elif mosek_fusion_LinearDomain._match_alt_withNamesOnAxis__3SI(*args):
      return self._withNamesOnAxis_alt__3SI(*args)
    else:
      raise ValueError('Invalid argument list withNamesOnAxis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearDomain.withNamesOnAxis(array(string,ndim=1),int32)')
  def withShape(self,*args):
    if False: pass
    elif mosek_fusion_LinearDomain._match_withShape__3I(*args):
      return self._withShape__3I(*args)
    elif mosek_fusion_LinearDomain._match_alt_withShape__3I(*args):
      return self._withShape_alt__3I(*args)
    elif mosek_fusion_LinearDomain._match_withShape_I(*args):
      return self._withShape_I(*args)
    elif mosek_fusion_LinearDomain._match_alt_withShape_I(*args):
      return self._withShape_alt_I(*args)
    elif mosek_fusion_LinearDomain._match_withShape_II(*args):
      return self._withShape_II(*args)
    elif mosek_fusion_LinearDomain._match_alt_withShape_II(*args):
      return self._withShape_alt_II(*args)
    elif mosek_fusion_LinearDomain._match_withShape_III(*args):
      return self._withShape_III(*args)
    elif mosek_fusion_LinearDomain._match_alt_withShape_III(*args):
      return self._withShape_alt_III(*args)
    else:
      raise ValueError('Invalid argument list withShape('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearDomain.withShape(array(int32,ndim=1))\n\tmosek.fusion.LinearDomain.withShape(int32)\n\tmosek.fusion.LinearDomain.withShape(int32,int32)\n\tmosek.fusion.LinearDomain.withShape(int32,int32,int32)')
  def symmetric(self,*args):
    if False: pass
    elif mosek_fusion_LinearDomain._match_symmetric_(*args):
      return self._symmetric_(*args)
    elif mosek_fusion_LinearDomain._match_alt_symmetric_(*args):
      return self._symmetric_alt_(*args)
    else:
      raise ValueError('Invalid argument list symmetric('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearDomain.symmetric()')
  def sparse(self,*args):
    if False: pass
    elif mosek_fusion_LinearDomain._match_sparse_(*args):
      return self._sparse_(*args)
    elif mosek_fusion_LinearDomain._match_alt_sparse_(*args):
      return self._sparse_alt_(*args)
    elif mosek_fusion_LinearDomain._match_sparse__3I(*args):
      return self._sparse__3I(*args)
    elif mosek_fusion_LinearDomain._match_alt_sparse__3I(*args):
      return self._sparse_alt__3I(*args)
    elif mosek_fusion_LinearDomain._match_sparse__3_5I(*args):
      return self._sparse__3_5I(*args)
    elif mosek_fusion_LinearDomain._match_alt_sparse__3_5I(*args):
      return self._sparse_alt__3_5I(*args)
    else:
      raise ValueError('Invalid argument list sparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.LinearDomain.sparse()\n\tmosek.fusion.LinearDomain.sparse(array(int32,ndim=1))\n\tmosek.fusion.LinearDomain.sparse(array(int32,ndim=2))')
  def __repr__(self): return 'mosek.fusion.LinearDomain'
  @staticmethod
  def _ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I(k,scalable,rhs,dims):
    o = LinearDomain.__new__(LinearDomain)
    o._ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I(k,scalable,rhs,dims)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I(*args):
    if len(args) != 4: return False
    k,scalable,rhs,dims, = args
    return (__arg_match_Emosek_4fusion_4RelationKey_2__(k) and __arg_match_Z__(scalable) and __arg_match__3D__(rhs) and __arg_match__3I__(dims))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I(*args):
    if len(args) != 4: return False
    k,scalable,rhs,dims, = args
    return (__arg_alt_match_Emosek_4fusion_4RelationKey_2__(k) and __arg_alt_match_Z__(scalable) and __arg_alt_match__3D__(rhs) and __arg_alt_match__3I__(dims))
  def _ctor_alt_init_Emosek_4fusion_4RelationKey_2Z_3D_3I(self,k,scalable,rhs,dims):
    self._ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I(k,scalable,numpy.array(rhs,dtype=numpy.dtype(numpy.float64)),numpy.array(dims,dtype=numpy.dtype(numpy.int32)))
  def _ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I(self,k,scalable,rhs,dims):
   mosek_fusion_LinearDomain._ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(self,k,scalable,rhs,dims,None,1)
  @staticmethod
  def _ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(k,scalable,rhs,dims,sp,steal):
    o = LinearDomain.__new__(LinearDomain)
    o._ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(k,scalable,rhs,dims,sp,steal)
    return o
  @staticmethod
  def __match_ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(*args):
    if len(args) != 6: return False
    k,scalable,rhs,dims,sp,steal, = args
    return (__arg_match_Emosek_4fusion_4RelationKey_2__(k) and __arg_match_Z__(scalable) and __arg_match__3D__(rhs) and __arg_match__3I__(dims) and __arg_match__3_5I__(sp) and __arg_match_I__(steal))
  @staticmethod
  def __match_alt_ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(*args):
    if len(args) != 6: return False
    k,scalable,rhs,dims,sp,steal, = args
    return (__arg_alt_match_Emosek_4fusion_4RelationKey_2__(k) and __arg_alt_match_Z__(scalable) and __arg_alt_match__3D__(rhs) and __arg_alt_match__3I__(dims) and __arg_alt_match__3_5I__(sp) and __arg_alt_match_I__(steal))
  def _ctor_alt_init_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(self,k,scalable,rhs,dims,sp,steal):
    self._ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(k,scalable,numpy.array(rhs,dtype=numpy.dtype(numpy.float64)),numpy.array(dims,dtype=numpy.dtype(numpy.int32)),numpy.array(sp,dtype=numpy.dtype(numpy.int32)),numpy.int32(steal))
  def _ctor_init_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(self,k,scalable,rhs,dims,sp,steal):
   (self._scalable) = scalable
   (self._shape) = dims
   (self._key) = k
   (self._bnd) = rhs
   (self._sparsity) = sp
   (self._cardinal_flag) = False
   (self._empty) = False
   self._indexnames = None
   (self._domsize) = 0
   (self._nelements) = 0
  @staticmethod
  def _ctor_Lmosek_4fusion_4LinearDomain_2(other):
    o = LinearDomain.__new__(LinearDomain)
    o._ctor_init_Lmosek_4fusion_4LinearDomain_2(other)
    return o
  @staticmethod
  def __match_ctor_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(other))
  @staticmethod
  def __match_alt_ctor_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    other, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(other))
  def _ctor_alt_init_Lmosek_4fusion_4LinearDomain_2(self,other):
    self._ctor_init_Lmosek_4fusion_4LinearDomain_2(other)
  def _ctor_init_Lmosek_4fusion_4LinearDomain_2(self,other):
   self._scalable = (other._scalable)
   self._nelements = (other._nelements)
   self._domsize = (other._domsize)
   self._shape = (other._shape)
   self._key = (other._key)
   self._bnd = (other._bnd)
   self._sparsity = (other._sparsity)
   self._cardinal_flag = (other._cardinal_flag)
   self._empty = (other._empty)
   self._indexnames = (other._indexnames)
  @staticmethod
  def _match_symmetric_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_symmetric_(*args):
    if len(args) != 0: return False
    return True
  def _symmetric_alt_(self,):
    return self._symmetric_()
  def _symmetric_(self,):
   return (mosek_fusion_SymmetricLinearDomain._ctor_Lmosek_4fusion_4LinearDomain_2(self))
  @staticmethod
  def _match_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3_5I__(_0))
  @staticmethod
  def _match_alt_sparse__3_5I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3_5I__(_0))
  def _sparse_alt__3_5I(self,_t__0):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3_5I(_0)
   return _1_res
  def _sparse__3_5I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),int((_0).shape[1]),), dtype=numpy.dtype(numpy.int32))
   (self._empty) = False
   _1=0
   while (_1 < int((_0).shape[0])):
    _2=0
    while (_2 < int((_0).shape[1])):
     (self._sparsity)[_1,_2] = _0[_1,_2]
     _2 += 1
    _1 += 1
   return (self)
  @staticmethod
  def _match_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_sparse__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _sparse_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._sparse__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _sparse__3I(self,_0):
   (self._sparsity) = numpy.zeros((int((_0).shape[0]),1,), dtype=numpy.dtype(numpy.int32))
   (self._empty) = False
   for _1 in range(0,int((_0).shape[0])):
    (self._sparsity)[_1,0] = _0[_1]
   return (self)
  @staticmethod
  def _match_sparse_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_sparse_(*args):
    if len(args) != 0: return False
    return True
  def _sparse_alt_(self,):
    return self._sparse_()
  def _sparse_(self,):
   (self._empty) = True
   (self._sparsity) = None
   return (self)
  @staticmethod
  def _match_integral_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_integral_(*args):
    if len(args) != 0: return False
    return True
  def _integral_alt_(self,):
    return self._integral_()
  def _integral_(self,):
   self._cardinal_flag = True
   return (self)
  @staticmethod
  def _match_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1) and __arg_match_I__(_2))
  @staticmethod
  def _match_alt_withShape_III(*args):
    if len(args) != 3: return False
    _0,_1,_2, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1) and __arg_alt_match_I__(_2))
  def _withShape_alt_III(self,_t__0,_t__1,_t__2):
    return self._withShape_III(numpy.int32(__0),numpy.int32(__1),numpy.int32(__2))
  def _withShape_III(self,_0,_1,_2):
   self._shape = numpy.array([_0,_1,_2], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withShape_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  def _withShape_alt_II(self,_t__0,_t__1):
    return self._withShape_II(numpy.int32(__0),numpy.int32(__1))
  def _withShape_II(self,_0,_1):
   self._shape = numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_withShape_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  def _withShape_alt_I(self,_t__0):
    return self._withShape_I(numpy.int32(__0))
  def _withShape_I(self,_0):
   self._shape = numpy.array([_0], dtype=numpy.dtype(numpy.int32))
   return (self)
  @staticmethod
  def _match_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_withShape__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  def _withShape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._withShape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withShape__3I(self,_0):
   self._shape = _0
   return (self)
  @staticmethod
  def _match_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3S__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_withNamesOnAxis__3SI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3S__(_0) and __arg_alt_match_I__(_1))
  def _withNamesOnAxis_alt__3SI(self,_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(object))
   _1=numpy.int32(_t__1)
   _1_res = self._withNamesOnAxis__3SI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _withNamesOnAxis__3SI(self,_0,_1):
   if (self._indexnames is None):
    self._indexnames = _monty.initJaggedArray([None for _2 in range(0,(_1 + 1))], 1)
    self._indexnames[_1] = numpy.array([_0[_3] for _3 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   if (int((self._indexnames).shape[0]) < (_1 + 1)):
    _4=_monty.initJaggedArray([None for _5 in range(0,(_1 + 1))], 1)
    for _6 in range(0,int((self._indexnames).shape[0])):
     _4[_6] = self._indexnames[_6]
    self._indexnames = _4
   self._indexnames[_1] = numpy.array([_0[_7] for _7 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(object))
   return (self)
  def _match_1shape_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._match_1shape__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _match_1shape__3I(self,_0):
   if (not self._scalable):
    for _1 in range(0,int((_0).shape[0])):
     if (_0[_1]==self._shape[_1]):
      return (False)
   return (True)
  def __finalize_1and_1validate_1inplace_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self.__finalize_1and_1validate_1inplace__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def __finalize_1and_1validate_1inplace__3I(self,_0):
   if self._scalable:
    if (self._shape is None):
     if ((self._sparsity is not None) and (_0 is None)):
      raise mosek_fusion_DimensionError._ctor_S("Sparse domain requires a fixed shape")
     if (_0 is not None):
      self._shape = _0
     else:
      self._shape = numpy.zeros((0,), dtype=numpy.dtype(numpy.int32))
   else:
    if (_0 is not None):
     if (int((_0).shape[0])!=int((self._shape).shape[0])):
      raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
     for _1 in range(0,int((_0).shape[0])):
      if (_0[_1]!=self._shape[_1]):
       raise mosek_fusion_DimensionError._ctor_S("Conflicting shape definitions")
   if (self._indexnames is not None):
    if (int((self._indexnames).shape[0]) > int((self._shape).shape[0])):
     raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
    for _2 in range(0,int((self._indexnames).shape[0])):
     if ((self._indexnames[_2] is not None) and (int((self._indexnames[_2]).shape[0])!=self._shape[_2])):
      raise mosek_fusion_DimensionError._ctor_S("Index names do not match shape")
    if (int((self._indexnames).shape[0]) < int((self._shape).shape[0])):
     _3=numpy.ndarray((int((self._shape).shape[0]),), dtype=numpy.dtype(object))
     for _4 in range(0,int((self._indexnames).shape[0])):
      _3[_4] = self._indexnames[_4]
     self._indexnames = _3
   self._domsize = 1
   self._domsize = fragments._c_closure_280(self._domsize,self._shape)
   self._domsize = numpy.int64(self._domsize) # postprocess
   if (self._sparsity is not None):
    self._nelements = int((self._sparsity).shape[0])
    if (int((self._shape).shape[0])!=int((self._sparsity).shape[1])):
     raise mosek_fusion_DimensionError._ctor_S("Mismatching shape and sparsity pattern")
    for _5 in range(0,self._nelements):
     for _6 in range(0,int((self._sparsity).shape[1])):
      if ((self._sparsity[_5,_6] < 0) or (self._sparsity[_5,_6] >= self._shape[_6])):
       raise mosek_fusion_DimensionError._ctor_S("Sparsity pattern entry is out of bounds")
    if ((not self._scalable) and ((self._bnd is not None) and (int((self._bnd).shape[0])!=self._nelements))):
     raise mosek_fusion_DimensionError._ctor_S("Sparsity pattern does not match bound")
   else:
    self._nelements = self._domsize
    if ((self._bnd is not None) and (not self._scalable)):
     if (int((self._bnd).shape[0])!=self._nelements):
      raise mosek_fusion_DimensionError._ctor_S("Domain bound does not match shape")
  def _finalize_1and_1validate_alt__3I(self,_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = self._finalize_1and_1validate__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  def _finalize_1and_1validate__3I(self,_0):
   _1=mosek_fusion_LinearDomain._ctor_Lmosek_4fusion_4LinearDomain_2(self)
   _1.__finalize_1and_1validate_1inplace__3I(_0)
   return (_1)
 return LinearDomain
mosek_fusion_LinearDomain=__mk_mosek_fusion_LinearDomain()
del __mk_mosek_fusion_LinearDomain
#BEFORE CLASS
def __mk_mosek_fusion_Domain():
 class Domain(object):
  @staticmethod
  def binary(*args):
    if False: pass
    elif mosek_fusion_Domain._match_binary_(*args):
      return mosek_fusion_Domain._binary_(*args)
    elif mosek_fusion_Domain._match_alt_binary_(*args):
      return mosek_fusion_Domain._binary_alt_(*args)
    elif mosek_fusion_Domain._match_binary__3I(*args):
      return mosek_fusion_Domain._binary__3I(*args)
    elif mosek_fusion_Domain._match_alt_binary__3I(*args):
      return mosek_fusion_Domain._binary_alt__3I(*args)
    elif mosek_fusion_Domain._match_binary_I(*args):
      return mosek_fusion_Domain._binary_I(*args)
    elif mosek_fusion_Domain._match_alt_binary_I(*args):
      return mosek_fusion_Domain._binary_alt_I(*args)
    elif mosek_fusion_Domain._match_binary_II(*args):
      return mosek_fusion_Domain._binary_II(*args)
    elif mosek_fusion_Domain._match_alt_binary_II(*args):
      return mosek_fusion_Domain._binary_alt_II(*args)
    else:
      raise ValueError('Invalid argument list binary('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.binary()\n\tmosek.fusion.Domain.binary(array(int32,ndim=1))\n\tmosek.fusion.Domain.binary(int32)\n\tmosek.fusion.Domain.binary(int32,int32)')
  @staticmethod
  def inRange(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inRange__3D_3D(*args):
      return mosek_fusion_Domain._inRange__3D_3D(*args)
    elif mosek_fusion_Domain._match_alt_inRange__3D_3D(*args):
      return mosek_fusion_Domain._inRange_alt__3D_3D(*args)
    elif mosek_fusion_Domain._match_inRange__3DD(*args):
      return mosek_fusion_Domain._inRange__3DD(*args)
    elif mosek_fusion_Domain._match_alt_inRange__3DD(*args):
      return mosek_fusion_Domain._inRange_alt__3DD(*args)
    elif mosek_fusion_Domain._match_inRange_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._inRange_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_alt_inRange_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._inRange_alt_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_inRange_D_3D(*args):
      return mosek_fusion_Domain._inRange_D_3D(*args)
    elif mosek_fusion_Domain._match_alt_inRange_D_3D(*args):
      return mosek_fusion_Domain._inRange_alt_D_3D(*args)
    elif mosek_fusion_Domain._match_inRange__3_5D_3_5D(*args):
      return mosek_fusion_Domain._inRange__3_5D_3_5D(*args)
    elif mosek_fusion_Domain._match_alt_inRange__3_5D_3_5D(*args):
      return mosek_fusion_Domain._inRange_alt__3_5D_3_5D(*args)
    elif mosek_fusion_Domain._match_inRange_DD(*args):
      return mosek_fusion_Domain._inRange_DD(*args)
    elif mosek_fusion_Domain._match_alt_inRange_DD(*args):
      return mosek_fusion_Domain._inRange_alt_DD(*args)
    elif mosek_fusion_Domain._match_inRange_D_3D_3I(*args):
      return mosek_fusion_Domain._inRange_D_3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inRange_D_3D_3I(*args):
      return mosek_fusion_Domain._inRange_alt_D_3D_3I(*args)
    elif mosek_fusion_Domain._match_inRange__3DD_3I(*args):
      return mosek_fusion_Domain._inRange__3DD_3I(*args)
    elif mosek_fusion_Domain._match_alt_inRange__3DD_3I(*args):
      return mosek_fusion_Domain._inRange_alt__3DD_3I(*args)
    elif mosek_fusion_Domain._match_inRange__3D_3D_3I(*args):
      return mosek_fusion_Domain._inRange__3D_3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inRange__3D_3D_3I(*args):
      return mosek_fusion_Domain._inRange_alt__3D_3D_3I(*args)
    elif mosek_fusion_Domain._match_inRange_DD_3I(*args):
      return mosek_fusion_Domain._inRange_DD_3I(*args)
    elif mosek_fusion_Domain._match_alt_inRange_DD_3I(*args):
      return mosek_fusion_Domain._inRange_alt_DD_3I(*args)
    else:
      raise ValueError('Invalid argument list inRange('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inRange(array(double,ndim=1),array(double,ndim=1))\n\tmosek.fusion.Domain.inRange(array(double,ndim=1),double)\n\tmosek.fusion.Domain.inRange(mosek.fusion.Matrix,mosek.fusion.Matrix)\n\tmosek.fusion.Domain.inRange(double,array(double,ndim=1))\n\tmosek.fusion.Domain.inRange(array(double,ndim=2),array(double,ndim=2))\n\tmosek.fusion.Domain.inRange(double,double)\n\tmosek.fusion.Domain.inRange(double,array(double,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Domain.inRange(array(double,ndim=1),double,array(int32,ndim=1))\n\tmosek.fusion.Domain.inRange(array(double,ndim=1),array(double,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Domain.inRange(double,double,array(int32,ndim=1))')
  @staticmethod
  def inDPowerCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inDPowerCone__3D(*args):
      return mosek_fusion_Domain._inDPowerCone__3D(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone__3D(*args):
      return mosek_fusion_Domain._inDPowerCone_alt__3D(*args)
    elif mosek_fusion_Domain._match_inDPowerCone_D(*args):
      return mosek_fusion_Domain._inDPowerCone_D(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone_D(*args):
      return mosek_fusion_Domain._inDPowerCone_alt_D(*args)
    elif mosek_fusion_Domain._match_inDPowerCone_D_3I(*args):
      return mosek_fusion_Domain._inDPowerCone_D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone_D_3I(*args):
      return mosek_fusion_Domain._inDPowerCone_alt_D_3I(*args)
    elif mosek_fusion_Domain._match_inDPowerCone__3DI(*args):
      return mosek_fusion_Domain._inDPowerCone__3DI(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone__3DI(*args):
      return mosek_fusion_Domain._inDPowerCone_alt__3DI(*args)
    elif mosek_fusion_Domain._match_inDPowerCone_DI(*args):
      return mosek_fusion_Domain._inDPowerCone_DI(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone_DI(*args):
      return mosek_fusion_Domain._inDPowerCone_alt_DI(*args)
    elif mosek_fusion_Domain._match_inDPowerCone__3D_3I(*args):
      return mosek_fusion_Domain._inDPowerCone__3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inDPowerCone__3D_3I(*args):
      return mosek_fusion_Domain._inDPowerCone_alt__3D_3I(*args)
    else:
      raise ValueError('Invalid argument list inDPowerCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inDPowerCone(array(double,ndim=1))\n\tmosek.fusion.Domain.inDPowerCone(double)\n\tmosek.fusion.Domain.inDPowerCone(double,array(int32,ndim=1))\n\tmosek.fusion.Domain.inDPowerCone(array(double,ndim=1),int32)\n\tmosek.fusion.Domain.inDPowerCone(double,int32)\n\tmosek.fusion.Domain.inDPowerCone(array(double,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def equalsTo(*args):
    if False: pass
    elif mosek_fusion_Domain._match_equalsTo__3D(*args):
      return mosek_fusion_Domain._equalsTo__3D(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo__3D(*args):
      return mosek_fusion_Domain._equalsTo_alt__3D(*args)
    elif mosek_fusion_Domain._match_equalsTo_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._equalsTo_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._equalsTo_alt_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_equalsTo__3_5D(*args):
      return mosek_fusion_Domain._equalsTo__3_5D(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo__3_5D(*args):
      return mosek_fusion_Domain._equalsTo_alt__3_5D(*args)
    elif mosek_fusion_Domain._match_equalsTo_D(*args):
      return mosek_fusion_Domain._equalsTo_D(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo_D(*args):
      return mosek_fusion_Domain._equalsTo_alt_D(*args)
    elif mosek_fusion_Domain._match_equalsTo_D_3I(*args):
      return mosek_fusion_Domain._equalsTo_D_3I(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo_D_3I(*args):
      return mosek_fusion_Domain._equalsTo_alt_D_3I(*args)
    elif mosek_fusion_Domain._match_equalsTo__3D_3I(*args):
      return mosek_fusion_Domain._equalsTo__3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo__3D_3I(*args):
      return mosek_fusion_Domain._equalsTo_alt__3D_3I(*args)
    elif mosek_fusion_Domain._match_equalsTo_DI(*args):
      return mosek_fusion_Domain._equalsTo_DI(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo_DI(*args):
      return mosek_fusion_Domain._equalsTo_alt_DI(*args)
    elif mosek_fusion_Domain._match_equalsTo_DII(*args):
      return mosek_fusion_Domain._equalsTo_DII(*args)
    elif mosek_fusion_Domain._match_alt_equalsTo_DII(*args):
      return mosek_fusion_Domain._equalsTo_alt_DII(*args)
    else:
      raise ValueError('Invalid argument list equalsTo('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.equalsTo(array(double,ndim=1))\n\tmosek.fusion.Domain.equalsTo(mosek.fusion.Matrix)\n\tmosek.fusion.Domain.equalsTo(array(double,ndim=2))\n\tmosek.fusion.Domain.equalsTo(double)\n\tmosek.fusion.Domain.equalsTo(double,array(int32,ndim=1))\n\tmosek.fusion.Domain.equalsTo(array(double,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Domain.equalsTo(double,int32)\n\tmosek.fusion.Domain.equalsTo(double,int32,int32)')
  @staticmethod
  def inPSDCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inPSDCone_(*args):
      return mosek_fusion_Domain._inPSDCone_(*args)
    elif mosek_fusion_Domain._match_alt_inPSDCone_(*args):
      return mosek_fusion_Domain._inPSDCone_alt_(*args)
    elif mosek_fusion_Domain._match_inPSDCone_I(*args):
      return mosek_fusion_Domain._inPSDCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inPSDCone_I(*args):
      return mosek_fusion_Domain._inPSDCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inPSDCone_II(*args):
      return mosek_fusion_Domain._inPSDCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inPSDCone_II(*args):
      return mosek_fusion_Domain._inPSDCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inPSDCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inPSDCone()\n\tmosek.fusion.Domain.inPSDCone(int32)\n\tmosek.fusion.Domain.inPSDCone(int32,int32)')
  @staticmethod
  def inDExpCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inDExpCone_(*args):
      return mosek_fusion_Domain._inDExpCone_(*args)
    elif mosek_fusion_Domain._match_alt_inDExpCone_(*args):
      return mosek_fusion_Domain._inDExpCone_alt_(*args)
    elif mosek_fusion_Domain._match_inDExpCone_I(*args):
      return mosek_fusion_Domain._inDExpCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inDExpCone_I(*args):
      return mosek_fusion_Domain._inDExpCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inDExpCone__3I(*args):
      return mosek_fusion_Domain._inDExpCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inDExpCone__3I(*args):
      return mosek_fusion_Domain._inDExpCone_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list inDExpCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inDExpCone()\n\tmosek.fusion.Domain.inDExpCone(int32)\n\tmosek.fusion.Domain.inDExpCone(array(int32,ndim=1))')
  @staticmethod
  def integral(*args):
    if False: pass
    elif mosek_fusion_Domain._match_integral_Lmosek_4fusion_4ConeDomain_2(*args):
      return mosek_fusion_Domain._integral_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Domain._match_alt_integral_Lmosek_4fusion_4ConeDomain_2(*args):
      return mosek_fusion_Domain._integral_alt_Lmosek_4fusion_4ConeDomain_2(*args)
    elif mosek_fusion_Domain._match_integral_Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_Domain._integral_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Domain._match_alt_integral_Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_Domain._integral_alt_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Domain._match_integral_Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_Domain._integral_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Domain._match_alt_integral_Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_Domain._integral_alt_Lmosek_4fusion_4RangeDomain_2(*args)
    else:
      raise ValueError('Invalid argument list integral('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.integral(mosek.fusion.ConeDomain)\n\tmosek.fusion.Domain.integral(mosek.fusion.LinearDomain)\n\tmosek.fusion.Domain.integral(mosek.fusion.RangeDomain)')
  @staticmethod
  def inDGeoMeanCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inDGeoMeanCone_(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_(*args)
    elif mosek_fusion_Domain._match_alt_inDGeoMeanCone_(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_alt_(*args)
    elif mosek_fusion_Domain._match_inDGeoMeanCone_I(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inDGeoMeanCone_I(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inDGeoMeanCone__3I(*args):
      return mosek_fusion_Domain._inDGeoMeanCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inDGeoMeanCone__3I(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_alt__3I(*args)
    elif mosek_fusion_Domain._match_inDGeoMeanCone_II(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inDGeoMeanCone_II(*args):
      return mosek_fusion_Domain._inDGeoMeanCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inDGeoMeanCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inDGeoMeanCone()\n\tmosek.fusion.Domain.inDGeoMeanCone(int32)\n\tmosek.fusion.Domain.inDGeoMeanCone(array(int32,ndim=1))\n\tmosek.fusion.Domain.inDGeoMeanCone(int32,int32)')
  @staticmethod
  def inSVecPSDCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inSVecPSDCone_(*args):
      return mosek_fusion_Domain._inSVecPSDCone_(*args)
    elif mosek_fusion_Domain._match_alt_inSVecPSDCone_(*args):
      return mosek_fusion_Domain._inSVecPSDCone_alt_(*args)
    elif mosek_fusion_Domain._match_inSVecPSDCone_I(*args):
      return mosek_fusion_Domain._inSVecPSDCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inSVecPSDCone_I(*args):
      return mosek_fusion_Domain._inSVecPSDCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inSVecPSDCone__3I(*args):
      return mosek_fusion_Domain._inSVecPSDCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inSVecPSDCone__3I(*args):
      return mosek_fusion_Domain._inSVecPSDCone_alt__3I(*args)
    elif mosek_fusion_Domain._match_inSVecPSDCone_II(*args):
      return mosek_fusion_Domain._inSVecPSDCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inSVecPSDCone_II(*args):
      return mosek_fusion_Domain._inSVecPSDCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inSVecPSDCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inSVecPSDCone()\n\tmosek.fusion.Domain.inSVecPSDCone(int32)\n\tmosek.fusion.Domain.inSVecPSDCone(array(int32,ndim=1))\n\tmosek.fusion.Domain.inSVecPSDCone(int32,int32)')
  @staticmethod
  def symmetric(*args):
    if False: pass
    elif mosek_fusion_Domain._match_symmetric_Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_Domain._symmetric_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Domain._match_alt_symmetric_Lmosek_4fusion_4LinearDomain_2(*args):
      return mosek_fusion_Domain._symmetric_alt_Lmosek_4fusion_4LinearDomain_2(*args)
    elif mosek_fusion_Domain._match_symmetric_Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_Domain._symmetric_Lmosek_4fusion_4RangeDomain_2(*args)
    elif mosek_fusion_Domain._match_alt_symmetric_Lmosek_4fusion_4RangeDomain_2(*args):
      return mosek_fusion_Domain._symmetric_alt_Lmosek_4fusion_4RangeDomain_2(*args)
    else:
      raise ValueError('Invalid argument list symmetric('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.symmetric(mosek.fusion.LinearDomain)\n\tmosek.fusion.Domain.symmetric(mosek.fusion.RangeDomain)')
  @staticmethod
  def greaterThan(*args):
    if False: pass
    elif mosek_fusion_Domain._match_greaterThan__3D(*args):
      return mosek_fusion_Domain._greaterThan__3D(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan__3D(*args):
      return mosek_fusion_Domain._greaterThan_alt__3D(*args)
    elif mosek_fusion_Domain._match_greaterThan_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._greaterThan_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._greaterThan_alt_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_greaterThan__3_5D(*args):
      return mosek_fusion_Domain._greaterThan__3_5D(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan__3_5D(*args):
      return mosek_fusion_Domain._greaterThan_alt__3_5D(*args)
    elif mosek_fusion_Domain._match_greaterThan_D(*args):
      return mosek_fusion_Domain._greaterThan_D(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan_D(*args):
      return mosek_fusion_Domain._greaterThan_alt_D(*args)
    elif mosek_fusion_Domain._match_greaterThan_D_3I(*args):
      return mosek_fusion_Domain._greaterThan_D_3I(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan_D_3I(*args):
      return mosek_fusion_Domain._greaterThan_alt_D_3I(*args)
    elif mosek_fusion_Domain._match_greaterThan__3D_3I(*args):
      return mosek_fusion_Domain._greaterThan__3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan__3D_3I(*args):
      return mosek_fusion_Domain._greaterThan_alt__3D_3I(*args)
    elif mosek_fusion_Domain._match_greaterThan_DI(*args):
      return mosek_fusion_Domain._greaterThan_DI(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan_DI(*args):
      return mosek_fusion_Domain._greaterThan_alt_DI(*args)
    elif mosek_fusion_Domain._match_greaterThan_DII(*args):
      return mosek_fusion_Domain._greaterThan_DII(*args)
    elif mosek_fusion_Domain._match_alt_greaterThan_DII(*args):
      return mosek_fusion_Domain._greaterThan_alt_DII(*args)
    else:
      raise ValueError('Invalid argument list greaterThan('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.greaterThan(array(double,ndim=1))\n\tmosek.fusion.Domain.greaterThan(mosek.fusion.Matrix)\n\tmosek.fusion.Domain.greaterThan(array(double,ndim=2))\n\tmosek.fusion.Domain.greaterThan(double)\n\tmosek.fusion.Domain.greaterThan(double,array(int32,ndim=1))\n\tmosek.fusion.Domain.greaterThan(array(double,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Domain.greaterThan(double,int32)\n\tmosek.fusion.Domain.greaterThan(double,int32,int32)')
  @staticmethod
  def inPExpCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inPExpCone_(*args):
      return mosek_fusion_Domain._inPExpCone_(*args)
    elif mosek_fusion_Domain._match_alt_inPExpCone_(*args):
      return mosek_fusion_Domain._inPExpCone_alt_(*args)
    elif mosek_fusion_Domain._match_inPExpCone_I(*args):
      return mosek_fusion_Domain._inPExpCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inPExpCone_I(*args):
      return mosek_fusion_Domain._inPExpCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inPExpCone__3I(*args):
      return mosek_fusion_Domain._inPExpCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inPExpCone__3I(*args):
      return mosek_fusion_Domain._inPExpCone_alt__3I(*args)
    else:
      raise ValueError('Invalid argument list inPExpCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inPExpCone()\n\tmosek.fusion.Domain.inPExpCone(int32)\n\tmosek.fusion.Domain.inPExpCone(array(int32,ndim=1))')
  @staticmethod
  def isTrilPSD(*args):
    if False: pass
    elif mosek_fusion_Domain._match_isTrilPSD_(*args):
      return mosek_fusion_Domain._isTrilPSD_(*args)
    elif mosek_fusion_Domain._match_alt_isTrilPSD_(*args):
      return mosek_fusion_Domain._isTrilPSD_alt_(*args)
    elif mosek_fusion_Domain._match_isTrilPSD_I(*args):
      return mosek_fusion_Domain._isTrilPSD_I(*args)
    elif mosek_fusion_Domain._match_alt_isTrilPSD_I(*args):
      return mosek_fusion_Domain._isTrilPSD_alt_I(*args)
    elif mosek_fusion_Domain._match_isTrilPSD_II(*args):
      return mosek_fusion_Domain._isTrilPSD_II(*args)
    elif mosek_fusion_Domain._match_alt_isTrilPSD_II(*args):
      return mosek_fusion_Domain._isTrilPSD_alt_II(*args)
    else:
      raise ValueError('Invalid argument list isTrilPSD('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.isTrilPSD()\n\tmosek.fusion.Domain.isTrilPSD(int32)\n\tmosek.fusion.Domain.isTrilPSD(int32,int32)')
  @staticmethod
  def inPPowerCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inPPowerCone__3D(*args):
      return mosek_fusion_Domain._inPPowerCone__3D(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone__3D(*args):
      return mosek_fusion_Domain._inPPowerCone_alt__3D(*args)
    elif mosek_fusion_Domain._match_inPPowerCone_D(*args):
      return mosek_fusion_Domain._inPPowerCone_D(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone_D(*args):
      return mosek_fusion_Domain._inPPowerCone_alt_D(*args)
    elif mosek_fusion_Domain._match_inPPowerCone_D_3I(*args):
      return mosek_fusion_Domain._inPPowerCone_D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone_D_3I(*args):
      return mosek_fusion_Domain._inPPowerCone_alt_D_3I(*args)
    elif mosek_fusion_Domain._match_inPPowerCone__3DI(*args):
      return mosek_fusion_Domain._inPPowerCone__3DI(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone__3DI(*args):
      return mosek_fusion_Domain._inPPowerCone_alt__3DI(*args)
    elif mosek_fusion_Domain._match_inPPowerCone_DI(*args):
      return mosek_fusion_Domain._inPPowerCone_DI(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone_DI(*args):
      return mosek_fusion_Domain._inPPowerCone_alt_DI(*args)
    elif mosek_fusion_Domain._match_inPPowerCone__3D_3I(*args):
      return mosek_fusion_Domain._inPPowerCone__3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_inPPowerCone__3D_3I(*args):
      return mosek_fusion_Domain._inPPowerCone_alt__3D_3I(*args)
    else:
      raise ValueError('Invalid argument list inPPowerCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inPPowerCone(array(double,ndim=1))\n\tmosek.fusion.Domain.inPPowerCone(double)\n\tmosek.fusion.Domain.inPPowerCone(double,array(int32,ndim=1))\n\tmosek.fusion.Domain.inPPowerCone(array(double,ndim=1),int32)\n\tmosek.fusion.Domain.inPPowerCone(double,int32)\n\tmosek.fusion.Domain.inPPowerCone(array(double,ndim=1),array(int32,ndim=1))')
  @staticmethod
  def lessThan(*args):
    if False: pass
    elif mosek_fusion_Domain._match_lessThan__3D(*args):
      return mosek_fusion_Domain._lessThan__3D(*args)
    elif mosek_fusion_Domain._match_alt_lessThan__3D(*args):
      return mosek_fusion_Domain._lessThan_alt__3D(*args)
    elif mosek_fusion_Domain._match_lessThan_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._lessThan_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_alt_lessThan_Lmosek_4fusion_4Matrix_2(*args):
      return mosek_fusion_Domain._lessThan_alt_Lmosek_4fusion_4Matrix_2(*args)
    elif mosek_fusion_Domain._match_lessThan__3_5D(*args):
      return mosek_fusion_Domain._lessThan__3_5D(*args)
    elif mosek_fusion_Domain._match_alt_lessThan__3_5D(*args):
      return mosek_fusion_Domain._lessThan_alt__3_5D(*args)
    elif mosek_fusion_Domain._match_lessThan_D(*args):
      return mosek_fusion_Domain._lessThan_D(*args)
    elif mosek_fusion_Domain._match_alt_lessThan_D(*args):
      return mosek_fusion_Domain._lessThan_alt_D(*args)
    elif mosek_fusion_Domain._match_lessThan_D_3I(*args):
      return mosek_fusion_Domain._lessThan_D_3I(*args)
    elif mosek_fusion_Domain._match_alt_lessThan_D_3I(*args):
      return mosek_fusion_Domain._lessThan_alt_D_3I(*args)
    elif mosek_fusion_Domain._match_lessThan__3D_3I(*args):
      return mosek_fusion_Domain._lessThan__3D_3I(*args)
    elif mosek_fusion_Domain._match_alt_lessThan__3D_3I(*args):
      return mosek_fusion_Domain._lessThan_alt__3D_3I(*args)
    elif mosek_fusion_Domain._match_lessThan_DI(*args):
      return mosek_fusion_Domain._lessThan_DI(*args)
    elif mosek_fusion_Domain._match_alt_lessThan_DI(*args):
      return mosek_fusion_Domain._lessThan_alt_DI(*args)
    elif mosek_fusion_Domain._match_lessThan_DII(*args):
      return mosek_fusion_Domain._lessThan_DII(*args)
    elif mosek_fusion_Domain._match_alt_lessThan_DII(*args):
      return mosek_fusion_Domain._lessThan_alt_DII(*args)
    else:
      raise ValueError('Invalid argument list lessThan('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.lessThan(array(double,ndim=1))\n\tmosek.fusion.Domain.lessThan(mosek.fusion.Matrix)\n\tmosek.fusion.Domain.lessThan(array(double,ndim=2))\n\tmosek.fusion.Domain.lessThan(double)\n\tmosek.fusion.Domain.lessThan(double,array(int32,ndim=1))\n\tmosek.fusion.Domain.lessThan(array(double,ndim=1),array(int32,ndim=1))\n\tmosek.fusion.Domain.lessThan(double,int32)\n\tmosek.fusion.Domain.lessThan(double,int32,int32)')
  @staticmethod
  def unbounded(*args):
    if False: pass
    elif mosek_fusion_Domain._match_unbounded_(*args):
      return mosek_fusion_Domain._unbounded_(*args)
    elif mosek_fusion_Domain._match_alt_unbounded_(*args):
      return mosek_fusion_Domain._unbounded_alt_(*args)
    elif mosek_fusion_Domain._match_unbounded_I(*args):
      return mosek_fusion_Domain._unbounded_I(*args)
    elif mosek_fusion_Domain._match_alt_unbounded_I(*args):
      return mosek_fusion_Domain._unbounded_alt_I(*args)
    elif mosek_fusion_Domain._match_unbounded__3I(*args):
      return mosek_fusion_Domain._unbounded__3I(*args)
    elif mosek_fusion_Domain._match_alt_unbounded__3I(*args):
      return mosek_fusion_Domain._unbounded_alt__3I(*args)
    elif mosek_fusion_Domain._match_unbounded_II(*args):
      return mosek_fusion_Domain._unbounded_II(*args)
    elif mosek_fusion_Domain._match_alt_unbounded_II(*args):
      return mosek_fusion_Domain._unbounded_alt_II(*args)
    else:
      raise ValueError('Invalid argument list unbounded('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.unbounded()\n\tmosek.fusion.Domain.unbounded(int32)\n\tmosek.fusion.Domain.unbounded(array(int32,ndim=1))\n\tmosek.fusion.Domain.unbounded(int32,int32)')
  @staticmethod
  def sparse(*args):
    if False: pass
    elif mosek_fusion_Domain._match_sparse_Lmosek_4fusion_4LinearDomain_2_3I(*args):
      return mosek_fusion_Domain._sparse_Lmosek_4fusion_4LinearDomain_2_3I(*args)
    elif mosek_fusion_Domain._match_alt_sparse_Lmosek_4fusion_4LinearDomain_2_3I(*args):
      return mosek_fusion_Domain._sparse_alt_Lmosek_4fusion_4LinearDomain_2_3I(*args)
    elif mosek_fusion_Domain._match_sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(*args):
      return mosek_fusion_Domain._sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(*args)
    elif mosek_fusion_Domain._match_alt_sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(*args):
      return mosek_fusion_Domain._sparse_alt_Lmosek_4fusion_4LinearDomain_2_3_5I(*args)
    elif mosek_fusion_Domain._match_sparse_Lmosek_4fusion_4RangeDomain_2_3I(*args):
      return mosek_fusion_Domain._sparse_Lmosek_4fusion_4RangeDomain_2_3I(*args)
    elif mosek_fusion_Domain._match_alt_sparse_Lmosek_4fusion_4RangeDomain_2_3I(*args):
      return mosek_fusion_Domain._sparse_alt_Lmosek_4fusion_4RangeDomain_2_3I(*args)
    elif mosek_fusion_Domain._match_sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(*args):
      return mosek_fusion_Domain._sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(*args)
    elif mosek_fusion_Domain._match_alt_sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(*args):
      return mosek_fusion_Domain._sparse_alt_Lmosek_4fusion_4RangeDomain_2_3_5I(*args)
    else:
      raise ValueError('Invalid argument list sparse('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.sparse(mosek.fusion.LinearDomain,array(int32,ndim=1))\n\tmosek.fusion.Domain.sparse(mosek.fusion.LinearDomain,array(int32,ndim=2))\n\tmosek.fusion.Domain.sparse(mosek.fusion.RangeDomain,array(int32,ndim=1))\n\tmosek.fusion.Domain.sparse(mosek.fusion.RangeDomain,array(int32,ndim=2))')
  @staticmethod
  def inPGeoMeanCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inPGeoMeanCone_(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_(*args)
    elif mosek_fusion_Domain._match_alt_inPGeoMeanCone_(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_alt_(*args)
    elif mosek_fusion_Domain._match_inPGeoMeanCone_I(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inPGeoMeanCone_I(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inPGeoMeanCone__3I(*args):
      return mosek_fusion_Domain._inPGeoMeanCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inPGeoMeanCone__3I(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_alt__3I(*args)
    elif mosek_fusion_Domain._match_inPGeoMeanCone_II(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inPGeoMeanCone_II(*args):
      return mosek_fusion_Domain._inPGeoMeanCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inPGeoMeanCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inPGeoMeanCone()\n\tmosek.fusion.Domain.inPGeoMeanCone(int32)\n\tmosek.fusion.Domain.inPGeoMeanCone(array(int32,ndim=1))\n\tmosek.fusion.Domain.inPGeoMeanCone(int32,int32)')
  @staticmethod
  def inRotatedQCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inRotatedQCone_(*args):
      return mosek_fusion_Domain._inRotatedQCone_(*args)
    elif mosek_fusion_Domain._match_alt_inRotatedQCone_(*args):
      return mosek_fusion_Domain._inRotatedQCone_alt_(*args)
    elif mosek_fusion_Domain._match_inRotatedQCone_I(*args):
      return mosek_fusion_Domain._inRotatedQCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inRotatedQCone_I(*args):
      return mosek_fusion_Domain._inRotatedQCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inRotatedQCone__3I(*args):
      return mosek_fusion_Domain._inRotatedQCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inRotatedQCone__3I(*args):
      return mosek_fusion_Domain._inRotatedQCone_alt__3I(*args)
    elif mosek_fusion_Domain._match_inRotatedQCone_II(*args):
      return mosek_fusion_Domain._inRotatedQCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inRotatedQCone_II(*args):
      return mosek_fusion_Domain._inRotatedQCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inRotatedQCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inRotatedQCone()\n\tmosek.fusion.Domain.inRotatedQCone(int32)\n\tmosek.fusion.Domain.inRotatedQCone(array(int32,ndim=1))\n\tmosek.fusion.Domain.inRotatedQCone(int32,int32)')
  @staticmethod
  def axis(*args):
    if False: pass
    elif mosek_fusion_Domain._match_axis_Lmosek_4fusion_4ConeDomain_2I(*args):
      return mosek_fusion_Domain._axis_Lmosek_4fusion_4ConeDomain_2I(*args)
    elif mosek_fusion_Domain._match_alt_axis_Lmosek_4fusion_4ConeDomain_2I(*args):
      return mosek_fusion_Domain._axis_alt_Lmosek_4fusion_4ConeDomain_2I(*args)
    else:
      raise ValueError('Invalid argument list axis('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.axis(mosek.fusion.ConeDomain,int32)')
  @staticmethod
  def inQCone(*args):
    if False: pass
    elif mosek_fusion_Domain._match_inQCone_(*args):
      return mosek_fusion_Domain._inQCone_(*args)
    elif mosek_fusion_Domain._match_alt_inQCone_(*args):
      return mosek_fusion_Domain._inQCone_alt_(*args)
    elif mosek_fusion_Domain._match_inQCone_I(*args):
      return mosek_fusion_Domain._inQCone_I(*args)
    elif mosek_fusion_Domain._match_alt_inQCone_I(*args):
      return mosek_fusion_Domain._inQCone_alt_I(*args)
    elif mosek_fusion_Domain._match_inQCone__3I(*args):
      return mosek_fusion_Domain._inQCone__3I(*args)
    elif mosek_fusion_Domain._match_alt_inQCone__3I(*args):
      return mosek_fusion_Domain._inQCone_alt__3I(*args)
    elif mosek_fusion_Domain._match_inQCone_II(*args):
      return mosek_fusion_Domain._inQCone_II(*args)
    elif mosek_fusion_Domain._match_alt_inQCone_II(*args):
      return mosek_fusion_Domain._inQCone_alt_II(*args)
    else:
      raise ValueError('Invalid argument list inQCone('+','.join(map(repr,args))+'). Candidates are\n\tmosek.fusion.Domain.inQCone()\n\tmosek.fusion.Domain.inQCone(int32)\n\tmosek.fusion.Domain.inQCone(array(int32,ndim=1))\n\tmosek.fusion.Domain.inQCone(int32,int32)')
  def __repr__(self): return 'mosek.fusion.Domain'
  @staticmethod
  def __dimsize_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain.__dimsize__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __dimsize__3I(_0):
   _1=1
   _1 = fragments._c_closure_281(_0,_1)
   _1 = numpy.int64(_1) # postprocess
   return numpy.int64(_1)
  @staticmethod
  def __mkRangedDomain_alt_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(_t__0,_t__1):
    return mosek_fusion_Domain.__mkRangedDomain_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(_0,_1)
  @staticmethod
  def __mkRangedDomain_Lmosek_4fusion_4Matrix_2Lmosek_4fusion_4Matrix_2(_0,_1):
   if (((_0._dimi)!=(_1._dimi)) or ((_0._dimj)!=(_1._dimj))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching dimensions in domain")
   if (_0._isSparse_() and _1._isSparse_()):
    _2=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _3=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _4=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.float64))
    _5=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _6=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _7=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.float64))
    _0._getDataAsTriplets__3I_3I_3D(_2,_3,_4)
    _1._getDataAsTriplets__3I_3I_3D(_5,_6,_7)
    _8=0
    _8 = fragments._c_closure_282(_2,_3,_8,_5,_6)
    _8 = numpy.int64(_8) # postprocess
    _9=numpy.zeros((_8,2,), dtype=numpy.dtype(numpy.int32))
    _10=numpy.zeros((_8,), dtype=numpy.dtype(numpy.float64))
    _11=numpy.zeros((_8,), dtype=numpy.dtype(numpy.float64))
    fragments._c_closure_283(_9,_10,_2,_3,_4,_11,_5,_6,_7) 
    return (mosek_fusion_RangeDomain._ctor_Z_3D_3D_3I_3_5II(False,_10,_11,numpy.array([(_0._dimi),(_0._dimj)], dtype=numpy.dtype(numpy.int32)),_9,1))
   else:
    _12=(_0._dimj)
    _13=(_0._dimi)
    _14=(_13 * _12)
    if _0._isSparse_():
     _15 = numpy.zeros((_14,), dtype=numpy.dtype(numpy.float64))
     _17=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
     _18=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
     _19=numpy.zeros((_0._numNonzeros_(),), dtype=numpy.dtype(numpy.float64))
     _0._getDataAsTriplets__3I_3I_3D(_17,_18,_19)
     fragments._c_closure_284(_12,_15,_17,_18,_19) 
    else:
     _15 = _0._getDataAsArray_()
    if _1._isSparse_():
     _16 = numpy.zeros((_14,), dtype=numpy.dtype(numpy.float64))
     _20=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
     _21=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
     _22=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.float64))
     _1._getDataAsTriplets__3I_3I_3D(_20,_21,_22)
     fragments._c_closure_285(_12,_20,_21,_16,_22) 
    else:
     _16 = _1._getDataAsArray_()
    return (mosek_fusion_RangeDomain._ctor_Z_3D_3D_3I_3_5II(False,_15,_16,numpy.array([(_0._dimi),(_0._dimj)], dtype=numpy.dtype(numpy.int32)),None,1))
  @staticmethod
  def __mkRangedDomain_alt__3_5D_3_5D(_t__0,_t__1):
   _0=numpy.array(_t__0,ndmin=_monty.checkShape(_t__0,2),dtype=numpy.dtype(numpy.float64))
   _1=numpy.array(_t__1,ndmin=_monty.checkShape(_t__1,2),dtype=numpy.dtype(numpy.float64))
   _1_res = mosek_fusion_Domain.__mkRangedDomain__3_5D_3_5D(_0,_1)
   return _1_res
  @staticmethod
  def __mkRangedDomain__3_5D_3_5D(_0,_1):
   if ((int((_0).shape[0])!=int((_1).shape[0])) or (int((_0).shape[1])!=int((_1).shape[1]))):
    raise mosek_fusion_DimensionError._ctor_S("Mismatching dimensions in domain")
   _2=int((_0).shape[1])
   _3=int((_0).shape[0])
   _4=(_3 * _2)
   _5=numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   _6=numpy.zeros((_4,), dtype=numpy.dtype(numpy.float64))
   _7=0
   _7 = fragments._c_closure_286(_3,_2,_7,_0,_5,_1,_6)
   _7 = numpy.int32(_7) # postprocess
   return (mosek_fusion_RangeDomain._ctor_Z_3D_3D_3I_3_5II(False,_5,_6,numpy.array([_3,_2], dtype=numpy.dtype(numpy.int32)),None,1))
  @staticmethod
  def __mkLinearDomain_alt_Emosek_4fusion_4RelationKey_2Lmosek_4fusion_4Matrix_2(_t__0,_t__1):
    return mosek_fusion_Domain.__mkLinearDomain_Emosek_4fusion_4RelationKey_2Lmosek_4fusion_4Matrix_2(__0,_1)
  @staticmethod
  def __mkLinearDomain_Emosek_4fusion_4RelationKey_2Lmosek_4fusion_4Matrix_2(_0,_1):
   if _1._isSparse_():
    _2=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _3=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.int32))
    _4=numpy.zeros((_1._numNonzeros_(),), dtype=numpy.dtype(numpy.float64))
    _1._getDataAsTriplets__3I_3I_3D(_2,_3,_4)
    _5=numpy.zeros((int((_2).shape[0]),2,), dtype=numpy.dtype(numpy.int32))
    fragments._c_closure_287(_5,_2,_3) 
    return (mosek_fusion_LinearDomain._ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(_0,False,_4,numpy.array([(_1._dimi),(_1._dimj)], dtype=numpy.dtype(numpy.int32)),_5,1))
   else:
    return (mosek_fusion_LinearDomain._ctor_Emosek_4fusion_4RelationKey_2Z_3D_3I_3_5II(_0,False,_1._getDataAsArray_(),numpy.array([(_1._dimi),(_1._dimj)], dtype=numpy.dtype(numpy.int32)),None,1))
  @staticmethod
  def __prod_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain.__prod__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __prod__3I(_0):
   _1=1
   _1 = fragments._c_closure_288(_0,_1)
   _1 = numpy.int64(_1) # postprocess
   return numpy.int64(_1)
  @staticmethod
  def __inRange_alt_Z_3D_3D_3_5I_3I(_t__0,_t__1,_t__2,_t__3,_t__4):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.float64))
   _2=numpy.array(_t__2,dtype=numpy.dtype(numpy.float64))
   _3=numpy.array(_t__3,ndmin=_monty.checkShape(_t__3,2),dtype=numpy.dtype(numpy.int32))
   _4=numpy.array(_t__4,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain.__inRange_Z_3D_3D_3_5I_3I(_0,_1,_2,_3,_4)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__2[:] = _2
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__4[:] = _4
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def __inRange_Z_3D_3D_3_5I_3I(_0,_1,_2,_3,_4):
   if ((not _0) and (int((_1).shape[0])!=int((_2).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching lengths of upper and lower bounds.")
   if ((_3 is not None) and (int((_3).shape[0])!=int((_1).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching lengths of upper/lower bounds and sparsity.")
   for _5 in range(0,int((_2).shape[0])):
    if (_1[_5] > _2[_5]):
     raise mosek_fusion_DomainError._ctor_S("Invalid range specified")
   if ((_4 is not None) and (mosek.fusion.Domain.__dimsize__3I(_4)!=int((_1).shape[0]))):
    raise mosek_fusion_LengthError._ctor_S("Mismatching dimensions.")
   return (mosek_fusion_RangeDomain._ctor_Z_3D_3D_3I(_0,_1,_2,_4)._sparse__3_5I(_3))
  @staticmethod
  def _match_symmetric_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _match_alt_symmetric_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _symmetric_alt_Lmosek_4fusion_4RangeDomain_2(_t__0):
    return mosek_fusion_Domain._symmetric_Lmosek_4fusion_4RangeDomain_2(_0)
  @staticmethod
  def _symmetric_Lmosek_4fusion_4RangeDomain_2(_0):
   return (_0._symmetric_())
  @staticmethod
  def _match_symmetric_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _match_alt_symmetric_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _symmetric_alt_Lmosek_4fusion_4LinearDomain_2(_t__0):
    return mosek_fusion_Domain._symmetric_Lmosek_4fusion_4LinearDomain_2(_0)
  @staticmethod
  def _symmetric_Lmosek_4fusion_4LinearDomain_2(_0):
   return (_0._symmetric_())
  @staticmethod
  def _match_sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0) and __arg_match__3_5I__(_1))
  @staticmethod
  def _match_alt_sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0) and __arg_alt_match__3_5I__(_1))
  @staticmethod
  def _sparse_alt_Lmosek_4fusion_4RangeDomain_2_3_5I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,ndmin=_monty.checkShape(_t__1,2),dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(_0,_1)
   return _1_res
  @staticmethod
  def _sparse_Lmosek_4fusion_4RangeDomain_2_3_5I(_0,_1):
   return (_0._sparse__3_5I(_1))
  @staticmethod
  def _match_sparse_Lmosek_4fusion_4RangeDomain_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_sparse_Lmosek_4fusion_4RangeDomain_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _sparse_alt_Lmosek_4fusion_4RangeDomain_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._sparse_Lmosek_4fusion_4RangeDomain_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _sparse_Lmosek_4fusion_4RangeDomain_2_3I(_0,_1):
   return (_0._sparse__3I(_1))
  @staticmethod
  def _match_sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0) and __arg_match__3_5I__(_1))
  @staticmethod
  def _match_alt_sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0) and __arg_alt_match__3_5I__(_1))
  @staticmethod
  def _sparse_alt_Lmosek_4fusion_4LinearDomain_2_3_5I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,ndmin=_monty.checkShape(_t__1,2),dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(_0,_1)
   return _1_res
  @staticmethod
  def _sparse_Lmosek_4fusion_4LinearDomain_2_3_5I(_0,_1):
   return (_0._sparse__3_5I(_1))
  @staticmethod
  def _match_sparse_Lmosek_4fusion_4LinearDomain_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_sparse_Lmosek_4fusion_4LinearDomain_2_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _sparse_alt_Lmosek_4fusion_4LinearDomain_2_3I(_t__0,_t__1):
   _0=_t__0
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._sparse_Lmosek_4fusion_4LinearDomain_2_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _sparse_Lmosek_4fusion_4LinearDomain_2_3I(_0,_1):
   return (_0._sparse__3I(_1))
  @staticmethod
  def _match_integral_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _match_alt_integral_Lmosek_4fusion_4RangeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4RangeDomain_2__(_0))
  @staticmethod
  def _integral_alt_Lmosek_4fusion_4RangeDomain_2(_t__0):
    return mosek_fusion_Domain._integral_Lmosek_4fusion_4RangeDomain_2(_0)
  @staticmethod
  def _integral_Lmosek_4fusion_4RangeDomain_2(_0):
   return (_0._integral_())
  @staticmethod
  def _match_integral_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _match_alt_integral_Lmosek_4fusion_4LinearDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4LinearDomain_2__(_0))
  @staticmethod
  def _integral_alt_Lmosek_4fusion_4LinearDomain_2(_t__0):
    return mosek_fusion_Domain._integral_Lmosek_4fusion_4LinearDomain_2(_0)
  @staticmethod
  def _integral_Lmosek_4fusion_4LinearDomain_2(_0):
   return (_0._integral_())
  @staticmethod
  def _match_integral_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(_0))
  @staticmethod
  def _match_alt_integral_Lmosek_4fusion_4ConeDomain_2(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_0))
  @staticmethod
  def _integral_alt_Lmosek_4fusion_4ConeDomain_2(_t__0):
    return mosek_fusion_Domain._integral_Lmosek_4fusion_4ConeDomain_2(_0)
  @staticmethod
  def _integral_Lmosek_4fusion_4ConeDomain_2(_0):
   return (_0._integral_())
  @staticmethod
  def _match_axis_Lmosek_4fusion_4ConeDomain_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_Lmosek_4fusion_4ConeDomain_2__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_axis_Lmosek_4fusion_4ConeDomain_2I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_Lmosek_4fusion_4ConeDomain_2__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _axis_alt_Lmosek_4fusion_4ConeDomain_2I(_t__0,_t__1):
    return mosek_fusion_Domain._axis_Lmosek_4fusion_4ConeDomain_2I(_0,numpy.int32(__1))
  @staticmethod
  def _axis_Lmosek_4fusion_4ConeDomain_2I(_0,_1):
   return (_0._axis_I(_1))
  @staticmethod
  def _match_inDPowerCone__3D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_inDPowerCone__3D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _inDPowerCone_alt__3D_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inDPowerCone__3D_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDPowerCone__3D_3I(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,_0,numpy.array([_1[_2] for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDPowerCone__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inDPowerCone__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inDPowerCone_alt__3DI(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Domain._inDPowerCone__3DI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDPowerCone__3DI(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,_0,numpy.array([_1,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDPowerCone__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_inDPowerCone__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  @staticmethod
  def _inDPowerCone_alt__3D(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = mosek_fusion_Domain._inDPowerCone__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDPowerCone__3D(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,_0,None))
  @staticmethod
  def _match_inDPowerCone_D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_D__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_inDPowerCone_D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_D__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _inDPowerCone_alt_D_3I(_t__0,_t__1):
   _0=numpy.float64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inDPowerCone_D_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDPowerCone_D_3I(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),numpy.array([_1[_2] for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDPowerCone_DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_D__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inDPowerCone_DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_D__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inDPowerCone_alt_DI(_t__0,_t__1):
    return mosek_fusion_Domain._inDPowerCone_DI(numpy.float64(__0),numpy.int32(__1))
  @staticmethod
  def _inDPowerCone_DI(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),numpy.array([_1,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDPowerCone_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_inDPowerCone_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  @staticmethod
  def _inDPowerCone_alt_D(_t__0):
    return mosek_fusion_Domain._inDPowerCone_D(numpy.float64(__0))
  @staticmethod
  def _inDPowerCone_D(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InDPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),None))
  @staticmethod
  def _match_inPPowerCone__3D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_inPPowerCone__3D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _inPPowerCone_alt__3D_3I(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inPPowerCone__3D_3I(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPPowerCone__3D_3I(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,_0,numpy.array([_1[_2] for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPPowerCone__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match__3D__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inPPowerCone__3DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match__3D__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inPPowerCone_alt__3DI(_t__0,_t__1):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1=numpy.int32(_t__1)
   _1_res = mosek_fusion_Domain._inPPowerCone__3DI(_0,_1)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPPowerCone__3DI(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,_0,numpy.array([_1,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPPowerCone__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3D__(_0))
  @staticmethod
  def _match_alt_inPPowerCone__3D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3D__(_0))
  @staticmethod
  def _inPPowerCone_alt__3D(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.float64))
   _1_res = mosek_fusion_Domain._inPPowerCone__3D(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPPowerCone__3D(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,_0,None))
  @staticmethod
  def _match_inPPowerCone_D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_D__(_0) and __arg_match__3I__(_1))
  @staticmethod
  def _match_alt_inPPowerCone_D_3I(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_D__(_0) and __arg_alt_match__3I__(_1))
  @staticmethod
  def _inPPowerCone_alt_D_3I(_t__0,_t__1):
   _0=numpy.float64(_t__0)
   _1=numpy.array(_t__1,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inPPowerCone_D_3I(_0,_1)
   try:
     _t__1[:] = _1
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPPowerCone_D_3I(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),numpy.array([_1[_2] for _2 in range(0,int((_1).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPPowerCone_DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_D__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inPPowerCone_DI(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_D__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inPPowerCone_alt_DI(_t__0,_t__1):
    return mosek_fusion_Domain._inPPowerCone_DI(numpy.float64(__0),numpy.int32(__1))
  @staticmethod
  def _inPPowerCone_DI(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),numpy.array([_1,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPPowerCone_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_D__(_0))
  @staticmethod
  def _match_alt_inPPowerCone_D(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_D__(_0))
  @staticmethod
  def _inPPowerCone_alt_D(_t__0):
    return mosek_fusion_Domain._inPPowerCone_D(numpy.float64(__0))
  @staticmethod
  def _inPPowerCone_D(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3D_3I(mosek.fusion.QConeKey.InPPowCone,numpy.array([_0,(1.0 - _0)], dtype=numpy.dtype(numpy.float64)),None))
  @staticmethod
  def _match_inDExpCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inDExpCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inDExpCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inDExpCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDExpCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDExpCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDExpCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_inDExpCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _inDExpCone_alt_I(_t__0):
    return mosek_fusion_Domain._inDExpCone_I(numpy.int32(__0))
  @staticmethod
  def _inDExpCone_I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDExpCone,numpy.array([_0,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDExpCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inDExpCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _inDExpCone_alt_():
    return mosek_fusion_Domain._inDExpCone_()
  @staticmethod
  def _inDExpCone_():
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDExpCone,None))
  @staticmethod
  def _match_inPExpCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inPExpCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inPExpCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inPExpCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPExpCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPExpCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPExpCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_inPExpCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _inPExpCone_alt_I(_t__0):
    return mosek_fusion_Domain._inPExpCone_I(numpy.int32(__0))
  @staticmethod
  def _inPExpCone_I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPExpCone,numpy.array([_0,3], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPExpCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inPExpCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _inPExpCone_alt_():
    return mosek_fusion_Domain._inPExpCone_()
  @staticmethod
  def _inPExpCone_():
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPExpCone,None))
  @staticmethod
  def _match_inDGeoMeanCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inDGeoMeanCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inDGeoMeanCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inDGeoMeanCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inDGeoMeanCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDGeoMeanCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDGeoMeanCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inDGeoMeanCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inDGeoMeanCone_alt_II(_t__0,_t__1):
    return mosek_fusion_Domain._inDGeoMeanCone_II(numpy.int32(__0),numpy.int32(__1))
  @staticmethod
  def _inDGeoMeanCone_II(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDGeoMeanCone,numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDGeoMeanCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_inDGeoMeanCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _inDGeoMeanCone_alt_I(_t__0):
    return mosek_fusion_Domain._inDGeoMeanCone_I(numpy.int32(__0))
  @staticmethod
  def _inDGeoMeanCone_I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDGeoMeanCone,numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inDGeoMeanCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inDGeoMeanCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _inDGeoMeanCone_alt_():
    return mosek_fusion_Domain._inDGeoMeanCone_()
  @staticmethod
  def _inDGeoMeanCone_():
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InDGeoMeanCone,None))
  @staticmethod
  def _match_inPGeoMeanCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inPGeoMeanCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inPGeoMeanCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inPGeoMeanCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inPGeoMeanCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPGeoMeanCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPGeoMeanCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inPGeoMeanCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inPGeoMeanCone_alt_II(_t__0,_t__1):
    return mosek_fusion_Domain._inPGeoMeanCone_II(numpy.int32(__0),numpy.int32(__1))
  @staticmethod
  def _inPGeoMeanCone_II(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPGeoMeanCone,numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPGeoMeanCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_inPGeoMeanCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _inPGeoMeanCone_alt_I(_t__0):
    return mosek_fusion_Domain._inPGeoMeanCone_I(numpy.int32(__0))
  @staticmethod
  def _inPGeoMeanCone_I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPGeoMeanCone,numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inPGeoMeanCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inPGeoMeanCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _inPGeoMeanCone_alt_():
    return mosek_fusion_Domain._inPGeoMeanCone_()
  @staticmethod
  def _inPGeoMeanCone_():
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InPGeoMeanCone,None))
  @staticmethod
  def _match_inRotatedQCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inRotatedQCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inRotatedQCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inRotatedQCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inRotatedQCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InRotatedQCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inRotatedQCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inRotatedQCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inRotatedQCone_alt_II(_t__0,_t__1):
    return mosek_fusion_Domain._inRotatedQCone_II(numpy.int32(__0),numpy.int32(__1))
  @staticmethod
  def _inRotatedQCone_II(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InRotatedQCone,numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inRotatedQCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match_I__(_0))
  @staticmethod
  def _match_alt_inRotatedQCone_I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match_I__(_0))
  @staticmethod
  def _inRotatedQCone_alt_I(_t__0):
    return mosek_fusion_Domain._inRotatedQCone_I(numpy.int32(__0))
  @staticmethod
  def _inRotatedQCone_I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InRotatedQCone,numpy.array([_0], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inRotatedQCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _match_alt_inRotatedQCone_(*args):
    if len(args) != 0: return False
    return True
  @staticmethod
  def _inRotatedQCone_alt_():
    return mosek_fusion_Domain._inRotatedQCone_()
  @staticmethod
  def _inRotatedQCone_():
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InRotatedQCone,None))
  @staticmethod
  def _match_inQCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_match__3I__(_0))
  @staticmethod
  def _match_alt_inQCone__3I(*args):
    if len(args) != 1: return False
    _0, = args
    return (__arg_alt_match__3I__(_0))
  @staticmethod
  def _inQCone_alt__3I(_t__0):
   _0=numpy.array(_t__0,dtype=numpy.dtype(numpy.int32))
   _1_res = mosek_fusion_Domain._inQCone__3I(_0)
   try:
     _t__0[:] = _0
   except TypeError:
     pass # if we cannot copy back - ignore it
   return _1_res
  @staticmethod
  def _inQCone__3I(_0):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InQCone,numpy.array([_0[_1] for _1 in range(0,int((_0).shape[0]))], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inQCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_match_I__(_0) and __arg_match_I__(_1))
  @staticmethod
  def _match_alt_inQCone_II(*args):
    if len(args) != 2: return False
    _0,_1, = args
    return (__arg_alt_match_I__(_0) and __arg_alt_match_I__(_1))
  @staticmethod
  def _inQCone_alt_II(_t__0,_t__1):
    return mosek_fusion_Domain._inQCone_II(numpy.int32(__0),numpy.int32(__1))
  @staticmethod
  def _inQCone_II(_0,_1):
   return (mosek_fusion_ConeDomain._ctor_Emosek_4fusion_4QConeKey_2_3I(mosek.fusion.QConeKey.InQCone,numpy.array([_0,_1], dtype=numpy.dtype(numpy.int32))))
  @staticmethod
  def _match_inQCone_I(*args):