/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import java.io.OutputStream;
import java.io.Writer;
import mosek.DataCallback;
import mosek.Progress;
import mosek.Task;
import mosek.fusion.AccSolutionStatus;
import mosek.fusion.BaseModel;
import mosek.fusion.CommonTools;
import mosek.fusion.ConeDomain;
import mosek.fusion.ConicConstraint;
import mosek.fusion.ConicVariable;
import mosek.fusion.Constraint;
import mosek.fusion.DJCDomain;
import mosek.fusion.DJCDomainType;
import mosek.fusion.DeletionError;
import mosek.fusion.DimensionError;
import mosek.fusion.Disjunction;
import mosek.fusion.DisjunctionTerms;
import mosek.fusion.Domain;
import mosek.fusion.DomainError;
import mosek.fusion.Expr;
import mosek.fusion.ExprCompress;
import mosek.fusion.ExprConicDomain;
import mosek.fusion.ExprDense;
import mosek.fusion.ExprDenseTril;
import mosek.fusion.ExprDomain;
import mosek.fusion.ExprLinearDomain;
import mosek.fusion.ExprOptimizeCode;
import mosek.fusion.ExprPSDDomain;
import mosek.fusion.ExprRangeDomain;
import mosek.fusion.ExprScaleVecPSD;
import mosek.fusion.ExprSymmetrize;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.LinearConstraint;
import mosek.fusion.LinearDomain;
import mosek.fusion.LinearVariable;
import mosek.fusion.LinkedBlocks;
import mosek.fusion.ModelConstraint;
import mosek.fusion.ModelVariable;
import mosek.fusion.NameError;
import mosek.fusion.ObjectiveSense;
import mosek.fusion.OptimizeError;
import mosek.fusion.PSDDomain;
import mosek.fusion.PSDKey;
import mosek.fusion.PSDVariable;
import mosek.fusion.Parameter;
import mosek.fusion.ParameterImpl;
import mosek.fusion.Parameters;
import mosek.fusion.ProblemStatus;
import mosek.fusion.QConeKey;
import mosek.fusion.RangeDomain;
import mosek.fusion.RangedConstraint;
import mosek.fusion.RangedVariable;
import mosek.fusion.RelationKey;
import mosek.fusion.RowBlockManager;
import mosek.fusion.Set;
import mosek.fusion.SolutionError;
import mosek.fusion.SolutionStatus;
import mosek.fusion.SolutionStruct;
import mosek.fusion.SolutionType;
import mosek.fusion.SolverStatus;
import mosek.fusion.SparseFormatError;
import mosek.fusion.Term;
import mosek.fusion.UnexpectedError;
import mosek.fusion.UpdateError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.Utils.StringIntMap;
import mosek.fusion.Utils.Tools;
import mosek.fusion.Variable;
import mosek.fusion.WorkStack;

public class Model
extends BaseModel {
    private WorkStack xs;
    private WorkStack ws;
    private WorkStack rs;
    private SolutionStruct sol_itg;
    private SolutionStruct sol_bas;
    private SolutionStruct sol_itr;
    private StringIntMap con_map;
    private ModelConstraint[] acons;
    private ModelConstraint[] cons;
    private long task_numaferow;
    private double[] param_value;
    private int param_num;
    private StringIntMap par_map;
    private int numparameter;
    private Parameter[] parameters;
    private boolean[] initsol_xx_flag;
    private double[] initsol_xx;
    private StringIntMap var_map;
    private ModelVariable[] barvars;
    private ModelVariable[] vars;
    private int bfixidx;
    private int[] barvar_block_elm_j;
    private int[] barvar_block_elm_i;
    private int[] barvar_block_elm_barj;
    private int[] barvar_block_elm_ptr;
    private int[] barvar_block_dim;
    private int[] barvar_block_ptr;
    private int[] barvar_dim;
    private int barvar_num;
    private int[] var_elm_acc_ofs;
    private int[] var_elm_acc_idx;
    private int[] var_block_acc_id;
    private LinkedBlocks var_block_map;
    private int[] acon_elm_afe;
    private int[] acon_elm_ofs;
    private double[] acon_elm_scale;
    private int[] acon_elm_accid;
    private int[] acon_afe;
    private int[] acon_acc;
    private LinkedBlocks acon_block_map;
    private LinkedBlocks acc_block_map;
    private RowBlockManager obj_blocks;
    private RowBlockManager afe_blocks;
    private RowBlockManager con_blocks;
    private int num_task_acc;
    private int num_task_afe;
    private int num_task_con;
    private SolutionType solutionptr;
    private AccSolutionStatus acceptable_sol;
    private String model_name;

    private Model(Model model) {
        super(model);
        Parameter[] parameterArray;
        Model model2 = this;
        this.model_name = model.model_name;
        this.acceptable_sol = model.acceptable_sol;
        this.solutionptr = model.solutionptr;
        this.sol_itr = model.sol_itr != null ? model.sol_itr.clone() : null;
        this.sol_itg = model.sol_itg != null ? model.sol_itg.clone() : null;
        this.sol_bas = model.sol_bas != null ? model.sol_bas.clone() : null;
        this.num_task_afe = model.num_task_afe;
        this.num_task_con = model.num_task_con;
        this.num_task_acc = model.num_task_acc;
        this.con_blocks = new RowBlockManager(model.con_blocks);
        this.afe_blocks = new RowBlockManager(model.afe_blocks);
        this.obj_blocks = new RowBlockManager(model.obj_blocks);
        this.acc_block_map = new LinkedBlocks(model.acc_block_map);
        this.acon_block_map = new LinkedBlocks(model.acon_block_map);
        this.acon_acc = Tools.arraycopy(model.acon_acc);
        this.acon_afe = Tools.arraycopy(model.acon_afe);
        this.acon_elm_accid = Tools.arraycopy(model.acon_elm_accid);
        this.acon_elm_scale = Tools.arraycopy(model.acon_elm_scale);
        this.acon_elm_ofs = Tools.arraycopy(model.acon_elm_ofs);
        this.acon_elm_afe = Tools.arraycopy(model.acon_elm_afe);
        this.task_numaferow = model.task_numaferow;
        this.var_block_map = new LinkedBlocks(model.var_block_map);
        this.var_block_acc_id = Tools.arraycopy(model.var_block_acc_id);
        this.var_elm_acc_idx = Tools.arraycopy(model.var_elm_acc_idx);
        this.var_elm_acc_ofs = Tools.arraycopy(model.var_elm_acc_ofs);
        this.barvar_num = 0;
        this.barvar_dim = Tools.arraycopy(model.barvar_dim);
        this.barvar_block_ptr = Tools.arraycopy(model.barvar_block_ptr);
        this.barvar_block_dim = Tools.arraycopy(model.barvar_block_dim);
        this.barvar_block_elm_ptr = Tools.arraycopy(model.barvar_block_elm_ptr);
        this.barvar_block_elm_barj = Tools.arraycopy(model.barvar_block_elm_barj);
        this.barvar_block_elm_i = Tools.arraycopy(model.barvar_block_elm_i);
        this.barvar_block_elm_j = Tools.arraycopy(model.barvar_block_elm_j);
        int n = 0;
        int n2 = 0;
        int n3 = model.vars.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        ModelVariable[] modelVariableArray = new ModelVariable[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            modelVariableArray[n] = model.vars[n5] != null ? model.vars[n5].clone(model2) : null;
            ++n;
            ++n6;
            ++n5;
        }
        this.vars = modelVariableArray;
        n6 = 0;
        int n7 = 0;
        int n8 = model.barvars.length;
        int n9 = n7 < n8 ? n8 - n7 : 0;
        ModelVariable[] modelVariableArray2 = new ModelVariable[n9];
        int n10 = n7;
        int n11 = 0;
        while (n11 < n9) {
            modelVariableArray2[n6] = model.barvars[n10] != null ? model.barvars[n10].clone(model2) : null;
            ++n6;
            ++n11;
            ++n10;
        }
        this.barvars = modelVariableArray2;
        this.var_map = model.var_map.clone();
        n11 = 0;
        int n12 = 0;
        int n13 = model.cons.length;
        int n14 = n12 < n13 ? n13 - n12 : 0;
        ModelConstraint[] modelConstraintArray = new ModelConstraint[n14];
        int n15 = n12;
        int n16 = 0;
        while (n16 < n14) {
            modelConstraintArray[n11] = model.cons[n15] != null ? model.cons[n15].clone(model2) : null;
            ++n11;
            ++n16;
            ++n15;
        }
        this.cons = modelConstraintArray;
        n16 = 0;
        int n17 = 0;
        int n18 = model.acons.length;
        int n19 = n17 < n18 ? n18 - n17 : 0;
        ModelConstraint[] modelConstraintArray2 = new ModelConstraint[n19];
        int n20 = n17;
        int n21 = 0;
        while (n21 < n19) {
            modelConstraintArray2[n16] = model.acons[n20] != null ? model.acons[n20].clone(model2) : null;
            ++n16;
            ++n21;
            ++n20;
        }
        this.acons = modelConstraintArray2;
        this.con_map = model.con_map.clone();
        this.numparameter = model.numparameter;
        if (model.parameters == null) {
            parameterArray = null;
        } else {
            int n22 = 0;
            int n23 = 0;
            int n24 = model.parameters.length;
            int n25 = n23 < n24 ? n24 - n23 : 0;
            Parameter[] parameterArray2 = new Parameter[n25];
            int n26 = n23;
            int n27 = 0;
            while (n27 < n25) {
                parameterArray2[n22] = model.parameters[n26] != null ? model.parameters[n26].clone(model2) : null;
                ++n22;
                ++n27;
                ++n26;
            }
            parameterArray = parameterArray2;
        }
        this.parameters = parameterArray;
        this.par_map = model.par_map.clone();
        this.param_num = model.param_num;
        this.param_value = model.param_value != null ? Tools.arraycopy(model.param_value) : null;
        this.initsol_xx = null;
        this.initsol_xx_flag = null;
        this.bfixidx = model.bfixidx;
        this.rs = new WorkStack();
        this.ws = new WorkStack();
        this.xs = new WorkStack();
    }

    public Model(String string, int n) {
        super(string, "");
        this.model_name = string;
        this.acceptable_sol = AccSolutionStatus.Optimal;
        this.solutionptr = SolutionType.Default;
        this.sol_itr = null;
        this.sol_itg = null;
        this.sol_bas = null;
        this.num_task_afe = 0;
        this.num_task_con = 0;
        this.num_task_acc = 0;
        this.con_blocks = new RowBlockManager();
        this.afe_blocks = new RowBlockManager();
        this.obj_blocks = new RowBlockManager();
        this.acc_block_map = new LinkedBlocks();
        this.acon_block_map = new LinkedBlocks();
        this.task_numaferow = 0L;
        this.acon_acc = new int[this.acon_block_map.block_capacity()];
        this.acon_afe = new int[this.acon_block_map.block_capacity()];
        this.acon_elm_accid = new int[this.acon_block_map.capacity()];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.acon_block_map.capacity();
        int n5 = n3 < n4 ? n4 - n3 : 0;
        double[] dArray = new double[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n2] = 1.0;
            ++n2;
            ++n7;
            ++n6;
        }
        this.acon_elm_scale = dArray;
        this.acon_elm_ofs = new int[this.acon_block_map.capacity()];
        this.acon_elm_afe = new int[this.acon_block_map.capacity()];
        this.var_block_map = new LinkedBlocks();
        this.var_block_acc_id = new int[this.var_block_map.block_capacity()];
        this.var_elm_acc_idx = new int[this.var_block_map.capacity()];
        this.var_elm_acc_ofs = new int[this.var_block_map.capacity()];
        this.barvar_num = 0;
        this.barvar_dim = new int[n];
        this.barvar_block_ptr = new int[n + 1];
        this.barvar_block_dim = new int[n];
        this.barvar_block_elm_ptr = new int[n + 1];
        this.barvar_block_elm_barj = new int[n];
        this.barvar_block_elm_i = new int[n];
        this.barvar_block_elm_j = new int[n];
        n7 = 0;
        int n8 = 0;
        int n9 = n * 8;
        int n10 = n8 < n9 ? n9 - n8 : 0;
        ModelVariable[] modelVariableArray = new ModelVariable[n10];
        int n11 = n8;
        int n12 = 0;
        while (n12 < n10) {
            modelVariableArray[n7] = null;
            ++n7;
            ++n12;
            ++n11;
        }
        this.vars = modelVariableArray;
        n12 = 0;
        int n13 = 0;
        int n14 = n;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        ModelVariable[] modelVariableArray2 = new ModelVariable[n15];
        int n16 = n13;
        int n17 = 0;
        while (n17 < n15) {
            modelVariableArray2[n12] = null;
            ++n12;
            ++n17;
            ++n16;
        }
        this.barvars = modelVariableArray2;
        this.var_map = new StringIntMap();
        this.initsol_xx = null;
        this.initsol_xx_flag = null;
        n17 = 0;
        int n18 = 0;
        int n19 = n * 8;
        int n20 = n18 < n19 ? n19 - n18 : 0;
        ModelConstraint[] modelConstraintArray = new ModelConstraint[n20];
        int n21 = n18;
        int n22 = 0;
        while (n22 < n20) {
            modelConstraintArray[n17] = null;
            ++n17;
            ++n22;
            ++n21;
        }
        this.cons = modelConstraintArray;
        n22 = 0;
        int n23 = 0;
        int n24 = n * 8;
        int n25 = n23 < n24 ? n24 - n23 : 0;
        ModelConstraint[] modelConstraintArray2 = new ModelConstraint[n25];
        int n26 = n23;
        int n27 = 0;
        while (n27 < n25) {
            modelConstraintArray2[n22] = null;
            ++n22;
            ++n27;
            ++n26;
        }
        this.acons = modelConstraintArray2;
        this.con_map = new StringIntMap();
        this.numparameter = 0;
        this.parameters = null;
        this.par_map = new StringIntMap();
        this.param_num = 0;
        this.param_value = null;
        int[] nArray = new int[1];
        int n28 = this.linearvar_alloc(1, nArray);
        this.bfixidx = nArray[0];
        this.task_var_putboundlist_fx(new int[]{this.bfixidx}, new double[]{1.0});
        this.task_var_name(this.bfixidx, "1.0");
        this.task_append_domain_empty();
        this.rs = new WorkStack();
        this.ws = new WorkStack();
        this.xs = new WorkStack();
    }

    public Model(int n) {
        this("", n);
    }

    public Model(String string) {
        this(string, 128);
    }

    public Model() {
        this("");
    }

    public Disjunction disjunction(String string, Term[] termArray) {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = termArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n5;
        for (int i = n10; i < n11; ++i) {
            n6 += termArray[i].size();
            n7 += termArray[i].num();
            n9 += termArray[i].numaccrows();
            n8 += termArray[i].numaccterms();
        }
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n9];
        double[] dArray = new double[n9];
        long[] lArray = new long[n8];
        long[] lArray2 = new long[n5];
        int n12 = this.afe_allocate(nArray);
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = n5;
        for (n4 = n17; n4 < n18; ++n4) {
            n3 = 0;
            n2 = termArray[n4].num();
            for (n = n3; n < n2; ++n) {
                int n19;
                int n20;
                object = termArray[n4].domains[n];
                ExprDense exprDense = new ExprDense(new ExprOptimizeCode(new ExprCompress(termArray[n4].exprs[n])));
                exprDense.eval(this.rs, this.ws, this.xs);
                this.rs.pop_expr();
                int[] nArray3 = this.rs.i32;
                long[] lArray3 = this.rs.i64;
                double[] dArray2 = this.rs.f64;
                int n21 = this.rs.nd;
                int n22 = this.rs.shape_base;
                int n23 = this.rs.nelem;
                int n24 = this.rs.nnz;
                int n25 = this.rs.ncodeatom;
                boolean bl = this.rs.hassp;
                int n26 = this.rs.ptr_base;
                int n27 = this.rs.nidxs_base;
                int n28 = this.rs.cof_base;
                int n29 = this.rs.code_base;
                int n30 = this.rs.codeptr_base;
                int n31 = this.rs.cconst_base;
                int n32 = 0;
                int n33 = 0;
                int n34 = n21;
                int n35 = n33 < n34 ? n34 - n33 : 0;
                int[] nArray4 = new int[n35];
                int n36 = n33;
                int n37 = 0;
                while (n37 < n35) {
                    nArray4[n32] = nArray3[n22 + n36];
                    ++n32;
                    ++n37;
                    ++n36;
                }
                int[] nArray5 = nArray4;
                this.putfrows(nArray, n16, this.rs, n23, n24, n26, n27, n28);
                if (((DJCDomain)object).dom == DJCDomainType.InRange) {
                    var48_55 = ((DJCDomain)object).b;
                    double[] dArray3 = ((DJCDomain)object).par;
                    n20 = 0;
                    n19 = n23;
                    for (int i = n20; i < n19; ++i) {
                        nArray2[n15 + i] = nArray[n16 + i];
                        nArray2[n15 + n23 + i] = nArray[n16 + i];
                        dArray[n15 + i] = var48_55[i];
                        dArray[n15 + n23 + i] = dArray3[i];
                    }
                    lArray[n14] = this.task_append_domain_rpos(n23);
                    lArray[n14 + 1] = this.task_append_domain_rneg(n23);
                    int n38 = n4;
                    lArray2[n38] = lArray2[n38] + 2L;
                    n14 += 2;
                    n15 += n23 * 2;
                } else if (((DJCDomain)object).dom == DJCDomainType.EqualTo || ((DJCDomain)object).dom == DJCDomainType.LessThan || ((DJCDomain)object).dom == DJCDomainType.GreaterThan || ((DJCDomain)object).dom == DJCDomainType.IsFree) {
                    var48_55 = ((DJCDomain)object).b;
                    int n39 = 0;
                    n20 = n23;
                    for (n19 = n39; n19 < n20; ++n19) {
                        nArray2[n15 + n19] = nArray[n16 + n19];
                        dArray[n15 + n19] = var48_55[n19];
                    }
                    lArray[n14] = ((DJCDomain)object).dom == DJCDomainType.EqualTo ? this.task_append_domain_rzero(n23) : (((DJCDomain)object).dom == DJCDomainType.LessThan ? this.task_append_domain_rneg(n23) : (((DJCDomain)object).dom == DJCDomainType.GreaterThan ? this.task_append_domain_rpos(n23) : this.task_append_domain_r(n23)));
                    int n40 = n4;
                    lArray2[n40] = lArray2[n40] + 1L;
                    ++n14;
                    n15 += n23;
                } else {
                    throw new UnexpectedError("Not implemented: Non-linear conic DJC constraints");
                }
                if (n25 > 0) {
                    int n41 = 0;
                    int n42 = 0;
                    n20 = n23;
                    n19 = n42 < n20 ? n20 - n42 : 0;
                    int[] nArray6 = new int[n19];
                    int n43 = n42;
                    int n44 = 0;
                    while (n44 < n19) {
                        nArray6[n41] = nArray[n16 + n43];
                        ++n41;
                        ++n44;
                        ++n43;
                    }
                    this.afe_blocks.replace_row_code(this.rs, nArray6, n26, n27, n30, n29, n31);
                }
                n16 += n23;
                ++n13;
            }
        }
        long l = this.task_append_djc(1L);
        n4 = 0;
        n3 = 0;
        n2 = nArray2.length;
        n = n3 < n2 ? n2 - n3 : 0;
        object = new long[n];
        int n45 = n3;
        int n46 = 0;
        while (n46 < n) {
            object[n4] = (long)nArray2[n45];
            ++n4;
            ++n46;
            ++n45;
        }
        this.task_putdjcslice(l, l + 1L, new long[]{n5}, lArray2, lArray, (long[])object, dArray);
        if (string.length() > 0) {
            this.task_djc_name(l, new StringBuffer().a(string).a("[").a("]").toString());
        }
        return new Disjunction(l);
    }

    public Disjunction disjunction(Term[] termArray) {
        return this.disjunction("", termArray);
    }

    public Disjunction disjunction(DisjunctionTerms disjunctionTerms) {
        return this.disjunction(disjunctionTerms.terms);
    }

    public Disjunction disjunction(String string, DisjunctionTerms disjunctionTerms) {
        return this.disjunction(string, disjunctionTerms.terms);
    }

    public Disjunction disjunction(String string, ExprDomain[] exprDomainArray) {
        int n = 0;
        int n2 = 0;
        int n3 = exprDomainArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        Term[] termArray = new Term[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            termArray[n] = exprDomainArray[n5].toDJCTerm();
            ++n;
            ++n6;
            ++n5;
        }
        return this.disjunction(string, termArray);
    }

    public Disjunction disjunction(ExprDomain[] exprDomainArray) {
        int n = 0;
        int n2 = 0;
        int n3 = exprDomainArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        Term[] termArray = new Term[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            termArray[n] = exprDomainArray[n5].toDJCTerm();
            ++n;
            ++n6;
            ++n5;
        }
        return this.disjunction("", termArray);
    }

    public Disjunction disjunction(String string, ExprDomain exprDomain) {
        return this.disjunction(string, new Term[]{exprDomain.toDJCTerm()});
    }

    public Disjunction disjunction(ExprDomain exprDomain) {
        return this.disjunction("", new Term[]{exprDomain.toDJCTerm()});
    }

    public Disjunction disjunction(Term term, Term term2, Term term3) {
        return this.disjunction("", new Term[]{term, term2, term3});
    }

    public Disjunction disjunction(Term term, Term term2) {
        return this.disjunction("", new Term[]{term, term2});
    }

    public Disjunction disjunction(Term term) {
        return this.disjunction("", new Term[]{term});
    }

    public Disjunction disjunction(String string, Term term, Term term2, Term term3) {
        return this.disjunction(string, new Term[]{term, term2, term3});
    }

    public Disjunction disjunction(String string, Term term, Term term2) {
        return this.disjunction(string, new Term[]{term, term2});
    }

    public Disjunction disjunction(String string, Term term) {
        return this.disjunction(string, new Term[]{term});
    }

    protected StringBuffer formstConstr(StringBuffer stringBuffer, int[] nArray, int[] nArray2) {
        return stringBuffer;
    }

    private void acon_release(int n) {
        int n2 = this.acon_block_map.blocksize(n);
        if (n2 >= 0) {
            int n3 = this.acc_block_map.blocksize(this.acon_acc[n]);
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n2];
            this.acc_block_map.get(this.acon_acc[n], nArray, 0);
            this.acc_block_map.free(this.acon_acc[n]);
            this.afe_blocks.get(this.acon_afe[n], nArray2, 0);
            this.afe_release(this.acon_afe[n]);
            this.acon_block_map.free(n);
            int n4 = 0;
            int n5 = 0;
            int n6 = n2;
            int n7 = n5 < n6 ? n6 - n5 : 0;
            long[] lArray = new long[n7];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n7) {
                lArray[n4] = nArray2[n8];
                ++n4;
                ++n9;
                ++n8;
            }
            this.task_clearafelist(lArray);
            n9 = 0;
            int n10 = 0;
            int n11 = n3;
            int n12 = n10 < n11 ? n11 - n10 : 0;
            long[] lArray2 = new long[n12];
            int n13 = n10;
            int n14 = 0;
            while (n14 < n12) {
                lArray2[n9] = nArray[n13];
                ++n9;
                ++n14;
                ++n13;
            }
            n14 = 0;
            int n15 = 0;
            int n16 = n3;
            int n17 = n15 < n16 ? n16 - n15 : 0;
            long[] lArray3 = new long[n17];
            int n18 = n15;
            int n19 = 0;
            while (n19 < n17) {
                lArray3[n14] = 0L;
                ++n14;
                ++n19;
                ++n18;
            }
            this.task_putacclist(lArray2, lArray3, new long[0], new double[0]);
        }
    }

    private int acon_allocate(long l, int n, int n2, double[] dArray, int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        int n5;
        Object[] objectArray;
        int n6;
        int n7;
        int n8;
        Object[] objectArray2;
        int[] nArray3;
        int n9 = n2 * n;
        int[] nArray4 = new int[n9];
        int n10 = this.acon_block_map.alloc(n9);
        int n11 = this.acc_block_map.alloc(n2);
        int n12 = this.afe_allocate(nArray);
        this.acon_block_map.get(n10, nArray4, 0);
        this.acc_block_map.get(n11, nArray2, 0);
        int n13 = this.acon_block_map.block_capacity();
        int n14 = this.acon_block_map.capacity();
        if (n13 > this.acon_acc.length) {
            nArray3 = new int[n13];
            objectArray2 = new int[n13];
            Tools.arraycopy(this.acon_acc, 0, nArray3, 0, this.acon_acc.length);
            Tools.arraycopy(this.acon_afe, 0, objectArray2, 0, this.acon_afe.length);
            this.acon_acc = nArray3;
            this.acon_afe = objectArray2;
        }
        this.acon_acc[n10] = n11;
        this.acon_afe[n10] = n12;
        if (n10 >= this.acons.length) {
            int n15 = 0;
            int n16 = 0;
            n8 = this.acons.length * 2;
            n7 = n16 < n8 ? n8 - n16 : 0;
            ModelConstraint[] modelConstraintArray = new ModelConstraint[n7];
            n6 = n16;
            int n17 = 0;
            while (n17 < n7) {
                modelConstraintArray[n15] = null;
                ++n15;
                ++n17;
                ++n6;
            }
            objectArray = modelConstraintArray;
            n5 = 0;
            n4 = this.acons.length;
            for (n3 = n5; n3 < n4; ++n3) {
                objectArray[n3] = this.acons[n3];
            }
            this.acons = objectArray;
        }
        if (n14 > this.acon_elm_accid.length) {
            nArray3 = new int[n14];
            objectArray2 = new double[n14];
            int[] nArray5 = new int[n14];
            int[] nArray6 = new int[n14];
            Tools.arraycopy(this.acon_elm_accid, 0, nArray3, 0, this.acon_elm_accid.length);
            Tools.arraycopy(this.acon_elm_scale, 0, (double[])objectArray2, 0, this.acon_elm_scale.length);
            Tools.arraycopy(this.acon_elm_ofs, 0, nArray5, 0, this.acon_elm_ofs.length);
            Tools.arraycopy(this.acon_elm_afe, 0, nArray6, 0, this.acon_elm_afe.length);
            this.acon_elm_accid = nArray3;
            this.acon_elm_ofs = nArray5;
            this.acon_elm_afe = nArray6;
            this.acon_elm_scale = objectArray2;
        }
        int n18 = 0;
        int n19 = 0;
        n8 = nArray2.length;
        for (n7 = n19; n7 < n8; ++n7) {
            if (nArray2[n7] <= n18) continue;
            n18 = nArray2[n7];
        }
        n19 = this.task_numacc();
        if (n19 < ++n18) {
            this.task_append_accs(0L, n18 - n19, new long[0], new double[0]);
        }
        n8 = 0;
        n7 = 0;
        int n20 = nArray2.length;
        n6 = n7 < n20 ? n20 - n7 : 0;
        objectArray = new long[n6];
        n5 = n7;
        n4 = 0;
        while (n4 < n6) {
            objectArray[n8] = (ModelConstraint)((long)nArray2[n5]);
            ++n8;
            ++n4;
            ++n5;
        }
        n4 = 0;
        n3 = 0;
        int n21 = nArray2.length;
        int n22 = n3 < n21 ? n21 - n3 : 0;
        long[] lArray = new long[n22];
        int n23 = n3;
        int n24 = 0;
        while (n24 < n22) {
            lArray[n4] = l;
            ++n4;
            ++n24;
            ++n23;
        }
        n24 = 0;
        int n25 = 0;
        int n26 = nArray.length;
        int n27 = n25 < n26 ? n26 - n25 : 0;
        long[] lArray2 = new long[n27];
        int n28 = n25;
        int n29 = 0;
        while (n29 < n27) {
            lArray2[n24] = nArray[n28];
            ++n24;
            ++n29;
            ++n28;
        }
        this.task_putacclist((long[])objectArray, lArray, lArray2, dArray);
        n29 = 0;
        int n30 = 0;
        int n31 = n2;
        for (int i = n30; i < n31; ++i) {
            int n32 = 0;
            int n33 = n;
            int n34 = n32;
            while (n34 < n33) {
                this.acon_elm_accid[nArray4[n29]] = nArray2[i];
                this.acon_elm_ofs[nArray4[n29]] = n34++;
                this.acon_elm_afe[nArray4[n29]] = nArray[n29];
                this.acon_elm_scale[nArray4[n29]] = 1.0;
                ++n29;
            }
        }
        return n10;
    }

    private void afe_release(int n) {
        int[] nArray = new int[this.afe_blocks.blocksize(n)];
        this.afe_blocks.release(n, nArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        long[] lArray = new long[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            lArray[n2] = nArray[n6];
            ++n2;
            ++n7;
            ++n6;
        }
        this.task_clearafelist(lArray);
    }

    private int afe_allocate(int[] nArray) {
        int n = this.afe_blocks.allocate(nArray);
        if (nArray.length > 0) {
            int n2 = this.task_numafe();
            int n3 = nArray[0];
            int n4 = 1;
            int n5 = nArray.length;
            for (int i = n4; i < n5; ++i) {
                if (nArray[i] <= n3) continue;
                n3 = nArray[i];
            }
            if (n3 + 1 > n2) {
                n4 = n3 + 1 - n2;
                this.task_append_afes(n4);
                this.task_numaferow += (long)n4;
            }
        }
        return n;
    }

    private void con_release(int n) {
        int n2 = this.con_blocks.blocksize(n);
        if (n2 >= 0) {
            int[] nArray = new int[n2];
            this.con_blocks.release(n, nArray);
            this.cons[n] = null;
            this.task_con_putboundlist_fr(nArray);
        }
    }

    private int con_allocate(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.con_blocks.allocate(nArray);
        if (nArray.length > 0) {
            n4 = nArray[0];
            n3 = 1;
            n2 = nArray.length;
            for (n = n3; n < n2; ++n) {
                if (nArray[n] <= n4) continue;
                n4 = nArray[n];
            }
            if (n4 + 1 > this.num_task_con) {
                n3 = n4 + 1 - this.num_task_con;
                this.task_append_con(n3);
                this.num_task_con += n3;
            }
        }
        if (n5 >= this.cons.length) {
            n4 = 0;
            n3 = 0;
            n2 = this.cons.length * 2;
            n = n3 < n2 ? n2 - n3 : 0;
            ModelConstraint[] modelConstraintArray = new ModelConstraint[n];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n) {
                modelConstraintArray[n4] = null;
                ++n4;
                ++n7;
                ++n6;
            }
            ModelConstraint[] modelConstraintArray2 = modelConstraintArray;
            int n8 = 0;
            int n9 = this.cons.length;
            for (int i = n8; i < n9; ++i) {
                modelConstraintArray2[i] = this.cons[i];
            }
            this.cons = modelConstraintArray2;
        }
        return n5;
    }

    private int barvar_alloc(int n, int n2, int[] nArray, long[] lArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray2;
        int n10 = this.barvar_num++;
        int n11 = n * (n + 1) / 2;
        int n12 = n11 * n2;
        int n13 = this.barvar_block_ptr[n10];
        int n14 = this.barvar_block_dim.length;
        int n15 = this.barvar_block_elm_ptr[n10];
        int n16 = this.barvar_block_elm_barj.length;
        if (n14 < n13 + 1) {
            int[] nArray3 = new int[this.barvar_block_dim.length * 2];
            int[] nArray4 = new int[this.barvar_block_dim.length * 2 + 1];
            nArray2 = new int[this.barvar_block_dim.length * 2 + 1];
            n9 = 0;
            n8 = 0;
            n7 = this.barvar_block_dim.length * 2 + 1;
            n6 = n8 < n7 ? n7 - n8 : 0;
            ModelVariable[] modelVariableArray = new ModelVariable[n6];
            n5 = n8;
            int n17 = 0;
            while (n17 < n6) {
                modelVariableArray[n9] = null;
                ++n9;
                ++n17;
                ++n5;
            }
            ModelVariable[] modelVariableArray2 = modelVariableArray;
            n4 = 0;
            n3 = this.barvars.length;
            for (int i = n4; i < n3; ++i) {
                modelVariableArray2[i] = this.barvars[i];
            }
            Tools.arraycopy(this.barvar_block_dim, 0, nArray3, 0, this.barvar_block_dim.length);
            Tools.arraycopy(this.barvar_block_ptr, 0, nArray4, 0, this.barvar_block_ptr.length);
            Tools.arraycopy(this.barvar_block_elm_ptr, 0, nArray2, 0, this.barvar_block_elm_ptr.length);
            this.barvar_block_dim = nArray3;
            this.barvar_block_ptr = nArray4;
            this.barvar_block_elm_ptr = nArray2;
            this.barvars = modelVariableArray2;
        }
        if (n16 < n15 + n12) {
            int n18 = n16 + n12 - n15;
            if (n18 < n16) {
                n18 = n16;
            }
            int n19 = n16 + n18;
            nArray2 = new int[n19];
            int[] nArray5 = new int[n19];
            int[] nArray6 = new int[n19];
            Tools.arraycopy(this.barvar_block_elm_barj, 0, nArray2, 0, this.barvar_block_elm_barj.length);
            Tools.arraycopy(this.barvar_block_elm_i, 0, nArray5, 0, this.barvar_block_elm_i.length);
            Tools.arraycopy(this.barvar_block_elm_j, 0, nArray6, 0, this.barvar_block_elm_j.length);
            this.barvar_block_elm_barj = nArray2;
            this.barvar_block_elm_i = nArray5;
            this.barvar_block_elm_j = nArray6;
        }
        int n20 = this.task_numbarvar();
        int n21 = 0;
        int n22 = n2;
        for (n9 = n21; n9 < n22; ++n9) {
            nArray[n9] = n20 + n9;
        }
        if (n20 + n2 >= this.barvar_dim.length) {
            n21 = n20 + n2 - this.barvar_dim.length;
            if (n21 < this.barvar_dim.length) {
                n21 = this.barvar_dim.length;
            }
            n22 = n21 + this.barvar_dim.length;
            int[] nArray7 = new int[n22];
            Tools.arraycopy(this.barvar_dim, 0, nArray7, 0, this.barvar_dim.length);
            this.barvar_dim = nArray7;
        }
        this.barvar_block_dim[n10] = n;
        this.barvar_block_ptr[n10 + 1] = this.barvar_block_ptr[n10] + n2;
        this.barvar_block_elm_ptr[n10 + 1] = this.barvar_block_elm_ptr[n10] + n12;
        n21 = 0;
        n22 = this.barvar_block_elm_ptr[n10];
        int n23 = 0;
        n8 = n2;
        for (n7 = n23; n7 < n8; ++n7) {
            n6 = 0;
            int n24 = n;
            for (n5 = n6; n5 < n24; ++n5) {
                int n25 = n5;
                n4 = n;
                n3 = n25;
                while (n3 < n4) {
                    this.barvar_block_elm_barj[n22 + n21] = n20 + n7;
                    this.barvar_block_elm_i[n22 + n21] = n3++;
                    this.barvar_block_elm_j[n22 + n21] = n5;
                    lArray[n21] = n22 + n21;
                    ++n21;
                }
            }
        }
        n23 = 0;
        n8 = n2;
        for (n7 = n23; n7 < n8; ++n7) {
            this.barvar_dim[n20 + n7] = n;
        }
        n21 = this.task_append_barvar(n, n2);
        return n10;
    }

    private int conicvar_alloc(long l, int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        int n5;
        int n6 = n * n2;
        int n7 = this.linearvar_alloc(n6, nArray2);
        double[] dArray = new double[n6];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n6];
        this.var_block_acc_id[n7] = n5 = this.acon_allocate(l, n, n2, dArray, nArray4, nArray);
        int n8 = 0;
        int n9 = n6;
        for (n4 = n8; n4 < n9; ++n4) {
            this.var_elm_acc_idx[nArray2[n4]] = nArray[n4 / n];
            this.var_elm_acc_ofs[nArray2[n4]] = n4 % n;
        }
        n8 = 0;
        n9 = 0;
        n4 = nArray4.length;
        int n10 = n9 < n4 ? n4 - n9 : 0;
        long[] lArray = new long[n10];
        int n11 = n9;
        int n12 = 0;
        while (n12 < n10) {
            lArray[n8] = nArray4[n11];
            ++n8;
            ++n12;
            ++n11;
        }
        n12 = 0;
        int n13 = 0;
        int n14 = n6 + 1;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        int[] nArray5 = new int[n15];
        int n16 = n13;
        for (n3 = 0; n3 < n15; ++n3) {
            nArray5[n12] = n16++;
            ++n12;
        }
        n3 = 0;
        int n17 = 0;
        int n18 = n6;
        int n19 = n17 < n18 ? n18 - n17 : 0;
        double[] dArray2 = new double[n19];
        int n20 = n17;
        int n21 = 0;
        while (n21 < n19) {
            dArray2[n3] = 1.0;
            ++n3;
            ++n21;
            ++n20;
        }
        n21 = 0;
        int n22 = 0;
        int n23 = n6;
        int n24 = n22 < n23 ? n23 - n22 : 0;
        double[] dArray3 = new double[n24];
        int n25 = n22;
        int n26 = 0;
        while (n26 < n24) {
            dArray3[n21] = 0.0;
            ++n21;
            ++n26;
            ++n25;
        }
        this.task_putafeflist(lArray, nArray5, nArray2, dArray2, dArray3);
        return n7;
    }

    private int linearvar_alloc(int n, int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5 = this.var_block_map.alloc(n);
        int n6 = this.var_block_map.maxidx(n5) + 1;
        int n7 = this.var_block_map.capacity();
        int n8 = this.var_block_map.block_capacity();
        this.var_block_map.get(n5, nArray, 0);
        if (this.task_numvar() < n6) {
            this.task_append_var(n6 - this.task_numvar());
        }
        if (n5 >= this.vars.length) {
            n4 = 0;
            n3 = 0;
            n2 = this.vars.length * 2;
            int n9 = n3 < n2 ? n2 - n3 : 0;
            ModelVariable[] modelVariableArray = new ModelVariable[n9];
            int n10 = n3;
            int n11 = 0;
            while (n11 < n9) {
                modelVariableArray[n4] = null;
                ++n4;
                ++n11;
                ++n10;
            }
            ModelVariable[] modelVariableArray2 = modelVariableArray;
            int n12 = 0;
            int n13 = this.vars.length;
            for (int i = n12; i < n13; ++i) {
                modelVariableArray2[i] = this.vars[i];
            }
            this.vars = modelVariableArray2;
        }
        if (n8 > this.var_block_acc_id.length) {
            int[] nArray2 = new int[n8];
            Tools.arraycopy(this.var_block_acc_id, 0, nArray2, 0, this.var_block_acc_id.length);
            this.var_block_acc_id = nArray2;
        }
        if (n7 > this.var_elm_acc_idx.length) {
            int[] nArray3 = new int[n7];
            Tools.arraycopy(this.var_elm_acc_idx, 0, nArray3, 0, this.var_elm_acc_idx.length);
            this.var_elm_acc_idx = nArray3;
            int[] nArray4 = new int[n7];
            Tools.arraycopy(this.var_elm_acc_ofs, 0, nArray4, 0, this.var_elm_acc_ofs.length);
            this.var_elm_acc_ofs = nArray4;
        }
        this.var_block_acc_id[n5] = -1;
        n4 = 0;
        n3 = n;
        for (n2 = n4; n2 < n3; ++n2) {
            this.var_elm_acc_idx[nArray[n2]] = -1;
        }
        return n5;
    }

    protected void make_continuous(long[] lArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = lArray.length;
        for (n = n3; n < n4; ++n) {
            if (lArray[n] <= 0L) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n4 = 0;
        n = 0;
        int n5 = lArray.length;
        for (int i = n; i < n5; ++i) {
            if (lArray[i] <= 0L) continue;
            nArray[n4] = (int)lArray[i];
            ++n4;
        }
        this.task_var_putcontlist(nArray);
    }

    protected void make_integer(long[] lArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = lArray.length;
        for (n = n3; n < n4; ++n) {
            if (lArray[n] <= 0L) continue;
            ++n2;
        }
        int[] nArray = new int[n2];
        n4 = 0;
        n = 0;
        int n5 = lArray.length;
        for (int i = n; i < n5; ++i) {
            if (lArray[i] <= 0L) continue;
            nArray[n4] = (int)lArray[i];
            ++n4;
        }
        this.task_var_putintlist(nArray);
    }

    public static void putlicensewait(boolean bl) {
        BaseModel.env_putlicensewait(bl);
    }

    public static void putlicensepath(String string) {
        BaseModel.env_putlicensepath(string);
    }

    public static void putlicensecode(int[] nArray) {
        BaseModel.env_putlicensecode(nArray);
    }

    @Override
    public void dispose() {
        int n;
        int n2 = 0;
        int n3 = this.vars.length;
        for (n = n2; n < n3; ++n) {
            this.vars[n] = null;
        }
        n2 = 0;
        n3 = this.cons.length;
        for (n = n2; n < n3; ++n) {
            this.cons[n] = null;
        }
        n2 = 0;
        n3 = this.acons.length;
        for (n = n2; n < n3; ++n) {
            this.acons[n] = null;
        }
        n2 = 0;
        n3 = this.barvars.length;
        for (n = n2; n < n3; ++n) {
            this.barvars[n] = null;
        }
        if (this.parameters != null) {
            n2 = 0;
            n3 = this.parameters.length;
            for (n = n2; n < n3; ++n) {
                this.parameters[n] = null;
            }
        }
        super.dispose();
    }

    public Task getTask() {
        return this.task_get();
    }

    public void getConstraintDuals(boolean bl, int[] nArray, double[] dArray, int n) throws SolutionError {
        int n2 = nArray.length;
        double[] dArray2 = this.getSolution_slc(SolutionType.Default);
        double[] dArray3 = this.getSolution_suc(SolutionType.Default);
        int n3 = 0;
        int n4 = n2;
        for (int i = n3; i < n4; ++i) {
            if (nArray[i] >= 0) {
                if (bl) {
                    dArray[n + i] = dArray2[nArray[i]];
                    continue;
                }
                dArray[n + i] = -dArray3[nArray[i]];
                continue;
            }
            throw new SolutionError("Requested invalid solution item");
        }
    }

    public void getConstraintValues(boolean bl, int[] nArray, double[] dArray, int n) throws SolutionError {
        int n2 = nArray.length;
        if (bl) {
            double[] dArray2 = this.getSolution_xc(SolutionType.Default);
            double[] dArray3 = this.getSolution_accx(SolutionType.Default);
            int[] nArray2 = this.getSolution_accptr(SolutionType.Default);
            int n3 = 0;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                if (nArray[i] >= 0) {
                    dArray[n + i] = dArray2[nArray[i]];
                    continue;
                }
                int n5 = -(1 + nArray[i]);
                dArray[n + i] = dArray3[nArray2[this.acon_elm_accid[n5]] + this.acon_elm_ofs[n5]] * this.acon_elm_scale[n5];
            }
        } else {
            double[] dArray4 = this.getSolution_y(SolutionType.Default);
            double[] dArray5 = this.getSolution_accy(SolutionType.Default);
            int[] nArray3 = this.getSolution_accptr(SolutionType.Default);
            int n6 = 0;
            int n7 = n2;
            for (int i = n6; i < n7; ++i) {
                if (nArray[i] >= 0) {
                    dArray[n + i] = dArray4[nArray[i]];
                    continue;
                }
                int n8 = -(1 + nArray[i]);
                dArray[n + i] = dArray5[nArray3[this.acon_elm_accid[n8]] + this.acon_elm_ofs[n8]] * this.acon_elm_scale[n8];
            }
        }
    }

    public void getVariableDuals(boolean bl, long[] lArray, double[] dArray, int n) throws SolutionError {
        int n2 = lArray.length;
        if (bl) {
            double[] dArray2 = this.getSolution_slx(SolutionType.Default);
            int n3 = 0;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                dArray[n + i] = lArray[i] > 0L ? dArray2[(int)lArray[i]] : 0.0;
            }
        } else {
            double[] dArray3 = this.getSolution_sux(SolutionType.Default);
            int n5 = 0;
            int n6 = n2;
            for (int i = n5; i < n6; ++i) {
                dArray[n + i] = lArray[i] > 0L ? -dArray3[(int)lArray[i]] : 0.0;
            }
        }
    }

    public void getVariableValues(boolean bl, long[] lArray, double[] dArray, int n) throws SolutionError {
        int n2 = lArray.length;
        this.barvar_num = this.task_numbarvar();
        if (bl) {
            double[] dArray2 = this.getSolution_xx(SolutionType.Default);
            double[] dArray3 = this.barvar_num > 0 ? this.getSolution_barx(SolutionType.Default) : null;
            int n3 = 0;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                if (lArray[i] > 0L) {
                    dArray[n + i] = dArray2[(int)lArray[i]];
                    continue;
                }
                if (lArray[i] < 0L) {
                    long l = -(lArray[i] + 1L);
                    dArray[n + i] = dArray3[(int)l];
                    continue;
                }
                dArray[n + i] = 0.0;
            }
        } else {
            double[] dArray4 = this.getSolution_yx(SolutionType.Default);
            double[] dArray5 = this.barvar_num > 0 ? this.getSolution_bars(SolutionType.Default) : null;
            double[] dArray6 = this.getSolution_accy(SolutionType.Default);
            int[] nArray = this.getSolution_accptr(SolutionType.Default);
            int n5 = 0;
            int n6 = n2;
            for (int i = n5; i < n6; ++i) {
                if (lArray[i] < 0L) {
                    long l = -(lArray[i] + 1L);
                    dArray[n + i] = dArray5[(int)l];
                    continue;
                }
                dArray[n + i] = lArray[i] == 0L ? 0.0 : (this.var_elm_acc_idx[(int)lArray[i]] >= 0 ? dArray6[nArray[this.var_elm_acc_idx[(int)lArray[i]]] + this.var_elm_acc_ofs[(int)lArray[i]]] : dArray4[(int)lArray[i]]);
            }
        }
    }

    public void setVariableValues(boolean bl, long[] lArray, double[] dArray) {
        if (bl) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = lArray.length;
            for (n = n3; n < n4; ++n) {
                if (lArray[n] < 0L) continue;
                ++n2;
            }
            int[] nArray = new int[n2];
            double[] dArray2 = new double[n2];
            n = 0;
            int n5 = 0;
            int n6 = lArray.length;
            for (int i = n5; i < n6; ++i) {
                if (lArray[i] < 0L) continue;
                nArray[n] = (int)lArray[i];
                dArray2[n] = dArray[i];
                ++n;
            }
            this.setSolution_xx(nArray, dArray2);
        }
    }

    public void flushNames() {
        int n;
        int n2 = 0;
        int n3 = this.vars.length;
        for (n = n2; n < n3; ++n) {
            if (this.vars[n] == null) continue;
            this.vars[n].flushNames();
        }
        n2 = 0;
        n3 = this.barvars.length;
        for (n = n2; n < n3; ++n) {
            if (this.barvars[n] == null) continue;
            this.barvars[n].flushNames();
        }
        n2 = 0;
        n3 = this.cons.length;
        for (n = n2; n < n3; ++n) {
            if (this.cons[n] == null) continue;
            this.cons[n].flushNames();
        }
        n2 = 0;
        n3 = this.acons.length;
        for (n = n2; n < n3; ++n) {
            if (this.acons[n] == null) continue;
            this.acons[n].flushNames();
        }
    }

    public void writeTaskNoFlush(String string) {
        this.flushNames();
        this.task_write(string);
    }

    public void writeTaskStream(String string, OutputStream outputStream) {
        this.flushNames();
        this.flush_parameters();
        this.task_write_stream(string, outputStream);
    }

    public void dataReport() {
        this.dataReport(10);
    }

    public void dataReport(int n) {
        this.flush_parameters();
        this.task_analyze_problem(n);
    }

    public void writeTask(String string) {
        this.flushNames();
        this.flush_parameters();
        this.task_write(string);
    }

    public long getSolverLIntInfo(String string) {
        return this.task_get_liinf(string);
    }

    public int getSolverIntInfo(String string) {
        return this.task_get_iinf(string);
    }

    public double getSolverDoubleInfo(String string) {
        return this.task_get_dinf(string);
    }

    public void setCallbackHandler(Progress progress) {
        this.task_setCallbackHandler(progress);
    }

    public void setDataCallbackHandler(DataCallback dataCallback) {
        this.task_setDataCallbackHandler(dataCallback);
    }

    public void setLogHandler(Writer writer) {
        this.task_setLogHandler(writer);
    }

    public void setSolverParam(String string, double d) {
        Parameters.setParameter(this, string, d);
    }

    public void setSolverParam(String string, int n) {
        Parameters.setParameter(this, string, n);
    }

    public void setSolverParam(String string, String string2) {
        Parameters.setParameter(this, string, string2);
    }

    public void breakSolver() {
        this.task_break_solve();
    }

    public void optserverHost(String string) {
        this.task_putoptserver_host(string);
    }

    @Override
    protected void report_solution(SolutionType solutionType, ProblemStatus problemStatus, SolutionStatus solutionStatus, SolutionStatus solutionStatus2, double d, double d2, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6;
        int n7;
        int n8;
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        SolutionStruct solutionStruct = solutionType == SolutionType.Interior ? this.sol_itr : (solutionType == SolutionType.Basic ? this.sol_bas : (solutionType == SolutionType.Integer ? this.sol_itg : null));
        if (solutionStruct == null) {
            solutionStruct = new SolutionStruct(n, n2, n3, n4, n5);
        } else {
            solutionStruct.resize(n, n2, n3, n4, n5);
        }
        solutionStruct.pobj = d;
        solutionStruct.dobj = d2;
        solutionStruct.pstatus = solutionStatus;
        solutionStruct.dstatus = solutionStatus2;
        solutionStruct.probstatus = problemStatus;
        if (n > 0) {
            if (bl) {
                this.report_solution_get_xx(solutionStruct.xx);
            }
            if (bl2) {
                this.report_solution_get_slx(solutionStruct.slx);
                this.report_solution_get_sux(solutionStruct.sux);
                dArray3 = solutionStruct.yx;
                dArray2 = solutionStruct.slx;
                dArray = solutionStruct.sux;
                n8 = 0;
                n7 = n;
                for (n6 = n8; n6 < n7; ++n6) {
                    dArray3[n6] = dArray2[n6] - dArray[n6];
                }
            }
        }
        if (n2 > 0) {
            if (bl) {
                this.report_solution_get_xc(solutionStruct.xc);
            }
            if (bl2) {
                this.report_solution_get_slc(solutionStruct.slc);
                this.report_solution_get_suc(solutionStruct.suc);
                dArray3 = solutionStruct.y;
                dArray2 = solutionStruct.slc;
                dArray = solutionStruct.suc;
                n8 = 0;
                n7 = n2;
                for (n6 = n8; n6 < n7; ++n6) {
                    dArray3[n6] = dArray2[n6] - dArray[n6];
                }
            }
        }
        if (n3 > 0) {
            if (bl) {
                this.report_solution_get_barx(solutionStruct.barx);
            }
            if (bl2) {
                this.report_solution_get_bars(solutionStruct.bars);
            }
        }
        if (this.task_numacc() > 0) {
            this.report_solution_get_accptr(solutionStruct.accptr);
            if (bl) {
                this.report_solution_get_accx(solutionStruct.accx);
            }
            if (bl2) {
                this.report_solution_get_accy(solutionStruct.accy);
            }
        }
        if (solutionType == SolutionType.Interior) {
            this.sol_itr = solutionStruct;
        } else if (solutionType == SolutionType.Basic) {
            this.sol_bas = solutionStruct;
        } else if (solutionType == SolutionType.Integer) {
            this.sol_itg = solutionStruct;
        }
    }

    @Override
    protected void clear_solutions() {
        this.sol_itr = null;
        this.sol_itg = null;
        this.sol_bas = null;
    }

    public static SolverStatus[] solveBatch(boolean bl, double d, int n, Model[] modelArray) throws OptimizeError {
        int n2;
        int n3 = modelArray.length;
        int n4 = 0;
        int n5 = n3;
        for (n2 = n4; n2 < n5; ++n2) {
            if (modelArray[n2] != null) continue;
            throw new OptimizeError("One of the models is a null object");
        }
        n4 = 0;
        n5 = n3;
        for (n2 = n4; n2 < n5; ++n2) {
            modelArray[n2].flushSolutions();
            modelArray[n2].flush_parameters();
        }
        SolverStatus[] solverStatusArray = BaseModel.env_solve_batch(bl, d, n, modelArray);
        n5 = 0;
        n2 = n3;
        for (int i = n5; i < n2; ++i) {
            modelArray[i].task_post_solve();
        }
        return solverStatusArray;
    }

    public void solve(String string, String string2) throws OptimizeError {
        this.flushSolutions();
        this.flush_parameters();
        this.task_solve(true, string, string2);
        this.task_post_solve();
    }

    public void solve() throws OptimizeError {
        this.flushSolutions();
        this.flush_parameters();
        this.task_solve(false, "", "");
        this.task_post_solve();
    }

    private void flush_parameters() {
        double[] dArray;
        int[] nArray;
        int[] nArray2;
        int n = this.con_blocks.num_parameterized();
        int n2 = this.afe_blocks.num_parameterized();
        int n3 = this.obj_blocks.num_parameterized();
        if (n > 0) {
            nArray2 = new int[n];
            nArray = new int[n];
            dArray = new double[n];
            this.con_blocks.evaluate(this.xs, this.param_value, nArray2, nArray, dArray);
            this.task_putaijlist(nArray2, nArray, dArray, n);
        }
        if (n2 > 0) {
            nArray2 = new int[n2];
            nArray = new int[n2];
            dArray = new double[n2];
            this.afe_blocks.evaluate(this.xs, this.param_value, nArray2, nArray, dArray);
            this.task_putafefijlist(nArray2, nArray, dArray);
        }
        if (n3 > 0) {
            nArray2 = new int[n3];
            nArray = new int[n3];
            dArray = new double[n3];
            this.obj_blocks.evaluate(this.xs, this.param_value, nArray2, nArray, dArray);
            this.task_putclist(nArray, dArray);
        }
    }

    public void flushParameters() {
        this.flush_parameters();
    }

    private void evaluate_parameterized(WorkStack workStack, int n, int[] nArray, int[] nArray2, long[] lArray, int[] nArray3, int[] nArray4, int[] nArray5, double[] dArray, int[] nArray6, double[] dArray2) {
        int n2 = workStack.allocf64(nArray5.length);
        int n3 = 0;
        double[] dArray3 = workStack.f64;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        for (int i = n5; i < n6; ++i) {
            int n7 = nArray3[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = n8; j < n9; ++j) {
                int n10 = 0;
                int n11 = nArray4[j];
                for (int k = n10; k < n11; ++k) {
                    if (nArray5[n7] != 0) {
                        if (nArray5[n7] == 1) {
                            dArray3[n2 + n3] = this.param_value[(int)dArray[n7]];
                            ++n3;
                        } else if (nArray5[n7] == 2) {
                            dArray3[n2 + n3] = dArray[n7];
                            ++n3;
                        } else if (nArray5[n7] == 3) {
                            int n12 = n2 + n3 - 2;
                            dArray3[n12] = dArray3[n12] + dArray3[n2 + n3 - 1];
                            --n3;
                        } else if (nArray5[n7] == 4) {
                            dArray3[n2 + n3 - 1] = -dArray3[n2 + n3 - 1];
                        } else if (nArray5[n7] == 5) {
                            int n13 = n2 + n3 - 2;
                            dArray3[n13] = dArray3[n13] * dArray3[n2 + n3 - 1];
                            --n3;
                        } else if (nArray5[n7] == 6) {
                            dArray3[n2 + n3 - 1] = 1.0 / dArray3[n2 + n3 - 1];
                        } else if (nArray5[n7] == 8) {
                            double d = 0.0;
                            int n14 = 0;
                            int n15 = (int)dArray[n7];
                            for (int i2 = n14; i2 < n15; ++i2) {
                                d += dArray3[n2 + n3 - 1];
                                --n3;
                            }
                            dArray3[n2 + n3] = d;
                            ++n3;
                        }
                    }
                    ++n7;
                }
                nArray6[n4] = (int)lArray[j];
                dArray2[n4] = dArray3[n2];
                n3 = 0;
                ++n4;
            }
        }
        workStack.popf64(nArray5.length);
    }

    public void flushSolutions() {
        this.flush_initsol(SolutionType.Interior);
        this.flush_initsol(SolutionType.Integer);
        this.flush_initsol(SolutionType.Basic);
    }

    private void flush_initsol(SolutionType solutionType) {
        if (this.initsol_xx != null) {
            int n = this.task_numvar();
            double[] dArray = new double[n];
            try {
                SolutionStruct solutionStruct = this.get_sol_cache(solutionType, true);
                if (solutionStruct.xx != null) {
                    Tools.arraycopy(solutionStruct.xx, 0, dArray, 0, solutionStruct.xx.length <= n ? solutionStruct.xx.length : n);
                }
            }
            catch (SolutionError solutionError) {
                // empty catch block
            }
            int n2 = this.initsol_xx.length <= n ? this.initsol_xx.length : n;
            int n3 = 0;
            int n4 = n2;
            for (int i = n3; i < n4; ++i) {
                if (!this.initsol_xx_flag[i]) continue;
                dArray[i] = this.initsol_xx[i];
            }
            dArray[this.bfixidx] = 1.0;
            this.task_putxx_slice(solutionType, 0, n, dArray);
        }
    }

    public SolutionStatus getDualSolutionStatus() {
        return this.getDualSolutionStatus(this.solutionptr);
    }

    public ProblemStatus getProblemStatus() {
        return this.getProblemStatus(this.solutionptr);
    }

    public SolutionStatus getPrimalSolutionStatus() {
        return this.getPrimalSolutionStatus(this.solutionptr);
    }

    public double dualObjValue() throws SolutionError {
        return this.get_sol_cache((SolutionType)SolutionType.Default, (boolean)false).dobj;
    }

    public double primalObjValue() throws SolutionError {
        return this.get_sol_cache((SolutionType)SolutionType.Default, (boolean)true).pobj;
    }

    protected SolutionStruct get_sol_cache(SolutionType solutionType, boolean bl, boolean bl2) throws SolutionError {
        SolutionStruct solutionStruct = null;
        SolutionType solutionType2 = solutionType;
        if (solutionType2 == SolutionType.Default) {
            solutionType2 = this.solutionptr;
        }
        if (solutionType2 == SolutionType.Default) {
            solutionStruct = this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr);
        } else if (solutionType2 == SolutionType.Interior) {
            solutionStruct = this.sol_itr;
        } else if (solutionType2 == SolutionType.Basic) {
            solutionStruct = this.sol_bas;
        } else if (solutionType2 == SolutionType.Integer) {
            solutionStruct = this.sol_itg;
        }
        if (solutionStruct == null) {
            throw new SolutionError("Solution not available");
        }
        if (bl2 || bl && solutionStruct.isPrimalAcceptable(this.acceptable_sol) || !bl && solutionStruct.isDualAcceptable(this.acceptable_sol)) {
            return solutionStruct;
        }
        if (solutionStruct == this.sol_itg && !bl) {
            throw new SolutionError("Dual solution does not exists for mixed-integer problems.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        SolutionStatus solutionStatus = solutionStruct.pstatus;
        ProblemStatus problemStatus = solutionStruct.probstatus;
        if (!bl) {
            solutionStatus = solutionStruct.dstatus;
        }
        stringBuffer.a("Solution status is ");
        if (solutionStatus == SolutionStatus.Undefined) {
            stringBuffer.a("Undefined");
        } else if (solutionStatus == SolutionStatus.Unknown) {
            stringBuffer.a("Unknown");
        } else if (solutionStatus == SolutionStatus.Optimal) {
            stringBuffer.a("Optimal");
        } else if (solutionStatus == SolutionStatus.Feasible) {
            stringBuffer.a("Feasible");
        } else if (solutionStatus == SolutionStatus.Certificate) {
            stringBuffer.a("Certificate");
        } else if (solutionStatus == SolutionStatus.IllposedCert) {
            stringBuffer.a("IllposedCert");
        }
        stringBuffer.a(" but ");
        if (this.acceptable_sol == AccSolutionStatus.Anything) {
            stringBuffer.a("Anything");
        } else if (this.acceptable_sol == AccSolutionStatus.Optimal) {
            stringBuffer.a("Optimal");
        } else if (this.acceptable_sol == AccSolutionStatus.Feasible) {
            stringBuffer.a("at least Feasible");
        } else if (this.acceptable_sol == AccSolutionStatus.Certificate) {
            stringBuffer.a("Certificate");
        }
        stringBuffer.a(" is expected. Reason: Accessing ");
        if (solutionStruct == this.sol_itr) {
            stringBuffer.a("interior-point solution");
        } else if (solutionStruct == this.sol_bas) {
            stringBuffer.a("basic solution");
        } else if (solutionStruct == this.sol_itg) {
            stringBuffer.a("integer solution");
        }
        stringBuffer.a(" whose problem status is ");
        if (problemStatus == ProblemStatus.Unknown) {
            stringBuffer.a("Unknown");
        } else if (problemStatus == ProblemStatus.PrimalAndDualFeasible) {
            stringBuffer.a("PrimalAndDualFeasible");
        } else if (problemStatus == ProblemStatus.PrimalFeasible) {
            stringBuffer.a("PrimalFeasible");
        } else if (problemStatus == ProblemStatus.DualFeasible) {
            stringBuffer.a("DualFeasible");
        } else if (problemStatus == ProblemStatus.PrimalInfeasible) {
            stringBuffer.a("PrimalInfeasible");
        } else if (problemStatus == ProblemStatus.DualInfeasible) {
            stringBuffer.a("DualInfeasible");
        } else if (problemStatus == ProblemStatus.PrimalAndDualInfeasible) {
            stringBuffer.a("PrimalAndDualInfeasible");
        } else if (problemStatus == ProblemStatus.IllPosed) {
            stringBuffer.a("IllPosed");
        } else if (problemStatus == ProblemStatus.PrimalInfeasibleOrUnbounded) {
            stringBuffer.a("PrimalInfeasibleOrUnbounded");
        }
        stringBuffer.a(".");
        throw new SolutionError(stringBuffer.toString());
    }

    protected SolutionStruct get_sol_cache(SolutionType solutionType, boolean bl) throws SolutionError {
        return this.get_sol_cache(solutionType, bl, false);
    }

    protected void setSolution_xx(int[] nArray, double[] dArray) {
        this.ensure_initsol_xx();
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.initsol_xx[nArray[i]] = dArray[i];
            this.initsol_xx_flag[nArray[i]] = true;
        }
    }

    protected void ensure_initsol_xx() {
        int n = this.task_numvar();
        if (this.initsol_xx == null) {
            this.initsol_xx = new double[n];
            int n2 = 0;
            int n3 = 0;
            int n4 = n;
            int n5 = n3 < n4 ? n4 - n3 : 0;
            boolean[] blArray = new boolean[n5];
            int n6 = n3;
            int n7 = 0;
            while (n7 < n5) {
                blArray[n2] = false;
                ++n2;
                ++n7;
                ++n6;
            }
            this.initsol_xx_flag = blArray;
        } else if (this.initsol_xx.length < n) {
            double[] dArray = this.initsol_xx;
            boolean[] blArray = this.initsol_xx_flag;
            this.initsol_xx = new double[n];
            this.initsol_xx_flag = new boolean[n];
            Tools.arraycopy(dArray, 0, this.initsol_xx, 0, dArray.length);
            int n8 = 0;
            int n9 = dArray.length;
            for (int i = n8; i < n9; ++i) {
                this.initsol_xx_flag[i] = blArray[i];
            }
        }
    }

    protected int[] getSolution_accptr(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true, (boolean)true).accptr;
    }

    protected double[] getSolution_accy(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).accy;
    }

    protected double[] getSolution_accx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).accx;
    }

    protected double[] getSolution_bars(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).bars;
    }

    protected double[] getSolution_barx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).barx;
    }

    protected double[] getSolution_y(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).y;
    }

    protected double[] getSolution_xc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).xc;
    }

    protected double[] getSolution_suc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).suc;
    }

    protected double[] getSolution_slc(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).slc;
    }

    protected double[] getSolution_sux(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).sux;
    }

    protected double[] getSolution_slx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).slx;
    }

    protected double[] getSolution_yx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)false).yx;
    }

    protected double[] getSolution_xx(SolutionType solutionType) throws SolutionError {
        return this.get_sol_cache((SolutionType)solutionType, (boolean)true).xx;
    }

    public void selectedSolution(SolutionType solutionType) {
        this.solutionptr = solutionType;
    }

    public AccSolutionStatus getAcceptedSolutionStatus() {
        return this.acceptable_sol;
    }

    public void acceptedSolutionStatus(AccSolutionStatus accSolutionStatus) {
        this.acceptable_sol = accSolutionStatus;
    }

    public ProblemStatus getProblemStatus(SolutionType solutionType) {
        SolutionStruct solutionStruct = null;
        if (solutionType == SolutionType.Default) {
            solutionStruct = this.sol_itg != null ? this.sol_itg : (this.sol_bas != null ? this.sol_bas : this.sol_itr);
        } else if (solutionType == SolutionType.Interior) {
            solutionStruct = this.sol_itr;
        } else if (solutionType == SolutionType.Basic) {
            solutionStruct = this.sol_bas;
        } else if (solutionType == SolutionType.Integer) {
            solutionStruct = this.sol_itg;
        }
        if (solutionStruct == null) {
            return ProblemStatus.Unknown;
        }
        return solutionStruct.probstatus;
    }

    public SolutionStatus getDualSolutionStatus(SolutionType solutionType) {
        return this.getSolutionStatus(solutionType, false);
    }

    public SolutionStatus getPrimalSolutionStatus(SolutionType solutionType) {
        return this.getSolutionStatus(solutionType, true);
    }

    protected SolutionStatus getSolutionStatus(SolutionType solutionType, boolean bl) {
        try {
            SolutionStruct solutionStruct = this.get_sol_cache(solutionType, bl, true);
            if (bl) {
                return solutionStruct.pstatus;
            }
            return solutionStruct.dstatus;
        }
        catch (SolutionError solutionError) {
            return SolutionStatus.Undefined;
        }
    }

    protected void update(int[] nArray, Expression expression) {
        int n;
        new ExprDense(new ExprOptimizeCode(new ExprCompress(expression))).eval(this.ws, this.rs, this.xs);
        this.ws.pop_expr();
        int n2 = this.ws.nd;
        int n3 = this.ws.shape_base;
        int n4 = this.ws.nelem;
        int n5 = this.ws.nnz;
        boolean bl = this.ws.hassp;
        int n6 = this.ws.ncodeatom;
        int n7 = this.ws.ptr_base;
        int n8 = this.ws.sp_base;
        int n9 = this.ws.nidxs_base;
        int n10 = this.ws.cof_base;
        int n11 = this.ws.code_base;
        int n12 = this.ws.codeptr_base;
        int n13 = this.ws.cconst_base;
        int[] nArray2 = this.ws.i32;
        long[] lArray = this.ws.i64;
        double[] dArray = this.ws.f64;
        int n14 = 0;
        int n15 = 0;
        int n16 = n4;
        for (n = n15; n < n16; ++n) {
            if (nArray[n] < 0) continue;
            ++n14;
        }
        n15 = n4 - n14;
        if (n14 == n4) {
            this.putarows(nArray, this.ws, n4, n5, n7, n9, n10);
            if (n6 > 0) {
                this.con_blocks.replace_row_code(this.rs, nArray, n7, n9, n12, n11, n13);
            } else {
                this.con_blocks.clear_row_code(nArray);
            }
        } else if (n15 == n4) {
            n16 = 0;
            n = 0;
            int n17 = n4;
            int n18 = n < n17 ? n17 - n : 0;
            int[] nArray3 = new int[n18];
            int n19 = n;
            int n20 = 0;
            while (n20 < n18) {
                nArray3[n16] = -(1 + nArray[n19]);
                ++n16;
                ++n20;
                ++n19;
            }
            this.putfrows(nArray3, 0, this.ws, n4, n5, n7, n9, n10);
            if (n6 > 0) {
                n20 = 0;
                int n21 = 0;
                int n22 = n4;
                int n23 = n21 < n22 ? n22 - n21 : 0;
                int[] nArray4 = new int[n23];
                int n24 = n21;
                int n25 = 0;
                while (n25 < n23) {
                    nArray4[n20] = -(1 + nArray[n24]);
                    ++n20;
                    ++n25;
                    ++n24;
                }
                this.afe_blocks.replace_row_code(this.rs, nArray4, n7, n9, n12, n11, n13);
            } else {
                n20 = 0;
                int n26 = 0;
                int n27 = n4;
                int n28 = n26 < n27 ? n27 - n26 : 0;
                int[] nArray5 = new int[n28];
                int n29 = n26;
                int n30 = 0;
                while (n30 < n28) {
                    nArray5[n20] = -(1 + nArray[n29]);
                    ++n20;
                    ++n30;
                    ++n29;
                }
                this.afe_blocks.clear_row_code(nArray5);
            }
        } else {
            int n31;
            int n32;
            int n33;
            n16 = 0;
            n = 0;
            int n34 = 0;
            int n35 = 0;
            int n36 = 0;
            int n37 = n4;
            for (n33 = n36; n33 < n37; ++n33) {
                if (nArray[n33] >= 0) {
                    n35 += nArray2[n7 + n33 + 1] - nArray2[n7 + n33];
                    continue;
                }
                n34 += nArray2[n7 + n33 + 1] - nArray2[n7 + n33];
            }
            n36 = this.xs.alloci32(n14);
            n37 = this.xs.alloci32(n15);
            n33 = this.xs.alloci32(n14 + 1);
            int n38 = this.xs.alloci32(n15 + 1);
            int n39 = this.xs.alloci64(n35);
            int n40 = this.xs.alloci64(n34);
            int n41 = this.xs.allocf64(n35);
            int n42 = this.xs.allocf64(n34);
            double[] dArray2 = this.xs.f64;
            long[] lArray2 = this.xs.i64;
            int[] nArray6 = this.xs.i32;
            nArray6[n33] = 0;
            nArray6[n38] = 0;
            int n43 = 0;
            int n44 = 0;
            int n45 = 0;
            int n46 = 0;
            int n47 = 0;
            int n48 = n4;
            for (n32 = n47; n32 < n48; ++n32) {
                n31 = nArray2[n7 + n32];
                int n49 = nArray2[n7 + n32 + 1];
                if (nArray[n32] >= 0) {
                    Tools.arraycopy(lArray, n9 + n31, lArray2, n39 + n46, n49 - n31);
                    Tools.arraycopy(dArray, n10 + n31, dArray2, n41 + n46, n49 - n31);
                    nArray6[n36 + n44] = nArray[n32];
                    nArray6[n33 + n44 + 1] = n46 += n49 - n31;
                    ++n44;
                    continue;
                }
                Tools.arraycopy(lArray, n9 + n31, lArray2, n40 + n45, n49 - n31);
                Tools.arraycopy(dArray, n10 + n31, dArray2, n42 + n45, n49 - n31);
                nArray6[n37 + n43] = -(1 + nArray[n32]);
                nArray6[n38 + n43 + 1] = n45 += n49 - n31;
                ++n43;
            }
            n47 = 0;
            n48 = 0;
            n32 = n14;
            n31 = n48 < n32 ? n32 - n48 : 0;
            int[] nArray7 = new int[n31];
            int n50 = n48;
            int n51 = 0;
            while (n51 < n31) {
                nArray7[n47] = nArray6[n36 + n50];
                ++n47;
                ++n51;
                ++n50;
            }
            this.putarows(nArray7, this.xs, n14, n35, n33, n39, n41);
            this.putfrows(nArray6, n37, this.xs, n15, n34, n38, n40, n42);
            if (n6 > 0) {
                int n52;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                n51 = 0;
                int n58 = n4;
                for (n57 = n51; n57 < n58; ++n57) {
                    if (nArray[n57] >= 0) {
                        n += nArray2[n12 + nArray2[n7 + n57 + 1]] - nArray2[n12 + nArray2[n7 + n57]];
                        continue;
                    }
                    n16 += nArray2[n12 + nArray2[n7 + n57 + 1]] - nArray2[n12 + nArray2[n7 + n57]];
                }
                n51 = this.xs.alloci32(n35 + 1);
                n58 = this.xs.alloci32(n34 + 1);
                n57 = this.xs.alloci32(n);
                int n59 = this.xs.alloci32(n16);
                int n60 = this.xs.allocf64(n);
                int n61 = this.xs.allocf64(n16);
                nArray6[n51] = 0;
                nArray6[n58] = 0;
                int n62 = 0;
                int n63 = 0;
                boolean bl2 = false;
                int n64 = 0;
                int n65 = 0;
                int n66 = n4;
                for (n56 = n65; n56 < n66; ++n56) {
                    n55 = nArray2[n7 + n56];
                    int n67 = nArray2[n7 + n56 + 1];
                    if (nArray[n56] >= 0) {
                        Tools.arraycopy(nArray2, n11 + nArray2[n12 + n55], nArray6, n57 + n63, nArray2[n12 + n67] - nArray2[n12 + n55]);
                        Tools.arraycopy(dArray, n13 + nArray2[n12 + n55], dArray2, n60 + n63, nArray2[n12 + n67] - nArray2[n12 + n55]);
                        n54 = n55;
                        n53 = n67;
                        for (n52 = n54; n52 < n53; ++n52) {
                            nArray6[n51 + n64 + 1] = n63 += nArray2[n12 + n52 + 1] - nArray2[n12 + n52];
                            ++n64;
                        }
                        continue;
                    }
                    Tools.arraycopy(nArray2, n11 + nArray2[n12 + n55], nArray6, n59 + n62, nArray2[n12 + n67] - nArray2[n12 + n55]);
                    Tools.arraycopy(dArray, n13 + nArray2[n12 + n55], dArray2, n61 + n62, nArray2[n12 + n67] - nArray2[n12 + n55]);
                    n54 = n55;
                    n53 = n67;
                    for (n52 = n54; n52 < n53; ++n52) {
                        nArray6[n58 + n45 + 1] = n62 += nArray2[n12 + n52 + 1] - nArray2[n12 + n52];
                        ++n45;
                    }
                }
                n65 = 0;
                n66 = 0;
                n56 = n14;
                n55 = n66 < n56 ? n56 - n66 : 0;
                int[] nArray8 = new int[n55];
                n54 = n66;
                n53 = 0;
                while (n53 < n55) {
                    nArray8[n65] = nArray6[n36 + n54];
                    ++n65;
                    ++n53;
                    ++n54;
                }
                this.con_blocks.replace_row_code(this.xs, nArray8, n33, n39, n51, n57, n60);
                n53 = 0;
                n52 = 0;
                int n68 = n15;
                int n69 = n52 < n68 ? n68 - n52 : 0;
                int[] nArray9 = new int[n69];
                int n70 = n52;
                int n71 = 0;
                while (n71 < n69) {
                    nArray9[n53] = (int)lArray2[n37 + n70];
                    ++n53;
                    ++n71;
                    ++n70;
                }
                this.afe_blocks.replace_row_code(this.xs, nArray9, n38, n40, n58, n59, n61);
            } else {
                n51 = 0;
                int n72 = 0;
                int n73 = n14;
                int n74 = n72 < n73 ? n73 - n72 : 0;
                int[] nArray10 = new int[n74];
                int n75 = n72;
                int n76 = 0;
                while (n76 < n74) {
                    nArray10[n51] = nArray6[n36 + n75];
                    ++n51;
                    ++n76;
                    ++n75;
                }
                this.con_blocks.clear_row_code(nArray10);
                n76 = 0;
                int n77 = 0;
                int n78 = n15;
                int n79 = n77 < n78 ? n78 - n77 : 0;
                int[] nArray11 = new int[n79];
                int n80 = n77;
                int n81 = 0;
                while (n81 < n79) {
                    nArray11[n76] = (int)lArray2[n37 + n80];
                    ++n76;
                    ++n81;
                    ++n80;
                }
                this.afe_blocks.clear_row_code(nArray11);
            }
        }
        this.xs.clear();
    }

    protected void update(int[] nArray, Expression expression, int[] nArray2) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = nArray.length;
        for (n2 = n3; n2 < n4; ++n2) {
            if (nArray[n2] >= 0 && this.con_blocks.row_is_parameterized(n2)) {
                throw new UpdateError("Cannot update parameterized constraint");
            }
            if (nArray[n2] >= 0 || !this.con_blocks.row_is_parameterized(-(n2 + 1))) continue;
            throw new UpdateError("Cannot update parameterized constraint");
        }
        new ExprDense(new ExprCompress(expression)).eval(this.ws, this.rs, this.xs);
        this.ws.pop_expr();
        n3 = this.ws.nd;
        n4 = this.ws.nelem;
        n2 = this.ws.nnz;
        boolean bl = this.ws.hassp;
        int n5 = this.ws.ncodeatom;
        int n6 = this.ws.shape_base;
        int n7 = this.ws.ptr_base;
        int n8 = this.ws.sp_base;
        int n9 = this.ws.nidxs_base;
        int n10 = this.ws.cof_base;
        int n11 = this.ws.code_base;
        int n12 = this.ws.codeptr_base;
        int n13 = this.ws.cconst_base;
        int[] nArray3 = this.ws.i32;
        long[] lArray = this.ws.i64;
        double[] dArray = this.ws.f64;
        int n14 = 0;
        int n15 = 0;
        int n16 = n4;
        for (n = n15; n < n16; ++n) {
            if (nArray[n] < 0) continue;
            ++n14;
        }
        n15 = n4 - n14;
        if (n14 == n4 || n15 == n4) {
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22;
            int n23;
            n16 = nArray.length * nArray2.length;
            double[] dArray2 = new double[n16];
            int n24 = 0;
            int n25 = 0;
            int n26 = n4;
            for (n23 = n25; n23 < n26; ++n23) {
                n22 = nArray3[n7 + n23];
                n21 = nArray3[n7 + n23 + 1];
                n20 = n22;
                n19 = 0;
                while (n19 < nArray2.length && n20 < n21) {
                    if ((long)nArray2[n19] < lArray[n9 + n20]) {
                        ++n19;
                        continue;
                    }
                    if ((long)nArray2[n19] > lArray[n9 + n20]) {
                        ++n20;
                        continue;
                    }
                    dArray2[n24 + n19] = dArray[n10 + n20];
                    ++n19;
                    ++n20;
                }
                n24 += nArray2.length;
            }
            n25 = 0;
            n26 = 0;
            n23 = n4;
            n22 = n26 < n23 ? n23 - n26 : 0;
            n21 = 0;
            n20 = nArray2.length;
            n19 = n21 < n20 ? n20 - n21 : 0;
            int[] nArray4 = new int[n22 * n19];
            int n27 = n26;
            int n28 = 0;
            while (n28 < n22) {
                n18 = n21;
                n17 = 0;
                while (n17 < n19) {
                    nArray4[n25] = nArray2[n18];
                    ++n25;
                    ++n17;
                    ++n18;
                }
                ++n28;
                ++n27;
            }
            int[] nArray5 = nArray4;
            if (n14 == n4) {
                n18 = 0;
                n17 = 0;
                int n29 = n4;
                int n30 = n17 < n29 ? n29 - n17 : 0;
                int n31 = 0;
                int n32 = nArray2.length;
                int n33 = n31 < n32 ? n32 - n31 : 0;
                int[] nArray6 = new int[n30 * n33];
                int n34 = n17;
                int n35 = 0;
                while (n35 < n30) {
                    int n36 = n31;
                    int n37 = 0;
                    while (n37 < n33) {
                        nArray6[n18] = nArray[n34];
                        ++n18;
                        ++n37;
                        ++n36;
                    }
                    ++n35;
                    ++n34;
                }
                int[] nArray7 = nArray6;
                this.task_putaijlist(nArray7, nArray5, dArray2, n24);
                if (n5 > 0) {
                    this.con_blocks.replace_row_code(this.rs, nArray, n7, n9, n12, n11, n13);
                }
            } else {
                int n38;
                int n39;
                n18 = 0;
                n17 = 0;
                int n40 = n4;
                int n41 = n17 < n40 ? n40 - n17 : 0;
                int n42 = 0;
                int n43 = nArray2.length;
                int n44 = n42 < n43 ? n43 - n42 : 0;
                int[] nArray8 = new int[n41 * n44];
                int n45 = n17;
                int n46 = 0;
                while (n46 < n41) {
                    n39 = n42;
                    n38 = 0;
                    while (n38 < n44) {
                        nArray8[n18] = -(nArray[n45] + 1);
                        ++n18;
                        ++n38;
                        ++n39;
                    }
                    ++n46;
                    ++n45;
                }
                int[] nArray9 = nArray8;
                this.task_putafefijlist(nArray9, nArray5, dArray2);
                if (n5 > 0) {
                    n39 = 0;
                    n38 = 0;
                    int n47 = n4;
                    int n48 = n38 < n47 ? n47 - n38 : 0;
                    int[] nArray10 = new int[n48];
                    int n49 = n38;
                    int n50 = 0;
                    while (n50 < n48) {
                        nArray10[n39] = -(1 + nArray[n49]);
                        ++n39;
                        ++n50;
                        ++n49;
                    }
                    this.afe_blocks.replace_row_code(this.rs, nArray10, n7, n9, n12, n11, n13);
                }
            }
        } else {
            int n51;
            int n52;
            int n53;
            int n54;
            int n55;
            int n56;
            int n57;
            int n58;
            n16 = n15 * nArray2.length;
            n = n14 * nArray2.length;
            double[] dArray3 = new double[n];
            double[] dArray4 = new double[n16];
            int n59 = 0;
            int n60 = 0;
            int n61 = n14;
            int n62 = n60 < n61 ? n61 - n60 : 0;
            int n63 = 0;
            int n64 = nArray2.length;
            int n65 = n63 < n64 ? n64 - n63 : 0;
            int[] nArray11 = new int[n62 * n65];
            int n66 = n60;
            int n67 = 0;
            while (n67 < n62) {
                n58 = n63;
                n57 = 0;
                while (n57 < n65) {
                    nArray11[n59] = nArray2[n58];
                    ++n59;
                    ++n57;
                    ++n58;
                }
                ++n67;
                ++n66;
            }
            int[] nArray12 = nArray11;
            n58 = 0;
            n57 = 0;
            int n68 = n15;
            int n69 = n57 < n68 ? n68 - n57 : 0;
            int n70 = 0;
            int n71 = nArray2.length;
            int n72 = n70 < n71 ? n71 - n70 : 0;
            int[] nArray13 = new int[n69 * n72];
            int n73 = n57;
            int n74 = 0;
            while (n74 < n69) {
                int n75 = n70;
                int n76 = 0;
                while (n76 < n72) {
                    nArray13[n58] = nArray2[n75];
                    ++n58;
                    ++n76;
                    ++n75;
                }
                ++n74;
                ++n73;
            }
            int[] nArray14 = nArray13;
            int[] nArray15 = new int[n14];
            int[] nArray16 = new int[n15];
            boolean bl2 = false;
            boolean bl3 = false;
            int n77 = 0;
            int n78 = 0;
            int n79 = 0;
            int n80 = 0;
            int n81 = 0;
            int n82 = n4;
            for (n56 = n81; n56 < n82; ++n56) {
                int n83;
                int n84;
                n55 = nArray3[n7 + n56];
                n54 = nArray3[n7 + n56 + 1];
                n53 = n55;
                n52 = 0;
                if (nArray[n56] >= 0) {
                    while (n52 < nArray2.length && n53 < n54) {
                        if ((long)nArray2[n52] < lArray[n9 + n53]) {
                            ++n52;
                            continue;
                        }
                        if ((long)nArray2[n52] > lArray[n9 + n53]) {
                            ++n53;
                            continue;
                        }
                        dArray3[n80 + n52] = dArray[n10 + n53];
                        ++n52;
                        ++n53;
                    }
                    n84 = 0;
                    n83 = nArray2.length;
                    for (n51 = n84; n51 < n83; ++n51) {
                        nArray15[n80 + n51] = nArray[n56];
                    }
                    n80 += nArray2.length;
                    continue;
                }
                while (n52 < nArray2.length && n53 < n54) {
                    if ((long)nArray2[n52] < lArray[n9 + n53]) {
                        ++n52;
                        continue;
                    }
                    if ((long)nArray2[n52] > lArray[n9 + n53]) {
                        ++n53;
                        continue;
                    }
                    dArray4[n79 + n52] = dArray[n10 + n53];
                    ++n52;
                    ++n53;
                }
                n84 = 0;
                n83 = nArray2.length;
                for (n51 = n84; n51 < n83; ++n51) {
                    nArray16[n79 + n51] = -(1 + nArray[n56]);
                }
                n79 += nArray2.length;
            }
            this.task_putaijlist(nArray15, nArray12, dArray3, n80);
            this.task_putafefijlist(nArray16, nArray14, dArray4);
            if (n5 > 0) {
                int n85;
                int n86;
                int n87;
                n81 = 0;
                n82 = n4;
                for (n56 = n81; n56 < n82; ++n56) {
                    if (nArray[n56] >= 0) {
                        n80 += nArray3[n7 + n56 + 1] - nArray3[n7 + n56];
                        continue;
                    }
                    n79 += nArray3[n7 + n56 + 1] - nArray3[n7 + n56];
                }
                int[] nArray17 = new int[n14];
                int[] nArray18 = new int[n15];
                n56 = this.xs.alloci32(n14 + 1);
                n55 = this.xs.alloci32(n15 + 1);
                n54 = this.xs.alloci64(n80);
                n53 = this.xs.alloci64(n79);
                double[] dArray5 = this.xs.f64;
                long[] lArray2 = this.xs.i64;
                int[] nArray19 = this.xs.i32;
                nArray19[n56] = 0;
                nArray19[n55] = 0;
                n51 = 0;
                int n88 = 0;
                int n89 = 0;
                int n90 = 0;
                int n91 = 0;
                int n92 = n4;
                for (n87 = n91; n87 < n92; ++n87) {
                    n86 = nArray3[n7 + n87];
                    n85 = nArray3[n7 + n87 + 1];
                    if (nArray[n87] >= 0) {
                        nArray17[n88] = nArray[n87];
                        nArray19[n56 + n88 + 1] = n90 += n85 - n86;
                        ++n88;
                        continue;
                    }
                    nArray18[n51] = -(1 + nArray[n87]);
                    nArray19[n55 + n51 + 1] = n89 += n85 - n86;
                    ++n51;
                }
                n91 = 0;
                n92 = n4;
                for (n87 = n91; n87 < n92; ++n87) {
                    if (nArray[n87] >= 0) {
                        n78 += nArray3[n12 + nArray3[n7 + n87 + 1]] - nArray3[n12 + nArray3[n7 + n87]];
                        continue;
                    }
                    n77 += nArray3[n12 + nArray3[n7 + n87 + 1]] - nArray3[n12 + nArray3[n7 + n87]];
                }
                n91 = this.xs.alloci32(n80 + 1);
                n92 = this.xs.alloci32(n79 + 1);
                n87 = this.xs.alloci32(n78);
                n86 = this.xs.alloci32(n77);
                n85 = this.xs.allocf64(n78);
                int n93 = this.xs.allocf64(n77);
                nArray19[n91] = 0;
                nArray19[n92] = 0;
                int n94 = 0;
                int n95 = 0;
                boolean bl4 = false;
                int n96 = 0;
                int n97 = 0;
                int n98 = n4;
                for (int i = n97; i < n98; ++i) {
                    int n99;
                    int n100;
                    int n101;
                    int n102 = nArray3[n7 + i];
                    int n103 = nArray3[n7 + i + 1];
                    if (nArray[i] >= 0) {
                        Tools.arraycopy(nArray3, n11 + nArray3[n12 + n102], nArray19, n87 + n95, nArray3[n12 + n103] - nArray3[n12 + n102]);
                        Tools.arraycopy(dArray, n13 + nArray3[n12 + n102], dArray5, n85 + n95, nArray3[n12 + n103] - nArray3[n12 + n102]);
                        n101 = n102;
                        n100 = n103;
                        for (n99 = n101; n99 < n100; ++n99) {
                            nArray19[n91 + n96 + 1] = n95 += nArray3[n12 + n99 + 1] - nArray3[n12 + n99];
                            ++n96;
                        }
                        continue;
                    }
                    Tools.arraycopy(nArray3, n11 + nArray3[n12 + n102], nArray19, n86 + n94, nArray3[n12 + n103] - nArray3[n12 + n102]);
                    Tools.arraycopy(dArray, n13 + nArray3[n12 + n102], dArray5, n93 + n94, nArray3[n12 + n103] - nArray3[n12 + n102]);
                    n101 = n102;
                    n100 = n103;
                    for (n99 = n101; n99 < n100; ++n99) {
                        nArray19[n92 + n89 + 1] = n94 += nArray3[n12 + n99 + 1] - nArray3[n12 + n99];
                        ++n89;
                    }
                }
                this.con_blocks.replace_row_code(this.xs, nArray17, n56, n54, n91, n87, n85);
                this.afe_blocks.replace_row_code(this.xs, nArray18, n55, n53, n92, n86, n93);
            } else {
                int[] nArray20 = new int[n14];
                int[] nArray21 = new int[n15];
                n56 = 0;
                n55 = 0;
                n54 = 0;
                n53 = n4;
                for (n52 = n54; n52 < n53; ++n52) {
                    if (nArray[n52] >= 0) {
                        nArray20[n55] = nArray[n52];
                        ++n55;
                        continue;
                    }
                    nArray21[n56] = -(1 + nArray[n52]);
                    ++n56;
                }
                this.con_blocks.clear_row_code(nArray20);
                this.afe_blocks.clear_row_code(nArray21);
            }
        }
        this.xs.clear();
    }

    public void updateObjective(Expression expression, Variable variable) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        if (expression.getSize() != 1L) {
            throw new DimensionError("Invalid expression size for objective");
        }
        if (this.obj_blocks.code_used > 0) {
            throw new UpdateError("Cannot update parameterized constraint");
        }
        int n12 = variable.numInst();
        long[] lArray = new long[n12];
        if ((long)n12 < variable.getSize()) {
            long[] lArray2 = new long[n12];
            variable.inst(0, lArray2, 0, lArray);
        } else {
            variable.inst(0, lArray);
        }
        int n13 = 0;
        int n14 = n12;
        for (n11 = n13; n11 < n14; ++n11) {
            if (lArray[n11] >= 0L) continue;
            throw new UpdateError("Updating semidefinite terms is currently not possible");
        }
        n13 = 1;
        n14 = 0;
        n11 = n12 - 1;
        for (n10 = n14; n10 < n11; ++n10) {
            n13 = n13 != 0 && lArray[n10] < lArray[n10 - 1] ? 1 : 0;
        }
        Object[] objectArray = null;
        if (n13 != 0) {
            n11 = 0;
            n10 = 0;
            var9_12 = n12;
            n9 = n10 < var9_12 ? var9_12 - n10 : 0;
            var11_15 = new int[n9];
            n8 = n10;
            n7 = 0;
            while (n7 < n9) {
                var11_15[n11] = (int)lArray[n8];
                ++n11;
                ++n7;
                ++n8;
            }
            objectArray = var11_15;
        } else {
            n11 = 0;
            n10 = -1;
            var9_12 = n12;
            n9 = n10 < var9_12 ? var9_12 - n10 : 0;
            var11_15 = new long[n9];
            n8 = n10;
            int n15 = 0;
            while (n15 < n9) {
                var11_15[n11] = (int)((long)n8);
                ++n11;
                ++n15;
                ++n8;
            }
            Object[] objectArray2 = var11_15;
            CommonTools.argQsort((long[])objectArray2, lArray, null, 0L, (long)n12);
            n6 = 0;
            n5 = 0;
            n4 = n12;
            n3 = n5 < n4 ? n4 - n5 : 0;
            int[] nArray = new int[n3];
            n2 = n5;
            n = 0;
            while (n < n3) {
                nArray[n6] = (int)lArray[(int)objectArray2[n2]];
                ++n6;
                ++n;
                ++n2;
            }
            objectArray = nArray;
        }
        n11 = objectArray.length;
        double[] dArray = new double[n11];
        Object[] objectArray3 = objectArray;
        new ExprDense(new ExprCompress(expression)).eval(this.ws, this.rs, this.xs);
        this.ws.pop_expr();
        n9 = this.ws.nd;
        int n16 = this.ws.nelem;
        n8 = this.ws.nnz;
        n7 = this.ws.hassp ? 1 : 0;
        n6 = this.ws.ncodeatom;
        n5 = this.ws.shape_base;
        n4 = this.ws.ptr_base;
        n3 = this.ws.sp_base;
        int n17 = this.ws.nidxs_base;
        n2 = this.ws.cof_base;
        n = this.ws.code_base;
        int n18 = this.ws.codeptr_base;
        int n19 = this.ws.cconst_base;
        if (n6 > 0) {
            throw new UpdateError("Cannot update parameterized objective");
        }
        int[] nArray = this.ws.i32;
        long[] lArray3 = this.ws.i64;
        double[] dArray2 = this.ws.f64;
        int n20 = 0;
        int n21 = 0;
        int n22 = n16;
        for (int i = n21; i < n22; ++i) {
            int n23 = nArray[n4 + i];
            int n24 = nArray[n4 + i + 1];
            int n25 = n23;
            int n26 = 0;
            while (n26 < objectArray.length && n25 < n24) {
                if ((long)objectArray[n26] < lArray3[n17 + n25]) {
                    ++n26;
                    continue;
                }
                if ((long)objectArray[n26] > lArray3[n17 + n25]) {
                    ++n25;
                    continue;
                }
                dArray[n20 + n26] = dArray2[n2 + n25];
                ++n26;
                ++n25;
            }
            n20 += objectArray.length;
        }
        this.task_putclist((int[])objectArray3, dArray);
        if (n6 > 0) {
            this.obj_blocks.replace_row_code(this.rs, new int[]{0}, n4, n17, n18, n, n19);
        }
    }

    private Parameter parameter_unchecked(String string, int[] nArray, long[] lArray) {
        int n;
        int n2;
        if (string.length() > 0 && this.par_map.hasItem(string)) {
            throw new NameError("Duplicate parameter name");
        }
        long l = Set.size(nArray);
        int n3 = n2 = lArray != null ? lArray.length : (int)l;
        if (this.param_value == null) {
            this.param_value = new double[n2];
        } else if (this.param_num + n2 > this.param_value.length) {
            double[] dArray = this.param_value;
            n = 2 * dArray.length > dArray.length + n2 ? 2 * dArray.length : dArray.length + n2;
            this.param_value = new double[n];
            if (this.param_num > 0) {
                Tools.arraycopy(dArray, 0, this.param_value, 0, this.param_num);
            }
        }
        int n4 = 0;
        n = 0;
        int n5 = n2;
        int n6 = n < n5 ? n5 - n : 0;
        int[] nArray2 = new int[n6];
        int n7 = n;
        int n8 = 0;
        while (n8 < n6) {
            nArray2[n4] = this.param_num + n7;
            ++n4;
            ++n8;
            ++n7;
        }
        ParameterImpl parameterImpl = new ParameterImpl(this, nArray, lArray, nArray2);
        this.param_num += n2;
        if (string.length() > 0) {
            if (this.parameters == null || this.numparameter == this.parameters.length) {
                Parameter[] parameterArray = this.parameters;
                int n9 = 0;
                int n10 = 0;
                int n11 = this.numparameter * 2 + 64;
                int n12 = n10 < n11 ? n11 - n10 : 0;
                Parameter[] parameterArray2 = new Parameter[n12];
                int n13 = n10;
                int n14 = 0;
                while (n14 < n12) {
                    parameterArray2[n9] = null;
                    ++n9;
                    ++n14;
                    ++n13;
                }
                this.parameters = parameterArray2;
                n14 = 0;
                int n15 = this.numparameter;
                for (int i = n14; i < n15; ++i) {
                    this.parameters[i] = parameterArray[i];
                }
            }
            this.parameters[this.numparameter] = parameterImpl;
            this.par_map.setItem(string, this.numparameter);
            ++this.numparameter;
        }
        return parameterImpl;
    }

    private Parameter parameter_(String string, int[] nArray, long[] lArray) {
        boolean bl = true;
        int n = nArray.length;
        if (lArray != null && lArray.length > 0) {
            boolean bl2 = lArray[lArray.length - 1] < Set.size(nArray);
            int n2 = 1;
            int n3 = lArray.length;
            for (int i = n2; i < n3; ++i) {
                bl2 = bl2 && lArray[i - 1] < lArray[i];
            }
            if (!bl2) {
                throw new IndexError("Unordered sparsity pattern");
            }
        }
        return this.parameter_unchecked(string, nArray, lArray);
    }

    private Parameter parameter_(String string, int[] nArray, int[][] nArray2) {
        int n;
        int n2 = nArray2.length;
        int n3 = nArray2[0].length;
        if (nArray.length != n3) {
            throw new LengthError("Invalid sparsity");
        }
        if (nArray2 == null) {
            return this.parameter_unchecked(string, nArray, null);
        }
        long[] lArray = new long[n2];
        long[] lArray2 = new long[n3];
        lArray2[n3 - 1] = 1L;
        int n4 = 1;
        int n5 = n3;
        for (n = n4; n < n5; ++n) {
            lArray2[n3 - 1 - n] = lArray2[n3 - n] * (long)nArray[n3 - n];
        }
        n4 = 0;
        n5 = n2;
        for (n = n4; n < n5; ++n) {
            lArray[n] = 0L;
            int n6 = 0;
            int n7 = n3;
            for (int i = n6; i < n7; ++i) {
                int n8 = n;
                lArray[n8] = lArray[n8] + (long)nArray2[n][i] * lArray2[i];
            }
        }
        return this.parameter_(string, nArray, lArray);
    }

    public Parameter parameter(String string) {
        long[] lArray = null;
        return this.parameter_(string, new int[0], lArray);
    }

    public Parameter parameter(String string, int n, int n2, int n3) {
        long[] lArray = null;
        return this.parameter_(string, new int[]{n, n2, n3}, lArray);
    }

    public Parameter parameter(String string, int n, int n2) {
        long[] lArray = null;
        return this.parameter_(string, new int[]{n, n2}, lArray);
    }

    public Parameter parameter(String string, int n) {
        long[] lArray = null;
        return this.parameter_(string, new int[]{n}, lArray);
    }

    public Parameter parameter(String string, int[] nArray) {
        long[] lArray = null;
        return this.parameter_(string, nArray, lArray);
    }

    public Parameter parameter(String string, int[] nArray, long[] lArray) {
        return this.parameter_(string, nArray, lArray);
    }

    public Parameter parameter(String string, int[] nArray, int[][] nArray2) {
        return this.parameter_(string, nArray, nArray2);
    }

    public Parameter parameter() {
        long[] lArray = null;
        return this.parameter_("", new int[0], lArray);
    }

    public Parameter parameter(int n, int n2, int n3) {
        long[] lArray = null;
        return this.parameter_("", new int[]{n, n2, n3}, lArray);
    }

    public Parameter parameter(int n, int n2) {
        long[] lArray = null;
        return this.parameter_("", new int[]{n, n2}, lArray);
    }

    public Parameter parameter(int n) {
        long[] lArray = null;
        return this.parameter_("", new int[]{n}, lArray);
    }

    public Parameter parameter(int[] nArray) {
        long[] lArray = null;
        return this.parameter_("", nArray, lArray);
    }

    public Parameter parameter(int[] nArray, long[] lArray) {
        return this.parameter_("", nArray, lArray);
    }

    public Parameter parameter(int[] nArray, int[][] nArray2) {
        return this.parameter_("", nArray, nArray2);
    }

    private void objective_(String string, ObjectiveSense objectiveSense, Expression expression) {
        int n;
        int n2;
        this.task_putobjectivename(string);
        WorkStack workStack = new WorkStack();
        WorkStack workStack2 = new WorkStack();
        ExprDense exprDense = new ExprDense(new ExprOptimizeCode(new ExprCompress(expression)));
        exprDense.eval(workStack, workStack2, this.xs);
        workStack.pop_expr();
        int[] nArray = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n3 = workStack.nd;
        int n4 = workStack.nelem;
        int n5 = workStack.nnz;
        boolean bl = workStack.hassp;
        int n6 = workStack.ncodeatom;
        int n7 = workStack.ptr_base;
        int n8 = workStack.shape_base;
        int n9 = workStack.nidxs_base;
        int n10 = workStack.cof_base;
        int n11 = workStack.code_base;
        int n12 = workStack.codeptr_base;
        int n13 = workStack.cconst_base;
        long l = 1L;
        int n14 = 0;
        int n15 = n3;
        for (n2 = n14; n2 < n15; ++n2) {
            n3 *= nArray[n8 + n2];
        }
        if (l != 1L) {
            throw new LengthError("Invalid expression size for objective");
        }
        if (n4 != 1) {
            throw new LengthError("Invalid expression for objective");
        }
        n14 = 0;
        n15 = 0;
        n2 = 0;
        int n16 = n5;
        for (n = n2; n < n16; ++n) {
            if (lArray[n9 + n] < 0L) {
                ++n15;
                continue;
            }
            if (lArray[n9 + n] < 0L) continue;
            ++n14;
        }
        int[] nArray2 = new int[n14];
        double[] dArray2 = new double[n14];
        n = 0;
        int n17 = 0;
        int n18 = n5;
        for (int i = n17; i < n18; ++i) {
            if (lArray[n9 + i] < 0L) continue;
            nArray2[n] = (int)lArray[n9 + i];
            dArray2[n] = dArray[n10 + i];
            ++n;
        }
        this.task_putobjective(objectiveSense == ObjectiveSense.Maximize, nArray2, dArray2, 0.0);
        if (n15 > 0) {
            int[] nArray3 = new int[n15];
            int[] nArray4 = new int[n15];
            int[] nArray5 = new int[n15];
            double[] dArray3 = new double[n15];
            int n19 = 0;
            int n20 = n15;
            for (int i = n19; i < n20; ++i) {
                long l2 = -(lArray[n9 + i] + 1L);
                nArray3[i] = this.barvar_block_elm_barj[(int)l2];
                nArray4[i] = this.barvar_block_elm_i[(int)l2];
                nArray5[i] = this.barvar_block_elm_j[(int)l2];
                dArray3[i] = nArray4[i] == nArray5[i] ? dArray[n10 + i] : 0.5 * dArray[n10 + i];
            }
            this.task_putbarc(nArray3, nArray4, nArray5, dArray3);
        }
        if (n6 > 0) {
            this.obj_blocks.replace_row_code(workStack, new int[]{0}, n7, n9, n12, n11, n13);
        }
    }

    public void objective(double d) {
        this.objective_("", ObjectiveSense.Minimize, Expr.constTerm(d));
    }

    public void objective(ObjectiveSense objectiveSense, double d) {
        this.objective_("", objectiveSense, Expr.constTerm(d));
    }

    public void objective(ObjectiveSense objectiveSense, Expression expression) {
        this.objective_("", objectiveSense, expression);
    }

    public void objective(String string, double d) {
        this.objective_(string, ObjectiveSense.Minimize, Expr.constTerm(d));
    }

    public void objective(String string, ObjectiveSense objectiveSense, double d) {
        this.objective_(string, objectiveSense, Expr.constTerm(d));
    }

    public void objective(String string, ObjectiveSense objectiveSense, Expression expression) {
        this.objective_(string, objectiveSense, expression);
    }

    public RangedConstraint constraint(ExprRangeDomain exprRangeDomain) {
        return this.constraint_("", exprRangeDomain.expr, exprRangeDomain.dom);
    }

    public RangedConstraint constraint(String string, ExprRangeDomain exprRangeDomain) {
        return this.constraint_(string, exprRangeDomain.expr, exprRangeDomain.dom);
    }

    public RangedConstraint constraint(Expression expression, RangeDomain rangeDomain) {
        return this.constraint_("", expression, rangeDomain);
    }

    public RangedConstraint constraint(String string, Expression expression, RangeDomain rangeDomain) {
        return this.constraint_(string, expression, rangeDomain);
    }

    public Constraint constraint(ExprConicDomain exprConicDomain) {
        return this.constraint_("", exprConicDomain.expr, exprConicDomain.dom);
    }

    public Constraint constraint(String string, ExprConicDomain exprConicDomain) {
        return this.constraint_(string, exprConicDomain.expr, exprConicDomain.dom);
    }

    public Constraint constraint(Expression expression, ConeDomain coneDomain) {
        return this.constraint_("", expression, coneDomain);
    }

    public Constraint constraint(String string, Expression expression, ConeDomain coneDomain) {
        return this.constraint_(string, expression, coneDomain);
    }

    public Constraint constraint(ExprLinearDomain exprLinearDomain) {
        return this.constraint_("", exprLinearDomain.expr, exprLinearDomain.dom);
    }

    public Constraint constraint(String string, ExprLinearDomain exprLinearDomain) {
        return this.constraint_(string, exprLinearDomain.expr, exprLinearDomain.dom);
    }

    public Constraint constraint(Expression expression, LinearDomain linearDomain) {
        return this.constraint_("", expression, linearDomain);
    }

    public Constraint constraint(String string, Expression expression, LinearDomain linearDomain) {
        return this.constraint_(string, expression, linearDomain);
    }

    public Constraint constraint(ExprPSDDomain exprPSDDomain) {
        return this.constraint_("", exprPSDDomain.expr, exprPSDDomain.dom);
    }

    public Constraint constraint(String string, ExprPSDDomain exprPSDDomain) {
        return this.constraint_(string, exprPSDDomain.expr, exprPSDDomain.dom);
    }

    public Constraint constraint(Expression expression, PSDDomain pSDDomain) {
        return this.constraint_("", expression, pSDDomain);
    }

    public Constraint constraint(String string, Expression expression, PSDDomain pSDDomain) {
        return this.constraint_(string, expression, pSDDomain);
    }

    public Variable variable(PSDDomain pSDDomain) {
        return this.variable_("", pSDDomain.shape, pSDDomain);
    }

    public Variable variable(int n, int n2, PSDDomain pSDDomain) {
        return this.variable_("", new int[]{n2, n, n}, pSDDomain);
    }

    public Variable variable(int n, PSDDomain pSDDomain) {
        return this.variable_("", new int[]{n, n}, pSDDomain);
    }

    public Variable variable(String string, PSDDomain pSDDomain) {
        return this.variable_(string, null, pSDDomain);
    }

    public Variable variable(String string, int n, int n2, PSDDomain pSDDomain) {
        return this.variable_(string, new int[]{n2, n, n}, pSDDomain);
    }

    public Variable variable(String string, int n, PSDDomain pSDDomain) {
        return this.variable_(string, new int[]{n, n}, pSDDomain);
    }

    public Variable variable(String string, int[] nArray, PSDDomain pSDDomain) {
        return this.variable_(string, nArray, pSDDomain);
    }

    public Variable variable(ConeDomain coneDomain) {
        return this.variable_("", null, coneDomain);
    }

    public RangedVariable variable(RangeDomain rangeDomain) {
        return this.ranged_variable("", null, rangeDomain);
    }

    public Variable variable(LinearDomain linearDomain) {
        return this.variable_("", null, linearDomain);
    }

    public Variable variable(int[] nArray, ConeDomain coneDomain) {
        return this.variable_("", nArray, coneDomain);
    }

    public RangedVariable variable(int[] nArray, RangeDomain rangeDomain) {
        return this.ranged_variable("", nArray, rangeDomain);
    }

    public Variable variable(int[] nArray, LinearDomain linearDomain) {
        return this.variable_("", nArray, linearDomain);
    }

    public Variable variable(int[] nArray) {
        return this.variable_("", nArray, Domain.unbounded());
    }

    public Variable variable(int n, ConeDomain coneDomain) {
        return this.variable_("", new int[]{n}, coneDomain);
    }

    public RangedVariable variable(int n, RangeDomain rangeDomain) {
        return this.ranged_variable("", new int[]{n}, rangeDomain);
    }

    public Variable variable(int n, LinearDomain linearDomain) {
        return this.variable_("", new int[]{n}, linearDomain);
    }

    public Variable variable(int n) {
        return this.variable_("", new int[]{n}, Domain.unbounded());
    }

    public Variable variable() {
        return this.variable_("", new int[0], Domain.unbounded());
    }

    public Variable variable(String string, ConeDomain coneDomain) {
        return this.variable_(string, null, coneDomain);
    }

    public RangedVariable variable(String string, RangeDomain rangeDomain) {
        return this.ranged_variable(string, null, rangeDomain);
    }

    public Variable variable(String string, LinearDomain linearDomain) {
        return this.variable_(string, null, linearDomain);
    }

    public Variable variable(String string, int[] nArray, ConeDomain coneDomain) {
        return this.variable_(string, nArray, coneDomain);
    }

    public RangedVariable variable(String string, int[] nArray, RangeDomain rangeDomain) {
        return this.ranged_variable(string, nArray, rangeDomain);
    }

    public Variable variable(String string, int[] nArray, LinearDomain linearDomain) {
        return this.variable_(string, nArray, linearDomain);
    }

    public Variable variable(String string, int[] nArray) {
        return this.variable_(string, nArray, Domain.unbounded());
    }

    public Variable variable(String string, int n, ConeDomain coneDomain) {
        return this.variable_(string, new int[]{n}, coneDomain);
    }

    public RangedVariable variable(String string, int n, RangeDomain rangeDomain) {
        return this.ranged_variable(string, new int[]{n}, rangeDomain);
    }

    public Variable variable(String string, int n, LinearDomain linearDomain) {
        return this.variable_(string, new int[]{n}, linearDomain);
    }

    public Variable variable(String string, int n) {
        return this.variable_(string, new int[]{n}, Domain.unbounded());
    }

    public Variable variable(String string) {
        return this.variable_(string, new int[0], Domain.unbounded());
    }

    protected void removeConstraintBlock(int n) {
        if (n >= 0) {
            this.con_release(n);
        } else {
            this.acon_release(-(1 + n));
        }
    }

    protected void removeVariableBlock(long l) {
        if (this.con_blocks.is_parameterized() || this.afe_blocks.is_parameterized()) {
            throw new DeletionError("Cannot remove variables in parameterized model");
        }
        if (l < 0L) {
            throw new DeletionError("PSD variables cannot be removed");
        }
        int n = (int)l;
        int n2 = this.var_block_map.blocksize(n);
        int[] nArray = new int[n2];
        this.var_block_map.get(n, nArray, 0);
        this.var_block_map.free(n);
        int n3 = this.var_block_acc_id[n];
        if (n3 >= 0) {
            this.removeConstraintBlock(n3);
        }
        this.task_var_putboundlist_fr(nArray);
        this.task_clearacollist(nArray);
    }

    private RangedVariable ranged_variable(String string, int[] nArray, RangeDomain rangeDomain) {
        double[] dArray;
        double[] dArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object[] objectArray;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        StringBuffer stringBuffer;
        Object object;
        int n13;
        int n14;
        int n15;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        RangeDomain rangeDomain2 = rangeDomain.finalize_and_validate(nArray);
        int[] nArray2 = rangeDomain2.shape;
        int n16 = nArray2.length;
        int[] nArray3 = new int[n16];
        if (n16 > 0) {
            nArray3[n16 - 1] = 1;
            n15 = 1;
            n14 = n16;
            for (n13 = n15; n13 < n14; ++n13) {
                nArray3[n16 - n13 - 1] = nArray3[n16 - n13] * nArray2[n16 - n13];
            }
        }
        n15 = 1;
        n14 = 0;
        n13 = nArray2.length;
        for (int i = n14; i < n13; ++i) {
            n15 *= nArray2[i];
        }
        Object[] objectArray2 = null;
        long[] lArray = null;
        Object object2 = null;
        Object var12_15 = null;
        Object var13_16 = null;
        StringBuffer stringBuffer2 = null;
        if (string.length() > 0 && rangeDomain2.indexnames != null) {
            object = new StringBuffer();
            stringBuffer = new StringBuffer();
            n12 = 0;
            long l = 0L;
            long l2 = 0L;
            if (rangeDomain2.indexnames.length != n16) {
                throw new DomainError("Invalid index name definition");
            }
            n11 = 0;
            n10 = rangeDomain2.indexnames.length;
            for (n9 = n11; n9 < n10; ++n9) {
                if (rangeDomain2.indexnames[n9] == null) continue;
                if (nArray2[n9] != rangeDomain2.indexnames[n9].length) {
                    throw new DomainError("Invalid index name definition");
                }
                l2 += (long)nArray2[n9];
            }
            lArray = new long[(int)(l2 + 1L)];
            n11 = 0;
            n10 = 0;
            n9 = n16;
            n8 = n10 < n9 ? n9 - n10 : 0;
            objectArray = new int[n8];
            n7 = n10;
            n6 = 0;
            while (n6 < n8) {
                objectArray[n11] = -1;
                ++n11;
                ++n6;
                ++n7;
            }
            objectArray2 = objectArray;
            n6 = 0;
            n5 = rangeDomain2.indexnames.length;
            for (n4 = n6; n4 < n5; ++n4) {
                if (rangeDomain2.indexnames[n4] == null) continue;
                objectArray2[n4] = n12;
                n3 = 0;
                int n17 = nArray2[n4];
                for (n2 = n3; n2 < n17; ++n2) {
                    ((StringBuffer)object).a(rangeDomain2.indexnames[n4][n2]);
                    lArray[++n12] = l += (long)rangeDomain2.indexnames[n4][n2].length();
                }
            }
            object2 = object;
            stringBuffer2 = stringBuffer;
        }
        object = null;
        stringBuffer = null;
        if (rangeDomain2.empty) {
            object = new long[0];
        } else if (rangeDomain2.sparsity != null) {
            if (rangeDomain2.sparsity[0].length != n16) {
                throw new SparseFormatError("Sparsity pattern is not correct");
            }
            n12 = rangeDomain2.sparsity.length;
            object = new long[n12];
            boolean bl = false;
            int[][] nArray4 = rangeDomain2.sparsity;
            int n18 = 0;
            int n19 = n12;
            for (n11 = n18; n11 < n19; ++n11) {
                n10 = 0;
                n9 = nArray4[0].length;
                for (n8 = n10; n8 < n9; ++n8) {
                    bl = bl || nArray4[n11][n8] < 0 || nArray4[n11][n8] >= nArray2[n8];
                }
                if (bl) continue;
                long l = 0L;
                n8 = 0;
                int n20 = nArray4[0].length;
                for (n7 = n8; n7 < n20; ++n7) {
                    l += (long)(nArray3[n7] * nArray4[n11][n7]);
                }
                object[n11] = l;
            }
            if (bl) {
                throw new SparseFormatError("Sparsity pattern is out of bounds");
            }
            int[][] nArray5 = rangeDomain2.sparsity;
            n = 0;
            n18 = 0;
            n19 = n16;
            for (n11 = n18; n11 < n19; ++n11) {
                if (n >= nArray2[n11]) continue;
                n = nArray2[n11];
            }
            int[] nArray6 = new int[n12];
            n19 = 0;
            n11 = n12;
            for (n10 = n19; n10 < n11; ++n10) {
                nArray6[n10] = n10;
            }
            Object[] objectArray3 = new int[n12];
            int[] nArray7 = new int[n + 1];
            n10 = 0;
            n9 = n16;
            for (n8 = n10; n8 < n9; ++n8) {
                int n21 = n16 - n8 - 1;
                n7 = 0;
                n6 = nArray2[n21] + 1;
                for (n5 = n7; n5 < n6; ++n5) {
                    nArray7[n5] = 0;
                }
                n7 = 0;
                n6 = n12;
                for (n5 = n7; n5 < n6; ++n5) {
                    int n22 = nArray5[n5][n21] + 1;
                    nArray7[n22] = nArray7[n22] + 1;
                }
                n7 = 0;
                n6 = nArray2[n21];
                for (n5 = n7; n5 < n6; ++n5) {
                    int n23 = n5 + 1;
                    nArray7[n23] = nArray7[n23] + nArray7[n5];
                }
                n7 = 0;
                n6 = n12;
                for (n5 = n7; n5 < n6; ++n5) {
                    objectArray3[nArray7[nArray5[n4][n21]]] = n4 = nArray6[n5];
                    int n24 = nArray5[n4][n21];
                    nArray7[n24] = nArray7[n24] + 1;
                }
                objectArray = nArray6;
                nArray6 = objectArray3;
                objectArray3 = objectArray;
            }
            n10 = 0;
            n9 = n12;
            for (n8 = n10; n8 < n9; ++n8) {
                int n25 = nArray6[n8];
                long l = 0L;
                n5 = 0;
                n4 = n16;
                for (n3 = n5; n3 < n4; ++n3) {
                    l += (long)(nArray3[n3] * nArray5[n25][n3]);
                }
                object[n8] = l;
            }
        }
        n12 = object != null ? ((Object)object).length : n15;
        int[] nArray8 = new int[n12];
        n = this.linearvar_alloc(n12, nArray8);
        if (string.length() > 0) {
            this.var_map.setItem(string, n);
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.a(string).a("[");
            if (n16 > 0) {
                stringBuffer3.a("%0");
                int n26 = 1;
                int n27 = n16;
                for (n10 = n26; n10 < n27; ++n10) {
                    stringBuffer3.a(",%").a(n10);
                }
            }
            stringBuffer3.a("]");
            if (rangeDomain2.indexnames != null) {
                this.task_format_var_names(nArray8, stringBuffer3.toString(), nArray2, (long[])object, rangeDomain2.indexnames);
            } else {
                this.task_format_var_names(nArray8, stringBuffer3.toString(), nArray2, (long[])object, null);
            }
        }
        if (rangeDomain2.scalable) {
            int n28 = 0;
            n10 = 0;
            n9 = n12;
            n8 = n10 < n9 ? n9 - n10 : 0;
            objectArray = new double[n8];
            n7 = n10;
            n6 = 0;
            while (n6 < n8) {
                objectArray[n28] = rangeDomain2.lb[0];
                ++n28;
                ++n6;
                ++n7;
            }
            dArray2 = objectArray;
            n6 = 0;
            n5 = 0;
            n4 = n12;
            n3 = n5 < n4 ? n4 - n5 : 0;
            double[] dArray3 = new double[n3];
            n2 = n5;
            int n29 = 0;
            while (n29 < n3) {
                dArray3[n6] = rangeDomain2.ub[0];
                ++n6;
                ++n29;
                ++n2;
            }
            dArray = dArray3;
        } else {
            dArray2 = rangeDomain2.lb;
            dArray = rangeDomain2.ub;
        }
        this.task_var_putboundlist_ra(nArray8, dArray2, dArray);
        RangedVariable rangedVariable = new RangedVariable(this, string, n, nArray2, (long[])object, nArray8);
        if (rangeDomain2.cardinal_flag) {
            this.task_var_putintlist(nArray8);
        }
        this.vars[n] = rangedVariable;
        return rangedVariable;
    }

    private Variable variable_(String string, int[] nArray, ConeDomain coneDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        long l;
        int n9;
        ConeDomain coneDomain2 = coneDomain.finalize_and_validate(nArray);
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        int[] nArray2 = coneDomain2.shape;
        int n10 = nArray2.length;
        int n11 = coneDomain2.getAxis();
        int n12 = nArray2[n11];
        int n13 = 1;
        int n14 = 1;
        int n15 = 1;
        int n16 = 0;
        int n17 = n10;
        for (n9 = n16; n9 < n17; ++n9) {
            n15 *= nArray2[n9];
        }
        n16 = 0;
        n17 = n11;
        for (n9 = n16; n9 < n17; ++n9) {
            n14 *= nArray2[n9];
        }
        n16 = n11 + 1;
        n17 = n10;
        for (n9 = n16; n9 < n17; ++n9) {
            n13 *= nArray2[n9];
        }
        n16 = n14 * n13;
        if (coneDomain2.key == QConeKey.InQCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for quadratic cone").toString());
            }
            l = this.task_append_domain_quad(n12);
        } else if (coneDomain2.key == QConeKey.InRotatedQCone) {
            if (n12 < 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for rotated quadratic cone").toString());
            }
            l = this.task_append_domain_rquad(n12);
        } else if (coneDomain2.key == QConeKey.InPExpCone) {
            if (n12 != 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for exponential cone").toString());
            }
            l = this.task_append_domain_pexp();
        } else if (coneDomain2.key == QConeKey.InPPowCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for power cone").toString());
            }
            l = this.task_append_domain_ppow(n12, coneDomain2.alpha);
        } else if (coneDomain2.key == QConeKey.InDExpCone) {
            if (n12 != 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for dual exponential cone").toString());
            }
            l = this.task_append_domain_dexp();
        } else if (coneDomain2.key == QConeKey.InDPowCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for dual power cone").toString());
            }
            l = this.task_append_domain_dpow(n12, coneDomain2.alpha);
        } else if (coneDomain2.key == QConeKey.InPGeoMeanCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for primal geometric mean cone").toString());
            }
            l = this.task_append_domain_pgeomean(n12);
        } else if (coneDomain2.key == QConeKey.InDGeoMeanCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for dual geometric mean cone").toString());
            }
            l = this.task_append_domain_dgeomean(n12);
        } else if (coneDomain2.key == QConeKey.Positive) {
            l = this.task_append_domain_rpos(n12);
        } else if (coneDomain2.key == QConeKey.InSVecPSDCone) {
            var15_16 = (int)((Tools.sqrt(1 + 8 * n12) - 1.0) / 2.0);
            if (var15_16 * (var15_16 + 1) / 2 != n12) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for vector positive semidefinite cone").toString());
            }
            l = this.task_append_domain_svec_psd(n12);
        } else if (coneDomain2.key == QConeKey.Negative) {
            l = this.task_append_domain_rneg(n12);
        } else if (coneDomain2.key == QConeKey.Unbounded) {
            l = this.task_append_domain_r(n12);
        } else if (coneDomain2.key == QConeKey.Zero) {
            l = this.task_append_domain_rzero(n12);
        } else if (coneDomain2.key == QConeKey.InPSDCone) {
            if (n12 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for positive semidefinite cone").toString());
            }
            var15_16 = (int)((Tools.sqrt(1 + 8 * n12) - 1.0) / 2.0);
            if (var15_16 * (var15_16 + 1) / 2 != n12) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n12).a(") for positive semidefinite cone").toString());
            }
            l = this.task_append_domain_svec_psd(n12);
        } else {
            throw new UnexpectedError("Internal error: Invalid cone type");
        }
        int[] nArray3 = new int[n16 * n12];
        int[] nArray4 = new int[n16];
        int n18 = this.conicvar_alloc(l, n12, n16, nArray4, nArray3);
        this.task_var_putboundlist_fr(nArray3);
        if (coneDomain2.int_flag) {
            this.task_var_putintlist(nArray3);
        }
        int[] nArray5 = nArray3;
        if (n11 < nArray2.length - 1) {
            nArray5 = new int[nArray3.length];
            int n19 = 0;
            int n20 = 0;
            n8 = n14;
            for (n7 = n20; n7 < n8; ++n7) {
                n6 = 0;
                n5 = n13;
                for (n4 = n6; n4 < n5; ++n4) {
                    n3 = 0;
                    n2 = n12;
                    for (n = n3; n < n2; ++n) {
                        nArray5[n19] = nArray3[(n7 * n12 + n) * n13 + n4];
                        ++n19;
                    }
                }
            }
        }
        ConicVariable conicVariable = new ConicVariable(this, string, n18, nArray2, nArray3);
        this.vars[n18] = conicVariable;
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(string).a("[");
            if (n10 > 0) {
                stringBuffer.a("%0");
                n8 = 1;
                n7 = n10;
                for (n6 = n8; n6 < n7; ++n6) {
                    stringBuffer.a(",%").a(n6);
                }
            }
            stringBuffer.a("]");
            if (coneDomain2.indexnames != null) {
                this.task_format_var_names(nArray5, stringBuffer.toString(), nArray2, null, coneDomain2.indexnames);
            } else {
                this.task_format_var_names(nArray5, stringBuffer.toString(), nArray2, null, null);
            }
            int[] nArray6 = new int[n16];
            this.acc_block_map.get(this.var_block_acc_id[n18], nArray6, 0);
            int[] nArray7 = new int[nArray2.length - 1];
            n6 = 0;
            n5 = n11;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray7[n4] = nArray2[n4];
            }
            n6 = n11 + 1;
            n5 = n10;
            for (n4 = n6; n4 < n5; ++n4) {
                nArray7[n4 - 1] = nArray2[n4];
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.a(string).a("[");
            if (n10 - 1 > 0) {
                stringBuffer2.a("%0");
                n5 = 1;
                n4 = n10;
                for (n3 = n5; n3 < n4; ++n3) {
                    stringBuffer2.a(",%").a(n3);
                }
            }
            stringBuffer2.a("]");
            if (coneDomain2.indexnames != null) {
                String[][] stringArray = new String[n10 - 1][];
                n4 = 0;
                n3 = n11;
                for (n2 = n4; n2 < n3; ++n2) {
                    stringArray[n2] = coneDomain2.indexnames[n2];
                }
                n4 = n11 + 1;
                n3 = n10;
                for (n2 = n4; n2 < n3; ++n2) {
                    stringArray[n2 - 1] = coneDomain2.indexnames[n2];
                }
                n4 = 0;
                n3 = 0;
                n2 = n16;
                n = n3 < n2 ? n2 - n3 : 0;
                long[] lArray = new long[n];
                int n21 = n3;
                int n22 = 0;
                while (n22 < n) {
                    lArray[n4] = nArray6[n21];
                    ++n4;
                    ++n22;
                    ++n21;
                }
                this.task_format_acc_names(lArray, stringBuffer2.toString(), nArray7, stringArray);
            } else {
                n5 = 0;
                n4 = 0;
                n3 = n16;
                n2 = n4 < n3 ? n3 - n4 : 0;
                long[] lArray = new long[n2];
                int n23 = n4;
                int n24 = 0;
                while (n24 < n2) {
                    lArray[n5] = nArray6[n23];
                    ++n5;
                    ++n24;
                    ++n23;
                }
                this.task_format_acc_names(lArray, stringBuffer2.toString(), nArray7, null);
            }
            this.var_map.setItem(string, n18);
        }
        return conicVariable;
    }

    private Variable variable_(String string, int[] nArray, LinearDomain linearDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray2;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        StringBuffer stringBuffer;
        Object object;
        int n12;
        int n13;
        int n14;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        LinearDomain linearDomain2 = linearDomain.finalize_and_validate(nArray);
        int[] nArray3 = linearDomain2.shape;
        int n15 = nArray3.length;
        int[] nArray4 = new int[n15];
        if (n15 > 0) {
            nArray4[n15 - 1] = 1;
            n14 = 1;
            n13 = n15;
            for (n12 = n14; n12 < n13; ++n12) {
                nArray4[n15 - n12 - 1] = nArray4[n15 - n12] * nArray3[n15 - n12];
            }
        }
        n14 = 1;
        n13 = 0;
        n12 = nArray3.length;
        for (int i = n13; i < n12; ++i) {
            n14 *= nArray3[i];
        }
        int[] nArray5 = null;
        long[] lArray = null;
        Object object2 = null;
        Object var12_15 = null;
        Object var13_16 = null;
        StringBuffer stringBuffer2 = null;
        if (string.length() > 0 && linearDomain2.indexnames != null) {
            object = new StringBuffer();
            stringBuffer = new StringBuffer();
            n11 = 0;
            long l = 0L;
            long l2 = 0L;
            if (linearDomain2.indexnames.length != n15) {
                throw new DomainError("Invalid index name definition");
            }
            n10 = 0;
            n9 = linearDomain2.indexnames.length;
            for (n8 = n10; n8 < n9; ++n8) {
                if (linearDomain2.indexnames[n8] == null) continue;
                if (nArray3[n8] != linearDomain2.indexnames[n8].length) {
                    throw new DomainError("Invalid index name definition");
                }
                l2 += (long)nArray3[n8];
            }
            lArray = new long[(int)(l2 + 1L)];
            n10 = 0;
            n9 = 0;
            n8 = n15;
            n7 = n9 < n8 ? n8 - n9 : 0;
            nArray2 = new int[n7];
            n6 = n9;
            n5 = 0;
            while (n5 < n7) {
                nArray2[n10] = -1;
                ++n10;
                ++n5;
                ++n6;
            }
            nArray5 = nArray2;
            n5 = 0;
            n4 = linearDomain2.indexnames.length;
            for (n3 = n5; n3 < n4; ++n3) {
                if (linearDomain2.indexnames[n3] == null) continue;
                nArray5[n3] = n11;
                n2 = 0;
                int n16 = nArray3[n3];
                for (int i = n2; i < n16; ++i) {
                    ((StringBuffer)object).a(linearDomain2.indexnames[n3][i]);
                    lArray[++n11] = l += (long)linearDomain2.indexnames[n3][i].length();
                }
            }
            object2 = object;
            stringBuffer2 = stringBuffer;
        }
        object = null;
        stringBuffer = null;
        if (linearDomain2.empty) {
            object = new long[0];
        } else if (linearDomain2.sparsity != null) {
            if (linearDomain2.sparsity[0].length != n15) {
                throw new SparseFormatError("Sparsity pattern is not correct");
            }
            n11 = linearDomain2.sparsity.length;
            object = new long[n11];
            boolean bl = false;
            int[][] nArray6 = linearDomain2.sparsity;
            int n17 = 0;
            int n18 = n11;
            for (n10 = n17; n10 < n18; ++n10) {
                n9 = 0;
                n8 = nArray6[0].length;
                for (n7 = n9; n7 < n8; ++n7) {
                    bl = bl || nArray6[n10][n7] < 0 || nArray6[n10][n7] >= nArray3[n7];
                }
                if (bl) continue;
                long l = 0L;
                n7 = 0;
                int n19 = nArray6[0].length;
                for (n6 = n7; n6 < n19; ++n6) {
                    l += (long)(nArray4[n6] * nArray6[n10][n6]);
                }
                object[n10] = l;
            }
            if (bl) {
                throw new SparseFormatError("Sparsity pattern is out of bounds");
            }
            int[][] nArray7 = linearDomain2.sparsity;
            n = 0;
            n17 = 0;
            n18 = n15;
            for (n10 = n17; n10 < n18; ++n10) {
                if (n >= nArray3[n10]) continue;
                n = nArray3[n10];
            }
            int[] nArray8 = new int[n11];
            n18 = 0;
            n10 = n11;
            for (n9 = n18; n9 < n10; ++n9) {
                nArray8[n9] = n9;
            }
            int[] nArray9 = new int[n11];
            int[] nArray10 = new int[n + 1];
            n9 = 0;
            n8 = n15;
            for (n7 = n9; n7 < n8; ++n7) {
                int n20 = n15 - n7 - 1;
                n6 = 0;
                n5 = nArray3[n20] + 1;
                for (n4 = n6; n4 < n5; ++n4) {
                    nArray10[n4] = 0;
                }
                n6 = 0;
                n5 = n11;
                for (n4 = n6; n4 < n5; ++n4) {
                    int n21 = nArray7[n4][n20] + 1;
                    nArray10[n21] = nArray10[n21] + 1;
                }
                n6 = 0;
                n5 = nArray3[n20];
                for (n4 = n6; n4 < n5; ++n4) {
                    int n22 = n4 + 1;
                    nArray10[n22] = nArray10[n22] + nArray10[n4];
                }
                n6 = 0;
                n5 = n11;
                for (n4 = n6; n4 < n5; ++n4) {
                    nArray9[nArray10[nArray7[n3][n20]]] = n3 = nArray8[n4];
                    int n23 = nArray7[n3][n20];
                    nArray10[n23] = nArray10[n23] + 1;
                }
                nArray2 = nArray8;
                nArray8 = nArray9;
                nArray9 = nArray2;
            }
            n9 = 0;
            n8 = n11;
            for (n7 = n9; n7 < n8; ++n7) {
                int n24 = nArray8[n7];
                long l = 0L;
                n4 = 0;
                n3 = n15;
                for (n2 = n4; n2 < n3; ++n2) {
                    l += (long)(nArray4[n2] * nArray7[n24][n2]);
                }
                object[n7] = l;
            }
        }
        n11 = object != null ? ((Object)object).length : n14;
        double[] dArray = new double[n11];
        if (linearDomain2.bnd != null) {
            if (linearDomain2.bnd.length == 1) {
                n = 0;
                int n25 = n11;
                for (int i = n; i < n25; ++i) {
                    dArray[i] = linearDomain2.bnd[0];
                }
            } else if (linearDomain2.bnd.length == n11) {
                Tools.arraycopy(linearDomain2.bnd, 0, dArray, 0, n11);
            } else {
                throw new DimensionError("Invalid right hand side shape in domain");
            }
        }
        int[] nArray11 = new int[n11];
        int n26 = this.linearvar_alloc(n11, nArray11);
        if (linearDomain2.key == RelationKey.IsFree) {
            this.task_var_putboundlist_fr(nArray11);
        }
        if (linearDomain2.key == RelationKey.LessThan) {
            this.task_var_putboundlist_up(nArray11, dArray);
        } else if (linearDomain2.key == RelationKey.GreaterThan) {
            this.task_var_putboundlist_lo(nArray11, dArray);
        } else if (linearDomain2.key == RelationKey.EqualsTo) {
            this.task_var_putboundlist_fx(nArray11, dArray);
        }
        LinearVariable linearVariable = new LinearVariable(this, string, n26, nArray3, (long[])object, nArray11);
        this.vars[n26] = linearVariable;
        if (string.length() > 0) {
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.a(string).a("[");
            if (n15 > 0) {
                stringBuffer3.a("%0");
                n9 = 1;
                n8 = n15;
                for (n7 = n9; n7 < n8; ++n7) {
                    stringBuffer3.a(",%").a(n7);
                }
            }
            stringBuffer3.a("]");
            if (linearDomain2.indexnames != null) {
                this.task_format_var_names(nArray11, stringBuffer3.toString(), nArray3, (long[])object, linearDomain2.indexnames);
            } else {
                this.task_format_var_names(nArray11, stringBuffer3.toString(), nArray3, (long[])object, null);
            }
            this.var_map.setItem(string, n26);
        }
        if (linearDomain2.cardinal_flag) {
            this.task_var_putintlist(nArray11);
        }
        return linearVariable;
    }

    private Variable variable_(String string, int[] nArray, PSDDomain pSDDomain) {
        int n;
        int n2;
        if (string.length() > 0 && this.hasVariable(string)) {
            throw new NameError(new StringBuffer().a("Duplicate variable name '").a(string).a("'").toString());
        }
        PSDDomain pSDDomain2 = pSDDomain.finalize_and_validate(nArray);
        int[] nArray2 = pSDDomain2.shape;
        int n3 = pSDDomain2.conedim1;
        int n4 = pSDDomain2.conedim2;
        int n5 = nArray2.length;
        int n6 = nArray2[n3];
        if (n3 > n4) {
            n2 = n3;
            n3 = n4;
            n4 = n2;
        }
        if (n3 == n4 || n3 < 0 || n4 >= n5) {
            throw new DimensionError("Invalid cone order dimensions for semidefinite variables");
        }
        if (nArray2[n3] != nArray2[n4]) {
            throw new DimensionError("Mismatching shape in cone order dimensions");
        }
        n2 = 1;
        int n7 = 0;
        int n8 = n3;
        for (n = n7; n < n8; ++n) {
            n2 *= nArray2[n];
        }
        n7 = n3 + 1;
        n8 = n4;
        for (n = n7; n < n8; ++n) {
            n2 *= nArray2[n];
        }
        n7 = n4 + 1;
        n8 = n5;
        for (n = n7; n < n8; ++n) {
            n2 *= nArray2[n];
        }
        n7 = n2 * n6 * (n6 + 1) / 2;
        long[] lArray = new long[n7];
        int[] nArray3 = new int[n2];
        int n9 = this.barvar_alloc(n6, n2, nArray3, lArray);
        PSDVariable pSDVariable = new PSDVariable(this, string, n9, nArray2, pSDDomain2.conedim1, pSDDomain2.conedim2, nArray3, lArray);
        if (string.length() > 0) {
            int n10;
            int n11;
            int[] nArray4 = new int[n5 - 2];
            int n12 = n3 < n4 ? n3 : n4;
            int n13 = n3 < n4 ? n4 : n3;
            int n14 = 0;
            int n15 = n12;
            for (n11 = n14; n11 < n15; ++n11) {
                nArray4[n11] = nArray2[n11];
            }
            n14 = n12 + 1;
            n15 = n13;
            for (n11 = n14; n11 < n15; ++n11) {
                nArray4[n11 - 1] = nArray2[n11];
            }
            n14 = n13 + 1;
            n15 = n5;
            for (n11 = n14; n11 < n15; ++n11) {
                nArray4[n11 - 2] = nArray2[n11];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(string).a("[");
            if (n5 - 2 > 0) {
                stringBuffer.a("%0");
                n15 = 1;
                n11 = n5 - 2;
                for (n10 = n15; n10 < n11; ++n10) {
                    stringBuffer.a(",%").a(n10);
                }
            }
            stringBuffer.a("]");
            if (pSDDomain2.indexnames != null) {
                int n16;
                String[][] stringArray = new String[n5 - 2][];
                n11 = 0;
                n10 = n12;
                for (n16 = n11; n16 < n10; ++n16) {
                    stringArray[n16] = pSDDomain2.indexnames[n16];
                }
                n11 = n12 + 1;
                n10 = n13;
                for (n16 = n11; n16 < n10; ++n16) {
                    stringArray[n16 - 1] = pSDDomain2.indexnames[n16];
                }
                n11 = n13 + 1;
                n10 = n5;
                for (n16 = n11; n16 < n10; ++n16) {
                    stringArray[n16 - 2] = pSDDomain2.indexnames[n16];
                }
                this.task_format_barvar_names(nArray3, stringBuffer.toString(), nArray4, stringArray);
            } else {
                this.task_format_barvar_names(nArray3, stringBuffer.toString(), nArray4, null);
            }
        }
        this.barvars[n9] = pSDVariable;
        if (string.length() > 0) {
            this.var_map.setItem(string, -(n9 + 1));
        }
        return pSDVariable;
    }

    private void putfrows(int[] nArray, int n, WorkStack workStack, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int[] nArray2 = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = n2;
        for (int i = n16; i < n17; ++i) {
            int n18 = nArray2[n4 + i];
            int n19 = nArray2[n4 + i + 1];
            n12 = n18;
            while (n12 < n19 && lArray[n5 + n12] < 0L) {
                n11 = this.barvar_block_elm_barj[(int)(-(lArray[n5 + n12] + 1L))];
                n10 = n12++;
                while (n12 < n19 && lArray[n5 + n12] < 0L && n11 == this.barvar_block_elm_barj[(int)(-(lArray[n5 + n12] + 1L))]) {
                    ++n12;
                }
                ++n14;
            }
            n15 += n12 - n18;
            while (n12 < n19 && lArray[n5 + n12] == 0L) {
                ++n12;
            }
            n13 += n19 - n12;
        }
        if (n2 > nArray.length - n) {
            throw new UnexpectedError("Internal: Mismatching sizes");
        }
        n16 = n2;
        int[] nArray3 = new int[n16 + 1];
        int[] nArray4 = new int[n13];
        double[] dArray2 = new double[n13];
        double[] dArray3 = new double[n2];
        n12 = 0;
        n11 = 0;
        n10 = n2;
        for (n9 = n11; n9 < n10; ++n9) {
            int n20 = 0;
            n8 = nArray2[n4 + n9];
            n7 = nArray2[n4 + n9 + 1];
            for (int i = n8; i < n7; ++i) {
                if (lArray[n5 + i] == 0L) {
                    int n21 = n9;
                    dArray3[n21] = dArray3[n21] + dArray[n6 + i];
                    continue;
                }
                if (lArray[n5 + i] <= 0L) continue;
                nArray4[n12 + n20] = (int)lArray[n5 + i];
                dArray2[n12 + n20] = dArray[n6 + i];
                ++n20;
            }
            nArray3[n9 + 1] = nArray3[n9] + n20;
            n12 += n20;
        }
        n12 = 0;
        n11 = 0;
        n10 = n2;
        n9 = n11 < n10 ? n10 - n11 : 0;
        long[] lArray2 = new long[n9];
        n8 = n11;
        n7 = 0;
        while (n7 < n9) {
            lArray2[n12] = nArray[n8 + n];
            ++n12;
            ++n7;
            ++n8;
        }
        this.task_putafeflist(lArray2, nArray3, nArray4, dArray2, dArray3);
        if (n14 > 0) {
            int[] nArray5 = nArray;
            int[] nArray6 = new int[n16 + 1];
            int[] nArray7 = new int[n14];
            int[] nArray8 = new int[n14];
            long[] lArray3 = new long[n14];
            int n22 = 0;
            int n23 = 0;
            int n24 = n15;
            int n25 = n23 < n24 ? n24 - n23 : 0;
            int[] nArray9 = new int[n25];
            int n26 = n23;
            int n27 = 0;
            while (n27 < n25) {
                nArray9[n22] = -1;
                ++n22;
                ++n27;
                ++n26;
            }
            int[] nArray10 = nArray9;
            int[] nArray11 = new int[n15];
            double[] dArray4 = new double[n15];
            int n28 = 0;
            int n29 = 0;
            int n30 = 0;
            int n31 = n16;
            for (int i = n30; i < n31; ++i) {
                int n32 = nArray2[n4 + i];
                int n33 = nArray2[n4 + i + 1];
                while (n32 < n33 && lArray[n5 + n32] < 0L) {
                    int n34 = n32;
                    int n35 = this.barvar_block_elm_barj[(int)(-(lArray[n5 + n32] + 1L))];
                    while (n32 < n33 && lArray[n5 + n32] < 0L && this.barvar_block_elm_barj[(int)(-(lArray[n5 + n32] + 1L))] == n35) {
                        nArray10[n29] = this.barvar_block_elm_i[(int)(-(lArray[n5 + n32] + 1L))];
                        nArray11[n29] = this.barvar_block_elm_j[(int)(-(lArray[n5 + n32] + 1L))];
                        dArray4[n29] = nArray10[n29] == nArray11[n29] ? dArray[n6 + n32] : 0.5 * dArray[n6 + n32];
                        ++n29;
                        ++n32;
                    }
                    nArray7[n28] = n35;
                    nArray8[n28] = this.barvar_dim[n35];
                    lArray3[n28] = n32 - n34;
                    ++n28;
                }
                n32 = n33;
                nArray6[i + 1] = n28;
            }
            long[] lArray4 = this.task_appendsymmatlist(nArray8, lArray3, nArray10, nArray11, dArray4);
            this.task_putafebarfrowlist(nArray5, nArray6, nArray7, lArray4);
        }
    }

    private void putarows(int[] nArray, WorkStack workStack, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray2 = workStack.i32;
        long[] lArray = workStack.i64;
        double[] dArray = workStack.f64;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = n;
        for (int i = n13; i < n14; ++i) {
            int n15 = nArray2[n3 + i];
            n9 = nArray2[n3 + i + 1];
            n8 = n15;
            while (n8 < n9 && lArray[n4 + n8] < 0L) {
                n7 = this.barvar_block_elm_barj[(int)(-(lArray[n4 + n8] + 1L))];
                n6 = n8++;
                while (n8 < n9 && lArray[n4 + n8] < 0L && n7 == this.barvar_block_elm_barj[(int)(-(lArray[n4 + n8] + 1L))]) {
                    ++n8;
                }
                ++n11;
            }
            n12 += n8 - n15;
            n10 += n9 - n8;
        }
        n13 = nArray.length;
        long[] lArray2 = new long[n13 + 1];
        int[] nArray3 = new int[n10 += n];
        double[] dArray2 = new double[n10];
        n9 = 0;
        n8 = 0;
        n7 = n;
        for (n6 = n8; n6 < n7; ++n6) {
            int n16 = 0;
            int n17 = nArray2[n3 + n6];
            int n18 = nArray2[n3 + n6 + 1];
            for (int i = n17; i < n18; ++i) {
                if (lArray[n4 + i] < 0L) continue;
                nArray3[n9 + n16] = (int)lArray[n4 + i];
                dArray2[n9 + n16] = dArray[n5 + i];
                ++n16;
            }
            lArray2[n6 + 1] = lArray2[n6] + (long)n16;
            n9 += n16;
        }
        this.task_putarowlist(nArray, lArray2, nArray3, dArray2);
        if (n11 > 0) {
            int[] nArray4 = nArray;
            long[] lArray3 = new long[n13 + 1];
            int[] nArray5 = new int[n11];
            int[] nArray6 = new int[n11];
            long[] lArray4 = new long[n11];
            int[] nArray7 = new int[n12];
            int[] nArray8 = new int[n12];
            double[] dArray3 = new double[n12];
            int n19 = 0;
            int n20 = 0;
            int n21 = 0;
            int n22 = n13;
            for (int i = n21; i < n22; ++i) {
                int n23 = nArray2[n3 + i];
                int n24 = nArray2[n3 + i + 1];
                while (n23 < n24 && lArray[n4 + n23] < 0L) {
                    int n25 = n23;
                    int n26 = this.barvar_block_elm_barj[(int)(-(lArray[n4 + n23] + 1L))];
                    while (n23 < n24 && lArray[n4 + n23] < 0L && this.barvar_block_elm_barj[(int)(-(lArray[n4 + n23] + 1L))] == n26) {
                        nArray7[n20] = this.barvar_block_elm_i[(int)(-(lArray[n4 + n23] + 1L))];
                        nArray8[n20] = this.barvar_block_elm_j[(int)(-(lArray[n4 + n23] + 1L))];
                        dArray3[n20] = nArray7[n20] == nArray8[n20] ? dArray[n5 + n23] : 0.5 * dArray[n5 + n23];
                        ++n20;
                        ++n23;
                    }
                    nArray5[n19] = n26;
                    nArray6[n19] = this.barvar_dim[n26];
                    lArray4[n19] = n23 - n25;
                    ++n19;
                }
                n23 = n24;
                lArray3[i + 1] = n19;
            }
            long[] lArray5 = this.task_appendsymmatlist(nArray6, lArray4, nArray7, nArray8, dArray3);
            this.task_putbararowlist(nArray4, lArray3, nArray5, lArray5);
        }
    }

    private RangedConstraint constraint_(String string, Expression expression, RangeDomain rangeDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        if (rangeDomain.cardinal_flag) {
            throw new DomainError("Integer domain not allowed in a constraint");
        }
        ExprDense exprDense = new ExprDense(new ExprOptimizeCode(new ExprCompress(expression)));
        exprDense.eval(this.rs, this.ws, this.xs);
        this.rs.pop_expr();
        int[] nArray = this.rs.i32;
        long[] lArray = this.rs.i64;
        double[] dArray = this.rs.f64;
        int n9 = this.rs.nd;
        int n10 = this.rs.shape_base;
        int n11 = this.rs.nelem;
        int n12 = this.rs.nnz;
        int n13 = this.rs.ncodeatom;
        boolean bl = this.rs.hassp;
        int n14 = this.rs.ptr_base;
        int n15 = this.rs.nidxs_base;
        int n16 = this.rs.cof_base;
        int n17 = this.rs.codeptr_base;
        int n18 = this.rs.code_base;
        int n19 = this.rs.cconst_base;
        int n20 = 0;
        int n21 = 0;
        int n22 = n9;
        int n23 = n21 < n22 ? n22 - n21 : 0;
        int[] nArray2 = new int[n23];
        int n24 = n21;
        int n25 = 0;
        while (n25 < n23) {
            nArray2[n20] = nArray[n10 + n24];
            ++n20;
            ++n25;
            ++n24;
        }
        int[] nArray3 = nArray2;
        RangeDomain rangeDomain2 = rangeDomain.finalize_and_validate(nArray3);
        if (rangeDomain2.shape != null) {
            if (rangeDomain2.shape.length != n9) {
                throw new DimensionError("Mismatching expression and domain");
            }
            n8 = 0;
            n7 = n9;
            for (n6 = n8; n6 < n7; ++n6) {
                if (rangeDomain2.shape[n6] == nArray[n10 + n6]) continue;
                throw new DimensionError("Mismatching expression and domain");
            }
        }
        n8 = 1;
        n7 = 0;
        n6 = n9;
        for (int i = n7; i < n6; ++i) {
            n8 *= nArray[n10 + i];
        }
        int[] nArray4 = new int[n8];
        n6 = this.con_allocate(nArray4);
        this.putarows(nArray4, this.rs, n11, n12, n14, n15, n16);
        this.xs.clear();
        double[] dArray2 = new double[n8];
        double[] dArray3 = new double[n8];
        double[] dArray4 = rangeDomain2.lb;
        double[] dArray5 = rangeDomain2.ub;
        boolean bl2 = rangeDomain2.empty;
        boolean bl3 = rangeDomain2.scalable;
        int[][] nArray5 = rangeDomain2.sparsity;
        if (bl3) {
            int n26 = 0;
            n5 = n8;
            for (n4 = n26; n4 < n5; ++n4) {
                dArray2[n4] = dArray4[0];
                dArray3[n4] = dArray5[0];
            }
        } else if (!bl2) {
            if (nArray5 != null) {
                int[] nArray6 = new int[n9];
                nArray6[n9 - 1] = 1;
                n5 = 1;
                n4 = n9;
                for (n3 = n5; n3 < n4; ++n3) {
                    nArray6[n9 - n3 - 1] = nArray6[n9 - n3] * nArray[n10 + n9 - n3];
                }
                n5 = 0;
                n4 = dArray4.length;
                for (n3 = n5; n3 < n4; ++n3) {
                    int n27 = 0;
                    n2 = 0;
                    n = n9;
                    for (int i = n2; i < n; ++i) {
                        n27 += nArray6[i] * nArray5[n3][i];
                    }
                    dArray2[n27] = dArray4[n3];
                    dArray3[n27] = dArray5[n3];
                }
            } else {
                int n28 = 0;
                n5 = n8;
                for (n4 = n28; n4 < n5; ++n4) {
                    dArray2[n4] = dArray4[n4];
                    dArray3[n4] = dArray5[n4];
                }
            }
        }
        this.task_con_putboundlist_ra(nArray4, dArray2, dArray3);
        if (n13 > 0) {
            this.con_blocks.replace_row_code(this.rs, nArray4, n14, n15, n17, n18, n19);
        }
        if (string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(string).a("[");
            if (nArray3.length > 0) {
                stringBuffer.a("%0");
            }
            n5 = 1;
            n4 = nArray3.length;
            for (n3 = n5; n3 < n4; ++n3) {
                stringBuffer.a(",%").a(n3);
            }
            stringBuffer.a("]");
            if (rangeDomain2.indexnames != null) {
                this.task_format_con_names(nArray4, stringBuffer.toString(), nArray3, null, rangeDomain2.indexnames);
            } else {
                this.task_format_con_names(nArray4, stringBuffer.toString(), nArray3, null, null);
            }
        }
        int n29 = 0;
        n5 = 0;
        n4 = n9;
        n3 = n5 < n4 ? n4 - n5 : 0;
        int[] nArray7 = new int[n3];
        n2 = n5;
        n = 0;
        while (n < n3) {
            nArray7[n29] = nArray[n10 + n2];
            ++n29;
            ++n;
            ++n2;
        }
        RangedConstraint rangedConstraint = new RangedConstraint(this, string, nArray7, nArray4, n6);
        this.cons[n6] = rangedConstraint;
        if (string.length() > 0) {
            this.con_map.setItem(string, n6);
        }
        return rangedConstraint;
    }

    private Constraint constraint_(String string, Expression expression, PSDDomain pSDDomain) {
        long l;
        long l2;
        long l3;
        int n;
        long l4;
        long l5;
        int n2;
        long l6;
        int n3;
        long l7;
        long l8;
        long l9;
        long l10;
        long l11;
        int n4;
        int n5;
        int[] nArray = expression.getShape();
        PSDDomain pSDDomain2 = pSDDomain.finalize_and_validate(nArray);
        boolean bl = pSDDomain2.conedim1 < pSDDomain2.conedim2;
        int n6 = pSDDomain2.conedim1 < pSDDomain2.conedim2 ? pSDDomain2.conedim2 : pSDDomain2.conedim1;
        int n7 = pSDDomain2.conedim1 < pSDDomain2.conedim2 ? pSDDomain2.conedim1 : pSDDomain2.conedim2;
        ExprDenseTril exprDenseTril = new ExprDenseTril(n7, n6, new ExprOptimizeCode(new ExprCompress(new ExprScaleVecPSD(n7, n6, new ExprDenseTril(n7, n6, pSDDomain2.key == PSDKey.IsSymPSD ? new ExprSymmetrize(n7, n6, expression) : expression)))));
        exprDenseTril.eval(this.rs, this.ws, this.xs);
        int[] nArray2 = this.rs.i32;
        long[] lArray = this.rs.i64;
        double[] dArray = this.rs.f64;
        int n8 = this.rs.nd;
        int n9 = this.rs.nelem;
        int n10 = this.rs.nnz;
        boolean bl2 = this.rs.hassp;
        int n11 = this.rs.ncodeatom;
        int n12 = this.rs.shape_base;
        int n13 = this.rs.ptr_base;
        int n14 = this.rs.nidxs_base;
        int n15 = this.rs.sp_base;
        int n16 = this.rs.cof_base;
        int n17 = this.rs.codeptr_base;
        int n18 = this.rs.code_base;
        int n19 = this.rs.cconst_base;
        int n20 = nArray[n6];
        int n21 = n20 * (n20 + 1) / 2;
        int n22 = 1;
        int n23 = 0;
        int n24 = n8;
        for (n5 = n23; n5 < n24; ++n5) {
            if (n5 == n7 || n5 == n6) continue;
            n22 *= nArray[n5];
        }
        long l12 = this.task_append_domain_svec_psd(n21);
        n5 = n21 * n22;
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n22];
        int[] nArray5 = new int[n5];
        double[] dArray2 = new double[n5];
        int n25 = this.acon_allocate(l12, n21, n22, dArray2, nArray3, nArray4);
        int[] nArray6 = new int[n5];
        this.acon_block_map.get(n25, nArray6, 0);
        long l13 = 1L;
        long l14 = nArray[n6];
        long l15 = 1L;
        long l16 = nArray[n7];
        long l17 = 1L;
        int n26 = 0;
        int n27 = n7;
        for (n4 = n26; n4 < n27; ++n4) {
            l17 *= (long)nArray[n4];
        }
        n26 = n7 + 1;
        n27 = n6;
        for (n4 = n26; n4 < n27; ++n4) {
            l15 *= (long)nArray[n4];
        }
        n26 = n6 + 1;
        n27 = n8;
        for (n4 = n26; n4 < n27; ++n4) {
            l13 *= (long)nArray[n4];
        }
        n26 = 0;
        double d = 1.0 / Tools.sqrt(2.0);
        int n28 = 0;
        long l18 = l17 * l15 * l13;
        for (long i = (long)n28; i < l18; ++i) {
            int n29 = 0;
            long l19 = l16;
            for (long j = (long)n29; j < l19; ++j) {
                ++n26;
                l11 = j + 1L;
                l10 = l14;
                for (l9 = l11; l9 < l10; ++l9) {
                    this.acon_elm_scale[nArray6[n26]] = d;
                    ++n26;
                }
            }
        }
        int[] nArray7 = new int[n9];
        int n30 = 0;
        if (bl) {
            n4 = 0;
            l8 = l17;
            for (l7 = (long)n4; l7 < l8; ++l7) {
                n3 = 0;
                long l20 = l14;
                for (l6 = (long)n3; l6 < l20; ++l6) {
                    n2 = 0;
                    l11 = l15;
                    for (l10 = (long)n2; l10 < l11; ++l10) {
                        l9 = l6;
                        long l21 = l16;
                        for (long i = l9; i < l21; ++i) {
                            int n31 = 0;
                            long l22 = l13;
                            for (long j = (long)n31; j < l22; ++j) {
                                long l23 = l7 * l15 * l13 + l10 * l13 + j;
                                long l24 = i * (i + 1L) / 2L + l6;
                                nArray7[(int)(l23 * (long)n21 + l24)] = nArray3[n30];
                                ++n30;
                            }
                        }
                    }
                }
            }
        } else {
            n4 = 0;
            l8 = l17;
            for (l7 = (long)n4; l7 < l8; ++l7) {
                n3 = 0;
                long l25 = l14;
                for (l6 = (long)n3; l6 < l25; ++l6) {
                    n2 = 0;
                    l11 = l15;
                    for (l10 = (long)n2; l10 < l11; ++l10) {
                        int n32 = 0;
                        l5 = l6 + 1L;
                        for (l4 = (long)n32; l4 < l5; ++l4) {
                            n = 0;
                            long l26 = l13;
                            for (l3 = (long)n; l3 < l26; ++l3) {
                                l2 = l7 * l15 * l13 + l10 * l13 + l3;
                                l = l4 * (2L * l16 - l4 - 1L) / 2L + l6;
                                nArray7[(int)(l2 * (long)n21 + l)] = nArray3[n30];
                                ++n30;
                            }
                        }
                    }
                }
            }
        }
        this.putfrows(nArray7, 0, this.rs, n9, n10, n13, n14, n16);
        if (n11 > 0) {
            this.afe_blocks.replace_row_code(this.rs, nArray7, n13, n14, n17, n18, n19);
        }
        nArray7 = new int[(int)((long)n22 * l16 * l16)];
        n30 = 0;
        if (bl) {
            n4 = 0;
            l8 = l17;
            for (l7 = (long)n4; l7 < l8; ++l7) {
                n3 = 0;
                long l27 = l16;
                for (l6 = (long)n3; l6 < l27; ++l6) {
                    n2 = 0;
                    l11 = l15;
                    for (l10 = (long)n2; l10 < l11; ++l10) {
                        int n33 = 0;
                        l5 = l14;
                        for (l4 = (long)n33; l4 < l5; ++l4) {
                            n = 0;
                            long l28 = l13;
                            for (l3 = (long)n; l3 < l28; ++l3) {
                                l2 = l7 * l15 * l13 + l10 * l13 + l3;
                                l = l6 >= l4 ? l4 * (2L * l16 - l4 - 1L) / 2L + l6 : l6 * (2L * l16 - l6 - 1L) / 2L + l4;
                                nArray7[n30] = nArray3[(int)(l2 * (long)n21 + l)];
                                ++n30;
                            }
                        }
                    }
                }
            }
        } else {
            n4 = 0;
            l8 = l17;
            for (l7 = (long)n4; l7 < l8; ++l7) {
                n3 = 0;
                long l29 = l16;
                for (l6 = (long)n3; l6 < l29; ++l6) {
                    n2 = 0;
                    l11 = l15;
                    for (l10 = (long)n2; l10 < l11; ++l10) {
                        int n34 = 0;
                        l5 = l14;
                        for (l4 = (long)n34; l4 < l5; ++l4) {
                            n = 0;
                            long l30 = l13;
                            for (l3 = (long)n; l3 < l30; ++l3) {
                                l2 = l7 * l15 * l13 + l10 * l13 + l3;
                                l = l6 >= l4 ? l4 * (2L * l16 - l4 - 1L) / 2L + l6 : l6 * (2L * l16 - l6 - 1L) / 2L + l4;
                                nArray7[n30] = nArray3[(int)(l2 * (long)n21 + l)];
                                ++n30;
                            }
                        }
                    }
                }
            }
        }
        if (string.length() > 0) {
            int n35;
            int[] nArray8 = new int[nArray.length - 2];
            n4 = 0;
            int n36 = n7;
            for (n35 = n4; n35 < n36; ++n35) {
                nArray8[n35] = nArray[n35];
            }
            n4 = n7 + 1;
            n36 = n6;
            for (n35 = n4; n35 < n36; ++n35) {
                nArray8[n35 - 1] = nArray[n35];
            }
            n4 = n6 + 1;
            n36 = n8;
            for (n35 = n4; n35 < n36; ++n35) {
                nArray8[n35 - 2] = nArray[n35];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(string).a("[");
            if (n8 > 2) {
                stringBuffer.a("%0");
                n36 = 1;
                n35 = n8 - 2;
                for (int i = n36; i < n35; ++i) {
                    stringBuffer.a(",%").a(i);
                }
            }
            stringBuffer.a("]");
            if (pSDDomain2.indexnames != null) {
                String[][] stringArray = pSDDomain2.indexnames;
                String[][] stringArray2 = new String[n8 - 2][];
                int n37 = 0;
                int n38 = n7;
                for (n3 = n37; n3 < n38; ++n3) {
                    stringArray2[n3] = stringArray[n3];
                }
                n37 = n7 + 1;
                n38 = n6;
                for (n3 = n37; n3 < n38; ++n3) {
                    stringArray2[n3 - 1] = stringArray[n3];
                }
                n37 = n6 + 1;
                n38 = n8;
                for (n3 = n37; n3 < n38; ++n3) {
                    stringArray2[n3 - 2] = stringArray[n3];
                }
                n37 = 0;
                n38 = 0;
                n3 = nArray4.length;
                int n39 = n38 < n3 ? n3 - n38 : 0;
                long[] lArray2 = new long[n39];
                int n40 = n38;
                int n41 = 0;
                while (n41 < n39) {
                    lArray2[n37] = nArray4[n40];
                    ++n37;
                    ++n41;
                    ++n40;
                }
                this.task_format_acc_names(lArray2, stringBuffer.toString(), nArray8, stringArray2);
            } else {
                n36 = 0;
                n35 = 0;
                int n42 = nArray4.length;
                int n43 = n35 < n42 ? n42 - n35 : 0;
                long[] lArray3 = new long[n43];
                int n44 = n35;
                int n45 = 0;
                while (n45 < n43) {
                    lArray3[n36] = nArray4[n44];
                    ++n36;
                    ++n45;
                    ++n44;
                }
                this.task_format_acc_names(lArray3, stringBuffer.toString(), nArray8, null);
            }
        }
        ConicConstraint conicConstraint = new ConicConstraint(this, string, null, nArray, n25, nArray7, null);
        this.acons[n25] = conicConstraint;
        if (string.length() > 0) {
            this.con_map.setItem(string, -(1 + n25));
        }
        return conicConstraint;
    }

    private Constraint constraint_(String string, Expression expression, ConeDomain coneDomain) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l;
        int n7;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        if (coneDomain.int_flag) {
            throw new DomainError("Integer domain not allowed in a constraint");
        }
        ExprDense exprDense = new ExprDense(new ExprOptimizeCode(new ExprCompress(expression)));
        exprDense.eval(this.rs, this.ws, this.xs);
        this.rs.pop_expr();
        int[] nArray = this.rs.i32;
        long[] lArray = this.rs.i64;
        double[] dArray = this.rs.f64;
        int n8 = this.rs.nd;
        int n9 = this.rs.shape_base;
        int n10 = this.rs.nelem;
        int n11 = this.rs.nnz;
        int n12 = this.rs.ncodeatom;
        boolean bl = this.rs.hassp;
        int n13 = this.rs.ptr_base;
        int n14 = this.rs.nidxs_base;
        int n15 = this.rs.cof_base;
        int n16 = this.rs.code_base;
        int n17 = this.rs.codeptr_base;
        int n18 = this.rs.cconst_base;
        int n19 = 0;
        int n20 = 0;
        int n21 = n8;
        int n22 = n20 < n21 ? n21 - n20 : 0;
        int[] nArray2 = new int[n22];
        int n23 = n20;
        int n24 = 0;
        while (n24 < n22) {
            nArray2[n19] = nArray[n9 + n23];
            ++n19;
            ++n24;
            ++n23;
        }
        int[] nArray3 = nArray2;
        ConeDomain coneDomain2 = coneDomain.finalize_and_validate(nArray3);
        int n25 = coneDomain2.axisIsSet() ? coneDomain2.getAxis() : n8 - 1;
        int n26 = nArray3[n25];
        int n27 = 1;
        int n28 = 1;
        int n29 = 1;
        int n30 = 0;
        int n31 = n8;
        for (n7 = n30; n7 < n31; ++n7) {
            n29 *= nArray3[n7];
        }
        n30 = 0;
        n31 = n25;
        for (n7 = n30; n7 < n31; ++n7) {
            n28 *= nArray3[n7];
        }
        n30 = n25 + 1;
        n31 = n8;
        for (n7 = n30; n7 < n31; ++n7) {
            n27 *= nArray3[n7];
        }
        n30 = n28 * n27;
        if (coneDomain2.key == QConeKey.InQCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for quadratic cone").toString());
            }
            l = this.task_append_domain_quad(n26);
        } else if (coneDomain2.key == QConeKey.InRotatedQCone) {
            if (n26 < 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for rotated quadratic cone").toString());
            }
            l = this.task_append_domain_rquad(n26);
        } else if (coneDomain2.key == QConeKey.InPExpCone) {
            if (n26 != 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for exponential cone").toString());
            }
            l = this.task_append_domain_pexp();
        } else if (coneDomain2.key == QConeKey.InPPowCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for power cone").toString());
            }
            if (coneDomain2.alpha.length < 2) {
                throw new DimensionError(new StringBuffer().a("Power cone requires at least two parameters").toString());
            }
            l = this.task_append_domain_ppow(n26, coneDomain2.alpha);
        } else if (coneDomain2.key == QConeKey.InDExpCone) {
            if (n26 != 3) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for dual exponential cone").toString());
            }
            l = this.task_append_domain_dexp();
        } else if (coneDomain2.key == QConeKey.InDPowCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for dual power cone").toString());
            }
            if (coneDomain2.alpha.length < 2) {
                throw new DimensionError(new StringBuffer().a("Power cone requires at least two parameters").toString());
            }
            l = this.task_append_domain_dpow(n26, coneDomain2.alpha);
        } else if (coneDomain2.key == QConeKey.InPGeoMeanCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for primal geometric mean cone").toString());
            }
            l = this.task_append_domain_pgeomean(n26);
        } else if (coneDomain2.key == QConeKey.InDGeoMeanCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for dual geometric mean cone").toString());
            }
            l = this.task_append_domain_dgeomean(n26);
        } else if (coneDomain2.key == QConeKey.InSVecPSDCone) {
            var36_38 = (int)((Tools.sqrt(1 + 8 * n26) - 1.0) / 2.0);
            if (var36_38 * (var36_38 + 1) / 2 != n26) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for vector positive semidefinite cone").toString());
            }
            l = this.task_append_domain_svec_psd(n26);
        } else if (coneDomain2.key == QConeKey.Positive) {
            l = this.task_append_domain_rpos(n26);
        } else if (coneDomain2.key == QConeKey.Negative) {
            l = this.task_append_domain_rneg(n26);
        } else if (coneDomain2.key == QConeKey.Unbounded) {
            l = this.task_append_domain_r(n26);
        } else if (coneDomain2.key == QConeKey.Zero) {
            l = this.task_append_domain_rzero(n26);
        } else if (coneDomain2.key == QConeKey.InPSDCone) {
            if (n26 < 2) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for positive semidefinite cone").toString());
            }
            var36_38 = (int)((Tools.sqrt(1 + 8 * n26) - 1.0) / 2.0);
            if (var36_38 * (var36_38 + 1) / 2 != n26) {
                throw new DimensionError(new StringBuffer().a("Invalid size (").a(n26).a(") for positive semidefinite cone").toString());
            }
            l = this.task_append_domain_svec_psd(n26);
        } else {
            throw new UnexpectedError("Internal error: Invalid cone type");
        }
        double[] dArray2 = new double[n29];
        int[] nArray4 = new int[n29];
        int[] nArray5 = new int[n30];
        int n32 = this.acon_allocate(l, n26, n30, dArray2, nArray4, nArray5);
        int[] nArray6 = new int[n29];
        int n33 = 0;
        double[] dArray3 = coneDomain2.domofs;
        int n34 = 0;
        int n35 = n28;
        for (n6 = n34; n6 < n35; ++n6) {
            n5 = 0;
            n4 = n27;
            for (int i = n5; i < n4; ++i) {
                n3 = 0;
                n2 = n26;
                for (n = n3; n < n2; ++n) {
                    nArray6[n6 * n27 * n26 + n * n27 + i] = n33++;
                }
            }
        }
        if (dArray3 != null) {
            n34 = 0;
            n35 = n29;
            for (n6 = n34; n6 < n35; ++n6) {
                dArray2[nArray6[n6]] = dArray3[n6];
            }
        }
        n33 = 0;
        int n36 = 0;
        n34 = n29;
        n35 = n36 < n34 ? n34 - n36 : 0;
        int[] nArray7 = new int[n35];
        n5 = n36;
        n4 = 0;
        while (n4 < n35) {
            nArray7[n33] = nArray4[nArray6[n5]];
            ++n33;
            ++n4;
            ++n5;
        }
        int[] nArray8 = nArray7;
        this.putfrows(nArray8, 0, this.rs, n10, n11, n13, n14, n15);
        if (n12 > 0) {
            this.afe_blocks.replace_row_code(this.rs, nArray8, n13, n14, n17, n16, n18);
        }
        if (string.length() > 0) {
            int n37;
            int[] nArray9 = new int[nArray3.length - 1];
            n3 = 0;
            n2 = n25;
            for (n = n3; n < n2; ++n) {
                nArray9[n] = nArray3[n];
            }
            n3 = n25 + 1;
            n2 = n8;
            for (n = n3; n < n2; ++n) {
                nArray9[n - 1] = nArray3[n];
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.a(string).a("[");
            if (n8 > 1) {
                stringBuffer.a("%0");
                n2 = 1;
                n = n8 - 1;
                for (n37 = n2; n37 < n; ++n37) {
                    stringBuffer.a(",%").a(n37);
                }
            }
            stringBuffer.a("]");
            if (coneDomain2.indexnames != null) {
                int n38;
                String[][] stringArray = coneDomain2.indexnames;
                String[][] stringArray2 = new String[n8 - 1][];
                n37 = 0;
                int n39 = n25;
                for (n38 = n37; n38 < n39; ++n38) {
                    stringArray2[n38] = stringArray[n38];
                }
                n37 = n25 + 1;
                n39 = n8;
                for (n38 = n37; n38 < n39; ++n38) {
                    stringArray2[n38 - 1] = stringArray[n38];
                }
                n37 = 0;
                n39 = 0;
                n38 = nArray5.length;
                int n40 = n39 < n38 ? n38 - n39 : 0;
                long[] lArray2 = new long[n40];
                int n41 = n39;
                int n42 = 0;
                while (n42 < n40) {
                    lArray2[n37] = nArray5[n41];
                    ++n37;
                    ++n42;
                    ++n41;
                }
                this.task_format_acc_names(lArray2, stringBuffer.toString(), nArray9, stringArray2);
            } else {
                n2 = 0;
                n = 0;
                n37 = nArray5.length;
                int n43 = n < n37 ? n37 - n : 0;
                long[] lArray3 = new long[n43];
                int n44 = n;
                int n45 = 0;
                while (n45 < n43) {
                    lArray3[n2] = nArray5[n44];
                    ++n2;
                    ++n45;
                    ++n44;
                }
                this.task_format_acc_names(lArray3, stringBuffer.toString(), nArray9, null);
            }
        }
        ConicConstraint conicConstraint = new ConicConstraint(this, string, coneDomain2, nArray3, n32, nArray4, coneDomain2.indexnames);
        this.acons[n32] = conicConstraint;
        if (string.length() > 0) {
            this.con_map.setItem(string, -(n32 + 1));
        }
        return conicConstraint;
    }

    private Constraint constraint_(String string, Expression expression, LinearDomain linearDomain) {
        double[] dArray;
        if (string.length() > 0 && this.hasConstraint(string)) {
            throw new NameError(new StringBuffer().a("Duplicate constraint name '").a(string).a("'").toString());
        }
        if (linearDomain.cardinal_flag) {
            throw new DomainError("Integer domain not allowed in a constraint");
        }
        ExprDense exprDense = new ExprDense(new ExprOptimizeCode(new ExprCompress(expression)));
        exprDense.eval(this.rs, this.ws, this.xs);
        this.rs.pop_expr();
        int[] nArray = this.rs.i32;
        long[] lArray = this.rs.i64;
        double[] dArray2 = this.rs.f64;
        int n = this.rs.nd;
        int n2 = this.rs.nelem;
        int n3 = this.rs.nnz;
        boolean bl = this.rs.hassp;
        int n4 = this.rs.ncodeatom;
        int n5 = this.rs.shape_base;
        int n6 = this.rs.ptr_base;
        int n7 = this.rs.nidxs_base;
        int n8 = this.rs.cof_base;
        int n9 = this.rs.codeptr_base;
        int n10 = this.rs.code_base;
        int n11 = this.rs.cconst_base;
        int n12 = 0;
        int n13 = 0;
        int n14 = n;
        int n15 = n13 < n14 ? n14 - n13 : 0;
        int[] nArray2 = new int[n15];
        int n16 = n13;
        int n17 = 0;
        while (n17 < n15) {
            nArray2[n12] = nArray[n5 + n16];
            ++n12;
            ++n17;
            ++n16;
        }
        int[] nArray3 = nArray2;
        LinearDomain linearDomain2 = linearDomain.finalize_and_validate(nArray3);
        long l = linearDomain2.domsize;
        String[][] stringArray = linearDomain2.indexnames;
        int[] nArray4 = new int[(int)l];
        int n18 = this.con_allocate(nArray4);
        this.putarows(nArray4, this.rs, n2, n3, n6, n7, n8);
        Object object = linearDomain2.sparsity;
        int n19 = linearDomain2.empty;
        double[] dArray3 = linearDomain2.bnd;
        int n20 = linearDomain2.scalable;
        if (dArray3 == null) {
            dArray = new double[nArray4.length];
        } else if (n20 != 0) {
            int n21 = 0;
            var39_42 = 0;
            var40_43 = nArray4.length;
            var41_44 = var39_42 < var40_43 ? var40_43 - var39_42 : 0;
            double[] dArray4 = new double[var41_44];
            var43_48 = var39_42;
            var44_49 = 0;
            while (var44_49 < var41_44) {
                dArray4[n21] = dArray3[0];
                ++n21;
                ++var44_49;
                ++var43_48;
            }
            dArray = dArray4;
        } else if (object != null) {
            int[] nArray5 = new int[n];
            nArray5[n - 1] = 1;
            var39_42 = 1;
            var40_43 = n;
            for (var41_44 = var39_42; var41_44 < var40_43; ++var41_44) {
                nArray5[n - var41_44 - 1] = nArray5[n - var41_44] * nArray3[n - var41_44];
            }
            dArray = new double[nArray4.length];
            var39_42 = 0;
            var40_43 = ((Object)object).length;
            for (var41_44 = var39_42; var41_44 < var40_43; ++var41_44) {
                int n22 = 0;
                var43_48 = 0;
                var44_49 = n;
                for (int i = var43_48; i < var44_49; ++i) {
                    n22 += nArray5[i] * object[var41_44][i];
                }
                dArray[n22] = dArray3[var41_44];
            }
        } else if (n19 != 0) {
            dArray = new double[nArray4.length];
        } else {
            int n23 = 0;
            var39_42 = 0;
            var40_43 = nArray4.length;
            var41_44 = var39_42 < var40_43 ? var40_43 - var39_42 : 0;
            double[] dArray5 = new double[var41_44];
            var43_48 = var39_42;
            var44_49 = 0;
            while (var44_49 < var41_44) {
                dArray5[n23] = dArray3[var43_48];
                ++n23;
                ++var44_49;
                ++var43_48;
            }
            dArray = dArray5;
        }
        if (linearDomain2.key == RelationKey.IsFree) {
            this.task_con_putboundlist_fr(nArray4);
        }
        if (linearDomain2.key == RelationKey.LessThan) {
            this.task_con_putboundlist_up(nArray4, dArray);
        } else if (linearDomain2.key == RelationKey.GreaterThan) {
            this.task_con_putboundlist_lo(nArray4, dArray);
        } else if (linearDomain2.key == RelationKey.EqualsTo) {
            this.task_con_putboundlist_fx(nArray4, dArray);
        }
        if (n4 > 0) {
            this.con_blocks.replace_row_code(this.rs, nArray4, n6, n7, n9, n10, n11);
        }
        if (string.length() > 0) {
            object = new StringBuffer();
            ((StringBuffer)object).a(string).a("[");
            if (nArray3.length > 0) {
                ((StringBuffer)object).a("%0");
            }
            n19 = 1;
            int n24 = nArray3.length;
            for (n20 = n19; n20 < n24; ++n20) {
                ((StringBuffer)object).a(",%").a(n20);
            }
            ((StringBuffer)object).a("]");
            if (linearDomain2.indexnames != null) {
                this.task_format_con_names(nArray4, ((StringBuffer)object).toString(), nArray3, null, linearDomain2.indexnames);
            } else {
                this.task_format_con_names(nArray4, ((StringBuffer)object).toString(), nArray3, null, null);
            }
        }
        this.cons[n18] = object = new LinearConstraint(this, string, n18, nArray3, nArray4, stringArray);
        if (string.length() > 0) {
            this.con_map.setItem(string, n18);
        }
        return object;
    }

    public static String getVersion() {
        return BaseModel.env_getversion();
    }

    public boolean hasParameter(String string) {
        return this.par_map.hasItem(string);
    }

    public boolean hasConstraint(String string) {
        return this.con_map.hasItem(string);
    }

    public boolean hasVariable(String string) {
        return this.var_map.hasItem(string);
    }

    public Parameter getParameter(String string) {
        return this.par_map.hasItem(string) ? this.parameters[this.par_map.getItem(string)] : null;
    }

    public Constraint getConstraint(int n) {
        ModelConstraint modelConstraint = n >= 0 ? this.cons[n] : this.acons[-(1 + n)];
        return modelConstraint;
    }

    public Constraint getConstraint(String string) {
        ModelConstraint modelConstraint = null;
        if (this.con_map.hasItem(string)) {
            int n = this.con_map.getItem(string);
            modelConstraint = n >= 0 ? this.cons[n] : this.acons[-(1 + n)];
        }
        return modelConstraint;
    }

    public Variable getVariable(int n) {
        return this.vars[n];
    }

    public Variable getVariable(String string) {
        if (this.var_map.hasItem(string)) {
            int n = this.var_map.getItem(string);
            if (n < 0) {
                return this.barvars[-(n + 1)];
            }
            return this.vars[n];
        }
        return null;
    }

    public String getName() {
        return this.model_name;
    }

    protected double[] getParameterValue(int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            dArray[i] = this.param_value[nArray[i]];
        }
        return dArray;
    }

    protected void setParameterValue(int[] nArray, double[] dArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.param_value[nArray[i]] = dArray[i];
        }
    }

    public Model clone() {
        return new Model(this);
    }
}

