/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.WorkStack;

public final class ExprScalarMul
extends BaseExpression {
    private Expression expr;
    private double[] mval;
    private int[] msubj;
    private int[] msubi;
    private int mdim1;
    private int mdim0;

    protected ExprScalarMul(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression, int n3) {
        super(new int[]{n, n2});
        this.mdim0 = n;
        this.mdim1 = n2;
        this.msubi = nArray;
        this.msubj = nArray2;
        this.mval = dArray;
        this.expr = expression;
    }

    public ExprScalarMul(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        this(n, n2, nArray, nArray2, dArray, expression, ExprScalarMul.validate(n, n2, nArray, nArray2, dArray, expression));
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        this.expr.eval(workStack2, workStack, workStack3);
        workStack2.pop_expr();
        int n = workStack2.nd;
        int n2 = workStack2.nelem;
        int n3 = workStack2.nnz;
        boolean bl = workStack2.hassp;
        int n4 = workStack2.ncodeatom;
        int n5 = workStack2.ptr_base;
        int n6 = workStack2.sp_base;
        int n7 = workStack2.nidxs_base;
        int n8 = workStack2.cof_base;
        int n9 = workStack2.code_base;
        int n10 = workStack2.codeptr_base;
        int n11 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n12 = this.mval.length;
        if (n != 0) {
            throw new DimensionError("Invalid expression shape");
        }
        if (n2 == 0) {
            workStack.alloc_expr(2, 0, 0, true);
            workStack.i32[workStack.shape_base] = this.mdim0;
            workStack.i32[workStack.shape_base + 1] = this.mdim1;
        } else {
            int n13 = n12 * (n4 + (n4 > 0 ? 2 * n3 : 0));
            workStack.alloc_expr(2, n12, n12 * n3, true, n13);
            int n14 = workStack.ptr_base;
            int n15 = workStack.nidxs_base;
            int n16 = workStack.sp_base;
            int n17 = workStack.cof_base;
            int n18 = workStack.shape_base;
            int n19 = workStack.code_base;
            int n20 = workStack.codeptr_base;
            int n21 = workStack.cconst_base;
            int[] nArray2 = workStack.i32;
            long[] lArray2 = workStack.i64;
            double[] dArray2 = workStack.f64;
            nArray2[n18] = this.mdim0;
            nArray2[n18 + 1] = this.mdim1;
            int n22 = 0;
            int n23 = 0;
            nArray2[n14] = 0;
            if (n4 > 0) {
                nArray2[n20] = 0;
                int n24 = 0;
                int n25 = n12;
                for (int i = n24; i < n25; ++i) {
                    int n26 = 0;
                    int n27 = n3;
                    for (int j = n26; j < n27; ++j) {
                        lArray2[n15 + n23] = lArray[n7 + j];
                        dArray2[n17 + n23] = dArray[n8 + j] * this.mval[i];
                        int n28 = nArray[n10 + j];
                        int n29 = nArray[n10 + j + 1];
                        for (int k = n28; k < n29; ++k) {
                            nArray2[n19 + n22] = nArray[n9 + k];
                            dArray2[n21 + n22] = dArray[n11 + k];
                            ++n22;
                        }
                        nArray2[n19 + n22] = 2;
                        dArray2[n21 + n22] = this.mval[i];
                        nArray2[n19 + ++n22] = 5;
                        nArray2[n20 + n23 + 1] = ++n22;
                        ++n23;
                    }
                    lArray2[n16 + i] = this.msubi[i] * this.mdim1 + this.msubj[i];
                    nArray2[n14 + i + 1] = n23;
                }
            } else {
                int n30 = 0;
                int n31 = n12;
                for (int i = n30; i < n31; ++i) {
                    int n32 = 0;
                    int n33 = n3;
                    for (int j = n32; j < n33; ++j) {
                        lArray2[n15 + n23] = lArray[n7 + j];
                        dArray2[n17 + n23] = dArray[n8 + j] * this.mval[i];
                        ++n23;
                    }
                    lArray2[n16 + i] = this.msubi[i] * this.mdim1 + this.msubj[i];
                    nArray2[n14 + i + 1] = n23;
                }
            }
        }
    }

    private static int validate(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        int n3;
        int n4 = expression.getND();
        if (n4 != 0) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (n < 0 || n2 < 0) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (nArray.length != nArray2.length || nArray.length != dArray.length) {
            throw new LengthError("Invalid matrix data");
        }
        int n5 = nArray.length;
        boolean bl = false;
        boolean bl2 = false;
        int n6 = 0;
        int n7 = n5;
        for (n3 = n6; n3 < n7; ++n3) {
            if (nArray[n3] >= 0 && nArray[n3] < n && nArray2[n3] >= 0 && nArray2[n3] < n2) continue;
            bl = true;
        }
        n6 = 0;
        n7 = n5 - 1;
        for (n3 = n6; n3 < n7; ++n3) {
            if (nArray[n3] <= nArray[n3 + 1] && (nArray[n3] != nArray[n3 + 1] || nArray2[n3] < nArray2[n3 + 1])) continue;
            bl2 = true;
        }
        if (bl) {
            throw new LengthError("Invalid matrix data");
        }
        if (bl2) {
            throw new LengthError("Unsorted matrix data");
        }
        return 1;
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprScalarMul(M,").a(this.expr.toString()).a(")").toString();
    }
}

