/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.LinearDomain;
import mosek.fusion.RelationKey;

public class SymmetricLinearDomain {
    protected int[][] sparsity;
    protected boolean cardinal_flag;
    protected RelationKey key;
    protected int[] shape;
    protected LinearDomain dom;
    protected int dim;

    protected SymmetricLinearDomain(LinearDomain linearDomain) {
        this.dom = linearDomain;
        this.shape = linearDomain.shape;
        this.key = linearDomain.key;
        this.cardinal_flag = linearDomain.cardinal_flag;
        this.sparsity = linearDomain.sparsity;
        if (this.shape != null && (this.shape.length != 2 || this.shape[0] != this.shape[1])) {
            throw new DimensionError("Only square domains can be symmetric");
        }
        this.dim = this.shape == null ? 0 : this.shape[0];
    }

    public SymmetricLinearDomain sparse(int[][] nArray) {
        this.sparsity = new int[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length && i < nArray.length; ++i) {
            for (int j = 0; j < nArray[0].length && j < nArray[0].length; ++j) {
                this.sparsity[i][j] = nArray[i][j];
            }
        }
        return this;
    }

    public SymmetricLinearDomain sparse(int[] nArray) {
        this.sparsity = new int[nArray.length][1];
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            this.sparsity[i][0] = nArray[i];
        }
        return this;
    }

    public SymmetricLinearDomain integral() {
        this.cardinal_flag = true;
        return this;
    }

    protected boolean match_shape(int[] nArray) {
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            if (nArray[i] != this.shape[i]) continue;
            return false;
        }
        return true;
    }
}

