/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Set;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.WorkStack;

public final class ExprMulElement
extends BaseExpression {
    private Expression expr;
    private long[] msp;
    private double[] mcof;

    public ExprMulElement(double[] dArray, long[] lArray, Expression expression) {
        this(dArray, lArray, expression, 1);
        int n;
        int[] nArray = expression.getShape();
        if (dArray.length != lArray.length) {
            throw new LengthError("Invalid matrix specification");
        }
        long l = Set.size(nArray);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = lArray.length;
        for (n = n2; n < n3; ++n) {
            if (lArray[n] >= 0L && lArray[n] < l) continue;
            bl = true;
        }
        n2 = 0;
        n3 = lArray.length - 1;
        for (n = n2; n < n3; ++n) {
            if (lArray[n] < lArray[n + 1]) continue;
            bl2 = true;
        }
        if (bl) {
            throw new IndexError("Invalid matrix data");
        }
        if (bl2) {
            throw new IndexError("Matrix data not sorted");
        }
    }

    protected ExprMulElement(double[] dArray, long[] lArray, Expression expression, int n) {
        super(expression.getShape());
        this.expr = expression;
        this.mcof = dArray;
        this.msp = lArray;
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        this.expr.eval(workStack2, workStack, workStack3);
        workStack2.pop_expr();
        int n7 = workStack2.nd;
        int n8 = workStack2.nelem;
        int n9 = workStack2.nnz;
        int n10 = workStack2.ncodeatom;
        boolean bl = workStack2.hassp;
        int n11 = workStack2.shape_base;
        int n12 = workStack2.ptr_base;
        int n13 = workStack2.nidxs_base;
        int n14 = workStack2.sp_base;
        int n15 = workStack2.cof_base;
        int n16 = workStack2.code_base;
        int n17 = workStack2.codeptr_base;
        int n18 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (!bl) {
            n21 = this.msp.length;
            n6 = 0;
            n5 = this.msp.length;
            for (n4 = n6; n4 < n5; ++n4) {
                n20 += nArray[(int)((long)n12 + this.msp[n4] + 1L)] - nArray[(int)((long)n12 + this.msp[n4])];
            }
            if (n10 > 0) {
                n6 = 0;
                n5 = this.msp.length;
                for (n4 = n6; n4 < n5; ++n4) {
                    n19 += nArray[n17 + nArray[(int)((long)n12 + this.msp[n4] + 1L)]] - nArray[n17 + nArray[(int)((long)n12 + this.msp[n4])]] + 2 * (nArray[(int)((long)n12 + this.msp[n4] + 1L)] - nArray[(int)((long)n12 + this.msp[n4])]);
                }
            }
        } else {
            n6 = this.msp.length;
            n5 = 0;
            n4 = n8;
            n3 = 0;
            while (n5 < n6 && n3 < n4) {
                if (this.msp[n5] < lArray[n14 + n3]) {
                    ++n5;
                    continue;
                }
                if (this.msp[n5] > lArray[n14 + n3]) {
                    ++n3;
                    continue;
                }
                n20 += nArray[n12 + n3 + 1] - nArray[n12 + n3];
                if (n10 > 0) {
                    n19 += nArray[n17 + nArray[n12 + n3 + 1]] - nArray[n17 + nArray[n12 + n3]] + 2 * (nArray[n12 + n3 + 1] - nArray[n12 + n3]);
                }
                ++n5;
                ++n3;
                ++n21;
            }
        }
        long l = 1L;
        n4 = 0;
        n3 = n7;
        for (n2 = n4; n2 < n3; ++n2) {
            l *= (long)nArray[n11 + n2];
        }
        n4 = (long)n21 < l ? 1 : 0;
        n3 = n7;
        workStack.alloc_expr(n3, n21, n20, n4 != 0, n19);
        n2 = workStack.ptr_base;
        int n22 = workStack.shape_base;
        int n23 = workStack.nidxs_base;
        int n24 = n4 != 0 ? workStack.sp_base : workStack.alloci64(n21);
        int n25 = workStack.cof_base;
        int n26 = workStack.code_base;
        int n27 = workStack.codeptr_base;
        int n28 = workStack.cconst_base;
        int[] nArray2 = workStack.i32;
        long[] lArray2 = workStack.i64;
        double[] dArray2 = workStack.f64;
        int n29 = 0;
        int n30 = 0;
        int n31 = 0;
        nArray2[n2] = 0;
        if (n19 > 0) {
            nArray2[n27] = 0;
        }
        int n32 = 0;
        int n33 = n3;
        for (n = n32; n < n33; ++n) {
            nArray2[n22 + n] = nArray[n11 + n];
        }
        if (!bl) {
            n32 = 0;
            n33 = this.msp.length;
            for (n = n32; n < n33; ++n) {
                int n34 = nArray[(int)((long)n12 + this.msp[n])];
                int n35 = nArray[(int)((long)n12 + this.msp[n] + 1L)];
                int n36 = n34;
                int n37 = n35;
                for (int i = n36; i < n37; ++i) {
                    lArray2[n23 + n31] = lArray[n13 + i];
                    dArray2[n25 + n31] = dArray[n15 + i] * this.mcof[n];
                    if (n10 > 0) {
                        int n38 = nArray[n17 + i];
                        int n39 = nArray[n17 + i + 1];
                        for (int j = n38; j < n39; ++j) {
                            nArray2[n26 + n29] = nArray[n16 + j];
                            dArray2[n28 + n29] = dArray[n18 + j];
                            ++n29;
                        }
                        nArray2[n26 + n29] = 2;
                        dArray2[n28 + n29] = this.mcof[n];
                        nArray2[n26 + ++n29] = 5;
                        nArray2[n27 + n31 + 1] = ++n29;
                    }
                    ++n31;
                }
                nArray2[n2 + n + 1] = n31;
                lArray2[n24 + n] = this.msp[n];
            }
        } else {
            n32 = this.msp.length;
            n33 = 0;
            n = n8;
            int n40 = 0;
            while (n33 < n32 && n40 < n) {
                if (this.msp[n33] < lArray[n14 + n40]) {
                    ++n33;
                    continue;
                }
                if (this.msp[n33] > lArray[n14 + n40]) {
                    ++n40;
                    continue;
                }
                int n41 = nArray[n12 + n40];
                int n42 = nArray[n12 + n40 + 1];
                int n43 = n41;
                int n44 = n42;
                for (int i = n43; i < n44; ++i) {
                    lArray2[n23 + n31] = lArray[n13 + i];
                    dArray2[n25 + n31] = dArray[n13 + i] * this.mcof[n33];
                    if (n10 > 0) {
                        int n45 = nArray[n17 + i];
                        int n46 = nArray[n17 + i + 1];
                        for (int j = n45; j < n46; ++j) {
                            nArray2[n26 + n29] = nArray[n16 + j];
                            dArray2[n28 + n29] = dArray[n18 + j];
                            ++n29;
                        }
                        nArray2[n26 + n29] = 2;
                        dArray2[n28 + n29] = this.mcof[n33];
                        nArray2[n26 + ++n29] = 5;
                        nArray2[n27 + n31 + 1] = ++n29;
                    }
                    ++n31;
                }
                nArray2[n2 + n30 + 1] = n31;
                lArray2[n24 + n30] = this.msp[n33];
                ++n30;
                ++n33;
                ++n40;
            }
        }
        if (n4 == 0) {
            workStack.popi64(n21);
        }
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprMulElement(M,").a(this.expr.toString()).a(")").toString();
    }
}

