/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.CommonTools;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.Utils.Tools;
import mosek.fusion.WorkStack;

public final class ExprPermuteDims
extends BaseExpression {
    private int[] dperm;
    private Expression expr;

    public ExprPermuteDims(int[] nArray, Expression expression) {
        this(nArray, expression, 1);
        int n;
        int[] nArray2 = expression.getShape();
        if (nArray.length != nArray2.length) {
            throw new LengthError("Invalid dimension permutation");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray.length;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        int[] nArray3 = new int[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            nArray3[n2] = 0;
            ++n2;
            ++n7;
            ++n6;
        }
        int[] nArray4 = nArray3;
        int n8 = 0;
        int n9 = nArray4.length;
        for (n = n8; n < n9; ++n) {
            if (nArray[n] < 0 || nArray[n] > nArray2.length) {
                throw new LengthError("Invalid dimension permutation");
            }
            int n10 = nArray[n];
            nArray4[n10] = nArray4[n10] + 1;
        }
        n8 = 0;
        n9 = nArray4.length;
        for (n = n8; n < n9; ++n) {
            if (nArray4[n] >= 1 && nArray4[n] <= 1) continue;
            throw new LengthError("Invalid dimension permutation");
        }
    }

    protected ExprPermuteDims(int[] nArray, Expression expression, int n) {
        super(ExprPermuteDims.computeshape(nArray, expression.getShape()));
        this.expr = expression;
        this.dperm = Tools.arraycopy(nArray);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        int n;
        int n2;
        int n3;
        this.expr.eval(workStack2, workStack, workStack3);
        workStack2.pop_expr();
        int n4 = workStack2.nd;
        int n5 = workStack2.nelem;
        int n6 = workStack2.nnz;
        int n7 = workStack2.ncodeatom;
        boolean bl = workStack2.hassp;
        int n8 = workStack2.shape_base;
        long[] lArray = new long[n4];
        lArray[n4 - 1] = 1L;
        int n9 = 1;
        int n10 = n4;
        for (n3 = n9; n3 < n10; ++n3) {
            lArray[n4 - n3 - 1] = lArray[n4 - n3] * (long)workStack2.i32[n8 + n4 - n3];
        }
        int[] nArray = new int[n4];
        nArray[n4 - 1] = 1;
        n10 = 1;
        n3 = n4;
        for (n2 = n10; n2 < n3; ++n2) {
            nArray[n4 - n2 - 1] = nArray[n4 - n2] * workStack2.i32[n8 + this.dperm[n4 - n2]];
        }
        n10 = workStack2.ptr_base;
        n3 = workStack2.sp_base;
        n2 = workStack2.nidxs_base;
        int n11 = workStack2.cof_base;
        int n12 = workStack2.code_base;
        int n13 = workStack2.codeptr_base;
        int n14 = workStack2.cconst_base;
        int[] nArray2 = workStack2.i32;
        long[] lArray2 = workStack2.i64;
        double[] dArray = workStack2.f64;
        workStack.alloc_expr(n4, n5, n6, bl, n7);
        int n15 = workStack.ptr_base;
        int n16 = workStack.shape_base;
        int n17 = workStack.nidxs_base;
        int n18 = workStack.sp_base;
        int n19 = workStack.cof_base;
        int n20 = workStack.code_base;
        int n21 = workStack.codeptr_base;
        int n22 = workStack.cconst_base;
        int[] nArray3 = workStack.i32;
        long[] lArray3 = workStack.i64;
        double[] dArray2 = workStack.f64;
        int n23 = 0;
        int n24 = n4;
        for (n = n23; n < n24; ++n) {
            nArray3[n16 + n] = nArray2[n8 + this.dperm[n]];
        }
        if (bl) {
            int n25;
            int n26;
            int n27;
            int n28;
            long[] lArray4 = new long[n5];
            n24 = 0;
            n = n5;
            for (n28 = n24; n28 < n; ++n28) {
                long l = 0L;
                n27 = 0;
                n26 = n4;
                for (n25 = n27; n25 < n26; ++n25) {
                    l += lArray2[n3 + n28] / lArray[n25] % (long)nArray2[n8 + n25] * (long)nArray[this.dperm[n25]];
                }
                lArray4[n28] = l;
            }
            n24 = 0;
            n = 0;
            n28 = n5;
            int n29 = n < n28 ? n28 - n : 0;
            long[] lArray5 = new long[n29];
            n27 = n;
            n26 = 0;
            while (n26 < n29) {
                lArray5[n24] = n27;
                ++n24;
                ++n26;
                ++n27;
            }
            long[] lArray6 = lArray5;
            CommonTools.argQsort(lArray6, lArray4, null, 0L, (long)n5);
            nArray3[n15] = 0;
            if (n7 > 0) {
                nArray3[n21] = 0;
            }
            n25 = 0;
            int n30 = 0;
            int n31 = 0;
            int n32 = 0;
            int n33 = n5;
            for (int i = n32; i < n33; ++i) {
                long l = lArray6[i];
                int n34 = nArray2[(int)((long)n10 + l)];
                int n35 = nArray2[(int)((long)n10 + l + 1L)];
                for (int j = n34; j < n35; ++j) {
                    lArray3[n17 + n31] = lArray2[n2 + j];
                    dArray2[n19 + n31] = dArray[n11 + j];
                    if (n7 > 0) {
                        int n36 = nArray2[n13 + j];
                        int n37 = nArray2[n13 + j + 1];
                        for (int k = n36; k < n37; ++k) {
                            nArray3[n20 + n25] = nArray2[n12 + k];
                            dArray2[n22 + n25] = dArray[n14 + k];
                            ++n25;
                        }
                        nArray3[n21 + n31 + 1] = n25;
                    }
                    ++n31;
                }
                lArray3[n18 + i] = lArray4[(int)l];
                ++n30;
                nArray3[n15 + i + 1] = n31;
            }
        } else {
            nArray3[n15] = 0;
            if (n7 > 0) {
                nArray3[n21] = 0;
            }
            n23 = 0;
            n24 = 0;
            n = 0;
            int n38 = 0;
            int n39 = n5;
            for (int i = n38; i < n39; ++i) {
                int n40;
                long l = 0L;
                int n41 = 0;
                int n42 = n4;
                for (n40 = n41; n40 < n42; ++n40) {
                    l += (long)i / lArray[this.dperm[n40]] % (long)nArray2[n8 + this.dperm[n40]] * (long)nArray[n40];
                }
                n41 = nArray2[(int)((long)n10 + l)];
                n42 = nArray2[(int)((long)n10 + l + 1L)];
                for (n40 = n41; n40 < n42; ++n40) {
                    lArray3[n17 + n] = lArray2[n2 + n40];
                    dArray2[n19 + n] = dArray[n11 + n40];
                    if (n7 > 0) {
                        int n43 = nArray2[n13 + n40];
                        int n44 = nArray2[n13 + n40 + 1];
                        for (int j = n43; j < n44; ++j) {
                            nArray3[n20 + n23] = nArray2[n12 + j];
                            dArray2[n22 + n23] = dArray[n14 + j];
                            ++n23;
                        }
                        nArray3[n21 + n + 1] = n23;
                    }
                    ++n;
                }
                nArray3[n15 + ++n24] = n;
            }
        }
    }

    private static int[] computeshape(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray3 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray3[n] = nArray2[nArray[n5]];
            ++n;
            ++n6;
            ++n5;
        }
        return nArray3;
    }
}

