/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.DimensionError;
import mosek.fusion.QConeKey;
import mosek.fusion.Set;
import mosek.fusion.Utils.Tools;

public final class ConeDomain {
    protected String[][] indexnames;
    protected long domsize;
    protected double[] domofs;
    protected double[] alpha;
    protected int[] shape;
    protected boolean int_flag;
    protected boolean axisset;
    protected int axisidx;
    protected QConeKey key;

    protected ConeDomain(QConeKey qConeKey, double[] dArray, int[] nArray) {
        this.shape = nArray != null ? Tools.arraycopy(nArray) : null;
        this.domsize = 0L;
        this.alpha = dArray;
        this.key = qConeKey;
        this.axisidx = 0;
        this.axisset = false;
        this.int_flag = false;
        this.domofs = null;
        this.indexnames = null;
    }

    protected ConeDomain(QConeKey qConeKey, int[] nArray) {
        this(qConeKey, null, nArray);
    }

    private ConeDomain(ConeDomain coneDomain) {
        this.key = coneDomain.key;
        this.axisidx = coneDomain.axisidx;
        this.axisset = coneDomain.axisset;
        this.int_flag = coneDomain.int_flag;
        this.shape = coneDomain.shape;
        this.alpha = coneDomain.alpha;
        this.domofs = coneDomain.domofs;
        this.domsize = coneDomain.domsize;
        this.indexnames = coneDomain.indexnames;
    }

    protected boolean match_shape(int[] nArray) {
        return this.shape == null || Set.match(nArray, this.shape);
    }

    public ConeDomain integral() {
        this.int_flag = true;
        return this;
    }

    public boolean axisIsSet() {
        return this.axisset;
    }

    public int getAxis() {
        return this.axisidx;
    }

    public ConeDomain axis(int n) {
        this.axisidx = n;
        this.axisset = true;
        return this;
    }

    public ConeDomain withShape(int n, int n2, int n3) {
        return this.withShape_(new int[]{n, n2, n3});
    }

    public ConeDomain withShape(int n, int n2) {
        return this.withShape_(new int[]{n, n2});
    }

    public ConeDomain withShape(int n) {
        return this.withShape_(new int[]{n});
    }

    public ConeDomain withShape(int[] nArray) {
        return this.withShape_(Tools.arraycopy(nArray));
    }

    private ConeDomain withShape_(int[] nArray) {
        this.shape = nArray;
        return this;
    }

    public ConeDomain withNamesOnAxis(String[] stringArray, int n) {
        int n2;
        int n3;
        String[] stringArray2;
        int n4;
        int n5;
        int n6;
        int n7;
        if (stringArray == null) {
            this.indexnames = new String[n + 1][];
            n7 = 0;
            n6 = 0;
            n5 = stringArray.length;
            n4 = n6 < n5 ? n5 - n6 : 0;
            stringArray2 = new String[n4];
            n3 = n6;
            n2 = 0;
            while (n2 < n4) {
                stringArray2[n7] = stringArray[n3];
                ++n7;
                ++n2;
                ++n3;
            }
            this.indexnames[n] = stringArray2;
        }
        if (this.indexnames.length < n + 1) {
            String[][] stringArrayArray = new String[n][];
            n6 = 0;
            n5 = this.indexnames.length;
            for (n4 = n6; n4 < n5; ++n4) {
                stringArrayArray[n4] = this.indexnames[n4];
            }
            this.indexnames = stringArrayArray;
        }
        n7 = 0;
        n6 = 0;
        n5 = stringArray.length;
        n4 = n6 < n5 ? n5 - n6 : 0;
        stringArray2 = new String[n4];
        n3 = n6;
        n2 = 0;
        while (n2 < n4) {
            stringArray2[n7] = stringArray[n3];
            ++n7;
            ++n2;
            ++n3;
        }
        this.indexnames[n] = stringArray2;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void finalize_and_validate_inplace(int[] nArray) {
        int n;
        int n2;
        int n3;
        this.domsize = 1L;
        if (this.shape == null) {
            if (nArray == null) throw new DimensionError("Missing domain shape");
            this.shape = nArray;
        } else if (nArray != null) {
            if (nArray.length != this.shape.length) {
                throw new DimensionError("Conflicting shape definitions");
            }
            n3 = 0;
            n2 = nArray.length;
            for (n = n3; n < n2; ++n) {
                if (nArray[n] == this.shape[n]) continue;
                throw new DimensionError("Conflicting shape definitions");
            }
        }
        n3 = 0;
        n2 = this.shape.length;
        for (n = n3; n < n2; ++n) {
            this.domsize *= (long)this.shape[n];
        }
        if (this.indexnames != null) {
            if (this.indexnames.length != this.shape.length) {
                throw new DimensionError("Index names do not match shape");
            }
            n3 = 0;
            n2 = this.shape.length;
            for (n = n3; n < n2; ++n) {
                if (this.indexnames[n] == null || this.indexnames[n].length == this.shape[n]) continue;
                throw new DimensionError("Index names do not match shape");
            }
        }
        if (!this.axisset) {
            this.axisset = true;
            this.axisidx = this.shape.length - 1;
        } else if (this.axisidx < 0 || this.axisidx >= this.shape.length) {
            throw new DimensionError("Cone axis is invalid");
        }
        if (this.domofs == null || (long)this.domofs.length == this.domsize) return;
        throw new DimensionError("Domain offset does not match shape");
    }

    protected ConeDomain finalize_and_validate(int[] nArray) {
        ConeDomain coneDomain = new ConeDomain(this);
        coneDomain.finalize_and_validate_inplace(nArray);
        return coneDomain;
    }
}

