/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.ConeDomain;
import mosek.fusion.DimensionError;
import mosek.fusion.DomainError;
import mosek.fusion.LengthError;
import mosek.fusion.LinearDomain;
import mosek.fusion.Matrix;
import mosek.fusion.PSDDomain;
import mosek.fusion.PSDKey;
import mosek.fusion.QConeKey;
import mosek.fusion.RangeDomain;
import mosek.fusion.RelationKey;
import mosek.fusion.SymmetricLinearDomain;
import mosek.fusion.SymmetricRangeDomain;
import mosek.fusion.Utils.Tools;

public class Domain {
    private static long dimsize(int[] nArray) {
        long l = 1L;
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)nArray[i];
        }
        return l;
    }

    private static RangeDomain mkRangedDomain(Matrix matrix, Matrix matrix2) {
        double[] dArray;
        int n;
        int n2;
        int n3;
        double[] dArray2;
        int[] nArray;
        int[] nArray2;
        double[] dArray3;
        if (matrix.dimi != matrix2.dimi || matrix.dimj != matrix2.dimj) {
            throw new DimensionError("Mismatching dimensions in domain");
        }
        if (matrix.isSparse() && matrix2.isSparse()) {
            int[] nArray3 = new int[(int)matrix.numNonzeros()];
            int[] nArray4 = new int[(int)matrix.numNonzeros()];
            double[] dArray4 = new double[(int)matrix.numNonzeros()];
            int[] nArray5 = new int[(int)matrix2.numNonzeros()];
            int[] nArray6 = new int[(int)matrix2.numNonzeros()];
            double[] dArray5 = new double[(int)matrix2.numNonzeros()];
            matrix.getDataAsTriplets(nArray3, nArray4, dArray4);
            matrix2.getDataAsTriplets(nArray5, nArray6, dArray5);
            long l = 0L;
            int n4 = 0;
            int n5 = 0;
            while (n5 < nArray3.length && n4 < nArray5.length) {
                if (nArray3[n5] < nArray5[n4] || nArray3[n5] == nArray5[n4] && nArray4[n5] < nArray6[n4]) {
                    ++l;
                    ++n5;
                    continue;
                }
                if (nArray3[n5] > nArray5[n4] || nArray3[n5] == nArray5[n4] && nArray4[n5] > nArray6[n4]) {
                    ++l;
                    ++n4;
                    continue;
                }
                ++l;
                ++n5;
                ++n4;
            }
            l += (long)(nArray3.length - n5);
            int[][] nArray7 = new int[(int)(l += (long)(nArray5.length - n4))][2];
            double[] dArray6 = new double[(int)l];
            double[] dArray7 = new double[(int)l];
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < nArray3.length && n7 < nArray5.length) {
                if (nArray3[n8] < nArray5[n7] || nArray3[n8] == nArray5[n7] && nArray4[n8] < nArray6[n7]) {
                    nArray7[n6][0] = nArray3[n8];
                    nArray7[n6][1] = nArray4[n8];
                    dArray6[n6] = dArray4[n8];
                    dArray7[n6] = 0.0;
                    ++n6;
                    ++n8;
                    continue;
                }
                if (nArray3[n8] > nArray5[n7] || nArray3[n8] == nArray5[n7] && nArray4[n8] > nArray6[n7]) {
                    nArray7[n6][0] = nArray5[n7];
                    nArray7[n6][1] = nArray6[n7];
                    dArray6[n6] = 0.0;
                    dArray7[n6] = dArray5[n7];
                    ++n6;
                    ++n7;
                    continue;
                }
                nArray7[n6][0] = nArray5[n7];
                nArray7[n6][1] = nArray6[n7];
                dArray6[n6] = dArray4[n7];
                dArray7[n6] = dArray5[n7];
                ++n6;
                ++n8;
                ++n7;
            }
            while (n8 < nArray3.length) {
                nArray7[n6][0] = nArray3[n8];
                nArray7[n6][1] = nArray4[n8];
                dArray6[n6] = dArray4[n8];
                dArray7[n6] = 0.0;
                ++n6;
                ++n8;
            }
            while (n7 < nArray5.length) {
                nArray7[n6][0] = nArray5[n7];
                nArray7[n6][1] = nArray6[n7];
                dArray6[n6] = 0.0;
                dArray7[n6] = dArray5[n7];
                ++n6;
                ++n7;
            }
            return new RangeDomain(false, dArray6, dArray7, new int[]{matrix.dimi, matrix.dimj}, nArray7, 1);
        }
        int n9 = matrix.dimj;
        int n10 = matrix.dimi;
        int n11 = n10 * n9;
        if (matrix.isSparse()) {
            dArray3 = new double[n11];
            nArray2 = new int[(int)matrix.numNonzeros()];
            nArray = new int[(int)matrix.numNonzeros()];
            dArray2 = new double[(int)matrix.numNonzeros()];
            matrix.getDataAsTriplets(nArray2, nArray, dArray2);
            n3 = 0;
            n2 = nArray2.length;
            for (n = n3; n < n2; ++n) {
                dArray3[nArray2[n] * n9 + nArray[n]] = dArray2[n];
            }
        } else {
            dArray3 = matrix.getDataAsArray();
        }
        if (matrix2.isSparse()) {
            dArray = new double[n11];
            nArray2 = new int[(int)matrix2.numNonzeros()];
            nArray = new int[(int)matrix2.numNonzeros()];
            dArray2 = new double[(int)matrix2.numNonzeros()];
            matrix2.getDataAsTriplets(nArray2, nArray, dArray2);
            n3 = 0;
            n2 = nArray2.length;
            for (n = n3; n < n2; ++n) {
                dArray[nArray2[n] * n9 + nArray[n]] = dArray2[n];
            }
        } else {
            dArray = matrix2.getDataAsArray();
        }
        return new RangeDomain(false, dArray3, dArray, new int[]{matrix.dimi, matrix.dimj}, null, 1);
    }

    private static RangeDomain mkRangedDomain(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length || dArray[0].length != dArray2[0].length) {
            throw new DimensionError("Mismatching dimensions in domain");
        }
        int n = dArray[0].length;
        int n2 = dArray.length;
        int n3 = n2 * n;
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        for (int i = n5; i < n6; ++i) {
            int n7 = 0;
            int n8 = n;
            for (int j = n7; j < n8; ++j) {
                dArray3[n4] = dArray[i][j];
                dArray4[n4] = dArray2[i][j];
                ++n4;
            }
        }
        return new RangeDomain(false, dArray3, dArray4, new int[]{n2, n}, null, 1);
    }

    private static LinearDomain mkLinearDomain(RelationKey relationKey, Matrix matrix) {
        if (matrix.isSparse()) {
            int[] nArray = new int[(int)matrix.numNonzeros()];
            int[] nArray2 = new int[(int)matrix.numNonzeros()];
            double[] dArray = new double[(int)matrix.numNonzeros()];
            matrix.getDataAsTriplets(nArray, nArray2, dArray);
            int[][] nArray3 = new int[nArray.length][2];
            int n = 0;
            int n2 = nArray.length;
            for (int i = n; i < n2; ++i) {
                nArray3[i][0] = nArray[i];
                nArray3[i][1] = nArray2[i];
            }
            return new LinearDomain(relationKey, false, dArray, new int[]{matrix.dimi, matrix.dimj}, nArray3, 1);
        }
        return new LinearDomain(relationKey, false, matrix.getDataAsArray(), new int[]{matrix.dimi, matrix.dimj}, null, 1);
    }

    private static long prod(int[] nArray) {
        long l = 1L;
        int n = 0;
        int n2 = nArray.length;
        for (int i = n; i < n2; ++i) {
            l *= (long)nArray[i];
        }
        return l;
    }

    private static RangeDomain inRange(boolean bl, double[] dArray, double[] dArray2, int[][] nArray, int[] nArray2) {
        if (!bl && dArray.length != dArray2.length) {
            throw new LengthError("Mismatching lengths of upper and lower bounds.");
        }
        if (nArray != null && nArray.length != dArray.length) {
            throw new LengthError("Mismatching lengths of upper/lower bounds and sparsity.");
        }
        int n = 0;
        int n2 = dArray2.length;
        for (int i = n; i < n2; ++i) {
            if (!(dArray[i] > dArray2[i])) continue;
            throw new DomainError("Invalid range specified");
        }
        if (nArray2 != null && Domain.dimsize(nArray2) != (long)dArray.length) {
            throw new LengthError("Mismatching dimensions.");
        }
        return new RangeDomain(bl, dArray, dArray2, nArray2).sparse(nArray);
    }

    public static SymmetricRangeDomain symmetric(RangeDomain rangeDomain) {
        return rangeDomain.symmetric();
    }

    public static SymmetricLinearDomain symmetric(LinearDomain linearDomain) {
        return linearDomain.symmetric();
    }

    public static RangeDomain sparse(RangeDomain rangeDomain, int[][] nArray) {
        return rangeDomain.sparse(nArray);
    }

    public static RangeDomain sparse(RangeDomain rangeDomain, int[] nArray) {
        return rangeDomain.sparse(nArray);
    }

    public static LinearDomain sparse(LinearDomain linearDomain, int[][] nArray) {
        return linearDomain.sparse(nArray);
    }

    public static LinearDomain sparse(LinearDomain linearDomain, int[] nArray) {
        return linearDomain.sparse(nArray);
    }

    public static RangeDomain integral(RangeDomain rangeDomain) {
        return rangeDomain.integral();
    }

    public static LinearDomain integral(LinearDomain linearDomain) {
        return linearDomain.integral();
    }

    public static ConeDomain integral(ConeDomain coneDomain) {
        return coneDomain.integral();
    }

    public static ConeDomain axis(ConeDomain coneDomain, int n) {
        return coneDomain.axis(n);
    }

    public static ConeDomain inDPowerCone(double[] dArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InDPowCone, dArray, nArray2);
    }

    public static ConeDomain inDPowerCone(double[] dArray, int n) {
        return new ConeDomain(QConeKey.InDPowCone, dArray, new int[]{n, 3});
    }

    public static ConeDomain inDPowerCone(double[] dArray) {
        return new ConeDomain(QConeKey.InDPowCone, dArray, null);
    }

    public static ConeDomain inDPowerCone(double d, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InDPowCone, new double[]{d, 1.0 - d}, nArray2);
    }

    public static ConeDomain inDPowerCone(double d, int n) {
        return new ConeDomain(QConeKey.InDPowCone, new double[]{d, 1.0 - d}, new int[]{n, 3});
    }

    public static ConeDomain inDPowerCone(double d) {
        return new ConeDomain(QConeKey.InDPowCone, new double[]{d, 1.0 - d}, null);
    }

    public static ConeDomain inPPowerCone(double[] dArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InPPowCone, dArray, nArray2);
    }

    public static ConeDomain inPPowerCone(double[] dArray, int n) {
        return new ConeDomain(QConeKey.InPPowCone, dArray, new int[]{n, 3});
    }

    public static ConeDomain inPPowerCone(double[] dArray) {
        return new ConeDomain(QConeKey.InPPowCone, dArray, null);
    }

    public static ConeDomain inPPowerCone(double d, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InPPowCone, new double[]{d, 1.0 - d}, nArray2);
    }

    public static ConeDomain inPPowerCone(double d, int n) {
        return new ConeDomain(QConeKey.InPPowCone, new double[]{d, 1.0 - d}, new int[]{n, 3});
    }

    public static ConeDomain inPPowerCone(double d) {
        return new ConeDomain(QConeKey.InPPowCone, new double[]{d, 1.0 - d}, null);
    }

    public static ConeDomain inDExpCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InDExpCone, nArray2);
    }

    public static ConeDomain inDExpCone(int n) {
        return new ConeDomain(QConeKey.InDExpCone, new int[]{n, 3});
    }

    public static ConeDomain inDExpCone() {
        return new ConeDomain(QConeKey.InDExpCone, null);
    }

    public static ConeDomain inPExpCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InPExpCone, nArray2);
    }

    public static ConeDomain inPExpCone(int n) {
        return new ConeDomain(QConeKey.InPExpCone, new int[]{n, 3});
    }

    public static ConeDomain inPExpCone() {
        return new ConeDomain(QConeKey.InPExpCone, null);
    }

    public static ConeDomain inDGeoMeanCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InDGeoMeanCone, nArray2);
    }

    public static ConeDomain inDGeoMeanCone(int n, int n2) {
        return new ConeDomain(QConeKey.InDGeoMeanCone, new int[]{n, n2});
    }

    public static ConeDomain inDGeoMeanCone(int n) {
        return new ConeDomain(QConeKey.InDGeoMeanCone, new int[]{n});
    }

    public static ConeDomain inDGeoMeanCone() {
        return new ConeDomain(QConeKey.InDGeoMeanCone, null);
    }

    public static ConeDomain inPGeoMeanCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InPGeoMeanCone, nArray2);
    }

    public static ConeDomain inPGeoMeanCone(int n, int n2) {
        return new ConeDomain(QConeKey.InPGeoMeanCone, new int[]{n, n2});
    }

    public static ConeDomain inPGeoMeanCone(int n) {
        return new ConeDomain(QConeKey.InPGeoMeanCone, new int[]{n});
    }

    public static ConeDomain inPGeoMeanCone() {
        return new ConeDomain(QConeKey.InPGeoMeanCone, null);
    }

    public static ConeDomain inRotatedQCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InRotatedQCone, nArray2);
    }

    public static ConeDomain inRotatedQCone(int n, int n2) {
        return new ConeDomain(QConeKey.InRotatedQCone, new int[]{n, n2});
    }

    public static ConeDomain inRotatedQCone(int n) {
        return new ConeDomain(QConeKey.InRotatedQCone, new int[]{n});
    }

    public static ConeDomain inRotatedQCone() {
        return new ConeDomain(QConeKey.InRotatedQCone, null);
    }

    public static ConeDomain inQCone(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new ConeDomain(QConeKey.InQCone, nArray2);
    }

    public static ConeDomain inQCone(int n, int n2) {
        return new ConeDomain(QConeKey.InQCone, new int[]{n, n2});
    }

    public static ConeDomain inQCone(int n) {
        return new ConeDomain(QConeKey.InQCone, new int[]{n});
    }

    public static ConeDomain inQCone() {
        return new ConeDomain(QConeKey.InQCone, null);
    }

    public static ConeDomain inSVecPSDCone(int[] nArray) {
        return new ConeDomain(QConeKey.InSVecPSDCone, nArray);
    }

    public static ConeDomain inSVecPSDCone(int n, int n2) {
        return new ConeDomain(QConeKey.InSVecPSDCone, new int[]{n, n2});
    }

    public static ConeDomain inSVecPSDCone(int n) {
        return new ConeDomain(QConeKey.InSVecPSDCone, new int[]{n});
    }

    public static ConeDomain inSVecPSDCone() {
        return new ConeDomain(QConeKey.InSVecPSDCone, null);
    }

    public static PSDDomain isTrilPSD(int n, int n2) {
        return new PSDDomain(PSDKey.IsTrilPSD, new int[]{n2, n, n}, 1, 2);
    }

    public static PSDDomain isTrilPSD(int n) {
        return new PSDDomain(PSDKey.IsTrilPSD, new int[]{n, n}, 0, 1);
    }

    public static PSDDomain isTrilPSD() {
        return new PSDDomain(PSDKey.IsTrilPSD);
    }

    public static PSDDomain inPSDCone(int n, int n2) {
        return new PSDDomain(PSDKey.IsSymPSD, new int[]{n2, n, n});
    }

    public static PSDDomain inPSDCone(int n) {
        return new PSDDomain(PSDKey.IsSymPSD, new int[]{n, n});
    }

    public static PSDDomain inPSDCone() {
        return new PSDDomain(PSDKey.IsSymPSD);
    }

    public static RangeDomain binary() {
        return Domain.inRange(0.0, 1.0).integral();
    }

    public static RangeDomain binary(int[] nArray) {
        return Domain.inRange(0.0, 1.0, nArray).integral();
    }

    public static RangeDomain binary(int n, int n2) {
        return Domain.inRange(0.0, 1.0, new int[]{n, n2}).integral();
    }

    public static RangeDomain binary(int n) {
        return Domain.inRange(0.0, 1.0, new int[]{n}).integral();
    }

    public static RangeDomain inRange(Matrix matrix, Matrix matrix2) {
        return Domain.mkRangedDomain(matrix, matrix2);
    }

    public static RangeDomain inRange(double[][] dArray, double[][] dArray2) {
        return Domain.mkRangedDomain(dArray, dArray2);
    }

    public static RangeDomain inRange(double[] dArray, double[] dArray2, int[] nArray) {
        return new RangeDomain(false, dArray, dArray2, nArray);
    }

    public static RangeDomain inRange(double[] dArray, double d, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return new RangeDomain(false, dArray, dArray2, nArray);
    }

    public static RangeDomain inRange(double d, double[] dArray, int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return new RangeDomain(false, dArray2, dArray, nArray);
    }

    public static RangeDomain inRange(double d, double d2, int[] nArray) {
        return new RangeDomain(false, d, d2, nArray);
    }

    public static RangeDomain inRange(double[] dArray, double[] dArray2) {
        return new RangeDomain(false, dArray, dArray2, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double[] dArray, double d) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return new RangeDomain(false, dArray, dArray2, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double d, double[] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        double[] dArray2 = new double[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            dArray2[n] = d;
            ++n;
            ++n6;
            ++n5;
        }
        return new RangeDomain(false, dArray2, dArray, new int[]{dArray.length});
    }

    public static RangeDomain inRange(double d, double d2) {
        return new RangeDomain(true, new double[]{d}, new double[]{d2}, null);
    }

    public static LinearDomain greaterThan(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.GreaterThan, matrix);
    }

    public static LinearDomain greaterThan(double[] dArray, int[] nArray) {
        return new LinearDomain(RelationKey.GreaterThan, false, Tools.arraycopy(dArray), nArray);
    }

    public static LinearDomain greaterThan(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        return new LinearDomain(RelationKey.GreaterThan, false, dArray2, new int[]{dArray.length, dArray[0].length});
    }

    public static LinearDomain greaterThan(double[] dArray) {
        return new LinearDomain(RelationKey.GreaterThan, false, Tools.arraycopy(dArray), new int[]{dArray.length});
    }

    public static LinearDomain greaterThan(double d, int[] nArray) {
        int n = 0;
        int n2 = 0;
        long l = Domain.prod(nArray);
        long l2 = (long)n2 < l ? l - (long)n2 : 0L;
        double[] dArray = new double[(int)l2];
        long l3 = n2;
        int n3 = 0;
        while ((long)n3 < l2) {
            dArray[n] = d;
            ++n;
            ++n3;
            ++l3;
        }
        return new LinearDomain(RelationKey.GreaterThan, false, dArray, nArray);
    }

    public static LinearDomain greaterThan(double d, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n2 * n;
        int n6 = n4 < n5 ? n5 - n4 : 0;
        double[] dArray = new double[n6];
        int n7 = n4;
        int n8 = 0;
        while (n8 < n6) {
            dArray[n3] = d;
            ++n3;
            ++n8;
            ++n7;
        }
        return new LinearDomain(RelationKey.GreaterThan, false, dArray, new int[]{n, n2});
    }

    public static LinearDomain greaterThan(double d, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        double[] dArray = new double[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            dArray[n2] = d;
            ++n2;
            ++n7;
            ++n6;
        }
        return new LinearDomain(RelationKey.GreaterThan, false, dArray, new int[]{n});
    }

    public static LinearDomain greaterThan(double d) {
        return new LinearDomain(RelationKey.GreaterThan, true, new double[]{d}, null);
    }

    public static LinearDomain lessThan(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.LessThan, matrix);
    }

    public static LinearDomain lessThan(double[] dArray, int[] nArray) {
        return new LinearDomain(RelationKey.LessThan, false, Tools.arraycopy(dArray), nArray);
    }

    public static LinearDomain lessThan(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        return new LinearDomain(RelationKey.LessThan, false, dArray2, new int[]{dArray.length, dArray[0].length});
    }

    public static LinearDomain lessThan(double[] dArray) {
        return new LinearDomain(RelationKey.LessThan, false, Tools.arraycopy(dArray), new int[]{dArray.length});
    }

    public static LinearDomain lessThan(double d, int[] nArray) {
        return new LinearDomain(RelationKey.LessThan, false, new double[]{d}, nArray);
    }

    public static LinearDomain lessThan(double d, int n, int n2) {
        return new LinearDomain(RelationKey.LessThan, false, new double[]{d}, new int[]{n, n2});
    }

    public static LinearDomain lessThan(double d, int n) {
        return new LinearDomain(RelationKey.LessThan, false, new double[]{d}, new int[]{n});
    }

    public static LinearDomain lessThan(double d) {
        return new LinearDomain(RelationKey.LessThan, true, new double[]{d}, null);
    }

    public static LinearDomain equalsTo(Matrix matrix) {
        return Domain.mkLinearDomain(RelationKey.EqualsTo, matrix);
    }

    public static LinearDomain equalsTo(double[] dArray, int[] nArray) {
        return new LinearDomain(RelationKey.EqualsTo, false, Tools.arraycopy(dArray), nArray);
    }

    public static LinearDomain equalsTo(double[][] dArray) {
        int n = 0;
        int n2 = 0;
        int n3 = dArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int n5 = 0;
        int n6 = dArray[0].length;
        int n7 = n5 < n6 ? n6 - n5 : 0;
        double[] dArray2 = new double[n4 * n7];
        int n8 = n2;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n5;
            int n11 = 0;
            while (n11 < n7) {
                dArray2[n] = dArray[n8][n10];
                ++n;
                ++n11;
                ++n10;
            }
            ++n9;
            ++n8;
        }
        return new LinearDomain(RelationKey.EqualsTo, false, dArray2, new int[]{dArray.length, dArray[0].length});
    }

    public static LinearDomain equalsTo(double[] dArray) {
        return new LinearDomain(RelationKey.EqualsTo, false, Tools.arraycopy(dArray), new int[]{dArray.length});
    }

    public static LinearDomain equalsTo(double d, int[] nArray) {
        return new LinearDomain(RelationKey.EqualsTo, false, new double[]{d}, nArray);
    }

    public static LinearDomain equalsTo(double d, int n, int n2) {
        return new LinearDomain(RelationKey.EqualsTo, false, new double[]{d}, new int[]{n, n2});
    }

    public static LinearDomain equalsTo(double d, int n) {
        return new LinearDomain(RelationKey.EqualsTo, false, new double[]{d}, new int[]{n});
    }

    public static LinearDomain equalsTo(double d) {
        return new LinearDomain(RelationKey.EqualsTo, true, new double[]{d}, null);
    }

    public static LinearDomain unbounded(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = n2 < n3 ? n3 - n2 : 0;
        int[] nArray2 = new int[n4];
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            nArray2[n] = nArray[n5];
            ++n;
            ++n6;
            ++n5;
        }
        return new LinearDomain(RelationKey.IsFree, false, null, nArray2);
    }

    public static LinearDomain unbounded(int n, int n2) {
        return new LinearDomain(RelationKey.IsFree, false, null, new int[]{n, n2});
    }

    public static LinearDomain unbounded(int n) {
        return new LinearDomain(RelationKey.IsFree, false, null, new int[]{n});
    }

    public static LinearDomain unbounded() {
        return new LinearDomain(RelationKey.IsFree, true, null, null);
    }
}

