/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.IndexError;
import mosek.fusion.LengthError;
import mosek.fusion.Set;
import mosek.fusion.WorkStack;

public final class ExprInner
extends BaseExpression {
    private double[] vcof;
    private long[] vsub;
    private Expression expr;

    public ExprInner(Expression expression, long[] lArray, double[] dArray) {
        super(new int[0]);
        this.expr = expression;
        this.vsub = lArray;
        this.vcof = dArray;
        if (lArray.length != dArray.length) {
            throw new LengthError("Mismatching lengths of vcof and vsub");
        }
        int[] nArray = expression.getShape();
        long l = Set.size(nArray);
        boolean bl = false;
        boolean bl2 = false;
        int n = 1;
        int n2 = lArray.length;
        for (int i = n; i < n2; ++i) {
            if (lArray[i] > lArray[i - 1]) continue;
            bl = true;
        }
        if (lArray.length > 0 && (lArray[0] < 0L || lArray[lArray.length - 1] > l)) {
            bl2 = true;
        }
        if (bl) {
            throw new IndexError("Unordered coefficcient subscripts");
        }
        if (bl2) {
            throw new IndexError("Coefficient subscript out of bounds");
        }
    }

    public ExprInner(Expression expression, double[] dArray) {
        this(expression, ExprInner.range(dArray.length), dArray);
        int[] nArray = expression.getShape();
        if (nArray.length != 1 || nArray[0] != dArray.length) {
            throw new DimensionError("Mismatching dimensions of operands");
        }
    }

    public ExprInner(Expression expression, int[][] nArray, double[] dArray) {
        this(expression, ExprInner.convert(expression.getShape(), nArray), dArray);
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        int n;
        int n2;
        int n3;
        this.expr.eval(workStack2, workStack, workStack3);
        workStack2.pop_expr();
        int n4 = workStack2.nd;
        int n5 = workStack2.nelem;
        int n6 = workStack2.nnz;
        int n7 = workStack2.ncodeatom;
        boolean bl = workStack2.hassp;
        int n8 = workStack2.shape_base;
        int n9 = workStack2.ptr_base;
        int n10 = workStack2.nidxs_base;
        int n11 = workStack2.sp_base;
        int n12 = workStack2.cof_base;
        int n13 = workStack2.code_base;
        int n14 = workStack2.codeptr_base;
        int n15 = workStack2.cconst_base;
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n16 = 0;
        if (bl) {
            n3 = 0;
            n2 = 0;
            while (n2 < this.vsub.length && n3 < n5) {
                if (lArray[n11 + n3] < this.vsub[n2]) {
                    ++n3;
                    continue;
                }
                if (lArray[n11 + n3] > this.vsub[n2]) {
                    ++n2;
                    continue;
                }
                n16 += nArray[n9 + n3 + 1] - nArray[n9 + n3];
                ++n2;
                ++n3;
            }
        } else {
            n3 = 0;
            n2 = this.vsub.length;
            for (n = n3; n < n2; ++n) {
                n16 += nArray[(int)((long)n9 + this.vsub[n] + 1L)] - nArray[(int)((long)n9 + this.vsub[n])];
            }
        }
        n3 = n7 > 0 ? n7 + 2 * n6 : 0;
        workStack.alloc_expr(0, 1, n16, false, n3);
        n2 = workStack.ptr_base;
        n = workStack.nidxs_base;
        int n17 = workStack.cof_base;
        int n18 = workStack.code_base;
        int n19 = workStack.codeptr_base;
        int n20 = workStack.cconst_base;
        int[] nArray2 = workStack.i32;
        long[] lArray2 = workStack.i64;
        double[] dArray2 = workStack.f64;
        nArray2[n2] = 0;
        nArray2[n2 + 1] = n16;
        if (n3 > 0) {
            nArray2[n19] = 0;
        }
        int n21 = 0;
        int n22 = 0;
        if (bl) {
            int n23 = 0;
            int n24 = 0;
            while (n24 < this.vsub.length && n23 < n5) {
                if (lArray[n11 + n23] < this.vsub[n24]) {
                    ++n23;
                    continue;
                }
                if (lArray[n11 + n23] > this.vsub[n24]) {
                    ++n24;
                    continue;
                }
                int n25 = nArray[n9 + n23];
                int n26 = nArray[n9 + n23 + 1];
                int n27 = n25;
                int n28 = n26;
                for (int i = n27; i < n28; ++i) {
                    lArray2[n + n22] = lArray[n10 + i];
                    dArray2[n17 + n22] = this.vcof[n24] * dArray[n12 + i];
                    if (n3 > 0) {
                        int n29 = nArray[n14 + i];
                        int n30 = nArray[n14 + i + 1];
                        for (int j = n29; j < n30; ++j) {
                            nArray2[n18 + n21] = nArray[n13 + j];
                            dArray2[n20 + n21] = dArray[n15 + j];
                            ++n21;
                        }
                        nArray2[n18 + n21] = 2;
                        dArray2[n20 + n21] = this.vcof[n24];
                        nArray2[n18 + ++n21] = 5;
                        nArray2[n19 + n22 + 1] = ++n21;
                    }
                    ++n22;
                }
                ++n24;
                ++n23;
            }
        } else {
            int n31 = 0;
            int n32 = this.vsub.length;
            for (int i = n31; i < n32; ++i) {
                int n33 = nArray[(int)((long)n9 + this.vsub[i])];
                int n34 = nArray[(int)((long)n9 + this.vsub[i] + 1L)];
                int n35 = n33;
                int n36 = n34;
                for (int j = n35; j < n36; ++j) {
                    lArray2[n + n22] = lArray[n10 + j];
                    dArray2[n17 + n22] = this.vcof[i] * dArray[n12 + j];
                    if (n3 > 0) {
                        int n37 = nArray[n14 + j];
                        int n38 = nArray[n14 + j + 1];
                        for (int k = n37; k < n38; ++k) {
                            nArray2[n18 + n21] = nArray[n13 + k];
                            dArray2[n20 + n21] = dArray[n15 + k];
                            ++n21;
                        }
                        nArray2[n18 + n21] = 2;
                        dArray2[n20 + n21] = this.vcof[i];
                        nArray2[n18 + ++n21] = 5;
                        nArray2[n19 + n22 + 1] = ++n21;
                    }
                    ++n22;
                }
            }
        }
    }

    private static long[] range(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = n;
        int n5 = n3 < n4 ? n4 - n3 : 0;
        long[] lArray = new long[n5];
        int n6 = n3;
        int n7 = 0;
        while (n7 < n5) {
            lArray[n2] = n6;
            ++n2;
            ++n7;
            ++n6;
        }
        return lArray;
    }

    private static long[] convert(int[] nArray, int[][] nArray2) {
        int n;
        int n2 = nArray.length;
        long[] lArray = new long[n2];
        lArray[n2 - 1] = 1L;
        int n3 = 1;
        int n4 = n2;
        for (n = n3; n < n4; ++n) {
            lArray[n2 - n - 1] = lArray[n2 - n] * (long)nArray[n2 - n];
        }
        long[] lArray2 = new long[nArray2.length];
        n4 = 0;
        n = nArray2.length;
        for (int i = n4; i < n; ++i) {
            int n5 = 0;
            int n6 = n2;
            for (int j = n5; j < n6; ++j) {
                int n7 = i;
                lArray2[n7] = lArray2[n7] + lArray[j] * (long)nArray2[i][j];
            }
        }
        return lArray2;
    }

    @Override
    public String toString() {
        return "ExprInner()";
    }
}

