/*
 * Decompiled with CFR 0.152.
 */
package mosek;

import java.io.Closeable;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import mosek.ArrayLengthException;
import mosek.Error;
import mosek.Stream;
import mosek.Task;
import mosek.feature;
import mosek.rescode;
import mosek.streamtype;
import mosek.transpose;
import mosek.uplo;

public final class Env
implements Closeable {
    private long native_env;
    private Stream[] stream;

    private void set(long l) {
        this.native_env = l;
    }

    public long get() {
        return this.native_env;
    }

    private static native long createEnv(String var0, boolean var1);

    private static native void deleteEnv(long var0);

    private native void attachStream(long var1, int var3);

    private native void detachStream(long var1, int var3);

    private void stream_func(int n, String string) {
        if (n < this.stream.length && this.stream[n] != null) {
            this.stream[n].print(string);
        }
    }

    public Env() {
        this(null, false);
    }

    public Env(String string) {
        this(string, false);
    }

    public Env(boolean bl) {
        this(null, bl);
    }

    public Env(String string, boolean bl) {
        this.native_env = Env.createEnv(string, bl);
        this.stream = new Stream[4];
    }

    public synchronized void set_Stream(streamtype streamtype2, Stream stream) {
        int n = streamtype2.getValue();
        this.detachStream(this.native_env, n);
        if (this.stream[n] != null) {
            this.stream[n] = null;
        }
        if (stream != null) {
            this.stream[n] = stream;
            this.attachStream(this.native_env, n);
        }
    }

    public void connectStream(Stream stream, streamtype streamtype2) {
        this.set_Stream(streamtype2, stream);
    }

    protected void finalize() {
        if (this.native_env != 0L) {
            this.cleanup();
            Env.deleteEnv(this.native_env);
            this.native_env = 0L;
        }
    }

    public void cleanup() {
        for (streamtype streamtype2 : streamtype.values()) {
            this.set_Stream(streamtype2, null);
        }
    }

    public void dispose() {
        this.finalize();
    }

    public static native boolean checkversion();

    private native void p_axpy(long var1, int var3, double var4, double[] var6, double[] var7);

    private native void p_checkinall(long var1);

    private native void p_checkinlicense(long var1, int var3);

    private native void p_checkoutlicense(long var1, int var3);

    private native void p_computesparsecholesky(long var1, int var3, int var4, double var5, int var7, int[] var8, long[] var9, int[] var10, double[] var11, int[][] var12, double[][] var13, int[][] var14, long[][] var15, long[] var16, int[][] var17, double[][] var18);

    private native void p_dot(long var1, int var3, double[] var4, double[] var5, double[] var6);

    private native void p_echointro(long var1, int var3);

    private native void p_expirylicenses(long var1, long[] var3);

    private native void p_gemm(long var1, int var3, int var4, int var5, int var6, int var7, double var8, double[] var10, double[] var11, double var12, double[] var14);

    private native void p_gemv(long var1, int var3, int var4, int var5, double var6, double[] var8, double[] var9, double var10, double[] var12);

    private static native void p_getcodedesc(int var0, byte[] var1, byte[] var2);

    private static native void p_getversion(int[] var0, int[] var1, int[] var2);

    private static native void p_licensecleanup();

    private native void p_linkfiletoenvstream(long var1, int var3, String var4, int var5);

    private native void p_optimizebatch(long var1, boolean var3, double var4, int var6, long var7, long[] var9, int[] var10, int[] var11);

    private native void p_potrf(long var1, int var3, int var4, double[] var5);

    private native void p_putlicensecode(long var1, int[] var3);

    private native void p_putlicensedebug(long var1, int var3);

    private native void p_putlicensepath(long var1, String var3);

    private native void p_putlicensewait(long var1, int var3);

    private native void p_resetexpirylicenses(long var1);

    private native void p_sparsetriangularsolvedense(long var1, int var3, int var4, int[] var5, long[] var6, long var7, int[] var9, double[] var10, double[] var11);

    private native void p_syeig(long var1, int var3, int var4, double[] var5, double[] var6);

    private native void p_syevd(long var1, int var3, int var4, double[] var5, double[] var6);

    private native void p_syrk(long var1, int var3, int var4, int var5, int var6, double var7, double[] var9, double var10, double[] var12);

    public synchronized void axpy(int n, double d, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument x in axpy is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("axpy", "x");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument y in axpy is null");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("axpy", "y");
        }
        this.p_axpy(this.native_env, n, d, dArray, dArray2);
    }

    public synchronized void checkinall() throws Error {
        this.p_checkinall(this.native_env);
    }

    public synchronized void checkinlicense(feature feature2) throws Error {
        this.p_checkinlicense(this.native_env, feature2.getValue());
    }

    public synchronized void checkoutlicense(feature feature2) throws Error {
        this.p_checkoutlicense(this.native_env, feature2.getValue());
    }

    public synchronized void computesparsecholesky(int n, int n2, double d, int[] nArray, long[] lArray, int[] nArray2, double[] dArray, int[][] nArray3, double[][] dArray2, int[][] nArray4, long[][] lArray2, long[] lArray3, int[][] nArray5, double[][] dArray3) throws Error {
        int n3 = -1;
        if (nArray != null) {
            if (n3 < 0) {
                n3 = nArray.length;
            } else if (n3 != nArray.length) {
                throw new ArrayLengthException("computesparsecholesky", "anzc");
            }
        }
        if (lArray != null) {
            if (n3 < 0) {
                n3 = lArray.length;
            } else if (n3 != lArray.length) {
                throw new ArrayLengthException("computesparsecholesky", "aptrc");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument anzc in computesparsecholesky is null");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument aptrc in computesparsecholesky is null");
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument asubc in computesparsecholesky is null");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument avalc in computesparsecholesky is null");
        }
        if (nArray3 == null) {
            throw new NullPointerException("Argument perm in computesparsecholesky is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument diag in computesparsecholesky is null");
        }
        if (nArray4 == null) {
            throw new NullPointerException("Argument lnzc in computesparsecholesky is null");
        }
        if (lArray2 == null) {
            throw new NullPointerException("Argument lptrc in computesparsecholesky is null");
        }
        long[] lArray4 = lArray3;
        if (lArray3.length != 1) {
            throw new ArrayLengthException("computesparsecholesky", "lensubnval");
        }
        if (nArray5 == null) {
            throw new NullPointerException("Argument lsubc in computesparsecholesky is null");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument lvalc in computesparsecholesky is null");
        }
        this.p_computesparsecholesky(this.native_env, n, n2, d, n3, nArray, lArray, nArray2, dArray, nArray3, dArray2, nArray4, lArray2, lArray4, nArray5, dArray3);
    }

    public synchronized void dot(int n, double[] dArray, double[] dArray2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument x in dot is null");
        }
        if (dArray != null && dArray.length < n) {
            throw new ArrayLengthException("dot", "x");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument y in dot is null");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("dot", "y");
        }
        double[] dArray4 = dArray3;
        if (dArray3.length != 1) {
            throw new ArrayLengthException("dot", "xty");
        }
        this.p_dot(this.native_env, n, dArray, dArray2, dArray4);
    }

    public synchronized void echointro(int n) throws Error {
        this.p_echointro(this.native_env, n);
    }

    public synchronized void expirylicenses(long[] lArray) throws Error {
        long[] lArray2 = lArray;
        if (lArray.length != 1) {
            throw new ArrayLengthException("expirylicenses", "expiry");
        }
        this.p_expirylicenses(this.native_env, lArray2);
    }

    public synchronized void gemm(transpose transpose2, transpose transpose3, int n, int n2, int n3, double d, double[] dArray, double[] dArray2, double d2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in gemm is null");
        }
        if (dArray != null && dArray.length < n * n3) {
            throw new ArrayLengthException("gemm", "a");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument b in gemm is null");
        }
        if (dArray2 != null && dArray2.length < n3 * n2) {
            throw new ArrayLengthException("gemm", "b");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument c in gemm is null");
        }
        if (dArray3 != null && dArray3.length < n * n2) {
            throw new ArrayLengthException("gemm", "c");
        }
        this.p_gemm(this.native_env, transpose2.getValue(), transpose3.getValue(), n, n2, n3, d, dArray, dArray2, d2, dArray3);
    }

    public synchronized void gemv(transpose transpose2, int n, int n2, double d, double[] dArray, double[] dArray2, double d2, double[] dArray3) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in gemv is null");
        }
        if (dArray != null && dArray.length < n2 * n) {
            throw new ArrayLengthException("gemv", "a");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument x in gemv is null");
        }
        if (dArray2 != null && dArray2.length < (transpose2 == transpose.no ? n2 : n)) {
            throw new ArrayLengthException("gemv", "x");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Argument y in gemv is null");
        }
        if (dArray3 != null && dArray3.length < (transpose2 == transpose.no ? n : n2)) {
            throw new ArrayLengthException("gemv", "y");
        }
        this.p_gemv(this.native_env, transpose2.getValue(), n, n2, d, dArray, dArray2, d2, dArray3);
    }

    public static void getcodedesc(rescode rescode2, StringBuffer stringBuffer, StringBuffer stringBuffer2) throws Error {
        int n;
        int n2;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[1024];
        Env.p_getcodedesc(rescode2.getValue(), byArray, byArray2);
        for (n2 = 0; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        String string = null;
        try {
            string = new String(byArray, 0, n2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer.append(string);
        for (n = 0; n < byArray2.length && byArray2[n] != 0; ++n) {
        }
        String string2 = null;
        try {
            string2 = new String(byArray2, 0, n, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuffer2.append(string2);
    }

    public static void getversion(int[] nArray, int[] nArray2, int[] nArray3) throws Error {
        int[] nArray4 = nArray;
        if (nArray.length != 1) {
            throw new ArrayLengthException("getversion", "major");
        }
        int[] nArray5 = nArray2;
        if (nArray2.length != 1) {
            throw new ArrayLengthException("getversion", "minor");
        }
        int[] nArray6 = nArray3;
        if (nArray3.length != 1) {
            throw new ArrayLengthException("getversion", "revision");
        }
        Env.p_getversion(nArray4, nArray5, nArray6);
    }

    public static void licensecleanup() throws Error {
        Env.p_licensecleanup();
    }

    public synchronized void linkfiletostream(streamtype streamtype2, String string, int n) throws Error {
        this.p_linkfiletoenvstream(this.native_env, streamtype2.getValue(), string, n);
    }

    public synchronized void optimizebatch(boolean bl, double d, int n, Task[] taskArray, rescode[] rescodeArray, rescode[] rescodeArray2) throws Error {
        int n2;
        long[] lArray;
        long l = -1L;
        if (taskArray != null) {
            if (l < 0L) {
                l = taskArray.length;
            } else if (l != (long)taskArray.length) {
                throw new ArrayLengthException("optimizebatch", "task");
            }
        }
        if (taskArray == null) {
            throw new NullPointerException("Argument task in optimizebatch is null");
        }
        if (taskArray != null && (long)taskArray.length < l) {
            throw new ArrayLengthException("optimizebatch", "task");
        }
        long[] lArray2 = lArray = taskArray != null ? new long[taskArray.length] : null;
        if (taskArray != null) {
            for (int i = 0; i < taskArray.length; ++i) {
                if (taskArray[i] == null) {
                    throw new NullPointerException("Element in argument task in optimizebatch is null");
                }
                lArray[i] = taskArray[i].native_task;
            }
        }
        if (rescodeArray == null) {
            throw new NullPointerException("Argument trmcode in optimizebatch is null");
        }
        if (rescodeArray != null && (long)rescodeArray.length < l) {
            throw new ArrayLengthException("optimizebatch", "trmcode");
        }
        int[] nArray = null;
        if (rescodeArray != null) {
            nArray = new int[rescodeArray.length];
        }
        if (rescodeArray2 == null) {
            throw new NullPointerException("Argument rcode in optimizebatch is null");
        }
        if (rescodeArray2 != null && (long)rescodeArray2.length < l) {
            throw new ArrayLengthException("optimizebatch", "rcode");
        }
        int[] nArray2 = null;
        if (rescodeArray2 != null) {
            nArray2 = new int[rescodeArray2.length];
        }
        this.p_optimizebatch(this.native_env, bl, d, n, l, lArray, nArray, nArray2);
        if (rescodeArray != null) {
            for (n2 = 0; n2 < rescodeArray.length; ++n2) {
                rescodeArray[n2] = rescode.fromValue(nArray[n2]);
            }
        }
        if (rescodeArray2 != null) {
            for (n2 = 0; n2 < rescodeArray2.length; ++n2) {
                rescodeArray2[n2] = rescode.fromValue(nArray2[n2]);
            }
        }
    }

    public synchronized void potrf(uplo uplo2, int n, double[] dArray) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in potrf is null");
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("potrf", "a");
        }
        this.p_potrf(this.native_env, uplo2.getValue(), n, dArray);
    }

    public synchronized void putlicensecode(int[] nArray) throws Error {
        if (nArray != null && nArray.length < 21) {
            throw new ArrayLengthException("putlicensecode", "code");
        }
        this.p_putlicensecode(this.native_env, nArray);
    }

    public synchronized void putlicensedebug(int n) throws Error {
        this.p_putlicensedebug(this.native_env, n);
    }

    public synchronized void putlicensepath(String string) throws Error {
        if (string == null) {
            throw new NullPointerException("Argument licensepath in putlicensepath is null");
        }
        this.p_putlicensepath(this.native_env, string);
    }

    public synchronized void putlicensewait(int n) throws Error {
        this.p_putlicensewait(this.native_env, n);
    }

    public synchronized void resetexpirylicenses() throws Error {
        this.p_resetexpirylicenses(this.native_env);
    }

    public synchronized void sparsetriangularsolvedense(transpose transpose2, int[] nArray, long[] lArray, int[] nArray2, double[] dArray, double[] dArray2) throws Error {
        int n = -1;
        if (nArray != null) {
            if (n < 0) {
                n = nArray.length;
            } else if (n != nArray.length) {
                throw new ArrayLengthException("sparsetriangularsolvedense", "lnzc");
            }
        }
        if (lArray != null) {
            if (n < 0) {
                n = lArray.length;
            } else if (n != lArray.length) {
                throw new ArrayLengthException("sparsetriangularsolvedense", "lptrc");
            }
        }
        if (dArray2 != null) {
            if (n < 0) {
                n = dArray2.length;
            } else if (n != dArray2.length) {
                throw new ArrayLengthException("sparsetriangularsolvedense", "b");
            }
        }
        if (nArray == null) {
            throw new NullPointerException("Argument lnzc in sparsetriangularsolvedense is null");
        }
        if (nArray != null && nArray.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lnzc");
        }
        if (lArray == null) {
            throw new NullPointerException("Argument lptrc in sparsetriangularsolvedense is null");
        }
        if (lArray != null && lArray.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lptrc");
        }
        long l = -1L;
        if (dArray != null) {
            if (l < 0L) {
                l = dArray.length;
            } else if (l != (long)dArray.length) {
                throw new ArrayLengthException("sparsetriangularsolvedense", "lvalc");
            }
        }
        if (nArray2 != null) {
            if (l < 0L) {
                l = nArray2.length;
            } else if (l != (long)nArray2.length) {
                throw new ArrayLengthException("sparsetriangularsolvedense", "lsubc");
            }
        }
        if (nArray2 == null) {
            throw new NullPointerException("Argument lsubc in sparsetriangularsolvedense is null");
        }
        if (nArray2 != null && (long)nArray2.length < l) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lsubc");
        }
        if (dArray == null) {
            throw new NullPointerException("Argument lvalc in sparsetriangularsolvedense is null");
        }
        if (dArray != null && (long)dArray.length < l) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "lvalc");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument b in sparsetriangularsolvedense is null");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("sparsetriangularsolvedense", "b");
        }
        this.p_sparsetriangularsolvedense(this.native_env, transpose2.getValue(), n, nArray, lArray, l, nArray2, dArray, dArray2);
    }

    public synchronized void syeig(uplo uplo2, int n, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in syeig is null");
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("syeig", "a");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument w in syeig is null");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("syeig", "w");
        }
        this.p_syeig(this.native_env, uplo2.getValue(), n, dArray, dArray2);
    }

    public synchronized void syevd(uplo uplo2, int n, double[] dArray, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in syevd is null");
        }
        if (dArray != null && dArray.length < n * n) {
            throw new ArrayLengthException("syevd", "a");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument w in syevd is null");
        }
        if (dArray2 != null && dArray2.length < n) {
            throw new ArrayLengthException("syevd", "w");
        }
        this.p_syevd(this.native_env, uplo2.getValue(), n, dArray, dArray2);
    }

    public synchronized void syrk(uplo uplo2, transpose transpose2, int n, int n2, double d, double[] dArray, double d2, double[] dArray2) throws Error {
        if (dArray == null) {
            throw new NullPointerException("Argument a in syrk is null");
        }
        if (dArray != null && dArray.length < n * n2) {
            throw new ArrayLengthException("syrk", "a");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Argument c in syrk is null");
        }
        if (dArray2 != null && dArray2.length < n * n) {
            throw new ArrayLengthException("syrk", "c");
        }
        this.p_syrk(this.native_env, uplo2.getValue(), transpose2.getValue(), n, n2, d, dArray, d2, dArray2);
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static void reload_library() {
        String string = "mosekjava10_2";
        try {
            String string2;
            String string3 = System.getProperty("os.name");
            String string4 = System.getProperty("os.arch");
            String string5 = null;
            String string6 = null;
            if (string3.contains("OS X")) {
                string5 = ".jnilib";
                string6 = "lib";
            } else if (string3.contains("Windows")) {
                string5 = ".dll";
                string6 = "";
            } else {
                string5 = ".so";
                string6 = "lib";
            }
            File file = new File(URLDecoder.decode(Env.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
            File file2 = file.getParentFile();
            if (string3.contains("Windows")) {
                string2 = null;
                string2 = string4 == "i386" ? new File(file2, "mosek/*{version:MAJOR}*/_/*{version:MINOR}*/.dll").getPath() : new File(file2, "mosek64_/*{version:MAJOR}*/_/*{version:MINOR}*/.dll").getPath();
                System.load(string2);
            }
            string2 = new File(file2, string6 + string + string5).getPath();
            System.load(string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.loadLibrary(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    static {
        try {
            Env.checkversion();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Env.reload_library();
        }
    }
}

