/*
 * Decompiled with CFR 0.152.
 */
package mosek.fusion;

import mosek.fusion.BaseExpression;
import mosek.fusion.DimensionError;
import mosek.fusion.Expression;
import mosek.fusion.LengthError;
import mosek.fusion.UnexpectedError;
import mosek.fusion.Utils.StringBuffer;
import mosek.fusion.WorkStack;

public final class ExprMulRight
extends BaseExpression {
    private Expression expr;
    private double[] mval;
    private int[] msubj;
    private int[] msubi;
    private int mdim1;
    private int mdim0;

    protected ExprMulRight(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression, int n3) {
        super(ExprMulRight.computeshape(n2, expression.getShape()));
        this.mdim0 = n;
        this.mdim1 = n2;
        this.msubi = nArray;
        this.msubj = nArray2;
        this.mval = dArray;
        this.expr = expression;
    }

    public ExprMulRight(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        this(n, n2, nArray, nArray2, dArray, expression, ExprMulRight.validate(n, n2, nArray, nArray2, dArray, expression));
    }

    @Override
    public void eval(WorkStack workStack, WorkStack workStack2, WorkStack workStack3) {
        boolean bl;
        this.expr.eval(workStack2, workStack, workStack3);
        workStack2.pop_expr();
        int[] nArray = workStack2.i32;
        long[] lArray = workStack2.i64;
        double[] dArray = workStack2.f64;
        int n = workStack2.nd;
        if (n != 2) {
            throw new DimensionError("Invalid operator shape for multiplication");
        }
        int n2 = workStack2.nelem;
        int n3 = workStack2.nnz;
        int n4 = workStack2.ncodeatom;
        boolean bl2 = workStack2.hassp;
        int n5 = workStack2.ptr_base;
        int n6 = workStack2.shape_base;
        int n7 = workStack2.sp_base;
        int n8 = workStack2.nidxs_base;
        int n9 = workStack2.cof_base;
        int n10 = workStack2.codeptr_base;
        int n11 = workStack2.code_base;
        int n12 = workStack2.cconst_base;
        int n13 = nArray[n6];
        int n14 = nArray[n6 + 1];
        int n15 = this.mval.length;
        boolean bl3 = bl = (long)n15 < (long)this.mdim0 * (long)this.mdim1;
        if (bl) {
            int n16;
            int n17 = workStack3.alloci32(this.mdim1 + 1);
            int n18 = workStack3.alloci32(n15);
            int n19 = workStack3.alloci32(n13 + 1);
            int[] nArray2 = workStack3.i32;
            int n20 = 0;
            int n21 = this.mdim1 + 1;
            for (n16 = n20; n16 < n21; ++n16) {
                nArray2[n17 + n16] = 0;
            }
            n20 = 0;
            n21 = n15;
            for (n16 = n20; n16 < n21; ++n16) {
                int n22 = n17 + this.msubj[n16] + 1;
                nArray2[n22] = nArray2[n22] + 1;
            }
            n20 = 0;
            n21 = this.mdim1;
            for (n16 = n20; n16 < n21; ++n16) {
                int n23 = n17 + n16 + 1;
                nArray2[n23] = nArray2[n23] + nArray2[n17 + n16];
            }
            n20 = 0;
            n21 = n15;
            for (n16 = n20; n16 < n21; ++n16) {
                nArray2[n18 + nArray2[n17 + this.msubj[n16]]] = n16;
                int n24 = n17 + this.msubj[n16];
                nArray2[n24] = nArray2[n24] + 1;
            }
            n20 = 0;
            n21 = this.mdim1;
            for (n16 = n20; n16 < n21; ++n16) {
                nArray2[n17 + this.mdim1 - n16] = nArray2[n17 + this.mdim1 - n16 - 1];
            }
            nArray2[n17] = 0;
            n20 = 0;
            n21 = n13 + 1;
            for (n16 = n20; n16 < n21; ++n16) {
                nArray2[n19 + n16] = 0;
            }
            if (bl2) {
                int n25;
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31;
                n20 = 0;
                n21 = 0;
                long l = 0L;
                int n32 = 0;
                while (n32 < n2) {
                    long l2 = lArray[n7 + n32] / (long)n14;
                    n31 = n32++;
                    while (n32 < n2 && lArray[n7 + n32] / (long)n14 == l2) {
                        ++n32;
                    }
                    n30 = n32;
                    n29 = 0;
                    while (n29 < n15) {
                        n28 = this.msubj[nArray2[n18 + n29]];
                        n27 = n29++;
                        while (n29 < n15 && this.msubj[nArray2[n18 + n29]] == n28) {
                            ++n29;
                        }
                        n26 = n29;
                        boolean bl4 = false;
                        int n33 = n27;
                        int n34 = n31;
                        while (n34 < n30 && n33 < n26) {
                            n25 = nArray2[n18 + n33];
                            if (lArray[n7 + n34] % (long)n14 < (long)this.msubi[n25]) {
                                ++n34;
                                continue;
                            }
                            if (lArray[n7 + n34] % (long)n14 > (long)this.msubi[n25]) {
                                ++n33;
                                continue;
                            }
                            if (this.mval[n25] > 0.0 || 0.0 < this.mval[n25]) {
                                l += (long)(nArray[n5 + n34 + 1] - nArray[n5 + n34]);
                                if (n4 > 0) {
                                    n20 += nArray[n10 + nArray[n5 + n34 + 1]] - nArray[n10 + nArray[n5 + n34]] + 2 * (nArray[n5 + n34 + 1] - nArray[n5 + n34]);
                                }
                                bl4 = true;
                            }
                            ++n34;
                            ++n33;
                        }
                        if (!bl4) continue;
                        ++n21;
                    }
                }
                n32 = n21 < n13 * this.mdim1 ? 1 : 0;
                workStack.alloc_expr(2, n21, (int)l, n32 != 0, n20);
                int n35 = workStack.ptr_base;
                int n36 = workStack.nidxs_base;
                n31 = n32 != 0 ? workStack.sp_base : workStack.alloci64(n21);
                n30 = workStack.cof_base;
                n29 = workStack.shape_base;
                n28 = workStack.codeptr_base;
                n27 = workStack.code_base;
                n26 = workStack.cconst_base;
                int[] nArray3 = workStack.i32;
                long[] lArray2 = workStack.i64;
                double[] dArray2 = workStack.f64;
                nArray3[n29] = n13;
                nArray3[n29 + 1] = this.mdim1;
                nArray3[n35] = 0;
                if (n20 > 0) {
                    nArray3[n28] = 0;
                }
                n25 = 0;
                int n37 = 0;
                int n38 = 0;
                int n39 = 0;
                while (n25 < n2) {
                    long l3 = lArray[n7 + n25] / (long)n14;
                    int n40 = n25++;
                    while (n25 < n2 && lArray[n7 + n25] / (long)n14 == l3) {
                        ++n25;
                    }
                    int n41 = n25;
                    int n42 = 0;
                    while (n42 < n15) {
                        int n43 = this.msubj[nArray2[n18 + n42]];
                        int n44 = n42++;
                        while (n42 < n15 && this.msubj[nArray2[n18 + n42]] == n43) {
                            ++n42;
                        }
                        int n45 = n42;
                        int n46 = n44;
                        int n47 = n40;
                        boolean bl5 = false;
                        while (n47 < n41 && n46 < n45) {
                            int n48 = nArray2[n18 + n46];
                            if (lArray[n7 + n47] % (long)n14 < (long)this.msubi[n48]) {
                                ++n47;
                                continue;
                            }
                            if (lArray[n7 + n47] % (long)n14 > (long)this.msubi[n48]) {
                                ++n46;
                                continue;
                            }
                            if (this.mval[n48] > 0.0 || 0.0 < this.mval[n48]) {
                                int n49 = nArray[n5 + n47];
                                int n50 = nArray[n5 + n47 + 1];
                                for (int i = n49; i < n50; ++i) {
                                    lArray2[n36 + n39] = lArray[n8 + i];
                                    dArray2[n30 + n39] = dArray[n9 + i] * this.mval[n48];
                                    if (n4 > 0) {
                                        int n51 = nArray[n10 + i];
                                        int n52 = nArray[n10 + i + 1];
                                        for (int j = n51; j < n52; ++j) {
                                            nArray3[n27 + n37] = nArray[n11 + j];
                                            dArray2[n26 + n37] = dArray[n12 + j];
                                            ++n37;
                                        }
                                        nArray3[n27 + n37] = 2;
                                        dArray2[n26 + n37] = this.mval[n46];
                                        nArray3[n27 + ++n37] = 5;
                                        nArray3[n28 + n39 + 1] = ++n37;
                                    }
                                    ++n39;
                                }
                                bl5 = true;
                            }
                            ++n47;
                            ++n46;
                        }
                        if (!bl5) continue;
                        nArray3[n35 + n38 + 1] = n39;
                        lArray2[n31 + n38] = l3 * (long)this.mdim1 + (long)n43;
                        ++n38;
                    }
                }
                if ((long)n39 != l) {
                    throw new UnexpectedError("Internal: invalid nnz");
                }
                if (n38 != n21) {
                    throw new UnexpectedError("Internal: invalid nnz");
                }
                if ((long)nArray3[n35 + n21] != l) {
                    throw new UnexpectedError("Internal: invalid nnz");
                }
                if (n32 == 0) {
                    workStack.popi64(n21);
                }
            } else {
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                int n59;
                n20 = 0;
                n21 = n13 * this.mdim1;
                n16 = 0;
                int n60 = 0;
                int n61 = n13;
                for (n59 = n60; n59 < n61; ++n59) {
                    n58 = 0;
                    n57 = this.mdim1;
                    for (n56 = n58; n56 < n57; ++n56) {
                        n55 = nArray2[n17 + n56];
                        n54 = nArray2[n17 + n56 + 1];
                        for (n53 = n55; n53 < n54; ++n53) {
                            int n62 = nArray2[n18 + n53];
                            int n63 = n59 * n14 + this.msubi[n62];
                            n16 += nArray[n5 + n63 + 1] - nArray[n5 + n63];
                            if (n4 <= 0) continue;
                            n20 += nArray[n10 + nArray[n5 + n63 + 1]] - nArray[n10 + nArray[n5 + n63]] + 2 * (nArray[n5 + n63 + 1] - nArray[n5 + n63]);
                        }
                    }
                }
                int n64 = n60 = n21 < n13 * this.mdim1 ? 1 : 0;
                if (n16 > Integer.MAX_VALUE) {
                    throw new LengthError("Maximum number of nonzeros exceeded in multiplication");
                }
                workStack.alloc_expr(2, n21, n16, n60 != 0, n20);
                n61 = workStack.shape_base;
                n59 = workStack.ptr_base;
                n58 = workStack.nidxs_base;
                n57 = n60 != 0 ? workStack.sp_base : workStack.alloci64(n21);
                n56 = workStack.cof_base;
                n55 = workStack.code_base;
                n54 = workStack.codeptr_base;
                n53 = workStack.cconst_base;
                int[] nArray4 = workStack.i32;
                long[] lArray3 = workStack.i64;
                double[] dArray3 = workStack.f64;
                nArray4[n61] = n13;
                nArray4[n61 + 1] = this.mdim1;
                int n65 = 0;
                int n66 = 0;
                int n67 = 0;
                nArray4[n59] = 0;
                if (n20 > 0) {
                    nArray4[n54] = 0;
                }
                int n68 = 0;
                int n69 = n13;
                for (int i = n68; i < n69; ++i) {
                    int n70 = 0;
                    int n71 = this.mdim1;
                    for (int j = n70; j < n71; ++j) {
                        int n72 = i * n14;
                        int n73 = nArray2[n17 + j];
                        int n74 = nArray2[n17 + j + 1];
                        for (int k = n73; k < n74; ++k) {
                            int n75;
                            int n76;
                            int n77;
                            int n78 = nArray2[n18 + k];
                            int n79 = n72 + this.msubi[n78];
                            if (n20 == 0) {
                                n77 = nArray[n5 + n79];
                                n76 = nArray[n5 + n79 + 1];
                                for (n75 = n77; n75 < n76; ++n75) {
                                    lArray3[n58 + n67] = lArray[n8 + n75];
                                    dArray3[n56 + n67] = dArray[n9 + n75] * this.mval[n78];
                                    ++n67;
                                }
                                continue;
                            }
                            n77 = nArray[n5 + n79];
                            n76 = nArray[n5 + n79 + 1];
                            for (n75 = n77; n75 < n76; ++n75) {
                                lArray3[n58 + n67] = lArray[n8 + n75];
                                dArray3[n56 + n67] = dArray[n9 + n75] * this.mval[n78];
                                int n80 = nArray[n10 + n75];
                                int n81 = nArray[n10 + n75 + 1];
                                for (int i2 = n80; i2 < n81; ++i2) {
                                    nArray4[n55 + n65] = nArray[n11 + i2];
                                    dArray3[n53 + n65] = dArray[n12 + i2];
                                    ++n65;
                                }
                                nArray4[n55 + n65] = 2;
                                dArray3[n53 + n65] = this.mval[n78];
                                nArray4[n55 + ++n65] = 5;
                                nArray4[n54 + n67 + 1] = ++n65;
                                ++n67;
                            }
                        }
                        nArray4[n59 + n66 + 1] = n67;
                        lArray3[n57 + n66] = i * this.mdim1 + j;
                        ++n66;
                    }
                }
                if (n60 == 0) {
                    workStack.popi64(n21);
                }
            }
            workStack3.clear();
        } else {
            int n82;
            int n83 = workStack3.alloci32(n13 + 1);
            int[] nArray5 = workStack3.i32;
            int n84 = 0;
            int n85 = n13 + 1;
            for (n82 = n84; n82 < n85; ++n82) {
                nArray5[n83 + n82] = 0;
            }
            long l = (long)n3 * (long)this.mdim1;
            n82 = n13 * this.mdim1;
            int n86 = n4 * this.mdim1 + (n4 == 0 ? 0 : (int)l * 2);
            boolean bl6 = false;
            int n87 = 2;
            if (l > Integer.MAX_VALUE) {
                throw new LengthError("Maximum number of nonzeros exceeded in multiplication");
            }
            workStack.alloc_expr(n87, n82, (int)l, bl6, n86);
            int[] nArray6 = workStack.i32;
            long[] lArray4 = workStack.i64;
            double[] dArray4 = workStack.f64;
            int n88 = workStack.shape_base;
            int n89 = workStack.ptr_base;
            int n90 = workStack.nidxs_base;
            int n91 = workStack.sp_base;
            int n92 = workStack.cof_base;
            int n93 = workStack.code_base;
            int n94 = workStack.codeptr_base;
            int n95 = workStack.cconst_base;
            nArray6[n88] = n13;
            nArray6[n88 + 1] = this.mdim1;
            int n96 = 0;
            int n97 = 0;
            int n98 = 0;
            nArray6[n89] = 0;
            if (n86 > 0) {
                nArray6[n94] = 0;
            }
            if (bl2) {
                int n99;
                int n100 = 0;
                int n101 = n2;
                for (n99 = n100; n99 < n101; ++n99) {
                    int n102 = (int)((long)n83 + lArray[n7 + n99] / (long)n14 + 1L);
                    nArray5[n102] = nArray5[n102] + 1;
                }
                n100 = 0;
                n101 = n13;
                for (n99 = n100; n99 < n101; ++n99) {
                    int n103 = n83 + n99 + 1;
                    nArray5[n103] = nArray5[n103] + nArray5[n83 + n99];
                }
                n100 = 0;
                n101 = n13;
                for (n99 = n100; n99 < n101; ++n99) {
                    int n104 = 0;
                    int n105 = this.mdim1;
                    for (int i = n104; i < n105; ++i) {
                        int n106 = nArray5[n83 + n99];
                        int n107 = nArray5[n83 + n99 + 1];
                        for (int j = n106; j < n107; ++j) {
                            long l4 = (long)i + lArray[n7 + j] % (long)n14 * (long)this.mdim1;
                            int n108 = nArray[n5 + j];
                            int n109 = nArray[n5 + j + 1];
                            for (int k = n108; k < n109; ++k) {
                                lArray4[n90 + n97] = lArray[n8 + k];
                                dArray4[n92 + n97] = dArray[n9 + k] * this.mval[(int)l4];
                                if (n4 > 0) {
                                    int n110 = nArray[n10 + k];
                                    int n111 = nArray[n10 + k + 1];
                                    for (int i3 = n110; i3 < n111; ++i3) {
                                        nArray6[n93 + n96] = nArray[n11 + i3];
                                        dArray4[n95 + n96] = dArray[n12 + i3];
                                        ++n96;
                                    }
                                    nArray6[n93 + n96] = 2;
                                    dArray4[n95 + n96] = this.mval[(int)l4];
                                    nArray6[n93 + ++n96] = 5;
                                    nArray6[n94 + n97 + 1] = ++n96;
                                }
                                ++n97;
                            }
                        }
                        nArray6[n89 + n98 + 1] = n97;
                        ++n98;
                    }
                }
                if ((long)n97 != l) {
                    throw new UnexpectedError("Internal: Invalid num nonzeros");
                }
                if (n98 != n82) {
                    throw new UnexpectedError("Internal: Invalid num elements");
                }
                if (n96 != n86) {
                    throw new UnexpectedError("Internal: Invalid num code atoms");
                }
            } else {
                int n112 = 0;
                int n113 = n13;
                for (int i = n112; i < n113; ++i) {
                    int n114 = 0;
                    int n115 = this.mdim1;
                    for (int j = n114; j < n115; ++j) {
                        int n116 = 0;
                        int n117 = n14;
                        for (int k = n116; k < n117; ++k) {
                            int n118 = i * n14 + k;
                            int n119 = j + k * this.mdim1;
                            int n120 = nArray[n5 + n118];
                            int n121 = nArray[n5 + n118 + 1];
                            for (int i4 = n120; i4 < n121; ++i4) {
                                lArray4[n90 + n97] = lArray[n8 + i4];
                                dArray4[n92 + n97] = dArray[n9 + i4] * this.mval[n119];
                                if (n4 > 0) {
                                    int n122 = nArray[n10 + i4];
                                    int n123 = nArray[n10 + i4 + 1];
                                    for (int i5 = n122; i5 < n123; ++i5) {
                                        nArray6[n93 + n96] = nArray[n11 + i5];
                                        dArray4[n95 + n96] = dArray[n12 + i5];
                                        ++n96;
                                    }
                                    nArray6[n93 + n96] = 2;
                                    dArray4[n95 + n96] = this.mval[n119];
                                    nArray6[n93 + ++n96] = 5;
                                    nArray6[n94 + n97 + 1] = ++n96;
                                }
                                ++n97;
                            }
                        }
                        nArray6[n89 + n98 + 1] = n97;
                        ++n98;
                    }
                }
            }
            workStack3.clear();
        }
    }

    private static int[] computeshape(int n, int[] nArray) {
        if (nArray.length == 1) {
            return new int[]{1, n};
        }
        return new int[]{nArray[0], n};
    }

    private static int validate(int n, int n2, int[] nArray, int[] nArray2, double[] dArray, Expression expression) {
        int n3;
        int[] nArray3 = expression.getShape();
        if (nArray3.length != 2) {
            throw new DimensionError("Invalid operand dimensions");
        }
        int n4 = nArray3[0];
        int n5 = nArray3[1];
        if (n < 0 || n2 < 0 || n4 < 0 || n5 < 0) {
            throw new DimensionError("Invalid operand dimensions");
        }
        if (n != n5) {
            throw new DimensionError("Mismatching operand dimensions");
        }
        if (nArray.length != nArray2.length || nArray.length != dArray.length) {
            throw new LengthError("Invalid matrix data");
        }
        int n6 = nArray.length;
        boolean bl = false;
        int n7 = 0;
        int n8 = n6;
        for (n3 = n7; n3 < n8; ++n3) {
            bl = bl || nArray[n3] < 0 || nArray[n3] >= n || nArray2[n3] < 0 || nArray2[n3] >= n2;
        }
        if (bl) {
            throw new LengthError("Invalid matrix data");
        }
        bl = false;
        n7 = 0;
        n8 = n6 - 1;
        for (n3 = n7; n3 < n8; ++n3) {
            bl = bl || nArray[n3] > nArray[n3 + 1] || nArray[n3] == nArray[n3 + 1] && nArray2[n3] >= nArray2[n3 + 1];
        }
        if (bl) {
            throw new LengthError("Unsorted matrix data");
        }
        return 1;
    }

    @Override
    public String toString() {
        return new StringBuffer().a("ExprMulRight(M,").a(this.expr.toString()).a(")").toString();
    }
}

