function [x, risk, ret] = sharpe(G, rT, w0, rf) 
% Computes the largest Sharpe ratio (assuming no short-selling), 
%
%   minimize    f
%   subject to  (r-e*rf)'*y = 1
%               G*y  = g,  ||g||_2 <= f               
%               sum(y) = t*sum(w0)
%               t >= 0
%               y >= 0
%
% or equivalently 
% 
%   minimize      f
%   subject to  [ (r-e*rf)'  0   0      0      ] [ y ]   [ 1 ] 
%               [    G       0  -I      0      ]*[ f ] = [ 0 ] 
%               [    e'      0   0   -sum(w0)  ] [ g ]   [ 0 ]    
%                                                [ t ]
%                 t     >= 0
%                 y     >= 0
%               ||g||_2 <= f

n = length(rT);
p = size(G,1);

prob.a = sparse([ rT-rf, zeros(1, 1+p+1); 
                  G, zeros(p,1), -eye(p), zeros(p,1);    
                  ones(1,n), zeros(1,1+p), -sum(w0)]);
prob.c = [zeros(n,1); 1; zeros(p+1,1)];
prob.cones{1}.type = 'MSK_CT_QUAD';
prob.cones{1}.sub = [n+1:n+1+p];
b = [1; zeros(p,1); 0];
prob.blc = b;
prob.buc = b;
prob.blx = [zeros(n,1); -inf*ones(1+p,1); 0];

[err,res]=mosekopt('minimize',prob);
y    = res.sol.itr.xx(1:n);
f    = res.sol.itr.xx(n+1);
g    = res.sol.itr.xx(n+1+[1:p]);
t    = res.sol.itr.xx(n+1+p+1);
x    = y/t - w0;
risk = f/t;
ret  = rT*(x+w0);

