function [x, risk] = minrisk(G, rT, t, w0) 
% Minimum risk Markowitz portfolio selection (assuming no short-selling)
%
%   minimize    f
%   subject to  r'*(w0 + x) = t
%               G*(w0 + x) = g,  ||g||_2 < f
%               sum(x) = 0.
% or equivalently 
% 
%   minimize     f
%   subject to  [ r'  0   0 ] [ x ]   [ t-r'*w0 ] 
%               [ G   0  -I ]*[ f ] = [  -G*w0  ] 
%               [ e'  0   0 ] [ g ]   [    0    ]    
%               ||g||_2 <= f

n = length(rT);
p = size(G,1);

prob.a = sparse([ rT, zeros(1, 1+p); 
                  G, zeros(p,1), -eye(p);    
                  ones(1,n), zeros(1,1+p)]);
prob.c = [ zeros(n,1); 1; zeros(p,1)];
prob.cones{1}.type = 'MSK_CT_QUAD';
prob.cones{1}.sub = [n+1:n+1+p];
b = [ t - rT*w0; -G*w0; 0 ];
prob.blc = b;
prob.buc = b;
prob.blx = [-w0; -inf*ones(1+p,1)];

[err,res]=mosekopt('minimize',prob);

x    = res.sol.itr.xx(1:n);
risk = res.sol.itr.xx(n+1);

