clear; close all;

% Read expected returns and covariance factor
rT = csvread('../data/sp500-ret.csv');
G  = csvread('../data/sp500-Gqr.csv');

n = size(G,2);
w0 = ones(n,1)/n;

tlow  = 1;
thigh = 1.005;     % or max(rT)
RET = linspace(tlow,thigh,21);

X = [];  RISK = zeros(1,length(RET));
for i = 1:length(RET)
    [x, risk] = minrisk(G, rT, RET(i), w0);

    X(:,i)  = x;
    RISK(i) = risk;
end

rf = 1.0005;
[x2, risk2, ret2] = sharpe(G, rT, w0, rf);
sharperatio = (ret2 - rf*sum(w0))/risk2;

plot(RISK, RET, '-')
hold on
plot(risk2,ret2,'o')
line([0, 100],[rf*sum(w0), rf*sum(w0) + 100*sharperatio])
hold off
axis([0, 0.1, tlow, thigh])

