source("minrisk.R")
source("sharpe.R")

# Read expected returns and covariance factor
rT <- as.matrix(read.csv("../data/sp500-ret.csv", header=F))
G  <- as.matrix(read.csv("../data/sp500-Gqr.csv", header=F))

n  <- ncol(G);
w0 <- matrix(1/n,nrow=n);

tlow  <- 1;
thigh <- 1.005;    # or max(rT)
RET <- seq(tlow, thigh, length.out=21)

X    <- Matrix(0,n,length(RET));
RISK <- rep(0, length(RET));
for (i in 1:length(RET)) {
    solrisk <- minrisk(G, rT, RET[i], w0);
    
    X[,i]    = solrisk$x;
    RISK[i] = solrisk$risk;
}

rf <- 1.0005;
solsharpe <- sharpe(G, rT, w0, rf);
x2 <- solsharpe$x;  risk2 <- solsharpe$risk;  ret2 <- solsharpe$ret;
sharperatio <- (ret2 - rf*sum(w0))/risk2;

plot(RISK, RET, 'l', xlim=c(0, 0.1), ylim=c(tlow, thigh))
points(risk2,ret2)
lines(c(0, 100), c(rf*sum(w0), rf*sum(w0) + 100*sharperatio))
dev.off()
